"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseEdgeConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class BaseEdgeConstruct extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.stack = aws_cdk_lib_1.Stack.of(this);
        this.edgeStack = this.stack.region !== 'us-east-1' ? this.getOrCreateCrossRegionSupportStack() : this.stack;
    }
    getOrCreateCrossRegionSupportStack() {
        const stack = this.stack.nestedStackParent ?? this.stack;
        const { account, stackName } = stack;
        const stackId = `lambda-at-edge-support-stack`;
        const app = this.requireApp();
        let supportStack = app.node.tryFindChild(stackId);
        if (!supportStack) {
            supportStack = new aws_cdk_lib_1.Stack(app, stackId, {
                stackName: `${stackName}-support-lambda-at-edge`,
                env: {
                    account,
                    region: 'us-east-1',
                },
            });
            // the stack containing the edge lambdas must be deployed before
            this.stack.addDependency(supportStack);
        }
        return supportStack;
    }
    requireApp() {
        const app = this.node.root;
        if (!app || !aws_cdk_lib_1.App.isApp(app)) {
            throw new Error('Stacks which uses edge constructs must be part of a CDK app');
        }
        return app;
    }
}
exports.BaseEdgeConstruct = BaseEdgeConstruct;
_a = JSII_RTTI_SYMBOL_1;
BaseEdgeConstruct[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.BaseEdgeConstruct", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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