"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PullRequestCheck = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Represents a reference to a PullRequestCheck.
 */
class PullRequestCheck extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { repository, buildSpec, buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_5_0, computeType = buildImage.defaultComputeType, privileged = false, updateApprovalState = true, postComment = true, projectName = `${repository.repositoryName}-pull-request`, role, vpc, subnetSelection, securityGroups, allowAllOutbound, environmentVariables, artifacts, } = props;
        this.pullRequestProject = new aws_codebuild_1.Project(this, 'PullRequestProject', {
            projectName,
            source: aws_codebuild_1.Source.codeCommit({
                repository,
            }),
            environment: {
                buildImage,
                computeType,
                privileged,
                environmentVariables,
            },
            buildSpec,
            role,
            vpc,
            subnetSelection,
            securityGroups,
            allowAllOutbound,
            artifacts,
        });
        if (updateApprovalState || postComment) {
            this.codeBuildResultFunction = new aws_lambda_1.Function(this, 'CodeBuildResultFunction', {
                runtime: aws_lambda_1.Runtime.NODEJS_18_X,
                code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'code-build-result')),
                handler: 'index.handler',
                environment: {
                    UPDATE_APPROVAL_STATE: updateApprovalState ? 'TRUE' : 'FALSE',
                    POST_COMMENT: postComment ? 'TRUE' : 'FALSE',
                },
            });
            this.codeBuildResultFunction.addToRolePolicy(new aws_iam_1.PolicyStatement({
                effect: aws_iam_1.Effect.ALLOW,
                resources: [repository.repositoryArn],
                actions: ['codecommit:PostCommentForPullRequest', 'codecommit:UpdatePullRequestApprovalState'],
            }));
            this.pullRequestProject.onStateChange('PullRequestValidationRule', {
                target: new aws_events_targets_1.LambdaFunction(this.codeBuildResultFunction),
            });
        }
        const rule = repository.onPullRequestStateChange(`${this.node.addr}Rule`, {
            eventPattern: {
                detail: {
                    event: ['pullRequestSourceBranchUpdated', 'pullRequestCreated'],
                },
            },
        });
        rule.addTarget(new aws_events_targets_1.CodeBuildProject(this.pullRequestProject, {
            event: aws_events_1.RuleTargetInput.fromObject({
                sourceVersion: aws_events_1.EventField.fromPath('$.detail.sourceCommit'),
                environmentVariablesOverride: [
                    {
                        name: 'pullRequestId',
                        value: aws_events_1.EventField.fromPath('$.detail.pullRequestId'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'repositoryName',
                        value: aws_events_1.EventField.fromPath('$.detail.repositoryNames[0]'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'sourceCommit',
                        value: aws_events_1.EventField.fromPath('$.detail.sourceCommit'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'destinationCommit',
                        value: aws_events_1.EventField.fromPath('$.detail.destinationCommit'),
                        type: 'PLAINTEXT',
                    },
                    {
                        name: 'revisionId',
                        value: aws_events_1.EventField.fromPath('$.detail.revisionId'),
                        type: 'PLAINTEXT',
                    },
                ],
            }),
        }));
    }
    /**
     * Defines an event rule which triggers when a check fails.
     */
    onCheckFailed(id, options) {
        return this.pullRequestProject.onBuildFailed(id, options);
    }
    /**
     * Defines an event rule which triggers when a check starts.
     */
    onCheckStarted(id, options) {
        return this.pullRequestProject.onBuildStarted(id, options);
    }
    /**
     * Defines an event rule which triggers when a check complets successfully.
     */
    onCheckSucceeded(id, options) {
        return this.pullRequestProject.onBuildSucceeded(id, options);
    }
    /**
     * Add a permission only if there's a policy attached.
     * @param statement The permissions statement to add
     */
    addToRolePolicy(statement) {
        this.pullRequestProject.addToRolePolicy(statement);
    }
}
exports.PullRequestCheck = PullRequestCheck;
_a = JSII_RTTI_SYMBOL_1;
PullRequestCheck[_a] = { fqn: "@cloudcomponents/cdk-pull-request-check.PullRequestCheck", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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