"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
class TimeToLive extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        core_1.Stack.of(this).node.addWarning(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_lambda_1.Function(this, 'DeleteStack', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_events_1.Rule(this, 'TimeToLive', {
            schedule: aws_events_1.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(deleteStack, {
            event: aws_events_1.RuleTargetInput.fromObject({
                stackId: core_1.Aws.STACK_ID,
            }),
        }));
    }
    onPrepare() {
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (!this.node.findAll().includes(c)) {
                c.node.addDependency(this);
            }
        });
    }
}
exports.TimeToLive = TimeToLive;
//# sourceMappingURL=data:application/json;base64,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