"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const path = require("path");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class TimeToLive extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        core_1.Stack.of(this).node.addWarning(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_lambda_1.Function(this, 'DeleteStack', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_events_1.Rule(this, 'TimeToLive', {
            schedule: aws_events_1.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(deleteStack, {
            event: aws_events_1.RuleTargetInput.fromObject({
                stackId: core_1.Aws.STACK_ID,
            }),
        }));
    }
    onPrepare() {
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (!this.node.findAll().includes(c)) {
                c.node.addDependency(this);
            }
        });
    }
    validate() {
        let count = 0;
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (c instanceof TimeToLive) {
                count++;
            }
        });
        if (count > 1) {
            return [`Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`];
        }
        return [];
    }
}
exports.TimeToLive = TimeToLive;
//# sourceMappingURL=data:application/json;base64,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