"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class TimeToLive extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        core_1.Stack.of(this).node.addInfo(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_lambda_1.Function(this, 'DeleteStack', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_events_1.Rule(this, 'TimeToLive', {
            schedule: aws_events_1.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(deleteStack, {
            event: aws_events_1.RuleTargetInput.fromObject({
                stackId: core_1.Aws.STACK_ID,
            }),
        }));
    }
    /**
     * Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    onPrepare() {
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (!this.node.findAll().includes(c)) {
                c.node.addDependency(this);
            }
        });
    }
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    validate() {
        let count = 0;
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (c instanceof TimeToLive) {
                count++;
            }
        });
        if (count > 1) {
            return [`Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`];
        }
        return [];
    }
}
exports.TimeToLive = TimeToLive;
_a = JSII_RTTI_SYMBOL_1;
TimeToLive[_a] = { fqn: "@cloudcomponents/cdk-temp-stack.TimeToLive", version: "1.29.0" };
//# sourceMappingURL=data:application/json;base64,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