"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_events_1 = require("@aws-cdk/aws-events");
const aws_events_targets_1 = require("@aws-cdk/aws-events-targets");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class TimeToLive extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        core_1.Annotations.of(this).addInfo(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_lambda_1.Function(this, 'DeleteStack', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_events_1.Rule(this, 'TimeToLive', {
            schedule: aws_events_1.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(deleteStack, {
            event: aws_events_1.RuleTargetInput.fromObject({
                stackId: core_1.Aws.STACK_ID,
            }),
        }));
    }
    /**
     * Perform final modifications before synthesis.
     *
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     *
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    onPrepare() {
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (!this.node.findAll().includes(c)) {
                c.node.addDependency(this);
            }
        });
    }
    /**
     * Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     */
    validate() {
        let count = 0;
        core_1.Stack.of(this).node.children.forEach((c) => {
            if (c instanceof TimeToLive) {
                count++;
            }
        });
        if (count > 1) {
            return [`Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`];
        }
        return [];
    }
}
exports.TimeToLive = TimeToLive;
_a = JSII_RTTI_SYMBOL_1;
TimeToLive[_a] = { fqn: "@cloudcomponents/cdk-temp-stack.TimeToLive", version: "1.40.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGltZS10by1saXZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3RpbWUtdG8tbGl2ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZCQUE2QjtBQUM3QixvREFBc0U7QUFDdEUsb0VBQTZEO0FBQzdELDhDQUEyRDtBQUMzRCxvREFBOEQ7QUFDOUQsd0NBQTZFO0FBUzdFLE1BQWEsVUFBVyxTQUFRLGdCQUFTO0lBQ3ZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBc0I7UUFDOUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixrQkFBVyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMseUNBQXlDLEtBQUssQ0FBQyxHQUFHLENBQUMsU0FBUyxFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBRTFHLE1BQU0sV0FBVyxHQUFHLElBQUkscUJBQVEsQ0FBQyxJQUFJLEVBQUUsYUFBYSxFQUFFO1lBQ3BELE9BQU8sRUFBRSxvQkFBTyxDQUFDLFdBQVc7WUFDNUIsSUFBSSxFQUFFLGlCQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxjQUFjLENBQUMsQ0FBQztZQUNyRSxPQUFPLEVBQUUsZUFBZTtTQUN6QixDQUFDLENBQUM7UUFFSCxXQUFXLENBQUMsZUFBZSxDQUN6QixJQUFJLHlCQUFlLENBQUM7WUFDbEIsTUFBTSxFQUFFLGdCQUFNLENBQUMsS0FBSztZQUNwQixPQUFPLEVBQUUsQ0FBQyxHQUFHLENBQUM7WUFDZCxTQUFTLEVBQUUsQ0FBQyxHQUFHLENBQUM7U0FDakIsQ0FBQyxDQUNILENBQUM7UUFFRixNQUFNLElBQUksR0FBRyxJQUFJLGlCQUFJLENBQUMsSUFBSSxFQUFFLFlBQVksRUFBRTtZQUN4QyxRQUFRLEVBQUUscUJBQVEsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQztTQUNuQyxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsU0FBUyxDQUNaLElBQUksbUNBQWMsQ0FBQyxXQUFXLEVBQUU7WUFDOUIsS0FBSyxFQUFFLDRCQUFlLENBQUMsVUFBVSxDQUFDO2dCQUNoQyxPQUFPLEVBQUUsVUFBRyxDQUFDLFFBQVE7YUFDdEIsQ0FBQztTQUNILENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQzs7Ozs7Ozs7Ozs7SUFFUyxTQUFTO1FBQ2pCLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUN6QyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLEVBQUU7Z0JBQ3BDLENBQUMsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQzVCO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOzs7Ozs7O0lBRVMsUUFBUTtRQUNoQixJQUFJLEtBQUssR0FBRyxDQUFDLENBQUM7UUFDZCxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7WUFDekMsSUFBSSxDQUFDLFlBQVksVUFBVSxFQUFFO2dCQUMzQixLQUFLLEVBQUUsQ0FBQzthQUNUO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssR0FBRyxDQUFDLEVBQUU7WUFDYixPQUFPLENBQUMsU0FBUyxLQUFLLHNHQUFzRyxDQUFDLENBQUM7U0FDL0g7UUFFRCxPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7O0FBdERILGdDQXVEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBSdWxlLCBTY2hlZHVsZSwgUnVsZVRhcmdldElucHV0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWV2ZW50cyc7XG5pbXBvcnQgeyBMYW1iZGFGdW5jdGlvbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMtdGFyZ2V0cyc7XG5pbXBvcnQgeyBFZmZlY3QsIFBvbGljeVN0YXRlbWVudCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29kZSwgUnVudGltZSwgRnVuY3Rpb24gfSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IEFubm90YXRpb25zLCBBd3MsIENvbnN0cnVjdCwgRHVyYXRpb24sIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVGltZVRvTGl2ZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdHRsOiBEdXJhdGlvbjtcbn1cblxuZXhwb3J0IGNsYXNzIFRpbWVUb0xpdmUgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVGltZVRvTGl2ZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIEFubm90YXRpb25zLm9mKHRoaXMpLmFkZEluZm8oYFdhcm5pbmchIFRoZSBzdGFjayBkZXN0cm95cyBpdHNlbGYgaW4gJHtwcm9wcy50dGwudG9NaW51dGVzKCl9IG1pbnV0ZXMuXFxuYCk7XG5cbiAgICBjb25zdCBkZWxldGVTdGFjayA9IG5ldyBGdW5jdGlvbih0aGlzLCAnRGVsZXRlU3RhY2snLCB7XG4gICAgICBydW50aW1lOiBSdW50aW1lLk5PREVKU18xMl9YLFxuICAgICAgY29kZTogQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ2xhbWJkYXMnLCAnZGVsZXRlLXN0YWNrJykpLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgIH0pO1xuXG4gICAgZGVsZXRlU3RhY2suYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgbmV3IFBvbGljeVN0YXRlbWVudCh7XG4gICAgICAgIGVmZmVjdDogRWZmZWN0LkFMTE9XLFxuICAgICAgICBhY3Rpb25zOiBbJyonXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbJyonXSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBjb25zdCBydWxlID0gbmV3IFJ1bGUodGhpcywgJ1RpbWVUb0xpdmUnLCB7XG4gICAgICBzY2hlZHVsZTogU2NoZWR1bGUucmF0ZShwcm9wcy50dGwpLFxuICAgIH0pO1xuXG4gICAgcnVsZS5hZGRUYXJnZXQoXG4gICAgICBuZXcgTGFtYmRhRnVuY3Rpb24oZGVsZXRlU3RhY2ssIHtcbiAgICAgICAgZXZlbnQ6IFJ1bGVUYXJnZXRJbnB1dC5mcm9tT2JqZWN0KHtcbiAgICAgICAgICBzdGFja0lkOiBBd3MuU1RBQ0tfSUQsXG4gICAgICAgIH0pLFxuICAgICAgfSksXG4gICAgKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBvblByZXBhcmUoKTogdm9pZCB7XG4gICAgU3RhY2sub2YodGhpcykubm9kZS5jaGlsZHJlbi5mb3JFYWNoKChjKSA9PiB7XG4gICAgICBpZiAoIXRoaXMubm9kZS5maW5kQWxsKCkuaW5jbHVkZXMoYykpIHtcbiAgICAgICAgYy5ub2RlLmFkZERlcGVuZGVuY3kodGhpcyk7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgdmFsaWRhdGUoKTogc3RyaW5nW10ge1xuICAgIGxldCBjb3VudCA9IDA7XG4gICAgU3RhY2sub2YodGhpcykubm9kZS5jaGlsZHJlbi5mb3JFYWNoKChjKSA9PiB7XG4gICAgICBpZiAoYyBpbnN0YW5jZW9mIFRpbWVUb0xpdmUpIHtcbiAgICAgICAgY291bnQrKztcbiAgICAgIH1cbiAgICB9KTtcblxuICAgIGlmIChjb3VudCA+IDEpIHtcbiAgICAgIHJldHVybiBbYEZvdW5kICR7Y291bnR9IGluc3RhbmNlcyBvZiB0aGUgVGltZVRvTGl2ZSBjb25zdHJ1Y3QgaW4gdGhlIHN0YWNrLiBUaGUgY29uc3RydWN0IG1heSBvbmx5IGJlIGFkZGVkIG9uY2UgcGVyIHN0YWNrLmBdO1xuICAgIH1cblxuICAgIHJldHVybiBbXTtcbiAgfVxufVxuIl19