"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class TimeToLive extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        aws_cdk_lib_1.Annotations.of(this).addInfo(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_cdk_lib_1.aws_lambda.Function(this, 'DeleteStack', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_cdk_lib_1.aws_events.Rule(this, 'TimeToLive', {
            schedule: aws_cdk_lib_1.aws_events.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_cdk_lib_1.aws_events_targets.LambdaFunction(deleteStack, {
            event: aws_cdk_lib_1.aws_events.RuleTargetInput.fromObject({
                stackId: aws_cdk_lib_1.Aws.STACK_ID,
            }),
        }));
        this.node.addValidation({
            validate: () => {
                aws_cdk_lib_1.Stack.of(this).node.children.forEach((c) => {
                    if (!this.node.findAll().includes(c)) {
                        c.node.addDependency(this);
                    }
                });
                let count = 0;
                aws_cdk_lib_1.Stack.of(this).node.children.forEach((c) => {
                    if (c instanceof TimeToLive) {
                        count++;
                    }
                });
                if (count > 1) {
                    return [`Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`];
                }
                return [];
            },
        });
    }
}
exports.TimeToLive = TimeToLive;
_a = JSII_RTTI_SYMBOL_1;
TimeToLive[_a] = { fqn: "@cloudcomponents/cdk-temp-stack.TimeToLive", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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