"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeToLive = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class TimeToLive extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        aws_cdk_lib_1.Annotations.of(this).addInfo(`Warning! The stack destroys itself in ${props.ttl.toMinutes()} minutes.\n`);
        const deleteStack = new aws_cdk_lib_1.aws_lambda.Function(this, 'DeleteStack', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'delete-stack')),
            handler: 'index.handler',
        });
        deleteStack.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: ['*'],
            resources: ['*'],
        }));
        const rule = new aws_cdk_lib_1.aws_events.Rule(this, 'TimeToLive', {
            schedule: aws_cdk_lib_1.aws_events.Schedule.rate(props.ttl),
        });
        rule.addTarget(new aws_cdk_lib_1.aws_events_targets.LambdaFunction(deleteStack, {
            event: aws_cdk_lib_1.aws_events.RuleTargetInput.fromObject({
                stackId: aws_cdk_lib_1.Aws.STACK_ID,
            }),
        }));
        this.node.addValidation({
            validate: () => {
                aws_cdk_lib_1.Stack.of(this).node.children.forEach((c) => {
                    if (!this.node.findAll().includes(c)) {
                        c.node.addDependency(this);
                    }
                });
                let count = 0;
                aws_cdk_lib_1.Stack.of(this).node.children.forEach((c) => {
                    if (c instanceof TimeToLive) {
                        count++;
                    }
                });
                if (count > 1) {
                    return [`Found ${count} instances of the TimeToLive construct in the stack. The construct may only be added once per stack.`];
                }
                return [];
            },
        });
    }
}
exports.TimeToLive = TimeToLive;
_a = JSII_RTTI_SYMBOL_1;
TimeToLive[_a] = { fqn: "@cloudcomponents/cdk-temp-stack.TimeToLive", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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