"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const assert = require("assert");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Database extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const databaseName = props.databaseName ?? 'wordpress';
        this.instance = new aws_cdk_lib_1.aws_rds.DatabaseInstance(this, 'Database', {
            databaseName,
            vpc: props.vpc,
            engine: props.engine ??
                aws_cdk_lib_1.aws_rds.DatabaseInstanceEngine.mariaDb({
                    version: aws_cdk_lib_1.aws_rds.MariaDbEngineVersion.VER_10_5,
                }),
            allocatedStorage: props.allocatedStorage ?? 10,
            instanceType: props.instanceType ?? aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.BURSTABLE3, aws_cdk_lib_1.aws_ec2.InstanceSize.MICRO),
            deleteAutomatedBackups: props.removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY,
            removalPolicy: props.removalPolicy,
        });
        this.environment = {
            WORDPRESS_DB_NAME: databaseName,
        };
        assert(this.instance.secret);
        this.secrets = {
            WORDPRESS_DB_HOST: aws_cdk_lib_1.aws_ecs.Secret.fromSecretsManager(this.instance.secret, 'host'),
            WORDPRESS_DB_USER: aws_cdk_lib_1.aws_ecs.Secret.fromSecretsManager(this.instance.secret, 'username'),
            WORDPRESS_DB_PASSWORD: aws_cdk_lib_1.aws_ecs.Secret.fromSecretsManager(this.instance.secret, 'password'),
        };
    }
    allowDefaultPortFrom(other, description) {
        this.instance.connections.allowDefaultPortFrom(other, description);
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Database", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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