"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class Dns extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'ARecord', {
            zone: props.domainZone,
            recordName: props.domainName,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(props.distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaRecord', {
            zone: props.domainZone,
            recordName: props.domainName,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(props.distribution)),
        });
    }
}
exports.Dns = Dns;
_a = JSII_RTTI_SYMBOL_1;
Dns[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Dns", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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