"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EfsVolume = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class EfsVolume extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.fileSystem = new aws_cdk_lib_1.aws_efs.FileSystem(this, 'FileSystem', {
            vpc: props.vpc,
            performanceMode: aws_cdk_lib_1.aws_efs.PerformanceMode.GENERAL_PURPOSE,
            lifecyclePolicy: aws_cdk_lib_1.aws_efs.LifecyclePolicy.AFTER_30_DAYS,
            throughputMode: aws_cdk_lib_1.aws_efs.ThroughputMode.BURSTING,
            encrypted: true,
            removalPolicy: props.removalPolicy,
        });
        const fileSystemAccessPoint = this.fileSystem.addAccessPoint('AccessPoint');
        this.name = props.name ?? 'efs';
        this.efsVolumeConfiguration = {
            fileSystemId: this.fileSystem.fileSystemId,
            transitEncryption: 'ENABLED',
            authorizationConfig: {
                accessPointId: fileSystemAccessPoint.accessPointId,
            },
        };
    }
    allowDefaultPortFrom(other, description) {
        this.fileSystem.connections.allowDefaultPortFrom(other, description);
    }
}
exports.EfsVolume = EfsVolume;
_a = JSII_RTTI_SYMBOL_1;
EfsVolume[_a] = { fqn: "@cloudcomponents/cdk-wordpress.EfsVolume", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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