"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wordpress = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const application_1 = require("./application");
const database_1 = require("./database");
const efs_volume_1 = require("./efs-volume");
class Wordpress extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const staticContentDomainName = `static.${props.domainName}`;
        const subjectAlternativeNames = props.subjectAlternativeNames ?? [];
        if (props.offloadStaticContent) {
            subjectAlternativeNames.push(staticContentDomainName);
        }
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.DnsValidatedCertificate(this, 'Certificate', {
            domainName: props.domainName,
            hostedZone: props.domainZone,
            subjectAlternativeNames,
            region: 'us-east-1',
        });
        const vpc = props.vpc ??
            new aws_cdk_lib_1.aws_ec2.Vpc(this, 'Vpc', {
                maxAzs: 2,
            });
        this.volume =
            props.volume ??
                new efs_volume_1.EfsVolume(this, 'Volume', {
                    vpc,
                    removalPolicy: props.removalPolicy,
                });
        this.database =
            props.database ??
                new database_1.Database(this, 'Database', {
                    vpc,
                    removalPolicy: props.removalPolicy,
                });
        this.application = new application_1.Application(this, 'Application', {
            domainName: props.domainName,
            domainZone: props.domainZone,
            certificate,
            vpc,
            volume: this.volume,
            database: this.database,
            image: props.image,
            serviceName: props.serviceName,
            memoryLimitMiB: props.memoryLimitMiB,
            environment: props.environment,
            secrets: props.secrets,
            logDriver: props.logDriver,
            cloudFrontHashHeader: props.cloudFrontHashHeader,
            removalPolicy: props.removalPolicy,
        });
        this.database.allowDefaultPortFrom(this.application.service);
        this.volume.allowDefaultPortFrom(this.application.service);
        if (props.offloadStaticContent) {
            this.staticContentOffload = this.application.enableStaticContentOffload(staticContentDomainName, certificate);
        }
        if (props.backupPlan) {
            if (props.removalPolicy) {
                props.backupPlan.applyRemovalPolicy(props.removalPolicy);
            }
            props.backupPlan.addSelection('BackupPlanSelection', {
                resources: [aws_cdk_lib_1.aws_backup.BackupResource.fromConstruct(this)],
            });
        }
    }
}
exports.Wordpress = Wordpress;
_a = JSII_RTTI_SYMBOL_1;
Wordpress[_a] = { fqn: "@cloudcomponents/cdk-wordpress.Wordpress", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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