## AWS CloudFormation Resource Provider Java Plugin

The CloudFormation CLI (cfn) allows you to author your own resource providers that can be used by CloudFormation.

This plugin library helps to provide Java runtime bindings for the execution of your providers by CloudFormation.

Usage
-----

If you are using this package to build resource providers for CloudFormation, install the [CloudFormation CLI Java Plugin](https://github.com/aws-cloudformation/cloudformation-cli-java-plugin) - this will automatically install the the [CloudFormation CLI](https://github.com/aws-cloudformation/cloudformation-cli)! A Python virtual environment is recommended.

**Prerequisites**

 - Python version 3.8 or above
 - Your choice of Java IDE
 - Lombok: The code generated by the CloudFormation CLI uses [Lombok](https://projectlombok.org/), which requires support in IDEs for some syntax highlighting to work. For the best development experience, it is recommended you install Lombok support in your IDE.

**Installation**

```shell
pip3 install cloudformation-cli-java-plugin
```

Refer to the [CloudFormation CLI User Guide](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-types.html) for the [CloudFormation CLI](https://github.com/aws-cloudformation/cloudformation-cli) for usage instructions.

### Alternate Type Formats
The `format` keyword can be specified on primitive types defined in a resource provider's schema to allow the CloudFormation CLI Java Plugin to generate more than the defaults for primitive types. Consult the table below for what formats are available and defaults for various types. The `default` value is used if omitted:

| JSON Schema Type | Format value | Generated variable type  |
| ---- | ----------- | ---------------------- |
| boolean | `default` | [Boolean](https://docs.oracle.com/javase/8/docs/api/java/lang/Boolean.html)|
| integer | `default`, `int32` | [Integer](https://docs.oracle.com/javase/8/docs/api/java/lang/Integer.html)|
| integer | `int64` | [Long](https://docs.oracle.com/javase/8/docs/api/java/lang/Long.html)|
| number | `default` | [Double](https://docs.oracle.com/javase/8/docs/api/java/lang/Double.html)|
| string | `default` | [String](https://docs.oracle.com/javase/8/docs/api/java/lang/String.html)|

For example, the below schema for a property would generate a variable of type `Long`.
```
{
    "type": "integer",
    "format": "int64"
}
```


Development
-----------

For changes to the plugin, a Python virtual environment is recommended. Check out and install the plugin in editable mode:

```shell
python3 -m venv env
source env/bin/activate
pip3 install -e /path/to/cloudformation-cli-java-plugin
```

Install `pytest-cov`, used when running unit tests for this plugin:

```shell
pip3 install pytest-cov
```

You may also want to check out the [CloudFormation CLI](https://github.com/aws-cloudformation/cloudformation-cli) if you wish to make edits to that. In this case, installing them in one operation works well:

```shell
pip3 install \
  -e /path/to/cloudformation-cli \
  -e /path/to/cloudformation-cli-java-plugin
```

That ensures neither is accidentally installed from PyPI.

Linting and running unit tests is done via [pre-commit](https://pre-commit.com/), and so is performed automatically on commit after being installed (`pre-commit install`). The continuous integration also runs these checks. Manual options are available so you don't have to commit:

```shell
# run all hooks on all files, mirrors what the CI runs
pre-commit run --all-files
# run unit tests only. can also be used for other hooks, e.g. black, flake8, pylint-local
pre-commit run pytest-local
```

License
-------

This library is licensed under the Apache 2.0 License.
