from __future__ import annotations

from cloudshell.cp.core.request_actions import DeployVMRequestActions
from cloudshell.cp.core.request_actions.models import DeployApp

from cloudshell.cp.cloudstack import constants
from cloudshell.cp.cloudstack.models.base_deployment_app import (
    CloudstackDeploymentAppAttributeNames,
    HddSpecsAttrRO,
    ResourceAttrRODeploymentPath,
    ResourceBoolAttrRODeploymentPath,
    ResourceFloatAttrRODeploymentPath,
    ResourceIntAttrRODeploymentPath,
)


class BaseCSDeployApp(DeployApp):
    _DO_NOT_EDIT_APP_NAME = True
    ATTR_NAMES = CloudstackDeploymentAppAttributeNames

    service_offering_id = ResourceAttrRODeploymentPath(ATTR_NAMES.service_offering_id)
    disk_offering_id = ResourceAttrRODeploymentPath(ATTR_NAMES.disk_offering_id)
    zone_id = ResourceAttrRODeploymentPath(ATTR_NAMES.zone_id)
    pod_id = ResourceAttrRODeploymentPath(ATTR_NAMES.pod_id)
    cluster_id = ResourceAttrRODeploymentPath(ATTR_NAMES.cluster_id)
    group = ResourceAttrRODeploymentPath(ATTR_NAMES.group)
    auto_power_on = ResourceBoolAttrRODeploymentPath(ATTR_NAMES.auto_power_on)
    auto_power_off = ResourceBoolAttrRODeploymentPath(ATTR_NAMES.auto_power_off)
    wait_for_ip = ResourceBoolAttrRODeploymentPath(ATTR_NAMES.wait_for_ip)
    auto_delete = ResourceBoolAttrRODeploymentPath(ATTR_NAMES.auto_delete)
    autoload = ResourceBoolAttrRODeploymentPath(ATTR_NAMES.autoload)
    ip_regex = ResourceAttrRODeploymentPath(ATTR_NAMES.ip_regex)
    hostname = ResourceAttrRODeploymentPath(ATTR_NAMES.hostname)
    private_ip = ResourceAttrRODeploymentPath(ATTR_NAMES.private_ip)
    cpu_num = ResourceIntAttrRODeploymentPath(ATTR_NAMES.cpu_num)
    ram_amount = ResourceFloatAttrRODeploymentPath(ATTR_NAMES.ram_amount)
    hdd_specs = HddSpecsAttrRO(ATTR_NAMES.hdd_specs)
    autogenerated_name = ResourceBoolAttrRODeploymentPath(ATTR_NAMES.autogenerated_name)
    mgmt_network_id = ResourceAttrRODeploymentPath(ATTR_NAMES.mgmt_network_id)


class VMFromTemplateDeployApp(BaseCSDeployApp):
    ATTR_NAMES = CloudstackDeploymentAppAttributeNames

    DEPLOYMENT_PATH = constants.VM_FROM_TEMPLATE_DEPLOYMENT_PATH
    template_id = ResourceAttrRODeploymentPath(ATTR_NAMES.template_id)


class CloudStackDeployVMRequestActions(DeployVMRequestActions):
    deploy_app: BaseCSDeployApp
