# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudsmith_api.api_client import ApiClient


class FilesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def files_abort(self, owner, repo, identifier, **kwargs):  # noqa: E501
        """Abort a multipart file upload.  # noqa: E501

        Abort a multipart file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_abort(owner, repo, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param str identifier: (required)
        :param PackageFileUploadRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_abort_with_http_info(owner, repo, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.files_abort_with_http_info(owner, repo, identifier, **kwargs)  # noqa: E501
            return data

    def files_abort_with_http_info(self, owner, repo, identifier, **kwargs):  # noqa: E501
        """Abort a multipart file upload.  # noqa: E501

        Abort a multipart file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_abort_with_http_info(owner, repo, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param str identifier: (required)
        :param PackageFileUploadRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_abort" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `files_abort`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `files_abort`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `files_abort`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/files/{owner}/{repo}/{identifier}/abort/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_complete(self, owner, repo, identifier, **kwargs):  # noqa: E501
        """Complete a multipart file upload.  # noqa: E501

        Complete a multipart file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_complete(owner, repo, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param str identifier: (required)
        :param PackageFileUploadRequest data:
        :return: PackageFileUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_complete_with_http_info(owner, repo, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.files_complete_with_http_info(owner, repo, identifier, **kwargs)  # noqa: E501
            return data

    def files_complete_with_http_info(self, owner, repo, identifier, **kwargs):  # noqa: E501
        """Complete a multipart file upload.  # noqa: E501

        Complete a multipart file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_complete_with_http_info(owner, repo, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param str identifier: (required)
        :param PackageFileUploadRequest data:
        :return: PackageFileUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_complete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `files_complete`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `files_complete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `files_complete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/files/{owner}/{repo}/{identifier}/complete/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageFileUpload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_create(self, owner, repo, **kwargs):  # noqa: E501
        """Request URL(s) to upload new package file upload(s) to.  # noqa: E501

        Request URL(s) to upload new package file upload(s) to.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_create(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param PackageFileUploadRequest data:
        :return: PackageFileUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_create_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.files_create_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def files_create_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """Request URL(s) to upload new package file upload(s) to.  # noqa: E501

        Request URL(s) to upload new package file upload(s) to.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_create_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param PackageFileUploadRequest data:
        :return: PackageFileUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `files_create`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `files_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/files/{owner}/{repo}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageFileUpload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_info(self, owner, repo, identifier, filename, **kwargs):  # noqa: E501
        """Get upload information to perform a multipart file upload.  # noqa: E501

        Get upload information to perform a multipart file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_info(owner, repo, identifier, filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param str identifier: (required)
        :param str filename: The filename of the file being uploaded (required)
        :param int part_number: The part number to be uploaded next
        :return: PackageFilePartsUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_info_with_http_info(owner, repo, identifier, filename, **kwargs)  # noqa: E501
        else:
            (data) = self.files_info_with_http_info(owner, repo, identifier, filename, **kwargs)  # noqa: E501
            return data

    def files_info_with_http_info(self, owner, repo, identifier, filename, **kwargs):  # noqa: E501
        """Get upload information to perform a multipart file upload.  # noqa: E501

        Get upload information to perform a multipart file upload.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_info_with_http_info(owner, repo, identifier, filename, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param str identifier: (required)
        :param str filename: The filename of the file being uploaded (required)
        :param int part_number: The part number to be uploaded next
        :return: PackageFilePartsUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'identifier', 'filename', 'part_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `files_info`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `files_info`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `files_info`")  # noqa: E501
        # verify the required parameter 'filename' is set
        if self.api_client.client_side_validation and ('filename' not in params or
                                                       params['filename'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `filename` when calling `files_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501
        if 'part_number' in params:
            query_params.append(('part_number', params['part_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/files/{owner}/{repo}/{identifier}/info/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageFilePartsUpload',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def files_validate(self, owner, repo, **kwargs):  # noqa: E501
        """Validate parameters used for create.  # noqa: E501

        Validate parameters used for create.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_validate(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param PackageFileUploadRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.files_validate_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.files_validate_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def files_validate_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """Validate parameters used for create.  # noqa: E501

        Validate parameters used for create.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.files_validate_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param PackageFileUploadRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method files_validate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `files_validate`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `files_validate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/files/{owner}/{repo}/validate/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
