# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from cloudsmith_api.api_client import ApiClient


class ReposApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_repos_geoip_status(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the GeoIP status for this repository.  # noqa: E501

        Retrieve the GeoIP status for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_repos_geoip_status(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGeoIpStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_repos_geoip_status_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.api_repos_geoip_status_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def api_repos_geoip_status_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the GeoIP status for this repository.  # noqa: E501

        Retrieve the GeoIP status for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_repos_geoip_status_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGeoIpStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_repos_geoip_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `api_repos_geoip_status`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `api_repos_geoip_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip/status/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGeoIpStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repo_retention_partial_update(self, owner, repo, **kwargs):  # noqa: E501
        """Update the retention rules for the repository.  # noqa: E501

        Update the retention rules for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repo_retention_partial_update(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param RepositoryRetentionRulesRequestPatch data:
        :return: RepositoryRetentionRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repo_retention_partial_update_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repo_retention_partial_update_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def repo_retention_partial_update_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """Update the retention rules for the repository.  # noqa: E501

        Update the retention rules for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repo_retention_partial_update_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param RepositoryRetentionRulesRequestPatch data:
        :return: RepositoryRetentionRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repo_retention_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repo_retention_partial_update`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `repo_retention_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{repo}/retention/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRetentionRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repo_retention_read(self, owner, repo, **kwargs):  # noqa: E501
        """Retrieve the retention rules for the repository.  # noqa: E501

        Retrieve the retention rules for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repo_retention_read(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :return: RepositoryRetentionRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repo_retention_read_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repo_retention_read_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def repo_retention_read_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """Retrieve the retention rules for the repository.  # noqa: E501

        Retrieve the retention rules for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repo_retention_read_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :return: RepositoryRetentionRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repo_retention_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repo_retention_read`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `repo_retention_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{repo}/retention/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRetentionRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_create(self, owner, **kwargs):  # noqa: E501
        """Create a new repository in a given namespace.  # noqa: E501

        Create a new repository in a given namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_create(owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param RepositoryCreateRequest data:
        :return: RepositoryCreate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_create_with_http_info(owner, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_create_with_http_info(owner, **kwargs)  # noqa: E501
            return data

    def repos_create_with_http_info(self, owner, **kwargs):  # noqa: E501
        """Create a new repository in a given namespace.  # noqa: E501

        Create a new repository in a given namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_create_with_http_info(owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param RepositoryCreateRequest data:
        :return: RepositoryCreate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryCreate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_delete(self, owner, identifier, **kwargs):  # noqa: E501
        """Delete a repository in a given namespace.  # noqa: E501

        Delete a repository in a given namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_delete(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_delete_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_delete_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_delete_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Delete a repository in a given namespace.  # noqa: E501

        Delete a repository in a given namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_delete_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_ecdsa_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Set the active ECDSA key for the Repository.  # noqa: E501

        Set the active ECDSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_ecdsa_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryEcdsaKeyCreate data:
        :return: RepositoryEcdsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_ecdsa_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_ecdsa_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_ecdsa_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Set the active ECDSA key for the Repository.  # noqa: E501

        Set the active ECDSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_ecdsa_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryEcdsaKeyCreate data:
        :return: RepositoryEcdsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_ecdsa_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_ecdsa_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_ecdsa_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/ecdsa/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryEcdsaKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_ecdsa_list(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active ECDSA key for the Repository.  # noqa: E501

        Retrieve the active ECDSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_ecdsa_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryEcdsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_ecdsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_ecdsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_ecdsa_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active ECDSA key for the Repository.  # noqa: E501

        Retrieve the active ECDSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_ecdsa_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryEcdsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_ecdsa_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_ecdsa_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_ecdsa_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/ecdsa/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryEcdsaKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_ecdsa_regenerate(self, owner, identifier, **kwargs):  # noqa: E501
        """Regenerate ECDSA Key for the Repository.  # noqa: E501

        Regenerate ECDSA Key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_ecdsa_regenerate(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryEcdsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_ecdsa_regenerate_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_ecdsa_regenerate_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_ecdsa_regenerate_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Regenerate ECDSA Key for the Repository.  # noqa: E501

        Regenerate ECDSA Key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_ecdsa_regenerate_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryEcdsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_ecdsa_regenerate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_ecdsa_regenerate`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_ecdsa_regenerate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/ecdsa/regenerate/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryEcdsaKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_geoip_disable(self, owner, identifier, **kwargs):  # noqa: E501
        """Disable GeoIP for this repository.  # noqa: E501

        Disable GeoIP for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_disable(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RespositoryGeoIpEnableDisableRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_geoip_disable_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_geoip_disable_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_geoip_disable_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Disable GeoIP for this repository.  # noqa: E501

        Disable GeoIP for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_disable_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RespositoryGeoIpEnableDisableRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_geoip_disable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_geoip_disable`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_geoip_disable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip/disable/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_geoip_enable(self, owner, identifier, **kwargs):  # noqa: E501
        """Enable GeoIP for this repository.  # noqa: E501

        Enable GeoIP for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_enable(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RespositoryGeoIpEnableDisableRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_geoip_enable_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_geoip_enable_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_geoip_enable_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Enable GeoIP for this repository.  # noqa: E501

        Enable GeoIP for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_enable_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RespositoryGeoIpEnableDisableRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_geoip_enable" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_geoip_enable`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_geoip_enable`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip/enable/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_geoip_partial_update(self, owner, identifier, **kwargs):  # noqa: E501
        """Partially update repository geoip rules.  # noqa: E501

        Partially update repository geoip rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_partial_update(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGeoIpRulesRequestPatch data:
        :return: RepositoryGeoIpRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_geoip_partial_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_geoip_partial_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_geoip_partial_update_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Partially update repository geoip rules.  # noqa: E501

        Partially update repository geoip rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_partial_update_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGeoIpRulesRequestPatch data:
        :return: RepositoryGeoIpRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_geoip_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_geoip_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_geoip_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGeoIpRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_geoip_read(self, owner, identifier, **kwargs):  # noqa: E501
        """List all repository geoip rules.  # noqa: E501

        List all repository geoip rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_read(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGeoIpRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_geoip_read_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_geoip_read_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_geoip_read_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List all repository geoip rules.  # noqa: E501

        List all repository geoip rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_read_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGeoIpRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_geoip_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_geoip_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_geoip_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGeoIpRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_geoip_test(self, owner, identifier, **kwargs):  # noqa: E501
        """Test a list of IP addresses against the repository's current GeoIP rules.  # noqa: E501

        Test a list of IP addresses against the repository's current GeoIP rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_test(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGeoIpTestAddress data:
        :return: RepositoryGeoIpTestAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_geoip_test_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_geoip_test_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_geoip_test_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Test a list of IP addresses against the repository's current GeoIP rules.  # noqa: E501

        Test a list of IP addresses against the repository's current GeoIP rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_test_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGeoIpTestAddress data:
        :return: RepositoryGeoIpTestAddressResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_geoip_test" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_geoip_test`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_geoip_test`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip/test/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGeoIpTestAddressResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_geoip_update(self, owner, identifier, **kwargs):  # noqa: E501
        """Replace repository geoip rules.  # noqa: E501

        Replace repository geoip rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_update(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGeoIpRulesRequest data:
        :return: RepositoryGeoIpRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_geoip_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_geoip_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_geoip_update_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Replace repository geoip rules.  # noqa: E501

        Replace repository geoip rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_geoip_update_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGeoIpRulesRequest data:
        :return: RepositoryGeoIpRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_geoip_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_geoip_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_geoip_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/geoip', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGeoIpRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_gpg_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Set the active GPG key for the Repository.  # noqa: E501

        Set the active GPG key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_gpg_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGpgKeyCreate data:
        :return: RepositoryGpgKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_gpg_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_gpg_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_gpg_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Set the active GPG key for the Repository.  # noqa: E501

        Set the active GPG key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_gpg_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryGpgKeyCreate data:
        :return: RepositoryGpgKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_gpg_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_gpg_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_gpg_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/gpg/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGpgKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_gpg_list(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active GPG key for the Repository.  # noqa: E501

        Retrieve the active GPG key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_gpg_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGpgKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_gpg_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_gpg_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_gpg_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active GPG key for the Repository.  # noqa: E501

        Retrieve the active GPG key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_gpg_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGpgKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_gpg_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_gpg_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_gpg_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/gpg/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGpgKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_gpg_regenerate(self, owner, identifier, **kwargs):  # noqa: E501
        """Regenerate GPG Key for the Repository.  # noqa: E501

        Regenerate GPG Key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_gpg_regenerate(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGpgKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_gpg_regenerate_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_gpg_regenerate_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_gpg_regenerate_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Regenerate GPG Key for the Repository.  # noqa: E501

        Regenerate GPG Key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_gpg_regenerate_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryGpgKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_gpg_regenerate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_gpg_regenerate`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_gpg_regenerate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/gpg/regenerate/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryGpgKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_namespace_list(self, owner, **kwargs):  # noqa: E501
        """Get a list of all repositories within a namespace.  # noqa: E501

        Get a list of all repositories within a namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_namespace_list(owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[Repository]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_namespace_list_with_http_info(owner, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_namespace_list_with_http_info(owner, **kwargs)  # noqa: E501
            return data

    def repos_namespace_list_with_http_info(self, owner, **kwargs):  # noqa: E501
        """Get a list of all repositories within a namespace.  # noqa: E501

        Get a list of all repositories within a namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_namespace_list_with_http_info(owner, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[Repository]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_namespace_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_namespace_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Repository]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_partial_update(self, owner, identifier, **kwargs):  # noqa: E501
        """Update details about a repository in a given namespace.  # noqa: E501

        Update details about a repository in a given namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_partial_update(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryRequestPatch data:
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_partial_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_partial_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_partial_update_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Update details about a repository in a given namespace.  # noqa: E501

        Update details about a repository in a given namespace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_partial_update_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryRequestPatch data:
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_privileges_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List all explicity created privileges for the repository.  # noqa: E501

        List all explicity created privileges for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_privileges_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: RepositoryPrivilegeInput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_privileges_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_privileges_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_privileges_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List all explicity created privileges for the repository.  # noqa: E501

        List all explicity created privileges for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_privileges_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: RepositoryPrivilegeInput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_privileges_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_privileges_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_privileges_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/privileges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryPrivilegeInput',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_privileges_partial_update(self, owner, identifier, **kwargs):  # noqa: E501
        """Modify privileges for the repository.  # noqa: E501

        Modify privileges for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_privileges_partial_update(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryPrivilegeInputRequestPatch data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_privileges_partial_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_privileges_partial_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_privileges_partial_update_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Modify privileges for the repository.  # noqa: E501

        Modify privileges for the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_privileges_partial_update_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryPrivilegeInputRequestPatch data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_privileges_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_privileges_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_privileges_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/privileges', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_privileges_update(self, owner, identifier, **kwargs):  # noqa: E501
        """Replace all existing repository privileges with those specified.  # noqa: E501

        Replace all existing repository privileges with those specified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_privileges_update(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryPrivilegeInputRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_privileges_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_privileges_update_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_privileges_update_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Replace all existing repository privileges with those specified.  # noqa: E501

        Replace all existing repository privileges with those specified.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_privileges_update_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryPrivilegeInputRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_privileges_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_privileges_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_privileges_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/privileges', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_read(self, owner, identifier, **kwargs):  # noqa: E501
        """Get a specific repository.  # noqa: E501

        Get a specific repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_read(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_read_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_read_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_read_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Get a specific repository.  # noqa: E501

        Get a specific repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_read_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: Repository
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Repository',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_rsa_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Set the active RSA key for the Repository.  # noqa: E501

        Set the active RSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_rsa_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryRsaKeyCreate data:
        :return: RepositoryRsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_rsa_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_rsa_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_rsa_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Set the active RSA key for the Repository.  # noqa: E501

        Set the active RSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_rsa_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RepositoryRsaKeyCreate data:
        :return: RepositoryRsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_rsa_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_rsa_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_rsa_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/rsa/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRsaKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_rsa_list(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active RSA key for the Repository.  # noqa: E501

        Retrieve the active RSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_rsa_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryRsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_rsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_rsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_rsa_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active RSA key for the Repository.  # noqa: E501

        Retrieve the active RSA key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_rsa_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryRsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_rsa_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_rsa_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_rsa_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/rsa/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRsaKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_rsa_regenerate(self, owner, identifier, **kwargs):  # noqa: E501
        """Regenerate RSA Key for the Repository.  # noqa: E501

        Regenerate RSA Key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_rsa_regenerate(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryRsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_rsa_regenerate_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_rsa_regenerate_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_rsa_regenerate_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Regenerate RSA Key for the Repository.  # noqa: E501

        Regenerate RSA Key for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_rsa_regenerate_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryRsaKey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_rsa_regenerate" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_rsa_regenerate`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_rsa_regenerate`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/rsa/regenerate/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryRsaKey',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_transfer_region(self, owner, repo, **kwargs):  # noqa: E501
        """Transfer a repository to a different region.  # noqa: E501

        Transfer a repository to a different region.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_transfer_region(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param RepositoryTransferRegionRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_transfer_region_with_http_info(owner, repo, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_transfer_region_with_http_info(owner, repo, **kwargs)  # noqa: E501
            return data

    def repos_transfer_region_with_http_info(self, owner, repo, **kwargs):  # noqa: E501
        """Transfer a repository to a different region.  # noqa: E501

        Transfer a repository to a different region.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_transfer_region_with_http_info(owner, repo, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str repo: (required)
        :param RepositoryTransferRegionRequest data:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'repo', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_transfer_region" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_transfer_region`")  # noqa: E501
        # verify the required parameter 'repo' is set
        if self.api_client.client_side_validation and ('repo' not in params or
                                                       params['repo'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repo` when calling `repos_transfer_region`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'repo' in params:
            path_params['repo'] = params['repo']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{repo}/transfer-region/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cargo_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Cargo upstream config for this repository.  # noqa: E501

        Create a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param CargoUpstreamRequest data:
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cargo_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cargo_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cargo_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Cargo upstream config for this repository.  # noqa: E501

        Create a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param CargoUpstreamRequest data:
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cargo_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cargo_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cargo_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cargo/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CargoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cargo_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Cargo upstream config for this repository.  # noqa: E501

        Delete a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cargo_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cargo_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cargo_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Cargo upstream config for this repository.  # noqa: E501

        Delete a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cargo_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cargo_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cargo_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cargo_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cargo_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Cargo upstream configs for this repository.  # noqa: E501

        List Cargo upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[CargoUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cargo_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cargo_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cargo_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Cargo upstream configs for this repository.  # noqa: E501

        List Cargo upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[CargoUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cargo_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cargo_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cargo_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cargo/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CargoUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cargo_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Cargo upstream config for this repository.  # noqa: E501

        Partially update a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CargoUpstreamRequestPatch data:
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cargo_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cargo_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cargo_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Cargo upstream config for this repository.  # noqa: E501

        Partially update a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CargoUpstreamRequestPatch data:
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cargo_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cargo_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cargo_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cargo_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CargoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cargo_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Cargo upstream config for this repository.  # noqa: E501

        Retrieve a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cargo_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cargo_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cargo_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Cargo upstream config for this repository.  # noqa: E501

        Retrieve a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cargo_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cargo_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cargo_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cargo_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CargoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cargo_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Cargo upstream config for this repository.  # noqa: E501

        Update a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CargoUpstreamRequest data:
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cargo_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cargo_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cargo_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Cargo upstream config for this repository.  # noqa: E501

        Update a Cargo upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cargo_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CargoUpstreamRequest data:
        :return: CargoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cargo_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cargo_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cargo_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cargo_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cargo/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CargoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_composer_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Composer upstream config for this repository.  # noqa: E501

        Create a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param ComposerUpstreamRequest data:
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_composer_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_composer_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_composer_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Composer upstream config for this repository.  # noqa: E501

        Create a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param ComposerUpstreamRequest data:
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_composer_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_composer_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_composer_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/composer/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComposerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_composer_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Composer upstream config for this repository.  # noqa: E501

        Delete a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_composer_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_composer_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_composer_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Composer upstream config for this repository.  # noqa: E501

        Delete a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_composer_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_composer_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_composer_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_composer_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/composer/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_composer_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Composer upstream configs for this repository.  # noqa: E501

        List Composer upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[ComposerUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_composer_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_composer_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_composer_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Composer upstream configs for this repository.  # noqa: E501

        List Composer upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[ComposerUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_composer_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_composer_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_composer_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/composer/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ComposerUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_composer_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Composer upstream config for this repository.  # noqa: E501

        Partially update a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param ComposerUpstreamRequestPatch data:
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_composer_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_composer_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_composer_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Composer upstream config for this repository.  # noqa: E501

        Partially update a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param ComposerUpstreamRequestPatch data:
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_composer_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_composer_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_composer_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_composer_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/composer/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComposerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_composer_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Composer upstream config for this repository.  # noqa: E501

        Retrieve a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_composer_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_composer_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_composer_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Composer upstream config for this repository.  # noqa: E501

        Retrieve a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_composer_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_composer_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_composer_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_composer_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/composer/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComposerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_composer_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Composer upstream config for this repository.  # noqa: E501

        Update a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param ComposerUpstreamRequest data:
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_composer_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_composer_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_composer_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Composer upstream config for this repository.  # noqa: E501

        Update a Composer upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_composer_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param ComposerUpstreamRequest data:
        :return: ComposerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_composer_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_composer_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_composer_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_composer_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/composer/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ComposerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cran_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a CRAN upstream config for this repository.  # noqa: E501

        Create a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param CranUpstreamRequest data:
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cran_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cran_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cran_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a CRAN upstream config for this repository.  # noqa: E501

        Create a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param CranUpstreamRequest data:
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cran_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cran_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cran_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cran/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CranUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cran_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a CRAN upstream config for this repository.  # noqa: E501

        Delete a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cran_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cran_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cran_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a CRAN upstream config for this repository.  # noqa: E501

        Delete a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cran_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cran_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cran_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cran_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cran/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cran_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List CRAN upstream configs for this repository.  # noqa: E501

        List CRAN upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[CranUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cran_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cran_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cran_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List CRAN upstream configs for this repository.  # noqa: E501

        List CRAN upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[CranUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cran_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cran_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cran_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cran/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CranUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cran_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a CRAN upstream config for this repository.  # noqa: E501

        Partially update a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CranUpstreamRequestPatch data:
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cran_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cran_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cran_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a CRAN upstream config for this repository.  # noqa: E501

        Partially update a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CranUpstreamRequestPatch data:
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cran_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cran_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cran_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cran_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cran/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CranUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cran_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a CRAN upstream config for this repository.  # noqa: E501

        Retrieve a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cran_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cran_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cran_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a CRAN upstream config for this repository.  # noqa: E501

        Retrieve a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cran_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cran_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cran_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cran_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cran/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CranUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_cran_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a CRAN upstream config for this repository.  # noqa: E501

        Update a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CranUpstreamRequest data:
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_cran_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_cran_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_cran_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a CRAN upstream config for this repository.  # noqa: E501

        Update a CRAN upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_cran_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param CranUpstreamRequest data:
        :return: CranUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_cran_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_cran_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_cran_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_cran_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/cran/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CranUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_dart_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Dart upstream config for this repository.  # noqa: E501

        Create a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param DartUpstreamRequest data:
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_dart_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_dart_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_dart_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Dart upstream config for this repository.  # noqa: E501

        Create a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param DartUpstreamRequest data:
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_dart_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_dart_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_dart_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/dart/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DartUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_dart_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Dart upstream config for this repository.  # noqa: E501

        Delete a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_dart_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_dart_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_dart_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Dart upstream config for this repository.  # noqa: E501

        Delete a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_dart_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_dart_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_dart_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_dart_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/dart/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_dart_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Dart upstream configs for this repository.  # noqa: E501

        List Dart upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[DartUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_dart_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_dart_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_dart_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Dart upstream configs for this repository.  # noqa: E501

        List Dart upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[DartUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_dart_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_dart_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_dart_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/dart/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DartUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_dart_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Dart upstream config for this repository.  # noqa: E501

        Partially update a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DartUpstreamRequestPatch data:
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_dart_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_dart_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_dart_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Dart upstream config for this repository.  # noqa: E501

        Partially update a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DartUpstreamRequestPatch data:
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_dart_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_dart_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_dart_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_dart_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/dart/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DartUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_dart_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Dart upstream config for this repository.  # noqa: E501

        Retrieve a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_dart_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_dart_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_dart_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Dart upstream config for this repository.  # noqa: E501

        Retrieve a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_dart_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_dart_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_dart_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_dart_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/dart/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DartUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_dart_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Dart upstream config for this repository.  # noqa: E501

        Update a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DartUpstreamRequest data:
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_dart_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_dart_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_dart_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Dart upstream config for this repository.  # noqa: E501

        Update a Dart upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_dart_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DartUpstreamRequest data:
        :return: DartUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_dart_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_dart_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_dart_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_dart_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/dart/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DartUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_deb_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Debian upstream config for this repository.  # noqa: E501

        Create a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param DebUpstreamRequest data:
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_deb_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_deb_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_deb_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Debian upstream config for this repository.  # noqa: E501

        Create a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param DebUpstreamRequest data:
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_deb_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_deb_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_deb_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/deb/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_deb_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Debian upstream config for this repository.  # noqa: E501

        Delete a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_deb_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_deb_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_deb_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Debian upstream config for this repository.  # noqa: E501

        Delete a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_deb_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_deb_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_deb_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_deb_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/deb/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_deb_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Debian upstream configs for this repository.  # noqa: E501

        List Debian upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[DebUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_deb_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_deb_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_deb_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Debian upstream configs for this repository.  # noqa: E501

        List Debian upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[DebUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_deb_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_deb_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_deb_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/deb/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DebUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_deb_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Debian upstream config for this repository.  # noqa: E501

        Partially update a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DebUpstreamRequestPatch data:
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_deb_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_deb_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_deb_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Debian upstream config for this repository.  # noqa: E501

        Partially update a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DebUpstreamRequestPatch data:
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_deb_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_deb_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_deb_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_deb_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/deb/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_deb_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Debian upstream config for this repository.  # noqa: E501

        Retrieve a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_deb_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_deb_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_deb_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Debian upstream config for this repository.  # noqa: E501

        Retrieve a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_deb_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_deb_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_deb_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_deb_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/deb/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_deb_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Debian upstream config for this repository.  # noqa: E501

        Update a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DebUpstreamRequest data:
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_deb_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_deb_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_deb_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Debian upstream config for this repository.  # noqa: E501

        Update a Debian upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_deb_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DebUpstreamRequest data:
        :return: DebUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_deb_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_deb_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_deb_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_deb_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/deb/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_docker_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Docker upstream config for this repository.  # noqa: E501

        Create a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param DockerUpstreamRequest data:
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_docker_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_docker_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_docker_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Docker upstream config for this repository.  # noqa: E501

        Create a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param DockerUpstreamRequest data:
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_docker_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_docker_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_docker_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/docker/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_docker_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Docker upstream config for this repository.  # noqa: E501

        Delete a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_docker_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_docker_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_docker_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Docker upstream config for this repository.  # noqa: E501

        Delete a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_docker_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_docker_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_docker_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_docker_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/docker/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_docker_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Docker upstream configs for this repository.  # noqa: E501

        List Docker upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[DockerUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_docker_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_docker_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_docker_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Docker upstream configs for this repository.  # noqa: E501

        List Docker upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[DockerUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_docker_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_docker_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_docker_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/docker/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_docker_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Docker upstream config for this repository.  # noqa: E501

        Partially update a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DockerUpstreamRequestPatch data:
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_docker_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_docker_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_docker_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Docker upstream config for this repository.  # noqa: E501

        Partially update a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DockerUpstreamRequestPatch data:
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_docker_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_docker_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_docker_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_docker_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/docker/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_docker_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Docker upstream config for this repository.  # noqa: E501

        Retrieve a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_docker_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_docker_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_docker_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Docker upstream config for this repository.  # noqa: E501

        Retrieve a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_docker_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_docker_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_docker_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_docker_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/docker/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_docker_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Docker upstream config for this repository.  # noqa: E501

        Update a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DockerUpstreamRequest data:
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_docker_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_docker_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_docker_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Docker upstream config for this repository.  # noqa: E501

        Update a Docker upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_docker_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param DockerUpstreamRequest data:
        :return: DockerUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_docker_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_docker_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_docker_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_docker_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/docker/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_go_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Go upstream config for this repository.  # noqa: E501

        Create a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param GoUpstreamRequest data:
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_go_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_go_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_go_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Go upstream config for this repository.  # noqa: E501

        Create a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param GoUpstreamRequest data:
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_go_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_go_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_go_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/go/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_go_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Go upstream config for this repository.  # noqa: E501

        Delete a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_go_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_go_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_go_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Go upstream config for this repository.  # noqa: E501

        Delete a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_go_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_go_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_go_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_go_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/go/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_go_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Go upstream configs for this repository.  # noqa: E501

        List Go upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[GoUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_go_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_go_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_go_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Go upstream configs for this repository.  # noqa: E501

        List Go upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[GoUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_go_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_go_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_go_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/go/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[GoUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_go_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Go upstream config for this repository.  # noqa: E501

        Partially update a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param GoUpstreamRequestPatch data:
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_go_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_go_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_go_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Go upstream config for this repository.  # noqa: E501

        Partially update a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param GoUpstreamRequestPatch data:
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_go_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_go_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_go_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_go_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/go/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_go_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Go upstream config for this repository.  # noqa: E501

        Retrieve a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_go_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_go_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_go_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Go upstream config for this repository.  # noqa: E501

        Retrieve a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_go_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_go_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_go_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_go_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/go/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_go_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Go upstream config for this repository.  # noqa: E501

        Update a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param GoUpstreamRequest data:
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_go_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_go_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_go_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Go upstream config for this repository.  # noqa: E501

        Update a Go upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_go_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param GoUpstreamRequest data:
        :return: GoUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_go_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_go_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_go_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_go_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/go/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GoUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_helm_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Helm upstream config for this repository.  # noqa: E501

        Create a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param HelmUpstreamRequest data:
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_helm_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_helm_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_helm_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Helm upstream config for this repository.  # noqa: E501

        Create a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param HelmUpstreamRequest data:
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_helm_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_helm_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_helm_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/helm/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HelmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_helm_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Helm upstream config for this repository.  # noqa: E501

        Delete a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_helm_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_helm_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_helm_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Helm upstream config for this repository.  # noqa: E501

        Delete a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_helm_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_helm_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_helm_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_helm_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/helm/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_helm_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Helm upstream configs for this repository.  # noqa: E501

        List Helm upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[HelmUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_helm_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_helm_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_helm_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Helm upstream configs for this repository.  # noqa: E501

        List Helm upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[HelmUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_helm_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_helm_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_helm_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/helm/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HelmUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_helm_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Helm upstream config for this repository.  # noqa: E501

        Partially update a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HelmUpstreamRequestPatch data:
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_helm_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_helm_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_helm_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Helm upstream config for this repository.  # noqa: E501

        Partially update a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HelmUpstreamRequestPatch data:
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_helm_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_helm_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_helm_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_helm_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/helm/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HelmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_helm_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Helm upstream config for this repository.  # noqa: E501

        Retrieve a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_helm_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_helm_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_helm_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Helm upstream config for this repository.  # noqa: E501

        Retrieve a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_helm_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_helm_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_helm_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_helm_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/helm/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HelmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_helm_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Helm upstream config for this repository.  # noqa: E501

        Update a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HelmUpstreamRequest data:
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_helm_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_helm_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_helm_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Helm upstream config for this repository.  # noqa: E501

        Update a Helm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_helm_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HelmUpstreamRequest data:
        :return: HelmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_helm_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_helm_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_helm_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_helm_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/helm/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HelmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_hex_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Hex upstream config for this repository.  # noqa: E501

        Create a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param HexUpstreamRequest data:
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_hex_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_hex_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_hex_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Hex upstream config for this repository.  # noqa: E501

        Create a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param HexUpstreamRequest data:
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_hex_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_hex_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_hex_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/hex/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HexUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_hex_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Hex upstream config for this repository.  # noqa: E501

        Delete a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_hex_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_hex_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_hex_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Hex upstream config for this repository.  # noqa: E501

        Delete a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_hex_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_hex_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_hex_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_hex_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/hex/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_hex_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Hex upstream configs for this repository.  # noqa: E501

        List Hex upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[HexUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_hex_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_hex_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_hex_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Hex upstream configs for this repository.  # noqa: E501

        List Hex upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[HexUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_hex_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_hex_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_hex_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/hex/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HexUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_hex_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Hex upstream config for this repository.  # noqa: E501

        Partially update a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HexUpstreamRequestPatch data:
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_hex_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_hex_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_hex_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Hex upstream config for this repository.  # noqa: E501

        Partially update a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HexUpstreamRequestPatch data:
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_hex_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_hex_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_hex_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_hex_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/hex/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HexUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_hex_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Hex upstream config for this repository.  # noqa: E501

        Retrieve a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_hex_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_hex_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_hex_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Hex upstream config for this repository.  # noqa: E501

        Retrieve a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_hex_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_hex_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_hex_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_hex_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/hex/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HexUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_hex_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Hex upstream config for this repository.  # noqa: E501

        Update a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HexUpstreamRequest data:
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_hex_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_hex_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_hex_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Hex upstream config for this repository.  # noqa: E501

        Update a Hex upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_hex_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param HexUpstreamRequest data:
        :return: HexUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_hex_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_hex_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_hex_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_hex_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/hex/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HexUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_maven_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Maven upstream config for this repository.  # noqa: E501

        Create a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param MavenUpstreamRequest data:
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_maven_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_maven_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_maven_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Maven upstream config for this repository.  # noqa: E501

        Create a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param MavenUpstreamRequest data:
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_maven_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_maven_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_maven_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/maven/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MavenUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_maven_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Maven upstream config for this repository.  # noqa: E501

        Delete a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_maven_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_maven_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_maven_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Maven upstream config for this repository.  # noqa: E501

        Delete a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_maven_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_maven_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_maven_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_maven_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/maven/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_maven_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Maven upstream configs for this repository.  # noqa: E501

        List Maven upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[MavenUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_maven_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_maven_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_maven_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Maven upstream configs for this repository.  # noqa: E501

        List Maven upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[MavenUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_maven_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_maven_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_maven_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/maven/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[MavenUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_maven_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Maven upstream config for this repository.  # noqa: E501

        Partially update a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param MavenUpstreamRequestPatch data:
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_maven_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_maven_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_maven_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Maven upstream config for this repository.  # noqa: E501

        Partially update a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param MavenUpstreamRequestPatch data:
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_maven_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_maven_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_maven_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_maven_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/maven/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MavenUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_maven_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Maven upstream config for this repository.  # noqa: E501

        Retrieve a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_maven_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_maven_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_maven_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Maven upstream config for this repository.  # noqa: E501

        Retrieve a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_maven_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_maven_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_maven_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_maven_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/maven/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MavenUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_maven_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Maven upstream config for this repository.  # noqa: E501

        Update a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param MavenUpstreamRequest data:
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_maven_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_maven_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_maven_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Maven upstream config for this repository.  # noqa: E501

        Update a Maven upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_maven_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param MavenUpstreamRequest data:
        :return: MavenUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_maven_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_maven_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_maven_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_maven_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/maven/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MavenUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_npm_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a npm upstream config for this repository.  # noqa: E501

        Create a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param NpmUpstreamRequest data:
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_npm_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_npm_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_npm_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a npm upstream config for this repository.  # noqa: E501

        Create a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param NpmUpstreamRequest data:
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_npm_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_npm_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_npm_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/npm/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_npm_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a npm upstream config for this repository.  # noqa: E501

        Delete a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_npm_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_npm_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_npm_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a npm upstream config for this repository.  # noqa: E501

        Delete a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_npm_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_npm_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_npm_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_npm_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/npm/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_npm_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List npm upstream configs for this repository.  # noqa: E501

        List npm upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[NpmUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_npm_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_npm_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_npm_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List npm upstream configs for this repository.  # noqa: E501

        List npm upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[NpmUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_npm_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_npm_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_npm_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/npm/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NpmUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_npm_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a npm upstream config for this repository.  # noqa: E501

        Partially update a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NpmUpstreamRequestPatch data:
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_npm_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_npm_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_npm_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a npm upstream config for this repository.  # noqa: E501

        Partially update a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NpmUpstreamRequestPatch data:
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_npm_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_npm_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_npm_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_npm_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/npm/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_npm_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a npm upstream config for this repository.  # noqa: E501

        Retrieve a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_npm_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_npm_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_npm_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a npm upstream config for this repository.  # noqa: E501

        Retrieve a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_npm_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_npm_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_npm_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_npm_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/npm/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_npm_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a npm upstream config for this repository.  # noqa: E501

        Update a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NpmUpstreamRequest data:
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_npm_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_npm_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_npm_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a npm upstream config for this repository.  # noqa: E501

        Update a npm upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_npm_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NpmUpstreamRequest data:
        :return: NpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_npm_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_npm_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_npm_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_npm_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/npm/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_nuget_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a NuGet upstream config for this repository.  # noqa: E501

        Create a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param NugetUpstreamRequest data:
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_nuget_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_nuget_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_nuget_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a NuGet upstream config for this repository.  # noqa: E501

        Create a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param NugetUpstreamRequest data:
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_nuget_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_nuget_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_nuget_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/nuget/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NugetUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_nuget_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a NuGet upstream config for this repository.  # noqa: E501

        Delete a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_nuget_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_nuget_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_nuget_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a NuGet upstream config for this repository.  # noqa: E501

        Delete a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_nuget_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_nuget_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_nuget_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_nuget_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_nuget_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List NuGet upstream configs for this repository.  # noqa: E501

        List NuGet upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[NugetUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_nuget_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_nuget_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_nuget_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List NuGet upstream configs for this repository.  # noqa: E501

        List NuGet upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[NugetUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_nuget_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_nuget_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_nuget_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/nuget/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[NugetUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_nuget_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a NuGet upstream config for this repository.  # noqa: E501

        Partially update a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NugetUpstreamRequestPatch data:
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_nuget_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_nuget_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_nuget_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a NuGet upstream config for this repository.  # noqa: E501

        Partially update a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NugetUpstreamRequestPatch data:
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_nuget_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_nuget_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_nuget_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_nuget_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NugetUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_nuget_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a NuGet upstream config for this repository.  # noqa: E501

        Retrieve a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_nuget_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_nuget_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_nuget_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a NuGet upstream config for this repository.  # noqa: E501

        Retrieve a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_nuget_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_nuget_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_nuget_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_nuget_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NugetUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_nuget_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a NuGet upstream config for this repository.  # noqa: E501

        Update a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NugetUpstreamRequest data:
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_nuget_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_nuget_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_nuget_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a NuGet upstream config for this repository.  # noqa: E501

        Update a NuGet upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_nuget_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param NugetUpstreamRequest data:
        :return: NugetUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_nuget_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_nuget_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_nuget_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_nuget_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/nuget/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NugetUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_python_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Python upstream config for this repository.  # noqa: E501

        Create a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param PythonUpstreamRequest data:
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_python_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_python_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_python_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Python upstream config for this repository.  # noqa: E501

        Create a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param PythonUpstreamRequest data:
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_python_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_python_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_python_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/python/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PythonUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_python_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Python upstream config for this repository.  # noqa: E501

        Delete a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_python_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_python_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_python_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Python upstream config for this repository.  # noqa: E501

        Delete a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_python_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_python_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_python_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_python_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/python/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_python_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Python upstream configs for this repository.  # noqa: E501

        List Python upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PythonUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_python_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_python_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_python_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Python upstream configs for this repository.  # noqa: E501

        List Python upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[PythonUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_python_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_python_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_python_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/python/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PythonUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_python_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Python upstream config for this repository.  # noqa: E501

        Partially update a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param PythonUpstreamRequestPatch data:
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_python_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_python_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_python_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Python upstream config for this repository.  # noqa: E501

        Partially update a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param PythonUpstreamRequestPatch data:
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_python_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_python_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_python_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_python_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/python/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PythonUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_python_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Python upstream config for this repository.  # noqa: E501

        Retrieve a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_python_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_python_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_python_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Python upstream config for this repository.  # noqa: E501

        Retrieve a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_python_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_python_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_python_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_python_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/python/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PythonUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_python_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Python upstream config for this repository.  # noqa: E501

        Update a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param PythonUpstreamRequest data:
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_python_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_python_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_python_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Python upstream config for this repository.  # noqa: E501

        Update a Python upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_python_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param PythonUpstreamRequest data:
        :return: PythonUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_python_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_python_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_python_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_python_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/python/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PythonUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_rpm_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a RedHat upstream config for this repository.  # noqa: E501

        Create a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RpmUpstreamRequest data:
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_rpm_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_rpm_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_rpm_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a RedHat upstream config for this repository.  # noqa: E501

        Create a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RpmUpstreamRequest data:
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_rpm_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_rpm_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_rpm_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/rpm/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_rpm_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a RedHat upstream config for this repository.  # noqa: E501

        Delete a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_rpm_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_rpm_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_rpm_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a RedHat upstream config for this repository.  # noqa: E501

        Delete a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_rpm_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_rpm_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_rpm_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_rpm_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_rpm_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List RedHat upstream configs for this repository.  # noqa: E501

        List RedHat upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[RpmUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_rpm_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_rpm_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_rpm_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List RedHat upstream configs for this repository.  # noqa: E501

        List RedHat upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[RpmUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_rpm_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_rpm_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_rpm_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/rpm/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RpmUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_rpm_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a RedHat upstream config for this repository.  # noqa: E501

        Partially update a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RpmUpstreamRequestPatch data:
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_rpm_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_rpm_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_rpm_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a RedHat upstream config for this repository.  # noqa: E501

        Partially update a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RpmUpstreamRequestPatch data:
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_rpm_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_rpm_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_rpm_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_rpm_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_rpm_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a RedHat upstream config for this repository.  # noqa: E501

        Retrieve a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_rpm_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_rpm_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_rpm_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a RedHat upstream config for this repository.  # noqa: E501

        Retrieve a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_rpm_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_rpm_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_rpm_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_rpm_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_rpm_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a RedHat upstream config for this repository.  # noqa: E501

        Update a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RpmUpstreamRequest data:
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_rpm_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_rpm_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_rpm_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a RedHat upstream config for this repository.  # noqa: E501

        Update a RedHat upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_rpm_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RpmUpstreamRequest data:
        :return: RpmUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_rpm_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_rpm_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_rpm_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_rpm_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/rpm/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RpmUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_ruby_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Ruby upstream config for this repository.  # noqa: E501

        Create a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RubyUpstreamRequest data:
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_ruby_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_ruby_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_ruby_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Ruby upstream config for this repository.  # noqa: E501

        Create a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param RubyUpstreamRequest data:
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_ruby_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_ruby_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_ruby_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/ruby/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RubyUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_ruby_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Ruby upstream config for this repository.  # noqa: E501

        Delete a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_ruby_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_ruby_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_ruby_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Ruby upstream config for this repository.  # noqa: E501

        Delete a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_ruby_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_ruby_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_ruby_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_ruby_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_ruby_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Ruby upstream configs for this repository.  # noqa: E501

        List Ruby upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[RubyUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_ruby_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_ruby_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_ruby_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Ruby upstream configs for this repository.  # noqa: E501

        List Ruby upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[RubyUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_ruby_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_ruby_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_ruby_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/ruby/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RubyUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_ruby_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Ruby upstream config for this repository.  # noqa: E501

        Partially update a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RubyUpstreamRequestPatch data:
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_ruby_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_ruby_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_ruby_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Ruby upstream config for this repository.  # noqa: E501

        Partially update a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RubyUpstreamRequestPatch data:
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_ruby_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_ruby_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_ruby_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_ruby_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RubyUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_ruby_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Ruby upstream config for this repository.  # noqa: E501

        Retrieve a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_ruby_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_ruby_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_ruby_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Ruby upstream config for this repository.  # noqa: E501

        Retrieve a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_ruby_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_ruby_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_ruby_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_ruby_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RubyUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_ruby_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Ruby upstream config for this repository.  # noqa: E501

        Update a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RubyUpstreamRequest data:
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_ruby_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_ruby_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_ruby_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Ruby upstream config for this repository.  # noqa: E501

        Update a Ruby upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_ruby_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param RubyUpstreamRequest data:
        :return: RubyUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_ruby_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_ruby_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_ruby_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_ruby_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/ruby/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RubyUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_swift_create(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Swift upstream config for this repository.  # noqa: E501

        Create a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_create(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param SwiftUpstreamRequest data:
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_swift_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_swift_create_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_swift_create_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Create a Swift upstream config for this repository.  # noqa: E501

        Create a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_create_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param SwiftUpstreamRequest data:
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_swift_create" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_swift_create`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_swift_create`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/swift/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SwiftUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_swift_delete(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Swift upstream config for this repository.  # noqa: E501

        Delete a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_delete(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_swift_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_swift_delete_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_swift_delete_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Delete a Swift upstream config for this repository.  # noqa: E501

        Delete a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_delete_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_swift_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_swift_delete`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_swift_delete`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_swift_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/swift/{slug_perm}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_swift_list(self, owner, identifier, **kwargs):  # noqa: E501
        """List Swift upstream configs for this repository.  # noqa: E501

        List Swift upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[SwiftUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_swift_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_swift_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_upstream_swift_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """List Swift upstream configs for this repository.  # noqa: E501

        List Swift upstream configs for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[SwiftUpstream]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_swift_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_swift_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_swift_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/swift/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SwiftUpstream]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_swift_partial_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Swift upstream config for this repository.  # noqa: E501

        Partially update a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_partial_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param SwiftUpstreamRequestPatch data:
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_swift_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_swift_partial_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_swift_partial_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Partially update a Swift upstream config for this repository.  # noqa: E501

        Partially update a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_partial_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param SwiftUpstreamRequestPatch data:
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_swift_partial_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_swift_partial_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_swift_partial_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_swift_partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/swift/{slug_perm}/', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SwiftUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_swift_read(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Swift upstream config for this repository.  # noqa: E501

        Retrieve a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_read(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_swift_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_swift_read_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_swift_read_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Retrieve a Swift upstream config for this repository.  # noqa: E501

        Retrieve a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_read_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_swift_read" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_swift_read`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_swift_read`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_swift_read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/swift/{slug_perm}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SwiftUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_upstream_swift_update(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Swift upstream config for this repository.  # noqa: E501

        Update a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_update(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param SwiftUpstreamRequest data:
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_upstream_swift_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_upstream_swift_update_with_http_info(owner, identifier, slug_perm, **kwargs)  # noqa: E501
            return data

    def repos_upstream_swift_update_with_http_info(self, owner, identifier, slug_perm, **kwargs):  # noqa: E501
        """Update a Swift upstream config for this repository.  # noqa: E501

        Update a Swift upstream config for this repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_upstream_swift_update_with_http_info(owner, identifier, slug_perm, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :param str slug_perm: (required)
        :param SwiftUpstreamRequest data:
        :return: SwiftUpstream
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier', 'slug_perm', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_upstream_swift_update" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_upstream_swift_update`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_upstream_swift_update`")  # noqa: E501
        # verify the required parameter 'slug_perm' is set
        if self.api_client.client_side_validation and ('slug_perm' not in params or
                                                       params['slug_perm'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `slug_perm` when calling `repos_upstream_swift_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'slug_perm' in params:
            path_params['slug_perm'] = params['slug_perm']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in params:
            body_params = params['data']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/upstream/swift/{slug_perm}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SwiftUpstream',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_user_list(self, **kwargs):  # noqa: E501
        """Get a list of all repositories associated with current user.  # noqa: E501

        Get a list of all repositories associated with current user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_user_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[Repository]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_user_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.repos_user_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def repos_user_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of all repositories associated with current user.  # noqa: E501

        Get a list of all repositories associated with current user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_user_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page: A page number within the paginated result set.
        :param int page_size: Number of results to return per page.
        :return: list[Repository]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_user_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Repository]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_x509_ecdsa_list(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active X.509 ECDSA certificate for the Repository.  # noqa: E501

        Retrieve the active X.509 ECDSA certificate for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_x509_ecdsa_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryX509EcdsaCertificate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_x509_ecdsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_x509_ecdsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_x509_ecdsa_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active X.509 ECDSA certificate for the Repository.  # noqa: E501

        Retrieve the active X.509 ECDSA certificate for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_x509_ecdsa_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryX509EcdsaCertificate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_x509_ecdsa_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_x509_ecdsa_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_x509_ecdsa_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/x509-ecdsa/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryX509EcdsaCertificate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def repos_x509_rsa_list(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active X.509 RSA certificate for the Repository.  # noqa: E501

        Retrieve the active X.509 RSA certificate for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_x509_rsa_list(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryX509RsaCertificate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.repos_x509_rsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.repos_x509_rsa_list_with_http_info(owner, identifier, **kwargs)  # noqa: E501
            return data

    def repos_x509_rsa_list_with_http_info(self, owner, identifier, **kwargs):  # noqa: E501
        """Retrieve the active X.509 RSA certificate for the Repository.  # noqa: E501

        Retrieve the active X.509 RSA certificate for the Repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.repos_x509_rsa_list_with_http_info(owner, identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str owner: (required)
        :param str identifier: (required)
        :return: RepositoryX509RsaCertificate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['owner', 'identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repos_x509_rsa_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'owner' is set
        if self.api_client.client_side_validation and ('owner' not in params or
                                                       params['owner'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `owner` when calling `repos_x509_rsa_list`")  # noqa: E501
        # verify the required parameter 'identifier' is set
        if self.api_client.client_side_validation and ('identifier' not in params or
                                                       params['identifier'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `identifier` when calling `repos_x509_rsa_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'owner' in params:
            path_params['owner'] = params['owner']  # noqa: E501
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikey', 'basic']  # noqa: E501

        return self.api_client.call_api(
            '/repos/{owner}/{identifier}/x509-rsa/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepositoryX509RsaCertificate',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
