# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class DebPackageUploadRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'changes_file': 'str',
        'component': 'str',
        'distribution': 'str',
        'package_file': 'str',
        'republish': 'bool',
        'sources_file': 'str',
        'tags': 'str'
    }

    attribute_map = {
        'changes_file': 'changes_file',
        'component': 'component',
        'distribution': 'distribution',
        'package_file': 'package_file',
        'republish': 'republish',
        'sources_file': 'sources_file',
        'tags': 'tags'
    }

    def __init__(self, changes_file=None, component='main', distribution=None, package_file=None, republish=None, sources_file=None, tags=None, _configuration=None):  # noqa: E501
        """DebPackageUploadRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._changes_file = None
        self._component = None
        self._distribution = None
        self._package_file = None
        self._republish = None
        self._sources_file = None
        self._tags = None
        self.discriminator = None

        if changes_file is not None:
            self.changes_file = changes_file
        if component is not None:
            self.component = component
        self.distribution = distribution
        self.package_file = package_file
        if republish is not None:
            self.republish = republish
        if sources_file is not None:
            self.sources_file = sources_file
        if tags is not None:
            self.tags = tags

    @property
    def changes_file(self):
        """Gets the changes_file of this DebPackageUploadRequest.

        The changes archive containing the changes made to the source and debian packaging files

        :return: The changes_file of this DebPackageUploadRequest.
        :rtype: str
        """
        return self._changes_file

    @changes_file.setter
    def changes_file(self, changes_file):
        """Sets the changes_file of this DebPackageUploadRequest.

        The changes archive containing the changes made to the source and debian packaging files

        :param changes_file: The changes_file of this DebPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                changes_file is not None and len(changes_file) < 1):
            raise ValueError("Invalid value for `changes_file`, length must be greater than or equal to `1`")  # noqa: E501

        self._changes_file = changes_file

    @property
    def component(self):
        """Gets the component of this DebPackageUploadRequest.

        The component (channel) for the package (e.g. 'main', 'unstable', etc.)

        :return: The component of this DebPackageUploadRequest.
        :rtype: str
        """
        return self._component

    @component.setter
    def component(self, component):
        """Sets the component of this DebPackageUploadRequest.

        The component (channel) for the package (e.g. 'main', 'unstable', etc.)

        :param component: The component of this DebPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                component is not None and len(component) > 64):
            raise ValueError("Invalid value for `component`, length must be less than or equal to `64`")  # noqa: E501
        if (self._configuration.client_side_validation and
                component is not None and len(component) < 1):
            raise ValueError("Invalid value for `component`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                component is not None and not re.search('^[-_.\\w]+$', component)):  # noqa: E501
            raise ValueError(r"Invalid value for `component`, must be a follow pattern or equal to `/^[-_.\\w]+$/`")  # noqa: E501

        self._component = component

    @property
    def distribution(self):
        """Gets the distribution of this DebPackageUploadRequest.

        The distribution to store the package for.

        :return: The distribution of this DebPackageUploadRequest.
        :rtype: str
        """
        return self._distribution

    @distribution.setter
    def distribution(self, distribution):
        """Sets the distribution of this DebPackageUploadRequest.

        The distribution to store the package for.

        :param distribution: The distribution of this DebPackageUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and distribution is None:
            raise ValueError("Invalid value for `distribution`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                distribution is not None and len(distribution) < 1):
            raise ValueError("Invalid value for `distribution`, length must be greater than or equal to `1`")  # noqa: E501

        self._distribution = distribution

    @property
    def package_file(self):
        """Gets the package_file of this DebPackageUploadRequest.

        The primary file for the package.

        :return: The package_file of this DebPackageUploadRequest.
        :rtype: str
        """
        return self._package_file

    @package_file.setter
    def package_file(self, package_file):
        """Sets the package_file of this DebPackageUploadRequest.

        The primary file for the package.

        :param package_file: The package_file of this DebPackageUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and package_file is None:
            raise ValueError("Invalid value for `package_file`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                package_file is not None and len(package_file) < 1):
            raise ValueError("Invalid value for `package_file`, length must be greater than or equal to `1`")  # noqa: E501

        self._package_file = package_file

    @property
    def republish(self):
        """Gets the republish of this DebPackageUploadRequest.

        If true, the uploaded package will overwrite any others with the same attributes (e.g. same version); otherwise, it will be flagged as a duplicate.

        :return: The republish of this DebPackageUploadRequest.
        :rtype: bool
        """
        return self._republish

    @republish.setter
    def republish(self, republish):
        """Sets the republish of this DebPackageUploadRequest.

        If true, the uploaded package will overwrite any others with the same attributes (e.g. same version); otherwise, it will be flagged as a duplicate.

        :param republish: The republish of this DebPackageUploadRequest.
        :type: bool
        """

        self._republish = republish

    @property
    def sources_file(self):
        """Gets the sources_file of this DebPackageUploadRequest.

        The sources archive containing the source code for the binary

        :return: The sources_file of this DebPackageUploadRequest.
        :rtype: str
        """
        return self._sources_file

    @sources_file.setter
    def sources_file(self, sources_file):
        """Sets the sources_file of this DebPackageUploadRequest.

        The sources archive containing the source code for the binary

        :param sources_file: The sources_file of this DebPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                sources_file is not None and len(sources_file) < 1):
            raise ValueError("Invalid value for `sources_file`, length must be greater than or equal to `1`")  # noqa: E501

        self._sources_file = sources_file

    @property
    def tags(self):
        """Gets the tags of this DebPackageUploadRequest.

        A comma-separated values list of tags to add to the package.

        :return: The tags of this DebPackageUploadRequest.
        :rtype: str
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this DebPackageUploadRequest.

        A comma-separated values list of tags to add to the package.

        :param tags: The tags of this DebPackageUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                tags is not None and len(tags) > 1024):
            raise ValueError("Invalid value for `tags`, length must be less than or equal to `1024`")  # noqa: E501
        if (self._configuration.client_side_validation and
                tags is not None and len(tags) < 1):
            raise ValueError("Invalid value for `tags`, length must be greater than or equal to `1`")  # noqa: E501

        self._tags = tags

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DebPackageUploadRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DebPackageUploadRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DebPackageUploadRequest):
            return True

        return self.to_dict() != other.to_dict()

