# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class Format(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'distributions': 'list[Distribution]',
        'extensions': 'list[str]',
        'name': 'str',
        'premium': 'bool',
        'premium_plan_id': 'str',
        'premium_plan_name': 'str',
        'slug': 'str',
        'supports': 'FormatSupport'
    }

    attribute_map = {
        'description': 'description',
        'distributions': 'distributions',
        'extensions': 'extensions',
        'name': 'name',
        'premium': 'premium',
        'premium_plan_id': 'premium_plan_id',
        'premium_plan_name': 'premium_plan_name',
        'slug': 'slug',
        'supports': 'supports'
    }

    def __init__(self, description=None, distributions=None, extensions=None, name=None, premium=None, premium_plan_id=None, premium_plan_name=None, slug=None, supports=None, _configuration=None):  # noqa: E501
        """Format - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._description = None
        self._distributions = None
        self._extensions = None
        self._name = None
        self._premium = None
        self._premium_plan_id = None
        self._premium_plan_name = None
        self._slug = None
        self._supports = None
        self.discriminator = None

        self.description = description
        if distributions is not None:
            self.distributions = distributions
        self.extensions = extensions
        self.name = name
        self.premium = premium
        if premium_plan_id is not None:
            self.premium_plan_id = premium_plan_id
        if premium_plan_name is not None:
            self.premium_plan_name = premium_plan_name
        self.slug = slug
        self.supports = supports

    @property
    def description(self):
        """Gets the description of this Format.

        Description of the package format

        :return: The description of this Format.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Format.

        Description of the package format

        :param description: The description of this Format.
        :type: str
        """
        if self._configuration.client_side_validation and description is None:
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                description is not None and len(description) < 1):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")  # noqa: E501

        self._description = description

    @property
    def distributions(self):
        """Gets the distributions of this Format.

        The distributions supported by this package format

        :return: The distributions of this Format.
        :rtype: list[Distribution]
        """
        return self._distributions

    @distributions.setter
    def distributions(self, distributions):
        """Sets the distributions of this Format.

        The distributions supported by this package format

        :param distributions: The distributions of this Format.
        :type: list[Distribution]
        """

        self._distributions = distributions

    @property
    def extensions(self):
        """Gets the extensions of this Format.

        A non-exhaustive list of extensions supported

        :return: The extensions of this Format.
        :rtype: list[str]
        """
        return self._extensions

    @extensions.setter
    def extensions(self, extensions):
        """Sets the extensions of this Format.

        A non-exhaustive list of extensions supported

        :param extensions: The extensions of this Format.
        :type: list[str]
        """
        if self._configuration.client_side_validation and extensions is None:
            raise ValueError("Invalid value for `extensions`, must not be `None`")  # noqa: E501

        self._extensions = extensions

    @property
    def name(self):
        """Gets the name of this Format.

        Name for the package format

        :return: The name of this Format.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Format.

        Name for the package format

        :param name: The name of this Format.
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def premium(self):
        """Gets the premium of this Format.

        If true the package format is a premium-only feature

        :return: The premium of this Format.
        :rtype: bool
        """
        return self._premium

    @premium.setter
    def premium(self, premium):
        """Sets the premium of this Format.

        If true the package format is a premium-only feature

        :param premium: The premium of this Format.
        :type: bool
        """
        if self._configuration.client_side_validation and premium is None:
            raise ValueError("Invalid value for `premium`, must not be `None`")  # noqa: E501

        self._premium = premium

    @property
    def premium_plan_id(self):
        """Gets the premium_plan_id of this Format.

        The minimum plan id required for this package format

        :return: The premium_plan_id of this Format.
        :rtype: str
        """
        return self._premium_plan_id

    @premium_plan_id.setter
    def premium_plan_id(self, premium_plan_id):
        """Sets the premium_plan_id of this Format.

        The minimum plan id required for this package format

        :param premium_plan_id: The premium_plan_id of this Format.
        :type: str
        """
        if (self._configuration.client_side_validation and
                premium_plan_id is not None and len(premium_plan_id) < 1):
            raise ValueError("Invalid value for `premium_plan_id`, length must be greater than or equal to `1`")  # noqa: E501

        self._premium_plan_id = premium_plan_id

    @property
    def premium_plan_name(self):
        """Gets the premium_plan_name of this Format.

        The minimum plan name required for this package format

        :return: The premium_plan_name of this Format.
        :rtype: str
        """
        return self._premium_plan_name

    @premium_plan_name.setter
    def premium_plan_name(self, premium_plan_name):
        """Sets the premium_plan_name of this Format.

        The minimum plan name required for this package format

        :param premium_plan_name: The premium_plan_name of this Format.
        :type: str
        """
        if (self._configuration.client_side_validation and
                premium_plan_name is not None and len(premium_plan_name) < 1):
            raise ValueError("Invalid value for `premium_plan_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._premium_plan_name = premium_plan_name

    @property
    def slug(self):
        """Gets the slug of this Format.

        Slug for the package format

        :return: The slug of this Format.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this Format.

        Slug for the package format

        :param slug: The slug of this Format.
        :type: str
        """
        if self._configuration.client_side_validation and slug is None:
            raise ValueError("Invalid value for `slug`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug is not None and len(slug) < 1):
            raise ValueError("Invalid value for `slug`, length must be greater than or equal to `1`")  # noqa: E501

        self._slug = slug

    @property
    def supports(self):
        """Gets the supports of this Format.


        :return: The supports of this Format.
        :rtype: FormatSupport
        """
        return self._supports

    @supports.setter
    def supports(self, supports):
        """Sets the supports of this Format.


        :param supports: The supports of this Format.
        :type: FormatSupport
        """
        if self._configuration.client_side_validation and supports is None:
            raise ValueError("Invalid value for `supports`, must not be `None`")  # noqa: E501

        self._supports = supports

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Format, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Format):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Format):
            return True

        return self.to_dict() != other.to_dict()

