# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class NestedVulnerabilityPolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allow_unknown_severity': 'bool',
        'created_at': 'datetime',
        'description': 'str',
        'min_severity': 'str',
        'name': 'str',
        'on_violation_quarantine': 'bool',
        'package_query_string': 'str',
        'slug_perm': 'str',
        'updated_at': 'datetime',
        'url': 'str'
    }

    attribute_map = {
        'allow_unknown_severity': 'allow_unknown_severity',
        'created_at': 'created_at',
        'description': 'description',
        'min_severity': 'min_severity',
        'name': 'name',
        'on_violation_quarantine': 'on_violation_quarantine',
        'package_query_string': 'package_query_string',
        'slug_perm': 'slug_perm',
        'updated_at': 'updated_at',
        'url': 'url'
    }

    def __init__(self, allow_unknown_severity=None, created_at=None, description=None, min_severity='Critical', name=None, on_violation_quarantine=None, package_query_string=None, slug_perm=None, updated_at=None, url=None, _configuration=None):  # noqa: E501
        """NestedVulnerabilityPolicy - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._allow_unknown_severity = None
        self._created_at = None
        self._description = None
        self._min_severity = None
        self._name = None
        self._on_violation_quarantine = None
        self._package_query_string = None
        self._slug_perm = None
        self._updated_at = None
        self._url = None
        self.discriminator = None

        if allow_unknown_severity is not None:
            self.allow_unknown_severity = allow_unknown_severity
        if created_at is not None:
            self.created_at = created_at
        if description is not None:
            self.description = description
        if min_severity is not None:
            self.min_severity = min_severity
        if name is not None:
            self.name = name
        if on_violation_quarantine is not None:
            self.on_violation_quarantine = on_violation_quarantine
        if package_query_string is not None:
            self.package_query_string = package_query_string
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if updated_at is not None:
            self.updated_at = updated_at
        if url is not None:
            self.url = url

    @property
    def allow_unknown_severity(self):
        """Gets the allow_unknown_severity of this NestedVulnerabilityPolicy.

        Denotes whether vulnerabilities detected by a security scan with an unknown severity are permitted by this policy.

        :return: The allow_unknown_severity of this NestedVulnerabilityPolicy.
        :rtype: bool
        """
        return self._allow_unknown_severity

    @allow_unknown_severity.setter
    def allow_unknown_severity(self, allow_unknown_severity):
        """Sets the allow_unknown_severity of this NestedVulnerabilityPolicy.

        Denotes whether vulnerabilities detected by a security scan with an unknown severity are permitted by this policy.

        :param allow_unknown_severity: The allow_unknown_severity of this NestedVulnerabilityPolicy.
        :type: bool
        """

        self._allow_unknown_severity = allow_unknown_severity

    @property
    def created_at(self):
        """Gets the created_at of this NestedVulnerabilityPolicy.


        :return: The created_at of this NestedVulnerabilityPolicy.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this NestedVulnerabilityPolicy.


        :param created_at: The created_at of this NestedVulnerabilityPolicy.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def description(self):
        """Gets the description of this NestedVulnerabilityPolicy.


        :return: The description of this NestedVulnerabilityPolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this NestedVulnerabilityPolicy.


        :param description: The description of this NestedVulnerabilityPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                description is not None and len(description) < 1):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")  # noqa: E501

        self._description = description

    @property
    def min_severity(self):
        """Gets the min_severity of this NestedVulnerabilityPolicy.


        :return: The min_severity of this NestedVulnerabilityPolicy.
        :rtype: str
        """
        return self._min_severity

    @min_severity.setter
    def min_severity(self, min_severity):
        """Sets the min_severity of this NestedVulnerabilityPolicy.


        :param min_severity: The min_severity of this NestedVulnerabilityPolicy.
        :type: str
        """
        allowed_values = ["Low", "Medium", "High", "Critical"]  # noqa: E501
        if (self._configuration.client_side_validation and
                min_severity not in allowed_values):
            raise ValueError(
                "Invalid value for `min_severity` ({0}), must be one of {1}"  # noqa: E501
                .format(min_severity, allowed_values)
            )

        self._min_severity = min_severity

    @property
    def name(self):
        """Gets the name of this NestedVulnerabilityPolicy.


        :return: The name of this NestedVulnerabilityPolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NestedVulnerabilityPolicy.


        :param name: The name of this NestedVulnerabilityPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def on_violation_quarantine(self):
        """Gets the on_violation_quarantine of this NestedVulnerabilityPolicy.


        :return: The on_violation_quarantine of this NestedVulnerabilityPolicy.
        :rtype: bool
        """
        return self._on_violation_quarantine

    @on_violation_quarantine.setter
    def on_violation_quarantine(self, on_violation_quarantine):
        """Sets the on_violation_quarantine of this NestedVulnerabilityPolicy.


        :param on_violation_quarantine: The on_violation_quarantine of this NestedVulnerabilityPolicy.
        :type: bool
        """

        self._on_violation_quarantine = on_violation_quarantine

    @property
    def package_query_string(self):
        """Gets the package_query_string of this NestedVulnerabilityPolicy.


        :return: The package_query_string of this NestedVulnerabilityPolicy.
        :rtype: str
        """
        return self._package_query_string

    @package_query_string.setter
    def package_query_string(self, package_query_string):
        """Sets the package_query_string of this NestedVulnerabilityPolicy.


        :param package_query_string: The package_query_string of this NestedVulnerabilityPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                package_query_string is not None and len(package_query_string) < 1):
            raise ValueError("Invalid value for `package_query_string`, length must be greater than or equal to `1`")  # noqa: E501

        self._package_query_string = package_query_string

    @property
    def slug_perm(self):
        """Gets the slug_perm of this NestedVulnerabilityPolicy.


        :return: The slug_perm of this NestedVulnerabilityPolicy.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this NestedVulnerabilityPolicy.


        :param slug_perm: The slug_perm of this NestedVulnerabilityPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def updated_at(self):
        """Gets the updated_at of this NestedVulnerabilityPolicy.


        :return: The updated_at of this NestedVulnerabilityPolicy.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this NestedVulnerabilityPolicy.


        :param updated_at: The updated_at of this NestedVulnerabilityPolicy.
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def url(self):
        """Gets the url of this NestedVulnerabilityPolicy.


        :return: The url of this NestedVulnerabilityPolicy.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this NestedVulnerabilityPolicy.


        :param url: The url of this NestedVulnerabilityPolicy.
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NestedVulnerabilityPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NestedVulnerabilityPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NestedVulnerabilityPolicy):
            return True

        return self.to_dict() != other.to_dict()

