# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class OrganizationGroupSyncRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'idp_key': 'str',
        'idp_value': 'str',
        'organization': 'str',
        'role': 'str',
        'team': 'str'
    }

    attribute_map = {
        'idp_key': 'idp_key',
        'idp_value': 'idp_value',
        'organization': 'organization',
        'role': 'role',
        'team': 'team'
    }

    def __init__(self, idp_key=None, idp_value=None, organization=None, role='Member', team=None, _configuration=None):  # noqa: E501
        """OrganizationGroupSyncRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._idp_key = None
        self._idp_value = None
        self._organization = None
        self._role = None
        self._team = None
        self.discriminator = None

        self.idp_key = idp_key
        self.idp_value = idp_value
        self.organization = organization
        if role is not None:
            self.role = role
        self.team = team

    @property
    def idp_key(self):
        """Gets the idp_key of this OrganizationGroupSyncRequest.


        :return: The idp_key of this OrganizationGroupSyncRequest.
        :rtype: str
        """
        return self._idp_key

    @idp_key.setter
    def idp_key(self, idp_key):
        """Sets the idp_key of this OrganizationGroupSyncRequest.


        :param idp_key: The idp_key of this OrganizationGroupSyncRequest.
        :type: str
        """
        if self._configuration.client_side_validation and idp_key is None:
            raise ValueError("Invalid value for `idp_key`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_key is not None and len(idp_key) > 100):
            raise ValueError("Invalid value for `idp_key`, length must be less than or equal to `100`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_key is not None and len(idp_key) < 1):
            raise ValueError("Invalid value for `idp_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._idp_key = idp_key

    @property
    def idp_value(self):
        """Gets the idp_value of this OrganizationGroupSyncRequest.


        :return: The idp_value of this OrganizationGroupSyncRequest.
        :rtype: str
        """
        return self._idp_value

    @idp_value.setter
    def idp_value(self, idp_value):
        """Sets the idp_value of this OrganizationGroupSyncRequest.


        :param idp_value: The idp_value of this OrganizationGroupSyncRequest.
        :type: str
        """
        if self._configuration.client_side_validation and idp_value is None:
            raise ValueError("Invalid value for `idp_value`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_value is not None and len(idp_value) > 100):
            raise ValueError("Invalid value for `idp_value`, length must be less than or equal to `100`")  # noqa: E501
        if (self._configuration.client_side_validation and
                idp_value is not None and len(idp_value) < 1):
            raise ValueError("Invalid value for `idp_value`, length must be greater than or equal to `1`")  # noqa: E501

        self._idp_value = idp_value

    @property
    def organization(self):
        """Gets the organization of this OrganizationGroupSyncRequest.


        :return: The organization of this OrganizationGroupSyncRequest.
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this OrganizationGroupSyncRequest.


        :param organization: The organization of this OrganizationGroupSyncRequest.
        :type: str
        """
        if self._configuration.client_side_validation and organization is None:
            raise ValueError("Invalid value for `organization`, must not be `None`")  # noqa: E501

        self._organization = organization

    @property
    def role(self):
        """Gets the role of this OrganizationGroupSyncRequest.


        :return: The role of this OrganizationGroupSyncRequest.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this OrganizationGroupSyncRequest.


        :param role: The role of this OrganizationGroupSyncRequest.
        :type: str
        """
        allowed_values = ["Manager", "Member"]  # noqa: E501
        if (self._configuration.client_side_validation and
                role not in allowed_values):
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def team(self):
        """Gets the team of this OrganizationGroupSyncRequest.


        :return: The team of this OrganizationGroupSyncRequest.
        :rtype: str
        """
        return self._team

    @team.setter
    def team(self, team):
        """Sets the team of this OrganizationGroupSyncRequest.


        :param team: The team of this OrganizationGroupSyncRequest.
        :type: str
        """
        if self._configuration.client_side_validation and team is None:
            raise ValueError("Invalid value for `team`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                team is not None and not re.search('^[-a-zA-Z0-9_]+$', team)):  # noqa: E501
            raise ValueError(r"Invalid value for `team`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._team = team

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrganizationGroupSyncRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationGroupSyncRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrganizationGroupSyncRequest):
            return True

        return self.to_dict() != other.to_dict()

