# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class OrganizationInvite(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email': 'str',
        'expires_at': 'datetime',
        'inviter': 'str',
        'inviter_url': 'str',
        'org': 'str',
        'role': 'str',
        'slug_perm': 'str',
        'teams': 'list[OrganizationTeamInvite]',
        'user': 'str',
        'user_url': 'str'
    }

    attribute_map = {
        'email': 'email',
        'expires_at': 'expires_at',
        'inviter': 'inviter',
        'inviter_url': 'inviter_url',
        'org': 'org',
        'role': 'role',
        'slug_perm': 'slug_perm',
        'teams': 'teams',
        'user': 'user',
        'user_url': 'user_url'
    }

    def __init__(self, email=None, expires_at=None, inviter=None, inviter_url=None, org=None, role='Member', slug_perm=None, teams=None, user=None, user_url=None, _configuration=None):  # noqa: E501
        """OrganizationInvite - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._email = None
        self._expires_at = None
        self._inviter = None
        self._inviter_url = None
        self._org = None
        self._role = None
        self._slug_perm = None
        self._teams = None
        self._user = None
        self._user_url = None
        self.discriminator = None

        if email is not None:
            self.email = email
        if expires_at is not None:
            self.expires_at = expires_at
        if inviter is not None:
            self.inviter = inviter
        if inviter_url is not None:
            self.inviter_url = inviter_url
        if org is not None:
            self.org = org
        if role is not None:
            self.role = role
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if teams is not None:
            self.teams = teams
        if user is not None:
            self.user = user
        if user_url is not None:
            self.user_url = user_url

    @property
    def email(self):
        """Gets the email of this OrganizationInvite.

        The email of the user to be invited.

        :return: The email of this OrganizationInvite.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this OrganizationInvite.

        The email of the user to be invited.

        :param email: The email of this OrganizationInvite.
        :type: str
        """
        if (self._configuration.client_side_validation and
                email is not None and len(email) < 1):
            raise ValueError("Invalid value for `email`, length must be greater than or equal to `1`")  # noqa: E501

        self._email = email

    @property
    def expires_at(self):
        """Gets the expires_at of this OrganizationInvite.


        :return: The expires_at of this OrganizationInvite.
        :rtype: datetime
        """
        return self._expires_at

    @expires_at.setter
    def expires_at(self, expires_at):
        """Sets the expires_at of this OrganizationInvite.


        :param expires_at: The expires_at of this OrganizationInvite.
        :type: datetime
        """

        self._expires_at = expires_at

    @property
    def inviter(self):
        """Gets the inviter of this OrganizationInvite.


        :return: The inviter of this OrganizationInvite.
        :rtype: str
        """
        return self._inviter

    @inviter.setter
    def inviter(self, inviter):
        """Sets the inviter of this OrganizationInvite.


        :param inviter: The inviter of this OrganizationInvite.
        :type: str
        """
        if (self._configuration.client_side_validation and
                inviter is not None and len(inviter) < 1):
            raise ValueError("Invalid value for `inviter`, length must be greater than or equal to `1`")  # noqa: E501

        self._inviter = inviter

    @property
    def inviter_url(self):
        """Gets the inviter_url of this OrganizationInvite.


        :return: The inviter_url of this OrganizationInvite.
        :rtype: str
        """
        return self._inviter_url

    @inviter_url.setter
    def inviter_url(self, inviter_url):
        """Sets the inviter_url of this OrganizationInvite.


        :param inviter_url: The inviter_url of this OrganizationInvite.
        :type: str
        """

        self._inviter_url = inviter_url

    @property
    def org(self):
        """Gets the org of this OrganizationInvite.


        :return: The org of this OrganizationInvite.
        :rtype: str
        """
        return self._org

    @org.setter
    def org(self, org):
        """Sets the org of this OrganizationInvite.


        :param org: The org of this OrganizationInvite.
        :type: str
        """

        self._org = org

    @property
    def role(self):
        """Gets the role of this OrganizationInvite.

        The role to be assigned to the invited user.

        :return: The role of this OrganizationInvite.
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this OrganizationInvite.

        The role to be assigned to the invited user.

        :param role: The role of this OrganizationInvite.
        :type: str
        """
        allowed_values = ["Owner", "Manager", "Member", "Collaborator"]  # noqa: E501
        if (self._configuration.client_side_validation and
                role not in allowed_values):
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def slug_perm(self):
        """Gets the slug_perm of this OrganizationInvite.


        :return: The slug_perm of this OrganizationInvite.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this OrganizationInvite.


        :param slug_perm: The slug_perm of this OrganizationInvite.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def teams(self):
        """Gets the teams of this OrganizationInvite.


        :return: The teams of this OrganizationInvite.
        :rtype: list[OrganizationTeamInvite]
        """
        return self._teams

    @teams.setter
    def teams(self, teams):
        """Sets the teams of this OrganizationInvite.


        :param teams: The teams of this OrganizationInvite.
        :type: list[OrganizationTeamInvite]
        """

        self._teams = teams

    @property
    def user(self):
        """Gets the user of this OrganizationInvite.

        The slug of the user to be invited.

        :return: The user of this OrganizationInvite.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this OrganizationInvite.

        The slug of the user to be invited.

        :param user: The user of this OrganizationInvite.
        :type: str
        """
        if (self._configuration.client_side_validation and
                user is not None and len(user) < 1):
            raise ValueError("Invalid value for `user`, length must be greater than or equal to `1`")  # noqa: E501

        self._user = user

    @property
    def user_url(self):
        """Gets the user_url of this OrganizationInvite.


        :return: The user_url of this OrganizationInvite.
        :rtype: str
        """
        return self._user_url

    @user_url.setter
    def user_url(self, user_url):
        """Sets the user_url of this OrganizationInvite.


        :param user_url: The user_url of this OrganizationInvite.
        :type: str
        """

        self._user_url = user_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrganizationInvite, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationInvite):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrganizationInvite):
            return True

        return self.to_dict() != other.to_dict()

