# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class OrganizationPackageLicensePolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'allow_unknown_licenses': 'bool',
        'created_at': 'datetime',
        'description': 'str',
        'name': 'str',
        'on_violation_quarantine': 'bool',
        'package_query_string': 'str',
        'slug_perm': 'str',
        'spdx_identifiers': 'list[str]',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'allow_unknown_licenses': 'allow_unknown_licenses',
        'created_at': 'created_at',
        'description': 'description',
        'name': 'name',
        'on_violation_quarantine': 'on_violation_quarantine',
        'package_query_string': 'package_query_string',
        'slug_perm': 'slug_perm',
        'spdx_identifiers': 'spdx_identifiers',
        'updated_at': 'updated_at'
    }

    def __init__(self, allow_unknown_licenses=None, created_at=None, description=None, name=None, on_violation_quarantine=None, package_query_string=None, slug_perm=None, spdx_identifiers=None, updated_at=None, _configuration=None):  # noqa: E501
        """OrganizationPackageLicensePolicy - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._allow_unknown_licenses = None
        self._created_at = None
        self._description = None
        self._name = None
        self._on_violation_quarantine = None
        self._package_query_string = None
        self._slug_perm = None
        self._spdx_identifiers = None
        self._updated_at = None
        self.discriminator = None

        if allow_unknown_licenses is not None:
            self.allow_unknown_licenses = allow_unknown_licenses
        if created_at is not None:
            self.created_at = created_at
        if description is not None:
            self.description = description
        self.name = name
        if on_violation_quarantine is not None:
            self.on_violation_quarantine = on_violation_quarantine
        if package_query_string is not None:
            self.package_query_string = package_query_string
        if slug_perm is not None:
            self.slug_perm = slug_perm
        self.spdx_identifiers = spdx_identifiers
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def allow_unknown_licenses(self):
        """Gets the allow_unknown_licenses of this OrganizationPackageLicensePolicy.


        :return: The allow_unknown_licenses of this OrganizationPackageLicensePolicy.
        :rtype: bool
        """
        return self._allow_unknown_licenses

    @allow_unknown_licenses.setter
    def allow_unknown_licenses(self, allow_unknown_licenses):
        """Sets the allow_unknown_licenses of this OrganizationPackageLicensePolicy.


        :param allow_unknown_licenses: The allow_unknown_licenses of this OrganizationPackageLicensePolicy.
        :type: bool
        """

        self._allow_unknown_licenses = allow_unknown_licenses

    @property
    def created_at(self):
        """Gets the created_at of this OrganizationPackageLicensePolicy.


        :return: The created_at of this OrganizationPackageLicensePolicy.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this OrganizationPackageLicensePolicy.


        :param created_at: The created_at of this OrganizationPackageLicensePolicy.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def description(self):
        """Gets the description of this OrganizationPackageLicensePolicy.


        :return: The description of this OrganizationPackageLicensePolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this OrganizationPackageLicensePolicy.


        :param description: The description of this OrganizationPackageLicensePolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                description is not None and len(description) > 250):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `250`")  # noqa: E501
        if (self._configuration.client_side_validation and
                description is not None and len(description) < 1):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")  # noqa: E501

        self._description = description

    @property
    def name(self):
        """Gets the name of this OrganizationPackageLicensePolicy.


        :return: The name of this OrganizationPackageLicensePolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OrganizationPackageLicensePolicy.


        :param name: The name of this OrganizationPackageLicensePolicy.
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def on_violation_quarantine(self):
        """Gets the on_violation_quarantine of this OrganizationPackageLicensePolicy.


        :return: The on_violation_quarantine of this OrganizationPackageLicensePolicy.
        :rtype: bool
        """
        return self._on_violation_quarantine

    @on_violation_quarantine.setter
    def on_violation_quarantine(self, on_violation_quarantine):
        """Sets the on_violation_quarantine of this OrganizationPackageLicensePolicy.


        :param on_violation_quarantine: The on_violation_quarantine of this OrganizationPackageLicensePolicy.
        :type: bool
        """

        self._on_violation_quarantine = on_violation_quarantine

    @property
    def package_query_string(self):
        """Gets the package_query_string of this OrganizationPackageLicensePolicy.


        :return: The package_query_string of this OrganizationPackageLicensePolicy.
        :rtype: str
        """
        return self._package_query_string

    @package_query_string.setter
    def package_query_string(self, package_query_string):
        """Sets the package_query_string of this OrganizationPackageLicensePolicy.


        :param package_query_string: The package_query_string of this OrganizationPackageLicensePolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                package_query_string is not None and len(package_query_string) < 1):
            raise ValueError("Invalid value for `package_query_string`, length must be greater than or equal to `1`")  # noqa: E501

        self._package_query_string = package_query_string

    @property
    def slug_perm(self):
        """Gets the slug_perm of this OrganizationPackageLicensePolicy.


        :return: The slug_perm of this OrganizationPackageLicensePolicy.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this OrganizationPackageLicensePolicy.


        :param slug_perm: The slug_perm of this OrganizationPackageLicensePolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def spdx_identifiers(self):
        """Gets the spdx_identifiers of this OrganizationPackageLicensePolicy.


        :return: The spdx_identifiers of this OrganizationPackageLicensePolicy.
        :rtype: list[str]
        """
        return self._spdx_identifiers

    @spdx_identifiers.setter
    def spdx_identifiers(self, spdx_identifiers):
        """Sets the spdx_identifiers of this OrganizationPackageLicensePolicy.


        :param spdx_identifiers: The spdx_identifiers of this OrganizationPackageLicensePolicy.
        :type: list[str]
        """
        if self._configuration.client_side_validation and spdx_identifiers is None:
            raise ValueError("Invalid value for `spdx_identifiers`, must not be `None`")  # noqa: E501

        self._spdx_identifiers = spdx_identifiers

    @property
    def updated_at(self):
        """Gets the updated_at of this OrganizationPackageLicensePolicy.


        :return: The updated_at of this OrganizationPackageLicensePolicy.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this OrganizationPackageLicensePolicy.


        :param updated_at: The updated_at of this OrganizationPackageLicensePolicy.
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrganizationPackageLicensePolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationPackageLicensePolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrganizationPackageLicensePolicy):
            return True

        return self.to_dict() != other.to_dict()

