# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class PackageDenyPolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'created_at': 'datetime',
        'description': 'str',
        'enabled': 'bool',
        'name': 'str',
        'package_query_string': 'str',
        'slug_perm': 'str',
        'status': 'str',
        'updated_at': 'datetime'
    }

    attribute_map = {
        'action': 'action',
        'created_at': 'created_at',
        'description': 'description',
        'enabled': 'enabled',
        'name': 'name',
        'package_query_string': 'package_query_string',
        'slug_perm': 'slug_perm',
        'status': 'status',
        'updated_at': 'updated_at'
    }

    def __init__(self, action='Block downloads', created_at=None, description=None, enabled=None, name=None, package_query_string=None, slug_perm=None, status='In Progress', updated_at=None, _configuration=None):  # noqa: E501
        """PackageDenyPolicy - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._action = None
        self._created_at = None
        self._description = None
        self._enabled = None
        self._name = None
        self._package_query_string = None
        self._slug_perm = None
        self._status = None
        self._updated_at = None
        self.discriminator = None

        if action is not None:
            self.action = action
        if created_at is not None:
            self.created_at = created_at
        if description is not None:
            self.description = description
        if enabled is not None:
            self.enabled = enabled
        if name is not None:
            self.name = name
        self.package_query_string = package_query_string
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if status is not None:
            self.status = status
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def action(self):
        """Gets the action of this PackageDenyPolicy.


        :return: The action of this PackageDenyPolicy.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this PackageDenyPolicy.


        :param action: The action of this PackageDenyPolicy.
        :type: str
        """
        allowed_values = ["Block downloads"]  # noqa: E501
        if (self._configuration.client_side_validation and
                action not in allowed_values):
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def created_at(self):
        """Gets the created_at of this PackageDenyPolicy.


        :return: The created_at of this PackageDenyPolicy.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this PackageDenyPolicy.


        :param created_at: The created_at of this PackageDenyPolicy.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def description(self):
        """Gets the description of this PackageDenyPolicy.


        :return: The description of this PackageDenyPolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this PackageDenyPolicy.


        :param description: The description of this PackageDenyPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                description is not None and len(description) > 250):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `250`")  # noqa: E501

        self._description = description

    @property
    def enabled(self):
        """Gets the enabled of this PackageDenyPolicy.

        Whether this rule is enabled or disabled.

        :return: The enabled of this PackageDenyPolicy.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this PackageDenyPolicy.

        Whether this rule is enabled or disabled.

        :param enabled: The enabled of this PackageDenyPolicy.
        :type: bool
        """

        self._enabled = enabled

    @property
    def name(self):
        """Gets the name of this PackageDenyPolicy.


        :return: The name of this PackageDenyPolicy.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PackageDenyPolicy.


        :param name: The name of this PackageDenyPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501

        self._name = name

    @property
    def package_query_string(self):
        """Gets the package_query_string of this PackageDenyPolicy.

        Packages that match this query will trigger this deny rule.

        :return: The package_query_string of this PackageDenyPolicy.
        :rtype: str
        """
        return self._package_query_string

    @package_query_string.setter
    def package_query_string(self, package_query_string):
        """Sets the package_query_string of this PackageDenyPolicy.

        Packages that match this query will trigger this deny rule.

        :param package_query_string: The package_query_string of this PackageDenyPolicy.
        :type: str
        """
        if self._configuration.client_side_validation and package_query_string is None:
            raise ValueError("Invalid value for `package_query_string`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                package_query_string is not None and len(package_query_string) < 1):
            raise ValueError("Invalid value for `package_query_string`, length must be greater than or equal to `1`")  # noqa: E501

        self._package_query_string = package_query_string

    @property
    def slug_perm(self):
        """Gets the slug_perm of this PackageDenyPolicy.


        :return: The slug_perm of this PackageDenyPolicy.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this PackageDenyPolicy.


        :param slug_perm: The slug_perm of this PackageDenyPolicy.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def status(self):
        """Gets the status of this PackageDenyPolicy.


        :return: The status of this PackageDenyPolicy.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PackageDenyPolicy.


        :param status: The status of this PackageDenyPolicy.
        :type: str
        """
        allowed_values = ["Pending", "In Progress", "Complete", "Cancelled", "Errored"]  # noqa: E501
        if (self._configuration.client_side_validation and
                status not in allowed_values):
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def updated_at(self):
        """Gets the updated_at of this PackageDenyPolicy.


        :return: The updated_at of this PackageDenyPolicy.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this PackageDenyPolicy.


        :param updated_at: The updated_at of this PackageDenyPolicy.
        :type: datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PackageDenyPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageDenyPolicy):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageDenyPolicy):
            return True

        return self.to_dict() != other.to_dict()

