# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class PackageFile(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cdn_url': 'str',
        'checksum_md5': 'str',
        'checksum_sha1': 'str',
        'checksum_sha256': 'str',
        'checksum_sha512': 'str',
        'downloads': 'int',
        'filename': 'str',
        'is_downloadable': 'bool',
        'is_primary': 'bool',
        'is_synchronised': 'bool',
        'signature_url': 'str',
        'size': 'int',
        'slug_perm': 'str',
        'tag': 'str'
    }

    attribute_map = {
        'cdn_url': 'cdn_url',
        'checksum_md5': 'checksum_md5',
        'checksum_sha1': 'checksum_sha1',
        'checksum_sha256': 'checksum_sha256',
        'checksum_sha512': 'checksum_sha512',
        'downloads': 'downloads',
        'filename': 'filename',
        'is_downloadable': 'is_downloadable',
        'is_primary': 'is_primary',
        'is_synchronised': 'is_synchronised',
        'signature_url': 'signature_url',
        'size': 'size',
        'slug_perm': 'slug_perm',
        'tag': 'tag'
    }

    def __init__(self, cdn_url=None, checksum_md5=None, checksum_sha1=None, checksum_sha256=None, checksum_sha512=None, downloads=None, filename=None, is_downloadable=None, is_primary=None, is_synchronised=None, signature_url=None, size=None, slug_perm=None, tag=None, _configuration=None):  # noqa: E501
        """PackageFile - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._cdn_url = None
        self._checksum_md5 = None
        self._checksum_sha1 = None
        self._checksum_sha256 = None
        self._checksum_sha512 = None
        self._downloads = None
        self._filename = None
        self._is_downloadable = None
        self._is_primary = None
        self._is_synchronised = None
        self._signature_url = None
        self._size = None
        self._slug_perm = None
        self._tag = None
        self.discriminator = None

        if cdn_url is not None:
            self.cdn_url = cdn_url
        if checksum_md5 is not None:
            self.checksum_md5 = checksum_md5
        if checksum_sha1 is not None:
            self.checksum_sha1 = checksum_sha1
        if checksum_sha256 is not None:
            self.checksum_sha256 = checksum_sha256
        if checksum_sha512 is not None:
            self.checksum_sha512 = checksum_sha512
        if downloads is not None:
            self.downloads = downloads
        if filename is not None:
            self.filename = filename
        if is_downloadable is not None:
            self.is_downloadable = is_downloadable
        if is_primary is not None:
            self.is_primary = is_primary
        if is_synchronised is not None:
            self.is_synchronised = is_synchronised
        if signature_url is not None:
            self.signature_url = signature_url
        if size is not None:
            self.size = size
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if tag is not None:
            self.tag = tag

    @property
    def cdn_url(self):
        """Gets the cdn_url of this PackageFile.


        :return: The cdn_url of this PackageFile.
        :rtype: str
        """
        return self._cdn_url

    @cdn_url.setter
    def cdn_url(self, cdn_url):
        """Sets the cdn_url of this PackageFile.


        :param cdn_url: The cdn_url of this PackageFile.
        :type: str
        """

        self._cdn_url = cdn_url

    @property
    def checksum_md5(self):
        """Gets the checksum_md5 of this PackageFile.


        :return: The checksum_md5 of this PackageFile.
        :rtype: str
        """
        return self._checksum_md5

    @checksum_md5.setter
    def checksum_md5(self, checksum_md5):
        """Sets the checksum_md5 of this PackageFile.


        :param checksum_md5: The checksum_md5 of this PackageFile.
        :type: str
        """

        self._checksum_md5 = checksum_md5

    @property
    def checksum_sha1(self):
        """Gets the checksum_sha1 of this PackageFile.


        :return: The checksum_sha1 of this PackageFile.
        :rtype: str
        """
        return self._checksum_sha1

    @checksum_sha1.setter
    def checksum_sha1(self, checksum_sha1):
        """Sets the checksum_sha1 of this PackageFile.


        :param checksum_sha1: The checksum_sha1 of this PackageFile.
        :type: str
        """

        self._checksum_sha1 = checksum_sha1

    @property
    def checksum_sha256(self):
        """Gets the checksum_sha256 of this PackageFile.


        :return: The checksum_sha256 of this PackageFile.
        :rtype: str
        """
        return self._checksum_sha256

    @checksum_sha256.setter
    def checksum_sha256(self, checksum_sha256):
        """Sets the checksum_sha256 of this PackageFile.


        :param checksum_sha256: The checksum_sha256 of this PackageFile.
        :type: str
        """

        self._checksum_sha256 = checksum_sha256

    @property
    def checksum_sha512(self):
        """Gets the checksum_sha512 of this PackageFile.


        :return: The checksum_sha512 of this PackageFile.
        :rtype: str
        """
        return self._checksum_sha512

    @checksum_sha512.setter
    def checksum_sha512(self, checksum_sha512):
        """Sets the checksum_sha512 of this PackageFile.


        :param checksum_sha512: The checksum_sha512 of this PackageFile.
        :type: str
        """

        self._checksum_sha512 = checksum_sha512

    @property
    def downloads(self):
        """Gets the downloads of this PackageFile.


        :return: The downloads of this PackageFile.
        :rtype: int
        """
        return self._downloads

    @downloads.setter
    def downloads(self, downloads):
        """Sets the downloads of this PackageFile.


        :param downloads: The downloads of this PackageFile.
        :type: int
        """

        self._downloads = downloads

    @property
    def filename(self):
        """Gets the filename of this PackageFile.


        :return: The filename of this PackageFile.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this PackageFile.


        :param filename: The filename of this PackageFile.
        :type: str
        """
        if (self._configuration.client_side_validation and
                filename is not None and len(filename) < 1):
            raise ValueError("Invalid value for `filename`, length must be greater than or equal to `1`")  # noqa: E501

        self._filename = filename

    @property
    def is_downloadable(self):
        """Gets the is_downloadable of this PackageFile.


        :return: The is_downloadable of this PackageFile.
        :rtype: bool
        """
        return self._is_downloadable

    @is_downloadable.setter
    def is_downloadable(self, is_downloadable):
        """Sets the is_downloadable of this PackageFile.


        :param is_downloadable: The is_downloadable of this PackageFile.
        :type: bool
        """

        self._is_downloadable = is_downloadable

    @property
    def is_primary(self):
        """Gets the is_primary of this PackageFile.


        :return: The is_primary of this PackageFile.
        :rtype: bool
        """
        return self._is_primary

    @is_primary.setter
    def is_primary(self, is_primary):
        """Sets the is_primary of this PackageFile.


        :param is_primary: The is_primary of this PackageFile.
        :type: bool
        """

        self._is_primary = is_primary

    @property
    def is_synchronised(self):
        """Gets the is_synchronised of this PackageFile.


        :return: The is_synchronised of this PackageFile.
        :rtype: bool
        """
        return self._is_synchronised

    @is_synchronised.setter
    def is_synchronised(self, is_synchronised):
        """Sets the is_synchronised of this PackageFile.


        :param is_synchronised: The is_synchronised of this PackageFile.
        :type: bool
        """

        self._is_synchronised = is_synchronised

    @property
    def signature_url(self):
        """Gets the signature_url of this PackageFile.


        :return: The signature_url of this PackageFile.
        :rtype: str
        """
        return self._signature_url

    @signature_url.setter
    def signature_url(self, signature_url):
        """Sets the signature_url of this PackageFile.


        :param signature_url: The signature_url of this PackageFile.
        :type: str
        """

        self._signature_url = signature_url

    @property
    def size(self):
        """Gets the size of this PackageFile.

        The calculated size of the file.

        :return: The size of this PackageFile.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this PackageFile.

        The calculated size of the file.

        :param size: The size of this PackageFile.
        :type: int
        """

        self._size = size

    @property
    def slug_perm(self):
        """Gets the slug_perm of this PackageFile.


        :return: The slug_perm of this PackageFile.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this PackageFile.


        :param slug_perm: The slug_perm of this PackageFile.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def tag(self):
        """Gets the tag of this PackageFile.

        Freeform descriptor that describes what the file is.

        :return: The tag of this PackageFile.
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this PackageFile.

        Freeform descriptor that describes what the file is.

        :param tag: The tag of this PackageFile.
        :type: str
        """

        self._tag = tag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PackageFile, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageFile):
            return True

        return self.to_dict() != other.to_dict()

