# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class PackageFileUploadRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'filename': 'str',
        'md5_checksum': 'str',
        'method': 'str',
        'sha256_checksum': 'str'
    }

    attribute_map = {
        'filename': 'filename',
        'md5_checksum': 'md5_checksum',
        'method': 'method',
        'sha256_checksum': 'sha256_checksum'
    }

    def __init__(self, filename=None, md5_checksum=None, method='post', sha256_checksum=None, _configuration=None):  # noqa: E501
        """PackageFileUploadRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._filename = None
        self._md5_checksum = None
        self._method = None
        self._sha256_checksum = None
        self.discriminator = None

        self.filename = filename
        if md5_checksum is not None:
            self.md5_checksum = md5_checksum
        if method is not None:
            self.method = method
        if sha256_checksum is not None:
            self.sha256_checksum = sha256_checksum

    @property
    def filename(self):
        """Gets the filename of this PackageFileUploadRequest.

        Filename for the package file upload.

        :return: The filename of this PackageFileUploadRequest.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this PackageFileUploadRequest.

        Filename for the package file upload.

        :param filename: The filename of this PackageFileUploadRequest.
        :type: str
        """
        if self._configuration.client_side_validation and filename is None:
            raise ValueError("Invalid value for `filename`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                filename is not None and len(filename) < 1):
            raise ValueError("Invalid value for `filename`, length must be greater than or equal to `1`")  # noqa: E501

        self._filename = filename

    @property
    def md5_checksum(self):
        """Gets the md5_checksum of this PackageFileUploadRequest.

        MD5 checksum for a POST-based package file upload.

        :return: The md5_checksum of this PackageFileUploadRequest.
        :rtype: str
        """
        return self._md5_checksum

    @md5_checksum.setter
    def md5_checksum(self, md5_checksum):
        """Sets the md5_checksum of this PackageFileUploadRequest.

        MD5 checksum for a POST-based package file upload.

        :param md5_checksum: The md5_checksum of this PackageFileUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                md5_checksum is not None and len(md5_checksum) > 32):
            raise ValueError("Invalid value for `md5_checksum`, length must be less than or equal to `32`")  # noqa: E501
        if (self._configuration.client_side_validation and
                md5_checksum is not None and len(md5_checksum) < 32):
            raise ValueError("Invalid value for `md5_checksum`, length must be greater than or equal to `32`")  # noqa: E501

        self._md5_checksum = md5_checksum

    @property
    def method(self):
        """Gets the method of this PackageFileUploadRequest.

        The method to use for package file upload.

        :return: The method of this PackageFileUploadRequest.
        :rtype: str
        """
        return self._method

    @method.setter
    def method(self, method):
        """Sets the method of this PackageFileUploadRequest.

        The method to use for package file upload.

        :param method: The method of this PackageFileUploadRequest.
        :type: str
        """
        allowed_values = ["put_parts", "put", "post", "presigned", "unsigned_put"]  # noqa: E501
        if (self._configuration.client_side_validation and
                method not in allowed_values):
            raise ValueError(
                "Invalid value for `method` ({0}), must be one of {1}"  # noqa: E501
                .format(method, allowed_values)
            )

        self._method = method

    @property
    def sha256_checksum(self):
        """Gets the sha256_checksum of this PackageFileUploadRequest.

        SHA256 checksum for a PUT-based package file upload.

        :return: The sha256_checksum of this PackageFileUploadRequest.
        :rtype: str
        """
        return self._sha256_checksum

    @sha256_checksum.setter
    def sha256_checksum(self, sha256_checksum):
        """Sets the sha256_checksum of this PackageFileUploadRequest.

        SHA256 checksum for a PUT-based package file upload.

        :param sha256_checksum: The sha256_checksum of this PackageFileUploadRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                sha256_checksum is not None and len(sha256_checksum) > 64):
            raise ValueError("Invalid value for `sha256_checksum`, length must be less than or equal to `64`")  # noqa: E501
        if (self._configuration.client_side_validation and
                sha256_checksum is not None and len(sha256_checksum) < 64):
            raise ValueError("Invalid value for `sha256_checksum`, length must be greater than or equal to `64`")  # noqa: E501

        self._sha256_checksum = sha256_checksum

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PackageFileUploadRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageFileUploadRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageFileUploadRequest):
            return True

        return self.to_dict() != other.to_dict()

