# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class PackageLicensePolicyEvaluationRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_at': 'datetime',
        'evaluation_count': 'int',
        'policy': 'NestedLicensePolicy',
        'slug_perm': 'str',
        'status': 'str',
        'updated_at': 'datetime',
        'violation_count': 'int'
    }

    attribute_map = {
        'created_at': 'created_at',
        'evaluation_count': 'evaluation_count',
        'policy': 'policy',
        'slug_perm': 'slug_perm',
        'status': 'status',
        'updated_at': 'updated_at',
        'violation_count': 'violation_count'
    }

    def __init__(self, created_at=None, evaluation_count=None, policy=None, slug_perm=None, status='Pending', updated_at=None, violation_count=None, _configuration=None):  # noqa: E501
        """PackageLicensePolicyEvaluationRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._created_at = None
        self._evaluation_count = None
        self._policy = None
        self._slug_perm = None
        self._status = None
        self._updated_at = None
        self._violation_count = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if evaluation_count is not None:
            self.evaluation_count = evaluation_count
        if policy is not None:
            self.policy = policy
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if status is not None:
            self.status = status
        if updated_at is not None:
            self.updated_at = updated_at
        if violation_count is not None:
            self.violation_count = violation_count

    @property
    def created_at(self):
        """Gets the created_at of this PackageLicensePolicyEvaluationRequest.


        :return: The created_at of this PackageLicensePolicyEvaluationRequest.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this PackageLicensePolicyEvaluationRequest.


        :param created_at: The created_at of this PackageLicensePolicyEvaluationRequest.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def evaluation_count(self):
        """Gets the evaluation_count of this PackageLicensePolicyEvaluationRequest.


        :return: The evaluation_count of this PackageLicensePolicyEvaluationRequest.
        :rtype: int
        """
        return self._evaluation_count

    @evaluation_count.setter
    def evaluation_count(self, evaluation_count):
        """Sets the evaluation_count of this PackageLicensePolicyEvaluationRequest.


        :param evaluation_count: The evaluation_count of this PackageLicensePolicyEvaluationRequest.
        :type: int
        """

        self._evaluation_count = evaluation_count

    @property
    def policy(self):
        """Gets the policy of this PackageLicensePolicyEvaluationRequest.


        :return: The policy of this PackageLicensePolicyEvaluationRequest.
        :rtype: NestedLicensePolicy
        """
        return self._policy

    @policy.setter
    def policy(self, policy):
        """Sets the policy of this PackageLicensePolicyEvaluationRequest.


        :param policy: The policy of this PackageLicensePolicyEvaluationRequest.
        :type: NestedLicensePolicy
        """

        self._policy = policy

    @property
    def slug_perm(self):
        """Gets the slug_perm of this PackageLicensePolicyEvaluationRequest.


        :return: The slug_perm of this PackageLicensePolicyEvaluationRequest.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this PackageLicensePolicyEvaluationRequest.


        :param slug_perm: The slug_perm of this PackageLicensePolicyEvaluationRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def status(self):
        """Gets the status of this PackageLicensePolicyEvaluationRequest.


        :return: The status of this PackageLicensePolicyEvaluationRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this PackageLicensePolicyEvaluationRequest.


        :param status: The status of this PackageLicensePolicyEvaluationRequest.
        :type: str
        """
        allowed_values = ["Pending", "In Progress", "Complete", "Cancelled", "Errored"]  # noqa: E501
        if (self._configuration.client_side_validation and
                status not in allowed_values):
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def updated_at(self):
        """Gets the updated_at of this PackageLicensePolicyEvaluationRequest.


        :return: The updated_at of this PackageLicensePolicyEvaluationRequest.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this PackageLicensePolicyEvaluationRequest.


        :param updated_at: The updated_at of this PackageLicensePolicyEvaluationRequest.
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def violation_count(self):
        """Gets the violation_count of this PackageLicensePolicyEvaluationRequest.


        :return: The violation_count of this PackageLicensePolicyEvaluationRequest.
        :rtype: int
        """
        return self._violation_count

    @violation_count.setter
    def violation_count(self, violation_count):
        """Sets the violation_count of this PackageLicensePolicyEvaluationRequest.


        :param violation_count: The violation_count of this PackageLicensePolicyEvaluationRequest.
        :type: int
        """

        self._violation_count = violation_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PackageLicensePolicyEvaluationRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PackageLicensePolicyEvaluationRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PackageLicensePolicyEvaluationRequest):
            return True

        return self.to_dict() != other.to_dict()

