# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class ProviderSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'claims': 'object',
        'enabled': 'bool',
        'name': 'str',
        'provider_url': 'str',
        'service_accounts': 'list[str]',
        'slug': 'str',
        'slug_perm': 'str'
    }

    attribute_map = {
        'claims': 'claims',
        'enabled': 'enabled',
        'name': 'name',
        'provider_url': 'provider_url',
        'service_accounts': 'service_accounts',
        'slug': 'slug',
        'slug_perm': 'slug_perm'
    }

    def __init__(self, claims=None, enabled=None, name=None, provider_url=None, service_accounts=None, slug=None, slug_perm=None, _configuration=None):  # noqa: E501
        """ProviderSettings - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._claims = None
        self._enabled = None
        self._name = None
        self._provider_url = None
        self._service_accounts = None
        self._slug = None
        self._slug_perm = None
        self.discriminator = None

        self.claims = claims
        self.enabled = enabled
        self.name = name
        self.provider_url = provider_url
        self.service_accounts = service_accounts
        if slug is not None:
            self.slug = slug
        if slug_perm is not None:
            self.slug_perm = slug_perm

    @property
    def claims(self):
        """Gets the claims of this ProviderSettings.

        The set of claims that any received tokens from the provider must contain to authenticate as the configured service account.

        :return: The claims of this ProviderSettings.
        :rtype: object
        """
        return self._claims

    @claims.setter
    def claims(self, claims):
        """Sets the claims of this ProviderSettings.

        The set of claims that any received tokens from the provider must contain to authenticate as the configured service account.

        :param claims: The claims of this ProviderSettings.
        :type: object
        """
        if self._configuration.client_side_validation and claims is None:
            raise ValueError("Invalid value for `claims`, must not be `None`")  # noqa: E501

        self._claims = claims

    @property
    def enabled(self):
        """Gets the enabled of this ProviderSettings.

        Whether the provider settings should be used for incoming OIDC requests.

        :return: The enabled of this ProviderSettings.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this ProviderSettings.

        Whether the provider settings should be used for incoming OIDC requests.

        :param enabled: The enabled of this ProviderSettings.
        :type: bool
        """
        if self._configuration.client_side_validation and enabled is None:
            raise ValueError("Invalid value for `enabled`, must not be `None`")  # noqa: E501

        self._enabled = enabled

    @property
    def name(self):
        """Gets the name of this ProviderSettings.

        The name of the provider settings are being configured for

        :return: The name of this ProviderSettings.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProviderSettings.

        The name of the provider settings are being configured for

        :param name: The name of this ProviderSettings.
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def provider_url(self):
        """Gets the provider_url of this ProviderSettings.

        The URL from the provider that serves as the base for the OpenID configuration. For example, if the OpenID configuration is available at https://token.actions.githubusercontent.com/.well-known/openid-configuration, the provider URL would be https://token.actions.githubusercontent.com/

        :return: The provider_url of this ProviderSettings.
        :rtype: str
        """
        return self._provider_url

    @provider_url.setter
    def provider_url(self, provider_url):
        """Sets the provider_url of this ProviderSettings.

        The URL from the provider that serves as the base for the OpenID configuration. For example, if the OpenID configuration is available at https://token.actions.githubusercontent.com/.well-known/openid-configuration, the provider URL would be https://token.actions.githubusercontent.com/

        :param provider_url: The provider_url of this ProviderSettings.
        :type: str
        """
        if self._configuration.client_side_validation and provider_url is None:
            raise ValueError("Invalid value for `provider_url`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                provider_url is not None and len(provider_url) < 1):
            raise ValueError("Invalid value for `provider_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._provider_url = provider_url

    @property
    def service_accounts(self):
        """Gets the service_accounts of this ProviderSettings.

        The service accounts associated with these provider settings

        :return: The service_accounts of this ProviderSettings.
        :rtype: list[str]
        """
        return self._service_accounts

    @service_accounts.setter
    def service_accounts(self, service_accounts):
        """Sets the service_accounts of this ProviderSettings.

        The service accounts associated with these provider settings

        :param service_accounts: The service_accounts of this ProviderSettings.
        :type: list[str]
        """
        if self._configuration.client_side_validation and service_accounts is None:
            raise ValueError("Invalid value for `service_accounts`, must not be `None`")  # noqa: E501

        self._service_accounts = service_accounts

    @property
    def slug(self):
        """Gets the slug of this ProviderSettings.

        The slug of the provider settings

        :return: The slug of this ProviderSettings.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this ProviderSettings.

        The slug of the provider settings

        :param slug: The slug of this ProviderSettings.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug is not None and len(slug) < 1):
            raise ValueError("Invalid value for `slug`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug is not None and not re.search('^[-a-zA-Z0-9_]+$', slug)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug = slug

    @property
    def slug_perm(self):
        """Gets the slug_perm of this ProviderSettings.

        The unique, immutable identifier of the provider settings.

        :return: The slug_perm of this ProviderSettings.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this ProviderSettings.

        The unique, immutable identifier of the provider settings.

        :param slug_perm: The slug_perm of this ProviderSettings.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ProviderSettings, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProviderSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProviderSettings):
            return True

        return self.to_dict() != other.to_dict()

