# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RateCheck(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'interval': 'float',
        'limit': 'int',
        'remaining': 'int',
        'reset': 'int',
        'reset_iso_8601': 'str',
        'throttled': 'bool'
    }

    attribute_map = {
        'interval': 'interval',
        'limit': 'limit',
        'remaining': 'remaining',
        'reset': 'reset',
        'reset_iso_8601': 'reset_iso_8601',
        'throttled': 'throttled'
    }

    def __init__(self, interval=None, limit=None, remaining=None, reset=None, reset_iso_8601=None, throttled=None, _configuration=None):  # noqa: E501
        """RateCheck - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._interval = None
        self._limit = None
        self._remaining = None
        self._reset = None
        self._reset_iso_8601 = None
        self._throttled = None
        self.discriminator = None

        if interval is not None:
            self.interval = interval
        if limit is not None:
            self.limit = limit
        if remaining is not None:
            self.remaining = remaining
        if reset is not None:
            self.reset = reset
        if reset_iso_8601 is not None:
            self.reset_iso_8601 = reset_iso_8601
        if throttled is not None:
            self.throttled = throttled

    @property
    def interval(self):
        """Gets the interval of this RateCheck.

        The time in seconds that you are suggested to wait until the next request in order to avoid consuming too much within the rate limit window.

        :return: The interval of this RateCheck.
        :rtype: float
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this RateCheck.

        The time in seconds that you are suggested to wait until the next request in order to avoid consuming too much within the rate limit window.

        :param interval: The interval of this RateCheck.
        :type: float
        """

        self._interval = interval

    @property
    def limit(self):
        """Gets the limit of this RateCheck.

        The maximum number of requests that you are permitted to send per hour

        :return: The limit of this RateCheck.
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this RateCheck.

        The maximum number of requests that you are permitted to send per hour

        :param limit: The limit of this RateCheck.
        :type: int
        """

        self._limit = limit

    @property
    def remaining(self):
        """Gets the remaining of this RateCheck.

        The number of requests that are remaining in the current rate limit window

        :return: The remaining of this RateCheck.
        :rtype: int
        """
        return self._remaining

    @remaining.setter
    def remaining(self, remaining):
        """Sets the remaining of this RateCheck.

        The number of requests that are remaining in the current rate limit window

        :param remaining: The remaining of this RateCheck.
        :type: int
        """

        self._remaining = remaining

    @property
    def reset(self):
        """Gets the reset of this RateCheck.

        The UTC epoch timestamp at which the current rate limit window will reset

        :return: The reset of this RateCheck.
        :rtype: int
        """
        return self._reset

    @reset.setter
    def reset(self, reset):
        """Sets the reset of this RateCheck.

        The UTC epoch timestamp at which the current rate limit window will reset

        :param reset: The reset of this RateCheck.
        :type: int
        """

        self._reset = reset

    @property
    def reset_iso_8601(self):
        """Gets the reset_iso_8601 of this RateCheck.

        The ISO 8601 datetime at which the current rate limit window will reset

        :return: The reset_iso_8601 of this RateCheck.
        :rtype: str
        """
        return self._reset_iso_8601

    @reset_iso_8601.setter
    def reset_iso_8601(self, reset_iso_8601):
        """Sets the reset_iso_8601 of this RateCheck.

        The ISO 8601 datetime at which the current rate limit window will reset

        :param reset_iso_8601: The reset_iso_8601 of this RateCheck.
        :type: str
        """
        if (self._configuration.client_side_validation and
                reset_iso_8601 is not None and len(reset_iso_8601) < 1):
            raise ValueError("Invalid value for `reset_iso_8601`, length must be greater than or equal to `1`")  # noqa: E501

        self._reset_iso_8601 = reset_iso_8601

    @property
    def throttled(self):
        """Gets the throttled of this RateCheck.

        If true, throttling is currently being enforced.

        :return: The throttled of this RateCheck.
        :rtype: bool
        """
        return self._throttled

    @throttled.setter
    def throttled(self, throttled):
        """Sets the throttled of this RateCheck.

        If true, throttling is currently being enforced.

        :param throttled: The throttled of this RateCheck.
        :type: bool
        """

        self._throttled = throttled

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RateCheck, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RateCheck):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RateCheck):
            return True

        return self.to_dict() != other.to_dict()

