# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RawPackageUpload(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'architectures': 'list[Architecture]',
        'cdn_url': 'str',
        'checksum_md5': 'str',
        'checksum_sha1': 'str',
        'checksum_sha256': 'str',
        'checksum_sha512': 'str',
        'dependencies_checksum_md5': 'str',
        'dependencies_url': 'str',
        'description': 'str',
        'display_name': 'str',
        'distro': 'Distribution',
        'distro_version': 'DistributionVersion',
        'downloads': 'int',
        'epoch': 'int',
        'extension': 'str',
        'filename': 'str',
        'files': 'list[PackageFile]',
        'format': 'str',
        'format_url': 'str',
        'freeable_storage': 'int',
        'fully_qualified_name': 'str',
        'identifier_perm': 'str',
        'identifiers': 'dict(str, str)',
        'indexed': 'bool',
        'is_cancellable': 'bool',
        'is_copyable': 'bool',
        'is_deleteable': 'bool',
        'is_downloadable': 'bool',
        'is_moveable': 'bool',
        'is_quarantinable': 'bool',
        'is_quarantined': 'bool',
        'is_resyncable': 'bool',
        'is_security_scannable': 'bool',
        'is_sync_awaiting': 'bool',
        'is_sync_completed': 'bool',
        'is_sync_failed': 'bool',
        'is_sync_in_flight': 'bool',
        'is_sync_in_progress': 'bool',
        'license': 'str',
        'name': 'str',
        'namespace': 'str',
        'namespace_url': 'str',
        'num_files': 'int',
        'origin_repository': 'str',
        'origin_repository_url': 'str',
        'package_type': 'int',
        'policy_violated': 'bool',
        'release': 'str',
        'repository': 'str',
        'repository_url': 'str',
        'security_scan_completed_at': 'datetime',
        'security_scan_started_at': 'datetime',
        'security_scan_status': 'str',
        'security_scan_status_updated_at': 'datetime',
        'self_html_url': 'str',
        'self_url': 'str',
        'signature_url': 'str',
        'size': 'int',
        'slug': 'str',
        'slug_perm': 'str',
        'stage': 'int',
        'stage_str': 'str',
        'stage_updated_at': 'datetime',
        'status': 'int',
        'status_reason': 'str',
        'status_str': 'str',
        'status_updated_at': 'datetime',
        'status_url': 'str',
        'subtype': 'str',
        'summary': 'str',
        'sync_finished_at': 'datetime',
        'sync_progress': 'int',
        'tags_immutable': 'Tags',
        'type_display': 'str',
        'uploaded_at': 'datetime',
        'uploader': 'str',
        'uploader_url': 'str',
        'version': 'str',
        'version_orig': 'str',
        'vulnerability_scan_results_url': 'str'
    }

    attribute_map = {
        'architectures': 'architectures',
        'cdn_url': 'cdn_url',
        'checksum_md5': 'checksum_md5',
        'checksum_sha1': 'checksum_sha1',
        'checksum_sha256': 'checksum_sha256',
        'checksum_sha512': 'checksum_sha512',
        'dependencies_checksum_md5': 'dependencies_checksum_md5',
        'dependencies_url': 'dependencies_url',
        'description': 'description',
        'display_name': 'display_name',
        'distro': 'distro',
        'distro_version': 'distro_version',
        'downloads': 'downloads',
        'epoch': 'epoch',
        'extension': 'extension',
        'filename': 'filename',
        'files': 'files',
        'format': 'format',
        'format_url': 'format_url',
        'freeable_storage': 'freeable_storage',
        'fully_qualified_name': 'fully_qualified_name',
        'identifier_perm': 'identifier_perm',
        'identifiers': 'identifiers',
        'indexed': 'indexed',
        'is_cancellable': 'is_cancellable',
        'is_copyable': 'is_copyable',
        'is_deleteable': 'is_deleteable',
        'is_downloadable': 'is_downloadable',
        'is_moveable': 'is_moveable',
        'is_quarantinable': 'is_quarantinable',
        'is_quarantined': 'is_quarantined',
        'is_resyncable': 'is_resyncable',
        'is_security_scannable': 'is_security_scannable',
        'is_sync_awaiting': 'is_sync_awaiting',
        'is_sync_completed': 'is_sync_completed',
        'is_sync_failed': 'is_sync_failed',
        'is_sync_in_flight': 'is_sync_in_flight',
        'is_sync_in_progress': 'is_sync_in_progress',
        'license': 'license',
        'name': 'name',
        'namespace': 'namespace',
        'namespace_url': 'namespace_url',
        'num_files': 'num_files',
        'origin_repository': 'origin_repository',
        'origin_repository_url': 'origin_repository_url',
        'package_type': 'package_type',
        'policy_violated': 'policy_violated',
        'release': 'release',
        'repository': 'repository',
        'repository_url': 'repository_url',
        'security_scan_completed_at': 'security_scan_completed_at',
        'security_scan_started_at': 'security_scan_started_at',
        'security_scan_status': 'security_scan_status',
        'security_scan_status_updated_at': 'security_scan_status_updated_at',
        'self_html_url': 'self_html_url',
        'self_url': 'self_url',
        'signature_url': 'signature_url',
        'size': 'size',
        'slug': 'slug',
        'slug_perm': 'slug_perm',
        'stage': 'stage',
        'stage_str': 'stage_str',
        'stage_updated_at': 'stage_updated_at',
        'status': 'status',
        'status_reason': 'status_reason',
        'status_str': 'status_str',
        'status_updated_at': 'status_updated_at',
        'status_url': 'status_url',
        'subtype': 'subtype',
        'summary': 'summary',
        'sync_finished_at': 'sync_finished_at',
        'sync_progress': 'sync_progress',
        'tags_immutable': 'tags_immutable',
        'type_display': 'type_display',
        'uploaded_at': 'uploaded_at',
        'uploader': 'uploader',
        'uploader_url': 'uploader_url',
        'version': 'version',
        'version_orig': 'version_orig',
        'vulnerability_scan_results_url': 'vulnerability_scan_results_url'
    }

    def __init__(self, architectures=None, cdn_url=None, checksum_md5=None, checksum_sha1=None, checksum_sha256=None, checksum_sha512=None, dependencies_checksum_md5=None, dependencies_url=None, description=None, display_name=None, distro=None, distro_version=None, downloads=None, epoch=None, extension=None, filename=None, files=None, format=None, format_url=None, freeable_storage=None, fully_qualified_name=None, identifier_perm=None, identifiers=None, indexed=None, is_cancellable=None, is_copyable=None, is_deleteable=None, is_downloadable=None, is_moveable=None, is_quarantinable=None, is_quarantined=None, is_resyncable=None, is_security_scannable=None, is_sync_awaiting=None, is_sync_completed=None, is_sync_failed=None, is_sync_in_flight=None, is_sync_in_progress=None, license=None, name=None, namespace=None, namespace_url=None, num_files=None, origin_repository=None, origin_repository_url=None, package_type=None, policy_violated=None, release=None, repository=None, repository_url=None, security_scan_completed_at=None, security_scan_started_at=None, security_scan_status='Awaiting Security Scan', security_scan_status_updated_at=None, self_html_url=None, self_url=None, signature_url=None, size=None, slug=None, slug_perm=None, stage=None, stage_str=None, stage_updated_at=None, status=None, status_reason=None, status_str=None, status_updated_at=None, status_url=None, subtype=None, summary=None, sync_finished_at=None, sync_progress=None, tags_immutable=None, type_display=None, uploaded_at=None, uploader=None, uploader_url=None, version=None, version_orig=None, vulnerability_scan_results_url=None, _configuration=None):  # noqa: E501
        """RawPackageUpload - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._architectures = None
        self._cdn_url = None
        self._checksum_md5 = None
        self._checksum_sha1 = None
        self._checksum_sha256 = None
        self._checksum_sha512 = None
        self._dependencies_checksum_md5 = None
        self._dependencies_url = None
        self._description = None
        self._display_name = None
        self._distro = None
        self._distro_version = None
        self._downloads = None
        self._epoch = None
        self._extension = None
        self._filename = None
        self._files = None
        self._format = None
        self._format_url = None
        self._freeable_storage = None
        self._fully_qualified_name = None
        self._identifier_perm = None
        self._identifiers = None
        self._indexed = None
        self._is_cancellable = None
        self._is_copyable = None
        self._is_deleteable = None
        self._is_downloadable = None
        self._is_moveable = None
        self._is_quarantinable = None
        self._is_quarantined = None
        self._is_resyncable = None
        self._is_security_scannable = None
        self._is_sync_awaiting = None
        self._is_sync_completed = None
        self._is_sync_failed = None
        self._is_sync_in_flight = None
        self._is_sync_in_progress = None
        self._license = None
        self._name = None
        self._namespace = None
        self._namespace_url = None
        self._num_files = None
        self._origin_repository = None
        self._origin_repository_url = None
        self._package_type = None
        self._policy_violated = None
        self._release = None
        self._repository = None
        self._repository_url = None
        self._security_scan_completed_at = None
        self._security_scan_started_at = None
        self._security_scan_status = None
        self._security_scan_status_updated_at = None
        self._self_html_url = None
        self._self_url = None
        self._signature_url = None
        self._size = None
        self._slug = None
        self._slug_perm = None
        self._stage = None
        self._stage_str = None
        self._stage_updated_at = None
        self._status = None
        self._status_reason = None
        self._status_str = None
        self._status_updated_at = None
        self._status_url = None
        self._subtype = None
        self._summary = None
        self._sync_finished_at = None
        self._sync_progress = None
        self._tags_immutable = None
        self._type_display = None
        self._uploaded_at = None
        self._uploader = None
        self._uploader_url = None
        self._version = None
        self._version_orig = None
        self._vulnerability_scan_results_url = None
        self.discriminator = None

        if architectures is not None:
            self.architectures = architectures
        if cdn_url is not None:
            self.cdn_url = cdn_url
        if checksum_md5 is not None:
            self.checksum_md5 = checksum_md5
        if checksum_sha1 is not None:
            self.checksum_sha1 = checksum_sha1
        if checksum_sha256 is not None:
            self.checksum_sha256 = checksum_sha256
        if checksum_sha512 is not None:
            self.checksum_sha512 = checksum_sha512
        if dependencies_checksum_md5 is not None:
            self.dependencies_checksum_md5 = dependencies_checksum_md5
        if dependencies_url is not None:
            self.dependencies_url = dependencies_url
        if description is not None:
            self.description = description
        if display_name is not None:
            self.display_name = display_name
        if distro is not None:
            self.distro = distro
        if distro_version is not None:
            self.distro_version = distro_version
        if downloads is not None:
            self.downloads = downloads
        if epoch is not None:
            self.epoch = epoch
        if extension is not None:
            self.extension = extension
        if filename is not None:
            self.filename = filename
        if files is not None:
            self.files = files
        if format is not None:
            self.format = format
        if format_url is not None:
            self.format_url = format_url
        if freeable_storage is not None:
            self.freeable_storage = freeable_storage
        if fully_qualified_name is not None:
            self.fully_qualified_name = fully_qualified_name
        if identifier_perm is not None:
            self.identifier_perm = identifier_perm
        if identifiers is not None:
            self.identifiers = identifiers
        if indexed is not None:
            self.indexed = indexed
        if is_cancellable is not None:
            self.is_cancellable = is_cancellable
        if is_copyable is not None:
            self.is_copyable = is_copyable
        if is_deleteable is not None:
            self.is_deleteable = is_deleteable
        if is_downloadable is not None:
            self.is_downloadable = is_downloadable
        if is_moveable is not None:
            self.is_moveable = is_moveable
        if is_quarantinable is not None:
            self.is_quarantinable = is_quarantinable
        if is_quarantined is not None:
            self.is_quarantined = is_quarantined
        if is_resyncable is not None:
            self.is_resyncable = is_resyncable
        if is_security_scannable is not None:
            self.is_security_scannable = is_security_scannable
        if is_sync_awaiting is not None:
            self.is_sync_awaiting = is_sync_awaiting
        if is_sync_completed is not None:
            self.is_sync_completed = is_sync_completed
        if is_sync_failed is not None:
            self.is_sync_failed = is_sync_failed
        if is_sync_in_flight is not None:
            self.is_sync_in_flight = is_sync_in_flight
        if is_sync_in_progress is not None:
            self.is_sync_in_progress = is_sync_in_progress
        if license is not None:
            self.license = license
        if name is not None:
            self.name = name
        if namespace is not None:
            self.namespace = namespace
        if namespace_url is not None:
            self.namespace_url = namespace_url
        if num_files is not None:
            self.num_files = num_files
        if origin_repository is not None:
            self.origin_repository = origin_repository
        if origin_repository_url is not None:
            self.origin_repository_url = origin_repository_url
        if package_type is not None:
            self.package_type = package_type
        if policy_violated is not None:
            self.policy_violated = policy_violated
        if release is not None:
            self.release = release
        if repository is not None:
            self.repository = repository
        if repository_url is not None:
            self.repository_url = repository_url
        if security_scan_completed_at is not None:
            self.security_scan_completed_at = security_scan_completed_at
        if security_scan_started_at is not None:
            self.security_scan_started_at = security_scan_started_at
        if security_scan_status is not None:
            self.security_scan_status = security_scan_status
        if security_scan_status_updated_at is not None:
            self.security_scan_status_updated_at = security_scan_status_updated_at
        if self_html_url is not None:
            self.self_html_url = self_html_url
        if self_url is not None:
            self.self_url = self_url
        if signature_url is not None:
            self.signature_url = signature_url
        if size is not None:
            self.size = size
        if slug is not None:
            self.slug = slug
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if stage is not None:
            self.stage = stage
        if stage_str is not None:
            self.stage_str = stage_str
        if stage_updated_at is not None:
            self.stage_updated_at = stage_updated_at
        if status is not None:
            self.status = status
        if status_reason is not None:
            self.status_reason = status_reason
        if status_str is not None:
            self.status_str = status_str
        if status_updated_at is not None:
            self.status_updated_at = status_updated_at
        if status_url is not None:
            self.status_url = status_url
        if subtype is not None:
            self.subtype = subtype
        if summary is not None:
            self.summary = summary
        if sync_finished_at is not None:
            self.sync_finished_at = sync_finished_at
        if sync_progress is not None:
            self.sync_progress = sync_progress
        if tags_immutable is not None:
            self.tags_immutable = tags_immutable
        if type_display is not None:
            self.type_display = type_display
        if uploaded_at is not None:
            self.uploaded_at = uploaded_at
        if uploader is not None:
            self.uploader = uploader
        if uploader_url is not None:
            self.uploader_url = uploader_url
        if version is not None:
            self.version = version
        if version_orig is not None:
            self.version_orig = version_orig
        if vulnerability_scan_results_url is not None:
            self.vulnerability_scan_results_url = vulnerability_scan_results_url

    @property
    def architectures(self):
        """Gets the architectures of this RawPackageUpload.


        :return: The architectures of this RawPackageUpload.
        :rtype: list[Architecture]
        """
        return self._architectures

    @architectures.setter
    def architectures(self, architectures):
        """Sets the architectures of this RawPackageUpload.


        :param architectures: The architectures of this RawPackageUpload.
        :type: list[Architecture]
        """

        self._architectures = architectures

    @property
    def cdn_url(self):
        """Gets the cdn_url of this RawPackageUpload.


        :return: The cdn_url of this RawPackageUpload.
        :rtype: str
        """
        return self._cdn_url

    @cdn_url.setter
    def cdn_url(self, cdn_url):
        """Sets the cdn_url of this RawPackageUpload.


        :param cdn_url: The cdn_url of this RawPackageUpload.
        :type: str
        """

        self._cdn_url = cdn_url

    @property
    def checksum_md5(self):
        """Gets the checksum_md5 of this RawPackageUpload.


        :return: The checksum_md5 of this RawPackageUpload.
        :rtype: str
        """
        return self._checksum_md5

    @checksum_md5.setter
    def checksum_md5(self, checksum_md5):
        """Sets the checksum_md5 of this RawPackageUpload.


        :param checksum_md5: The checksum_md5 of this RawPackageUpload.
        :type: str
        """

        self._checksum_md5 = checksum_md5

    @property
    def checksum_sha1(self):
        """Gets the checksum_sha1 of this RawPackageUpload.


        :return: The checksum_sha1 of this RawPackageUpload.
        :rtype: str
        """
        return self._checksum_sha1

    @checksum_sha1.setter
    def checksum_sha1(self, checksum_sha1):
        """Sets the checksum_sha1 of this RawPackageUpload.


        :param checksum_sha1: The checksum_sha1 of this RawPackageUpload.
        :type: str
        """

        self._checksum_sha1 = checksum_sha1

    @property
    def checksum_sha256(self):
        """Gets the checksum_sha256 of this RawPackageUpload.


        :return: The checksum_sha256 of this RawPackageUpload.
        :rtype: str
        """
        return self._checksum_sha256

    @checksum_sha256.setter
    def checksum_sha256(self, checksum_sha256):
        """Sets the checksum_sha256 of this RawPackageUpload.


        :param checksum_sha256: The checksum_sha256 of this RawPackageUpload.
        :type: str
        """

        self._checksum_sha256 = checksum_sha256

    @property
    def checksum_sha512(self):
        """Gets the checksum_sha512 of this RawPackageUpload.


        :return: The checksum_sha512 of this RawPackageUpload.
        :rtype: str
        """
        return self._checksum_sha512

    @checksum_sha512.setter
    def checksum_sha512(self, checksum_sha512):
        """Sets the checksum_sha512 of this RawPackageUpload.


        :param checksum_sha512: The checksum_sha512 of this RawPackageUpload.
        :type: str
        """

        self._checksum_sha512 = checksum_sha512

    @property
    def dependencies_checksum_md5(self):
        """Gets the dependencies_checksum_md5 of this RawPackageUpload.

        A checksum of all of the package's dependencies.

        :return: The dependencies_checksum_md5 of this RawPackageUpload.
        :rtype: str
        """
        return self._dependencies_checksum_md5

    @dependencies_checksum_md5.setter
    def dependencies_checksum_md5(self, dependencies_checksum_md5):
        """Sets the dependencies_checksum_md5 of this RawPackageUpload.

        A checksum of all of the package's dependencies.

        :param dependencies_checksum_md5: The dependencies_checksum_md5 of this RawPackageUpload.
        :type: str
        """

        self._dependencies_checksum_md5 = dependencies_checksum_md5

    @property
    def dependencies_url(self):
        """Gets the dependencies_url of this RawPackageUpload.


        :return: The dependencies_url of this RawPackageUpload.
        :rtype: str
        """
        return self._dependencies_url

    @dependencies_url.setter
    def dependencies_url(self, dependencies_url):
        """Sets the dependencies_url of this RawPackageUpload.


        :param dependencies_url: The dependencies_url of this RawPackageUpload.
        :type: str
        """

        self._dependencies_url = dependencies_url

    @property
    def description(self):
        """Gets the description of this RawPackageUpload.

        A textual description of this package.

        :return: The description of this RawPackageUpload.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this RawPackageUpload.

        A textual description of this package.

        :param description: The description of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                description is not None and len(description) > 12288):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `12288`")  # noqa: E501

        self._description = description

    @property
    def display_name(self):
        """Gets the display_name of this RawPackageUpload.


        :return: The display_name of this RawPackageUpload.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this RawPackageUpload.


        :param display_name: The display_name of this RawPackageUpload.
        :type: str
        """

        self._display_name = display_name

    @property
    def distro(self):
        """Gets the distro of this RawPackageUpload.


        :return: The distro of this RawPackageUpload.
        :rtype: Distribution
        """
        return self._distro

    @distro.setter
    def distro(self, distro):
        """Sets the distro of this RawPackageUpload.


        :param distro: The distro of this RawPackageUpload.
        :type: Distribution
        """

        self._distro = distro

    @property
    def distro_version(self):
        """Gets the distro_version of this RawPackageUpload.


        :return: The distro_version of this RawPackageUpload.
        :rtype: DistributionVersion
        """
        return self._distro_version

    @distro_version.setter
    def distro_version(self, distro_version):
        """Sets the distro_version of this RawPackageUpload.


        :param distro_version: The distro_version of this RawPackageUpload.
        :type: DistributionVersion
        """

        self._distro_version = distro_version

    @property
    def downloads(self):
        """Gets the downloads of this RawPackageUpload.


        :return: The downloads of this RawPackageUpload.
        :rtype: int
        """
        return self._downloads

    @downloads.setter
    def downloads(self, downloads):
        """Sets the downloads of this RawPackageUpload.


        :param downloads: The downloads of this RawPackageUpload.
        :type: int
        """

        self._downloads = downloads

    @property
    def epoch(self):
        """Gets the epoch of this RawPackageUpload.

        The epoch of the package version (if any).

        :return: The epoch of this RawPackageUpload.
        :rtype: int
        """
        return self._epoch

    @epoch.setter
    def epoch(self, epoch):
        """Sets the epoch of this RawPackageUpload.

        The epoch of the package version (if any).

        :param epoch: The epoch of this RawPackageUpload.
        :type: int
        """

        self._epoch = epoch

    @property
    def extension(self):
        """Gets the extension of this RawPackageUpload.


        :return: The extension of this RawPackageUpload.
        :rtype: str
        """
        return self._extension

    @extension.setter
    def extension(self, extension):
        """Sets the extension of this RawPackageUpload.


        :param extension: The extension of this RawPackageUpload.
        :type: str
        """

        self._extension = extension

    @property
    def filename(self):
        """Gets the filename of this RawPackageUpload.


        :return: The filename of this RawPackageUpload.
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this RawPackageUpload.


        :param filename: The filename of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                filename is not None and len(filename) < 1):
            raise ValueError("Invalid value for `filename`, length must be greater than or equal to `1`")  # noqa: E501

        self._filename = filename

    @property
    def files(self):
        """Gets the files of this RawPackageUpload.


        :return: The files of this RawPackageUpload.
        :rtype: list[PackageFile]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this RawPackageUpload.


        :param files: The files of this RawPackageUpload.
        :type: list[PackageFile]
        """

        self._files = files

    @property
    def format(self):
        """Gets the format of this RawPackageUpload.


        :return: The format of this RawPackageUpload.
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this RawPackageUpload.


        :param format: The format of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                format is not None and len(format) < 1):
            raise ValueError("Invalid value for `format`, length must be greater than or equal to `1`")  # noqa: E501

        self._format = format

    @property
    def format_url(self):
        """Gets the format_url of this RawPackageUpload.


        :return: The format_url of this RawPackageUpload.
        :rtype: str
        """
        return self._format_url

    @format_url.setter
    def format_url(self, format_url):
        """Sets the format_url of this RawPackageUpload.


        :param format_url: The format_url of this RawPackageUpload.
        :type: str
        """

        self._format_url = format_url

    @property
    def freeable_storage(self):
        """Gets the freeable_storage of this RawPackageUpload.

        Amount of storage that will be freed if this package is deleted

        :return: The freeable_storage of this RawPackageUpload.
        :rtype: int
        """
        return self._freeable_storage

    @freeable_storage.setter
    def freeable_storage(self, freeable_storage):
        """Sets the freeable_storage of this RawPackageUpload.

        Amount of storage that will be freed if this package is deleted

        :param freeable_storage: The freeable_storage of this RawPackageUpload.
        :type: int
        """

        self._freeable_storage = freeable_storage

    @property
    def fully_qualified_name(self):
        """Gets the fully_qualified_name of this RawPackageUpload.


        :return: The fully_qualified_name of this RawPackageUpload.
        :rtype: str
        """
        return self._fully_qualified_name

    @fully_qualified_name.setter
    def fully_qualified_name(self, fully_qualified_name):
        """Sets the fully_qualified_name of this RawPackageUpload.


        :param fully_qualified_name: The fully_qualified_name of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                fully_qualified_name is not None and len(fully_qualified_name) < 1):
            raise ValueError("Invalid value for `fully_qualified_name`, length must be greater than or equal to `1`")  # noqa: E501

        self._fully_qualified_name = fully_qualified_name

    @property
    def identifier_perm(self):
        """Gets the identifier_perm of this RawPackageUpload.

        Unique and permanent identifier for the package.

        :return: The identifier_perm of this RawPackageUpload.
        :rtype: str
        """
        return self._identifier_perm

    @identifier_perm.setter
    def identifier_perm(self, identifier_perm):
        """Sets the identifier_perm of this RawPackageUpload.

        Unique and permanent identifier for the package.

        :param identifier_perm: The identifier_perm of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                identifier_perm is not None and len(identifier_perm) < 1):
            raise ValueError("Invalid value for `identifier_perm`, length must be greater than or equal to `1`")  # noqa: E501

        self._identifier_perm = identifier_perm

    @property
    def identifiers(self):
        """Gets the identifiers of this RawPackageUpload.

        Return a map of identifier field names and their values.

        :return: The identifiers of this RawPackageUpload.
        :rtype: dict(str, str)
        """
        return self._identifiers

    @identifiers.setter
    def identifiers(self, identifiers):
        """Sets the identifiers of this RawPackageUpload.

        Return a map of identifier field names and their values.

        :param identifiers: The identifiers of this RawPackageUpload.
        :type: dict(str, str)
        """

        self._identifiers = identifiers

    @property
    def indexed(self):
        """Gets the indexed of this RawPackageUpload.


        :return: The indexed of this RawPackageUpload.
        :rtype: bool
        """
        return self._indexed

    @indexed.setter
    def indexed(self, indexed):
        """Sets the indexed of this RawPackageUpload.


        :param indexed: The indexed of this RawPackageUpload.
        :type: bool
        """

        self._indexed = indexed

    @property
    def is_cancellable(self):
        """Gets the is_cancellable of this RawPackageUpload.


        :return: The is_cancellable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_cancellable

    @is_cancellable.setter
    def is_cancellable(self, is_cancellable):
        """Sets the is_cancellable of this RawPackageUpload.


        :param is_cancellable: The is_cancellable of this RawPackageUpload.
        :type: bool
        """

        self._is_cancellable = is_cancellable

    @property
    def is_copyable(self):
        """Gets the is_copyable of this RawPackageUpload.


        :return: The is_copyable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_copyable

    @is_copyable.setter
    def is_copyable(self, is_copyable):
        """Sets the is_copyable of this RawPackageUpload.


        :param is_copyable: The is_copyable of this RawPackageUpload.
        :type: bool
        """

        self._is_copyable = is_copyable

    @property
    def is_deleteable(self):
        """Gets the is_deleteable of this RawPackageUpload.


        :return: The is_deleteable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_deleteable

    @is_deleteable.setter
    def is_deleteable(self, is_deleteable):
        """Sets the is_deleteable of this RawPackageUpload.


        :param is_deleteable: The is_deleteable of this RawPackageUpload.
        :type: bool
        """

        self._is_deleteable = is_deleteable

    @property
    def is_downloadable(self):
        """Gets the is_downloadable of this RawPackageUpload.


        :return: The is_downloadable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_downloadable

    @is_downloadable.setter
    def is_downloadable(self, is_downloadable):
        """Sets the is_downloadable of this RawPackageUpload.


        :param is_downloadable: The is_downloadable of this RawPackageUpload.
        :type: bool
        """

        self._is_downloadable = is_downloadable

    @property
    def is_moveable(self):
        """Gets the is_moveable of this RawPackageUpload.


        :return: The is_moveable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_moveable

    @is_moveable.setter
    def is_moveable(self, is_moveable):
        """Sets the is_moveable of this RawPackageUpload.


        :param is_moveable: The is_moveable of this RawPackageUpload.
        :type: bool
        """

        self._is_moveable = is_moveable

    @property
    def is_quarantinable(self):
        """Gets the is_quarantinable of this RawPackageUpload.


        :return: The is_quarantinable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_quarantinable

    @is_quarantinable.setter
    def is_quarantinable(self, is_quarantinable):
        """Sets the is_quarantinable of this RawPackageUpload.


        :param is_quarantinable: The is_quarantinable of this RawPackageUpload.
        :type: bool
        """

        self._is_quarantinable = is_quarantinable

    @property
    def is_quarantined(self):
        """Gets the is_quarantined of this RawPackageUpload.


        :return: The is_quarantined of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_quarantined

    @is_quarantined.setter
    def is_quarantined(self, is_quarantined):
        """Sets the is_quarantined of this RawPackageUpload.


        :param is_quarantined: The is_quarantined of this RawPackageUpload.
        :type: bool
        """

        self._is_quarantined = is_quarantined

    @property
    def is_resyncable(self):
        """Gets the is_resyncable of this RawPackageUpload.


        :return: The is_resyncable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_resyncable

    @is_resyncable.setter
    def is_resyncable(self, is_resyncable):
        """Sets the is_resyncable of this RawPackageUpload.


        :param is_resyncable: The is_resyncable of this RawPackageUpload.
        :type: bool
        """

        self._is_resyncable = is_resyncable

    @property
    def is_security_scannable(self):
        """Gets the is_security_scannable of this RawPackageUpload.


        :return: The is_security_scannable of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_security_scannable

    @is_security_scannable.setter
    def is_security_scannable(self, is_security_scannable):
        """Sets the is_security_scannable of this RawPackageUpload.


        :param is_security_scannable: The is_security_scannable of this RawPackageUpload.
        :type: bool
        """

        self._is_security_scannable = is_security_scannable

    @property
    def is_sync_awaiting(self):
        """Gets the is_sync_awaiting of this RawPackageUpload.


        :return: The is_sync_awaiting of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_sync_awaiting

    @is_sync_awaiting.setter
    def is_sync_awaiting(self, is_sync_awaiting):
        """Sets the is_sync_awaiting of this RawPackageUpload.


        :param is_sync_awaiting: The is_sync_awaiting of this RawPackageUpload.
        :type: bool
        """

        self._is_sync_awaiting = is_sync_awaiting

    @property
    def is_sync_completed(self):
        """Gets the is_sync_completed of this RawPackageUpload.


        :return: The is_sync_completed of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_sync_completed

    @is_sync_completed.setter
    def is_sync_completed(self, is_sync_completed):
        """Sets the is_sync_completed of this RawPackageUpload.


        :param is_sync_completed: The is_sync_completed of this RawPackageUpload.
        :type: bool
        """

        self._is_sync_completed = is_sync_completed

    @property
    def is_sync_failed(self):
        """Gets the is_sync_failed of this RawPackageUpload.


        :return: The is_sync_failed of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_sync_failed

    @is_sync_failed.setter
    def is_sync_failed(self, is_sync_failed):
        """Sets the is_sync_failed of this RawPackageUpload.


        :param is_sync_failed: The is_sync_failed of this RawPackageUpload.
        :type: bool
        """

        self._is_sync_failed = is_sync_failed

    @property
    def is_sync_in_flight(self):
        """Gets the is_sync_in_flight of this RawPackageUpload.


        :return: The is_sync_in_flight of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_sync_in_flight

    @is_sync_in_flight.setter
    def is_sync_in_flight(self, is_sync_in_flight):
        """Sets the is_sync_in_flight of this RawPackageUpload.


        :param is_sync_in_flight: The is_sync_in_flight of this RawPackageUpload.
        :type: bool
        """

        self._is_sync_in_flight = is_sync_in_flight

    @property
    def is_sync_in_progress(self):
        """Gets the is_sync_in_progress of this RawPackageUpload.


        :return: The is_sync_in_progress of this RawPackageUpload.
        :rtype: bool
        """
        return self._is_sync_in_progress

    @is_sync_in_progress.setter
    def is_sync_in_progress(self, is_sync_in_progress):
        """Sets the is_sync_in_progress of this RawPackageUpload.


        :param is_sync_in_progress: The is_sync_in_progress of this RawPackageUpload.
        :type: bool
        """

        self._is_sync_in_progress = is_sync_in_progress

    @property
    def license(self):
        """Gets the license of this RawPackageUpload.

        The license of this package.

        :return: The license of this RawPackageUpload.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """Sets the license of this RawPackageUpload.

        The license of this package.

        :param license: The license of this RawPackageUpload.
        :type: str
        """

        self._license = license

    @property
    def name(self):
        """Gets the name of this RawPackageUpload.

        The name of this package.

        :return: The name of this RawPackageUpload.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RawPackageUpload.

        The name of this package.

        :param name: The name of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 200):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `200`")  # noqa: E501

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this RawPackageUpload.


        :return: The namespace of this RawPackageUpload.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this RawPackageUpload.


        :param namespace: The namespace of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                namespace is not None and len(namespace) < 1):
            raise ValueError("Invalid value for `namespace`, length must be greater than or equal to `1`")  # noqa: E501

        self._namespace = namespace

    @property
    def namespace_url(self):
        """Gets the namespace_url of this RawPackageUpload.


        :return: The namespace_url of this RawPackageUpload.
        :rtype: str
        """
        return self._namespace_url

    @namespace_url.setter
    def namespace_url(self, namespace_url):
        """Sets the namespace_url of this RawPackageUpload.


        :param namespace_url: The namespace_url of this RawPackageUpload.
        :type: str
        """

        self._namespace_url = namespace_url

    @property
    def num_files(self):
        """Gets the num_files of this RawPackageUpload.


        :return: The num_files of this RawPackageUpload.
        :rtype: int
        """
        return self._num_files

    @num_files.setter
    def num_files(self, num_files):
        """Sets the num_files of this RawPackageUpload.


        :param num_files: The num_files of this RawPackageUpload.
        :type: int
        """

        self._num_files = num_files

    @property
    def origin_repository(self):
        """Gets the origin_repository of this RawPackageUpload.


        :return: The origin_repository of this RawPackageUpload.
        :rtype: str
        """
        return self._origin_repository

    @origin_repository.setter
    def origin_repository(self, origin_repository):
        """Sets the origin_repository of this RawPackageUpload.


        :param origin_repository: The origin_repository of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                origin_repository is not None and len(origin_repository) < 1):
            raise ValueError("Invalid value for `origin_repository`, length must be greater than or equal to `1`")  # noqa: E501

        self._origin_repository = origin_repository

    @property
    def origin_repository_url(self):
        """Gets the origin_repository_url of this RawPackageUpload.


        :return: The origin_repository_url of this RawPackageUpload.
        :rtype: str
        """
        return self._origin_repository_url

    @origin_repository_url.setter
    def origin_repository_url(self, origin_repository_url):
        """Sets the origin_repository_url of this RawPackageUpload.


        :param origin_repository_url: The origin_repository_url of this RawPackageUpload.
        :type: str
        """

        self._origin_repository_url = origin_repository_url

    @property
    def package_type(self):
        """Gets the package_type of this RawPackageUpload.

        The type of package contents.

        :return: The package_type of this RawPackageUpload.
        :rtype: int
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """Sets the package_type of this RawPackageUpload.

        The type of package contents.

        :param package_type: The package_type of this RawPackageUpload.
        :type: int
        """

        self._package_type = package_type

    @property
    def policy_violated(self):
        """Gets the policy_violated of this RawPackageUpload.

        Whether or not the package has violated any policy.

        :return: The policy_violated of this RawPackageUpload.
        :rtype: bool
        """
        return self._policy_violated

    @policy_violated.setter
    def policy_violated(self, policy_violated):
        """Sets the policy_violated of this RawPackageUpload.

        Whether or not the package has violated any policy.

        :param policy_violated: The policy_violated of this RawPackageUpload.
        :type: bool
        """

        self._policy_violated = policy_violated

    @property
    def release(self):
        """Gets the release of this RawPackageUpload.

        The release of the package version (if any).

        :return: The release of this RawPackageUpload.
        :rtype: str
        """
        return self._release

    @release.setter
    def release(self, release):
        """Sets the release of this RawPackageUpload.

        The release of the package version (if any).

        :param release: The release of this RawPackageUpload.
        :type: str
        """

        self._release = release

    @property
    def repository(self):
        """Gets the repository of this RawPackageUpload.


        :return: The repository of this RawPackageUpload.
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this RawPackageUpload.


        :param repository: The repository of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                repository is not None and len(repository) < 1):
            raise ValueError("Invalid value for `repository`, length must be greater than or equal to `1`")  # noqa: E501

        self._repository = repository

    @property
    def repository_url(self):
        """Gets the repository_url of this RawPackageUpload.


        :return: The repository_url of this RawPackageUpload.
        :rtype: str
        """
        return self._repository_url

    @repository_url.setter
    def repository_url(self, repository_url):
        """Sets the repository_url of this RawPackageUpload.


        :param repository_url: The repository_url of this RawPackageUpload.
        :type: str
        """

        self._repository_url = repository_url

    @property
    def security_scan_completed_at(self):
        """Gets the security_scan_completed_at of this RawPackageUpload.

        The datetime the security scanning was completed.

        :return: The security_scan_completed_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._security_scan_completed_at

    @security_scan_completed_at.setter
    def security_scan_completed_at(self, security_scan_completed_at):
        """Sets the security_scan_completed_at of this RawPackageUpload.

        The datetime the security scanning was completed.

        :param security_scan_completed_at: The security_scan_completed_at of this RawPackageUpload.
        :type: datetime
        """

        self._security_scan_completed_at = security_scan_completed_at

    @property
    def security_scan_started_at(self):
        """Gets the security_scan_started_at of this RawPackageUpload.

        The datetime the security scanning was started.

        :return: The security_scan_started_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._security_scan_started_at

    @security_scan_started_at.setter
    def security_scan_started_at(self, security_scan_started_at):
        """Sets the security_scan_started_at of this RawPackageUpload.

        The datetime the security scanning was started.

        :param security_scan_started_at: The security_scan_started_at of this RawPackageUpload.
        :type: datetime
        """

        self._security_scan_started_at = security_scan_started_at

    @property
    def security_scan_status(self):
        """Gets the security_scan_status of this RawPackageUpload.


        :return: The security_scan_status of this RawPackageUpload.
        :rtype: str
        """
        return self._security_scan_status

    @security_scan_status.setter
    def security_scan_status(self, security_scan_status):
        """Sets the security_scan_status of this RawPackageUpload.


        :param security_scan_status: The security_scan_status of this RawPackageUpload.
        :type: str
        """
        allowed_values = ["Awaiting Security Scan", "Security Scanning in Progress", "Scan Detected Vulnerabilities", "Scan Detected No Vulnerabilities", "Security Scanning Disabled", "Security Scanning Failed", "Security Scanning Skipped", "Security Scanning Not Supported"]  # noqa: E501
        if (self._configuration.client_side_validation and
                security_scan_status not in allowed_values):
            raise ValueError(
                "Invalid value for `security_scan_status` ({0}), must be one of {1}"  # noqa: E501
                .format(security_scan_status, allowed_values)
            )

        self._security_scan_status = security_scan_status

    @property
    def security_scan_status_updated_at(self):
        """Gets the security_scan_status_updated_at of this RawPackageUpload.

        The datetime the security scanning status was updated.

        :return: The security_scan_status_updated_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._security_scan_status_updated_at

    @security_scan_status_updated_at.setter
    def security_scan_status_updated_at(self, security_scan_status_updated_at):
        """Sets the security_scan_status_updated_at of this RawPackageUpload.

        The datetime the security scanning status was updated.

        :param security_scan_status_updated_at: The security_scan_status_updated_at of this RawPackageUpload.
        :type: datetime
        """

        self._security_scan_status_updated_at = security_scan_status_updated_at

    @property
    def self_html_url(self):
        """Gets the self_html_url of this RawPackageUpload.


        :return: The self_html_url of this RawPackageUpload.
        :rtype: str
        """
        return self._self_html_url

    @self_html_url.setter
    def self_html_url(self, self_html_url):
        """Sets the self_html_url of this RawPackageUpload.


        :param self_html_url: The self_html_url of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                self_html_url is not None and len(self_html_url) < 1):
            raise ValueError("Invalid value for `self_html_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._self_html_url = self_html_url

    @property
    def self_url(self):
        """Gets the self_url of this RawPackageUpload.


        :return: The self_url of this RawPackageUpload.
        :rtype: str
        """
        return self._self_url

    @self_url.setter
    def self_url(self, self_url):
        """Sets the self_url of this RawPackageUpload.


        :param self_url: The self_url of this RawPackageUpload.
        :type: str
        """

        self._self_url = self_url

    @property
    def signature_url(self):
        """Gets the signature_url of this RawPackageUpload.


        :return: The signature_url of this RawPackageUpload.
        :rtype: str
        """
        return self._signature_url

    @signature_url.setter
    def signature_url(self, signature_url):
        """Sets the signature_url of this RawPackageUpload.


        :param signature_url: The signature_url of this RawPackageUpload.
        :type: str
        """

        self._signature_url = signature_url

    @property
    def size(self):
        """Gets the size of this RawPackageUpload.

        The calculated size of the package.

        :return: The size of this RawPackageUpload.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this RawPackageUpload.

        The calculated size of the package.

        :param size: The size of this RawPackageUpload.
        :type: int
        """

        self._size = size

    @property
    def slug(self):
        """Gets the slug of this RawPackageUpload.

        The public unique identifier for the package.

        :return: The slug of this RawPackageUpload.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this RawPackageUpload.

        The public unique identifier for the package.

        :param slug: The slug of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug is not None and len(slug) < 1):
            raise ValueError("Invalid value for `slug`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug is not None and not re.search('^[-a-zA-Z0-9_]+$', slug)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug = slug

    @property
    def slug_perm(self):
        """Gets the slug_perm of this RawPackageUpload.


        :return: The slug_perm of this RawPackageUpload.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this RawPackageUpload.


        :param slug_perm: The slug_perm of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def stage(self):
        """Gets the stage of this RawPackageUpload.

        The synchronisation (in progress) stage of the package.

        :return: The stage of this RawPackageUpload.
        :rtype: int
        """
        return self._stage

    @stage.setter
    def stage(self, stage):
        """Sets the stage of this RawPackageUpload.

        The synchronisation (in progress) stage of the package.

        :param stage: The stage of this RawPackageUpload.
        :type: int
        """

        self._stage = stage

    @property
    def stage_str(self):
        """Gets the stage_str of this RawPackageUpload.


        :return: The stage_str of this RawPackageUpload.
        :rtype: str
        """
        return self._stage_str

    @stage_str.setter
    def stage_str(self, stage_str):
        """Sets the stage_str of this RawPackageUpload.


        :param stage_str: The stage_str of this RawPackageUpload.
        :type: str
        """

        self._stage_str = stage_str

    @property
    def stage_updated_at(self):
        """Gets the stage_updated_at of this RawPackageUpload.

        The datetime the package stage was updated at.

        :return: The stage_updated_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._stage_updated_at

    @stage_updated_at.setter
    def stage_updated_at(self, stage_updated_at):
        """Sets the stage_updated_at of this RawPackageUpload.

        The datetime the package stage was updated at.

        :param stage_updated_at: The stage_updated_at of this RawPackageUpload.
        :type: datetime
        """

        self._stage_updated_at = stage_updated_at

    @property
    def status(self):
        """Gets the status of this RawPackageUpload.

        The synchronisation status of the package.

        :return: The status of this RawPackageUpload.
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this RawPackageUpload.

        The synchronisation status of the package.

        :param status: The status of this RawPackageUpload.
        :type: int
        """

        self._status = status

    @property
    def status_reason(self):
        """Gets the status_reason of this RawPackageUpload.

        A textual description for the synchronous status reason (if any

        :return: The status_reason of this RawPackageUpload.
        :rtype: str
        """
        return self._status_reason

    @status_reason.setter
    def status_reason(self, status_reason):
        """Sets the status_reason of this RawPackageUpload.

        A textual description for the synchronous status reason (if any

        :param status_reason: The status_reason of this RawPackageUpload.
        :type: str
        """

        self._status_reason = status_reason

    @property
    def status_str(self):
        """Gets the status_str of this RawPackageUpload.


        :return: The status_str of this RawPackageUpload.
        :rtype: str
        """
        return self._status_str

    @status_str.setter
    def status_str(self, status_str):
        """Sets the status_str of this RawPackageUpload.


        :param status_str: The status_str of this RawPackageUpload.
        :type: str
        """

        self._status_str = status_str

    @property
    def status_updated_at(self):
        """Gets the status_updated_at of this RawPackageUpload.

        The datetime the package status was updated at.

        :return: The status_updated_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._status_updated_at

    @status_updated_at.setter
    def status_updated_at(self, status_updated_at):
        """Sets the status_updated_at of this RawPackageUpload.

        The datetime the package status was updated at.

        :param status_updated_at: The status_updated_at of this RawPackageUpload.
        :type: datetime
        """

        self._status_updated_at = status_updated_at

    @property
    def status_url(self):
        """Gets the status_url of this RawPackageUpload.


        :return: The status_url of this RawPackageUpload.
        :rtype: str
        """
        return self._status_url

    @status_url.setter
    def status_url(self, status_url):
        """Sets the status_url of this RawPackageUpload.


        :param status_url: The status_url of this RawPackageUpload.
        :type: str
        """

        self._status_url = status_url

    @property
    def subtype(self):
        """Gets the subtype of this RawPackageUpload.


        :return: The subtype of this RawPackageUpload.
        :rtype: str
        """
        return self._subtype

    @subtype.setter
    def subtype(self, subtype):
        """Sets the subtype of this RawPackageUpload.


        :param subtype: The subtype of this RawPackageUpload.
        :type: str
        """

        self._subtype = subtype

    @property
    def summary(self):
        """Gets the summary of this RawPackageUpload.

        A one-liner synopsis of this package.

        :return: The summary of this RawPackageUpload.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """Sets the summary of this RawPackageUpload.

        A one-liner synopsis of this package.

        :param summary: The summary of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                summary is not None and len(summary) > 255):
            raise ValueError("Invalid value for `summary`, length must be less than or equal to `255`")  # noqa: E501

        self._summary = summary

    @property
    def sync_finished_at(self):
        """Gets the sync_finished_at of this RawPackageUpload.

        The datetime the package sync was finished at.

        :return: The sync_finished_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._sync_finished_at

    @sync_finished_at.setter
    def sync_finished_at(self, sync_finished_at):
        """Sets the sync_finished_at of this RawPackageUpload.

        The datetime the package sync was finished at.

        :param sync_finished_at: The sync_finished_at of this RawPackageUpload.
        :type: datetime
        """

        self._sync_finished_at = sync_finished_at

    @property
    def sync_progress(self):
        """Gets the sync_progress of this RawPackageUpload.

        Synchronisation progress (from 0-100)

        :return: The sync_progress of this RawPackageUpload.
        :rtype: int
        """
        return self._sync_progress

    @sync_progress.setter
    def sync_progress(self, sync_progress):
        """Sets the sync_progress of this RawPackageUpload.

        Synchronisation progress (from 0-100)

        :param sync_progress: The sync_progress of this RawPackageUpload.
        :type: int
        """

        self._sync_progress = sync_progress

    @property
    def tags_immutable(self):
        """Gets the tags_immutable of this RawPackageUpload.


        :return: The tags_immutable of this RawPackageUpload.
        :rtype: Tags
        """
        return self._tags_immutable

    @tags_immutable.setter
    def tags_immutable(self, tags_immutable):
        """Sets the tags_immutable of this RawPackageUpload.


        :param tags_immutable: The tags_immutable of this RawPackageUpload.
        :type: Tags
        """

        self._tags_immutable = tags_immutable

    @property
    def type_display(self):
        """Gets the type_display of this RawPackageUpload.


        :return: The type_display of this RawPackageUpload.
        :rtype: str
        """
        return self._type_display

    @type_display.setter
    def type_display(self, type_display):
        """Sets the type_display of this RawPackageUpload.


        :param type_display: The type_display of this RawPackageUpload.
        :type: str
        """

        self._type_display = type_display

    @property
    def uploaded_at(self):
        """Gets the uploaded_at of this RawPackageUpload.

        The date this package was uploaded.

        :return: The uploaded_at of this RawPackageUpload.
        :rtype: datetime
        """
        return self._uploaded_at

    @uploaded_at.setter
    def uploaded_at(self, uploaded_at):
        """Sets the uploaded_at of this RawPackageUpload.

        The date this package was uploaded.

        :param uploaded_at: The uploaded_at of this RawPackageUpload.
        :type: datetime
        """

        self._uploaded_at = uploaded_at

    @property
    def uploader(self):
        """Gets the uploader of this RawPackageUpload.


        :return: The uploader of this RawPackageUpload.
        :rtype: str
        """
        return self._uploader

    @uploader.setter
    def uploader(self, uploader):
        """Sets the uploader of this RawPackageUpload.


        :param uploader: The uploader of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                uploader is not None and len(uploader) < 1):
            raise ValueError("Invalid value for `uploader`, length must be greater than or equal to `1`")  # noqa: E501

        self._uploader = uploader

    @property
    def uploader_url(self):
        """Gets the uploader_url of this RawPackageUpload.


        :return: The uploader_url of this RawPackageUpload.
        :rtype: str
        """
        return self._uploader_url

    @uploader_url.setter
    def uploader_url(self, uploader_url):
        """Sets the uploader_url of this RawPackageUpload.


        :param uploader_url: The uploader_url of this RawPackageUpload.
        :type: str
        """

        self._uploader_url = uploader_url

    @property
    def version(self):
        """Gets the version of this RawPackageUpload.

        The raw version for this package.

        :return: The version of this RawPackageUpload.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this RawPackageUpload.

        The raw version for this package.

        :param version: The version of this RawPackageUpload.
        :type: str
        """
        if (self._configuration.client_side_validation and
                version is not None and len(version) > 128):
            raise ValueError("Invalid value for `version`, length must be less than or equal to `128`")  # noqa: E501

        self._version = version

    @property
    def version_orig(self):
        """Gets the version_orig of this RawPackageUpload.


        :return: The version_orig of this RawPackageUpload.
        :rtype: str
        """
        return self._version_orig

    @version_orig.setter
    def version_orig(self, version_orig):
        """Sets the version_orig of this RawPackageUpload.


        :param version_orig: The version_orig of this RawPackageUpload.
        :type: str
        """

        self._version_orig = version_orig

    @property
    def vulnerability_scan_results_url(self):
        """Gets the vulnerability_scan_results_url of this RawPackageUpload.


        :return: The vulnerability_scan_results_url of this RawPackageUpload.
        :rtype: str
        """
        return self._vulnerability_scan_results_url

    @vulnerability_scan_results_url.setter
    def vulnerability_scan_results_url(self, vulnerability_scan_results_url):
        """Sets the vulnerability_scan_results_url of this RawPackageUpload.


        :param vulnerability_scan_results_url: The vulnerability_scan_results_url of this RawPackageUpload.
        :type: str
        """

        self._vulnerability_scan_results_url = vulnerability_scan_results_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RawPackageUpload, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RawPackageUpload):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RawPackageUpload):
            return True

        return self.to_dict() != other.to_dict()

