# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryCreate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cdn_url': 'str',
        'content_kind': 'str',
        'contextual_auth_realm': 'bool',
        'copy_own': 'bool',
        'copy_packages': 'str',
        'cosign_signing_enabled': 'bool',
        'created_at': 'datetime',
        'default_privilege': 'str',
        'delete_own': 'bool',
        'delete_packages': 'str',
        'deleted_at': 'datetime',
        'description': 'str',
        'distributes': 'list[str]',
        'docker_refresh_tokens_enabled': 'bool',
        'ecdsa_keys': 'list[RepositoryEcdsaKey]',
        'enforce_eula': 'bool',
        'gpg_keys': 'list[RepositoryGpgKey]',
        'index_files': 'bool',
        'is_open_source': 'bool',
        'is_private': 'bool',
        'is_public': 'bool',
        'manage_entitlements_privilege': 'str',
        'move_own': 'bool',
        'move_packages': 'str',
        'name': 'str',
        'namespace': 'str',
        'namespace_url': 'str',
        'nuget_native_signing_enabled': 'bool',
        'num_downloads': 'int',
        'num_policy_violated_packages': 'int',
        'num_quarantined_packages': 'int',
        'open_source_license': 'str',
        'open_source_project_url': 'str',
        'package_count': 'int',
        'package_group_count': 'int',
        'proxy_npmjs': 'bool',
        'proxy_pypi': 'bool',
        'raw_package_index_enabled': 'bool',
        'raw_package_index_signatures_enabled': 'bool',
        'replace_packages': 'str',
        'replace_packages_by_default': 'bool',
        'repository_type': 'int',
        'repository_type_str': 'str',
        'resync_own': 'bool',
        'resync_packages': 'str',
        'scan_own': 'bool',
        'scan_packages': 'str',
        'self_html_url': 'str',
        'self_url': 'str',
        'show_setup_all': 'bool',
        'size': 'int',
        'size_str': 'str',
        'slug': 'str',
        'slug_perm': 'str',
        'storage_region': 'str',
        'strict_npm_validation': 'bool',
        'tag_pre_releases_as_latest': 'bool',
        'use_debian_labels': 'bool',
        'use_default_cargo_upstream': 'bool',
        'use_entitlements_privilege': 'str',
        'use_noarch_packages': 'bool',
        'use_source_packages': 'bool',
        'use_vulnerability_scanning': 'bool',
        'user_entitlements_enabled': 'bool',
        'view_statistics': 'str'
    }

    attribute_map = {
        'cdn_url': 'cdn_url',
        'content_kind': 'content_kind',
        'contextual_auth_realm': 'contextual_auth_realm',
        'copy_own': 'copy_own',
        'copy_packages': 'copy_packages',
        'cosign_signing_enabled': 'cosign_signing_enabled',
        'created_at': 'created_at',
        'default_privilege': 'default_privilege',
        'delete_own': 'delete_own',
        'delete_packages': 'delete_packages',
        'deleted_at': 'deleted_at',
        'description': 'description',
        'distributes': 'distributes',
        'docker_refresh_tokens_enabled': 'docker_refresh_tokens_enabled',
        'ecdsa_keys': 'ecdsa_keys',
        'enforce_eula': 'enforce_eula',
        'gpg_keys': 'gpg_keys',
        'index_files': 'index_files',
        'is_open_source': 'is_open_source',
        'is_private': 'is_private',
        'is_public': 'is_public',
        'manage_entitlements_privilege': 'manage_entitlements_privilege',
        'move_own': 'move_own',
        'move_packages': 'move_packages',
        'name': 'name',
        'namespace': 'namespace',
        'namespace_url': 'namespace_url',
        'nuget_native_signing_enabled': 'nuget_native_signing_enabled',
        'num_downloads': 'num_downloads',
        'num_policy_violated_packages': 'num_policy_violated_packages',
        'num_quarantined_packages': 'num_quarantined_packages',
        'open_source_license': 'open_source_license',
        'open_source_project_url': 'open_source_project_url',
        'package_count': 'package_count',
        'package_group_count': 'package_group_count',
        'proxy_npmjs': 'proxy_npmjs',
        'proxy_pypi': 'proxy_pypi',
        'raw_package_index_enabled': 'raw_package_index_enabled',
        'raw_package_index_signatures_enabled': 'raw_package_index_signatures_enabled',
        'replace_packages': 'replace_packages',
        'replace_packages_by_default': 'replace_packages_by_default',
        'repository_type': 'repository_type',
        'repository_type_str': 'repository_type_str',
        'resync_own': 'resync_own',
        'resync_packages': 'resync_packages',
        'scan_own': 'scan_own',
        'scan_packages': 'scan_packages',
        'self_html_url': 'self_html_url',
        'self_url': 'self_url',
        'show_setup_all': 'show_setup_all',
        'size': 'size',
        'size_str': 'size_str',
        'slug': 'slug',
        'slug_perm': 'slug_perm',
        'storage_region': 'storage_region',
        'strict_npm_validation': 'strict_npm_validation',
        'tag_pre_releases_as_latest': 'tag_pre_releases_as_latest',
        'use_debian_labels': 'use_debian_labels',
        'use_default_cargo_upstream': 'use_default_cargo_upstream',
        'use_entitlements_privilege': 'use_entitlements_privilege',
        'use_noarch_packages': 'use_noarch_packages',
        'use_source_packages': 'use_source_packages',
        'use_vulnerability_scanning': 'use_vulnerability_scanning',
        'user_entitlements_enabled': 'user_entitlements_enabled',
        'view_statistics': 'view_statistics'
    }

    def __init__(self, cdn_url=None, content_kind='Standard', contextual_auth_realm=None, copy_own=None, copy_packages='Read', cosign_signing_enabled=None, created_at=None, default_privilege='None', delete_own=None, delete_packages='Admin', deleted_at=None, description=None, distributes=None, docker_refresh_tokens_enabled=None, ecdsa_keys=None, enforce_eula=None, gpg_keys=None, index_files=None, is_open_source=None, is_private=None, is_public=None, manage_entitlements_privilege='Admin', move_own=None, move_packages='Admin', name=None, namespace=None, namespace_url=None, nuget_native_signing_enabled=None, num_downloads=None, num_policy_violated_packages=None, num_quarantined_packages=None, open_source_license=None, open_source_project_url=None, package_count=None, package_group_count=None, proxy_npmjs=None, proxy_pypi=None, raw_package_index_enabled=None, raw_package_index_signatures_enabled=None, replace_packages='Write', replace_packages_by_default=None, repository_type=None, repository_type_str='Public', resync_own=None, resync_packages='Admin', scan_own=None, scan_packages='Read', self_html_url=None, self_url=None, show_setup_all=None, size=None, size_str=None, slug=None, slug_perm=None, storage_region='default', strict_npm_validation=None, tag_pre_releases_as_latest=None, use_debian_labels=None, use_default_cargo_upstream=None, use_entitlements_privilege='Read', use_noarch_packages=None, use_source_packages=None, use_vulnerability_scanning=None, user_entitlements_enabled=None, view_statistics='Read', _configuration=None):  # noqa: E501
        """RepositoryCreate - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._cdn_url = None
        self._content_kind = None
        self._contextual_auth_realm = None
        self._copy_own = None
        self._copy_packages = None
        self._cosign_signing_enabled = None
        self._created_at = None
        self._default_privilege = None
        self._delete_own = None
        self._delete_packages = None
        self._deleted_at = None
        self._description = None
        self._distributes = None
        self._docker_refresh_tokens_enabled = None
        self._ecdsa_keys = None
        self._enforce_eula = None
        self._gpg_keys = None
        self._index_files = None
        self._is_open_source = None
        self._is_private = None
        self._is_public = None
        self._manage_entitlements_privilege = None
        self._move_own = None
        self._move_packages = None
        self._name = None
        self._namespace = None
        self._namespace_url = None
        self._nuget_native_signing_enabled = None
        self._num_downloads = None
        self._num_policy_violated_packages = None
        self._num_quarantined_packages = None
        self._open_source_license = None
        self._open_source_project_url = None
        self._package_count = None
        self._package_group_count = None
        self._proxy_npmjs = None
        self._proxy_pypi = None
        self._raw_package_index_enabled = None
        self._raw_package_index_signatures_enabled = None
        self._replace_packages = None
        self._replace_packages_by_default = None
        self._repository_type = None
        self._repository_type_str = None
        self._resync_own = None
        self._resync_packages = None
        self._scan_own = None
        self._scan_packages = None
        self._self_html_url = None
        self._self_url = None
        self._show_setup_all = None
        self._size = None
        self._size_str = None
        self._slug = None
        self._slug_perm = None
        self._storage_region = None
        self._strict_npm_validation = None
        self._tag_pre_releases_as_latest = None
        self._use_debian_labels = None
        self._use_default_cargo_upstream = None
        self._use_entitlements_privilege = None
        self._use_noarch_packages = None
        self._use_source_packages = None
        self._use_vulnerability_scanning = None
        self._user_entitlements_enabled = None
        self._view_statistics = None
        self.discriminator = None

        if cdn_url is not None:
            self.cdn_url = cdn_url
        if content_kind is not None:
            self.content_kind = content_kind
        if contextual_auth_realm is not None:
            self.contextual_auth_realm = contextual_auth_realm
        if copy_own is not None:
            self.copy_own = copy_own
        if copy_packages is not None:
            self.copy_packages = copy_packages
        if cosign_signing_enabled is not None:
            self.cosign_signing_enabled = cosign_signing_enabled
        if created_at is not None:
            self.created_at = created_at
        if default_privilege is not None:
            self.default_privilege = default_privilege
        if delete_own is not None:
            self.delete_own = delete_own
        if delete_packages is not None:
            self.delete_packages = delete_packages
        if deleted_at is not None:
            self.deleted_at = deleted_at
        if description is not None:
            self.description = description
        if distributes is not None:
            self.distributes = distributes
        if docker_refresh_tokens_enabled is not None:
            self.docker_refresh_tokens_enabled = docker_refresh_tokens_enabled
        if ecdsa_keys is not None:
            self.ecdsa_keys = ecdsa_keys
        if enforce_eula is not None:
            self.enforce_eula = enforce_eula
        if gpg_keys is not None:
            self.gpg_keys = gpg_keys
        if index_files is not None:
            self.index_files = index_files
        if is_open_source is not None:
            self.is_open_source = is_open_source
        if is_private is not None:
            self.is_private = is_private
        if is_public is not None:
            self.is_public = is_public
        if manage_entitlements_privilege is not None:
            self.manage_entitlements_privilege = manage_entitlements_privilege
        if move_own is not None:
            self.move_own = move_own
        if move_packages is not None:
            self.move_packages = move_packages
        self.name = name
        if namespace is not None:
            self.namespace = namespace
        if namespace_url is not None:
            self.namespace_url = namespace_url
        if nuget_native_signing_enabled is not None:
            self.nuget_native_signing_enabled = nuget_native_signing_enabled
        if num_downloads is not None:
            self.num_downloads = num_downloads
        if num_policy_violated_packages is not None:
            self.num_policy_violated_packages = num_policy_violated_packages
        if num_quarantined_packages is not None:
            self.num_quarantined_packages = num_quarantined_packages
        if open_source_license is not None:
            self.open_source_license = open_source_license
        if open_source_project_url is not None:
            self.open_source_project_url = open_source_project_url
        if package_count is not None:
            self.package_count = package_count
        if package_group_count is not None:
            self.package_group_count = package_group_count
        if proxy_npmjs is not None:
            self.proxy_npmjs = proxy_npmjs
        if proxy_pypi is not None:
            self.proxy_pypi = proxy_pypi
        if raw_package_index_enabled is not None:
            self.raw_package_index_enabled = raw_package_index_enabled
        if raw_package_index_signatures_enabled is not None:
            self.raw_package_index_signatures_enabled = raw_package_index_signatures_enabled
        if replace_packages is not None:
            self.replace_packages = replace_packages
        if replace_packages_by_default is not None:
            self.replace_packages_by_default = replace_packages_by_default
        if repository_type is not None:
            self.repository_type = repository_type
        if repository_type_str is not None:
            self.repository_type_str = repository_type_str
        if resync_own is not None:
            self.resync_own = resync_own
        if resync_packages is not None:
            self.resync_packages = resync_packages
        if scan_own is not None:
            self.scan_own = scan_own
        if scan_packages is not None:
            self.scan_packages = scan_packages
        if self_html_url is not None:
            self.self_html_url = self_html_url
        if self_url is not None:
            self.self_url = self_url
        if show_setup_all is not None:
            self.show_setup_all = show_setup_all
        if size is not None:
            self.size = size
        if size_str is not None:
            self.size_str = size_str
        if slug is not None:
            self.slug = slug
        if slug_perm is not None:
            self.slug_perm = slug_perm
        if storage_region is not None:
            self.storage_region = storage_region
        if strict_npm_validation is not None:
            self.strict_npm_validation = strict_npm_validation
        if tag_pre_releases_as_latest is not None:
            self.tag_pre_releases_as_latest = tag_pre_releases_as_latest
        if use_debian_labels is not None:
            self.use_debian_labels = use_debian_labels
        if use_default_cargo_upstream is not None:
            self.use_default_cargo_upstream = use_default_cargo_upstream
        if use_entitlements_privilege is not None:
            self.use_entitlements_privilege = use_entitlements_privilege
        if use_noarch_packages is not None:
            self.use_noarch_packages = use_noarch_packages
        if use_source_packages is not None:
            self.use_source_packages = use_source_packages
        if use_vulnerability_scanning is not None:
            self.use_vulnerability_scanning = use_vulnerability_scanning
        if user_entitlements_enabled is not None:
            self.user_entitlements_enabled = user_entitlements_enabled
        if view_statistics is not None:
            self.view_statistics = view_statistics

    @property
    def cdn_url(self):
        """Gets the cdn_url of this RepositoryCreate.

        Base URL from which packages and other artifacts are downloaded.

        :return: The cdn_url of this RepositoryCreate.
        :rtype: str
        """
        return self._cdn_url

    @cdn_url.setter
    def cdn_url(self, cdn_url):
        """Sets the cdn_url of this RepositoryCreate.

        Base URL from which packages and other artifacts are downloaded.

        :param cdn_url: The cdn_url of this RepositoryCreate.
        :type: str
        """

        self._cdn_url = cdn_url

    @property
    def content_kind(self):
        """Gets the content_kind of this RepositoryCreate.

        The repository content kind determines whether this repository contains packages, or provides a distribution of packages from other repositories. You can only select the content kind at repository creation time.

        :return: The content_kind of this RepositoryCreate.
        :rtype: str
        """
        return self._content_kind

    @content_kind.setter
    def content_kind(self, content_kind):
        """Sets the content_kind of this RepositoryCreate.

        The repository content kind determines whether this repository contains packages, or provides a distribution of packages from other repositories. You can only select the content kind at repository creation time.

        :param content_kind: The content_kind of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Standard", "Distribution", "Upstream"]  # noqa: E501
        if (self._configuration.client_side_validation and
                content_kind not in allowed_values):
            raise ValueError(
                "Invalid value for `content_kind` ({0}), must be one of {1}"  # noqa: E501
                .format(content_kind, allowed_values)
            )

        self._content_kind = content_kind

    @property
    def contextual_auth_realm(self):
        """Gets the contextual_auth_realm of this RepositoryCreate.

        If checked, missing credentials for this repository where basic authentication is required shall present an enriched value in the 'WWW-Authenticate' header containing the namespace and repository. This can be useful for tooling such as SBT where the authentication realm is used to distinguish and disambiguate credentials.

        :return: The contextual_auth_realm of this RepositoryCreate.
        :rtype: bool
        """
        return self._contextual_auth_realm

    @contextual_auth_realm.setter
    def contextual_auth_realm(self, contextual_auth_realm):
        """Sets the contextual_auth_realm of this RepositoryCreate.

        If checked, missing credentials for this repository where basic authentication is required shall present an enriched value in the 'WWW-Authenticate' header containing the namespace and repository. This can be useful for tooling such as SBT where the authentication realm is used to distinguish and disambiguate credentials.

        :param contextual_auth_realm: The contextual_auth_realm of this RepositoryCreate.
        :type: bool
        """

        self._contextual_auth_realm = contextual_auth_realm

    @property
    def copy_own(self):
        """Gets the copy_own of this RepositoryCreate.

        If checked, users can copy any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :return: The copy_own of this RepositoryCreate.
        :rtype: bool
        """
        return self._copy_own

    @copy_own.setter
    def copy_own(self, copy_own):
        """Sets the copy_own of this RepositoryCreate.

        If checked, users can copy any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :param copy_own: The copy_own of this RepositoryCreate.
        :type: bool
        """

        self._copy_own = copy_own

    @property
    def copy_packages(self):
        """Gets the copy_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to copy packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific copy setting.

        :return: The copy_packages of this RepositoryCreate.
        :rtype: str
        """
        return self._copy_packages

    @copy_packages.setter
    def copy_packages(self, copy_packages):
        """Sets the copy_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to copy packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific copy setting.

        :param copy_packages: The copy_packages of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                copy_packages not in allowed_values):
            raise ValueError(
                "Invalid value for `copy_packages` ({0}), must be one of {1}"  # noqa: E501
                .format(copy_packages, allowed_values)
            )

        self._copy_packages = copy_packages

    @property
    def cosign_signing_enabled(self):
        """Gets the cosign_signing_enabled of this RepositoryCreate.

        When enabled, all pushed (or pulled from upstream) OCI packages and artifacts will be signed using cosign with the repository's ECDSA key. This generates a distinct cosign signature artifact per artifact.

        :return: The cosign_signing_enabled of this RepositoryCreate.
        :rtype: bool
        """
        return self._cosign_signing_enabled

    @cosign_signing_enabled.setter
    def cosign_signing_enabled(self, cosign_signing_enabled):
        """Sets the cosign_signing_enabled of this RepositoryCreate.

        When enabled, all pushed (or pulled from upstream) OCI packages and artifacts will be signed using cosign with the repository's ECDSA key. This generates a distinct cosign signature artifact per artifact.

        :param cosign_signing_enabled: The cosign_signing_enabled of this RepositoryCreate.
        :type: bool
        """

        self._cosign_signing_enabled = cosign_signing_enabled

    @property
    def created_at(self):
        """Gets the created_at of this RepositoryCreate.


        :return: The created_at of this RepositoryCreate.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this RepositoryCreate.


        :param created_at: The created_at of this RepositoryCreate.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def default_privilege(self):
        """Gets the default_privilege of this RepositoryCreate.

        This defines the default level of privilege that all of your organization members have for this repository. This does not include collaborators, but applies to any member of the org regardless of their own membership role (i.e. it applies to owners, managers and members). Be careful if setting this to admin, because any member will be able to change settings.

        :return: The default_privilege of this RepositoryCreate.
        :rtype: str
        """
        return self._default_privilege

    @default_privilege.setter
    def default_privilege(self, default_privilege):
        """Sets the default_privilege of this RepositoryCreate.

        This defines the default level of privilege that all of your organization members have for this repository. This does not include collaborators, but applies to any member of the org regardless of their own membership role (i.e. it applies to owners, managers and members). Be careful if setting this to admin, because any member will be able to change settings.

        :param default_privilege: The default_privilege of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read", "None"]  # noqa: E501
        if (self._configuration.client_side_validation and
                default_privilege not in allowed_values):
            raise ValueError(
                "Invalid value for `default_privilege` ({0}), must be one of {1}"  # noqa: E501
                .format(default_privilege, allowed_values)
            )

        self._default_privilege = default_privilege

    @property
    def delete_own(self):
        """Gets the delete_own of this RepositoryCreate.

        If checked, users can delete any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :return: The delete_own of this RepositoryCreate.
        :rtype: bool
        """
        return self._delete_own

    @delete_own.setter
    def delete_own(self, delete_own):
        """Sets the delete_own of this RepositoryCreate.

        If checked, users can delete any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :param delete_own: The delete_own of this RepositoryCreate.
        :type: bool
        """

        self._delete_own = delete_own

    @property
    def delete_packages(self):
        """Gets the delete_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to delete packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific delete setting.

        :return: The delete_packages of this RepositoryCreate.
        :rtype: str
        """
        return self._delete_packages

    @delete_packages.setter
    def delete_packages(self, delete_packages):
        """Sets the delete_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to delete packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific delete setting.

        :param delete_packages: The delete_packages of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write"]  # noqa: E501
        if (self._configuration.client_side_validation and
                delete_packages not in allowed_values):
            raise ValueError(
                "Invalid value for `delete_packages` ({0}), must be one of {1}"  # noqa: E501
                .format(delete_packages, allowed_values)
            )

        self._delete_packages = delete_packages

    @property
    def deleted_at(self):
        """Gets the deleted_at of this RepositoryCreate.

        The datetime the repository was manually deleted at.

        :return: The deleted_at of this RepositoryCreate.
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this RepositoryCreate.

        The datetime the repository was manually deleted at.

        :param deleted_at: The deleted_at of this RepositoryCreate.
        :type: datetime
        """

        self._deleted_at = deleted_at

    @property
    def description(self):
        """Gets the description of this RepositoryCreate.

        A description of the repository's purpose/contents.

        :return: The description of this RepositoryCreate.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this RepositoryCreate.

        A description of the repository's purpose/contents.

        :param description: The description of this RepositoryCreate.
        :type: str
        """

        self._description = description

    @property
    def distributes(self):
        """Gets the distributes of this RepositoryCreate.

        The repositories distributed through this repo. Adding repos here is only valid if the content_kind is DISTRIBUTION.

        :return: The distributes of this RepositoryCreate.
        :rtype: list[str]
        """
        return self._distributes

    @distributes.setter
    def distributes(self, distributes):
        """Sets the distributes of this RepositoryCreate.

        The repositories distributed through this repo. Adding repos here is only valid if the content_kind is DISTRIBUTION.

        :param distributes: The distributes of this RepositoryCreate.
        :type: list[str]
        """

        self._distributes = distributes

    @property
    def docker_refresh_tokens_enabled(self):
        """Gets the docker_refresh_tokens_enabled of this RepositoryCreate.

        If checked, refresh tokens will be issued in addition to access tokens for Docker authentication. This allows unlimited extension of the lifetime of access tokens.

        :return: The docker_refresh_tokens_enabled of this RepositoryCreate.
        :rtype: bool
        """
        return self._docker_refresh_tokens_enabled

    @docker_refresh_tokens_enabled.setter
    def docker_refresh_tokens_enabled(self, docker_refresh_tokens_enabled):
        """Sets the docker_refresh_tokens_enabled of this RepositoryCreate.

        If checked, refresh tokens will be issued in addition to access tokens for Docker authentication. This allows unlimited extension of the lifetime of access tokens.

        :param docker_refresh_tokens_enabled: The docker_refresh_tokens_enabled of this RepositoryCreate.
        :type: bool
        """

        self._docker_refresh_tokens_enabled = docker_refresh_tokens_enabled

    @property
    def ecdsa_keys(self):
        """Gets the ecdsa_keys of this RepositoryCreate.


        :return: The ecdsa_keys of this RepositoryCreate.
        :rtype: list[RepositoryEcdsaKey]
        """
        return self._ecdsa_keys

    @ecdsa_keys.setter
    def ecdsa_keys(self, ecdsa_keys):
        """Sets the ecdsa_keys of this RepositoryCreate.


        :param ecdsa_keys: The ecdsa_keys of this RepositoryCreate.
        :type: list[RepositoryEcdsaKey]
        """

        self._ecdsa_keys = ecdsa_keys

    @property
    def enforce_eula(self):
        """Gets the enforce_eula of this RepositoryCreate.

        If checked, downloads will explicitly require acceptance of an EULA.

        :return: The enforce_eula of this RepositoryCreate.
        :rtype: bool
        """
        return self._enforce_eula

    @enforce_eula.setter
    def enforce_eula(self, enforce_eula):
        """Sets the enforce_eula of this RepositoryCreate.

        If checked, downloads will explicitly require acceptance of an EULA.

        :param enforce_eula: The enforce_eula of this RepositoryCreate.
        :type: bool
        """

        self._enforce_eula = enforce_eula

    @property
    def gpg_keys(self):
        """Gets the gpg_keys of this RepositoryCreate.


        :return: The gpg_keys of this RepositoryCreate.
        :rtype: list[RepositoryGpgKey]
        """
        return self._gpg_keys

    @gpg_keys.setter
    def gpg_keys(self, gpg_keys):
        """Sets the gpg_keys of this RepositoryCreate.


        :param gpg_keys: The gpg_keys of this RepositoryCreate.
        :type: list[RepositoryGpgKey]
        """

        self._gpg_keys = gpg_keys

    @property
    def index_files(self):
        """Gets the index_files of this RepositoryCreate.

        If checked, files contained in packages will be indexed, which increase the synchronisation time required for packages. Note that it is recommended you keep this enabled unless the synchronisation time is significantly impacted.

        :return: The index_files of this RepositoryCreate.
        :rtype: bool
        """
        return self._index_files

    @index_files.setter
    def index_files(self, index_files):
        """Sets the index_files of this RepositoryCreate.

        If checked, files contained in packages will be indexed, which increase the synchronisation time required for packages. Note that it is recommended you keep this enabled unless the synchronisation time is significantly impacted.

        :param index_files: The index_files of this RepositoryCreate.
        :type: bool
        """

        self._index_files = index_files

    @property
    def is_open_source(self):
        """Gets the is_open_source of this RepositoryCreate.


        :return: The is_open_source of this RepositoryCreate.
        :rtype: bool
        """
        return self._is_open_source

    @is_open_source.setter
    def is_open_source(self, is_open_source):
        """Sets the is_open_source of this RepositoryCreate.


        :param is_open_source: The is_open_source of this RepositoryCreate.
        :type: bool
        """

        self._is_open_source = is_open_source

    @property
    def is_private(self):
        """Gets the is_private of this RepositoryCreate.


        :return: The is_private of this RepositoryCreate.
        :rtype: bool
        """
        return self._is_private

    @is_private.setter
    def is_private(self, is_private):
        """Sets the is_private of this RepositoryCreate.


        :param is_private: The is_private of this RepositoryCreate.
        :type: bool
        """

        self._is_private = is_private

    @property
    def is_public(self):
        """Gets the is_public of this RepositoryCreate.


        :return: The is_public of this RepositoryCreate.
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """Sets the is_public of this RepositoryCreate.


        :param is_public: The is_public of this RepositoryCreate.
        :type: bool
        """

        self._is_public = is_public

    @property
    def manage_entitlements_privilege(self):
        """Gets the manage_entitlements_privilege of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to manage entitlement tokens with private repositories. Management is the ability to create, alter, enable, disable or delete all tokens without a repository.

        :return: The manage_entitlements_privilege of this RepositoryCreate.
        :rtype: str
        """
        return self._manage_entitlements_privilege

    @manage_entitlements_privilege.setter
    def manage_entitlements_privilege(self, manage_entitlements_privilege):
        """Sets the manage_entitlements_privilege of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to manage entitlement tokens with private repositories. Management is the ability to create, alter, enable, disable or delete all tokens without a repository.

        :param manage_entitlements_privilege: The manage_entitlements_privilege of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                manage_entitlements_privilege not in allowed_values):
            raise ValueError(
                "Invalid value for `manage_entitlements_privilege` ({0}), must be one of {1}"  # noqa: E501
                .format(manage_entitlements_privilege, allowed_values)
            )

        self._manage_entitlements_privilege = manage_entitlements_privilege

    @property
    def move_own(self):
        """Gets the move_own of this RepositoryCreate.

        If checked, users can move any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :return: The move_own of this RepositoryCreate.
        :rtype: bool
        """
        return self._move_own

    @move_own.setter
    def move_own(self, move_own):
        """Sets the move_own of this RepositoryCreate.

        If checked, users can move any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :param move_own: The move_own of this RepositoryCreate.
        :type: bool
        """

        self._move_own = move_own

    @property
    def move_packages(self):
        """Gets the move_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to move packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific move setting.

        :return: The move_packages of this RepositoryCreate.
        :rtype: str
        """
        return self._move_packages

    @move_packages.setter
    def move_packages(self, move_packages):
        """Sets the move_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to move packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific move setting.

        :param move_packages: The move_packages of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                move_packages not in allowed_values):
            raise ValueError(
                "Invalid value for `move_packages` ({0}), must be one of {1}"  # noqa: E501
                .format(move_packages, allowed_values)
            )

        self._move_packages = move_packages

    @property
    def name(self):
        """Gets the name of this RepositoryCreate.

        A descriptive name for the repository.

        :return: The name of this RepositoryCreate.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this RepositoryCreate.

        A descriptive name for the repository.

        :param name: The name of this RepositoryCreate.
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 50):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `50`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and not re.search('^\\w[\\w \\-\'\\.\\/()]+$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^\\w[\\w \\-'\\.\/()]+$/`")  # noqa: E501

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this RepositoryCreate.

        Namespace to which this repository belongs.

        :return: The namespace of this RepositoryCreate.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this RepositoryCreate.

        Namespace to which this repository belongs.

        :param namespace: The namespace of this RepositoryCreate.
        :type: str
        """
        if (self._configuration.client_side_validation and
                namespace is not None and not re.search('^[-a-zA-Z0-9_]+$', namespace)):  # noqa: E501
            raise ValueError(r"Invalid value for `namespace`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._namespace = namespace

    @property
    def namespace_url(self):
        """Gets the namespace_url of this RepositoryCreate.

        API endpoint where data about this namespace can be retrieved.

        :return: The namespace_url of this RepositoryCreate.
        :rtype: str
        """
        return self._namespace_url

    @namespace_url.setter
    def namespace_url(self, namespace_url):
        """Sets the namespace_url of this RepositoryCreate.

        API endpoint where data about this namespace can be retrieved.

        :param namespace_url: The namespace_url of this RepositoryCreate.
        :type: str
        """

        self._namespace_url = namespace_url

    @property
    def nuget_native_signing_enabled(self):
        """Gets the nuget_native_signing_enabled of this RepositoryCreate.

        When enabled, all pushed (or pulled from upstream) nuget packages and artifacts will be signed using the repository's X.509 RSA certificate. Additionally, the nuget RepositorySignature index will list all of the repository's signing certificates including the ones from configured upstreams.

        :return: The nuget_native_signing_enabled of this RepositoryCreate.
        :rtype: bool
        """
        return self._nuget_native_signing_enabled

    @nuget_native_signing_enabled.setter
    def nuget_native_signing_enabled(self, nuget_native_signing_enabled):
        """Sets the nuget_native_signing_enabled of this RepositoryCreate.

        When enabled, all pushed (or pulled from upstream) nuget packages and artifacts will be signed using the repository's X.509 RSA certificate. Additionally, the nuget RepositorySignature index will list all of the repository's signing certificates including the ones from configured upstreams.

        :param nuget_native_signing_enabled: The nuget_native_signing_enabled of this RepositoryCreate.
        :type: bool
        """

        self._nuget_native_signing_enabled = nuget_native_signing_enabled

    @property
    def num_downloads(self):
        """Gets the num_downloads of this RepositoryCreate.

        The number of downloads for packages in the repository.

        :return: The num_downloads of this RepositoryCreate.
        :rtype: int
        """
        return self._num_downloads

    @num_downloads.setter
    def num_downloads(self, num_downloads):
        """Sets the num_downloads of this RepositoryCreate.

        The number of downloads for packages in the repository.

        :param num_downloads: The num_downloads of this RepositoryCreate.
        :type: int
        """

        self._num_downloads = num_downloads

    @property
    def num_policy_violated_packages(self):
        """Gets the num_policy_violated_packages of this RepositoryCreate.

        Number of packages with policy violations in a repository.

        :return: The num_policy_violated_packages of this RepositoryCreate.
        :rtype: int
        """
        return self._num_policy_violated_packages

    @num_policy_violated_packages.setter
    def num_policy_violated_packages(self, num_policy_violated_packages):
        """Sets the num_policy_violated_packages of this RepositoryCreate.

        Number of packages with policy violations in a repository.

        :param num_policy_violated_packages: The num_policy_violated_packages of this RepositoryCreate.
        :type: int
        """

        self._num_policy_violated_packages = num_policy_violated_packages

    @property
    def num_quarantined_packages(self):
        """Gets the num_quarantined_packages of this RepositoryCreate.

        Number of quarantined packages in a repository.

        :return: The num_quarantined_packages of this RepositoryCreate.
        :rtype: int
        """
        return self._num_quarantined_packages

    @num_quarantined_packages.setter
    def num_quarantined_packages(self, num_quarantined_packages):
        """Sets the num_quarantined_packages of this RepositoryCreate.

        Number of quarantined packages in a repository.

        :param num_quarantined_packages: The num_quarantined_packages of this RepositoryCreate.
        :type: int
        """

        self._num_quarantined_packages = num_quarantined_packages

    @property
    def open_source_license(self):
        """Gets the open_source_license of this RepositoryCreate.

        The SPDX identifier of the open source license.

        :return: The open_source_license of this RepositoryCreate.
        :rtype: str
        """
        return self._open_source_license

    @open_source_license.setter
    def open_source_license(self, open_source_license):
        """Sets the open_source_license of this RepositoryCreate.

        The SPDX identifier of the open source license.

        :param open_source_license: The open_source_license of this RepositoryCreate.
        :type: str
        """

        self._open_source_license = open_source_license

    @property
    def open_source_project_url(self):
        """Gets the open_source_project_url of this RepositoryCreate.

        The URL to the Open-Source project, used for validating that the project meets the requirements for Open-Source.

        :return: The open_source_project_url of this RepositoryCreate.
        :rtype: str
        """
        return self._open_source_project_url

    @open_source_project_url.setter
    def open_source_project_url(self, open_source_project_url):
        """Sets the open_source_project_url of this RepositoryCreate.

        The URL to the Open-Source project, used for validating that the project meets the requirements for Open-Source.

        :param open_source_project_url: The open_source_project_url of this RepositoryCreate.
        :type: str
        """
        if (self._configuration.client_side_validation and
                open_source_project_url is not None and len(open_source_project_url) > 200):
            raise ValueError("Invalid value for `open_source_project_url`, length must be less than or equal to `200`")  # noqa: E501

        self._open_source_project_url = open_source_project_url

    @property
    def package_count(self):
        """Gets the package_count of this RepositoryCreate.

        The number of packages in the repository.

        :return: The package_count of this RepositoryCreate.
        :rtype: int
        """
        return self._package_count

    @package_count.setter
    def package_count(self, package_count):
        """Sets the package_count of this RepositoryCreate.

        The number of packages in the repository.

        :param package_count: The package_count of this RepositoryCreate.
        :type: int
        """

        self._package_count = package_count

    @property
    def package_group_count(self):
        """Gets the package_group_count of this RepositoryCreate.

        The number of groups in the repository.

        :return: The package_group_count of this RepositoryCreate.
        :rtype: int
        """
        return self._package_group_count

    @package_group_count.setter
    def package_group_count(self, package_group_count):
        """Sets the package_group_count of this RepositoryCreate.

        The number of groups in the repository.

        :param package_group_count: The package_group_count of this RepositoryCreate.
        :type: int
        """

        self._package_group_count = package_group_count

    @property
    def proxy_npmjs(self):
        """Gets the proxy_npmjs of this RepositoryCreate.

        If checked, Npm packages that are not in the repository when requested by clients will automatically be proxied from the public npmjs.org registry. If there is at least one version for a package, others will not be proxied.

        :return: The proxy_npmjs of this RepositoryCreate.
        :rtype: bool
        """
        return self._proxy_npmjs

    @proxy_npmjs.setter
    def proxy_npmjs(self, proxy_npmjs):
        """Sets the proxy_npmjs of this RepositoryCreate.

        If checked, Npm packages that are not in the repository when requested by clients will automatically be proxied from the public npmjs.org registry. If there is at least one version for a package, others will not be proxied.

        :param proxy_npmjs: The proxy_npmjs of this RepositoryCreate.
        :type: bool
        """

        self._proxy_npmjs = proxy_npmjs

    @property
    def proxy_pypi(self):
        """Gets the proxy_pypi of this RepositoryCreate.

        If checked, Python packages that are not in the repository when requested by clients will automatically be proxied from the public pypi.python.org registry. If there is at least one version for a package, others will not be proxied.

        :return: The proxy_pypi of this RepositoryCreate.
        :rtype: bool
        """
        return self._proxy_pypi

    @proxy_pypi.setter
    def proxy_pypi(self, proxy_pypi):
        """Sets the proxy_pypi of this RepositoryCreate.

        If checked, Python packages that are not in the repository when requested by clients will automatically be proxied from the public pypi.python.org registry. If there is at least one version for a package, others will not be proxied.

        :param proxy_pypi: The proxy_pypi of this RepositoryCreate.
        :type: bool
        """

        self._proxy_pypi = proxy_pypi

    @property
    def raw_package_index_enabled(self):
        """Gets the raw_package_index_enabled of this RepositoryCreate.

        If checked, HTML and JSON indexes will be generated that list all available raw packages in the repository.

        :return: The raw_package_index_enabled of this RepositoryCreate.
        :rtype: bool
        """
        return self._raw_package_index_enabled

    @raw_package_index_enabled.setter
    def raw_package_index_enabled(self, raw_package_index_enabled):
        """Sets the raw_package_index_enabled of this RepositoryCreate.

        If checked, HTML and JSON indexes will be generated that list all available raw packages in the repository.

        :param raw_package_index_enabled: The raw_package_index_enabled of this RepositoryCreate.
        :type: bool
        """

        self._raw_package_index_enabled = raw_package_index_enabled

    @property
    def raw_package_index_signatures_enabled(self):
        """Gets the raw_package_index_signatures_enabled of this RepositoryCreate.

        If checked, the HTML and JSON indexes will display raw package GPG signatures alongside the index packages.

        :return: The raw_package_index_signatures_enabled of this RepositoryCreate.
        :rtype: bool
        """
        return self._raw_package_index_signatures_enabled

    @raw_package_index_signatures_enabled.setter
    def raw_package_index_signatures_enabled(self, raw_package_index_signatures_enabled):
        """Sets the raw_package_index_signatures_enabled of this RepositoryCreate.

        If checked, the HTML and JSON indexes will display raw package GPG signatures alongside the index packages.

        :param raw_package_index_signatures_enabled: The raw_package_index_signatures_enabled of this RepositoryCreate.
        :type: bool
        """

        self._raw_package_index_signatures_enabled = raw_package_index_signatures_enabled

    @property
    def replace_packages(self):
        """Gets the replace_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to republish packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific republish setting. Please note that the user still requires the privilege to delete packages that will be replaced by the new package; otherwise the republish will fail.

        :return: The replace_packages of this RepositoryCreate.
        :rtype: str
        """
        return self._replace_packages

    @replace_packages.setter
    def replace_packages(self, replace_packages):
        """Sets the replace_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to republish packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific republish setting. Please note that the user still requires the privilege to delete packages that will be replaced by the new package; otherwise the republish will fail.

        :param replace_packages: The replace_packages of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write"]  # noqa: E501
        if (self._configuration.client_side_validation and
                replace_packages not in allowed_values):
            raise ValueError(
                "Invalid value for `replace_packages` ({0}), must be one of {1}"  # noqa: E501
                .format(replace_packages, allowed_values)
            )

        self._replace_packages = replace_packages

    @property
    def replace_packages_by_default(self):
        """Gets the replace_packages_by_default of this RepositoryCreate.

        If checked, uploaded packages will overwrite/replace any others with the same attributes (e.g. same version) by default. This only applies if the user has the required privilege for the republishing AND has the required privilege to delete existing packages that they don't own.

        :return: The replace_packages_by_default of this RepositoryCreate.
        :rtype: bool
        """
        return self._replace_packages_by_default

    @replace_packages_by_default.setter
    def replace_packages_by_default(self, replace_packages_by_default):
        """Sets the replace_packages_by_default of this RepositoryCreate.

        If checked, uploaded packages will overwrite/replace any others with the same attributes (e.g. same version) by default. This only applies if the user has the required privilege for the republishing AND has the required privilege to delete existing packages that they don't own.

        :param replace_packages_by_default: The replace_packages_by_default of this RepositoryCreate.
        :type: bool
        """

        self._replace_packages_by_default = replace_packages_by_default

    @property
    def repository_type(self):
        """Gets the repository_type of this RepositoryCreate.

        The repository type changes how it is accessed and billed. Private repositories are visible only to you or authorized delegates. Open-Source repositories are always visible to everyone and are restricted by licensing, but are free to use and come with generous bandwidth/storage. You can only select Open-Source at repository creation time.

        :return: The repository_type of this RepositoryCreate.
        :rtype: int
        """
        return self._repository_type

    @repository_type.setter
    def repository_type(self, repository_type):
        """Sets the repository_type of this RepositoryCreate.

        The repository type changes how it is accessed and billed. Private repositories are visible only to you or authorized delegates. Open-Source repositories are always visible to everyone and are restricted by licensing, but are free to use and come with generous bandwidth/storage. You can only select Open-Source at repository creation time.

        :param repository_type: The repository_type of this RepositoryCreate.
        :type: int
        """

        self._repository_type = repository_type

    @property
    def repository_type_str(self):
        """Gets the repository_type_str of this RepositoryCreate.

        The repository type changes how it is accessed and billed. Private repositories are visible only to you or authorized delegates. Public repositories are visible to all Cloudsmith users.

        :return: The repository_type_str of this RepositoryCreate.
        :rtype: str
        """
        return self._repository_type_str

    @repository_type_str.setter
    def repository_type_str(self, repository_type_str):
        """Sets the repository_type_str of this RepositoryCreate.

        The repository type changes how it is accessed and billed. Private repositories are visible only to you or authorized delegates. Public repositories are visible to all Cloudsmith users.

        :param repository_type_str: The repository_type_str of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Public", "Private", "Open-Source"]  # noqa: E501
        if (self._configuration.client_side_validation and
                repository_type_str not in allowed_values):
            raise ValueError(
                "Invalid value for `repository_type_str` ({0}), must be one of {1}"  # noqa: E501
                .format(repository_type_str, allowed_values)
            )

        self._repository_type_str = repository_type_str

    @property
    def resync_own(self):
        """Gets the resync_own of this RepositoryCreate.

        If checked, users can resync any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :return: The resync_own of this RepositoryCreate.
        :rtype: bool
        """
        return self._resync_own

    @resync_own.setter
    def resync_own(self, resync_own):
        """Sets the resync_own of this RepositoryCreate.

        If checked, users can resync any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :param resync_own: The resync_own of this RepositoryCreate.
        :type: bool
        """

        self._resync_own = resync_own

    @property
    def resync_packages(self):
        """Gets the resync_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to resync packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific resync setting.

        :return: The resync_packages of this RepositoryCreate.
        :rtype: str
        """
        return self._resync_packages

    @resync_packages.setter
    def resync_packages(self, resync_packages):
        """Sets the resync_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to resync packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific resync setting.

        :param resync_packages: The resync_packages of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write"]  # noqa: E501
        if (self._configuration.client_side_validation and
                resync_packages not in allowed_values):
            raise ValueError(
                "Invalid value for `resync_packages` ({0}), must be one of {1}"  # noqa: E501
                .format(resync_packages, allowed_values)
            )

        self._resync_packages = resync_packages

    @property
    def scan_own(self):
        """Gets the scan_own of this RepositoryCreate.

        If checked, users can scan any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :return: The scan_own of this RepositoryCreate.
        :rtype: bool
        """
        return self._scan_own

    @scan_own.setter
    def scan_own(self, scan_own):
        """Sets the scan_own of this RepositoryCreate.

        If checked, users can scan any of their own packages that they have uploaded, assuming that they still have write privilege for the repository. This takes precedence over privileges configured in the 'Access Controls' section of the repository, and any inherited from the org.

        :param scan_own: The scan_own of this RepositoryCreate.
        :type: bool
        """

        self._scan_own = scan_own

    @property
    def scan_packages(self):
        """Gets the scan_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to scan packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific scan setting.

        :return: The scan_packages of this RepositoryCreate.
        :rtype: str
        """
        return self._scan_packages

    @scan_packages.setter
    def scan_packages(self, scan_packages):
        """Sets the scan_packages of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to scan packages. Unless the package was uploaded by that user, in which the permission may be overridden by the user-specific scan setting.

        :param scan_packages: The scan_packages of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                scan_packages not in allowed_values):
            raise ValueError(
                "Invalid value for `scan_packages` ({0}), must be one of {1}"  # noqa: E501
                .format(scan_packages, allowed_values)
            )

        self._scan_packages = scan_packages

    @property
    def self_html_url(self):
        """Gets the self_html_url of this RepositoryCreate.

        Website URL for this repository.

        :return: The self_html_url of this RepositoryCreate.
        :rtype: str
        """
        return self._self_html_url

    @self_html_url.setter
    def self_html_url(self, self_html_url):
        """Sets the self_html_url of this RepositoryCreate.

        Website URL for this repository.

        :param self_html_url: The self_html_url of this RepositoryCreate.
        :type: str
        """
        if (self._configuration.client_side_validation and
                self_html_url is not None and len(self_html_url) < 1):
            raise ValueError("Invalid value for `self_html_url`, length must be greater than or equal to `1`")  # noqa: E501

        self._self_html_url = self_html_url

    @property
    def self_url(self):
        """Gets the self_url of this RepositoryCreate.

        API endpoint where data about this repository can be retrieved.

        :return: The self_url of this RepositoryCreate.
        :rtype: str
        """
        return self._self_url

    @self_url.setter
    def self_url(self, self_url):
        """Sets the self_url of this RepositoryCreate.

        API endpoint where data about this repository can be retrieved.

        :param self_url: The self_url of this RepositoryCreate.
        :type: str
        """

        self._self_url = self_url

    @property
    def show_setup_all(self):
        """Gets the show_setup_all of this RepositoryCreate.

        If checked, the Set Me Up help for all formats will always be shown, even if you don't have packages of that type uploaded. Otherwise, help will only be shown for packages that are in the repository. For example, if you have uploaded only NuGet packages, then the Set Me Up help for NuGet packages will be shown only.

        :return: The show_setup_all of this RepositoryCreate.
        :rtype: bool
        """
        return self._show_setup_all

    @show_setup_all.setter
    def show_setup_all(self, show_setup_all):
        """Sets the show_setup_all of this RepositoryCreate.

        If checked, the Set Me Up help for all formats will always be shown, even if you don't have packages of that type uploaded. Otherwise, help will only be shown for packages that are in the repository. For example, if you have uploaded only NuGet packages, then the Set Me Up help for NuGet packages will be shown only.

        :param show_setup_all: The show_setup_all of this RepositoryCreate.
        :type: bool
        """

        self._show_setup_all = show_setup_all

    @property
    def size(self):
        """Gets the size of this RepositoryCreate.

        The calculated size of the repository.

        :return: The size of this RepositoryCreate.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this RepositoryCreate.

        The calculated size of the repository.

        :param size: The size of this RepositoryCreate.
        :type: int
        """

        self._size = size

    @property
    def size_str(self):
        """Gets the size_str of this RepositoryCreate.

        The calculated size of the repository (human readable).

        :return: The size_str of this RepositoryCreate.
        :rtype: str
        """
        return self._size_str

    @size_str.setter
    def size_str(self, size_str):
        """Sets the size_str of this RepositoryCreate.

        The calculated size of the repository (human readable).

        :param size_str: The size_str of this RepositoryCreate.
        :type: str
        """

        self._size_str = size_str

    @property
    def slug(self):
        """Gets the slug of this RepositoryCreate.

        The slug identifies the repository in URIs.

        :return: The slug of this RepositoryCreate.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """Sets the slug of this RepositoryCreate.

        The slug identifies the repository in URIs.

        :param slug: The slug of this RepositoryCreate.
        :type: str
        """

        self._slug = slug

    @property
    def slug_perm(self):
        """Gets the slug_perm of this RepositoryCreate.

        The slug_perm immutably identifies the repository. It will never change once a repository has been created.

        :return: The slug_perm of this RepositoryCreate.
        :rtype: str
        """
        return self._slug_perm

    @slug_perm.setter
    def slug_perm(self, slug_perm):
        """Sets the slug_perm of this RepositoryCreate.

        The slug_perm immutably identifies the repository. It will never change once a repository has been created.

        :param slug_perm: The slug_perm of this RepositoryCreate.
        :type: str
        """
        if (self._configuration.client_side_validation and
                slug_perm is not None and len(slug_perm) < 1):
            raise ValueError("Invalid value for `slug_perm`, length must be greater than or equal to `1`")  # noqa: E501
        if (self._configuration.client_side_validation and
                slug_perm is not None and not re.search('^[-a-zA-Z0-9_]+$', slug_perm)):  # noqa: E501
            raise ValueError(r"Invalid value for `slug_perm`, must be a follow pattern or equal to `/^[-a-zA-Z0-9_]+$/`")  # noqa: E501

        self._slug_perm = slug_perm

    @property
    def storage_region(self):
        """Gets the storage_region of this RepositoryCreate.

        The Cloudsmith region in which package files are stored.

        :return: The storage_region of this RepositoryCreate.
        :rtype: str
        """
        return self._storage_region

    @storage_region.setter
    def storage_region(self, storage_region):
        """Sets the storage_region of this RepositoryCreate.

        The Cloudsmith region in which package files are stored.

        :param storage_region: The storage_region of this RepositoryCreate.
        :type: str
        """

        self._storage_region = storage_region

    @property
    def strict_npm_validation(self):
        """Gets the strict_npm_validation of this RepositoryCreate.

        If checked, npm packages will be validated strictly to ensure the package matches specifcation. You can turn this on if you want to guarantee that the packages will work with npm-cli and other tools correctly.

        :return: The strict_npm_validation of this RepositoryCreate.
        :rtype: bool
        """
        return self._strict_npm_validation

    @strict_npm_validation.setter
    def strict_npm_validation(self, strict_npm_validation):
        """Sets the strict_npm_validation of this RepositoryCreate.

        If checked, npm packages will be validated strictly to ensure the package matches specifcation. You can turn this on if you want to guarantee that the packages will work with npm-cli and other tools correctly.

        :param strict_npm_validation: The strict_npm_validation of this RepositoryCreate.
        :type: bool
        """

        self._strict_npm_validation = strict_npm_validation

    @property
    def tag_pre_releases_as_latest(self):
        """Gets the tag_pre_releases_as_latest of this RepositoryCreate.

        If checked, packages pushed with a pre-release component on that version will be marked with the 'latest' tag. Note that if unchecked, a repository containing ONLY pre-release versions, will have no version marked latest which may cause incompatibility with native tools 

        :return: The tag_pre_releases_as_latest of this RepositoryCreate.
        :rtype: bool
        """
        return self._tag_pre_releases_as_latest

    @tag_pre_releases_as_latest.setter
    def tag_pre_releases_as_latest(self, tag_pre_releases_as_latest):
        """Sets the tag_pre_releases_as_latest of this RepositoryCreate.

        If checked, packages pushed with a pre-release component on that version will be marked with the 'latest' tag. Note that if unchecked, a repository containing ONLY pre-release versions, will have no version marked latest which may cause incompatibility with native tools 

        :param tag_pre_releases_as_latest: The tag_pre_releases_as_latest of this RepositoryCreate.
        :type: bool
        """

        self._tag_pre_releases_as_latest = tag_pre_releases_as_latest

    @property
    def use_debian_labels(self):
        """Gets the use_debian_labels of this RepositoryCreate.

        If checked, a 'Label' field will be present in Debian-based repositories. It will contain a string that identifies the entitlement token used to authenticate the repository, in the form of 'source=t-<identifier>'; or 'source=none' if no token was used. You can use this to help with pinning.

        :return: The use_debian_labels of this RepositoryCreate.
        :rtype: bool
        """
        return self._use_debian_labels

    @use_debian_labels.setter
    def use_debian_labels(self, use_debian_labels):
        """Sets the use_debian_labels of this RepositoryCreate.

        If checked, a 'Label' field will be present in Debian-based repositories. It will contain a string that identifies the entitlement token used to authenticate the repository, in the form of 'source=t-<identifier>'; or 'source=none' if no token was used. You can use this to help with pinning.

        :param use_debian_labels: The use_debian_labels of this RepositoryCreate.
        :type: bool
        """

        self._use_debian_labels = use_debian_labels

    @property
    def use_default_cargo_upstream(self):
        """Gets the use_default_cargo_upstream of this RepositoryCreate.

        If checked, dependencies of uploaded Cargo crates which do not set an explicit value for \"registry\" will be assumed to be available from crates.io. If unchecked, dependencies with unspecified \"registry\" values will be assumed to be available in the registry being uploaded to. Uncheck this if you want to ensure that dependencies are only ever installed from Cloudsmith unless explicitly specified as belong to another registry.

        :return: The use_default_cargo_upstream of this RepositoryCreate.
        :rtype: bool
        """
        return self._use_default_cargo_upstream

    @use_default_cargo_upstream.setter
    def use_default_cargo_upstream(self, use_default_cargo_upstream):
        """Sets the use_default_cargo_upstream of this RepositoryCreate.

        If checked, dependencies of uploaded Cargo crates which do not set an explicit value for \"registry\" will be assumed to be available from crates.io. If unchecked, dependencies with unspecified \"registry\" values will be assumed to be available in the registry being uploaded to. Uncheck this if you want to ensure that dependencies are only ever installed from Cloudsmith unless explicitly specified as belong to another registry.

        :param use_default_cargo_upstream: The use_default_cargo_upstream of this RepositoryCreate.
        :type: bool
        """

        self._use_default_cargo_upstream = use_default_cargo_upstream

    @property
    def use_entitlements_privilege(self):
        """Gets the use_entitlements_privilege of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to see/use entitlement tokens with private repositories. If a user does not have the permission, they will only be able to download packages using other credentials, such as email/password via basic authentication. Use this if you want to force users to only use their user-based token, which is tied to their access (if removed, they can't use it).

        :return: The use_entitlements_privilege of this RepositoryCreate.
        :rtype: str
        """
        return self._use_entitlements_privilege

    @use_entitlements_privilege.setter
    def use_entitlements_privilege(self, use_entitlements_privilege):
        """Sets the use_entitlements_privilege of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to see/use entitlement tokens with private repositories. If a user does not have the permission, they will only be able to download packages using other credentials, such as email/password via basic authentication. Use this if you want to force users to only use their user-based token, which is tied to their access (if removed, they can't use it).

        :param use_entitlements_privilege: The use_entitlements_privilege of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                use_entitlements_privilege not in allowed_values):
            raise ValueError(
                "Invalid value for `use_entitlements_privilege` ({0}), must be one of {1}"  # noqa: E501
                .format(use_entitlements_privilege, allowed_values)
            )

        self._use_entitlements_privilege = use_entitlements_privilege

    @property
    def use_noarch_packages(self):
        """Gets the use_noarch_packages of this RepositoryCreate.

        If checked, noarch packages (if supported) are enabled in installations/configurations. A noarch package is one that is not tied to specific system architecture (like i686).

        :return: The use_noarch_packages of this RepositoryCreate.
        :rtype: bool
        """
        return self._use_noarch_packages

    @use_noarch_packages.setter
    def use_noarch_packages(self, use_noarch_packages):
        """Sets the use_noarch_packages of this RepositoryCreate.

        If checked, noarch packages (if supported) are enabled in installations/configurations. A noarch package is one that is not tied to specific system architecture (like i686).

        :param use_noarch_packages: The use_noarch_packages of this RepositoryCreate.
        :type: bool
        """

        self._use_noarch_packages = use_noarch_packages

    @property
    def use_source_packages(self):
        """Gets the use_source_packages of this RepositoryCreate.

        If checked, source packages (if supported) are enabled in installations/configurations. A source package is one that contains source code rather than built binaries.

        :return: The use_source_packages of this RepositoryCreate.
        :rtype: bool
        """
        return self._use_source_packages

    @use_source_packages.setter
    def use_source_packages(self, use_source_packages):
        """Sets the use_source_packages of this RepositoryCreate.

        If checked, source packages (if supported) are enabled in installations/configurations. A source package is one that contains source code rather than built binaries.

        :param use_source_packages: The use_source_packages of this RepositoryCreate.
        :type: bool
        """

        self._use_source_packages = use_source_packages

    @property
    def use_vulnerability_scanning(self):
        """Gets the use_vulnerability_scanning of this RepositoryCreate.

        If checked, vulnerability scanning will be enabled for all supported packages within this repository.

        :return: The use_vulnerability_scanning of this RepositoryCreate.
        :rtype: bool
        """
        return self._use_vulnerability_scanning

    @use_vulnerability_scanning.setter
    def use_vulnerability_scanning(self, use_vulnerability_scanning):
        """Sets the use_vulnerability_scanning of this RepositoryCreate.

        If checked, vulnerability scanning will be enabled for all supported packages within this repository.

        :param use_vulnerability_scanning: The use_vulnerability_scanning of this RepositoryCreate.
        :type: bool
        """

        self._use_vulnerability_scanning = use_vulnerability_scanning

    @property
    def user_entitlements_enabled(self):
        """Gets the user_entitlements_enabled of this RepositoryCreate.

        If checked, users can use and manage their own user-specific entitlement token for the repository (if private). Otherwise, user-specific entitlements are disabled for all users.

        :return: The user_entitlements_enabled of this RepositoryCreate.
        :rtype: bool
        """
        return self._user_entitlements_enabled

    @user_entitlements_enabled.setter
    def user_entitlements_enabled(self, user_entitlements_enabled):
        """Sets the user_entitlements_enabled of this RepositoryCreate.

        If checked, users can use and manage their own user-specific entitlement token for the repository (if private). Otherwise, user-specific entitlements are disabled for all users.

        :param user_entitlements_enabled: The user_entitlements_enabled of this RepositoryCreate.
        :type: bool
        """

        self._user_entitlements_enabled = user_entitlements_enabled

    @property
    def view_statistics(self):
        """Gets the view_statistics of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to view repository statistics, to include entitlement-based usage, if applicable. If a user does not have the permission, they won't be able to view any statistics, either via the UI, API or CLI.

        :return: The view_statistics of this RepositoryCreate.
        :rtype: str
        """
        return self._view_statistics

    @view_statistics.setter
    def view_statistics(self, view_statistics):
        """Sets the view_statistics of this RepositoryCreate.

        This defines the minimum level of privilege required for a user to view repository statistics, to include entitlement-based usage, if applicable. If a user does not have the permission, they won't be able to view any statistics, either via the UI, API or CLI.

        :param view_statistics: The view_statistics of this RepositoryCreate.
        :type: str
        """
        allowed_values = ["Admin", "Write", "Read"]  # noqa: E501
        if (self._configuration.client_side_validation and
                view_statistics not in allowed_values):
            raise ValueError(
                "Invalid value for `view_statistics` ({0}), must be one of {1}"  # noqa: E501
                .format(view_statistics, allowed_values)
            )

        self._view_statistics = view_statistics

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryCreate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryCreate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryCreate):
            return True

        return self.to_dict() != other.to_dict()

