# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryRetentionRulesRequestPatch(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'retention_count_limit': 'int',
        'retention_days_limit': 'int',
        'retention_enabled': 'bool',
        'retention_group_by_format': 'bool',
        'retention_group_by_name': 'bool',
        'retention_group_by_package_type': 'bool',
        'retention_package_query_string': 'str',
        'retention_size_limit': 'int'
    }

    attribute_map = {
        'retention_count_limit': 'retention_count_limit',
        'retention_days_limit': 'retention_days_limit',
        'retention_enabled': 'retention_enabled',
        'retention_group_by_format': 'retention_group_by_format',
        'retention_group_by_name': 'retention_group_by_name',
        'retention_group_by_package_type': 'retention_group_by_package_type',
        'retention_package_query_string': 'retention_package_query_string',
        'retention_size_limit': 'retention_size_limit'
    }

    def __init__(self, retention_count_limit=None, retention_days_limit=None, retention_enabled=None, retention_group_by_format=None, retention_group_by_name=None, retention_group_by_package_type=None, retention_package_query_string=None, retention_size_limit=None, _configuration=None):  # noqa: E501
        """RepositoryRetentionRulesRequestPatch - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._retention_count_limit = None
        self._retention_days_limit = None
        self._retention_enabled = None
        self._retention_group_by_format = None
        self._retention_group_by_name = None
        self._retention_group_by_package_type = None
        self._retention_package_query_string = None
        self._retention_size_limit = None
        self.discriminator = None

        if retention_count_limit is not None:
            self.retention_count_limit = retention_count_limit
        if retention_days_limit is not None:
            self.retention_days_limit = retention_days_limit
        if retention_enabled is not None:
            self.retention_enabled = retention_enabled
        if retention_group_by_format is not None:
            self.retention_group_by_format = retention_group_by_format
        if retention_group_by_name is not None:
            self.retention_group_by_name = retention_group_by_name
        if retention_group_by_package_type is not None:
            self.retention_group_by_package_type = retention_group_by_package_type
        if retention_package_query_string is not None:
            self.retention_package_query_string = retention_package_query_string
        if retention_size_limit is not None:
            self.retention_size_limit = retention_size_limit

    @property
    def retention_count_limit(self):
        """Gets the retention_count_limit of this RepositoryRetentionRulesRequestPatch.

        The maximum X number of packages to retain.

        :return: The retention_count_limit of this RepositoryRetentionRulesRequestPatch.
        :rtype: int
        """
        return self._retention_count_limit

    @retention_count_limit.setter
    def retention_count_limit(self, retention_count_limit):
        """Sets the retention_count_limit of this RepositoryRetentionRulesRequestPatch.

        The maximum X number of packages to retain.

        :param retention_count_limit: The retention_count_limit of this RepositoryRetentionRulesRequestPatch.
        :type: int
        """
        if (self._configuration.client_side_validation and
                retention_count_limit is not None and retention_count_limit > 10000):  # noqa: E501
            raise ValueError("Invalid value for `retention_count_limit`, must be a value less than or equal to `10000`")  # noqa: E501
        if (self._configuration.client_side_validation and
                retention_count_limit is not None and retention_count_limit < 0):  # noqa: E501
            raise ValueError("Invalid value for `retention_count_limit`, must be a value greater than or equal to `0`")  # noqa: E501

        self._retention_count_limit = retention_count_limit

    @property
    def retention_days_limit(self):
        """Gets the retention_days_limit of this RepositoryRetentionRulesRequestPatch.

        The X number of days of packages to retain.

        :return: The retention_days_limit of this RepositoryRetentionRulesRequestPatch.
        :rtype: int
        """
        return self._retention_days_limit

    @retention_days_limit.setter
    def retention_days_limit(self, retention_days_limit):
        """Sets the retention_days_limit of this RepositoryRetentionRulesRequestPatch.

        The X number of days of packages to retain.

        :param retention_days_limit: The retention_days_limit of this RepositoryRetentionRulesRequestPatch.
        :type: int
        """
        if (self._configuration.client_side_validation and
                retention_days_limit is not None and retention_days_limit > 180):  # noqa: E501
            raise ValueError("Invalid value for `retention_days_limit`, must be a value less than or equal to `180`")  # noqa: E501
        if (self._configuration.client_side_validation and
                retention_days_limit is not None and retention_days_limit < 0):  # noqa: E501
            raise ValueError("Invalid value for `retention_days_limit`, must be a value greater than or equal to `0`")  # noqa: E501

        self._retention_days_limit = retention_days_limit

    @property
    def retention_enabled(self):
        """Gets the retention_enabled of this RepositoryRetentionRulesRequestPatch.

        If checked, the retention lifecycle rules will be activated for the repository. Any packages that don't match will be deleted automatically, and the rest are retained.

        :return: The retention_enabled of this RepositoryRetentionRulesRequestPatch.
        :rtype: bool
        """
        return self._retention_enabled

    @retention_enabled.setter
    def retention_enabled(self, retention_enabled):
        """Sets the retention_enabled of this RepositoryRetentionRulesRequestPatch.

        If checked, the retention lifecycle rules will be activated for the repository. Any packages that don't match will be deleted automatically, and the rest are retained.

        :param retention_enabled: The retention_enabled of this RepositoryRetentionRulesRequestPatch.
        :type: bool
        """

        self._retention_enabled = retention_enabled

    @property
    def retention_group_by_format(self):
        """Gets the retention_group_by_format of this RepositoryRetentionRulesRequestPatch.

        If checked, retention will apply to packages by package formats rather than across all package formats.For example, when retaining by a limit of 1 and you upload PythonPkg 1.0 and RubyPkg 1.0, no packages are deleted because they are different formats.

        :return: The retention_group_by_format of this RepositoryRetentionRulesRequestPatch.
        :rtype: bool
        """
        return self._retention_group_by_format

    @retention_group_by_format.setter
    def retention_group_by_format(self, retention_group_by_format):
        """Sets the retention_group_by_format of this RepositoryRetentionRulesRequestPatch.

        If checked, retention will apply to packages by package formats rather than across all package formats.For example, when retaining by a limit of 1 and you upload PythonPkg 1.0 and RubyPkg 1.0, no packages are deleted because they are different formats.

        :param retention_group_by_format: The retention_group_by_format of this RepositoryRetentionRulesRequestPatch.
        :type: bool
        """

        self._retention_group_by_format = retention_group_by_format

    @property
    def retention_group_by_name(self):
        """Gets the retention_group_by_name of this RepositoryRetentionRulesRequestPatch.

        If checked, retention will apply to groups of packages by name rather than all packages.<br>For example, when retaining by a limit of 1 and you upload PkgA 1.0, PkgB 1.0 and PkgB 1.1; only PkgB 1.0 is deleted because there are two (2) PkgBs and one (1) PkgA.

        :return: The retention_group_by_name of this RepositoryRetentionRulesRequestPatch.
        :rtype: bool
        """
        return self._retention_group_by_name

    @retention_group_by_name.setter
    def retention_group_by_name(self, retention_group_by_name):
        """Sets the retention_group_by_name of this RepositoryRetentionRulesRequestPatch.

        If checked, retention will apply to groups of packages by name rather than all packages.<br>For example, when retaining by a limit of 1 and you upload PkgA 1.0, PkgB 1.0 and PkgB 1.1; only PkgB 1.0 is deleted because there are two (2) PkgBs and one (1) PkgA.

        :param retention_group_by_name: The retention_group_by_name of this RepositoryRetentionRulesRequestPatch.
        :type: bool
        """

        self._retention_group_by_name = retention_group_by_name

    @property
    def retention_group_by_package_type(self):
        """Gets the retention_group_by_package_type of this RepositoryRetentionRulesRequestPatch.

        If checked, retention will apply to packages by package type (e.g. by binary, by source, etc.), rather than across all package types for one or more formats. <br>For example, when retaining by a limit of 1 and you upload DebPackage 1.0 and DebSourcePackage 1.0, no packages are deleted because they are different package types, binary and source respectively.

        :return: The retention_group_by_package_type of this RepositoryRetentionRulesRequestPatch.
        :rtype: bool
        """
        return self._retention_group_by_package_type

    @retention_group_by_package_type.setter
    def retention_group_by_package_type(self, retention_group_by_package_type):
        """Sets the retention_group_by_package_type of this RepositoryRetentionRulesRequestPatch.

        If checked, retention will apply to packages by package type (e.g. by binary, by source, etc.), rather than across all package types for one or more formats. <br>For example, when retaining by a limit of 1 and you upload DebPackage 1.0 and DebSourcePackage 1.0, no packages are deleted because they are different package types, binary and source respectively.

        :param retention_group_by_package_type: The retention_group_by_package_type of this RepositoryRetentionRulesRequestPatch.
        :type: bool
        """

        self._retention_group_by_package_type = retention_group_by_package_type

    @property
    def retention_package_query_string(self):
        """Gets the retention_package_query_string of this RepositoryRetentionRulesRequestPatch.

        A package search expression which, if provided, filters the packages to be deleted.<br>For example, a search expression of `name:foo` will result in only packages called 'foo' being deleted, or a search expression of `tag:~latest` will prevent any packages tagged 'latest' from being deleted.<br>Refer to the Cloudsmith documentation for package query syntax.

        :return: The retention_package_query_string of this RepositoryRetentionRulesRequestPatch.
        :rtype: str
        """
        return self._retention_package_query_string

    @retention_package_query_string.setter
    def retention_package_query_string(self, retention_package_query_string):
        """Sets the retention_package_query_string of this RepositoryRetentionRulesRequestPatch.

        A package search expression which, if provided, filters the packages to be deleted.<br>For example, a search expression of `name:foo` will result in only packages called 'foo' being deleted, or a search expression of `tag:~latest` will prevent any packages tagged 'latest' from being deleted.<br>Refer to the Cloudsmith documentation for package query syntax.

        :param retention_package_query_string: The retention_package_query_string of this RepositoryRetentionRulesRequestPatch.
        :type: str
        """

        self._retention_package_query_string = retention_package_query_string

    @property
    def retention_size_limit(self):
        """Gets the retention_size_limit of this RepositoryRetentionRulesRequestPatch.

        The maximum X total size (in bytes) of packages to retain.

        :return: The retention_size_limit of this RepositoryRetentionRulesRequestPatch.
        :rtype: int
        """
        return self._retention_size_limit

    @retention_size_limit.setter
    def retention_size_limit(self, retention_size_limit):
        """Sets the retention_size_limit of this RepositoryRetentionRulesRequestPatch.

        The maximum X total size (in bytes) of packages to retain.

        :param retention_size_limit: The retention_size_limit of this RepositoryRetentionRulesRequestPatch.
        :type: int
        """
        if (self._configuration.client_side_validation and
                retention_size_limit is not None and retention_size_limit > 21474836480):  # noqa: E501
            raise ValueError("Invalid value for `retention_size_limit`, must be a value less than or equal to `21474836480`")  # noqa: E501
        if (self._configuration.client_side_validation and
                retention_size_limit is not None and retention_size_limit < 0):  # noqa: E501
            raise ValueError("Invalid value for `retention_size_limit`, must be a value greater than or equal to `0`")  # noqa: E501

        self._retention_size_limit = retention_size_limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryRetentionRulesRequestPatch, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryRetentionRulesRequestPatch):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryRetentionRulesRequestPatch):
            return True

        return self.to_dict() != other.to_dict()

