# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryRsaKeyCreate(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'rsa_passphrase': 'str',
        'rsa_private_key': 'str'
    }

    attribute_map = {
        'rsa_passphrase': 'rsa_passphrase',
        'rsa_private_key': 'rsa_private_key'
    }

    def __init__(self, rsa_passphrase=None, rsa_private_key=None, _configuration=None):  # noqa: E501
        """RepositoryRsaKeyCreate - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._rsa_passphrase = None
        self._rsa_private_key = None
        self.discriminator = None

        if rsa_passphrase is not None:
            self.rsa_passphrase = rsa_passphrase
        self.rsa_private_key = rsa_private_key

    @property
    def rsa_passphrase(self):
        """Gets the rsa_passphrase of this RepositoryRsaKeyCreate.

        The RSA passphrase used for signing.

        :return: The rsa_passphrase of this RepositoryRsaKeyCreate.
        :rtype: str
        """
        return self._rsa_passphrase

    @rsa_passphrase.setter
    def rsa_passphrase(self, rsa_passphrase):
        """Sets the rsa_passphrase of this RepositoryRsaKeyCreate.

        The RSA passphrase used for signing.

        :param rsa_passphrase: The rsa_passphrase of this RepositoryRsaKeyCreate.
        :type: str
        """
        if (self._configuration.client_side_validation and
                rsa_passphrase is not None and len(rsa_passphrase) < 1):
            raise ValueError("Invalid value for `rsa_passphrase`, length must be greater than or equal to `1`")  # noqa: E501

        self._rsa_passphrase = rsa_passphrase

    @property
    def rsa_private_key(self):
        """Gets the rsa_private_key of this RepositoryRsaKeyCreate.

        The RSA private key.

        :return: The rsa_private_key of this RepositoryRsaKeyCreate.
        :rtype: str
        """
        return self._rsa_private_key

    @rsa_private_key.setter
    def rsa_private_key(self, rsa_private_key):
        """Sets the rsa_private_key of this RepositoryRsaKeyCreate.

        The RSA private key.

        :param rsa_private_key: The rsa_private_key of this RepositoryRsaKeyCreate.
        :type: str
        """
        if self._configuration.client_side_validation and rsa_private_key is None:
            raise ValueError("Invalid value for `rsa_private_key`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                rsa_private_key is not None and len(rsa_private_key) < 1):
            raise ValueError("Invalid value for `rsa_private_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._rsa_private_key = rsa_private_key

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryRsaKeyCreate, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryRsaKeyCreate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryRsaKeyCreate):
            return True

        return self.to_dict() != other.to_dict()

