# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class RepositoryTokenRefreshRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'eula_required': 'bool',
        'is_active': 'bool',
        'limit_bandwidth': 'int',
        'limit_bandwidth_unit': 'str',
        'limit_date_range_from': 'datetime',
        'limit_date_range_to': 'datetime',
        'limit_num_clients': 'int',
        'limit_num_downloads': 'int',
        'limit_package_query': 'str',
        'limit_path_query': 'str',
        'metadata': 'object',
        'scheduled_reset_at': 'datetime',
        'scheduled_reset_period': 'str',
        'token': 'str'
    }

    attribute_map = {
        'eula_required': 'eula_required',
        'is_active': 'is_active',
        'limit_bandwidth': 'limit_bandwidth',
        'limit_bandwidth_unit': 'limit_bandwidth_unit',
        'limit_date_range_from': 'limit_date_range_from',
        'limit_date_range_to': 'limit_date_range_to',
        'limit_num_clients': 'limit_num_clients',
        'limit_num_downloads': 'limit_num_downloads',
        'limit_package_query': 'limit_package_query',
        'limit_path_query': 'limit_path_query',
        'metadata': 'metadata',
        'scheduled_reset_at': 'scheduled_reset_at',
        'scheduled_reset_period': 'scheduled_reset_period',
        'token': 'token'
    }

    def __init__(self, eula_required=None, is_active=None, limit_bandwidth=None, limit_bandwidth_unit='Byte', limit_date_range_from=None, limit_date_range_to=None, limit_num_clients=None, limit_num_downloads=None, limit_package_query=None, limit_path_query=None, metadata=None, scheduled_reset_at=None, scheduled_reset_period='Never Reset', token=None, _configuration=None):  # noqa: E501
        """RepositoryTokenRefreshRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._eula_required = None
        self._is_active = None
        self._limit_bandwidth = None
        self._limit_bandwidth_unit = None
        self._limit_date_range_from = None
        self._limit_date_range_to = None
        self._limit_num_clients = None
        self._limit_num_downloads = None
        self._limit_package_query = None
        self._limit_path_query = None
        self._metadata = None
        self._scheduled_reset_at = None
        self._scheduled_reset_period = None
        self._token = None
        self.discriminator = None

        if eula_required is not None:
            self.eula_required = eula_required
        if is_active is not None:
            self.is_active = is_active
        if limit_bandwidth is not None:
            self.limit_bandwidth = limit_bandwidth
        if limit_bandwidth_unit is not None:
            self.limit_bandwidth_unit = limit_bandwidth_unit
        if limit_date_range_from is not None:
            self.limit_date_range_from = limit_date_range_from
        if limit_date_range_to is not None:
            self.limit_date_range_to = limit_date_range_to
        if limit_num_clients is not None:
            self.limit_num_clients = limit_num_clients
        if limit_num_downloads is not None:
            self.limit_num_downloads = limit_num_downloads
        if limit_package_query is not None:
            self.limit_package_query = limit_package_query
        if limit_path_query is not None:
            self.limit_path_query = limit_path_query
        if metadata is not None:
            self.metadata = metadata
        if scheduled_reset_at is not None:
            self.scheduled_reset_at = scheduled_reset_at
        if scheduled_reset_period is not None:
            self.scheduled_reset_period = scheduled_reset_period
        if token is not None:
            self.token = token

    @property
    def eula_required(self):
        """Gets the eula_required of this RepositoryTokenRefreshRequest.

        If checked, a EULA acceptance is required for this token.

        :return: The eula_required of this RepositoryTokenRefreshRequest.
        :rtype: bool
        """
        return self._eula_required

    @eula_required.setter
    def eula_required(self, eula_required):
        """Sets the eula_required of this RepositoryTokenRefreshRequest.

        If checked, a EULA acceptance is required for this token.

        :param eula_required: The eula_required of this RepositoryTokenRefreshRequest.
        :type: bool
        """

        self._eula_required = eula_required

    @property
    def is_active(self):
        """Gets the is_active of this RepositoryTokenRefreshRequest.

        If enabled, the token will allow downloads based on configured restrictions (if any).

        :return: The is_active of this RepositoryTokenRefreshRequest.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this RepositoryTokenRefreshRequest.

        If enabled, the token will allow downloads based on configured restrictions (if any).

        :param is_active: The is_active of this RepositoryTokenRefreshRequest.
        :type: bool
        """

        self._is_active = is_active

    @property
    def limit_bandwidth(self):
        """Gets the limit_bandwidth of this RepositoryTokenRefreshRequest.

        The maximum download bandwidth allowed for the token. Values are expressed as the selected unit of bandwidth. Please note that since downloads are calculated asynchronously (after the download happens), the limit may not be imposed immediately but at a later point. 

        :return: The limit_bandwidth of this RepositoryTokenRefreshRequest.
        :rtype: int
        """
        return self._limit_bandwidth

    @limit_bandwidth.setter
    def limit_bandwidth(self, limit_bandwidth):
        """Sets the limit_bandwidth of this RepositoryTokenRefreshRequest.

        The maximum download bandwidth allowed for the token. Values are expressed as the selected unit of bandwidth. Please note that since downloads are calculated asynchronously (after the download happens), the limit may not be imposed immediately but at a later point. 

        :param limit_bandwidth: The limit_bandwidth of this RepositoryTokenRefreshRequest.
        :type: int
        """
        if (self._configuration.client_side_validation and
                limit_bandwidth is not None and limit_bandwidth > 9223372036854775807):  # noqa: E501
            raise ValueError("Invalid value for `limit_bandwidth`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if (self._configuration.client_side_validation and
                limit_bandwidth is not None and limit_bandwidth < -9223372036854775808):  # noqa: E501
            raise ValueError("Invalid value for `limit_bandwidth`, must be a value greater than or equal to `-9223372036854775808`")  # noqa: E501

        self._limit_bandwidth = limit_bandwidth

    @property
    def limit_bandwidth_unit(self):
        """Gets the limit_bandwidth_unit of this RepositoryTokenRefreshRequest.


        :return: The limit_bandwidth_unit of this RepositoryTokenRefreshRequest.
        :rtype: str
        """
        return self._limit_bandwidth_unit

    @limit_bandwidth_unit.setter
    def limit_bandwidth_unit(self, limit_bandwidth_unit):
        """Sets the limit_bandwidth_unit of this RepositoryTokenRefreshRequest.


        :param limit_bandwidth_unit: The limit_bandwidth_unit of this RepositoryTokenRefreshRequest.
        :type: str
        """
        allowed_values = ["Byte", "Kilobyte", "Megabyte", "Gigabyte", "Terabyte", "Petabyte", "Exabyte", "Zettabyte", "Yottabyte"]  # noqa: E501
        if (self._configuration.client_side_validation and
                limit_bandwidth_unit not in allowed_values):
            raise ValueError(
                "Invalid value for `limit_bandwidth_unit` ({0}), must be one of {1}"  # noqa: E501
                .format(limit_bandwidth_unit, allowed_values)
            )

        self._limit_bandwidth_unit = limit_bandwidth_unit

    @property
    def limit_date_range_from(self):
        """Gets the limit_date_range_from of this RepositoryTokenRefreshRequest.

        The starting date/time the token is allowed to be used from.

        :return: The limit_date_range_from of this RepositoryTokenRefreshRequest.
        :rtype: datetime
        """
        return self._limit_date_range_from

    @limit_date_range_from.setter
    def limit_date_range_from(self, limit_date_range_from):
        """Sets the limit_date_range_from of this RepositoryTokenRefreshRequest.

        The starting date/time the token is allowed to be used from.

        :param limit_date_range_from: The limit_date_range_from of this RepositoryTokenRefreshRequest.
        :type: datetime
        """

        self._limit_date_range_from = limit_date_range_from

    @property
    def limit_date_range_to(self):
        """Gets the limit_date_range_to of this RepositoryTokenRefreshRequest.

        The ending date/time the token is allowed to be used until.

        :return: The limit_date_range_to of this RepositoryTokenRefreshRequest.
        :rtype: datetime
        """
        return self._limit_date_range_to

    @limit_date_range_to.setter
    def limit_date_range_to(self, limit_date_range_to):
        """Sets the limit_date_range_to of this RepositoryTokenRefreshRequest.

        The ending date/time the token is allowed to be used until.

        :param limit_date_range_to: The limit_date_range_to of this RepositoryTokenRefreshRequest.
        :type: datetime
        """

        self._limit_date_range_to = limit_date_range_to

    @property
    def limit_num_clients(self):
        """Gets the limit_num_clients of this RepositoryTokenRefreshRequest.

        The maximum number of unique clients allowed for the token. Please note that since clients are calculated asynchronously (after the download happens), the limit may not be imposed immediately but at a later point.

        :return: The limit_num_clients of this RepositoryTokenRefreshRequest.
        :rtype: int
        """
        return self._limit_num_clients

    @limit_num_clients.setter
    def limit_num_clients(self, limit_num_clients):
        """Sets the limit_num_clients of this RepositoryTokenRefreshRequest.

        The maximum number of unique clients allowed for the token. Please note that since clients are calculated asynchronously (after the download happens), the limit may not be imposed immediately but at a later point.

        :param limit_num_clients: The limit_num_clients of this RepositoryTokenRefreshRequest.
        :type: int
        """
        if (self._configuration.client_side_validation and
                limit_num_clients is not None and limit_num_clients > 9223372036854775807):  # noqa: E501
            raise ValueError("Invalid value for `limit_num_clients`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if (self._configuration.client_side_validation and
                limit_num_clients is not None and limit_num_clients < -9223372036854775808):  # noqa: E501
            raise ValueError("Invalid value for `limit_num_clients`, must be a value greater than or equal to `-9223372036854775808`")  # noqa: E501

        self._limit_num_clients = limit_num_clients

    @property
    def limit_num_downloads(self):
        """Gets the limit_num_downloads of this RepositoryTokenRefreshRequest.

        The maximum number of downloads allowed for the token. Please note that since downloads are calculated asynchronously (after the download happens), the limit may not be imposed immediately but at a later point.

        :return: The limit_num_downloads of this RepositoryTokenRefreshRequest.
        :rtype: int
        """
        return self._limit_num_downloads

    @limit_num_downloads.setter
    def limit_num_downloads(self, limit_num_downloads):
        """Sets the limit_num_downloads of this RepositoryTokenRefreshRequest.

        The maximum number of downloads allowed for the token. Please note that since downloads are calculated asynchronously (after the download happens), the limit may not be imposed immediately but at a later point.

        :param limit_num_downloads: The limit_num_downloads of this RepositoryTokenRefreshRequest.
        :type: int
        """
        if (self._configuration.client_side_validation and
                limit_num_downloads is not None and limit_num_downloads > 9223372036854775807):  # noqa: E501
            raise ValueError("Invalid value for `limit_num_downloads`, must be a value less than or equal to `9223372036854775807`")  # noqa: E501
        if (self._configuration.client_side_validation and
                limit_num_downloads is not None and limit_num_downloads < -9223372036854775808):  # noqa: E501
            raise ValueError("Invalid value for `limit_num_downloads`, must be a value greater than or equal to `-9223372036854775808`")  # noqa: E501

        self._limit_num_downloads = limit_num_downloads

    @property
    def limit_package_query(self):
        """Gets the limit_package_query of this RepositoryTokenRefreshRequest.

        The package-based search query to apply to restrict downloads to. This uses the same syntax as the standard search used for repositories, and also supports boolean logic operators such as OR/AND/NOT and parentheses for grouping. This will still allow access to non-package files, such as metadata.

        :return: The limit_package_query of this RepositoryTokenRefreshRequest.
        :rtype: str
        """
        return self._limit_package_query

    @limit_package_query.setter
    def limit_package_query(self, limit_package_query):
        """Sets the limit_package_query of this RepositoryTokenRefreshRequest.

        The package-based search query to apply to restrict downloads to. This uses the same syntax as the standard search used for repositories, and also supports boolean logic operators such as OR/AND/NOT and parentheses for grouping. This will still allow access to non-package files, such as metadata.

        :param limit_package_query: The limit_package_query of this RepositoryTokenRefreshRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                limit_package_query is not None and len(limit_package_query) > 1024):
            raise ValueError("Invalid value for `limit_package_query`, length must be less than or equal to `1024`")  # noqa: E501

        self._limit_package_query = limit_package_query

    @property
    def limit_path_query(self):
        """Gets the limit_path_query of this RepositoryTokenRefreshRequest.

        THIS WILL SOON BE DEPRECATED, please use limit_package_query instead. The path-based search query to apply to restrict downloads to. This supports boolean logic operators such as OR/AND/NOT and parentheses for grouping. The path evaluated does not include the domain name, the namespace, the entitlement code used, the package format, etc. and it always starts with a forward slash.

        :return: The limit_path_query of this RepositoryTokenRefreshRequest.
        :rtype: str
        """
        return self._limit_path_query

    @limit_path_query.setter
    def limit_path_query(self, limit_path_query):
        """Sets the limit_path_query of this RepositoryTokenRefreshRequest.

        THIS WILL SOON BE DEPRECATED, please use limit_package_query instead. The path-based search query to apply to restrict downloads to. This supports boolean logic operators such as OR/AND/NOT and parentheses for grouping. The path evaluated does not include the domain name, the namespace, the entitlement code used, the package format, etc. and it always starts with a forward slash.

        :param limit_path_query: The limit_path_query of this RepositoryTokenRefreshRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                limit_path_query is not None and len(limit_path_query) > 1024):
            raise ValueError("Invalid value for `limit_path_query`, length must be less than or equal to `1024`")  # noqa: E501

        self._limit_path_query = limit_path_query

    @property
    def metadata(self):
        """Gets the metadata of this RepositoryTokenRefreshRequest.


        :return: The metadata of this RepositoryTokenRefreshRequest.
        :rtype: object
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """Sets the metadata of this RepositoryTokenRefreshRequest.


        :param metadata: The metadata of this RepositoryTokenRefreshRequest.
        :type: object
        """

        self._metadata = metadata

    @property
    def scheduled_reset_at(self):
        """Gets the scheduled_reset_at of this RepositoryTokenRefreshRequest.

        The time at which the scheduled reset period has elapsed and the token limits were automatically reset to zero.

        :return: The scheduled_reset_at of this RepositoryTokenRefreshRequest.
        :rtype: datetime
        """
        return self._scheduled_reset_at

    @scheduled_reset_at.setter
    def scheduled_reset_at(self, scheduled_reset_at):
        """Sets the scheduled_reset_at of this RepositoryTokenRefreshRequest.

        The time at which the scheduled reset period has elapsed and the token limits were automatically reset to zero.

        :param scheduled_reset_at: The scheduled_reset_at of this RepositoryTokenRefreshRequest.
        :type: datetime
        """

        self._scheduled_reset_at = scheduled_reset_at

    @property
    def scheduled_reset_period(self):
        """Gets the scheduled_reset_period of this RepositoryTokenRefreshRequest.


        :return: The scheduled_reset_period of this RepositoryTokenRefreshRequest.
        :rtype: str
        """
        return self._scheduled_reset_period

    @scheduled_reset_period.setter
    def scheduled_reset_period(self, scheduled_reset_period):
        """Sets the scheduled_reset_period of this RepositoryTokenRefreshRequest.


        :param scheduled_reset_period: The scheduled_reset_period of this RepositoryTokenRefreshRequest.
        :type: str
        """
        allowed_values = ["Never Reset", "Daily", "Weekly", "Fortnightly", "Monthly", "Bi-Monthly", "Quarterly", "Every 6 months", "Annual"]  # noqa: E501
        if (self._configuration.client_side_validation and
                scheduled_reset_period not in allowed_values):
            raise ValueError(
                "Invalid value for `scheduled_reset_period` ({0}), must be one of {1}"  # noqa: E501
                .format(scheduled_reset_period, allowed_values)
            )

        self._scheduled_reset_period = scheduled_reset_period

    @property
    def token(self):
        """Gets the token of this RepositoryTokenRefreshRequest.


        :return: The token of this RepositoryTokenRefreshRequest.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this RepositoryTokenRefreshRequest.


        :param token: The token of this RepositoryTokenRefreshRequest.
        :type: str
        """
        if (self._configuration.client_side_validation and
                token is not None and len(token) < 1):
            raise ValueError("Invalid value for `token`, length must be greater than or equal to `1`")  # noqa: E501

        self._token = token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RepositoryTokenRefreshRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RepositoryTokenRefreshRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RepositoryTokenRefreshRequest):
            return True

        return self.to_dict() != other.to_dict()

