# coding: utf-8

"""
    Cloudsmith API (v1)

    The API to the Cloudsmith Service  # noqa: E501

    OpenAPI spec version: v1
    Contact: support@cloudsmith.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from cloudsmith_api.configuration import Configuration


class UserAuthToken(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'token': 'str',
        'two_factor_required': 'bool',
        'two_factor_token': 'str'
    }

    attribute_map = {
        'token': 'token',
        'two_factor_required': 'two_factor_required',
        'two_factor_token': 'two_factor_token'
    }

    def __init__(self, token=None, two_factor_required=None, two_factor_token=None, _configuration=None):  # noqa: E501
        """UserAuthToken - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._token = None
        self._two_factor_required = None
        self._two_factor_token = None
        self.discriminator = None

        if token is not None:
            self.token = token
        if two_factor_required is not None:
            self.two_factor_required = two_factor_required
        if two_factor_token is not None:
            self.two_factor_token = two_factor_token

    @property
    def token(self):
        """Gets the token of this UserAuthToken.

        API token for the authenticated user

        :return: The token of this UserAuthToken.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this UserAuthToken.

        API token for the authenticated user

        :param token: The token of this UserAuthToken.
        :type: str
        """
        if (self._configuration.client_side_validation and
                token is not None and len(token) < 1):
            raise ValueError("Invalid value for `token`, length must be greater than or equal to `1`")  # noqa: E501

        self._token = token

    @property
    def two_factor_required(self):
        """Gets the two_factor_required of this UserAuthToken.

        Flag indicating whether a 2FA code is required to complete authentication

        :return: The two_factor_required of this UserAuthToken.
        :rtype: bool
        """
        return self._two_factor_required

    @two_factor_required.setter
    def two_factor_required(self, two_factor_required):
        """Sets the two_factor_required of this UserAuthToken.

        Flag indicating whether a 2FA code is required to complete authentication

        :param two_factor_required: The two_factor_required of this UserAuthToken.
        :type: bool
        """

        self._two_factor_required = two_factor_required

    @property
    def two_factor_token(self):
        """Gets the two_factor_token of this UserAuthToken.

        Token to use when providing 2FA code

        :return: The two_factor_token of this UserAuthToken.
        :rtype: str
        """
        return self._two_factor_token

    @two_factor_token.setter
    def two_factor_token(self, two_factor_token):
        """Sets the two_factor_token of this UserAuthToken.

        Token to use when providing 2FA code

        :param two_factor_token: The two_factor_token of this UserAuthToken.
        :type: str
        """
        if (self._configuration.client_side_validation and
                two_factor_token is not None and len(two_factor_token) < 1):
            raise ValueError("Invalid value for `two_factor_token`, length must be greater than or equal to `1`")  # noqa: E501

        self._two_factor_token = two_factor_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserAuthToken, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserAuthToken):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserAuthToken):
            return True

        return self.to_dict() != other.to_dict()

