# coding: utf-8

"""
    Codabl Community API

    The Codabl API is a collection of analytics tools and data integrations made for blockchain developers. In particular we offer Natural Language Processing and Anomaly detection algorithms that have been fine tune to understand text data and time series in the domain speficic setting of cryptocurrency and blockchain technology. This technology is intended to be use as building blocks to bigger applications, we offer examples on how to use them for Trading Backtesting and Smart Contract anomaly monitoring.  # noqa: E501

    OpenAPI spec version: 0.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class OrderbookRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'base_trading_symbol': 'str',
        'exchange': 'str',
        'limit': 'float',
        'quote_trading_symbol': 'str'
    }

    attribute_map = {
        'base_trading_symbol': 'base_trading_symbol',
        'exchange': 'exchange',
        'limit': 'limit',
        'quote_trading_symbol': 'quote_trading_symbol'
    }

    def __init__(self, base_trading_symbol=None, exchange=None, limit=None, quote_trading_symbol=None):  # noqa: E501
        """OrderbookRequest - a model defined in Swagger"""  # noqa: E501

        self._base_trading_symbol = None
        self._exchange = None
        self._limit = None
        self._quote_trading_symbol = None
        self.discriminator = None

        if base_trading_symbol is not None:
            self.base_trading_symbol = base_trading_symbol
        if exchange is not None:
            self.exchange = exchange
        if limit is not None:
            self.limit = limit
        if quote_trading_symbol is not None:
            self.quote_trading_symbol = quote_trading_symbol

    @property
    def base_trading_symbol(self):
        """Gets the base_trading_symbol of this OrderbookRequest.  # noqa: E501

        Name of the currency pair  # noqa: E501

        :return: The base_trading_symbol of this OrderbookRequest.  # noqa: E501
        :rtype: str
        """
        return self._base_trading_symbol

    @base_trading_symbol.setter
    def base_trading_symbol(self, base_trading_symbol):
        """Sets the base_trading_symbol of this OrderbookRequest.

        Name of the currency pair  # noqa: E501

        :param base_trading_symbol: The base_trading_symbol of this OrderbookRequest.  # noqa: E501
        :type: str
        """

        self._base_trading_symbol = base_trading_symbol

    @property
    def exchange(self):
        """Gets the exchange of this OrderbookRequest.  # noqa: E501

        Name of the exchange  # noqa: E501

        :return: The exchange of this OrderbookRequest.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this OrderbookRequest.

        Name of the exchange  # noqa: E501

        :param exchange: The exchange of this OrderbookRequest.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def limit(self):
        """Gets the limit of this OrderbookRequest.  # noqa: E501

        Limit depth to extract from the orderbook  # noqa: E501

        :return: The limit of this OrderbookRequest.  # noqa: E501
        :rtype: float
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this OrderbookRequest.

        Limit depth to extract from the orderbook  # noqa: E501

        :param limit: The limit of this OrderbookRequest.  # noqa: E501
        :type: float
        """

        self._limit = limit

    @property
    def quote_trading_symbol(self):
        """Gets the quote_trading_symbol of this OrderbookRequest.  # noqa: E501

        Name of the data format availables (standard)  # noqa: E501

        :return: The quote_trading_symbol of this OrderbookRequest.  # noqa: E501
        :rtype: str
        """
        return self._quote_trading_symbol

    @quote_trading_symbol.setter
    def quote_trading_symbol(self, quote_trading_symbol):
        """Sets the quote_trading_symbol of this OrderbookRequest.

        Name of the data format availables (standard)  # noqa: E501

        :param quote_trading_symbol: The quote_trading_symbol of this OrderbookRequest.  # noqa: E501
        :type: str
        """

        self._quote_trading_symbol = quote_trading_symbol

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderbookRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderbookRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
