# Auto-generated by java_generate.py
# flake8: noqa

from typing import Dict, List, TypedDict

class MethodInfo(TypedDict):
    name: str
    parameters: List[str]
    return_type: str
    signature: str

MethodsDict = Dict[str, Dict[str, List[MethodInfo]]]

JAVA_METHODS: MethodsDict = {
    "javax.jms": {
        "BytesMessage": [
            {
                "name": "getBodyLength",
                "parameters": [],
                "signature": "public abstract long getBodyLength() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBoolean",
                "parameters": [],
                "signature": "public abstract boolean readBoolean() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readByte",
                "parameters": [],
                "signature": "public abstract byte readByte() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readUnsignedByte",
                "parameters": [],
                "signature": "public abstract int readUnsignedByte() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readShort",
                "parameters": [],
                "signature": "public abstract short readShort() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readUnsignedShort",
                "parameters": [],
                "signature": "public abstract int readUnsignedShort() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readChar",
                "parameters": [],
                "signature": "public abstract char readChar() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readInt",
                "parameters": [],
                "signature": "public abstract int readInt() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readLong",
                "parameters": [],
                "signature": "public abstract long readLong() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readFloat",
                "parameters": [],
                "signature": "public abstract float readFloat() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readDouble",
                "parameters": [],
                "signature": "public abstract double readDouble() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readUTF",
                "parameters": [],
                "signature": "public abstract java.lang.String readUTF() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract int readBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [
                    "byte[]",
                    "int"
                ],
                "signature": "public abstract int readBytes(byte[], int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBoolean",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void writeBoolean(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeByte",
                "parameters": [
                    "byte"
                ],
                "signature": "public abstract void writeByte(byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeShort",
                "parameters": [
                    "short"
                ],
                "signature": "public abstract void writeShort(short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeChar",
                "parameters": [
                    "char"
                ],
                "signature": "public abstract void writeChar(char) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void writeInt(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeLong",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void writeLong(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeFloat",
                "parameters": [
                    "float"
                ],
                "signature": "public abstract void writeFloat(float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeDouble",
                "parameters": [
                    "double"
                ],
                "signature": "public abstract void writeDouble(double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeUTF",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void writeUTF(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void writeBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract void writeBytes(byte[], int, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract void writeObject(java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "reset",
                "parameters": [],
                "signature": "public abstract void reset() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MapMessage": [
            {
                "name": "getBoolean",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBoolean(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getByte",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByte(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getShort",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShort(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getChar",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract char getChar(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getInt",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getInt(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getLong",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLong(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getFloat",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloat(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDouble",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDouble(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getString(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte[] getBytes(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObject(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMapNames",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getMapNames() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBoolean",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void setBoolean(java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setByte",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void setByte(java.lang.String, byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setShort",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void setShort(java.lang.String, short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setChar",
                "parameters": [
                    "java.lang.String",
                    "char"
                ],
                "signature": "public abstract void setChar(java.lang.String, char) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setInt",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setInt(java.lang.String, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setLong",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void setLong(java.lang.String, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setFloat",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void setFloat(java.lang.String, float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDouble",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void setDouble(java.lang.String, double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]"
                ],
                "signature": "public abstract void setBytes(java.lang.String, byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract void setBytes(java.lang.String, byte[], int, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "itemExists",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean itemExists(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "JMSConsumer": [
            {
                "name": "getMessageSelector",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessageSelector();",
                "return_type": "void"
            },
            {
                "name": "getMessageListener",
                "parameters": [],
                "signature": "public abstract javax.jms.MessageListener getMessageListener() throws javax.jms.JMSRuntimeException;",
                "return_type": "void"
            },
            {
                "name": "setMessageListener",
                "parameters": [
                    "javax.jms.MessageListener"
                ],
                "signature": "public abstract void setMessageListener(javax.jms.MessageListener) throws javax.jms.JMSRuntimeException;",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receive();",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.Message receive(long);",
                "return_type": "void"
            },
            {
                "name": "receiveNoWait",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receiveNoWait();",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close();",
                "return_type": "void"
            },
            {
                "name": "receiveBody",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T receiveBody(java.lang.Class<T>);",
                "return_type": "void"
            },
            {
                "name": "receiveBody",
                "parameters": [
                    "java.lang.Class<T>",
                    "long"
                ],
                "signature": "public abstract <T> T receiveBody(java.lang.Class<T>, long);",
                "return_type": "void"
            },
            {
                "name": "receiveBodyNoWait",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T receiveBodyNoWait(java.lang.Class<T>);",
                "return_type": "void"
            }
        ],
        "TemporaryTopic": [
            {
                "name": "delete",
                "parameters": [],
                "signature": "public abstract void delete() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MessageProducer": [
            {
                "name": "setDisableMessageID",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setDisableMessageID(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageID",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDisableMessageTimestamp",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setDisableMessageTimestamp(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageTimestamp",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageTimestamp() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDeliveryMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setDeliveryMode(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDeliveryMode",
                "parameters": [],
                "signature": "public abstract int getDeliveryMode() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setPriority",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setPriority(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getPriority",
                "parameters": [],
                "signature": "public abstract int getPriority() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setTimeToLive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setTimeToLive(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getTimeToLive",
                "parameters": [],
                "signature": "public abstract long getTimeToLive() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDeliveryDelay",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setDeliveryDelay(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDeliveryDelay",
                "parameters": [],
                "signature": "public abstract long getDeliveryDelay() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDestination",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getDestination() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Message, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Message, int, int, long, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message, int, int, long, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TopicSubscriber": [
            {
                "name": "getTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.Topic getTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getNoLocal",
                "parameters": [],
                "signature": "public abstract boolean getNoLocal() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueSender": [
            {
                "name": "getQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.Queue getQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Queue",
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Queue, javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Queue",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Queue, javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "CompletionListener": [
            {
                "name": "onCompletion",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void onCompletion(javax.jms.Message);",
                "return_type": "void"
            },
            {
                "name": "onException",
                "parameters": [
                    "javax.jms.Message",
                    "java.lang.Exception"
                ],
                "signature": "public abstract void onException(javax.jms.Message, java.lang.Exception);",
                "return_type": "void"
            }
        ],
        "TopicRequestor": [
            {
                "name": "javax.jms.TopicRequestor",
                "parameters": [
                    "javax.jms.TopicSession",
                    "javax.jms.Topic"
                ],
                "signature": "public javax.jms.TopicRequestor(javax.jms.TopicSession, javax.jms.Topic) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "request",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public javax.jms.Message request(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "javax.jms.Message"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TopicPublisher": [
            {
                "name": "getTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.Topic getTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void publish(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void publish(javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Topic",
                    "javax.jms.Message"
                ],
                "signature": "public abstract void publish(javax.jms.Topic, javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Topic",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void publish(javax.jms.Topic, javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XATopicSession": [
            {
                "name": "getTopicSession",
                "parameters": [],
                "signature": "public abstract javax.jms.TopicSession getTopicSession() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MessageFormatException": [
            {
                "name": "javax.jms.MessageFormatException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageFormatException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSConnectionFactory": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract java.lang.String value();",
                "return_type": "void"
            }
        ],
        "InvalidDestinationException": [
            {
                "name": "javax.jms.InvalidDestinationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidDestinationException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "InvalidDestinationRuntimeException": [
            {
                "name": "javax.jms.InvalidDestinationRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidDestinationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidDestinationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.InvalidDestinationRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "TopicConnectionFactory": [
            {
                "name": "createTopicConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.TopicConnection createTopicConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTopicConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TopicConnection createTopicConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ResourceAllocationRuntimeException": [
            {
                "name": "javax.jms.ResourceAllocationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.ResourceAllocationRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.ResourceAllocationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.ResourceAllocationRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "TransactionInProgressRuntimeException": [
            {
                "name": "javax.jms.TransactionInProgressRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionInProgressRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionInProgressRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.TransactionInProgressRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "MessageNotWriteableException": [
            {
                "name": "javax.jms.MessageNotWriteableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotWriteableException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "MessageNotReadableException": [
            {
                "name": "javax.jms.MessageNotReadableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotReadableException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotReadableException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotReadableException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "QueueRequestor": [
            {
                "name": "javax.jms.QueueRequestor",
                "parameters": [
                    "javax.jms.QueueSession",
                    "javax.jms.Queue"
                ],
                "signature": "public javax.jms.QueueRequestor(javax.jms.QueueSession, javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "request",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public javax.jms.Message request(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "javax.jms.Message"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TransactionInProgressException": [
            {
                "name": "javax.jms.TransactionInProgressException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionInProgressException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "TransactionRolledBackRuntimeException": [
            {
                "name": "javax.jms.TransactionRolledBackRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionRolledBackRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionRolledBackRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.TransactionRolledBackRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "InvalidClientIDRuntimeException": [
            {
                "name": "javax.jms.InvalidClientIDRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidClientIDRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidClientIDRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.InvalidClientIDRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "MessageNotWriteableRuntimeException": [
            {
                "name": "javax.jms.MessageNotWriteableRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotWriteableRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotWriteableRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.MessageNotWriteableRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "JMSSecurityException": [
            {
                "name": "javax.jms.JMSSecurityException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSSecurityException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "IllegalStateRuntimeException": [
            {
                "name": "javax.jms.IllegalStateRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.IllegalStateRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.IllegalStateRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.IllegalStateRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "StreamMessage": [
            {
                "name": "readBoolean",
                "parameters": [],
                "signature": "public abstract boolean readBoolean() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readByte",
                "parameters": [],
                "signature": "public abstract byte readByte() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readShort",
                "parameters": [],
                "signature": "public abstract short readShort() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readChar",
                "parameters": [],
                "signature": "public abstract char readChar() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readInt",
                "parameters": [],
                "signature": "public abstract int readInt() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readLong",
                "parameters": [],
                "signature": "public abstract long readLong() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readFloat",
                "parameters": [],
                "signature": "public abstract float readFloat() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readDouble",
                "parameters": [],
                "signature": "public abstract double readDouble() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readString",
                "parameters": [],
                "signature": "public abstract java.lang.String readString() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract int readBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [],
                "signature": "public abstract java.lang.Object readObject() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBoolean",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void writeBoolean(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeByte",
                "parameters": [
                    "byte"
                ],
                "signature": "public abstract void writeByte(byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeShort",
                "parameters": [
                    "short"
                ],
                "signature": "public abstract void writeShort(short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeChar",
                "parameters": [
                    "char"
                ],
                "signature": "public abstract void writeChar(char) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void writeInt(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeLong",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void writeLong(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeFloat",
                "parameters": [
                    "float"
                ],
                "signature": "public abstract void writeFloat(float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeDouble",
                "parameters": [
                    "double"
                ],
                "signature": "public abstract void writeDouble(double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void writeString(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void writeBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract void writeBytes(byte[], int, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract void writeObject(java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "reset",
                "parameters": [],
                "signature": "public abstract void reset() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Message": [
            {
                "name": "getJMSMessageID",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSMessageID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSMessageID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setJMSMessageID(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSTimestamp",
                "parameters": [],
                "signature": "public abstract long getJMSTimestamp() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSTimestamp",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setJMSTimestamp(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationIDAsBytes",
                "parameters": [],
                "signature": "public abstract byte[] getJMSCorrelationIDAsBytes() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationIDAsBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void setJMSCorrelationIDAsBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setJMSCorrelationID(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationID",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSCorrelationID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSReplyTo",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getJMSReplyTo() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSReplyTo",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract void setJMSReplyTo(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSDestination",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getJMSDestination() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSDestination",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract void setJMSDestination(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSDeliveryMode",
                "parameters": [],
                "signature": "public abstract int getJMSDeliveryMode() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSDeliveryMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setJMSDeliveryMode(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSRedelivered",
                "parameters": [],
                "signature": "public abstract boolean getJMSRedelivered() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSRedelivered",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setJMSRedelivered(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSType",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSType() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSType",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setJMSType(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSExpiration",
                "parameters": [],
                "signature": "public abstract long getJMSExpiration() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSExpiration",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setJMSExpiration(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSDeliveryTime",
                "parameters": [],
                "signature": "public abstract long getJMSDeliveryTime() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSDeliveryTime",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setJMSDeliveryTime(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSPriority",
                "parameters": [],
                "signature": "public abstract int getJMSPriority() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSPriority",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setJMSPriority(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "clearProperties",
                "parameters": [],
                "signature": "public abstract void clearProperties() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "propertyExists",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean propertyExists(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getBooleanProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBooleanProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getByteProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByteProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getShortProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShortProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getIntProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getIntProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getLongProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLongProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getFloatProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloatProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDoubleProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDoubleProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getStringProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getStringProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getObjectProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObjectProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getPropertyNames",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getPropertyNames() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBooleanProperty",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void setBooleanProperty(java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setByteProperty",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void setByteProperty(java.lang.String, byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setShortProperty",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void setShortProperty(java.lang.String, short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setIntProperty",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setIntProperty(java.lang.String, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setLongProperty",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void setLongProperty(java.lang.String, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setFloatProperty",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void setFloatProperty(java.lang.String, float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDoubleProperty",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void setDoubleProperty(java.lang.String, double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setStringProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setStringProperty(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setObjectProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObjectProperty(java.lang.String, java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "acknowledge",
                "parameters": [],
                "signature": "public abstract void acknowledge() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "clearBody",
                "parameters": [],
                "signature": "public abstract void clearBody() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getBody",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T getBody(java.lang.Class<T>) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "isBodyAssignableTo",
                "parameters": [
                    "java.lang.Class"
                ],
                "signature": "public abstract boolean isBodyAssignableTo(java.lang.Class) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "JMSException": [
            {
                "name": "javax.jms.JMSException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getErrorCode",
                "parameters": [],
                "signature": "public java.lang.String getErrorCode();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getLinkedException",
                "parameters": [],
                "signature": "public java.lang.Exception getLinkedException();",
                "return_type": "java.lang.Exception"
            },
            {
                "name": "setLinkedException",
                "parameters": [
                    "java.lang.Exception"
                ],
                "signature": "public void setLinkedException(java.lang.Exception);",
                "return_type": "void"
            }
        ],
        "Destination": [],
        "XAQueueConnectionFactory": [
            {
                "name": "createXAQueueConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.XAQueueConnection createXAQueueConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXAQueueConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XAQueueConnection createXAQueueConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XAConnectionFactory": [
            {
                "name": "createXAConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.XAConnection createXAConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXAConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XAConnection createXAConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXAContext",
                "parameters": [],
                "signature": "public abstract javax.jms.XAJMSContext createXAContext();",
                "return_type": "void"
            },
            {
                "name": "createXAContext",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XAJMSContext createXAContext(java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ],
        "QueueConnectionFactory": [
            {
                "name": "createQueueConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.QueueConnection createQueueConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createQueueConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueConnection createQueueConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ConnectionFactory": [
            {
                "name": "createConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.Connection createConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Connection createConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSContext createContext();",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(int);",
                "return_type": "void"
            }
        ],
        "XAQueueConnection": [
            {
                "name": "createXAQueueSession",
                "parameters": [],
                "signature": "public abstract javax.jms.XAQueueSession createXAQueueSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createQueueSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.QueueSession createQueueSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XAConnection": [
            {
                "name": "createXASession",
                "parameters": [],
                "signature": "public abstract javax.jms.XASession createXASession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.Session createSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Connection": [
            {
                "name": "createSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.Session createSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSession",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.Session createSession(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSession",
                "parameters": [],
                "signature": "public abstract javax.jms.Session createSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getClientID",
                "parameters": [],
                "signature": "public abstract java.lang.String getClientID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setClientID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setClientID(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract javax.jms.ConnectionMetaData getMetaData() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getExceptionListener",
                "parameters": [],
                "signature": "public abstract javax.jms.ExceptionListener getExceptionListener() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setExceptionListener",
                "parameters": [
                    "javax.jms.ExceptionListener"
                ],
                "signature": "public abstract void setExceptionListener(javax.jms.ExceptionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "start",
                "parameters": [],
                "signature": "public abstract void start() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "stop",
                "parameters": [],
                "signature": "public abstract void stop() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createConnectionConsumer(javax.jms.Destination, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createSharedConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createDurableConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createSharedDurableConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueConnection": [
            {
                "name": "createQueueSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.QueueSession createQueueSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionConsumer",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createConnectionConsumer(javax.jms.Queue, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XAJMSContext": [
            {
                "name": "getContext",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSContext getContext();",
                "return_type": "void"
            },
            {
                "name": "getXAResource",
                "parameters": [],
                "signature": "public abstract javax.transaction.xa.XAResource getXAResource();",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted();",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit();",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback();",
                "return_type": "void"
            }
        ],
        "JMSContext": [
            {
                "name": "createContext",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(int);",
                "return_type": "void"
            },
            {
                "name": "createProducer",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSProducer createProducer();",
                "return_type": "void"
            },
            {
                "name": "getClientID",
                "parameters": [],
                "signature": "public abstract java.lang.String getClientID();",
                "return_type": "void"
            },
            {
                "name": "setClientID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setClientID(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract javax.jms.ConnectionMetaData getMetaData();",
                "return_type": "void"
            },
            {
                "name": "getExceptionListener",
                "parameters": [],
                "signature": "public abstract javax.jms.ExceptionListener getExceptionListener();",
                "return_type": "void"
            },
            {
                "name": "setExceptionListener",
                "parameters": [
                    "javax.jms.ExceptionListener"
                ],
                "signature": "public abstract void setExceptionListener(javax.jms.ExceptionListener);",
                "return_type": "void"
            },
            {
                "name": "start",
                "parameters": [],
                "signature": "public abstract void start();",
                "return_type": "void"
            },
            {
                "name": "stop",
                "parameters": [],
                "signature": "public abstract void stop();",
                "return_type": "void"
            },
            {
                "name": "setAutoStart",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setAutoStart(boolean);",
                "return_type": "void"
            },
            {
                "name": "getAutoStart",
                "parameters": [],
                "signature": "public abstract boolean getAutoStart();",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close();",
                "return_type": "void"
            },
            {
                "name": "createBytesMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.BytesMessage createBytesMessage();",
                "return_type": "void"
            },
            {
                "name": "createMapMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.MapMessage createMapMessage();",
                "return_type": "void"
            },
            {
                "name": "createMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.Message createMessage();",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage();",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [
                    "java.io.Serializable"
                ],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage(java.io.Serializable);",
                "return_type": "void"
            },
            {
                "name": "createStreamMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.StreamMessage createStreamMessage();",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.TextMessage createTextMessage();",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TextMessage createTextMessage(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted();",
                "return_type": "void"
            },
            {
                "name": "getSessionMode",
                "parameters": [],
                "signature": "public abstract int getSessionMode();",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit();",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback();",
                "return_type": "void"
            },
            {
                "name": "recover",
                "parameters": [],
                "signature": "public abstract void recover();",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createConsumer(javax.jms.Destination);",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createConsumer(javax.jms.Destination, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createConsumer(javax.jms.Destination, java.lang.String, boolean);",
                "return_type": "void"
            },
            {
                "name": "createQueue",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Queue createQueue(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createTopic",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Topic createTopic(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createDurableConsumer(javax.jms.Topic, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String, boolean);",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedConsumer(javax.jms.Topic, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedConsumer(javax.jms.Topic, java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue);",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createTemporaryQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryQueue createTemporaryQueue();",
                "return_type": "void"
            },
            {
                "name": "createTemporaryTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryTopic createTemporaryTopic();",
                "return_type": "void"
            },
            {
                "name": "unsubscribe",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void unsubscribe(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "acknowledge",
                "parameters": [],
                "signature": "public abstract void acknowledge();",
                "return_type": "void"
            }
        ],
        "XAQueueSession": [
            {
                "name": "getQueueSession",
                "parameters": [],
                "signature": "public abstract javax.jms.QueueSession getQueueSession() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XASession": [
            {
                "name": "getSession",
                "parameters": [],
                "signature": "public abstract javax.jms.Session getSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getXAResource",
                "parameters": [],
                "signature": "public abstract javax.transaction.xa.XAResource getXAResource();",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Session": [
            {
                "name": "createBytesMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.BytesMessage createBytesMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createMapMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.MapMessage createMapMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.Message createMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [
                    "java.io.Serializable"
                ],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage(java.io.Serializable) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createStreamMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.StreamMessage createStreamMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.TextMessage createTextMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TextMessage createTextMessage(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getAcknowledgeMode",
                "parameters": [],
                "signature": "public abstract int getAcknowledgeMode() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "recover",
                "parameters": [],
                "signature": "public abstract void recover() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMessageListener",
                "parameters": [],
                "signature": "public abstract javax.jms.MessageListener getMessageListener() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setMessageListener",
                "parameters": [
                    "javax.jms.MessageListener"
                ],
                "signature": "public abstract void setMessageListener(javax.jms.MessageListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "run",
                "parameters": [],
                "signature": "public abstract void run();",
                "return_type": "void"
            },
            {
                "name": "createProducer",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.MessageProducer createProducer(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createConsumer(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createConsumer(javax.jms.Destination, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createConsumer(javax.jms.Destination, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic, java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createQueue",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Queue createQueue(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTopic",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Topic createTopic(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryQueue createTemporaryQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryTopic createTemporaryTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "unsubscribe",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void unsubscribe(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueSession": [
            {
                "name": "createQueue",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Queue createQueue(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createReceiver",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueReceiver createReceiver(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createReceiver",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueReceiver createReceiver(javax.jms.Queue, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSender",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueSender createSender(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryQueue createTemporaryQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ConnectionMetaData": [
            {
                "name": "getJMSVersion",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSMajorVersion",
                "parameters": [],
                "signature": "public abstract int getJMSMajorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSMinorVersion",
                "parameters": [],
                "signature": "public abstract int getJMSMinorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSProviderName",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSProviderName() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getProviderVersion",
                "parameters": [],
                "signature": "public abstract java.lang.String getProviderVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getProviderMajorVersion",
                "parameters": [],
                "signature": "public abstract int getProviderMajorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getProviderMinorVersion",
                "parameters": [],
                "signature": "public abstract int getProviderMinorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSXPropertyNames",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getJMSXPropertyNames() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ExceptionListener": [
            {
                "name": "onException",
                "parameters": [
                    "javax.jms.JMSException"
                ],
                "signature": "public abstract void onException(javax.jms.JMSException);",
                "return_type": "void"
            }
        ],
        "ServerSessionPool": [
            {
                "name": "getServerSession",
                "parameters": [],
                "signature": "public abstract javax.jms.ServerSession getServerSession() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ConnectionConsumer": [
            {
                "name": "getServerSessionPool",
                "parameters": [],
                "signature": "public abstract javax.jms.ServerSessionPool getServerSessionPool() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Topic": [
            {
                "name": "getTopicName",
                "parameters": [],
                "signature": "public abstract java.lang.String getTopicName() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            }
        ],
        "Queue": [
            {
                "name": "getQueueName",
                "parameters": [],
                "signature": "public abstract java.lang.String getQueueName() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            }
        ],
        "JMSProducer": [
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, javax.jms.Message);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "java.util.Map<java.lang.String",
                    "java.lang.Object>"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, java.util.Map<java.lang.String, java.lang.Object>);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "byte[]"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, byte[]);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "java.io.Serializable"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, java.io.Serializable);",
                "return_type": "void"
            },
            {
                "name": "setDisableMessageID",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDisableMessageID(boolean);",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageID",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageID();",
                "return_type": "void"
            },
            {
                "name": "setDisableMessageTimestamp",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDisableMessageTimestamp(boolean);",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageTimestamp",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageTimestamp();",
                "return_type": "void"
            },
            {
                "name": "setDeliveryMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDeliveryMode(int);",
                "return_type": "void"
            },
            {
                "name": "getDeliveryMode",
                "parameters": [],
                "signature": "public abstract int getDeliveryMode();",
                "return_type": "void"
            },
            {
                "name": "setPriority",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSProducer setPriority(int);",
                "return_type": "void"
            },
            {
                "name": "getPriority",
                "parameters": [],
                "signature": "public abstract int getPriority();",
                "return_type": "void"
            },
            {
                "name": "setTimeToLive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.JMSProducer setTimeToLive(long);",
                "return_type": "void"
            },
            {
                "name": "getTimeToLive",
                "parameters": [],
                "signature": "public abstract long getTimeToLive();",
                "return_type": "void"
            },
            {
                "name": "setDeliveryDelay",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDeliveryDelay(long);",
                "return_type": "void"
            },
            {
                "name": "getDeliveryDelay",
                "parameters": [],
                "signature": "public abstract long getDeliveryDelay();",
                "return_type": "void"
            },
            {
                "name": "setAsync",
                "parameters": [
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract javax.jms.JMSProducer setAsync(javax.jms.CompletionListener);",
                "return_type": "void"
            },
            {
                "name": "getAsync",
                "parameters": [],
                "signature": "public abstract javax.jms.CompletionListener getAsync();",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, boolean);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, byte);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, short);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, long);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, float);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, double);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "clearProperties",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSProducer clearProperties();",
                "return_type": "void"
            },
            {
                "name": "propertyExists",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean propertyExists(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getBooleanProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBooleanProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getByteProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByteProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getShortProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShortProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getIntProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getIntProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getLongProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLongProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getFloatProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloatProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getDoubleProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDoubleProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getStringProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getStringProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getObjectProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObjectProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getPropertyNames",
                "parameters": [],
                "signature": "public abstract java.util.Set<java.lang.String> getPropertyNames();",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationIDAsBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSCorrelationIDAsBytes(byte[]);",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationIDAsBytes",
                "parameters": [],
                "signature": "public abstract byte[] getJMSCorrelationIDAsBytes();",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSCorrelationID(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationID",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSCorrelationID();",
                "return_type": "void"
            },
            {
                "name": "setJMSType",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSType(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getJMSType",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSType();",
                "return_type": "void"
            },
            {
                "name": "setJMSReplyTo",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSReplyTo(javax.jms.Destination);",
                "return_type": "void"
            },
            {
                "name": "getJMSReplyTo",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getJMSReplyTo();",
                "return_type": "void"
            }
        ],
        "ObjectMessage": [
            {
                "name": "setObject",
                "parameters": [
                    "java.io.Serializable"
                ],
                "signature": "public abstract void setObject(java.io.Serializable) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [],
                "signature": "public abstract java.io.Serializable getObject() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TextMessage": [
            {
                "name": "setText",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setText(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getText",
                "parameters": [],
                "signature": "public abstract java.lang.String getText() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueBrowser": [
            {
                "name": "getQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.Queue getQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMessageSelector",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessageSelector() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getEnumeration",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getEnumeration() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TemporaryQueue": [
            {
                "name": "delete",
                "parameters": [],
                "signature": "public abstract void delete() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MessageListener": [
            {
                "name": "onMessage",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void onMessage(javax.jms.Message);",
                "return_type": "void"
            }
        ],
        "MessageConsumer": [
            {
                "name": "getMessageSelector",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessageSelector() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMessageListener",
                "parameters": [],
                "signature": "public abstract javax.jms.MessageListener getMessageListener() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setMessageListener",
                "parameters": [
                    "javax.jms.MessageListener"
                ],
                "signature": "public abstract void setMessageListener(javax.jms.MessageListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receive() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.Message receive(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "receiveNoWait",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receiveNoWait() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueReceiver": [
            {
                "name": "getQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.Queue getQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ServerSession": [
            {
                "name": "getSession",
                "parameters": [],
                "signature": "public abstract javax.jms.Session getSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "start",
                "parameters": [],
                "signature": "public abstract void start() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "JMSRuntimeException": [
            {
                "name": "javax.jms.JMSRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.JMSRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getErrorCode",
                "parameters": [],
                "signature": "public java.lang.String getErrorCode();",
                "return_type": "java.lang.String"
            }
        ],
        "JMSSecurityRuntimeException": [
            {
                "name": "javax.jms.JMSSecurityRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSSecurityRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSSecurityRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.JMSSecurityRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "TopicSession": [
            {
                "name": "createTopic",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Topic createTopic(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSubscriber",
                "parameters": [
                    "javax.jms.Topic"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createSubscriber(javax.jms.Topic) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createSubscriber(javax.jms.Topic, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createPublisher",
                "parameters": [
                    "javax.jms.Topic"
                ],
                "signature": "public abstract javax.jms.TopicPublisher createPublisher(javax.jms.Topic) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryTopic createTemporaryTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "unsubscribe",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void unsubscribe(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XATopicConnection": [
            {
                "name": "createXATopicSession",
                "parameters": [],
                "signature": "public abstract javax.jms.XATopicSession createXATopicSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTopicSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.TopicSession createTopicSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TopicConnection": [
            {
                "name": "createTopicSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.TopicSession createTopicSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createConnectionConsumer(javax.jms.Topic, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createDurableConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "InvalidClientIDException": [
            {
                "name": "javax.jms.InvalidClientIDException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidClientIDException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSDestinationDefinition": [
            {
                "name": "description",
                "parameters": [],
                "signature": "public abstract java.lang.String description();",
                "return_type": "void"
            },
            {
                "name": "name",
                "parameters": [],
                "signature": "public abstract java.lang.String name();",
                "return_type": "void"
            },
            {
                "name": "interfaceName",
                "parameters": [],
                "signature": "public abstract java.lang.String interfaceName();",
                "return_type": "void"
            },
            {
                "name": "className",
                "parameters": [],
                "signature": "public abstract java.lang.String className();",
                "return_type": "void"
            },
            {
                "name": "resourceAdapter",
                "parameters": [],
                "signature": "public abstract java.lang.String resourceAdapter();",
                "return_type": "void"
            },
            {
                "name": "destinationName",
                "parameters": [],
                "signature": "public abstract java.lang.String destinationName();",
                "return_type": "void"
            },
            {
                "name": "properties",
                "parameters": [],
                "signature": "public abstract java.lang.String[] properties();",
                "return_type": "void"
            }
        ],
        "ResourceAllocationException": [
            {
                "name": "javax.jms.ResourceAllocationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.ResourceAllocationException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSConnectionFactoryDefinition": [
            {
                "name": "description",
                "parameters": [],
                "signature": "public abstract java.lang.String description();",
                "return_type": "void"
            },
            {
                "name": "name",
                "parameters": [],
                "signature": "public abstract java.lang.String name();",
                "return_type": "void"
            },
            {
                "name": "interfaceName",
                "parameters": [],
                "signature": "public abstract java.lang.String interfaceName();",
                "return_type": "void"
            },
            {
                "name": "className",
                "parameters": [],
                "signature": "public abstract java.lang.String className();",
                "return_type": "void"
            },
            {
                "name": "resourceAdapter",
                "parameters": [],
                "signature": "public abstract java.lang.String resourceAdapter();",
                "return_type": "void"
            },
            {
                "name": "user",
                "parameters": [],
                "signature": "public abstract java.lang.String user();",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [],
                "signature": "public abstract java.lang.String password();",
                "return_type": "void"
            },
            {
                "name": "clientId",
                "parameters": [],
                "signature": "public abstract java.lang.String clientId();",
                "return_type": "void"
            },
            {
                "name": "properties",
                "parameters": [],
                "signature": "public abstract java.lang.String[] properties();",
                "return_type": "void"
            },
            {
                "name": "transactional",
                "parameters": [],
                "signature": "public abstract boolean transactional();",
                "return_type": "void"
            },
            {
                "name": "maxPoolSize",
                "parameters": [],
                "signature": "public abstract int maxPoolSize();",
                "return_type": "void"
            },
            {
                "name": "minPoolSize",
                "parameters": [],
                "signature": "public abstract int minPoolSize();",
                "return_type": "void"
            }
        ],
        "JMSPasswordCredential": [
            {
                "name": "userName",
                "parameters": [],
                "signature": "public abstract java.lang.String userName();",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [],
                "signature": "public abstract java.lang.String password();",
                "return_type": "void"
            }
        ],
        "JMSDestinationDefinitions": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSDestinationDefinition[] value();",
                "return_type": "void"
            }
        ],
        "TransactionRolledBackException": [
            {
                "name": "javax.jms.TransactionRolledBackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionRolledBackException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "XATopicConnectionFactory": [
            {
                "name": "createXATopicConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.XATopicConnection createXATopicConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXATopicConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XATopicConnection createXATopicConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "DeliveryMode": [],
        "MessageFormatRuntimeException": [
            {
                "name": "javax.jms.MessageFormatRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageFormatRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageFormatRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.MessageFormatRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "IllegalStateException": [
            {
                "name": "javax.jms.IllegalStateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.IllegalStateException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "MessageEOFException": [
            {
                "name": "javax.jms.MessageEOFException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageEOFException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageEOFException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageEOFException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSSessionMode": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract int value();",
                "return_type": "void"
            }
        ],
        "InvalidSelectorException": [
            {
                "name": "javax.jms.InvalidSelectorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidSelectorException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSConnectionFactoryDefinitions": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSConnectionFactoryDefinition[] value();",
                "return_type": "void"
            }
        ],
        "InvalidSelectorRuntimeException": [
            {
                "name": "javax.jms.InvalidSelectorRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidSelectorRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidSelectorRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.InvalidSelectorRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ]
    },
    "java.util": {
        "ArrayList": [
            {
                "name": "java.util.ArrayList",
                "parameters": [
                    "int"
                ],
                "signature": "public java.util.ArrayList(int);",
                "return_type": "void"
            },
            {
                "name": "java.util.ArrayList",
                "parameters": [],
                "signature": "public java.util.ArrayList();",
                "return_type": "void"
            },
            {
                "name": "java.util.ArrayList",
                "parameters": [
                    "java.util.Collection<? extends E>"
                ],
                "signature": "public java.util.ArrayList(java.util.Collection<? extends E>);",
                "return_type": "void"
            },
            {
                "name": "trimToSize",
                "parameters": [],
                "signature": "public void trimToSize();",
                "return_type": "void"
            },
            {
                "name": "ensureCapacity",
                "parameters": [
                    "int"
                ],
                "signature": "public void ensureCapacity(int);",
                "return_type": "void"
            },
            {
                "name": "grow",
                "parameters": [
                    "int"
                ],
                "signature": "private java.lang.Object[] grow(int);",
                "return_type": "void"
            },
            {
                "name": "grow",
                "parameters": [],
                "signature": "private java.lang.Object[] grow();",
                "return_type": "void"
            },
            {
                "name": "size",
                "parameters": [],
                "signature": "public int size();",
                "return_type": "int"
            },
            {
                "name": "isEmpty",
                "parameters": [],
                "signature": "public boolean isEmpty();",
                "return_type": "boolean"
            },
            {
                "name": "contains",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean contains(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "indexOf",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public int indexOf(java.lang.Object);",
                "return_type": "int"
            },
            {
                "name": "lastIndexOf",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public int lastIndexOf(java.lang.Object);",
                "return_type": "int"
            },
            {
                "name": "clone",
                "parameters": [],
                "signature": "public java.lang.Object clone();",
                "return_type": "java.lang.Object"
            },
            {
                "name": "toArray",
                "parameters": [],
                "signature": "public java.lang.Object[] toArray();",
                "return_type": "java.lang.Object[]"
            },
            {
                "name": "toArray",
                "parameters": [
                    "T[]"
                ],
                "signature": "public <T> T[] toArray(T[]);",
                "return_type": "void"
            },
            {
                "name": "get",
                "parameters": [
                    "int"
                ],
                "signature": "public E get(int);",
                "return_type": "E"
            },
            {
                "name": "getFirst",
                "parameters": [],
                "signature": "public E getFirst();",
                "return_type": "E"
            },
            {
                "name": "getLast",
                "parameters": [],
                "signature": "public E getLast();",
                "return_type": "E"
            },
            {
                "name": "set",
                "parameters": [
                    "int",
                    "E"
                ],
                "signature": "public E set(int, E);",
                "return_type": "E"
            },
            {
                "name": "add",
                "parameters": [
                    "E",
                    "java.lang.Object[]",
                    "int"
                ],
                "signature": "private void add(E, java.lang.Object[], int);",
                "return_type": "void"
            },
            {
                "name": "add",
                "parameters": [
                    "E"
                ],
                "signature": "public boolean add(E);",
                "return_type": "boolean"
            },
            {
                "name": "add",
                "parameters": [
                    "int",
                    "E"
                ],
                "signature": "public void add(int, E);",
                "return_type": "void"
            },
            {
                "name": "addFirst",
                "parameters": [
                    "E"
                ],
                "signature": "public void addFirst(E);",
                "return_type": "void"
            },
            {
                "name": "addLast",
                "parameters": [
                    "E"
                ],
                "signature": "public void addLast(E);",
                "return_type": "void"
            },
            {
                "name": "remove",
                "parameters": [
                    "int"
                ],
                "signature": "public E remove(int);",
                "return_type": "E"
            },
            {
                "name": "removeFirst",
                "parameters": [],
                "signature": "public E removeFirst();",
                "return_type": "E"
            },
            {
                "name": "removeLast",
                "parameters": [],
                "signature": "public E removeLast();",
                "return_type": "E"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "equalsArrayList",
                "parameters": [
                    "java.util.ArrayList<?>"
                ],
                "signature": "private boolean equalsArrayList(java.util.ArrayList<?>);",
                "return_type": "void"
            },
            {
                "name": "checkForComodification",
                "parameters": [
                    "int"
                ],
                "signature": "private void checkForComodification(int);",
                "return_type": "void"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "remove",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean remove(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "fastRemove",
                "parameters": [
                    "java.lang.Object[]",
                    "int"
                ],
                "signature": "private void fastRemove(java.lang.Object[], int);",
                "return_type": "void"
            },
            {
                "name": "clear",
                "parameters": [],
                "signature": "public void clear();",
                "return_type": "void"
            },
            {
                "name": "addAll",
                "parameters": [
                    "java.util.Collection<? extends E>"
                ],
                "signature": "public boolean addAll(java.util.Collection<? extends E>);",
                "return_type": "boolean"
            },
            {
                "name": "addAll",
                "parameters": [
                    "int",
                    "java.util.Collection<? extends E>"
                ],
                "signature": "public boolean addAll(int, java.util.Collection<? extends E>);",
                "return_type": "boolean"
            },
            {
                "name": "removeRange",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "protected void removeRange(int, int);",
                "return_type": "void"
            },
            {
                "name": "shiftTailOverGap",
                "parameters": [
                    "java.lang.Object[]",
                    "int",
                    "int"
                ],
                "signature": "private void shiftTailOverGap(java.lang.Object[], int, int);",
                "return_type": "void"
            },
            {
                "name": "rangeCheckForAdd",
                "parameters": [
                    "int"
                ],
                "signature": "private void rangeCheckForAdd(int);",
                "return_type": "void"
            },
            {
                "name": "outOfBoundsMsg",
                "parameters": [
                    "int"
                ],
                "signature": "private java.lang.String outOfBoundsMsg(int);",
                "return_type": "void"
            },
            {
                "name": "outOfBoundsMsg",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "private static java.lang.String outOfBoundsMsg(int, int);",
                "return_type": "void"
            },
            {
                "name": "removeAll",
                "parameters": [
                    "java.util.Collection<?>"
                ],
                "signature": "public boolean removeAll(java.util.Collection<?>);",
                "return_type": "boolean"
            },
            {
                "name": "retainAll",
                "parameters": [
                    "java.util.Collection<?>"
                ],
                "signature": "public boolean retainAll(java.util.Collection<?>);",
                "return_type": "boolean"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.io.ObjectOutputStream"
                ],
                "signature": "private void writeObject(java.io.ObjectOutputStream) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            },
            {
                "name": "listIterator",
                "parameters": [
                    "int"
                ],
                "signature": "public java.util.ListIterator<E> listIterator(int);",
                "return_type": "java.util.ListIterator<E>"
            },
            {
                "name": "listIterator",
                "parameters": [],
                "signature": "public java.util.ListIterator<E> listIterator();",
                "return_type": "java.util.ListIterator<E>"
            },
            {
                "name": "iterator",
                "parameters": [],
                "signature": "public java.util.Iterator<E> iterator();",
                "return_type": "java.util.Iterator<E>"
            },
            {
                "name": "subList",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public java.util.List<E> subList(int, int);",
                "return_type": "java.util.List<E>"
            },
            {
                "name": "forEach",
                "parameters": [
                    "java.util.function.Consumer<? super E>"
                ],
                "signature": "public void forEach(java.util.function.Consumer<? super E>);",
                "return_type": "void"
            },
            {
                "name": "spliterator",
                "parameters": [],
                "signature": "public java.util.Spliterator<E> spliterator();",
                "return_type": "java.util.Spliterator<E>"
            },
            {
                "name": "nBits",
                "parameters": [
                    "int"
                ],
                "signature": "private static long[] nBits(int);",
                "return_type": "void"
            },
            {
                "name": "setBit",
                "parameters": [
                    "long[]",
                    "int"
                ],
                "signature": "private static void setBit(long[], int);",
                "return_type": "void"
            },
            {
                "name": "isClear",
                "parameters": [
                    "long[]",
                    "int"
                ],
                "signature": "private static boolean isClear(long[], int);",
                "return_type": "void"
            },
            {
                "name": "removeIf",
                "parameters": [
                    "java.util.function.Predicate<? super E>"
                ],
                "signature": "public boolean removeIf(java.util.function.Predicate<? super E>);",
                "return_type": "boolean"
            },
            {
                "name": "replaceAll",
                "parameters": [
                    "java.util.function.UnaryOperator<E>"
                ],
                "signature": "public void replaceAll(java.util.function.UnaryOperator<E>);",
                "return_type": "void"
            },
            {
                "name": "replaceAllRange",
                "parameters": [
                    "java.util.function.UnaryOperator<E>",
                    "int",
                    "int"
                ],
                "signature": "private void replaceAllRange(java.util.function.UnaryOperator<E>, int, int);",
                "return_type": "void"
            },
            {
                "name": "sort",
                "parameters": [
                    "java.util.Comparator<? super E>"
                ],
                "signature": "public void sort(java.util.Comparator<? super E>);",
                "return_type": "void"
            },
            {
                "name": "sortRange",
                "parameters": [
                    "java.util.Comparator<? super E>",
                    "int",
                    "int"
                ],
                "signature": "private void sortRange(java.util.Comparator<? super E>, int, int);",
                "return_type": "void"
            }
        ]
    }
}

