# Auto-generated by java_generate.py
# flake8: noqa

from typing import Dict, List, TypedDict

class FieldInfo(TypedDict):
    name: str
    type: str
    signature: str

FieldsDict = Dict[str, Dict[str, List[FieldInfo]]]

JAVA_FIELDS: FieldsDict = {
    "javax.jms": {
        "BytesMessage": [],
        "MapMessage": [],
        "JMSConsumer": [],
        "TemporaryTopic": [],
        "MessageProducer": [],
        "TopicSubscriber": [],
        "QueueSender": [],
        "CompletionListener": [],
        "TopicRequestor": [],
        "TopicPublisher": [],
        "XATopicSession": [],
        "MessageFormatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JMSConnectionFactory": [],
        "InvalidDestinationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvalidDestinationRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TopicConnectionFactory": [],
        "ResourceAllocationRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TransactionInProgressRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MessageNotWriteableException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MessageNotReadableException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "QueueRequestor": [],
        "TransactionInProgressException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TransactionRolledBackRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvalidClientIDRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MessageNotWriteableRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JMSSecurityException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalStateRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StreamMessage": [],
        "Message": [
            [
                "DEFAULT_DELIVERY_MODE",
                "int"
            ],
            [
                "DEFAULT_PRIORITY",
                "int"
            ],
            [
                "DEFAULT_TIME_TO_LIVE",
                "long"
            ],
            [
                "DEFAULT_DELIVERY_DELAY",
                "long"
            ]
        ],
        "JMSException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "errorCode",
                "java.lang.String"
            ],
            [
                "linkedException",
                "java.lang.Exception"
            ]
        ],
        "Destination": [],
        "XAQueueConnectionFactory": [],
        "XAConnectionFactory": [],
        "QueueConnectionFactory": [],
        "ConnectionFactory": [],
        "XAQueueConnection": [],
        "XAConnection": [],
        "Connection": [],
        "QueueConnection": [],
        "XAJMSContext": [],
        "JMSContext": [
            [
                "AUTO_ACKNOWLEDGE",
                "int"
            ],
            [
                "CLIENT_ACKNOWLEDGE",
                "int"
            ],
            [
                "DUPS_OK_ACKNOWLEDGE",
                "int"
            ],
            [
                "SESSION_TRANSACTED",
                "int"
            ]
        ],
        "XAQueueSession": [],
        "XASession": [],
        "Session": [
            [
                "AUTO_ACKNOWLEDGE",
                "int"
            ],
            [
                "CLIENT_ACKNOWLEDGE",
                "int"
            ],
            [
                "DUPS_OK_ACKNOWLEDGE",
                "int"
            ],
            [
                "SESSION_TRANSACTED",
                "int"
            ]
        ],
        "QueueSession": [],
        "ConnectionMetaData": [],
        "ExceptionListener": [],
        "ServerSessionPool": [],
        "ConnectionConsumer": [],
        "Topic": [],
        "Queue": [],
        "JMSProducer": [],
        "ObjectMessage": [],
        "TextMessage": [],
        "QueueBrowser": [],
        "TemporaryQueue": [],
        "MessageListener": [],
        "MessageConsumer": [],
        "QueueReceiver": [],
        "ServerSession": [],
        "JMSRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "errorCode",
                "java.lang.String"
            ]
        ],
        "JMSSecurityRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TopicSession": [],
        "XATopicConnection": [],
        "TopicConnection": [],
        "InvalidClientIDException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JMSDestinationDefinition": [],
        "ResourceAllocationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JMSConnectionFactoryDefinition": [],
        "JMSPasswordCredential": [],
        "JMSDestinationDefinitions": [],
        "TransactionRolledBackException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "XATopicConnectionFactory": [],
        "DeliveryMode": [
            [
                "NON_PERSISTENT",
                "int"
            ],
            [
                "PERSISTENT",
                "int"
            ]
        ],
        "MessageFormatRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalStateException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MessageEOFException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JMSSessionMode": [],
        "InvalidSelectorException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JMSConnectionFactoryDefinitions": [],
        "InvalidSelectorRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "javax.security.sasl": {
        "AuthenticationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AuthorizeCallback": [
            [
                "authenticationID",
                "java.lang.String"
            ],
            [
                "authorizationID",
                "java.lang.String"
            ],
            [
                "authorizedID",
                "java.lang.String"
            ],
            [
                "authorized",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RealmCallback": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RealmChoiceCallback": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Sasl": [
            [
                "disabledMechanisms",
                "java.util.List<java.lang.String>"
            ],
            [
                "SASL_LOGGER_NAME",
                "java.lang.String"
            ],
            [
                "logger",
                "java.util.logging.Logger"
            ],
            [
                "QOP",
                "java.lang.String"
            ],
            [
                "STRENGTH",
                "java.lang.String"
            ],
            [
                "SERVER_AUTH",
                "java.lang.String"
            ],
            [
                "BOUND_SERVER_NAME",
                "java.lang.String"
            ],
            [
                "MAX_BUFFER",
                "java.lang.String"
            ],
            [
                "RAW_SEND_SIZE",
                "java.lang.String"
            ],
            [
                "REUSE",
                "java.lang.String"
            ],
            [
                "POLICY_NOPLAINTEXT",
                "java.lang.String"
            ],
            [
                "POLICY_NOACTIVE",
                "java.lang.String"
            ],
            [
                "POLICY_NODICTIONARY",
                "java.lang.String"
            ],
            [
                "POLICY_NOANONYMOUS",
                "java.lang.String"
            ],
            [
                "POLICY_FORWARD_SECRECY",
                "java.lang.String"
            ],
            [
                "POLICY_PASS_CREDENTIALS",
                "java.lang.String"
            ],
            [
                "CREDENTIALS",
                "java.lang.String"
            ]
        ],
        "SaslClient": [],
        "SaslClientFactory": [],
        "SaslException": [
            [
                "_exception",
                "java.lang.Throwable"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SaslServer": [],
        "SaslServerFactory": []
    },
    "jdk.security.jarsigner": {
        "JarSigner": [
            [
                "privateKey",
                "java.security.PrivateKey"
            ],
            [
                "certChain",
                "java.security.cert.X509Certificate[]"
            ],
            [
                "digestalg",
                "java.lang.String[]"
            ],
            [
                "sigalg",
                "java.lang.String"
            ],
            [
                "digestProvider",
                "java.security.Provider"
            ],
            [
                "sigProvider",
                "java.security.Provider"
            ],
            [
                "tsaUrl",
                "java.net.URI"
            ],
            [
                "signerName",
                "java.lang.String"
            ],
            [
                "handler",
                "java.lang.String>"
            ],
            [
                "tSAPolicyID",
                "java.lang.String"
            ],
            [
                "tSADigestAlg",
                "java.lang.String"
            ],
            [
                "sectionsonly",
                "boolean"
            ],
            [
                "internalsf",
                "boolean"
            ],
            [
                "externalFileAttributesDetected",
                "boolean"
            ]
        ],
        "JarSignerException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "jdk.nio.zipfs": {
        "ByteArrayChannel": [
            [
                "rwlock",
                "java.util.concurrent.locks.ReadWriteLock"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "pos",
                "int"
            ],
            [
                "last",
                "int"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "readonly",
                "boolean"
            ],
            [
                "MAX_ARRAY_SIZE",
                "int"
            ]
        ],
        "ZipCoder": [
            [
                "utf8",
                "jdk.nio.zipfs.ZipCoder"
            ],
            [
                "cs",
                "java.nio.charset.Charset"
            ],
            [
                "decTL",
                "java.lang.ThreadLocal<java.nio.charset.CharsetDecoder>"
            ],
            [
                "encTL",
                "java.lang.ThreadLocal<java.nio.charset.CharsetEncoder>"
            ]
        ],
        "ZipConstants": [],
        "ZipDirectoryStream": [
            [
                "zipfs",
                "jdk.nio.zipfs.ZipFileSystem"
            ],
            [
                "dir",
                "jdk.nio.zipfs.ZipPath"
            ],
            [
                "filter",
                "java.nio.file.Path>"
            ],
            [
                "isClosed",
                "boolean"
            ],
            [
                "itr",
                "java.util.Iterator<java.nio.file.Path>"
            ]
        ],
        "ZipFileAttributeView": [
            [
                "isZipView",
                "boolean"
            ]
        ],
        "ZipFileAttributes": [],
        "ZipFileStore": [
            [
                "zfs",
                "jdk.nio.zipfs.ZipFileSystem"
            ]
        ],
        "ZipFileSystem": [
            [
                "isWindows",
                "boolean"
            ],
            [
                "ROOTPATH",
                "byte[]"
            ],
            [
                "PROPERTY_POSIX",
                "java.lang.String"
            ],
            [
                "PROPERTY_DEFAULT_OWNER",
                "java.lang.String"
            ],
            [
                "PROPERTY_DEFAULT_GROUP",
                "java.lang.String"
            ],
            [
                "PROPERTY_DEFAULT_PERMISSIONS",
                "java.lang.String"
            ],
            [
                "PROPERTY_RELEASE_VERSION",
                "java.lang.String"
            ],
            [
                "PROPERTY_MULTI_RELEASE",
                "java.lang.String"
            ],
            [
                "DEFAULT_PERMISSIONS",
                "java.util.Set<java.nio.file.attribute.PosixFilePermission>"
            ],
            [
                "PROPERTY_COMPRESSION_METHOD",
                "java.lang.String"
            ],
            [
                "COMPRESSION_METHOD_DEFLATED",
                "java.lang.String"
            ],
            [
                "COMPRESSION_METHOD_STORED",
                "java.lang.String"
            ],
            [
                "provider",
                "jdk.nio.zipfs.ZipFileSystemProvider"
            ],
            [
                "zfpath",
                "java.nio.file.Path"
            ],
            [
                "rootdir",
                "jdk.nio.zipfs.ZipPath"
            ],
            [
                "readOnly",
                "boolean"
            ],
            [
                "zfsDefaultTimeStamp",
                "long"
            ],
            [
                "noExtt",
                "boolean"
            ],
            [
                "useTempFile",
                "boolean"
            ],
            [
                "tempFileCreationThreshold",
                "int"
            ],
            [
                "forceEnd64",
                "boolean"
            ],
            [
                "defaultCompressionMethod",
                "int"
            ],
            [
                "entryLookup",
                "byte[]>"
            ],
            [
                "defaultOwner",
                "java.nio.file.attribute.UserPrincipal"
            ],
            [
                "defaultGroup",
                "java.nio.file.attribute.GroupPrincipal"
            ],
            [
                "defaultPermissions",
                "java.util.Set<java.nio.file.attribute.PosixFilePermission>"
            ],
            [
                "supportedFileAttributeViews",
                "java.util.Set<java.lang.String>"
            ],
            [
                "GLOB_SYNTAX",
                "java.lang.String"
            ],
            [
                "REGEX_SYNTAX",
                "java.lang.String"
            ],
            [
                "streams",
                "java.util.Set<java.io.InputStream>"
            ],
            [
                "tmppaths",
                "java.util.Set<java.nio.file.Path>"
            ],
            [
                "isOpen",
                "boolean"
            ],
            [
                "ch",
                "java.nio.channels.SeekableByteChannel"
            ],
            [
                "end",
                "jdk.nio.zipfs.ZipFileSystem$END"
            ],
            [
                "locpos",
                "long"
            ],
            [
                "rwlock",
                "java.util.concurrent.locks.ReadWriteLock"
            ],
            [
                "inodes",
                "jdk.nio.zipfs.ZipFileSystem$IndexNode>"
            ],
            [
                "hasUpdate",
                "boolean"
            ],
            [
                "LOOKUPKEY",
                "jdk.nio.zipfs.ZipFileSystem$IndexNode"
            ],
            [
                "MAX_FLATER",
                "int"
            ],
            [
                "inflaters",
                "java.util.List<java.util.zip.Inflater>"
            ],
            [
                "deflaters",
                "java.util.List<java.util.zip.Deflater>"
            ]
        ],
        "ZipFileSystemProvider": [
            [
                "filesystems",
                "jdk.nio.zipfs.ZipFileSystem>"
            ]
        ],
        "ZipInfo": [],
        "ZipPath": [
            [
                "zfs",
                "jdk.nio.zipfs.ZipFileSystem"
            ],
            [
                "path",
                "byte[]"
            ],
            [
                "offsets",
                "int[]"
            ],
            [
                "hashcode",
                "int"
            ],
            [
                "resolved",
                "byte[]"
            ]
        ],
        "ZipPosixFileAttributeView": [
            [
                "isOwnerView",
                "boolean"
            ]
        ],
        "ZipUtils": [
            [
                "WINDOWS_EPOCH_IN_MICROSECONDS",
                "long"
            ],
            [
                "regexMetaChars",
                "java.lang.String"
            ],
            [
                "globMetaChars",
                "java.lang.String"
            ],
            [
                "EOL",
                "char"
            ]
        ]
    },
    "java.sql": {
        "Array": [],
        "BatchUpdateException": [
            [
                "updateCounts",
                "int[]"
            ],
            [
                "longUpdateCounts",
                "long[]"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Blob": [],
        "CallableStatement": [],
        "ClientInfoStatus": [
            [
                "REASON_UNKNOWN",
                "java.sql.ClientInfoStatus"
            ],
            [
                "REASON_UNKNOWN_PROPERTY",
                "java.sql.ClientInfoStatus"
            ],
            [
                "REASON_VALUE_INVALID",
                "java.sql.ClientInfoStatus"
            ],
            [
                "REASON_VALUE_TRUNCATED",
                "java.sql.ClientInfoStatus"
            ],
            [
                "$VALUES",
                "java.sql.ClientInfoStatus[]"
            ]
        ],
        "Clob": [],
        "Connection": [
            [
                "TRANSACTION_NONE",
                "int"
            ],
            [
                "TRANSACTION_READ_UNCOMMITTED",
                "int"
            ],
            [
                "TRANSACTION_READ_COMMITTED",
                "int"
            ],
            [
                "TRANSACTION_REPEATABLE_READ",
                "int"
            ],
            [
                "TRANSACTION_SERIALIZABLE",
                "int"
            ]
        ],
        "ConnectionBuilder": [],
        "DataTruncation": [
            [
                "index",
                "int"
            ],
            [
                "parameter",
                "boolean"
            ],
            [
                "read",
                "boolean"
            ],
            [
                "dataSize",
                "int"
            ],
            [
                "transferSize",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DatabaseMetaData": [
            [
                "procedureResultUnknown",
                "int"
            ],
            [
                "procedureNoResult",
                "int"
            ],
            [
                "procedureReturnsResult",
                "int"
            ],
            [
                "procedureColumnUnknown",
                "int"
            ],
            [
                "procedureColumnIn",
                "int"
            ],
            [
                "procedureColumnInOut",
                "int"
            ],
            [
                "procedureColumnOut",
                "int"
            ],
            [
                "procedureColumnReturn",
                "int"
            ],
            [
                "procedureColumnResult",
                "int"
            ],
            [
                "procedureNoNulls",
                "int"
            ],
            [
                "procedureNullable",
                "int"
            ],
            [
                "procedureNullableUnknown",
                "int"
            ],
            [
                "columnNoNulls",
                "int"
            ],
            [
                "columnNullable",
                "int"
            ],
            [
                "columnNullableUnknown",
                "int"
            ],
            [
                "bestRowTemporary",
                "int"
            ],
            [
                "bestRowTransaction",
                "int"
            ],
            [
                "bestRowSession",
                "int"
            ],
            [
                "bestRowUnknown",
                "int"
            ],
            [
                "bestRowNotPseudo",
                "int"
            ],
            [
                "bestRowPseudo",
                "int"
            ],
            [
                "versionColumnUnknown",
                "int"
            ],
            [
                "versionColumnNotPseudo",
                "int"
            ],
            [
                "versionColumnPseudo",
                "int"
            ],
            [
                "importedKeyCascade",
                "int"
            ],
            [
                "importedKeyRestrict",
                "int"
            ],
            [
                "importedKeySetNull",
                "int"
            ],
            [
                "importedKeyNoAction",
                "int"
            ],
            [
                "importedKeySetDefault",
                "int"
            ],
            [
                "importedKeyInitiallyDeferred",
                "int"
            ],
            [
                "importedKeyInitiallyImmediate",
                "int"
            ],
            [
                "importedKeyNotDeferrable",
                "int"
            ],
            [
                "typeNoNulls",
                "int"
            ],
            [
                "typeNullable",
                "int"
            ],
            [
                "typeNullableUnknown",
                "int"
            ],
            [
                "typePredNone",
                "int"
            ],
            [
                "typePredChar",
                "int"
            ],
            [
                "typePredBasic",
                "int"
            ],
            [
                "typeSearchable",
                "int"
            ],
            [
                "tableIndexStatistic",
                "short"
            ],
            [
                "tableIndexClustered",
                "short"
            ],
            [
                "tableIndexHashed",
                "short"
            ],
            [
                "tableIndexOther",
                "short"
            ],
            [
                "attributeNoNulls",
                "short"
            ],
            [
                "attributeNullable",
                "short"
            ],
            [
                "attributeNullableUnknown",
                "short"
            ],
            [
                "sqlStateXOpen",
                "int"
            ],
            [
                "sqlStateSQL",
                "int"
            ],
            [
                "sqlStateSQL99",
                "int"
            ],
            [
                "functionColumnUnknown",
                "int"
            ],
            [
                "functionColumnIn",
                "int"
            ],
            [
                "functionColumnInOut",
                "int"
            ],
            [
                "functionColumnOut",
                "int"
            ],
            [
                "functionReturn",
                "int"
            ],
            [
                "functionColumnResult",
                "int"
            ],
            [
                "functionNoNulls",
                "int"
            ],
            [
                "functionNullable",
                "int"
            ],
            [
                "functionNullableUnknown",
                "int"
            ],
            [
                "functionResultUnknown",
                "int"
            ],
            [
                "functionNoTable",
                "int"
            ],
            [
                "functionReturnsTable",
                "int"
            ]
        ],
        "Date": [],
        "Driver": [],
        "DriverAction": [],
        "DriverInfo": [],
        "DriverManager": [
            [
                "registeredDrivers",
                "java.util.concurrent.CopyOnWriteArrayList<java.sql.DriverInfo>"
            ],
            [
                "loginTimeout",
                "int"
            ],
            [
                "logWriter",
                "java.io.PrintWriter"
            ],
            [
                "logStream",
                "java.io.PrintStream"
            ],
            [
                "logSync",
                "java.lang.Object"
            ],
            [
                "lockForInitDrivers",
                "java.lang.Object"
            ],
            [
                "driversInitialized",
                "boolean"
            ],
            [
                "JDBC_DRIVERS_PROPERTY",
                "java.lang.String"
            ]
        ],
        "DriverPropertyInfo": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "required",
                "boolean"
            ],
            [
                "value",
                "java.lang.String"
            ],
            [
                "choices",
                "java.lang.String[]"
            ]
        ],
        "JDBCType": [
            [
                "BIT",
                "java.sql.JDBCType"
            ],
            [
                "TINYINT",
                "java.sql.JDBCType"
            ],
            [
                "SMALLINT",
                "java.sql.JDBCType"
            ],
            [
                "INTEGER",
                "java.sql.JDBCType"
            ],
            [
                "BIGINT",
                "java.sql.JDBCType"
            ],
            [
                "FLOAT",
                "java.sql.JDBCType"
            ],
            [
                "REAL",
                "java.sql.JDBCType"
            ],
            [
                "DOUBLE",
                "java.sql.JDBCType"
            ],
            [
                "NUMERIC",
                "java.sql.JDBCType"
            ],
            [
                "DECIMAL",
                "java.sql.JDBCType"
            ],
            [
                "CHAR",
                "java.sql.JDBCType"
            ],
            [
                "VARCHAR",
                "java.sql.JDBCType"
            ],
            [
                "LONGVARCHAR",
                "java.sql.JDBCType"
            ],
            [
                "DATE",
                "java.sql.JDBCType"
            ],
            [
                "TIME",
                "java.sql.JDBCType"
            ],
            [
                "TIMESTAMP",
                "java.sql.JDBCType"
            ],
            [
                "BINARY",
                "java.sql.JDBCType"
            ],
            [
                "VARBINARY",
                "java.sql.JDBCType"
            ],
            [
                "LONGVARBINARY",
                "java.sql.JDBCType"
            ],
            [
                "NULL",
                "java.sql.JDBCType"
            ],
            [
                "OTHER",
                "java.sql.JDBCType"
            ],
            [
                "JAVA_OBJECT",
                "java.sql.JDBCType"
            ],
            [
                "DISTINCT",
                "java.sql.JDBCType"
            ],
            [
                "STRUCT",
                "java.sql.JDBCType"
            ],
            [
                "ARRAY",
                "java.sql.JDBCType"
            ],
            [
                "BLOB",
                "java.sql.JDBCType"
            ],
            [
                "CLOB",
                "java.sql.JDBCType"
            ],
            [
                "REF",
                "java.sql.JDBCType"
            ],
            [
                "DATALINK",
                "java.sql.JDBCType"
            ],
            [
                "BOOLEAN",
                "java.sql.JDBCType"
            ],
            [
                "ROWID",
                "java.sql.JDBCType"
            ],
            [
                "NCHAR",
                "java.sql.JDBCType"
            ],
            [
                "NVARCHAR",
                "java.sql.JDBCType"
            ],
            [
                "LONGNVARCHAR",
                "java.sql.JDBCType"
            ],
            [
                "NCLOB",
                "java.sql.JDBCType"
            ],
            [
                "SQLXML",
                "java.sql.JDBCType"
            ],
            [
                "REF_CURSOR",
                "java.sql.JDBCType"
            ],
            [
                "TIME_WITH_TIMEZONE",
                "java.sql.JDBCType"
            ],
            [
                "TIMESTAMP_WITH_TIMEZONE",
                "java.sql.JDBCType"
            ],
            [
                "type",
                "java.lang.Integer"
            ],
            [
                "$VALUES",
                "java.sql.JDBCType[]"
            ]
        ],
        "NClob": [],
        "ParameterMetaData": [
            [
                "parameterNoNulls",
                "int"
            ],
            [
                "parameterNullable",
                "int"
            ],
            [
                "parameterNullableUnknown",
                "int"
            ],
            [
                "parameterModeUnknown",
                "int"
            ],
            [
                "parameterModeIn",
                "int"
            ],
            [
                "parameterModeInOut",
                "int"
            ],
            [
                "parameterModeOut",
                "int"
            ]
        ],
        "PreparedStatement": [],
        "PseudoColumnUsage": [
            [
                "SELECT_LIST_ONLY",
                "java.sql.PseudoColumnUsage"
            ],
            [
                "WHERE_CLAUSE_ONLY",
                "java.sql.PseudoColumnUsage"
            ],
            [
                "NO_USAGE_RESTRICTIONS",
                "java.sql.PseudoColumnUsage"
            ],
            [
                "USAGE_UNKNOWN",
                "java.sql.PseudoColumnUsage"
            ],
            [
                "$VALUES",
                "java.sql.PseudoColumnUsage[]"
            ]
        ],
        "Ref": [],
        "ResultSet": [
            [
                "FETCH_FORWARD",
                "int"
            ],
            [
                "FETCH_REVERSE",
                "int"
            ],
            [
                "FETCH_UNKNOWN",
                "int"
            ],
            [
                "TYPE_FORWARD_ONLY",
                "int"
            ],
            [
                "TYPE_SCROLL_INSENSITIVE",
                "int"
            ],
            [
                "TYPE_SCROLL_SENSITIVE",
                "int"
            ],
            [
                "CONCUR_READ_ONLY",
                "int"
            ],
            [
                "CONCUR_UPDATABLE",
                "int"
            ],
            [
                "HOLD_CURSORS_OVER_COMMIT",
                "int"
            ],
            [
                "CLOSE_CURSORS_AT_COMMIT",
                "int"
            ]
        ],
        "ResultSetMetaData": [
            [
                "columnNoNulls",
                "int"
            ],
            [
                "columnNullable",
                "int"
            ],
            [
                "columnNullableUnknown",
                "int"
            ]
        ],
        "RowId": [],
        "RowIdLifetime": [
            [
                "ROWID_UNSUPPORTED",
                "java.sql.RowIdLifetime"
            ],
            [
                "ROWID_VALID_OTHER",
                "java.sql.RowIdLifetime"
            ],
            [
                "ROWID_VALID_SESSION",
                "java.sql.RowIdLifetime"
            ],
            [
                "ROWID_VALID_TRANSACTION",
                "java.sql.RowIdLifetime"
            ],
            [
                "ROWID_VALID_FOREVER",
                "java.sql.RowIdLifetime"
            ],
            [
                "$VALUES",
                "java.sql.RowIdLifetime[]"
            ]
        ],
        "SQLClientInfoException": [
            [
                "failedProperties",
                "java.sql.ClientInfoStatus>"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLData": [],
        "SQLDataException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLException": [
            [
                "SQLState",
                "java.lang.String"
            ],
            [
                "vendorCode",
                "int"
            ],
            [
                "next",
                "java.sql.SQLException"
            ],
            [
                "nextUpdater",
                "java.sql.SQLException>"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLFeatureNotSupportedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLInput": [],
        "SQLIntegrityConstraintViolationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLInvalidAuthorizationSpecException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLNonTransientConnectionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLNonTransientException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLOutput": [],
        "SQLPermission": [],
        "SQLRecoverableException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLSyntaxErrorException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLTimeoutException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLTransactionRollbackException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLTransientConnectionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLTransientException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLType": [],
        "SQLWarning": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SQLXML": [],
        "Savepoint": [],
        "ShardingKey": [],
        "ShardingKeyBuilder": [],
        "Statement": [
            [
                "CLOSE_CURRENT_RESULT",
                "int"
            ],
            [
                "KEEP_CURRENT_RESULT",
                "int"
            ],
            [
                "CLOSE_ALL_RESULTS",
                "int"
            ],
            [
                "SUCCESS_NO_INFO",
                "int"
            ],
            [
                "EXECUTE_FAILED",
                "int"
            ],
            [
                "RETURN_GENERATED_KEYS",
                "int"
            ],
            [
                "NO_GENERATED_KEYS",
                "int"
            ]
        ],
        "Struct": [],
        "Time": [],
        "Timestamp": [
            [
                "nanos",
                "int"
            ],
            [
                "MILLIS_PER_SECOND",
                "int"
            ]
        ],
        "Types": [
            [
                "BIT",
                "int"
            ],
            [
                "TINYINT",
                "int"
            ],
            [
                "SMALLINT",
                "int"
            ],
            [
                "INTEGER",
                "int"
            ],
            [
                "BIGINT",
                "int"
            ],
            [
                "FLOAT",
                "int"
            ],
            [
                "REAL",
                "int"
            ],
            [
                "DOUBLE",
                "int"
            ],
            [
                "NUMERIC",
                "int"
            ],
            [
                "DECIMAL",
                "int"
            ],
            [
                "CHAR",
                "int"
            ],
            [
                "VARCHAR",
                "int"
            ],
            [
                "LONGVARCHAR",
                "int"
            ],
            [
                "DATE",
                "int"
            ],
            [
                "TIME",
                "int"
            ],
            [
                "TIMESTAMP",
                "int"
            ],
            [
                "BINARY",
                "int"
            ],
            [
                "VARBINARY",
                "int"
            ],
            [
                "LONGVARBINARY",
                "int"
            ],
            [
                "NULL",
                "int"
            ],
            [
                "OTHER",
                "int"
            ],
            [
                "JAVA_OBJECT",
                "int"
            ],
            [
                "DISTINCT",
                "int"
            ],
            [
                "STRUCT",
                "int"
            ],
            [
                "ARRAY",
                "int"
            ],
            [
                "BLOB",
                "int"
            ],
            [
                "CLOB",
                "int"
            ],
            [
                "REF",
                "int"
            ],
            [
                "DATALINK",
                "int"
            ],
            [
                "BOOLEAN",
                "int"
            ],
            [
                "ROWID",
                "int"
            ],
            [
                "NCHAR",
                "int"
            ],
            [
                "NVARCHAR",
                "int"
            ],
            [
                "LONGNVARCHAR",
                "int"
            ],
            [
                "NCLOB",
                "int"
            ],
            [
                "SQLXML",
                "int"
            ],
            [
                "REF_CURSOR",
                "int"
            ],
            [
                "TIME_WITH_TIMEZONE",
                "int"
            ],
            [
                "TIMESTAMP_WITH_TIMEZONE",
                "int"
            ]
        ],
        "Wrapper": []
    },
    "javax.sql": {
        "CommonDataSource": [],
        "ConnectionEvent": [
            [
                "ex",
                "java.sql.SQLException"
            ]
        ],
        "ConnectionEventListener": [],
        "ConnectionPoolDataSource": [],
        "DataSource": [],
        "PooledConnection": [],
        "PooledConnectionBuilder": [],
        "RowSet": [],
        "RowSetEvent": [],
        "RowSetInternal": [],
        "RowSetListener": [],
        "RowSetMetaData": [],
        "RowSetReader": [],
        "RowSetWriter": [],
        "StatementEvent": [
            [
                "exception",
                "java.sql.SQLException"
            ],
            [
                "statement",
                "java.sql.PreparedStatement"
            ]
        ],
        "StatementEventListener": [],
        "XAConnection": [],
        "XAConnectionBuilder": [],
        "XADataSource": []
    },
    "javax.smartcardio": {
        "ATR": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "atr",
                "byte[]"
            ],
            [
                "startHistorical",
                "int"
            ],
            [
                "nHistorical",
                "int"
            ]
        ],
        "Card": [],
        "CardChannel": [],
        "CardException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CardNotPresentException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CardPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "A_CONNECT",
                "int"
            ],
            [
                "A_EXCLUSIVE",
                "int"
            ],
            [
                "A_GET_BASIC_CHANNEL",
                "int"
            ],
            [
                "A_OPEN_LOGICAL_CHANNEL",
                "int"
            ],
            [
                "A_RESET",
                "int"
            ],
            [
                "A_TRANSMIT_CONTROL",
                "int"
            ],
            [
                "A_ALL",
                "int"
            ],
            [
                "ARRAY_MASKS",
                "int[]"
            ],
            [
                "S_CONNECT",
                "java.lang.String"
            ],
            [
                "S_EXCLUSIVE",
                "java.lang.String"
            ],
            [
                "S_GET_BASIC_CHANNEL",
                "java.lang.String"
            ],
            [
                "S_OPEN_LOGICAL_CHANNEL",
                "java.lang.String"
            ],
            [
                "S_RESET",
                "java.lang.String"
            ],
            [
                "S_TRANSMIT_CONTROL",
                "java.lang.String"
            ],
            [
                "S_ALL",
                "java.lang.String"
            ],
            [
                "ARRAY_STRINGS",
                "java.lang.String[]"
            ],
            [
                "mask",
                "int"
            ],
            [
                "actions",
                "java.lang.String"
            ]
        ],
        "CardTerminal": [],
        "CardTerminals": [],
        "CommandAPDU": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "MAX_APDU_SIZE",
                "int"
            ],
            [
                "apdu",
                "byte[]"
            ],
            [
                "nc",
                "int"
            ],
            [
                "ne",
                "int"
            ],
            [
                "dataOffset",
                "int"
            ]
        ],
        "ResponseAPDU": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "apdu",
                "byte[]"
            ]
        ],
        "TerminalFactory": [
            [
                "PROP_NAME",
                "java.lang.String"
            ],
            [
                "defaultType",
                "java.lang.String"
            ],
            [
                "defaultFactory",
                "javax.smartcardio.TerminalFactory"
            ],
            [
                "spi",
                "javax.smartcardio.TerminalFactorySpi"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "type",
                "java.lang.String"
            ]
        ],
        "TerminalFactorySpi": []
    },
    "javax.annotation.processing": {
        "AbstractProcessor": [
            [
                "processingEnv",
                "javax.annotation.processing.ProcessingEnvironment"
            ],
            [
                "initialized",
                "boolean"
            ]
        ],
        "Completion": [],
        "Completions": [],
        "Filer": [],
        "FilerException": [],
        "Generated": [],
        "Messager": [],
        "ProcessingEnvironment": [],
        "Processor": [],
        "RoundEnvironment": [],
        "SupportedAnnotationTypes": [],
        "SupportedOptions": [],
        "SupportedSourceVersion": []
    },
    "javax.lang.model": {
        "AnnotatedConstruct": [],
        "SourceVersion": [
            [
                "RELEASE_0",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_1",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_2",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_3",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_4",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_5",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_6",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_7",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_8",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_9",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_10",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_11",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_12",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_13",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_14",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_15",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_16",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_17",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_18",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_19",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_20",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_21",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_22",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_23",
                "javax.lang.model.SourceVersion"
            ],
            [
                "RELEASE_24",
                "javax.lang.model.SourceVersion"
            ],
            [
                "latestSupported",
                "javax.lang.model.SourceVersion"
            ],
            [
                "$VALUES",
                "javax.lang.model.SourceVersion[]"
            ]
        ],
        "UnknownEntityException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "javax.lang.model.element": {
        "AnnotationMirror": [],
        "AnnotationValue": [],
        "AnnotationValueVisitor": [],
        "Element": [],
        "ElementKind": [
            [
                "PACKAGE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "ENUM",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "CLASS",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "ANNOTATION_TYPE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "INTERFACE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "ENUM_CONSTANT",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "FIELD",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "PARAMETER",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "LOCAL_VARIABLE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "EXCEPTION_PARAMETER",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "METHOD",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "CONSTRUCTOR",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "STATIC_INIT",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "INSTANCE_INIT",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "TYPE_PARAMETER",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "OTHER",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "RESOURCE_VARIABLE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "MODULE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "RECORD",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "RECORD_COMPONENT",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "BINDING_VARIABLE",
                "javax.lang.model.element.ElementKind"
            ],
            [
                "$VALUES",
                "javax.lang.model.element.ElementKind[]"
            ]
        ],
        "ElementVisitor": [],
        "ExecutableElement": [],
        "Modifier": [
            [
                "PUBLIC",
                "javax.lang.model.element.Modifier"
            ],
            [
                "PROTECTED",
                "javax.lang.model.element.Modifier"
            ],
            [
                "PRIVATE",
                "javax.lang.model.element.Modifier"
            ],
            [
                "ABSTRACT",
                "javax.lang.model.element.Modifier"
            ],
            [
                "DEFAULT",
                "javax.lang.model.element.Modifier"
            ],
            [
                "STATIC",
                "javax.lang.model.element.Modifier"
            ],
            [
                "SEALED",
                "javax.lang.model.element.Modifier"
            ],
            [
                "NON_SEALED",
                "javax.lang.model.element.Modifier"
            ],
            [
                "FINAL",
                "javax.lang.model.element.Modifier"
            ],
            [
                "TRANSIENT",
                "javax.lang.model.element.Modifier"
            ],
            [
                "VOLATILE",
                "javax.lang.model.element.Modifier"
            ],
            [
                "SYNCHRONIZED",
                "javax.lang.model.element.Modifier"
            ],
            [
                "NATIVE",
                "javax.lang.model.element.Modifier"
            ],
            [
                "STRICTFP",
                "javax.lang.model.element.Modifier"
            ],
            [
                "$VALUES",
                "javax.lang.model.element.Modifier[]"
            ]
        ],
        "ModuleElement": [],
        "Name": [],
        "NestingKind": [
            [
                "TOP_LEVEL",
                "javax.lang.model.element.NestingKind"
            ],
            [
                "MEMBER",
                "javax.lang.model.element.NestingKind"
            ],
            [
                "LOCAL",
                "javax.lang.model.element.NestingKind"
            ],
            [
                "ANONYMOUS",
                "javax.lang.model.element.NestingKind"
            ],
            [
                "$VALUES",
                "javax.lang.model.element.NestingKind[]"
            ]
        ],
        "PackageElement": [],
        "Parameterizable": [],
        "QualifiedNameable": [],
        "RecordComponentElement": [],
        "TypeElement": [],
        "TypeParameterElement": [],
        "UnknownAnnotationValueException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "av",
                "javax.lang.model.element.AnnotationValue"
            ],
            [
                "parameter",
                "java.lang.Object"
            ]
        ],
        "UnknownDirectiveException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "directive",
                "javax.lang.model.element.ModuleElement$Directive"
            ],
            [
                "parameter",
                "java.lang.Object"
            ]
        ],
        "UnknownElementException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "element",
                "javax.lang.model.element.Element"
            ],
            [
                "parameter",
                "java.lang.Object"
            ]
        ],
        "VariableElement": []
    },
    "javax.lang.model.type": {
        "ArrayType": [],
        "DeclaredType": [],
        "ErrorType": [],
        "ExecutableType": [],
        "IntersectionType": [],
        "MirroredTypeException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "javax.lang.model.type.TypeMirror"
            ]
        ],
        "MirroredTypesException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoType": [],
        "NullType": [],
        "PrimitiveType": [],
        "ReferenceType": [],
        "TypeKind": [
            [
                "BOOLEAN",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "BYTE",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "SHORT",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "INT",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "LONG",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "CHAR",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "FLOAT",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "DOUBLE",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "VOID",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "NONE",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "NULL",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "ARRAY",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "DECLARED",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "ERROR",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "TYPEVAR",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "WILDCARD",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "PACKAGE",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "EXECUTABLE",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "OTHER",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "UNION",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "INTERSECTION",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "MODULE",
                "javax.lang.model.type.TypeKind"
            ],
            [
                "$VALUES",
                "javax.lang.model.type.TypeKind[]"
            ]
        ],
        "TypeMirror": [],
        "TypeVariable": [],
        "TypeVisitor": [],
        "UnionType": [],
        "UnknownTypeException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "javax.lang.model.type.TypeMirror"
            ],
            [
                "parameter",
                "java.lang.Object"
            ]
        ],
        "WildcardType": []
    },
    "javax.lang.model.util": {
        "AbstractAnnotationValueVisitor14": [],
        "AbstractAnnotationValueVisitor6": [],
        "AbstractAnnotationValueVisitor7": [],
        "AbstractAnnotationValueVisitor8": [],
        "AbstractAnnotationValueVisitor9": [],
        "AbstractAnnotationValueVisitorPreview": [],
        "AbstractElementVisitor14": [],
        "AbstractElementVisitor6": [],
        "AbstractElementVisitor7": [],
        "AbstractElementVisitor8": [],
        "AbstractElementVisitor9": [],
        "AbstractElementVisitorPreview": [],
        "AbstractTypeVisitor14": [],
        "AbstractTypeVisitor6": [],
        "AbstractTypeVisitor7": [],
        "AbstractTypeVisitor8": [],
        "AbstractTypeVisitor9": [],
        "AbstractTypeVisitorPreview": [],
        "ElementFilter": [
            [
                "CONSTRUCTOR_KIND",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ],
            [
                "FIELD_KINDS",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ],
            [
                "METHOD_KIND",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ],
            [
                "PACKAGE_KIND",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ],
            [
                "MODULE_KIND",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ],
            [
                "TYPE_KINDS",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ],
            [
                "RECORD_COMPONENT_KIND",
                "java.util.Set<javax.lang.model.element.ElementKind>"
            ]
        ],
        "ElementKindVisitor14": [],
        "ElementKindVisitor6": [],
        "ElementKindVisitor7": [],
        "ElementKindVisitor8": [],
        "ElementKindVisitor9": [],
        "ElementKindVisitorPreview": [],
        "ElementScanner14": [],
        "ElementScanner6": [
            [
                "DEFAULT_VALUE",
                "R"
            ]
        ],
        "ElementScanner7": [],
        "ElementScanner8": [],
        "ElementScanner9": [],
        "ElementScannerPreview": [],
        "Elements": [],
        "SimpleAnnotationValueVisitor14": [],
        "SimpleAnnotationValueVisitor6": [
            [
                "DEFAULT_VALUE",
                "R"
            ]
        ],
        "SimpleAnnotationValueVisitor7": [],
        "SimpleAnnotationValueVisitor8": [],
        "SimpleAnnotationValueVisitor9": [],
        "SimpleAnnotationValueVisitorPreview": [],
        "SimpleElementVisitor14": [],
        "SimpleElementVisitor6": [
            [
                "DEFAULT_VALUE",
                "R"
            ]
        ],
        "SimpleElementVisitor7": [],
        "SimpleElementVisitor8": [],
        "SimpleElementVisitor9": [],
        "SimpleElementVisitorPreview": [],
        "SimpleTypeVisitor14": [],
        "SimpleTypeVisitor6": [
            [
                "DEFAULT_VALUE",
                "R"
            ]
        ],
        "SimpleTypeVisitor7": [],
        "SimpleTypeVisitor8": [],
        "SimpleTypeVisitor9": [],
        "SimpleTypeVisitorPreview": [],
        "TypeKindVisitor14": [],
        "TypeKindVisitor6": [],
        "TypeKindVisitor7": [],
        "TypeKindVisitor8": [],
        "TypeKindVisitor9": [],
        "TypeKindVisitorPreview": [],
        "Types": []
    },
    "javax.tools": {
        "Diagnostic": [
            [
                "NOPOS",
                "long"
            ]
        ],
        "DiagnosticCollector": [
            [
                "diagnostics",
                "S>>"
            ]
        ],
        "DiagnosticListener": [],
        "DocumentationTool": [],
        "FileObject": [],
        "ForwardingFileObject": [
            [
                "fileObject",
                "F"
            ]
        ],
        "ForwardingJavaFileManager": [
            [
                "fileManager",
                "M"
            ]
        ],
        "ForwardingJavaFileObject": [],
        "JavaCompiler": [],
        "JavaFileManager": [],
        "JavaFileObject": [],
        "OptionChecker": [],
        "SimpleJavaFileObject": [
            [
                "uri",
                "java.net.URI"
            ],
            [
                "kind",
                "javax.tools.JavaFileObject$Kind"
            ]
        ],
        "StandardJavaFileManager": [],
        "StandardLocation": [
            [
                "CLASS_OUTPUT",
                "javax.tools.StandardLocation"
            ],
            [
                "SOURCE_OUTPUT",
                "javax.tools.StandardLocation"
            ],
            [
                "CLASS_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "SOURCE_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "ANNOTATION_PROCESSOR_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "ANNOTATION_PROCESSOR_MODULE_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "PLATFORM_CLASS_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "NATIVE_HEADER_OUTPUT",
                "javax.tools.StandardLocation"
            ],
            [
                "MODULE_SOURCE_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "UPGRADE_MODULE_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "SYSTEM_MODULES",
                "javax.tools.StandardLocation"
            ],
            [
                "MODULE_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "PATCH_MODULE_PATH",
                "javax.tools.StandardLocation"
            ],
            [
                "locations",
                "javax.tools.JavaFileManager$Location>"
            ],
            [
                "$VALUES",
                "javax.tools.StandardLocation[]"
            ]
        ],
        "Tool": [],
        "ToolProvider": [
            [
                "systemJavaCompilerModule",
                "java.lang.String"
            ],
            [
                "systemJavaCompilerName",
                "java.lang.String"
            ],
            [
                "systemDocumentationToolModule",
                "java.lang.String"
            ],
            [
                "systemDocumentationToolName",
                "java.lang.String"
            ]
        ]
    },
    "jdk.incubator.vector": {
        "AbstractMask": [],
        "AbstractShuffle": [],
        "AbstractSpecies": [
            [
                "CACHES",
                "jdk.incubator.vector.AbstractSpecies<?>[][]"
            ]
        ],
        "AbstractVector": [],
        "Byte128Vector": [],
        "Byte256Vector": [],
        "Byte512Vector": [],
        "Byte64Vector": [],
        "ByteMaxVector": [],
        "ByteVector": [
            [
                "UN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Byte>>>"
            ],
            [
                "BIN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Byte>>>"
            ],
            [
                "BIN_INT_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Byte>>>"
            ],
            [
                "SHIFT_MASK",
                "int"
            ],
            [
                "LSHR_SETUP_MASK",
                "int"
            ],
            [
                "TERN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Byte>>>"
            ],
            [
                "REDUCE_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Byte>>>"
            ],
            [
                "MIN_OR_INF",
                "byte"
            ],
            [
                "MAX_OR_INF",
                "byte"
            ],
            [
                "SPECIES_64",
                "jdk.incubator.vector.VectorSpecies<java.lang.Byte>"
            ],
            [
                "SPECIES_128",
                "jdk.incubator.vector.VectorSpecies<java.lang.Byte>"
            ],
            [
                "SPECIES_256",
                "jdk.incubator.vector.VectorSpecies<java.lang.Byte>"
            ],
            [
                "SPECIES_512",
                "jdk.incubator.vector.VectorSpecies<java.lang.Byte>"
            ],
            [
                "SPECIES_MAX",
                "jdk.incubator.vector.VectorSpecies<java.lang.Byte>"
            ],
            [
                "SPECIES_PREFERRED",
                "jdk.incubator.vector.VectorSpecies<java.lang.Byte>"
            ]
        ],
        "Double128Vector": [],
        "Double256Vector": [],
        "Double512Vector": [],
        "Double64Vector": [],
        "DoubleMaxVector": [],
        "DoubleVector": [
            [
                "UN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Double>>>"
            ],
            [
                "BIN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Double>>>"
            ],
            [
                "TERN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Double>>>"
            ],
            [
                "REDUCE_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Double>>>"
            ],
            [
                "MIN_OR_INF",
                "double"
            ],
            [
                "MAX_OR_INF",
                "double"
            ],
            [
                "SPECIES_64",
                "jdk.incubator.vector.VectorSpecies<java.lang.Double>"
            ],
            [
                "SPECIES_128",
                "jdk.incubator.vector.VectorSpecies<java.lang.Double>"
            ],
            [
                "SPECIES_256",
                "jdk.incubator.vector.VectorSpecies<java.lang.Double>"
            ],
            [
                "SPECIES_512",
                "jdk.incubator.vector.VectorSpecies<java.lang.Double>"
            ],
            [
                "SPECIES_MAX",
                "jdk.incubator.vector.VectorSpecies<java.lang.Double>"
            ],
            [
                "SPECIES_PREFERRED",
                "jdk.incubator.vector.VectorSpecies<java.lang.Double>"
            ]
        ],
        "Float128Vector": [],
        "Float16": [
            [
                "value",
                "short"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "POSITIVE_INFINITY",
                "jdk.incubator.vector.Float16"
            ],
            [
                "NEGATIVE_INFINITY",
                "jdk.incubator.vector.Float16"
            ],
            [
                "NaN",
                "jdk.incubator.vector.Float16"
            ],
            [
                "MAX_VALUE",
                "jdk.incubator.vector.Float16"
            ],
            [
                "MIN_NORMAL",
                "jdk.incubator.vector.Float16"
            ],
            [
                "MIN_VALUE",
                "jdk.incubator.vector.Float16"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "PRECISION",
                "int"
            ],
            [
                "MAX_EXPONENT",
                "int"
            ],
            [
                "MIN_EXPONENT",
                "int"
            ],
            [
                "BYTES",
                "int"
            ]
        ],
        "Float16Consts": [
            [
                "SIGNIFICAND_WIDTH",
                "int"
            ],
            [
                "MIN_SUB_EXPONENT",
                "int"
            ],
            [
                "EXP_BIAS",
                "int"
            ],
            [
                "SIGN_BIT_MASK",
                "int"
            ],
            [
                "EXP_BIT_MASK",
                "int"
            ],
            [
                "SIGNIF_BIT_MASK",
                "int"
            ],
            [
                "MAG_BIT_MASK",
                "int"
            ]
        ],
        "Float256Vector": [],
        "Float512Vector": [],
        "Float64Vector": [],
        "FloatMaxVector": [],
        "FloatVector": [
            [
                "UN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Float>>>"
            ],
            [
                "BIN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Float>>>"
            ],
            [
                "TERN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Float>>>"
            ],
            [
                "REDUCE_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Float>>>"
            ],
            [
                "MIN_OR_INF",
                "float"
            ],
            [
                "MAX_OR_INF",
                "float"
            ],
            [
                "SPECIES_64",
                "jdk.incubator.vector.VectorSpecies<java.lang.Float>"
            ],
            [
                "SPECIES_128",
                "jdk.incubator.vector.VectorSpecies<java.lang.Float>"
            ],
            [
                "SPECIES_256",
                "jdk.incubator.vector.VectorSpecies<java.lang.Float>"
            ],
            [
                "SPECIES_512",
                "jdk.incubator.vector.VectorSpecies<java.lang.Float>"
            ],
            [
                "SPECIES_MAX",
                "jdk.incubator.vector.VectorSpecies<java.lang.Float>"
            ],
            [
                "SPECIES_PREFERRED",
                "jdk.incubator.vector.VectorSpecies<java.lang.Float>"
            ]
        ],
        "Int128Vector": [],
        "Int256Vector": [],
        "Int512Vector": [],
        "Int64Vector": [],
        "IntMaxVector": [],
        "IntVector": [
            [
                "UN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Integer>>>"
            ],
            [
                "BIN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Integer>>>"
            ],
            [
                "BIN_INT_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Integer>>>"
            ],
            [
                "SHIFT_MASK",
                "int"
            ],
            [
                "LSHR_SETUP_MASK",
                "int"
            ],
            [
                "TERN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Integer>>>"
            ],
            [
                "REDUCE_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Integer>>>"
            ],
            [
                "MIN_OR_INF",
                "int"
            ],
            [
                "MAX_OR_INF",
                "int"
            ],
            [
                "SPECIES_64",
                "jdk.incubator.vector.VectorSpecies<java.lang.Integer>"
            ],
            [
                "SPECIES_128",
                "jdk.incubator.vector.VectorSpecies<java.lang.Integer>"
            ],
            [
                "SPECIES_256",
                "jdk.incubator.vector.VectorSpecies<java.lang.Integer>"
            ],
            [
                "SPECIES_512",
                "jdk.incubator.vector.VectorSpecies<java.lang.Integer>"
            ],
            [
                "SPECIES_MAX",
                "jdk.incubator.vector.VectorSpecies<java.lang.Integer>"
            ],
            [
                "SPECIES_PREFERRED",
                "jdk.incubator.vector.VectorSpecies<java.lang.Integer>"
            ]
        ],
        "LaneType": [
            [
                "FLOAT",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "DOUBLE",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "BYTE",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "SHORT",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "INT",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "LONG",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "asIntegral",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "asFloating",
                "jdk.incubator.vector.LaneType"
            ],
            [
                "ENUM_VALUES",
                "jdk.incubator.vector.LaneType[]"
            ],
            [
                "ENUM_FROM_SK",
                "jdk.incubator.vector.LaneType[]"
            ],
            [
                "ENUM_FROM_C0",
                "jdk.incubator.vector.LaneType[]"
            ],
            [
                "ENUM_FROM_BT",
                "jdk.incubator.vector.LaneType[]"
            ],
            [
                "C0_MASK",
                "int"
            ],
            [
                "BT_MASK",
                "int"
            ],
            [
                "$VALUES",
                "jdk.incubator.vector.LaneType[]"
            ]
        ],
        "Long128Vector": [],
        "Long256Vector": [],
        "Long512Vector": [],
        "Long64Vector": [],
        "LongMaxVector": [],
        "LongVector": [
            [
                "UN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Long>>>"
            ],
            [
                "BIN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Long>>>"
            ],
            [
                "BIN_INT_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Long>>>"
            ],
            [
                "SHIFT_MASK",
                "int"
            ],
            [
                "LSHR_SETUP_MASK",
                "long"
            ],
            [
                "TERN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Long>>>"
            ],
            [
                "REDUCE_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Long>>>"
            ],
            [
                "MIN_OR_INF",
                "long"
            ],
            [
                "MAX_OR_INF",
                "long"
            ],
            [
                "SPECIES_64",
                "jdk.incubator.vector.VectorSpecies<java.lang.Long>"
            ],
            [
                "SPECIES_128",
                "jdk.incubator.vector.VectorSpecies<java.lang.Long>"
            ],
            [
                "SPECIES_256",
                "jdk.incubator.vector.VectorSpecies<java.lang.Long>"
            ],
            [
                "SPECIES_512",
                "jdk.incubator.vector.VectorSpecies<java.lang.Long>"
            ],
            [
                "SPECIES_MAX",
                "jdk.incubator.vector.VectorSpecies<java.lang.Long>"
            ],
            [
                "SPECIES_PREFERRED",
                "jdk.incubator.vector.VectorSpecies<java.lang.Long>"
            ]
        ],
        "Short128Vector": [],
        "Short256Vector": [],
        "Short512Vector": [],
        "Short64Vector": [],
        "ShortMaxVector": [],
        "ShortVector": [
            [
                "UN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Short>>>"
            ],
            [
                "BIN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Short>>>"
            ],
            [
                "BIN_INT_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Short>>>"
            ],
            [
                "SHIFT_MASK",
                "int"
            ],
            [
                "LSHR_SETUP_MASK",
                "int"
            ],
            [
                "TERN_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Short>>>"
            ],
            [
                "REDUCE_IMPL",
                "jdk.incubator.vector.VectorMask<java.lang.Short>>>"
            ],
            [
                "MIN_OR_INF",
                "short"
            ],
            [
                "MAX_OR_INF",
                "short"
            ],
            [
                "SPECIES_64",
                "jdk.incubator.vector.VectorSpecies<java.lang.Short>"
            ],
            [
                "SPECIES_128",
                "jdk.incubator.vector.VectorSpecies<java.lang.Short>"
            ],
            [
                "SPECIES_256",
                "jdk.incubator.vector.VectorSpecies<java.lang.Short>"
            ],
            [
                "SPECIES_512",
                "jdk.incubator.vector.VectorSpecies<java.lang.Short>"
            ],
            [
                "SPECIES_MAX",
                "jdk.incubator.vector.VectorSpecies<java.lang.Short>"
            ],
            [
                "SPECIES_PREFERRED",
                "jdk.incubator.vector.VectorSpecies<java.lang.Short>"
            ]
        ],
        "Vector": [],
        "VectorIntrinsics": [],
        "VectorMask": [],
        "VectorMath": [],
        "VectorOperators": [
            [
                "OPC_NAME",
                "java.lang.String>"
            ],
            [
                "CMP_OPC_NAME",
                "java.lang.String>"
            ],
            [
                "CONV_OPC_NAME",
                "java.lang.String>"
            ],
            [
                "NOT",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "ZOMO",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "ABS",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "NEG",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "BIT_COUNT",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "TRAILING_ZEROS_COUNT",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "LEADING_ZEROS_COUNT",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "REVERSE",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "REVERSE_BYTES",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "SIN",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "COS",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "TAN",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "ASIN",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "ACOS",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "ATAN",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "EXP",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "LOG",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "LOG10",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "SQRT",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "CBRT",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "SINH",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "COSH",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "TANH",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "EXPM1",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "LOG1P",
                "jdk.incubator.vector.VectorOperators$Unary"
            ],
            [
                "ADD",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "SUB",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "MUL",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "DIV",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "MIN",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "MAX",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "FIRST_NONZERO",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "AND",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "AND_NOT",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "OR",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "XOR",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "SADD",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "SUADD",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "SSUB",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "SUSUB",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "UMIN",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "UMAX",
                "jdk.incubator.vector.VectorOperators$Associative"
            ],
            [
                "LSHL",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "ASHR",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "LSHR",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "ROL",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "ROR",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "COMPRESS_BITS",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "EXPAND_BITS",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "ATAN2",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "POW",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "HYPOT",
                "jdk.incubator.vector.VectorOperators$Binary"
            ],
            [
                "BITWISE_BLEND",
                "jdk.incubator.vector.VectorOperators$Ternary"
            ],
            [
                "FMA",
                "jdk.incubator.vector.VectorOperators$Ternary"
            ],
            [
                "IS_DEFAULT",
                "jdk.incubator.vector.VectorOperators$Test"
            ],
            [
                "IS_NEGATIVE",
                "jdk.incubator.vector.VectorOperators$Test"
            ],
            [
                "IS_FINITE",
                "jdk.incubator.vector.VectorOperators$Test"
            ],
            [
                "IS_NAN",
                "jdk.incubator.vector.VectorOperators$Test"
            ],
            [
                "IS_INFINITE",
                "jdk.incubator.vector.VectorOperators$Test"
            ],
            [
                "EQ",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "NE",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "LT",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "LE",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "GT",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "GE",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "ULT",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "ULE",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "UGT",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "UGE",
                "jdk.incubator.vector.VectorOperators$Comparison"
            ],
            [
                "B2D",
                "java.lang.Double>"
            ],
            [
                "B2F",
                "java.lang.Float>"
            ],
            [
                "B2I",
                "java.lang.Integer>"
            ],
            [
                "B2L",
                "java.lang.Long>"
            ],
            [
                "B2S",
                "java.lang.Short>"
            ],
            [
                "D2B",
                "java.lang.Byte>"
            ],
            [
                "D2F",
                "java.lang.Float>"
            ],
            [
                "D2I",
                "java.lang.Integer>"
            ],
            [
                "D2L",
                "java.lang.Long>"
            ],
            [
                "D2S",
                "java.lang.Short>"
            ],
            [
                "F2B",
                "java.lang.Byte>"
            ],
            [
                "F2D",
                "java.lang.Double>"
            ],
            [
                "F2I",
                "java.lang.Integer>"
            ],
            [
                "F2L",
                "java.lang.Long>"
            ],
            [
                "F2S",
                "java.lang.Short>"
            ],
            [
                "I2B",
                "java.lang.Byte>"
            ],
            [
                "I2D",
                "java.lang.Double>"
            ],
            [
                "I2F",
                "java.lang.Float>"
            ],
            [
                "I2L",
                "java.lang.Long>"
            ],
            [
                "I2S",
                "java.lang.Short>"
            ],
            [
                "L2B",
                "java.lang.Byte>"
            ],
            [
                "L2D",
                "java.lang.Double>"
            ],
            [
                "L2F",
                "java.lang.Float>"
            ],
            [
                "L2I",
                "java.lang.Integer>"
            ],
            [
                "L2S",
                "java.lang.Short>"
            ],
            [
                "S2B",
                "java.lang.Byte>"
            ],
            [
                "S2D",
                "java.lang.Double>"
            ],
            [
                "S2F",
                "java.lang.Float>"
            ],
            [
                "S2I",
                "java.lang.Integer>"
            ],
            [
                "S2L",
                "java.lang.Long>"
            ],
            [
                "REINTERPRET_D2L",
                "java.lang.Long>"
            ],
            [
                "REINTERPRET_F2I",
                "java.lang.Integer>"
            ],
            [
                "REINTERPRET_I2F",
                "java.lang.Float>"
            ],
            [
                "REINTERPRET_L2D",
                "java.lang.Double>"
            ],
            [
                "ZERO_EXTEND_B2I",
                "java.lang.Integer>"
            ],
            [
                "ZERO_EXTEND_B2L",
                "java.lang.Long>"
            ],
            [
                "ZERO_EXTEND_B2S",
                "java.lang.Short>"
            ],
            [
                "ZERO_EXTEND_I2L",
                "java.lang.Long>"
            ],
            [
                "ZERO_EXTEND_S2I",
                "java.lang.Integer>"
            ],
            [
                "ZERO_EXTEND_S2L",
                "java.lang.Long>"
            ]
        ],
        "VectorShape": [
            [
                "S_64_BIT",
                "jdk.incubator.vector.VectorShape"
            ],
            [
                "S_128_BIT",
                "jdk.incubator.vector.VectorShape"
            ],
            [
                "S_256_BIT",
                "jdk.incubator.vector.VectorShape"
            ],
            [
                "S_512_BIT",
                "jdk.incubator.vector.VectorShape"
            ],
            [
                "S_Max_BIT",
                "jdk.incubator.vector.VectorShape"
            ],
            [
                "PREFERRED_SHAPE",
                "jdk.incubator.vector.VectorShape"
            ],
            [
                "$VALUES",
                "jdk.incubator.vector.VectorShape[]"
            ]
        ],
        "VectorShuffle": [],
        "VectorSpecies": []
    },
    "javax.sql.rowset": {
        "BaseRowSet": [
            [
                "UNICODE_STREAM_PARAM",
                "int"
            ],
            [
                "BINARY_STREAM_PARAM",
                "int"
            ],
            [
                "ASCII_STREAM_PARAM",
                "int"
            ],
            [
                "binaryStream",
                "java.io.InputStream"
            ],
            [
                "unicodeStream",
                "java.io.InputStream"
            ],
            [
                "asciiStream",
                "java.io.InputStream"
            ],
            [
                "charStream",
                "java.io.Reader"
            ],
            [
                "command",
                "java.lang.String"
            ],
            [
                "URL",
                "java.lang.String"
            ],
            [
                "dataSource",
                "java.lang.String"
            ],
            [
                "username",
                "java.lang.String"
            ],
            [
                "password",
                "java.lang.String"
            ],
            [
                "rowSetType",
                "int"
            ],
            [
                "showDeleted",
                "boolean"
            ],
            [
                "queryTimeout",
                "int"
            ],
            [
                "maxRows",
                "int"
            ],
            [
                "maxFieldSize",
                "int"
            ],
            [
                "concurrency",
                "int"
            ],
            [
                "readOnly",
                "boolean"
            ],
            [
                "escapeProcessing",
                "boolean"
            ],
            [
                "isolation",
                "int"
            ],
            [
                "fetchDir",
                "int"
            ],
            [
                "fetchSize",
                "int"
            ],
            [
                "map",
                "java.lang.Class<?>>"
            ],
            [
                "listeners",
                "java.util.Vector<javax.sql.RowSetListener>"
            ],
            [
                "params",
                "java.lang.Object>"
            ]
        ],
        "CachedRowSet": [
            [
                "COMMIT_ON_ACCEPT_CHANGES",
                "boolean"
            ]
        ],
        "FilteredRowSet": [],
        "JdbcRowSet": [],
        "JoinRowSet": [
            [
                "CROSS_JOIN",
                "int"
            ],
            [
                "INNER_JOIN",
                "int"
            ],
            [
                "LEFT_OUTER_JOIN",
                "int"
            ],
            [
                "RIGHT_OUTER_JOIN",
                "int"
            ],
            [
                "FULL_JOIN",
                "int"
            ]
        ],
        "Joinable": [],
        "Predicate": [],
        "RowSetFactory": [],
        "RowSetMetaDataImpl": [
            [
                "colCount",
                "int"
            ],
            [
                "colInfo",
                "javax.sql.rowset.RowSetMetaDataImpl$ColInfo[]"
            ]
        ],
        "RowSetProvider": [
            [
                "ROWSET_DEBUG_PROPERTY",
                "java.lang.String"
            ],
            [
                "ROWSET_FACTORY_IMPL",
                "java.lang.String"
            ],
            [
                "ROWSET_FACTORY_NAME",
                "java.lang.String"
            ],
            [
                "debug",
                "boolean"
            ]
        ],
        "RowSetWarning": [],
        "WebRowSet": [
            [
                "PUBLIC_XML_SCHEMA",
                "java.lang.String"
            ],
            [
                "SCHEMA_SYSTEM_ID",
                "java.lang.String"
            ]
        ]
    },
    "javax.sql.rowset.serial": {
        "SQLInputImpl": [
            [
                "lastValueWasNull",
                "boolean"
            ],
            [
                "idx",
                "int"
            ],
            [
                "attrib",
                "java.lang.Object[]"
            ],
            [
                "map",
                "java.lang.Class<?>>"
            ]
        ],
        "SQLOutputImpl": [
            [
                "attribs",
                "java.util.Vector"
            ],
            [
                "map",
                "java.util.Map"
            ]
        ],
        "SerialArray": [
            [
                "elements",
                "java.lang.Object[]"
            ],
            [
                "baseType",
                "int"
            ],
            [
                "baseTypeName",
                "java.lang.String"
            ],
            [
                "len",
                "int"
            ]
        ],
        "SerialBlob": [
            [
                "buf",
                "byte[]"
            ],
            [
                "blob",
                "java.sql.Blob"
            ],
            [
                "len",
                "long"
            ],
            [
                "origLen",
                "long"
            ]
        ],
        "SerialClob": [
            [
                "buf",
                "char[]"
            ],
            [
                "clob",
                "java.sql.Clob"
            ],
            [
                "len",
                "long"
            ],
            [
                "origLen",
                "long"
            ]
        ],
        "SerialDatalink": [
            [
                "url",
                "java.net.URL"
            ],
            [
                "baseType",
                "int"
            ],
            [
                "baseTypeName",
                "java.lang.String"
            ]
        ],
        "SerialException": [],
        "SerialJavaObject": [
            [
                "obj",
                "java.lang.Object"
            ],
            [
                "fields",
                "java.lang.reflect.Field[]"
            ]
        ],
        "SerialRef": [
            [
                "baseTypeName",
                "java.lang.String"
            ],
            [
                "object",
                "java.lang.Object"
            ],
            [
                "reference",
                "java.sql.Ref"
            ]
        ],
        "SerialStruct": [
            [
                "SQLTypeName",
                "java.lang.String"
            ],
            [
                "attribs",
                "java.lang.Object[]"
            ]
        ]
    },
    "javax.sql.rowset.spi": {
        "ProviderImpl": [
            [
                "className",
                "java.lang.String"
            ],
            [
                "vendorName",
                "java.lang.String"
            ],
            [
                "ver",
                "java.lang.String"
            ],
            [
                "index",
                "int"
            ]
        ],
        "SyncFactory": [
            [
                "ROWSET_SYNC_PROVIDER",
                "java.lang.String"
            ],
            [
                "ROWSET_SYNC_VENDOR",
                "java.lang.String"
            ],
            [
                "ROWSET_SYNC_PROVIDER_VERSION",
                "java.lang.String"
            ],
            [
                "ROWSET_PROPERTIES",
                "java.lang.String"
            ],
            [
                "ic",
                "javax.naming.Context"
            ],
            [
                "rsLogger",
                "java.util.logging.Logger"
            ],
            [
                "implementations",
                "javax.sql.rowset.spi.SyncProvider>"
            ],
            [
                "colon",
                "java.lang.String"
            ],
            [
                "strFileSep",
                "java.lang.String"
            ],
            [
                "debug",
                "boolean"
            ],
            [
                "providerImplIndex",
                "int"
            ],
            [
                "lazyJNDICtxRefresh",
                "boolean"
            ]
        ],
        "SyncFactoryException": [],
        "SyncProvider": [
            [
                "GRADE_NONE",
                "int"
            ],
            [
                "GRADE_CHECK_MODIFIED_AT_COMMIT",
                "int"
            ],
            [
                "GRADE_CHECK_ALL_AT_COMMIT",
                "int"
            ],
            [
                "GRADE_LOCK_WHEN_MODIFIED",
                "int"
            ],
            [
                "GRADE_LOCK_WHEN_LOADED",
                "int"
            ],
            [
                "DATASOURCE_NO_LOCK",
                "int"
            ],
            [
                "DATASOURCE_ROW_LOCK",
                "int"
            ],
            [
                "DATASOURCE_TABLE_LOCK",
                "int"
            ],
            [
                "DATASOURCE_DB_LOCK",
                "int"
            ],
            [
                "UPDATABLE_VIEW_SYNC",
                "int"
            ],
            [
                "NONUPDATABLE_VIEW_SYNC",
                "int"
            ]
        ],
        "SyncProviderException": [
            [
                "syncResolver",
                "javax.sql.rowset.spi.SyncResolver"
            ]
        ],
        "SyncResolver": [
            [
                "UPDATE_ROW_CONFLICT",
                "int"
            ],
            [
                "DELETE_ROW_CONFLICT",
                "int"
            ],
            [
                "INSERT_ROW_CONFLICT",
                "int"
            ],
            [
                "NO_ROW_CONFLICT",
                "int"
            ]
        ],
        "TransactionalWriter": [],
        "XmlReader": [],
        "XmlWriter": []
    },
    "jdk.jfr": {
        "AnnotationElement": [
            [
                "type",
                "jdk.jfr.internal.Type"
            ],
            [
                "annotationValues",
                "java.util.List<java.lang.Object>"
            ],
            [
                "inBootClassLoader",
                "boolean"
            ]
        ],
        "BooleanFlag": [],
        "Category": [],
        "Configuration": [
            [
                "settings",
                "java.lang.String>"
            ],
            [
                "label",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "provider",
                "java.lang.String"
            ],
            [
                "contents",
                "java.lang.String"
            ],
            [
                "name",
                "java.lang.String"
            ]
        ],
        "ContentType": [],
        "DataAmount": [
            [
                "BITS",
                "java.lang.String"
            ],
            [
                "BYTES",
                "java.lang.String"
            ]
        ],
        "Description": [],
        "Enabled": [
            [
                "NAME",
                "java.lang.String"
            ]
        ],
        "Event": [],
        "EventFactory": [
            [
                "REGISTERED_ID",
                "long"
            ],
            [
                "eventClass",
                "jdk.jfr.Event>"
            ],
            [
                "constructorHandle",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "sanitizedAnnotation",
                "java.util.List<jdk.jfr.AnnotationElement>"
            ],
            [
                "sanitizedFields",
                "java.util.List<jdk.jfr.ValueDescriptor>"
            ]
        ],
        "EventSettings": [],
        "EventType": [
            [
                "UNKNOWN",
                "java.lang.String"
            ],
            [
                "UNCATEGORIZED",
                "java.lang.String[]"
            ],
            [
                "platformEventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "cache",
                "jdk.jfr.ValueDescriptor>"
            ],
            [
                "label",
                "java.lang.String"
            ]
        ],
        "Experimental": [],
        "FlightRecorder": [
            [
                "platformRecorder",
                "jdk.jfr.FlightRecorder"
            ],
            [
                "initialized",
                "boolean"
            ],
            [
                "internal",
                "jdk.jfr.internal.PlatformRecorder"
            ]
        ],
        "FlightRecorderListener": [],
        "FlightRecorderPermission": [],
        "Frequency": [],
        "Label": [],
        "MemoryAddress": [],
        "MetadataDefinition": [],
        "Name": [],
        "Percentage": [],
        "Period": [
            [
                "NAME",
                "java.lang.String"
            ]
        ],
        "Recording": [
            [
                "internal",
                "jdk.jfr.internal.PlatformRecording"
            ]
        ],
        "RecordingState": [
            [
                "NEW",
                "jdk.jfr.RecordingState"
            ],
            [
                "DELAYED",
                "jdk.jfr.RecordingState"
            ],
            [
                "RUNNING",
                "jdk.jfr.RecordingState"
            ],
            [
                "STOPPED",
                "jdk.jfr.RecordingState"
            ],
            [
                "CLOSED",
                "jdk.jfr.RecordingState"
            ],
            [
                "$VALUES",
                "jdk.jfr.RecordingState[]"
            ]
        ],
        "Registered": [],
        "Relational": [],
        "SettingControl": [
            [
                "context",
                "java.security.AccessControlContext"
            ],
            [
                "initialized",
                "boolean"
            ]
        ],
        "SettingDefinition": [],
        "SettingDescriptor": [
            [
                "annotationConstruct",
                "jdk.jfr.internal.AnnotationConstruct"
            ],
            [
                "type",
                "jdk.jfr.internal.Type"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "defaultValue",
                "java.lang.String"
            ]
        ],
        "StackTrace": [
            [
                "NAME",
                "java.lang.String"
            ]
        ],
        "Threshold": [
            [
                "NAME",
                "java.lang.String"
            ]
        ],
        "Timespan": [
            [
                "TICKS",
                "java.lang.String"
            ],
            [
                "SECONDS",
                "java.lang.String"
            ],
            [
                "MILLISECONDS",
                "java.lang.String"
            ],
            [
                "NANOSECONDS",
                "java.lang.String"
            ],
            [
                "MICROSECONDS",
                "java.lang.String"
            ]
        ],
        "Timestamp": [
            [
                "MILLISECONDS_SINCE_EPOCH",
                "java.lang.String"
            ],
            [
                "TICKS",
                "java.lang.String"
            ]
        ],
        "TransitionFrom": [],
        "TransitionTo": [],
        "Unsigned": [],
        "ValueDescriptor": [
            [
                "UNKNOWN",
                "java.lang.String"
            ],
            [
                "annotationConstruct",
                "jdk.jfr.internal.AnnotationConstruct"
            ],
            [
                "type",
                "jdk.jfr.internal.Type"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "isArray",
                "boolean"
            ],
            [
                "constantPool",
                "boolean"
            ],
            [
                "javaFieldName",
                "java.lang.String"
            ],
            [
                "label",
                "java.lang.String"
            ],
            [
                "contentType",
                "java.lang.String"
            ]
        ]
    },
    "jdk.jfr.consumer": {
        "EventStream": [],
        "MetadataEvent": [
            [
                "current",
                "java.util.List<jdk.jfr.EventType>"
            ],
            [
                "previous",
                "java.util.List<jdk.jfr.EventType>"
            ],
            [
                "configurations",
                "java.util.List<jdk.jfr.Configuration>"
            ],
            [
                "added",
                "java.util.List<jdk.jfr.EventType>"
            ],
            [
                "removed",
                "java.util.List<jdk.jfr.EventType>"
            ]
        ],
        "RecordedClass": [
            [
                "uniqueId",
                "long"
            ]
        ],
        "RecordedClassLoader": [
            [
                "uniqueId",
                "long"
            ]
        ],
        "RecordedEvent": [],
        "RecordedFrame": [],
        "RecordedMethod": [],
        "RecordedObject": [],
        "RecordedStackTrace": [],
        "RecordedThread": [
            [
                "uniqueId",
                "long"
            ]
        ],
        "RecordedThreadGroup": [],
        "RecordingFile": [
            [
                "parserState",
                "jdk.jfr.internal.consumer.ParserState"
            ],
            [
                "chunkWriter",
                "jdk.jfr.internal.consumer.filter.ChunkWriter"
            ],
            [
                "isLastEventInChunk",
                "boolean"
            ],
            [
                "file",
                "java.io.File"
            ],
            [
                "input",
                "jdk.jfr.internal.consumer.RecordingInput"
            ],
            [
                "chunkParser",
                "jdk.jfr.internal.consumer.ChunkParser"
            ],
            [
                "nextEvent",
                "jdk.jfr.consumer.RecordedEvent"
            ],
            [
                "eof",
                "boolean"
            ]
        ],
        "RecordingStream": [
            [
                "recording",
                "jdk.jfr.Recording"
            ],
            [
                "creationTime",
                "java.time.Instant"
            ],
            [
                "directoryStream",
                "jdk.jfr.internal.consumer.EventDirectoryStream"
            ],
            [
                "maxSize",
                "long"
            ],
            [
                "maxAge",
                "java.time.Duration"
            ]
        ]
    },
    "jdk.jfr.events": {
        "AbstractBufferStatisticsEvent": [],
        "AbstractJDKEvent": [],
        "AbstractPeriodicEvent": [],
        "ActiveRecordingEvent": [
            [
                "id",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "destination",
                "java.lang.String"
            ],
            [
                "disk",
                "boolean"
            ],
            [
                "maxAge",
                "long"
            ],
            [
                "flushInterval",
                "long"
            ],
            [
                "maxSize",
                "long"
            ],
            [
                "recordingStart",
                "long"
            ],
            [
                "recordingDuration",
                "long"
            ]
        ],
        "ActiveSettingEvent": [
            [
                "id",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "CertificateId": [],
        "ContainerCPUThrottlingEvent": [
            [
                "cpuElapsedSlices",
                "long"
            ],
            [
                "cpuThrottledSlices",
                "long"
            ],
            [
                "cpuThrottledTime",
                "long"
            ]
        ],
        "ContainerCPUUsageEvent": [
            [
                "cpuTime",
                "long"
            ],
            [
                "cpuUserTime",
                "long"
            ],
            [
                "cpuSystemTime",
                "long"
            ]
        ],
        "ContainerConfigurationEvent": [
            [
                "containerType",
                "java.lang.String"
            ],
            [
                "cpuSlicePeriod",
                "long"
            ],
            [
                "cpuQuota",
                "long"
            ],
            [
                "cpuShares",
                "long"
            ],
            [
                "effectiveCpuCount",
                "long"
            ],
            [
                "memorySoftLimit",
                "long"
            ],
            [
                "memoryLimit",
                "long"
            ],
            [
                "swapMemoryLimit",
                "long"
            ],
            [
                "hostTotalMemory",
                "long"
            ],
            [
                "hostTotalSwapMemory",
                "long"
            ]
        ],
        "ContainerIOUsageEvent": [
            [
                "serviceRequests",
                "long"
            ],
            [
                "dataTransferred",
                "long"
            ]
        ],
        "ContainerMemoryUsageEvent": [
            [
                "memoryFailCount",
                "long"
            ],
            [
                "memoryUsage",
                "long"
            ],
            [
                "swapMemoryUsage",
                "long"
            ]
        ],
        "DeserializationEvent": [
            [
                "filterConfigured",
                "boolean"
            ],
            [
                "filterStatus",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Class<?>"
            ],
            [
                "arrayLength",
                "int"
            ],
            [
                "objectReferences",
                "long"
            ],
            [
                "depth",
                "long"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "exceptionType",
                "java.lang.Class<?>"
            ],
            [
                "exceptionMessage",
                "java.lang.String"
            ]
        ],
        "DirectBufferStatisticsEvent": [
            [
                "DIRECT_BUFFER_POOL",
                "jdk.internal.misc.VM$BufferPool"
            ]
        ],
        "ErrorThrownEvent": [
            [
                "message",
                "java.lang.String"
            ],
            [
                "thrownClass",
                "java.lang.Class<?>"
            ]
        ],
        "ExceptionStatisticsEvent": [
            [
                "throwables",
                "long"
            ]
        ],
        "ExceptionThrownEvent": [
            [
                "message",
                "java.lang.String"
            ],
            [
                "thrownClass",
                "java.lang.Class<?>"
            ]
        ],
        "FileForceEvent": [
            [
                "path",
                "java.lang.String"
            ],
            [
                "metaData",
                "boolean"
            ]
        ],
        "FileReadEvent": [
            [
                "path",
                "java.lang.String"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "endOfFile",
                "boolean"
            ]
        ],
        "FileWriteEvent": [
            [
                "path",
                "java.lang.String"
            ],
            [
                "bytesWritten",
                "long"
            ]
        ],
        "InitialSecurityPropertyEvent": [
            [
                "key",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "ProcessStartEvent": [
            [
                "pid",
                "long"
            ],
            [
                "directory",
                "java.lang.String"
            ],
            [
                "command",
                "java.lang.String"
            ]
        ],
        "SecurityPropertyModificationEvent": [
            [
                "key",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "SecurityProviderServiceEvent": [
            [
                "type",
                "java.lang.String"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "provider",
                "java.lang.String"
            ]
        ],
        "SerializationMisdeclarationEvent": [
            [
                "misdeclaredClass",
                "java.lang.Class<?>"
            ],
            [
                "message",
                "java.lang.String"
            ]
        ],
        "SocketReadEvent": [
            [
                "host",
                "java.lang.String"
            ],
            [
                "address",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "timeout",
                "long"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "endOfStream",
                "boolean"
            ]
        ],
        "SocketWriteEvent": [
            [
                "host",
                "java.lang.String"
            ],
            [
                "address",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "bytesWritten",
                "long"
            ]
        ],
        "StackFilter": [],
        "TLSHandshakeEvent": [
            [
                "peerHost",
                "java.lang.String"
            ],
            [
                "peerPort",
                "int"
            ],
            [
                "protocolVersion",
                "java.lang.String"
            ],
            [
                "cipherSuite",
                "java.lang.String"
            ],
            [
                "certificateId",
                "long"
            ]
        ],
        "ThreadSleepEvent": [
            [
                "time",
                "long"
            ]
        ],
        "VirtualThreadEndEvent": [
            [
                "javaThreadId",
                "long"
            ]
        ],
        "VirtualThreadStartEvent": [
            [
                "javaThreadId",
                "long"
            ]
        ],
        "VirtualThreadSubmitFailedEvent": [
            [
                "javaThreadId",
                "long"
            ],
            [
                "exceptionMessage",
                "java.lang.String"
            ]
        ],
        "X509CertificateEvent": [
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "serialNumber",
                "java.lang.String"
            ],
            [
                "subject",
                "java.lang.String"
            ],
            [
                "issuer",
                "java.lang.String"
            ],
            [
                "keyType",
                "java.lang.String"
            ],
            [
                "keyLength",
                "int"
            ],
            [
                "certificateId",
                "long"
            ],
            [
                "validFrom",
                "long"
            ],
            [
                "validUntil",
                "long"
            ]
        ],
        "X509ValidationEvent": [
            [
                "certificateId",
                "long"
            ],
            [
                "certificatePosition",
                "int"
            ],
            [
                "validationCounter",
                "long"
            ]
        ]
    },
    "jdk.jfr.internal": {
        "AnnotationConstruct": [
            [
                "annotationElements",
                "java.util.List<jdk.jfr.AnnotationElement>"
            ],
            [
                "unsignedFlag",
                "byte"
            ]
        ],
        "Bits": [
            [
                "unsafe",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "unalignedAccess",
                "boolean"
            ],
            [
                "bigEndian",
                "boolean"
            ]
        ],
        "ChunkInputStream": [
            [
                "chunks",
                "java.util.Iterator<jdk.jfr.internal.RepositoryChunk>"
            ],
            [
                "unstreamedSize",
                "long"
            ],
            [
                "currentChunk",
                "jdk.jfr.internal.RepositoryChunk"
            ],
            [
                "stream",
                "java.io.InputStream"
            ]
        ],
        "ChunksChannel": [
            [
                "chunks",
                "java.util.Iterator<jdk.jfr.internal.RepositoryChunk>"
            ],
            [
                "current",
                "jdk.jfr.internal.RepositoryChunk"
            ],
            [
                "channel",
                "java.nio.channels.ReadableByteChannel"
            ]
        ],
        "Control": [
            [
                "context",
                "java.security.AccessControlContext"
            ],
            [
                "CACHE_SIZE",
                "int"
            ],
            [
                "cachedUnions",
                "java.util.Set<?>[]"
            ],
            [
                "cachedValues",
                "java.lang.String[]"
            ],
            [
                "delegate",
                "jdk.jfr.SettingControl"
            ],
            [
                "defaultValue",
                "java.lang.String"
            ],
            [
                "lastValue",
                "java.lang.String"
            ]
        ],
        "Cutoff": [
            [
                "NAME",
                "java.lang.String"
            ],
            [
                "INFINITY",
                "java.lang.String"
            ]
        ],
        "EventClassBuilder": [
            [
                "TYPE_EVENT",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_IOBE",
                "java.lang.constant.ClassDesc"
            ],
            [
                "DEFAULT_CONSTRUCTOR",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "SET_METHOD",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "idCounter",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "fullClassName",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.constant.ClassDesc"
            ],
            [
                "fields",
                "java.util.List<jdk.jfr.ValueDescriptor>"
            ],
            [
                "annotationElements",
                "java.util.List<jdk.jfr.AnnotationElement>"
            ]
        ],
        "EventControl": [
            [
                "TYPE_ENABLED",
                "jdk.jfr.internal.Type"
            ],
            [
                "TYPE_THRESHOLD",
                "jdk.jfr.internal.Type"
            ],
            [
                "TYPE_STACK_TRACE",
                "jdk.jfr.internal.Type"
            ],
            [
                "TYPE_PERIOD",
                "jdk.jfr.internal.Type"
            ],
            [
                "TYPE_CUTOFF",
                "jdk.jfr.internal.Type"
            ],
            [
                "TYPE_THROTTLE",
                "jdk.jfr.internal.Type"
            ],
            [
                "STACK_FILTER_ID",
                "long"
            ],
            [
                "TYPE_LEVEL",
                "jdk.jfr.internal.Type"
            ],
            [
                "settingControls",
                "java.util.ArrayList<jdk.jfr.SettingControl>"
            ],
            [
                "namedControls",
                "java.util.ArrayList<jdk.jfr.internal.EventControl$NamedControl>"
            ],
            [
                "type",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "idName",
                "java.lang.String"
            ]
        ],
        "EventInstrumentation": [
            [
                "FIELD_DURATION",
                "jdk.jfr.internal.util.Bytecode$FieldDesc"
            ],
            [
                "FIELD_EVENT_CONFIGURATION",
                "jdk.jfr.internal.util.Bytecode$FieldDesc"
            ],
            [
                "FIELD_START_TIME",
                "jdk.jfr.internal.util.Bytecode$FieldDesc"
            ],
            [
                "ANNOTATION_ENABLED",
                "java.lang.constant.ClassDesc"
            ],
            [
                "ANNOTATION_NAME",
                "java.lang.constant.ClassDesc"
            ],
            [
                "ANNOTATION_REGISTERED",
                "java.lang.constant.ClassDesc"
            ],
            [
                "ANNOTATION_REMOVE_FIELDS",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_EVENT_CONFIGURATION",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_ISE",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_EVENT_WRITER",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_EVENT_WRITER_FACTORY",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_OBJECT",
                "java.lang.constant.ClassDesc"
            ],
            [
                "TYPE_SETTING_DEFINITION",
                "java.lang.constant.ClassDesc"
            ],
            [
                "METHOD_BEGIN",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_COMMIT",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_DURATION",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_ENABLED",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_END",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_EVENT_CONFIGURATION_SHOULD_COMMIT",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_EVENT_CONFIGURATION_GET_SETTING",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_EVENT_SHOULD_COMMIT",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_GET_EVENT_WRITER_KEY",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_IS_ENABLED",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_RESET",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_SHOULD_COMMIT_LONG",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "METHOD_TIME_STAMP",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "classModel",
                "java.lang.classfile.ClassModel"
            ],
            [
                "settingDescs",
                "java.util.List<jdk.jfr.internal.EventInstrumentation$SettingDesc>"
            ],
            [
                "fieldDescs",
                "java.util.List<jdk.jfr.internal.util.Bytecode$FieldDesc>"
            ],
            [
                "eventName",
                "java.lang.String"
            ],
            [
                "className",
                "java.lang.String"
            ],
            [
                "superClass",
                "java.lang.Class<?>"
            ],
            [
                "untypedEventConfiguration",
                "boolean"
            ],
            [
                "staticCommitMethod",
                "jdk.jfr.internal.util.Bytecode$MethodDesc"
            ],
            [
                "eventTypeId",
                "long"
            ],
            [
                "guardEventConfiguration",
                "boolean"
            ],
            [
                "isJDK",
                "boolean"
            ],
            [
                "methodUpdates",
                "java.util.function.Consumer<java.lang.classfile.CodeBuilder>>"
            ],
            [
                "implicitFields",
                "jdk.jfr.internal.util.ImplicitFields"
            ]
        ],
        "EventWriterFactoryRecipe": [
            [
                "KEY",
                "long"
            ]
        ],
        "EventWriterKey": [
            [
                "KEY",
                "long"
            ],
            [
                "loaded",
                "boolean"
            ],
            [
                "logged",
                "boolean"
            ]
        ],
        "EventWriterMethod": [
            [
                "BEGIN_EVENT",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "END_EVENT",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_BYTE",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_SHORT",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_INT",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_LONG",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_FLOAT",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_DOUBLE",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_CHAR",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_BOOLEAN",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_THREAD",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_CLASS",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_STRING",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_EVENT_THREAD",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "PUT_STACK_TRACE",
                "jdk.jfr.internal.EventWriterMethod"
            ],
            [
                "$VALUES",
                "jdk.jfr.internal.EventWriterMethod[]"
            ]
        ],
        "FilePurger": [
            [
                "paths",
                "java.util.SequencedSet<jdk.jfr.internal.SecuritySupport$SafePath>"
            ]
        ],
        "JDKEvents": [
            [
                "eventClasses",
                "java.lang.Class<?>[]"
            ],
            [
                "emitExceptionStatistics",
                "java.lang.Runnable"
            ],
            [
                "emitDirectBufferStatistics",
                "java.lang.Runnable"
            ],
            [
                "emitContainerConfiguration",
                "java.lang.Runnable"
            ],
            [
                "emitContainerCPUUsage",
                "java.lang.Runnable"
            ],
            [
                "emitContainerCPUThrottling",
                "java.lang.Runnable"
            ],
            [
                "emitContainerMemoryUsage",
                "java.lang.Runnable"
            ],
            [
                "emitContainerIOUsage",
                "java.lang.Runnable"
            ],
            [
                "emitInitialSecurityProperties",
                "java.lang.Runnable"
            ],
            [
                "containerMetrics",
                "jdk.internal.platform.Metrics"
            ],
            [
                "initializationTriggered",
                "boolean"
            ]
        ],
        "JVM": [
            [
                "jvm",
                "jdk.jfr.internal.JVM"
            ],
            [
                "CHUNK_ROTATION_MONITOR",
                "java.lang.Object"
            ],
            [
                "nativeOK",
                "boolean"
            ]
        ],
        "JVMSupport": [
            [
                "UNSUPPORTED_VM_MESSAGE",
                "java.lang.String"
            ],
            [
                "notAvailable",
                "boolean"
            ],
            [
                "lastTimestamp",
                "java.time.Instant"
            ],
            [
                "nativeOK",
                "boolean"
            ]
        ],
        "JVMUpcalls": [],
        "Level": [
            [
                "NAME",
                "java.lang.String"
            ]
        ],
        "LogLevel": [
            [
                "TRACE",
                "jdk.jfr.internal.LogLevel"
            ],
            [
                "DEBUG",
                "jdk.jfr.internal.LogLevel"
            ],
            [
                "INFO",
                "jdk.jfr.internal.LogLevel"
            ],
            [
                "WARN",
                "jdk.jfr.internal.LogLevel"
            ],
            [
                "ERROR",
                "jdk.jfr.internal.LogLevel"
            ],
            [
                "$VALUES",
                "jdk.jfr.internal.LogLevel[]"
            ]
        ],
        "LogTag": [
            [
                "JFR",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_EVENT",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_SETTING",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_BYTECODE",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_PARSER",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_METADATA",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_STREAMING",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_THROTTLE",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SYSTEM_PERIODIC",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_PERIODIC",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_METADATA",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_EVENT",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_SETTING",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_DCMD",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "JFR_START",
                "jdk.jfr.internal.LogTag"
            ],
            [
                "$VALUES",
                "jdk.jfr.internal.LogTag[]"
            ]
        ],
        "Logger": [
            [
                "MAX_SIZE",
                "int"
            ],
            [
                "MAX_EVENT_SIZE",
                "int"
            ]
        ],
        "LongMap": [
            [
                "MAXIMUM_CAPACITY",
                "int"
            ],
            [
                "EMPTY_KEYS",
                "long[]"
            ],
            [
                "EMPTY_OBJECTS",
                "java.lang.Object[]"
            ],
            [
                "DEFAULT_SIZE",
                "int"
            ],
            [
                "NULL_OBJECT",
                "java.lang.Object"
            ],
            [
                "bitCount",
                "int"
            ],
            [
                "bitSet",
                "java.util.BitSet"
            ],
            [
                "keys",
                "long[]"
            ],
            [
                "objects",
                "T[]"
            ],
            [
                "count",
                "int"
            ],
            [
                "shift",
                "int"
            ]
        ],
        "MetadataDescriptor": [
            [
                "metadataId",
                "long"
            ]
        ],
        "MetadataLoader": [
            [
                "RELATIONAL",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "ENABLED",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "DISABLED",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "THRESHOLD",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "STACK_TRACE",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "TRANSITION_TO",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "TRANSITION_FROM",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "EXPERIMENTAL",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "UNSIGNED",
                "jdk.jfr.AnnotationElement"
            ],
            [
                "SMALL_TEMP_LIST",
                "java.util.List<java.lang.Object>"
            ],
            [
                "LABEL_TYPE",
                "jdk.jfr.internal.Type"
            ],
            [
                "DESCRIPTION_TYPE",
                "jdk.jfr.internal.Type"
            ],
            [
                "CATEGORY_TYPE",
                "jdk.jfr.internal.Type"
            ],
            [
                "PERIOD_TYPE",
                "jdk.jfr.internal.Type"
            ],
            [
                "types",
                "java.util.List<jdk.jfr.internal.MetadataLoader$TypeElement>"
            ],
            [
                "anotationElements",
                "java.util.List<jdk.jfr.AnnotationElement>>"
            ],
            [
                "categories",
                "jdk.jfr.AnnotationElement>"
            ]
        ],
        "MetadataReader": [
            [
                "input",
                "java.io.DataInput"
            ],
            [
                "pool",
                "java.util.List<java.lang.String>"
            ],
            [
                "descriptor",
                "jdk.jfr.internal.MetadataDescriptor"
            ],
            [
                "types",
                "jdk.jfr.internal.Type>"
            ]
        ],
        "MetadataRepository": [
            [
                "instance",
                "jdk.jfr.internal.MetadataRepository"
            ],
            [
                "nativeEventTypes",
                "jdk.jfr.EventType>"
            ],
            [
                "nativeControls",
                "jdk.jfr.internal.EventControl>"
            ],
            [
                "settingsManager",
                "jdk.jfr.internal.SettingsManager"
            ],
            [
                "threadSleeper",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "cachedEventConfigurationConstructor",
                "java.lang.reflect.Constructor<jdk.jfr.internal.event.EventConfiguration>"
            ],
            [
                "staleMetadata",
                "boolean"
            ],
            [
                "unregistered",
                "boolean"
            ],
            [
                "lastUnloaded",
                "long"
            ],
            [
                "lastMillis",
                "long"
            ]
        ],
        "MetadataWriter": [
            [
                "metadata",
                "jdk.jfr.internal.MetadataDescriptor$Element"
            ],
            [
                "root",
                "jdk.jfr.internal.MetadataDescriptor$Element"
            ]
        ],
        "MirrorEvent": [],
        "MirrorEvents": [
            [
                "mirrorLookup",
                "jdk.jfr.internal.MirrorEvent>>"
            ]
        ],
        "OldObjectSample": [
            [
                "EVENT_NAME",
                "java.lang.String"
            ],
            [
                "OLD_OBJECT_CUTOFF",
                "java.lang.String"
            ],
            [
                "OLD_OBJECT_ENABLED",
                "java.lang.String"
            ]
        ],
        "Options": [
            [
                "WAIT_INTERVAL",
                "long"
            ],
            [
                "MIN_MAX_CHUNKSIZE",
                "long"
            ],
            [
                "DEFAULT_GLOBAL_BUFFER_COUNT",
                "long"
            ],
            [
                "DEFAULT_GLOBAL_BUFFER_SIZE",
                "long"
            ],
            [
                "DEFAULT_MEMORY_SIZE",
                "long"
            ],
            [
                "DEFAULT_THREAD_BUFFER_SIZE",
                "long"
            ],
            [
                "DEFAULT_STACK_DEPTH",
                "int"
            ],
            [
                "DEFAULT_MAX_CHUNK_SIZE",
                "long"
            ],
            [
                "DEFAULT_DUMP_PATH",
                "jdk.jfr.internal.SecuritySupport$SafePath"
            ],
            [
                "DEFAULT_PRESERVE_REPOSITORY",
                "boolean"
            ],
            [
                "memorySize",
                "long"
            ],
            [
                "globalBufferSize",
                "long"
            ],
            [
                "globalBufferCount",
                "long"
            ],
            [
                "threadBufferSize",
                "long"
            ],
            [
                "stackDepth",
                "int"
            ],
            [
                "maxChunkSize",
                "long"
            ],
            [
                "preserveRepository",
                "boolean"
            ]
        ],
        "PlatformEventType": [
            [
                "isJVM",
                "boolean"
            ],
            [
                "isJDK",
                "boolean"
            ],
            [
                "isMethodSampling",
                "boolean"
            ],
            [
                "settings",
                "java.util.List<jdk.jfr.SettingDescriptor>"
            ],
            [
                "dynamicSettings",
                "boolean"
            ],
            [
                "stackTraceOffset",
                "int"
            ],
            [
                "startFilterId",
                "long"
            ],
            [
                "largeSize",
                "boolean"
            ],
            [
                "enabled",
                "boolean"
            ],
            [
                "stackTraceEnabled",
                "boolean"
            ],
            [
                "thresholdTicks",
                "long"
            ],
            [
                "period",
                "long"
            ],
            [
                "hasHook",
                "boolean"
            ],
            [
                "beginChunk",
                "boolean"
            ],
            [
                "endChunk",
                "boolean"
            ],
            [
                "hasPeriod",
                "boolean"
            ],
            [
                "hasCutoff",
                "boolean"
            ],
            [
                "hasThrottle",
                "boolean"
            ],
            [
                "isInstrumented",
                "boolean"
            ],
            [
                "markForInstrumentation",
                "boolean"
            ],
            [
                "registered",
                "boolean"
            ],
            [
                "committable",
                "boolean"
            ],
            [
                "hasLevel",
                "boolean"
            ]
        ],
        "PlatformRecorder": [
            [
                "recordings",
                "java.util.ArrayList<jdk.jfr.internal.PlatformRecording>"
            ],
            [
                "changeListeners",
                "java.util.List<jdk.jfr.internal.SecuritySupport$SecureRecorderListener>"
            ],
            [
                "repository",
                "jdk.jfr.internal.Repository"
            ],
            [
                "shutdownHook",
                "java.lang.Thread"
            ],
            [
                "timer",
                "java.util.Timer"
            ],
            [
                "recordingCounter",
                "long"
            ],
            [
                "currentChunk",
                "jdk.jfr.internal.RepositoryChunk"
            ],
            [
                "inShutdown",
                "boolean"
            ],
            [
                "runPeriodicTask",
                "boolean"
            ]
        ],
        "PlatformRecording": [
            [
                "recorder",
                "jdk.jfr.internal.PlatformRecorder"
            ],
            [
                "id",
                "long"
            ],
            [
                "settings",
                "java.lang.String>"
            ],
            [
                "duration",
                "java.time.Duration"
            ],
            [
                "maxAge",
                "java.time.Duration"
            ],
            [
                "maxSize",
                "long"
            ],
            [
                "destination",
                "jdk.jfr.internal.WriteableUserPath"
            ],
            [
                "toDisk",
                "boolean"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "dumpOnExit",
                "boolean"
            ],
            [
                "dumpDirectory",
                "jdk.jfr.internal.SecuritySupport$SafePath"
            ],
            [
                "stopTime",
                "java.time.Instant"
            ],
            [
                "startTime",
                "java.time.Instant"
            ],
            [
                "state",
                "jdk.jfr.RecordingState"
            ],
            [
                "size",
                "long"
            ],
            [
                "chunks",
                "java.util.LinkedList<jdk.jfr.internal.RepositoryChunk>"
            ],
            [
                "recording",
                "jdk.jfr.Recording"
            ],
            [
                "stopTask",
                "java.util.TimerTask"
            ],
            [
                "startTask",
                "java.util.TimerTask"
            ],
            [
                "dumpDirectoryControlContext",
                "java.security.AccessControlContext"
            ],
            [
                "shouldWriteActiveRecordingEvent",
                "boolean"
            ],
            [
                "flushInterval",
                "java.time.Duration"
            ],
            [
                "finalStartChunkNanos",
                "long"
            ],
            [
                "startNanos",
                "long"
            ]
        ],
        "PrivateAccess": [
            [
                "instance",
                "jdk.jfr.internal.PrivateAccess"
            ]
        ],
        "RemoveFields": [],
        "Repository": [
            [
                "MAX_REPO_CREATION_RETRIES",
                "int"
            ],
            [
                "instance",
                "jdk.jfr.internal.Repository"
            ],
            [
                "JFR_REPOSITORY_LOCATION_PROPERTY",
                "java.lang.String"
            ],
            [
                "cleanupDirectories",
                "java.util.Set<jdk.jfr.internal.SecuritySupport$SafePath>"
            ],
            [
                "baseLocation",
                "jdk.jfr.internal.SecuritySupport$SafePath"
            ],
            [
                "repository",
                "jdk.jfr.internal.SecuritySupport$SafePath"
            ],
            [
                "chunkFilename",
                "jdk.jfr.internal.management.ChunkFilename"
            ]
        ],
        "RepositoryChunk": [
            [
                "chunkFile",
                "jdk.jfr.internal.SecuritySupport$SafePath"
            ],
            [
                "unFinishedRAF",
                "java.io.RandomAccessFile"
            ],
            [
                "endTime",
                "java.time.Instant"
            ],
            [
                "startTime",
                "java.time.Instant"
            ],
            [
                "refCount",
                "int"
            ],
            [
                "size",
                "long"
            ]
        ],
        "SecuritySupport": [
            [
                "EVENTS_PACKAGE_NAME",
                "java.lang.String"
            ],
            [
                "EVENT_PACKAGE_NAME",
                "java.lang.String"
            ],
            [
                "REGISTER_EVENT",
                "java.lang.String"
            ],
            [
                "ACCESS_FLIGHT_RECORDER",
                "java.lang.String"
            ],
            [
                "LOOKUP",
                "java.lang.invoke.MethodHandles$Lookup"
            ],
            [
                "JFR_MODULE",
                "java.lang.Module"
            ],
            [
                "JFC_DIRECTORY",
                "jdk.jfr.internal.SecuritySupport$SafePath"
            ],
            [
                "PRIVILEGED",
                "jdk.jfr.internal.consumer.FileAccess"
            ]
        ],
        "SettingsManager": [
            [
                "availableSettings",
                "jdk.jfr.internal.SettingsManager$InternalSetting>"
            ]
        ],
        "ShutdownHook": [
            [
                "recorder",
                "jdk.jfr.internal.PlatformRecorder"
            ]
        ],
        "StringPool": [
            [
                "MIN_LIMIT",
                "int"
            ],
            [
                "MAX_LIMIT",
                "int"
            ],
            [
                "PRECACHE_THRESHOLD",
                "int"
            ],
            [
                "DO_NOT_POOL",
                "long"
            ],
            [
                "MAX_SIZE",
                "int"
            ],
            [
                "MAX_SIZE_UTF16",
                "long"
            ],
            [
                "SID_MASK",
                "long"
            ],
            [
                "sidIdx",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "preCache",
                "java.lang.String[]"
            ],
            [
                "cache",
                "java.lang.Long>"
            ],
            [
                "preCacheMask",
                "int"
            ],
            [
                "preCacheOld",
                "int"
            ],
            [
                "currentSizeUTF16",
                "long"
            ]
        ],
        "Throttle": [
            [
                "NAME",
                "java.lang.String"
            ],
            [
                "DEFAULT",
                "java.lang.String"
            ]
        ],
        "Type": [
            [
                "SUPER_TYPE_ANNOTATION",
                "java.lang.String"
            ],
            [
                "SUPER_TYPE_SETTING",
                "java.lang.String"
            ],
            [
                "SUPER_TYPE_EVENT",
                "java.lang.String"
            ],
            [
                "EVENT_NAME_PREFIX",
                "java.lang.String"
            ],
            [
                "TYPES_PREFIX",
                "java.lang.String"
            ],
            [
                "SETTINGS_PREFIX",
                "java.lang.String"
            ],
            [
                "knownTypes",
                "java.lang.Class<?>>"
            ],
            [
                "STACK_TRACE",
                "jdk.jfr.internal.Type"
            ],
            [
                "annos",
                "jdk.jfr.internal.AnnotationConstruct"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "superType",
                "java.lang.String"
            ],
            [
                "fields",
                "java.util.List<jdk.jfr.ValueDescriptor>"
            ],
            [
                "simpleType",
                "java.lang.Boolean"
            ],
            [
                "remove",
                "boolean"
            ],
            [
                "id",
                "long"
            ],
            [
                "visible",
                "boolean"
            ],
            [
                "internal",
                "boolean"
            ]
        ],
        "TypeLibrary": [
            [
                "implicitFieldTypes",
                "boolean"
            ],
            [
                "types",
                "jdk.jfr.internal.Type>"
            ],
            [
                "initialized",
                "boolean"
            ]
        ],
        "WriteableUserPath": [
            [
                "controlContext",
                "java.security.AccessControlContext"
            ],
            [
                "original",
                "java.nio.file.Path"
            ],
            [
                "real",
                "java.nio.file.Path"
            ],
            [
                "realPathText",
                "java.lang.String"
            ],
            [
                "originalText",
                "java.lang.String"
            ],
            [
                "inPrivileged",
                "boolean"
            ]
        ]
    },
    "jdk.jfr.internal.consumer": {
        "AbstractEventStream": [
            [
                "counter",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "terminated",
                "java.util.concurrent.CountDownLatch"
            ],
            [
                "flushOperation",
                "java.lang.Runnable"
            ],
            [
                "accessControllerContext",
                "java.security.AccessControlContext"
            ],
            [
                "streamConfiguration",
                "jdk.jfr.internal.consumer.StreamConfiguration"
            ],
            [
                "configurations",
                "java.util.List<jdk.jfr.Configuration>"
            ],
            [
                "parserState",
                "jdk.jfr.internal.consumer.ParserState"
            ],
            [
                "closeOnComplete",
                "boolean"
            ],
            [
                "dispatcher",
                "jdk.jfr.internal.consumer.Dispatcher"
            ],
            [
                "daemon",
                "boolean"
            ]
        ],
        "ChunkHeader": [
            [
                "HEADER_SIZE",
                "long"
            ],
            [
                "CHUNK_SIZE_POSITION",
                "long"
            ],
            [
                "major",
                "short"
            ],
            [
                "minor",
                "short"
            ],
            [
                "chunkStartTicks",
                "long"
            ],
            [
                "ticksPerSecond",
                "long"
            ],
            [
                "chunkStartNanos",
                "long"
            ],
            [
                "absoluteChunkStart",
                "long"
            ],
            [
                "input",
                "jdk.jfr.internal.consumer.RecordingInput"
            ],
            [
                "id",
                "long"
            ],
            [
                "absoluteEventStart",
                "long"
            ],
            [
                "chunkSize",
                "long"
            ],
            [
                "constantPoolPosition",
                "long"
            ],
            [
                "metadataPosition",
                "long"
            ],
            [
                "durationNanos",
                "long"
            ],
            [
                "absoluteChunkEnd",
                "long"
            ],
            [
                "finished",
                "boolean"
            ],
            [
                "finalChunk",
                "boolean"
            ]
        ],
        "ChunkParser": [
            [
                "FLUSH_MARKER",
                "jdk.jfr.consumer.RecordedEvent"
            ],
            [
                "CONSTANT_POOL_TYPE_ID",
                "long"
            ],
            [
                "input",
                "jdk.jfr.internal.consumer.RecordingInput"
            ],
            [
                "chunkHeader",
                "jdk.jfr.internal.consumer.ChunkHeader"
            ],
            [
                "timeConverter",
                "jdk.jfr.internal.consumer.TimeConverter"
            ],
            [
                "parserState",
                "jdk.jfr.internal.consumer.ParserState"
            ],
            [
                "constantLookups",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.ConstantLookup>"
            ],
            [
                "typeMap",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.Type>"
            ],
            [
                "parsers",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.Parser>"
            ],
            [
                "chunkFinished",
                "boolean"
            ],
            [
                "configuration",
                "jdk.jfr.internal.consumer.ChunkParser$ParserConfiguration"
            ],
            [
                "previousMetadata",
                "jdk.jfr.internal.MetadataDescriptor"
            ],
            [
                "metadata",
                "jdk.jfr.internal.MetadataDescriptor"
            ],
            [
                "lastFlush",
                "long"
            ],
            [
                "staleMetadata",
                "boolean"
            ]
        ],
        "CompositeParser": [],
        "ConstantLookup": [
            [
                "type",
                "jdk.jfr.internal.Type"
            ],
            [
                "current",
                "jdk.jfr.internal.consumer.ConstantMap"
            ],
            [
                "previous",
                "jdk.jfr.internal.consumer.ConstantMap"
            ]
        ],
        "ConstantMap": [
            [
                "RESOLUTION_FINISHED",
                "int"
            ],
            [
                "RESOLUTION_STARTED",
                "int"
            ],
            [
                "EMPTY",
                "jdk.jfr.internal.consumer.ConstantMap"
            ],
            [
                "objects",
                "jdk.jfr.internal.LongMap<java.lang.Object>"
            ],
            [
                "resolving",
                "boolean"
            ],
            [
                "allResolved",
                "boolean"
            ]
        ],
        "Dispatcher": [
            [
                "errorActions",
                "java.util.function.Consumer<java.lang.Throwable>[]"
            ],
            [
                "metadataActions",
                "java.util.function.Consumer<jdk.jfr.consumer.MetadataEvent>[]"
            ],
            [
                "flushActions",
                "java.lang.Runnable[]"
            ],
            [
                "closeActions",
                "java.lang.Runnable[]"
            ],
            [
                "dispatchers",
                "jdk.jfr.internal.consumer.Dispatcher$EventDispatcher[]"
            ],
            [
                "dispatcherLookup",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.Dispatcher$EventDispatcher[]>"
            ],
            [
                "cacheEventType",
                "jdk.jfr.EventType"
            ],
            [
                "cacheDispatchers",
                "jdk.jfr.internal.consumer.Dispatcher$EventDispatcher[]"
            ]
        ],
        "EventDirectoryStream": [
            [
                "EVENT_COMPARATOR",
                "jdk.jfr.consumer.RecordedEvent>"
            ],
            [
                "repositoryFiles",
                "jdk.jfr.internal.consumer.RepositoryFiles"
            ],
            [
                "fileAccess",
                "jdk.jfr.internal.consumer.FileAccess"
            ],
            [
                "recording",
                "jdk.jfr.internal.PlatformRecording"
            ],
            [
                "barrier",
                "jdk.jfr.internal.management.StreamBarrier"
            ],
            [
                "streamId",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "currentParser",
                "jdk.jfr.internal.consumer.ChunkParser"
            ],
            [
                "currentChunkStartNanos",
                "long"
            ],
            [
                "sortedCache",
                "jdk.jfr.consumer.RecordedEvent[]"
            ],
            [
                "threadExclusionLevel",
                "int"
            ],
            [
                "onCompleteHandler",
                "java.util.function.Consumer<java.lang.Long>"
            ]
        ],
        "EventFileStream": [
            [
                "EVENT_COMPARATOR",
                "jdk.jfr.consumer.RecordedEvent>"
            ],
            [
                "input",
                "jdk.jfr.internal.consumer.RecordingInput"
            ],
            [
                "currentParser",
                "jdk.jfr.internal.consumer.ChunkParser"
            ],
            [
                "cacheSorted",
                "jdk.jfr.consumer.RecordedEvent[]"
            ]
        ],
        "EventLog": [
            [
                "logStream",
                "jdk.jfr.consumer.EventStream"
            ],
            [
                "prettyWriter",
                "jdk.jfr.internal.tool.PrettyWriter"
            ],
            [
                "logWriter",
                "jdk.jfr.internal.consumer.EventLog$LogWriter"
            ],
            [
                "systemEventLookup",
                "java.util.Set<java.lang.Long>"
            ]
        ],
        "EventParser": [
            [
                "PRIVATE_ACCESS",
                "jdk.jfr.internal.consumer.JdkJfrConsumer"
            ],
            [
                "parsers",
                "jdk.jfr.internal.consumer.Parser[]"
            ],
            [
                "eventType",
                "jdk.jfr.EventType"
            ],
            [
                "timeConverter",
                "jdk.jfr.internal.consumer.TimeConverter"
            ],
            [
                "hasDuration",
                "boolean"
            ],
            [
                "valueDescriptors",
                "java.util.List<jdk.jfr.ValueDescriptor>"
            ],
            [
                "startIndex",
                "int"
            ],
            [
                "length",
                "int"
            ],
            [
                "unorderedEvent",
                "jdk.jfr.consumer.RecordedEvent"
            ],
            [
                "objectContext",
                "jdk.jfr.internal.consumer.ObjectContext"
            ],
            [
                "cached",
                "jdk.jfr.consumer.RecordedEvent[]"
            ],
            [
                "cacheIndex",
                "int"
            ],
            [
                "enabled",
                "boolean"
            ],
            [
                "ordered",
                "boolean"
            ],
            [
                "filterStart",
                "long"
            ],
            [
                "filterEnd",
                "long"
            ],
            [
                "thresholdNanos",
                "long"
            ]
        ],
        "FileAccess": [
            [
                "UNPRIVILEGED",
                "jdk.jfr.internal.consumer.FileAccess"
            ]
        ],
        "FinishedStream": [
            [
                "inputStream",
                "java.io.BufferedInputStream"
            ],
            [
                "buffer",
                "byte[]"
            ]
        ],
        "JdkJfrConsumer": [
            [
                "instance",
                "jdk.jfr.internal.consumer.JdkJfrConsumer"
            ]
        ],
        "ObjectContext": [
            [
                "contextLookup",
                "jdk.jfr.internal.consumer.ObjectContext>"
            ],
            [
                "timeConverter",
                "jdk.jfr.internal.consumer.TimeConverter"
            ],
            [
                "eventType",
                "jdk.jfr.EventType"
            ],
            [
                "fields",
                "java.util.List<jdk.jfr.ValueDescriptor>"
            ]
        ],
        "ObjectFactory": [
            [
                "PRIVATE_ACCESS",
                "jdk.jfr.internal.consumer.JdkJfrConsumer"
            ],
            [
                "TYPE_PREFIX_VERSION_1",
                "java.lang.String"
            ],
            [
                "TYPE_PREFIX_VERSION_2",
                "java.lang.String"
            ],
            [
                "STACK_FRAME_VERSION_1",
                "java.lang.String"
            ],
            [
                "STACK_FRAME_VERSION_2",
                "java.lang.String"
            ],
            [
                "objectContext",
                "jdk.jfr.internal.consumer.ObjectContext"
            ]
        ],
        "OngoingStream": [
            [
                "EMPTY_ARRAY",
                "byte[]"
            ],
            [
                "HEADER_SIZE",
                "int"
            ],
            [
                "HEADER_FILE_STATE_POSITION",
                "int"
            ],
            [
                "MODIFYING_STATE",
                "byte"
            ],
            [
                "repositoryFiles",
                "jdk.jfr.internal.consumer.RepositoryFiles"
            ],
            [
                "recording",
                "jdk.jfr.Recording"
            ],
            [
                "threadSleeper",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "blockSize",
                "int"
            ],
            [
                "endTimeNanos",
                "long"
            ],
            [
                "headerBytes",
                "byte[]"
            ],
            [
                "input",
                "jdk.jfr.internal.consumer.RecordingInput"
            ],
            [
                "header",
                "jdk.jfr.internal.consumer.ChunkHeader"
            ],
            [
                "position",
                "long"
            ],
            [
                "startTimeNanos",
                "long"
            ],
            [
                "path",
                "java.nio.file.Path"
            ],
            [
                "first",
                "boolean"
            ]
        ],
        "Parser": [],
        "ParserFactory": [
            [
                "parsers",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.Parser>"
            ],
            [
                "timeConverter",
                "jdk.jfr.internal.consumer.TimeConverter"
            ],
            [
                "types",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.Type>"
            ],
            [
                "constantLookups",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.ConstantLookup>"
            ]
        ],
        "ParserFilter": [
            [
                "ACCEPT_ALL",
                "jdk.jfr.internal.consumer.ParserFilter"
            ],
            [
                "thresholds",
                "java.lang.Long>"
            ],
            [
                "acceptAll",
                "boolean"
            ]
        ],
        "ParserState": [
            [
                "closed",
                "boolean"
            ]
        ],
        "RecordingInput": [
            [
                "DEFAULT_BLOCK_SIZE",
                "int"
            ],
            [
                "blockSize",
                "int"
            ],
            [
                "fileAccess",
                "jdk.jfr.internal.consumer.FileAccess"
            ],
            [
                "threadSleeper",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "pollCount",
                "long"
            ],
            [
                "file",
                "java.io.RandomAccessFile"
            ],
            [
                "filename",
                "java.lang.String"
            ],
            [
                "currentBlock",
                "jdk.jfr.internal.consumer.RecordingInput$Block"
            ],
            [
                "previousBlock",
                "jdk.jfr.internal.consumer.RecordingInput$Block"
            ],
            [
                "position",
                "long"
            ],
            [
                "size",
                "long"
            ]
        ],
        "Reference": [
            [
                "pool",
                "jdk.jfr.internal.consumer.ConstantMap"
            ],
            [
                "key",
                "long"
            ]
        ],
        "RepositoryFiles": [
            [
                "WAIT_OBJECT",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "DIRECTORY_PATTERN",
                "java.lang.String"
            ],
            [
                "fileAccess",
                "jdk.jfr.internal.consumer.FileAccess"
            ],
            [
                "pathSet",
                "java.nio.file.Path>"
            ],
            [
                "pathLookup",
                "java.lang.Long>"
            ],
            [
                "waitObject",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "allowSubDirectory",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "repository",
                "java.nio.file.Path"
            ]
        ],
        "StreamConfiguration": [
            [
                "changed",
                "boolean"
            ]
        ],
        "StringParser": [
            [
                "stringLookup",
                "jdk.jfr.internal.consumer.ConstantLookup"
            ],
            [
                "charArrayParser",
                "jdk.jfr.internal.consumer.StringParser$CharArrayParser"
            ],
            [
                "utf8parser",
                "jdk.jfr.internal.consumer.StringParser$CharsetParser"
            ],
            [
                "latin1parser",
                "jdk.jfr.internal.consumer.StringParser$CharsetParser"
            ],
            [
                "event",
                "boolean"
            ]
        ],
        "TimeConverter": [
            [
                "startTicks",
                "long"
            ],
            [
                "startNanos",
                "long"
            ],
            [
                "divisor",
                "double"
            ],
            [
                "zoneOffset",
                "java.time.ZoneOffset"
            ]
        ]
    },
    "jdk.jfr.internal.consumer.filter": {
        "CheckpointEvent": [
            [
                "chunkWriter",
                "jdk.jfr.internal.consumer.filter.ChunkWriter"
            ],
            [
                "pools",
                "jdk.jfr.internal.consumer.filter.CheckpointPool>"
            ],
            [
                "startPosition",
                "long"
            ]
        ],
        "CheckpointPool": [
            [
                "entries",
                "java.util.List<jdk.jfr.internal.consumer.filter.PoolEntry>"
            ],
            [
                "typeId",
                "long"
            ]
        ],
        "ChunkWriter": [
            [
                "pools",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.filter.Constants>"
            ],
            [
                "checkpoints",
                "java.util.Deque<jdk.jfr.internal.consumer.filter.CheckpointEvent>"
            ],
            [
                "destination",
                "java.nio.file.Path"
            ],
            [
                "input",
                "jdk.jfr.internal.consumer.RecordingInput"
            ],
            [
                "output",
                "jdk.jfr.internal.consumer.filter.RecordingOutput"
            ],
            [
                "filter",
                "java.util.function.Predicate<jdk.jfr.consumer.RecordedEvent>"
            ],
            [
                "waste",
                "java.lang.Long>"
            ],
            [
                "chunkStartPosition",
                "long"
            ],
            [
                "chunkComplete",
                "boolean"
            ],
            [
                "lastCheckpoint",
                "long"
            ]
        ],
        "Constants": [
            [
                "table",
                "jdk.jfr.internal.LongMap<jdk.jfr.internal.consumer.filter.PoolEntry>"
            ],
            [
                "type",
                "jdk.jfr.internal.Type"
            ]
        ],
        "PoolEntry": [
            [
                "startPosition",
                "long"
            ],
            [
                "endPosition",
                "long"
            ],
            [
                "type",
                "jdk.jfr.internal.Type"
            ],
            [
                "keyId",
                "long"
            ],
            [
                "references",
                "java.lang.Object"
            ],
            [
                "touched",
                "boolean"
            ]
        ],
        "RecordingOutput": [
            [
                "file",
                "java.io.RandomAccessFile"
            ],
            [
                "buffer",
                "byte[]"
            ],
            [
                "bufferPosition",
                "int"
            ],
            [
                "position",
                "long"
            ]
        ]
    },
    "jdk.jfr.internal.dcmd": {
        "AbstractDCmd": [
            [
                "output",
                "jdk.jfr.internal.util.Output$LinePrinter"
            ],
            [
                "source",
                "java.lang.String"
            ]
        ],
        "Argument": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.String"
            ],
            [
                "mandatory",
                "boolean"
            ],
            [
                "option",
                "boolean"
            ],
            [
                "defaultValue",
                "java.lang.String"
            ],
            [
                "allowMultiple",
                "boolean"
            ]
        ],
        "ArgumentParser": [
            [
                "options",
                "java.lang.Object>"
            ],
            [
                "extendedOptions",
                "java.lang.Object>"
            ],
            [
                "conflictedOptions",
                "java.util.List<java.lang.String>"
            ],
            [
                "builder",
                "java.lang.StringBuilder"
            ],
            [
                "text",
                "java.lang.String"
            ],
            [
                "delimiter",
                "char"
            ],
            [
                "keyValueDelimiter",
                "java.lang.String"
            ],
            [
                "valueDelimiter",
                "java.lang.String"
            ],
            [
                "arguments",
                "jdk.jfr.internal.dcmd.Argument[]"
            ],
            [
                "position",
                "int"
            ],
            [
                "argumentIndex",
                "int"
            ]
        ],
        "DCmdCheck": [],
        "DCmdConfigure": [],
        "DCmdDump": [],
        "DCmdException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DCmdQuery": [],
        "DCmdStart": [],
        "DCmdStop": [],
        "DCmdView": [],
        "QueryRecording": [
            [
                "DEFAULT_MAX_SIZE",
                "long"
            ],
            [
                "DEFAULT_MAX_AGE",
                "long"
            ],
            [
                "recorder",
                "jdk.jfr.internal.PlatformRecorder"
            ],
            [
                "chunks",
                "java.util.List<jdk.jfr.internal.RepositoryChunk>"
            ],
            [
                "eventStream",
                "jdk.jfr.consumer.EventStream"
            ],
            [
                "endTime",
                "java.time.Instant"
            ]
        ]
    },
    "jdk.jfr.internal.event": {
        "EventConfiguration": [
            [
                "platformEventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "eventType",
                "jdk.jfr.EventType"
            ],
            [
                "eventControl",
                "jdk.jfr.internal.EventControl"
            ],
            [
                "settings",
                "jdk.jfr.SettingControl[]"
            ]
        ],
        "EventWriter": [
            [
                "MAX_EVENT_SIZE",
                "long"
            ],
            [
                "unsafe",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "threadID",
                "long"
            ],
            [
                "startPosition",
                "long"
            ],
            [
                "currentPosition",
                "long"
            ],
            [
                "maxPosition",
                "long"
            ],
            [
                "valid",
                "boolean"
            ],
            [
                "pinVirtualThread",
                "boolean"
            ],
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "largeSize",
                "boolean"
            ]
        ]
    },
    "jdk.jfr.internal.jfc": {
        "JFC": [
            [
                "BUFFER_SIZE",
                "int"
            ],
            [
                "MAXIMUM_FILE_SIZE",
                "int"
            ],
            [
                "MAX_BUFFER_SIZE",
                "int"
            ],
            [
                "knownConfigurations",
                "java.util.List<jdk.jfr.internal.jfc.JFC$KnownConfiguration>"
            ]
        ],
        "JFCParser": [
            [
                "MAXIMUM_FILE_SIZE",
                "int"
            ]
        ],
        "JFCParserHandler": [
            [
                "ELEMENT_CONFIGURATION",
                "java.lang.String"
            ],
            [
                "ELEMENT_EVENT_TYPE",
                "java.lang.String"
            ],
            [
                "ELEMENT_SETTING",
                "java.lang.String"
            ],
            [
                "ATTRIBUTE_NAME",
                "java.lang.String"
            ],
            [
                "ATTRIBUTE_LABEL",
                "java.lang.String"
            ],
            [
                "ATTRIBUTE_DESCRIPTION",
                "java.lang.String"
            ],
            [
                "ATTRIBUTE_PROVIDER",
                "java.lang.String"
            ],
            [
                "ATTRIBUTE_VERSION",
                "java.lang.String"
            ],
            [
                "currentCharacters",
                "java.lang.StringBuilder"
            ],
            [
                "currentEventName",
                "java.lang.String"
            ],
            [
                "currentSettingsName",
                "java.lang.String"
            ]
        ]
    },
    "jdk.jfr.internal.jfc.model": {
        "AbortException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Constraint": [
            [
                "type",
                "jdk.jfr.internal.jfc.model.XmlElement>"
            ],
            [
                "min",
                "int"
            ],
            [
                "max",
                "int"
            ]
        ],
        "ControlElement": [],
        "JFCModel": [
            [
                "controls",
                "java.util.List<jdk.jfr.internal.jfc.model.ControlElement>>"
            ],
            [
                "configuration",
                "jdk.jfr.internal.jfc.model.XmlConfiguration"
            ],
            [
                "logger",
                "java.util.function.Consumer<java.lang.String>"
            ]
        ],
        "JFCModelException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Parser": [],
        "PrettyPrinter": [
            [
                "out",
                "java.io.PrintWriter"
            ]
        ],
        "Result": [
            [
                "value",
                "java.lang.String"
            ],
            [
                "FALSE",
                "jdk.jfr.internal.jfc.model.Result"
            ],
            [
                "TRUE",
                "jdk.jfr.internal.jfc.model.Result"
            ],
            [
                "NULL",
                "jdk.jfr.internal.jfc.model.Result"
            ]
        ],
        "SettingsLog": [
            [
                "settings",
                "java.lang.String>"
            ],
            [
                "enabled",
                "boolean"
            ]
        ],
        "UserInterface": [],
        "Utilities": [],
        "XmlAnd": [],
        "XmlCondition": [],
        "XmlConfiguration": [],
        "XmlControl": [],
        "XmlElement": [
            [
                "attributes",
                "java.lang.String>"
            ],
            [
                "elements",
                "java.util.List<jdk.jfr.internal.jfc.model.XmlElement>"
            ],
            [
                "listeners",
                "java.util.List<jdk.jfr.internal.jfc.model.XmlElement>"
            ],
            [
                "producers",
                "java.util.List<jdk.jfr.internal.jfc.model.XmlElement>"
            ],
            [
                "elementName",
                "java.lang.String"
            ],
            [
                "parent",
                "jdk.jfr.internal.jfc.model.XmlElement"
            ],
            [
                "content",
                "java.lang.String"
            ]
        ],
        "XmlEvent": [],
        "XmlExpression": [],
        "XmlFlag": [],
        "XmlInput": [],
        "XmlNot": [],
        "XmlOption": [],
        "XmlOr": [],
        "XmlSelection": [],
        "XmlSetting": [],
        "XmlTest": [],
        "XmlText": []
    },
    "jdk.jfr.internal.management": {
        "ChunkFilename": [
            [
                "MAX_CHUNK_NAMES",
                "int"
            ],
            [
                "FILE_EXTENSION",
                "java.lang.String"
            ],
            [
                "directory",
                "java.nio.file.Path"
            ],
            [
                "fileAcess",
                "jdk.jfr.internal.consumer.FileAccess"
            ],
            [
                "lastPath",
                "java.nio.file.Path"
            ],
            [
                "counter",
                "int"
            ]
        ],
        "EventByteStream": [
            [
                "NAME",
                "java.lang.String"
            ],
            [
                "idCounter",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "identifier",
                "long"
            ],
            [
                "time",
                "long"
            ]
        ],
        "EventSettingsModifier": [],
        "HiddenWait": [],
        "ManagementSupport": [],
        "StreamBarrier": [
            [
                "lock",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "activated",
                "boolean"
            ],
            [
                "used",
                "boolean"
            ],
            [
                "end",
                "long"
            ]
        ],
        "StreamCleanupTask": [
            [
                "stream",
                "jdk.jfr.internal.management.EventByteStream"
            ],
            [
                "manager",
                "jdk.jfr.internal.management.StreamManager"
            ]
        ],
        "StreamManager": [
            [
                "TIME_OUT",
                "long"
            ],
            [
                "DEFAULT_BLOCK_SIZE",
                "int"
            ],
            [
                "streams",
                "jdk.jfr.internal.management.EventByteStream>"
            ],
            [
                "timer",
                "java.util.Timer"
            ]
        ]
    },
    "jdk.jfr.internal.periodic": {
        "Batch": [
            [
                "tasks",
                "java.util.List<jdk.jfr.internal.periodic.PeriodicTask>"
            ],
            [
                "period",
                "long"
            ],
            [
                "delta",
                "long"
            ]
        ],
        "BatchManager": [
            [
                "batches",
                "java.util.List<jdk.jfr.internal.periodic.Batch>"
            ],
            [
                "iteration",
                "long"
            ]
        ],
        "EventTask": [
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ]
        ],
        "FlushTask": [
            [
                "flushInterval",
                "long"
            ]
        ],
        "JDKEventTask": [],
        "JVMEventTask": [
            [
                "lock",
                "java.util.concurrent.locks.Lock"
            ]
        ],
        "JavaEventTask": [
            [
                "runnable",
                "java.lang.Runnable"
            ]
        ],
        "LookupKey": [
            [
                "object",
                "java.lang.Object"
            ]
        ],
        "PeriodicEvents": [
            [
                "taskRepository",
                "jdk.jfr.internal.periodic.TaskRepository"
            ],
            [
                "batchManager",
                "jdk.jfr.internal.periodic.BatchManager"
            ],
            [
                "flushTask",
                "jdk.jfr.internal.periodic.FlushTask"
            ],
            [
                "settingsIteration",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "lastTimeMillis",
                "long"
            ]
        ],
        "PeriodicTask": [
            [
                "lookupKey",
                "jdk.jfr.internal.periodic.LookupKey"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "counter",
                "long"
            ],
            [
                "period",
                "long"
            ],
            [
                "batch",
                "jdk.jfr.internal.periodic.Batch"
            ]
        ],
        "PeriodicType": [
            [
                "BEGIN_CHUNK",
                "jdk.jfr.internal.periodic.PeriodicType"
            ],
            [
                "INTERVAL",
                "jdk.jfr.internal.periodic.PeriodicType"
            ],
            [
                "END_CHUNK",
                "jdk.jfr.internal.periodic.PeriodicType"
            ],
            [
                "$VALUES",
                "jdk.jfr.internal.periodic.PeriodicType[]"
            ]
        ],
        "TaskRepository": [
            [
                "lookup",
                "jdk.jfr.internal.periodic.EventTask>"
            ],
            [
                "cache",
                "java.util.List<jdk.jfr.internal.periodic.EventTask>"
            ]
        ],
        "UserEventTask": [
            [
                "controlContext",
                "java.security.AccessControlContext"
            ]
        ]
    },
    "jdk.jfr.internal.query": {
        "Aggregator": [
            [
                "MISSING",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "AVERAGE",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "COUNT",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "DIFFERENCE",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "FIRST",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "LAST",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "LIST",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "SET",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "MAXIMUM",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "MEDIAN",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "MINIMUM",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "P90",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "P95",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "P99",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "P999",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "STANDARD_DEVIATION",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "SUM",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "UNIQUE",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "LAST_BATCH",
                "jdk.jfr.internal.query.Aggregator"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "$VALUES",
                "jdk.jfr.internal.query.Aggregator[]"
            ]
        ],
        "Configuration": [
            [
                "MAX_PREFERRED_WIDTH",
                "int"
            ],
            [
                "MIN_PREFERRED_WIDTH",
                "int"
            ],
            [
                "PREFERRED_WIDTH",
                "int"
            ],
            [
                "output",
                "jdk.jfr.internal.util.Output"
            ],
            [
                "title",
                "java.lang.String"
            ],
            [
                "truncate",
                "jdk.jfr.internal.query.Configuration$Truncate"
            ],
            [
                "cellHeight",
                "int"
            ],
            [
                "width",
                "int"
            ],
            [
                "verbose",
                "boolean"
            ],
            [
                "verboseHeaders",
                "boolean"
            ],
            [
                "verboseTitle",
                "boolean"
            ],
            [
                "startTime",
                "java.time.Instant"
            ],
            [
                "endTime",
                "java.time.Instant"
            ]
        ],
        "Field": [
            [
                "fixedWidth",
                "boolean"
            ],
            [
                "missingText",
                "java.lang.String"
            ]
        ],
        "FieldBuilder": [
            [
                "KNOWN_TYPES",
                "java.util.Set<java.lang.String>"
            ],
            [
                "eventTypes",
                "java.util.List<jdk.jfr.EventType>"
            ],
            [
                "field",
                "jdk.jfr.internal.query.Field"
            ],
            [
                "fieldName",
                "java.lang.String"
            ],
            [
                "descriptor",
                "jdk.jfr.ValueDescriptor"
            ]
        ],
        "FieldFormatter": [],
        "FilteredType": [
            [
                "filters",
                "java.util.List<jdk.jfr.internal.query.FilteredType$Filter>"
            ],
            [
                "eventType",
                "jdk.jfr.EventType"
            ],
            [
                "simpleName",
                "java.lang.String"
            ]
        ],
        "FormRenderer": [
            [
                "LABEL_SUFFIX",
                "java.lang.String"
            ],
            [
                "table",
                "jdk.jfr.internal.query.Table"
            ],
            [
                "out",
                "jdk.jfr.internal.util.Output"
            ],
            [
                "configuration",
                "jdk.jfr.internal.query.Configuration"
            ],
            [
                "width",
                "int"
            ]
        ],
        "Function": [],
        "Histogram": [
            [
                "keyFunctionsMap",
                "jdk.jfr.internal.query.Function[]>"
            ],
            [
                "fields",
                "java.util.List<jdk.jfr.internal.query.Field>"
            ]
        ],
        "Query": [],
        "QueryExecutor": [
            [
                "queryRuns",
                "java.util.List<jdk.jfr.internal.query.QueryRun>"
            ],
            [
                "eventTypes",
                "java.util.List<jdk.jfr.EventType>"
            ],
            [
                "stream",
                "jdk.jfr.consumer.EventStream"
            ]
        ],
        "QueryParser": [
            [
                "tokenizer",
                "jdk.jfr.internal.util.Tokenizer"
            ]
        ],
        "QueryPrinter": [
            [
                "stream",
                "jdk.jfr.consumer.EventStream"
            ],
            [
                "configuration",
                "jdk.jfr.internal.query.Configuration"
            ],
            [
                "out",
                "jdk.jfr.internal.util.Output"
            ],
            [
                "stopWatch",
                "jdk.jfr.internal.util.StopWatch"
            ]
        ],
        "QueryResolver": [
            [
                "eventTypes",
                "java.util.List<jdk.jfr.EventType>"
            ],
            [
                "fromTypes",
                "java.util.List<jdk.jfr.internal.query.FilteredType>"
            ],
            [
                "typeAliases",
                "jdk.jfr.internal.query.FilteredType>"
            ],
            [
                "fieldAliases",
                "jdk.jfr.internal.query.Field>"
            ],
            [
                "resultFields",
                "java.util.List<jdk.jfr.internal.query.Field>"
            ],
            [
                "column",
                "java.util.List<java.lang.String>"
            ],
            [
                "format",
                "java.util.List<jdk.jfr.internal.query.Query$Formatter>"
            ],
            [
                "select",
                "java.util.List<jdk.jfr.internal.query.Query$Expression>"
            ],
            [
                "from",
                "java.util.List<jdk.jfr.internal.query.Query$Source>"
            ],
            [
                "where",
                "java.util.List<jdk.jfr.internal.query.Query$Condition>"
            ],
            [
                "orderBy",
                "java.util.List<jdk.jfr.internal.query.Query$OrderElement>"
            ],
            [
                "groupBy",
                "java.util.List<jdk.jfr.internal.query.Query$Grouper>"
            ]
        ],
        "QueryRun": [
            [
                "histogram",
                "jdk.jfr.internal.query.Histogram"
            ],
            [
                "table",
                "jdk.jfr.internal.query.Table"
            ],
            [
                "syntaxErrors",
                "java.util.List<java.lang.String>"
            ],
            [
                "metadataErrors",
                "java.util.List<java.lang.String>"
            ],
            [
                "query",
                "jdk.jfr.internal.query.Query"
            ],
            [
                "stream",
                "jdk.jfr.consumer.EventStream"
            ]
        ],
        "Row": [
            [
                "values",
                "java.lang.Object[]"
            ],
            [
                "texts",
                "java.lang.String[]"
            ]
        ],
        "Table": [
            [
                "rows",
                "java.util.List<jdk.jfr.internal.query.Row>"
            ],
            [
                "fields",
                "java.util.List<jdk.jfr.internal.query.Field>"
            ]
        ],
        "TableCell": [
            [
                "lines",
                "java.util.List<java.lang.String>"
            ],
            [
                "truncate",
                "jdk.jfr.internal.query.Configuration$Truncate"
            ],
            [
                "preferredWidth",
                "int"
            ]
        ],
        "TableRenderer": [
            [
                "configuration",
                "jdk.jfr.internal.query.Configuration"
            ],
            [
                "tableCells",
                "java.util.List<jdk.jfr.internal.query.TableCell>"
            ],
            [
                "table",
                "jdk.jfr.internal.query.Table"
            ],
            [
                "query",
                "jdk.jfr.internal.query.Query"
            ],
            [
                "out",
                "jdk.jfr.internal.util.Output"
            ],
            [
                "width",
                "int"
            ],
            [
                "preferredWidth",
                "int"
            ]
        ],
        "TableSorter": [
            [
                "table",
                "jdk.jfr.internal.query.Table"
            ],
            [
                "query",
                "jdk.jfr.internal.query.Query"
            ]
        ],
        "ViewFile": [
            [
                "configurations",
                "java.util.List<jdk.jfr.internal.query.ViewFile$ViewConfiguration>"
            ]
        ],
        "ViewPrinter": [
            [
                "configuration",
                "jdk.jfr.internal.query.Configuration"
            ],
            [
                "stream",
                "jdk.jfr.consumer.EventStream"
            ],
            [
                "out",
                "jdk.jfr.internal.util.Output"
            ],
            [
                "stopWatch",
                "jdk.jfr.internal.util.StopWatch"
            ]
        ]
    },
    "jdk.jfr.internal.settings": {
        "BooleanSetting": [
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "defaultValue",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "CutoffSetting": [
            [
                "DEFAULT_VALUE",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ],
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ]
        ],
        "EnabledSetting": [],
        "JDKSettingControl": [],
        "LevelSetting": [
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "levels",
                "java.util.List<java.lang.String>"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "PeriodSetting": [
            [
                "typeId",
                "long"
            ],
            [
                "EVERY_CHUNK",
                "java.lang.String"
            ],
            [
                "BEGIN_CHUNK",
                "java.lang.String"
            ],
            [
                "END_CHUNK",
                "java.lang.String"
            ],
            [
                "DEFAULT_VALUE",
                "java.lang.String"
            ],
            [
                "NAME",
                "java.lang.String"
            ],
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "StackTraceSetting": [
            [
                "typeId",
                "long"
            ]
        ],
        "ThresholdSetting": [
            [
                "DEFAULT_VALUE",
                "java.lang.String"
            ],
            [
                "typeId",
                "long"
            ],
            [
                "value",
                "java.lang.String"
            ],
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ]
        ],
        "ThrottleSetting": [
            [
                "DEFAULT_VALUE",
                "java.lang.String"
            ],
            [
                "eventType",
                "jdk.jfr.internal.PlatformEventType"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ]
    },
    "jdk.jfr.internal.test": {
        "DeprecatedMethods": [
            [
                "counter",
                "int"
            ]
        ],
        "DeprecatedThing": [
            [
                "counter",
                "int"
            ]
        ],
        "WhiteBox": [
            [
                "writeAllObjectSamples",
                "boolean"
            ],
            [
                "skipBFS",
                "boolean"
            ]
        ]
    },
    "jdk.jfr.internal.tool": {
        "Assemble": [],
        "Command": [
            [
                "title",
                "java.lang.String"
            ],
            [
                "HELP",
                "jdk.jfr.internal.tool.Command"
            ],
            [
                "COMMANDS",
                "java.util.List<jdk.jfr.internal.tool.Command>"
            ]
        ],
        "Configure": [
            [
                "inputFiles",
                "java.util.List<java.lang.String>"
            ]
        ],
        "Disassemble": [],
        "EventPrintWriter": [
            [
                "STACK_TRACE_FIELD",
                "java.lang.String"
            ],
            [
                "EVENT_THREAD_FIELD",
                "java.lang.String"
            ],
            [
                "PRIVATE_ACCESS",
                "jdk.jfr.internal.consumer.JdkJfrConsumer"
            ],
            [
                "eventFilter",
                "java.util.function.Predicate<jdk.jfr.EventType>"
            ],
            [
                "stackDepth",
                "int"
            ],
            [
                "typeOfValues",
                "jdk.jfr.internal.tool.EventPrintWriter$ValueType>"
            ]
        ],
        "Filters": [],
        "Help": [],
        "JSONWriter": [
            [
                "first",
                "boolean"
            ]
        ],
        "Main": [
            [
                "EXIT_OK",
                "int"
            ],
            [
                "EXIT_FAILED",
                "int"
            ],
            [
                "EXIT_WRONG_ARGUMENTS",
                "int"
            ]
        ],
        "Metadata": [
            [
                "PRIVATE_ACCESS",
                "jdk.jfr.internal.consumer.JdkJfrConsumer"
            ]
        ],
        "PrettyWriter": [
            [
                "TYPE_OLD_OBJECT",
                "java.lang.String"
            ],
            [
                "TIME_FORMAT",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ZERO",
                "java.lang.Long"
            ],
            [
                "showIds",
                "boolean"
            ],
            [
                "currentEvent",
                "jdk.jfr.consumer.RecordedEvent"
            ]
        ],
        "Print": [],
        "Query": [],
        "Scrub": [],
        "StructuredWriter": [
            [
                "out",
                "java.io.PrintWriter"
            ],
            [
                "builder",
                "java.lang.StringBuilder"
            ],
            [
                "indention",
                "java.lang.String"
            ],
            [
                "indent",
                "int"
            ],
            [
                "column",
                "int"
            ],
            [
                "first",
                "boolean"
            ],
            [
                "lineSeparator",
                "java.lang.String"
            ]
        ],
        "Summary": [
            [
                "DATE_FORMAT",
                "java.time.format.DateTimeFormatter"
            ]
        ],
        "UserDataException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UserSyntaxException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Version": [],
        "View": [],
        "XMLWriter": []
    },
    "jdk.jfr.internal.util": {
        "Bytecode": [
            [
                "CD_Thread",
                "java.lang.constant.ClassDesc"
            ]
        ],
        "Columnizer": [
            [
                "columns",
                "java.util.List<jdk.jfr.internal.util.Columnizer$Column>"
            ]
        ],
        "ImplicitFields": [
            [
                "START_TIME",
                "java.lang.String"
            ],
            [
                "DURATION",
                "java.lang.String"
            ],
            [
                "EVENT_THREAD",
                "java.lang.String"
            ],
            [
                "STACK_TRACE",
                "java.lang.String"
            ],
            [
                "fields",
                "java.util.List<java.lang.String>"
            ]
        ],
        "Matcher": [],
        "Output": [],
        "Rate": [
            [
                "amount",
                "long"
            ],
            [
                "unit",
                "jdk.jfr.internal.util.TimespanUnit"
            ]
        ],
        "SpellChecker": [],
        "StopWatch": [
            [
                "timings",
                "java.util.List<jdk.jfr.internal.util.StopWatch$Timing>"
            ]
        ],
        "TimespanUnit": [
            [
                "NANOSECONDS",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "MICROSECONDS",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "MILLISECONDS",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "SECONDS",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "MINUTES",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "HOURS",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "DAYS",
                "jdk.jfr.internal.util.TimespanUnit"
            ],
            [
                "text",
                "java.lang.String"
            ],
            [
                "nanos",
                "long"
            ],
            [
                "size",
                "int"
            ],
            [
                "timeUnit",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "$VALUES",
                "jdk.jfr.internal.util.TimespanUnit[]"
            ]
        ],
        "Tokenizer": [
            [
                "text",
                "java.lang.String"
            ],
            [
                "separators",
                "char[]"
            ],
            [
                "index",
                "int"
            ]
        ],
        "UserDataException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UserSyntaxException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Utils": [
            [
                "flushObject",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "LEGACY_EVENT_NAME_PREFIX",
                "java.lang.String"
            ]
        ],
        "ValueFormatter": [
            [
                "DATE_FORMAT",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "MICRO_SECOND",
                "java.time.Duration"
            ],
            [
                "SECOND",
                "java.time.Duration"
            ],
            [
                "MINUTE",
                "java.time.Duration"
            ],
            [
                "HOUR",
                "java.time.Duration"
            ],
            [
                "DAY",
                "java.time.Duration"
            ],
            [
                "NANO_SIGNIFICANT_FIGURES",
                "int"
            ],
            [
                "MILL_SIGNIFICANT_FIGURES",
                "int"
            ],
            [
                "DISPLAY_NANO_DIGIT",
                "int"
            ],
            [
                "BASE",
                "int"
            ],
            [
                "NUMBER_FORMAT",
                "java.text.NumberFormat"
            ]
        ],
        "ValueParser": [
            [
                "INFINITY",
                "java.lang.String"
            ],
            [
                "MISSING",
                "long"
            ]
        ]
    },
    "jdk.jfr.snippets": {
        "Snippets": []
    },
    "jdk.jfr.snippets.consumer": {
        "Snippets": []
    },
    "jdk.jpackage.internal": {
        "AbstractAppImageBuilder": [
            [
                "root",
                "java.nio.file.Path"
            ],
            [
                "appLayout",
                "jdk.jpackage.internal.ApplicationLayout"
            ]
        ],
        "AbstractBundler": [],
        "AddLauncherArguments": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "filename",
                "java.lang.String"
            ],
            [
                "allArgs",
                "java.lang.String>"
            ],
            [
                "bundleParams",
                "java.lang.Object>"
            ]
        ],
        "AppImageBundler": [
            [
                "dependentTask",
                "boolean"
            ],
            [
                "paramsValidator",
                "jdk.jpackage.internal.AppImageBundler$ParamsValidator"
            ],
            [
                "appImageSupplier",
                "jdk.jpackage.internal.AbstractAppImageBuilder>"
            ]
        ],
        "AppImageFile": [
            [
                "appVersion",
                "java.lang.String"
            ],
            [
                "launcherName",
                "java.lang.String"
            ],
            [
                "mainClass",
                "java.lang.String"
            ],
            [
                "addLauncherInfos",
                "java.util.List<jdk.jpackage.internal.AppImageFile$LauncherInfo>"
            ],
            [
                "creatorVersion",
                "java.lang.String"
            ],
            [
                "creatorPlatform",
                "java.lang.String"
            ],
            [
                "signed",
                "boolean"
            ],
            [
                "appStore",
                "boolean"
            ],
            [
                "FILENAME",
                "java.lang.String"
            ],
            [
                "PLATFORM_LABELS",
                "java.lang.String>"
            ]
        ],
        "ApplicationLayout": [
            [
                "data",
                "jdk.jpackage.internal.PathGroup"
            ]
        ],
        "Arguments": [
            [
                "I18N",
                "java.util.ResourceBundle"
            ],
            [
                "FA_EXTENSIONS",
                "java.lang.String"
            ],
            [
                "FA_CONTENT_TYPE",
                "java.lang.String"
            ],
            [
                "FA_DESCRIPTION",
                "java.lang.String"
            ],
            [
                "FA_ICON",
                "java.lang.String"
            ],
            [
                "MAC_CFBUNDLETYPEROLE",
                "java.lang.String"
            ],
            [
                "MAC_LSHANDLERRANK",
                "java.lang.String"
            ],
            [
                "MAC_NSSTORETYPEKEY",
                "java.lang.String"
            ],
            [
                "MAC_NSDOCUMENTCLASS",
                "java.lang.String"
            ],
            [
                "MAC_LSTYPEISPACKAGE",
                "java.lang.String"
            ],
            [
                "MAC_LSDOCINPLACE",
                "java.lang.String"
            ],
            [
                "MAC_UIDOCBROWSER",
                "java.lang.String"
            ],
            [
                "MAC_NSEXPORTABLETYPES",
                "java.lang.String"
            ],
            [
                "MAC_UTTYPECONFORMSTO",
                "java.lang.String"
            ],
            [
                "pattern",
                "java.util.regex.Pattern"
            ],
            [
                "deployParams",
                "jdk.jpackage.internal.DeployParams"
            ],
            [
                "pos",
                "int"
            ],
            [
                "argList",
                "java.util.List<java.lang.String>"
            ],
            [
                "allOptions",
                "java.util.List<jdk.jpackage.internal.Arguments$CLIOptions>"
            ],
            [
                "hasMainJar",
                "boolean"
            ],
            [
                "hasMainClass",
                "boolean"
            ],
            [
                "hasMainModule",
                "boolean"
            ],
            [
                "userProvidedBuildRoot",
                "boolean"
            ],
            [
                "buildRoot",
                "java.lang.String"
            ],
            [
                "mainJarPath",
                "java.lang.String"
            ],
            [
                "runtimeInstaller",
                "boolean"
            ],
            [
                "addLaunchers",
                "java.util.List<jdk.jpackage.internal.AddLauncherArguments>"
            ],
            [
                "argIds",
                "jdk.jpackage.internal.Arguments$CLIOptions>"
            ],
            [
                "argShortIds",
                "jdk.jpackage.internal.Arguments$CLIOptions>"
            ],
            [
                "instance",
                "java.lang.InheritableThreadLocal<jdk.jpackage.internal.Arguments>"
            ]
        ],
        "BasicBundlers": [
            [
                "bundlers",
                "java.util.Collection<jdk.jpackage.internal.Bundler>"
            ]
        ],
        "BundleParams": [
            [
                "params",
                "java.lang.Object>"
            ]
        ],
        "Bundler": [],
        "BundlerParamInfo": [],
        "Bundlers": [],
        "CFBundleVersion": [],
        "CLIHelp": [
            [
                "I18N",
                "java.util.ResourceBundle"
            ]
        ],
        "CfgFile": [
            [
                "launcherName",
                "java.lang.String"
            ],
            [
                "version",
                "java.lang.String"
            ],
            [
                "launcherData",
                "jdk.jpackage.internal.LauncherData"
            ],
            [
                "appLayout",
                "jdk.jpackage.internal.ApplicationLayout"
            ],
            [
                "SECTION_TAG",
                "java.lang.Object"
            ]
        ],
        "ConfigException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DeployParams": [
            [
                "multi_args",
                "java.util.Set<java.lang.String>"
            ]
        ],
        "DottedVersion": [
            [
                "components",
                "java.math.BigInteger[]"
            ],
            [
                "value",
                "java.lang.String"
            ],
            [
                "suffix",
                "java.lang.String"
            ]
        ],
        "Enquoter": [
            [
                "beginQuoteChr",
                "int"
            ],
            [
                "endQuoteChr",
                "int"
            ],
            [
                "escaper",
                "java.lang.StringBuilder>"
            ],
            [
                "needQuotes",
                "java.util.function.Predicate<java.lang.String>"
            ],
            [
                "QUOTE_IF_WHITESPACES",
                "java.util.function.Predicate<java.lang.String>"
            ],
            [
                "PREPEND_BACKSLASH",
                "java.lang.StringBuilder>"
            ]
        ],
        "Executor": [
            [
                "INFINITE_TIMEOUT",
                "int"
            ],
            [
                "pb",
                "java.lang.ProcessBuilder"
            ],
            [
                "saveOutput",
                "boolean"
            ],
            [
                "writeOutputToFile",
                "boolean"
            ],
            [
                "quietCommand",
                "boolean"
            ],
            [
                "timeout",
                "long"
            ],
            [
                "output",
                "java.util.List<java.lang.String>"
            ],
            [
                "outputConsumer",
                "java.util.function.Consumer<java.util.stream.Stream<java.lang.String>>"
            ]
        ],
        "FileAssociation": [],
        "I18N": [
            [
                "BUNDLE",
                "jdk.jpackage.internal.I18N$MultiResourceBundle"
            ]
        ],
        "IOUtils": [],
        "InstallableFile": [
            [
                "installPath",
                "java.nio.file.Path"
            ],
            [
                "srcPath",
                "java.nio.file.Path"
            ]
        ],
        "JLinkBundlerHelper": [
            [
                "ALL_MODULE_PATH",
                "java.lang.String"
            ],
            [
                "ALL_DEFAULT",
                "java.lang.String"
            ]
        ],
        "JPackageToolProvider": [],
        "LauncherAsService": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "resource",
                "jdk.jpackage.internal.OverridableResource"
            ]
        ],
        "LauncherData": [
            [
                "qualifiedClassName",
                "java.lang.String"
            ],
            [
                "jarMainClass",
                "java.lang.String"
            ],
            [
                "mainJarName",
                "java.nio.file.Path"
            ],
            [
                "classPath",
                "java.util.List<java.nio.file.Path>"
            ],
            [
                "modulePath",
                "java.util.List<java.nio.file.Path>"
            ],
            [
                "moduleInfo",
                "jdk.jpackage.internal.LauncherData$ModuleInfo"
            ]
        ],
        "Log": [
            [
                "instance",
                "java.lang.InheritableThreadLocal<jdk.jpackage.internal.Log$Logger>"
            ]
        ],
        "MacAppBundler": [
            [
                "TEMPLATE_BUNDLE_ICON",
                "java.lang.String"
            ],
            [
                "DEFAULT_ICNS_ICON",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "DEVELOPER_ID_APP_SIGNING_KEY",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "APP_IMAGE_SIGN_IDENTITY",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "BUNDLE_ID_SIGNING_PREFIX",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ]
        ],
        "MacAppImageBuilder": [
            [
                "I18N",
                "java.util.ResourceBundle"
            ],
            [
                "TEMPLATE_BUNDLE_ICON",
                "java.lang.String"
            ],
            [
                "OS_TYPE_CODE",
                "java.lang.String"
            ],
            [
                "TEMPLATE_INFO_PLIST_LITE",
                "java.lang.String"
            ],
            [
                "TEMPLATE_RUNTIME_INFO_PLIST",
                "java.lang.String"
            ],
            [
                "root",
                "java.nio.file.Path"
            ],
            [
                "contentsDir",
                "java.nio.file.Path"
            ],
            [
                "resourcesDir",
                "java.nio.file.Path"
            ],
            [
                "macOSDir",
                "java.nio.file.Path"
            ],
            [
                "runtimeDir",
                "java.nio.file.Path"
            ],
            [
                "runtimeRoot",
                "java.nio.file.Path"
            ],
            [
                "withPackageFile",
                "boolean"
            ],
            [
                "keyChains",
                "java.util.List<java.lang.String>"
            ],
            [
                "MAC_CONFIGURE_LAUNCHER_IN_PLIST",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.Boolean>"
            ],
            [
                "MAC_CF_BUNDLE_NAME",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "APP_CATEGORY",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "MAC_CF_BUNDLE_IDENTIFIER",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "ICON_ICNS",
                "jdk.jpackage.internal.BundlerParamInfo<java.nio.file.Path>"
            ],
            [
                "ENTITLEMENTS",
                "jdk.jpackage.internal.BundlerParamInfo<java.nio.file.Path>"
            ],
            [
                "FA_MAC_CFBUNDLETYPEROLE",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_LSHANDLERRANK",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_NSSTORETYPEKEY",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_NSDOCUMENTCLASS",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_LSTYPEISPACKAGE",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_LSDOCINPLACE",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_UIDOCBROWSER",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "FA_MAC_NSEXPORTABLETYPES",
                "jdk.jpackage.internal.StandardBundlerParam<java.util.List<java.lang.String>>"
            ],
            [
                "FA_MAC_UTTYPECONFORMSTO",
                "jdk.jpackage.internal.StandardBundlerParam<java.util.List<java.lang.String>>"
            ]
        ],
        "MacBaseInstallerBundler": [
            [
                "APP_IMAGE_TEMP_ROOT",
                "jdk.jpackage.internal.BundlerParamInfo<java.nio.file.Path>"
            ],
            [
                "SIGNING_KEY_USER",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "SIGNING_KEYCHAIN",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "INSTALLER_SIGN_IDENTITY",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "MAC_INSTALLER_NAME",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "appImageBundler",
                "jdk.jpackage.internal.Bundler"
            ]
        ],
        "MacCertificate": [
            [
                "certificate",
                "java.lang.String"
            ]
        ],
        "MacDmgBundler": [
            [
                "I18N",
                "java.util.ResourceBundle"
            ],
            [
                "INSTALLER_SUFFIX",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "hdiutil",
                "java.lang.String"
            ],
            [
                "required",
                "java.lang.String[]"
            ]
        ],
        "MacLaunchersAsServices": [],
        "MacPkgBundler": [
            [
                "I18N",
                "java.util.ResourceBundle"
            ],
            [
                "DEFAULT_BACKGROUND_IMAGE",
                "java.lang.String"
            ],
            [
                "DEFAULT_PDF",
                "java.lang.String"
            ],
            [
                "PACKAGES_ROOT",
                "jdk.jpackage.internal.BundlerParamInfo<java.nio.file.Path>"
            ],
            [
                "SCRIPTS_DIR",
                "jdk.jpackage.internal.BundlerParamInfo<java.nio.file.Path>"
            ],
            [
                "DEVELOPER_ID_INSTALLER_SIGNING_KEY",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ],
            [
                "INSTALLER_SUFFIX",
                "jdk.jpackage.internal.BundlerParamInfo<java.lang.String>"
            ]
        ],
        "MacPkgInstallerScripts": [],
        "OverridableResource": [
            [
                "substitutionData",
                "java.lang.String>"
            ],
            [
                "category",
                "java.lang.String"
            ],
            [
                "resourceDir",
                "java.nio.file.Path"
            ],
            [
                "publicName",
                "java.nio.file.Path"
            ],
            [
                "logPublicName",
                "java.nio.file.Path"
            ],
            [
                "externalPath",
                "java.nio.file.Path"
            ],
            [
                "defaultName",
                "java.lang.String"
            ],
            [
                "sources",
                "jdk.jpackage.internal.OverridableResource$SourceHandler>>"
            ]
        ],
        "PackageFile": [
            [
                "packageName",
                "java.lang.String"
            ],
            [
                "FILENAME",
                "java.lang.String"
            ]
        ],
        "PackageScripts": [
            [
                "scripts",
                "jdk.jpackage.internal.ShellScriptResource>"
            ]
        ],
        "PackagerException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "bundle",
                "java.util.ResourceBundle"
            ]
        ],
        "PathGroup": [
            [
                "entries",
                "java.nio.file.Path>"
            ]
        ],
        "PlatformPackage": [],
        "RetryExecutor": [
            [
                "executorInitializer",
                "java.util.function.Consumer<jdk.jpackage.internal.Executor>"
            ],
            [
                "aborted",
                "boolean"
            ],
            [
                "attempts",
                "int"
            ],
            [
                "timeoutMillis",
                "int"
            ],
            [
                "saveOutput",
                "boolean"
            ],
            [
                "output",
                "java.util.List<java.lang.String>"
            ],
            [
                "writeOutputToFile",
                "boolean"
            ]
        ],
        "ScriptRunner": [
            [
                "scriptNameSuffix",
                "java.lang.String"
            ],
            [
                "resourceCategoryId",
                "java.lang.String"
            ],
            [
                "directory",
                "java.nio.file.Path"
            ],
            [
                "environment",
                "java.lang.String>"
            ]
        ],
        "ShellCustomAction": [],
        "ShellCustomActionFactory": [],
        "ShellScriptResource": [
            [
                "execPerms",
                "java.util.Set<java.nio.file.attribute.PosixFilePermission>"
            ],
            [
                "resource",
                "jdk.jpackage.internal.OverridableResource"
            ],
            [
                "ALL_CAN_EXECUTE",
                "java.util.Set<java.nio.file.attribute.PosixFilePermission>"
            ],
            [
                "OWNER_CAN_EXECUTE",
                "java.util.Set<java.nio.file.attribute.PosixFilePermission>"
            ]
        ],
        "StandardBundlerParam": [
            [
                "JAVABASEJMOD",
                "java.lang.String"
            ],
            [
                "DEFAULT_VERSION",
                "java.lang.String"
            ],
            [
                "DEFAULT_RELEASE",
                "java.lang.String"
            ],
            [
                "DEFAULT_JLINK_OPTIONS",
                "java.lang.String[]"
            ],
            [
                "LICENSE_FILE",
                "jdk.jpackage.internal.StandardBundlerParam<java.lang.String>"
            ],
            [
                "CONFIG_ROOT",
                "jdk.jpackage.internal.StandardBundlerParam<java.nio.file.Path>"
            ]
        ],
        "ToolValidator": [
            [
                "toolPath",
                "java.nio.file.Path"
            ],
            [
                "args",
                "java.util.List<java.lang.String>"
            ],
            [
                "minimalVersion",
                "java.lang.Comparable<java.lang.String>"
            ],
            [
                "versionParser",
                "java.lang.String>"
            ],
            [
                "toolNotFoundErrorHandler",
                "jdk.jpackage.internal.ConfigException>"
            ],
            [
                "toolOldVersionErrorHandler",
                "jdk.jpackage.internal.ConfigException>"
            ]
        ],
        "UnixLaunchersAsServices": [
            [
                "thePackage",
                "jdk.jpackage.internal.PlatformPackage"
            ],
            [
                "requiredPackages",
                "java.util.List<java.lang.String>"
            ],
            [
                "launchers",
                "java.util.List<jdk.jpackage.internal.UnixLaunchersAsServices$UnixLauncherAsService>"
            ],
            [
                "enqouter",
                "jdk.jpackage.internal.Enquoter"
            ],
            [
                "COMMANDS_INSTALL",
                "java.lang.String"
            ],
            [
                "COMMANDS_UNINSTALL",
                "java.lang.String"
            ],
            [
                "SCRIPTS",
                "java.lang.String"
            ],
            [
                "REPLACEMENT_STRING_IDS",
                "java.util.List<java.lang.String>"
            ]
        ],
        "ValidOptions": [
            [
                "options",
                "java.util.EnumSet<jdk.jpackage.internal.ValidOptions$USE>>"
            ]
        ]
    },
    "jdk.jpackage.internal.resources": {
        "ResourceLocator": []
    },
    "jdk.jpackage.internal.util": {
        "FileUtils": [],
        "PathUtils": [],
        "PrettyPrintHandler": [
            [
                "target",
                "javax.xml.stream.XMLStreamWriter"
            ],
            [
                "depth",
                "int"
            ],
            [
                "hasChildElement",
                "java.lang.Boolean>"
            ],
            [
                "INDENT",
                "java.lang.String"
            ],
            [
                "EOL",
                "java.lang.String"
            ]
        ],
        "SkipDocumentHandler": [
            [
                "target",
                "javax.xml.stream.XMLStreamWriter"
            ]
        ],
        "XmlConsumer": [],
        "XmlUtils": []
    },
    "jdk.jpackage.internal.util.function": {
        "ExceptionBox": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ThrowingBiConsumer": [],
        "ThrowingBiFunction": [],
        "ThrowingConsumer": [],
        "ThrowingFunction": [],
        "ThrowingRunnable": [],
        "ThrowingSupplier": [],
        "ThrowingUnaryOperator": []
    },
    "jdk.jpackage.main": {
        "Main": [
            [
                "I18N",
                "java.util.ResourceBundle"
            ]
        ]
    },
    "jdk.swing.interop": {
        "DispatcherWrapper": [
            [
                "fwd",
                "jdk.swing.interop.DispatcherWrapper$DispatcherProxy"
            ]
        ],
        "DragSourceContextWrapper": [
            [
                "dsp",
                "jdk.swing.interop.DragSourceContextWrapper$DragSourceContextPeerProxy"
            ]
        ],
        "DropTargetContextWrapper": [
            [
                "dcp",
                "jdk.swing.interop.DropTargetContextWrapper$DropTargetContextPeerProxy"
            ]
        ],
        "LightweightContentWrapper": [
            [
                "lwCnt",
                "jdk.swing.interop.LightweightContentWrapper$LightweightContentProxy"
            ]
        ],
        "LightweightFrameWrapper": [],
        "SwingInterOpUtils": [
            [
                "GRAB_EVENT_MASK",
                "int"
            ]
        ]
    },
    "jdk.swing.interop.internal": {
        "InteropProviderImpl": []
    },
    "jdk.management": {
        "VirtualThreadSchedulerMXBean": []
    },
    "java.rmi": {
        "AccessException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AlreadyBoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ConnectException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ConnectIOException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MarshalException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MarshalledObject": [
            [
                "objBytes",
                "byte[]"
            ],
            [
                "locBytes",
                "byte[]"
            ],
            [
                "hash",
                "int"
            ],
            [
                "objectInputFilter",
                "java.io.ObjectInputFilter"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Naming": [],
        "NoSuchObjectException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NotBoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RMISecurityException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RMISecurityManager": [],
        "Remote": [],
        "RemoteException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "detail",
                "java.lang.Throwable"
            ]
        ],
        "ServerError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ServerException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ServerRuntimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StubNotFoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnexpectedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnknownHostException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnmarshalException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "java.rmi.dgc": {
        "DGC": [],
        "Lease": [
            [
                "vmid",
                "java.rmi.dgc.VMID"
            ],
            [
                "value",
                "long"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "VMID": [
            [
                "randomBytes",
                "byte[]"
            ],
            [
                "addr",
                "byte[]"
            ],
            [
                "uid",
                "java.rmi.server.UID"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "java.rmi.registry": {
        "LocateRegistry": [],
        "Registry": [
            [
                "REGISTRY_PORT",
                "int"
            ]
        ],
        "RegistryHandler": []
    },
    "java.rmi.server": {
        "ExportException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LoaderHandler": [
            [
                "packagePrefix",
                "java.lang.String"
            ]
        ],
        "LogStream": [
            [
                "known",
                "java.rmi.server.LogStream>"
            ],
            [
                "defaultStream",
                "java.io.PrintStream"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "logOut",
                "java.io.OutputStream"
            ],
            [
                "logWriter",
                "java.io.OutputStreamWriter"
            ],
            [
                "buffer",
                "java.lang.StringBuffer"
            ],
            [
                "bufOut",
                "java.io.ByteArrayOutputStream"
            ],
            [
                "SILENT",
                "int"
            ],
            [
                "BRIEF",
                "int"
            ],
            [
                "VERBOSE",
                "int"
            ]
        ],
        "ObjID": [
            [
                "REGISTRY_ID",
                "int"
            ],
            [
                "ACTIVATOR_ID",
                "int"
            ],
            [
                "DGC_ID",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "nextObjNum",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "mySpace",
                "java.rmi.server.UID"
            ],
            [
                "secureRandom",
                "java.security.SecureRandom"
            ],
            [
                "objNum",
                "long"
            ],
            [
                "space",
                "java.rmi.server.UID"
            ]
        ],
        "Operation": [
            [
                "operation",
                "java.lang.String"
            ]
        ],
        "RMIClassLoader": [
            [
                "defaultProvider",
                "java.rmi.server.RMIClassLoaderSpi"
            ],
            [
                "provider",
                "java.rmi.server.RMIClassLoaderSpi"
            ]
        ],
        "RMIClassLoaderSpi": [],
        "RMIClientSocketFactory": [],
        "RMIFailureHandler": [],
        "RMIServerSocketFactory": [],
        "RMISocketFactory": [
            [
                "factory",
                "java.rmi.server.RMISocketFactory"
            ],
            [
                "defaultSocketFactory",
                "java.rmi.server.RMISocketFactory"
            ],
            [
                "handler",
                "java.rmi.server.RMIFailureHandler"
            ]
        ],
        "RemoteCall": [],
        "RemoteObject": [
            [
                "ref",
                "java.rmi.server.RemoteRef"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RemoteObjectInvocationHandler": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "methodToHash_Maps",
                "java.rmi.server.RemoteObjectInvocationHandler$MethodToHash_Maps"
            ]
        ],
        "RemoteRef": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "packagePrefix",
                "java.lang.String"
            ]
        ],
        "RemoteServer": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "logNull",
                "boolean"
            ]
        ],
        "RemoteStub": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ServerCloneException": [
            [
                "detail",
                "java.lang.Exception"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ServerNotActiveException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ServerRef": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Skeleton": [],
        "SkeletonMismatchException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SkeletonNotFoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SocketSecurityException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UID": [
            [
                "hostUnique",
                "int"
            ],
            [
                "hostUniqueSet",
                "boolean"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "lastTime",
                "long"
            ],
            [
                "lastCount",
                "short"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "unique",
                "int"
            ],
            [
                "time",
                "long"
            ],
            [
                "count",
                "short"
            ]
        ],
        "UnicastRemoteObject": [
            [
                "port",
                "int"
            ],
            [
                "csf",
                "java.rmi.server.RMIClientSocketFactory"
            ],
            [
                "ssf",
                "java.rmi.server.RMIServerSocketFactory"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Unreferenced": []
    },
    "javax.rmi.ssl": {
        "SslRMIClientSocketFactory": [
            [
                "defaultSocketFactory",
                "javax.net.SocketFactory"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SslRMIServerSocketFactory": [
            [
                "defaultSSLSocketFactory",
                "javax.net.ssl.SSLSocketFactory"
            ],
            [
                "enabledCipherSuites",
                "java.lang.String[]"
            ],
            [
                "enabledProtocols",
                "java.lang.String[]"
            ],
            [
                "needClientAuth",
                "boolean"
            ],
            [
                "enabledCipherSuitesList",
                "java.util.List<java.lang.String>"
            ],
            [
                "enabledProtocolsList",
                "java.util.List<java.lang.String>"
            ],
            [
                "context",
                "javax.net.ssl.SSLContext"
            ]
        ]
    },
    "jdk.management.jfr": {
        "ConfigurationInfo": [
            [
                "settings",
                "java.lang.String>"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "label",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "provider",
                "java.lang.String"
            ],
            [
                "contents",
                "java.lang.String"
            ]
        ],
        "DiskRepository": [
            [
                "chunks",
                "java.util.Deque<jdk.management.jfr.DiskRepository$DiskChunk>"
            ],
            [
                "deadChunks",
                "java.util.Deque<jdk.management.jfr.DiskRepository$DiskChunk>"
            ],
            [
                "fileDumps",
                "java.util.Deque<jdk.management.jfr.FileDump>"
            ],
            [
                "deleteDirectory",
                "boolean"
            ],
            [
                "buffer",
                "java.nio.ByteBuffer"
            ],
            [
                "directory",
                "java.nio.file.Path"
            ],
            [
                "chunkFilename",
                "jdk.jfr.internal.management.ChunkFilename"
            ],
            [
                "barrier",
                "jdk.jfr.internal.management.StreamBarrier"
            ],
            [
                "raf",
                "java.io.RandomAccessFile"
            ],
            [
                "previousRAF",
                "java.io.RandomAccessFile"
            ],
            [
                "previousRAFstate",
                "byte"
            ],
            [
                "index",
                "int"
            ],
            [
                "bufferIndex",
                "int"
            ],
            [
                "state",
                "jdk.management.jfr.DiskRepository$State"
            ],
            [
                "currentByteArray",
                "byte[]"
            ],
            [
                "typeId",
                "long"
            ],
            [
                "typeIdshift",
                "int"
            ],
            [
                "sizeShift",
                "int"
            ],
            [
                "payLoadSize",
                "long"
            ],
            [
                "longValueshift",
                "int"
            ],
            [
                "eventFieldSize",
                "int"
            ],
            [
                "lastFlush",
                "int"
            ],
            [
                "currentChunk",
                "jdk.management.jfr.DiskRepository$DiskChunk"
            ],
            [
                "maxAge",
                "java.time.Duration"
            ],
            [
                "maxSize",
                "long"
            ],
            [
                "size",
                "long"
            ]
        ],
        "DownLoadThread": [
            [
                "stream",
                "jdk.management.jfr.RemoteRecordingStream"
            ],
            [
                "startTime",
                "java.time.Instant"
            ],
            [
                "endTime",
                "java.time.Instant"
            ],
            [
                "diskRepository",
                "jdk.management.jfr.DiskRepository"
            ],
            [
                "threadSleeper",
                "jdk.jfr.internal.management.HiddenWait"
            ]
        ],
        "EventTypeInfo": [
            [
                "settingDescriptors",
                "java.util.List<jdk.management.jfr.SettingDescriptorInfo>"
            ],
            [
                "id",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "label",
                "java.lang.String"
            ],
            [
                "categoryNames",
                "java.util.List<java.lang.String>"
            ]
        ],
        "FileDump": [
            [
                "lock",
                "jdk.jfr.internal.management.HiddenWait"
            ],
            [
                "chunks",
                "java.util.Deque<jdk.management.jfr.DiskRepository$DiskChunk>"
            ],
            [
                "stopTimeMillis",
                "long"
            ],
            [
                "complete",
                "boolean"
            ]
        ],
        "FlightRecorderMXBean": [
            [
                "MXBEAN_NAME",
                "java.lang.String"
            ]
        ],
        "FlightRecorderMXBeanImpl": [
            [
                "ATTRIBUTE_RECORDINGS",
                "java.lang.String"
            ],
            [
                "OPTION_MAX_SIZE",
                "java.lang.String"
            ],
            [
                "OPTION_MAX_AGE",
                "java.lang.String"
            ],
            [
                "OPTION_NAME",
                "java.lang.String"
            ],
            [
                "OPTION_DISK",
                "java.lang.String"
            ],
            [
                "OPTION_DUMP_ON_EXIT",
                "java.lang.String"
            ],
            [
                "OPTION_DURATION",
                "java.lang.String"
            ],
            [
                "OPTION_DESTINATION",
                "java.lang.String"
            ],
            [
                "OPTIONS",
                "java.util.List<java.lang.String>"
            ],
            [
                "streamHandler",
                "jdk.jfr.internal.management.StreamManager"
            ],
            [
                "changes",
                "java.lang.Object>"
            ],
            [
                "sequenceNumber",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "listeners",
                "java.util.List<jdk.management.jfr.FlightRecorderMXBeanImpl$MXBeanListener>"
            ],
            [
                "recorder",
                "jdk.jfr.FlightRecorder"
            ]
        ],
        "MBeanUtils": [
            [
                "monitor",
                "java.security.Permission"
            ],
            [
                "control",
                "java.security.Permission"
            ]
        ],
        "RecordingInfo": [
            [
                "id",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "state",
                "java.lang.String"
            ],
            [
                "dumpOnExit",
                "boolean"
            ],
            [
                "size",
                "long"
            ],
            [
                "toDisk",
                "boolean"
            ],
            [
                "maxAge",
                "long"
            ],
            [
                "maxSize",
                "long"
            ],
            [
                "startTime",
                "long"
            ],
            [
                "stopTime",
                "long"
            ],
            [
                "destination",
                "java.lang.String"
            ],
            [
                "durationInSeconds",
                "long"
            ],
            [
                "settings",
                "java.lang.String>"
            ]
        ],
        "RemoteRecordingStream": [
            [
                "ENABLED",
                "java.lang.String"
            ],
            [
                "OBJECT_NAME",
                "javax.management.ObjectName"
            ],
            [
                "started",
                "boolean"
            ],
            [
                "maxAge",
                "java.time.Duration"
            ],
            [
                "maxSize",
                "long"
            ]
        ],
        "SettingDescriptorInfo": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "label",
                "java.lang.String"
            ],
            [
                "description",
                "java.lang.String"
            ],
            [
                "typeName",
                "java.lang.String"
            ],
            [
                "contentType",
                "java.lang.String"
            ],
            [
                "defaultValue",
                "java.lang.String"
            ]
        ],
        "Stringifier": [
            [
                "sb",
                "java.lang.StringBuilder"
            ],
            [
                "first",
                "boolean"
            ]
        ]
    },
    "jdk.management.jfr.internal": {
        "FlightRecorderMXBeanProvider": [
            [
                "flightRecorderMXBeanFactory",
                "java.util.concurrent.Callable<jdk.management.jfr.FlightRecorderMXBean>"
            ],
            [
                "flightRecorderMXBean",
                "jdk.management.jfr.FlightRecorderMXBean"
            ]
        ]
    },
    "jdk.net": {
        "ExtendedSocketOptions": [
            [
                "TCP_QUICKACK",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "TCP_KEEPIDLE",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "TCP_KEEPINTERVAL",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "TCP_KEEPCOUNT",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "SO_INCOMING_NAPI_ID",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "SO_PEERCRED",
                "java.net.SocketOption<jdk.net.UnixDomainPrincipal>"
            ],
            [
                "IP_DONTFRAGMENT",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "platformSocketOptions",
                "jdk.net.ExtendedSocketOptions$PlatformSocketOptions"
            ],
            [
                "quickAckSupported",
                "boolean"
            ],
            [
                "keepAliveOptSupported",
                "boolean"
            ],
            [
                "peerCredentialsSupported",
                "boolean"
            ],
            [
                "incomingNapiIdOptSupported",
                "boolean"
            ],
            [
                "ipDontFragmentSupported",
                "boolean"
            ],
            [
                "extendedOptions",
                "java.util.Set<java.net.SocketOption<?>>"
            ],
            [
                "fdAccess",
                "jdk.internal.access.JavaIOFileDescriptorAccess"
            ]
        ],
        "MacOSXSocketOptions": [],
        "NetworkPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Sockets": [
            [
                "options",
                "java.util.Set<java.net.SocketOption<?>>>"
            ],
            [
                "checkedReusePort",
                "boolean"
            ],
            [
                "isReusePortAvailable",
                "boolean"
            ]
        ],
        "UnixDomainPrincipal": [
            [
                "user",
                "java.nio.file.attribute.UserPrincipal"
            ],
            [
                "group",
                "java.nio.file.attribute.GroupPrincipal"
            ]
        ]
    },
    "jdk.nio": {
        "Channels": []
    },
    "java.util.prefs": {
        "AbstractPreferences": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "absolutePath",
                "java.lang.String"
            ],
            [
                "root",
                "java.util.prefs.AbstractPreferences"
            ],
            [
                "newNode",
                "boolean"
            ],
            [
                "kidCache",
                "java.util.prefs.AbstractPreferences>"
            ],
            [
                "removed",
                "boolean"
            ],
            [
                "prefListeners",
                "java.util.prefs.PreferenceChangeListener[]"
            ],
            [
                "nodeListeners",
                "java.util.prefs.NodeChangeListener[]"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "EMPTY_STRING_ARRAY",
                "java.lang.String[]"
            ],
            [
                "EMPTY_ABSTRACT_PREFS_ARRAY",
                "java.util.prefs.AbstractPreferences[]"
            ],
            [
                "eventQueue",
                "java.util.List<java.util.EventObject>"
            ],
            [
                "eventDispatchThread",
                "java.lang.Thread"
            ]
        ],
        "BackingStoreException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Base64": [
            [
                "intToBase64",
                "char[]"
            ],
            [
                "intToAltBase64",
                "char[]"
            ],
            [
                "base64ToInt",
                "byte[]"
            ],
            [
                "altBase64ToInt",
                "byte[]"
            ]
        ],
        "FileSystemPreferences": [
            [
                "SYNC_INTERVAL",
                "int"
            ],
            [
                "systemRootDir",
                "java.io.File"
            ],
            [
                "isSystemRootWritable",
                "boolean"
            ],
            [
                "userRootDir",
                "java.io.File"
            ],
            [
                "isUserRootWritable",
                "boolean"
            ],
            [
                "userRoot",
                "java.util.prefs.Preferences"
            ],
            [
                "systemRoot",
                "java.util.prefs.Preferences"
            ],
            [
                "USER_READ_WRITE",
                "int"
            ],
            [
                "USER_RW_ALL_READ",
                "int"
            ],
            [
                "USER_RWX_ALL_RX",
                "int"
            ],
            [
                "USER_RWX",
                "int"
            ],
            [
                "userRootLockHandle",
                "int"
            ],
            [
                "systemRootLockHandle",
                "int"
            ],
            [
                "dir",
                "java.io.File"
            ],
            [
                "prefsFile",
                "java.io.File"
            ],
            [
                "tmpFile",
                "java.io.File"
            ],
            [
                "userRootModFile",
                "java.io.File"
            ],
            [
                "isUserRootModified",
                "boolean"
            ],
            [
                "userRootModTime",
                "long"
            ],
            [
                "systemRootModFile",
                "java.io.File"
            ],
            [
                "isSystemRootModified",
                "boolean"
            ],
            [
                "systemRootModTime",
                "long"
            ],
            [
                "prefsCache",
                "java.lang.String>"
            ],
            [
                "lastSyncTime",
                "long"
            ],
            [
                "EAGAIN",
                "int"
            ],
            [
                "EACCES",
                "int"
            ],
            [
                "LOCK_HANDLE",
                "int"
            ],
            [
                "ERROR_CODE",
                "int"
            ],
            [
                "syncTimer",
                "java.util.Timer"
            ],
            [
                "isUserNode",
                "boolean"
            ],
            [
                "EMPTY_STRING_ARRAY",
                "java.lang.String[]"
            ],
            [
                "INIT_SLEEP_TIME",
                "int"
            ],
            [
                "MAX_ATTEMPTS",
                "int"
            ]
        ],
        "FileSystemPreferencesFactory": [],
        "InvalidPreferencesFormatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MacOSXPreferences": [
            [
                "defaultAppName",
                "java.lang.String"
            ],
            [
                "isUser",
                "boolean"
            ],
            [
                "file",
                "java.util.prefs.MacOSXPreferencesFile"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "userRoot",
                "java.util.prefs.MacOSXPreferences"
            ],
            [
                "systemRoot",
                "java.util.prefs.MacOSXPreferences"
            ]
        ],
        "MacOSXPreferencesFactory": [],
        "MacOSXPreferencesFile": [
            [
                "cachedFiles",
                "java.lang.ref.WeakReference<java.util.prefs.MacOSXPreferencesFile>>"
            ],
            [
                "changedFiles",
                "java.util.HashSet<java.util.prefs.MacOSXPreferencesFile>"
            ],
            [
                "timer",
                "java.util.Timer"
            ],
            [
                "flushTimerTask",
                "java.util.prefs.MacOSXPreferencesFile$FlushTask"
            ],
            [
                "flushDelay",
                "long"
            ],
            [
                "syncInterval",
                "long"
            ],
            [
                "appName",
                "java.lang.String"
            ],
            [
                "user",
                "long"
            ],
            [
                "host",
                "long"
            ],
            [
                "cfCurrentUser",
                "long"
            ],
            [
                "cfAnyUser",
                "long"
            ],
            [
                "cfCurrentHost",
                "long"
            ],
            [
                "cfAnyHost",
                "long"
            ]
        ],
        "NodeChangeEvent": [
            [
                "child",
                "java.util.prefs.Preferences"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NodeChangeListener": [],
        "PreferenceChangeEvent": [
            [
                "key",
                "java.lang.String"
            ],
            [
                "newValue",
                "java.lang.String"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PreferenceChangeListener": [],
        "Preferences": [
            [
                "factory",
                "java.util.prefs.PreferencesFactory"
            ],
            [
                "MAX_KEY_LENGTH",
                "int"
            ],
            [
                "MAX_VALUE_LENGTH",
                "int"
            ],
            [
                "MAX_NAME_LENGTH",
                "int"
            ]
        ],
        "PreferencesFactory": [],
        "XmlSupport": [
            [
                "PREFS_DTD_URI",
                "java.lang.String"
            ],
            [
                "PREFS_DTD",
                "java.lang.String"
            ],
            [
                "EXTERNAL_XML_VERSION",
                "java.lang.String"
            ],
            [
                "MAP_XML_VERSION",
                "java.lang.String"
            ]
        ]
    },
    "java.util.logging": {
        "ConsoleHandler": [],
        "ErrorManager": [
            [
                "reported",
                "boolean"
            ],
            [
                "GENERIC_FAILURE",
                "int"
            ],
            [
                "WRITE_FAILURE",
                "int"
            ],
            [
                "FLUSH_FAILURE",
                "int"
            ],
            [
                "CLOSE_FAILURE",
                "int"
            ],
            [
                "OPEN_FAILURE",
                "int"
            ],
            [
                "FORMAT_FAILURE",
                "int"
            ]
        ],
        "FileHandler": [
            [
                "meter",
                "java.util.logging.FileHandler$MeteredStream"
            ],
            [
                "append",
                "boolean"
            ],
            [
                "limit",
                "long"
            ],
            [
                "count",
                "int"
            ],
            [
                "pattern",
                "java.lang.String"
            ],
            [
                "lockFileName",
                "java.lang.String"
            ],
            [
                "lockFileChannel",
                "java.nio.channels.FileChannel"
            ],
            [
                "files",
                "java.io.File[]"
            ],
            [
                "MAX_LOCKS",
                "int"
            ],
            [
                "maxLocks",
                "int"
            ],
            [
                "locks",
                "java.util.Set<java.lang.String>"
            ]
        ],
        "Filter": [],
        "Formatter": [],
        "Handler": [
            [
                "offValue",
                "int"
            ],
            [
                "manager",
                "java.util.logging.LogManager"
            ],
            [
                "filter",
                "java.util.logging.Filter"
            ],
            [
                "formatter",
                "java.util.logging.Formatter"
            ],
            [
                "logLevel",
                "java.util.logging.Level"
            ],
            [
                "errorManager",
                "java.util.logging.ErrorManager"
            ],
            [
                "encoding",
                "java.lang.String"
            ]
        ],
        "Level": [
            [
                "defaultBundle",
                "java.lang.String"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "value",
                "int"
            ],
            [
                "resourceBundleName",
                "java.lang.String"
            ],
            [
                "localizedLevelName",
                "java.lang.String"
            ],
            [
                "cachedLocale",
                "java.util.Locale"
            ],
            [
                "OFF",
                "java.util.logging.Level"
            ],
            [
                "SEVERE",
                "java.util.logging.Level"
            ],
            [
                "WARNING",
                "java.util.logging.Level"
            ],
            [
                "INFO",
                "java.util.logging.Level"
            ],
            [
                "CONFIG",
                "java.util.logging.Level"
            ],
            [
                "FINE",
                "java.util.logging.Level"
            ],
            [
                "FINER",
                "java.util.logging.Level"
            ],
            [
                "FINEST",
                "java.util.logging.Level"
            ],
            [
                "ALL",
                "java.util.logging.Level"
            ],
            [
                "standardLevels",
                "java.util.logging.Level[]"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LogManager": [
            [
                "props",
                "java.util.Properties"
            ],
            [
                "defaultLevel",
                "java.util.logging.Level"
            ],
            [
                "systemContext",
                "java.util.logging.LogManager$LoggerContext"
            ],
            [
                "userContext",
                "java.util.logging.LogManager$LoggerContext"
            ],
            [
                "rootLogger",
                "java.util.logging.Logger"
            ],
            [
                "readPrimordialConfiguration",
                "boolean"
            ],
            [
                "STATE_INITIALIZED",
                "int"
            ],
            [
                "STATE_INITIALIZING",
                "int"
            ],
            [
                "STATE_READING_CONFIG",
                "int"
            ],
            [
                "STATE_UNINITIALIZED",
                "int"
            ],
            [
                "STATE_SHUTDOWN",
                "int"
            ],
            [
                "globalHandlersState",
                "int"
            ],
            [
                "configurationLock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "closeOnResetLoggers",
                "java.util.concurrent.CopyOnWriteArrayList<java.util.logging.LogManager$CloseOnReset>"
            ],
            [
                "listeners",
                "java.lang.Runnable>"
            ],
            [
                "manager",
                "java.util.logging.LogManager"
            ],
            [
                "initializedCalled",
                "boolean"
            ],
            [
                "initializationDone",
                "boolean"
            ],
            [
                "loggerRefQueue",
                "java.lang.ref.ReferenceQueue<java.util.logging.Logger>"
            ],
            [
                "MAX_ITERATIONS",
                "int"
            ],
            [
                "LOGGING_MXBEAN_NAME",
                "java.lang.String"
            ]
        ],
        "LogRecord": [
            [
                "globalSequenceNumber",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "level",
                "java.util.logging.Level"
            ],
            [
                "sequenceNumber",
                "long"
            ],
            [
                "sourceClassName",
                "java.lang.String"
            ],
            [
                "sourceMethodName",
                "java.lang.String"
            ],
            [
                "message",
                "java.lang.String"
            ],
            [
                "threadID",
                "int"
            ],
            [
                "longThreadID",
                "long"
            ],
            [
                "thrown",
                "java.lang.Throwable"
            ],
            [
                "loggerName",
                "java.lang.String"
            ],
            [
                "resourceBundleName",
                "java.lang.String"
            ],
            [
                "instant",
                "java.time.Instant"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "needToInferCaller",
                "boolean"
            ],
            [
                "parameters",
                "java.lang.Object[]"
            ],
            [
                "resourceBundle",
                "java.util.ResourceBundle"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Logger": [
            [
                "emptyHandlers",
                "java.util.logging.Handler[]"
            ],
            [
                "offValue",
                "int"
            ],
            [
                "SYSTEM_BUNDLE",
                "java.util.logging.Logger$LoggerBundle"
            ],
            [
                "NO_RESOURCE_BUNDLE",
                "java.util.logging.Logger$LoggerBundle"
            ],
            [
                "config",
                "java.util.logging.Logger$ConfigurationData"
            ],
            [
                "manager",
                "java.util.logging.LogManager"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "loggerBundle",
                "java.util.logging.Logger$LoggerBundle"
            ],
            [
                "anonymous",
                "boolean"
            ],
            [
                "catalogRef",
                "java.lang.ref.WeakReference<java.util.ResourceBundle>"
            ],
            [
                "catalogName",
                "java.lang.String"
            ],
            [
                "catalogLocale",
                "java.util.Locale"
            ],
            [
                "treeLock",
                "java.lang.Object"
            ],
            [
                "parent",
                "java.util.logging.Logger"
            ],
            [
                "kids",
                "java.util.ArrayList<java.util.logging.LogManager$LoggerWeakRef>"
            ],
            [
                "callerModuleRef",
                "java.lang.ref.WeakReference<java.lang.Module>"
            ],
            [
                "isSystemLogger",
                "boolean"
            ],
            [
                "GLOBAL_LOGGER_NAME",
                "java.lang.String"
            ],
            [
                "global",
                "java.util.logging.Logger"
            ]
        ],
        "Logging": [
            [
                "logManager",
                "java.util.logging.LogManager"
            ],
            [
                "EMPTY_STRING",
                "java.lang.String"
            ],
            [
                "INSTANCE",
                "java.util.logging.Logging"
            ]
        ],
        "LoggingMXBean": [],
        "LoggingPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MemoryHandler": [
            [
                "DEFAULT_SIZE",
                "int"
            ],
            [
                "pushLevel",
                "java.util.logging.Level"
            ],
            [
                "size",
                "int"
            ],
            [
                "target",
                "java.util.logging.Handler"
            ],
            [
                "buffer",
                "java.util.logging.LogRecord[]"
            ]
        ],
        "SimpleFormatter": [
            [
                "format",
                "java.lang.String"
            ]
        ],
        "SocketHandler": [
            [
                "sock",
                "java.net.Socket"
            ],
            [
                "host",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ]
        ],
        "StreamHandler": [
            [
                "output",
                "java.io.OutputStream"
            ],
            [
                "doneHeader",
                "boolean"
            ],
            [
                "writer",
                "java.io.Writer"
            ]
        ],
        "XMLFormatter": [
            [
                "manager",
                "java.util.logging.LogManager"
            ],
            [
                "useInstant",
                "boolean"
            ]
        ]
    },
    "java.io": {
        "BufferedInputStream": [
            [
                "DEFAULT_BUFFER_SIZE",
                "int"
            ],
            [
                "EMPTY",
                "byte[]"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "BUF_OFFSET",
                "long"
            ],
            [
                "initialSize",
                "int"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "count",
                "int"
            ],
            [
                "pos",
                "int"
            ],
            [
                "markpos",
                "int"
            ],
            [
                "marklimit",
                "int"
            ]
        ],
        "BufferedOutputStream": [
            [
                "DEFAULT_INITIAL_BUFFER_SIZE",
                "int"
            ],
            [
                "DEFAULT_MAX_BUFFER_SIZE",
                "int"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "count",
                "int"
            ],
            [
                "maxBufSize",
                "int"
            ]
        ],
        "BufferedReader": [
            [
                "in",
                "java.io.Reader"
            ],
            [
                "cb",
                "char[]"
            ],
            [
                "nChars",
                "int"
            ],
            [
                "nextChar",
                "int"
            ],
            [
                "INVALIDATED",
                "int"
            ],
            [
                "UNMARKED",
                "int"
            ],
            [
                "markedChar",
                "int"
            ],
            [
                "readAheadLimit",
                "int"
            ],
            [
                "skipLF",
                "boolean"
            ],
            [
                "markedSkipLF",
                "boolean"
            ],
            [
                "DEFAULT_CHAR_BUFFER_SIZE",
                "int"
            ],
            [
                "DEFAULT_EXPECTED_LINE_LENGTH",
                "int"
            ]
        ],
        "BufferedWriter": [
            [
                "DEFAULT_INITIAL_BUFFER_SIZE",
                "int"
            ],
            [
                "DEFAULT_MAX_BUFFER_SIZE",
                "int"
            ],
            [
                "out",
                "java.io.Writer"
            ],
            [
                "cb",
                "char[]"
            ],
            [
                "nChars",
                "int"
            ],
            [
                "nextChar",
                "int"
            ],
            [
                "maxChars",
                "int"
            ]
        ],
        "ByteArrayInputStream": [
            [
                "MAX_TRANSFER_SIZE",
                "int"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "pos",
                "int"
            ],
            [
                "mark",
                "int"
            ],
            [
                "count",
                "int"
            ]
        ],
        "ByteArrayOutputStream": [
            [
                "buf",
                "byte[]"
            ],
            [
                "count",
                "int"
            ]
        ],
        "CharArrayReader": [
            [
                "buf",
                "char[]"
            ],
            [
                "pos",
                "int"
            ],
            [
                "markedPos",
                "int"
            ],
            [
                "count",
                "int"
            ]
        ],
        "CharArrayWriter": [
            [
                "buf",
                "char[]"
            ],
            [
                "count",
                "int"
            ]
        ],
        "CharConversionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ClassCache": [
            [
                "queue",
                "java.lang.ref.ReferenceQueue<T>"
            ],
            [
                "map",
                "java.lang.ClassValue<java.io.ClassCache$CacheRef<T>>"
            ]
        ],
        "Closeable": [],
        "Console": [
            [
                "istty",
                "boolean"
            ],
            [
                "cons",
                "java.io.Console"
            ]
        ],
        "DataInput": [],
        "DataInputStream": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "EMPTY_BYTE_ARRAY",
                "byte[]"
            ],
            [
                "EMPTY_CHAR_ARRAY",
                "char[]"
            ],
            [
                "readBuffer",
                "byte[]"
            ],
            [
                "bytearr",
                "byte[]"
            ],
            [
                "chararr",
                "char[]"
            ],
            [
                "lineBuffer",
                "char[]"
            ]
        ],
        "DataOutput": [],
        "DataOutputStream": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "written",
                "int"
            ],
            [
                "bytearr",
                "byte[]"
            ],
            [
                "writeBuffer",
                "byte[]"
            ]
        ],
        "DefaultFileSystem": [],
        "DeleteOnExitHook": [
            [
                "files",
                "java.util.LinkedHashSet<java.lang.String>"
            ]
        ],
        "EOFException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Externalizable": [],
        "File": [
            [
                "FS",
                "java.io.FileSystem"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "status",
                "java.io.File$PathStatus"
            ],
            [
                "prefixLength",
                "int"
            ],
            [
                "separatorChar",
                "char"
            ],
            [
                "separator",
                "java.lang.String"
            ],
            [
                "pathSeparatorChar",
                "char"
            ],
            [
                "pathSeparator",
                "java.lang.String"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "PATH_OFFSET",
                "long"
            ],
            [
                "PREFIX_LENGTH_OFFSET",
                "long"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "filePath",
                "java.nio.file.Path"
            ]
        ],
        "FileCleanable": [
            [
                "fdAccess",
                "jdk.internal.access.JavaIOFileDescriptorAccess"
            ],
            [
                "fd",
                "int"
            ],
            [
                "handle",
                "long"
            ]
        ],
        "FileDescriptor": [
            [
                "fd",
                "int"
            ],
            [
                "handle",
                "long"
            ],
            [
                "parent",
                "java.io.Closeable"
            ],
            [
                "otherParents",
                "java.util.List<java.io.Closeable>"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "append",
                "boolean"
            ],
            [
                "cleanup",
                "jdk.internal.ref.PhantomCleanable<java.io.FileDescriptor>"
            ],
            [
                "in",
                "java.io.FileDescriptor"
            ],
            [
                "out",
                "java.io.FileDescriptor"
            ],
            [
                "err",
                "java.io.FileDescriptor"
            ]
        ],
        "FileFilter": [],
        "FileInputStream": [
            [
                "DEFAULT_BUFFER_SIZE",
                "int"
            ],
            [
                "jfrTracing",
                "boolean"
            ],
            [
                "fd",
                "java.io.FileDescriptor"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "channel",
                "java.nio.channels.FileChannel"
            ],
            [
                "closeLock",
                "java.lang.Object"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "isRegularFile",
                "java.lang.Boolean"
            ]
        ],
        "FileNotFoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "FileOutputStream": [
            [
                "FD_ACCESS",
                "jdk.internal.access.JavaIOFileDescriptorAccess"
            ],
            [
                "jfrTracing",
                "boolean"
            ],
            [
                "fd",
                "java.io.FileDescriptor"
            ],
            [
                "channel",
                "java.nio.channels.FileChannel"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "closeLock",
                "java.lang.Object"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "FilePermission": [
            [
                "EXECUTE",
                "int"
            ],
            [
                "WRITE",
                "int"
            ],
            [
                "READ",
                "int"
            ],
            [
                "DELETE",
                "int"
            ],
            [
                "READLINK",
                "int"
            ],
            [
                "ALL",
                "int"
            ],
            [
                "NONE",
                "int"
            ],
            [
                "mask",
                "int"
            ],
            [
                "directory",
                "boolean"
            ],
            [
                "recursive",
                "boolean"
            ],
            [
                "actions",
                "java.lang.String"
            ],
            [
                "cpath",
                "java.lang.String"
            ],
            [
                "npath",
                "java.nio.file.Path"
            ],
            [
                "npath2",
                "java.nio.file.Path"
            ],
            [
                "allFiles",
                "boolean"
            ],
            [
                "invalid",
                "boolean"
            ],
            [
                "RECURSIVE_CHAR",
                "char"
            ],
            [
                "WILD_CHAR",
                "char"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "builtInFS",
                "java.nio.file.FileSystem"
            ],
            [
                "here",
                "java.nio.file.Path"
            ],
            [
                "EMPTY_PATH",
                "java.nio.file.Path"
            ],
            [
                "DASH_PATH",
                "java.nio.file.Path"
            ],
            [
                "DOTDOT_PATH",
                "java.nio.file.Path"
            ]
        ],
        "FilePermissionCollection": [
            [
                "perms",
                "java.security.Permission>"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "FileReader": [],
        "FileSystem": [
            [
                "BA_EXISTS",
                "int"
            ],
            [
                "BA_REGULAR",
                "int"
            ],
            [
                "BA_DIRECTORY",
                "int"
            ],
            [
                "BA_HIDDEN",
                "int"
            ],
            [
                "ACCESS_READ",
                "int"
            ],
            [
                "ACCESS_WRITE",
                "int"
            ],
            [
                "ACCESS_EXECUTE",
                "int"
            ],
            [
                "SPACE_TOTAL",
                "int"
            ],
            [
                "SPACE_FREE",
                "int"
            ],
            [
                "SPACE_USABLE",
                "int"
            ]
        ],
        "FileWriter": [],
        "FilenameFilter": [],
        "FilterInputStream": [
            [
                "in",
                "java.io.InputStream"
            ]
        ],
        "FilterOutputStream": [
            [
                "out",
                "java.io.OutputStream"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "closeLock",
                "java.lang.Object"
            ]
        ],
        "FilterReader": [
            [
                "in",
                "java.io.Reader"
            ]
        ],
        "FilterWriter": [
            [
                "out",
                "java.io.Writer"
            ]
        ],
        "Flushable": [],
        "IO": [],
        "IOError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IOException": [],
        "InputStream": [
            [
                "MAX_SKIP_BUFFER_SIZE",
                "int"
            ],
            [
                "DEFAULT_BUFFER_SIZE",
                "int"
            ],
            [
                "MAX_BUFFER_SIZE",
                "int"
            ]
        ],
        "InputStreamReader": [
            [
                "sd",
                "sun.nio.cs.StreamDecoder"
            ]
        ],
        "InterruptedIOException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "bytesTransferred",
                "int"
            ]
        ],
        "InvalidClassException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "classname",
                "java.lang.String"
            ]
        ],
        "InvalidObjectException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LineNumberInputStream": [],
        "LineNumberReader": [
            [
                "NONE",
                "int"
            ],
            [
                "CHAR",
                "int"
            ],
            [
                "EOL",
                "int"
            ],
            [
                "EOF",
                "int"
            ],
            [
                "prevChar",
                "int"
            ],
            [
                "lineNumber",
                "int"
            ],
            [
                "markedLineNumber",
                "int"
            ],
            [
                "skipLF",
                "boolean"
            ],
            [
                "markedSkipLF",
                "boolean"
            ],
            [
                "maxSkipBufferSize",
                "int"
            ],
            [
                "skipBuffer",
                "char[]"
            ]
        ],
        "NotActiveException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NotSerializableException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ObjectInput": [],
        "ObjectInputFilter": [],
        "ObjectInputStream": [
            [
                "NULL_HANDLE",
                "int"
            ],
            [
                "unsharedMarker",
                "java.lang.Object"
            ],
            [
                "bin",
                "java.io.ObjectInputStream$BlockDataInputStream"
            ],
            [
                "vlist",
                "java.io.ObjectInputStream$ValidationList"
            ],
            [
                "depth",
                "long"
            ],
            [
                "totalObjectRefs",
                "long"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "handles",
                "java.io.ObjectInputStream$HandleTable"
            ],
            [
                "passHandle",
                "int"
            ],
            [
                "defaultDataEnd",
                "boolean"
            ],
            [
                "enableOverride",
                "boolean"
            ],
            [
                "enableResolve",
                "boolean"
            ],
            [
                "curContext",
                "java.io.SerialCallbackContext"
            ],
            [
                "serialFilter",
                "java.io.ObjectInputFilter"
            ],
            [
                "streamFilterSet",
                "boolean"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ]
        ],
        "ObjectInputValidation": [],
        "ObjectOutput": [],
        "ObjectOutputStream": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "bout",
                "java.io.ObjectOutputStream$BlockDataOutputStream"
            ],
            [
                "handles",
                "java.io.ObjectOutputStream$HandleTable"
            ],
            [
                "subs",
                "java.io.ObjectOutputStream$ReplaceTable"
            ],
            [
                "protocol",
                "int"
            ],
            [
                "depth",
                "int"
            ],
            [
                "primVals",
                "byte[]"
            ],
            [
                "enableOverride",
                "boolean"
            ],
            [
                "enableReplace",
                "boolean"
            ],
            [
                "curContext",
                "java.io.SerialCallbackContext"
            ],
            [
                "curPut",
                "java.io.ObjectOutputStream$PutFieldImpl"
            ],
            [
                "debugInfoStack",
                "java.io.ObjectOutputStream$DebugTraceInfoStack"
            ],
            [
                "extendedDebugInfo",
                "boolean"
            ]
        ],
        "ObjectStreamClass": [
            [
                "NO_FIELDS",
                "java.io.ObjectStreamField[]"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "cl",
                "java.lang.Class<?>"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "suid",
                "java.lang.Long"
            ],
            [
                "isProxy",
                "boolean"
            ],
            [
                "isEnum",
                "boolean"
            ],
            [
                "isRecord",
                "boolean"
            ],
            [
                "serializable",
                "boolean"
            ],
            [
                "externalizable",
                "boolean"
            ],
            [
                "hasWriteObjectData",
                "boolean"
            ],
            [
                "hasBlockExternalData",
                "boolean"
            ],
            [
                "resolveEx",
                "java.lang.ClassNotFoundException"
            ],
            [
                "deserializeEx",
                "java.io.ObjectStreamClass$ExceptionInfo"
            ],
            [
                "serializeEx",
                "java.io.ObjectStreamClass$ExceptionInfo"
            ],
            [
                "defaultSerializeEx",
                "java.io.ObjectStreamClass$ExceptionInfo"
            ],
            [
                "fields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "primDataSize",
                "int"
            ],
            [
                "numObjFields",
                "int"
            ],
            [
                "fieldRefl",
                "java.io.ObjectStreamClass$FieldReflector"
            ],
            [
                "dataLayout",
                "java.io.ObjectStreamClass$ClassDataSlot[]"
            ],
            [
                "cons",
                "java.lang.reflect.Constructor<?>"
            ],
            [
                "canonicalCtr",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "deserializationCtrs",
                "java.io.ObjectStreamClass$DeserializationConstructorsCache"
            ],
            [
                "deserializationCtr",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "writeObjectMethod",
                "java.lang.reflect.Method"
            ],
            [
                "readObjectMethod",
                "java.lang.reflect.Method"
            ],
            [
                "readObjectNoDataMethod",
                "java.lang.reflect.Method"
            ],
            [
                "writeReplaceMethod",
                "java.lang.reflect.Method"
            ],
            [
                "readResolveMethod",
                "java.lang.reflect.Method"
            ],
            [
                "localDesc",
                "java.io.ObjectStreamClass"
            ],
            [
                "superDesc",
                "java.io.ObjectStreamClass"
            ],
            [
                "initialized",
                "boolean"
            ]
        ],
        "ObjectStreamConstants": [
            [
                "STREAM_MAGIC",
                "short"
            ],
            [
                "STREAM_VERSION",
                "short"
            ],
            [
                "TC_BASE",
                "byte"
            ],
            [
                "TC_NULL",
                "byte"
            ],
            [
                "TC_REFERENCE",
                "byte"
            ],
            [
                "TC_CLASSDESC",
                "byte"
            ],
            [
                "TC_OBJECT",
                "byte"
            ],
            [
                "TC_STRING",
                "byte"
            ],
            [
                "TC_ARRAY",
                "byte"
            ],
            [
                "TC_CLASS",
                "byte"
            ],
            [
                "TC_BLOCKDATA",
                "byte"
            ],
            [
                "TC_ENDBLOCKDATA",
                "byte"
            ],
            [
                "TC_RESET",
                "byte"
            ],
            [
                "TC_BLOCKDATALONG",
                "byte"
            ],
            [
                "TC_EXCEPTION",
                "byte"
            ],
            [
                "TC_LONGSTRING",
                "byte"
            ],
            [
                "TC_PROXYCLASSDESC",
                "byte"
            ],
            [
                "TC_ENUM",
                "byte"
            ],
            [
                "TC_MAX",
                "byte"
            ],
            [
                "baseWireHandle",
                "int"
            ],
            [
                "SC_WRITE_METHOD",
                "byte"
            ],
            [
                "SC_BLOCK_DATA",
                "byte"
            ],
            [
                "SC_SERIALIZABLE",
                "byte"
            ],
            [
                "SC_EXTERNALIZABLE",
                "byte"
            ],
            [
                "SC_ENUM",
                "byte"
            ],
            [
                "SUBSTITUTION_PERMISSION",
                "java.io.SerializablePermission"
            ],
            [
                "SUBCLASS_IMPLEMENTATION_PERMISSION",
                "java.io.SerializablePermission"
            ],
            [
                "SERIAL_FILTER_PERMISSION",
                "java.io.SerializablePermission"
            ],
            [
                "PROTOCOL_VERSION_1",
                "int"
            ],
            [
                "PROTOCOL_VERSION_2",
                "int"
            ]
        ],
        "ObjectStreamException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ObjectStreamField": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "signature",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Class<?>"
            ],
            [
                "typeSignature",
                "java.lang.String"
            ],
            [
                "unshared",
                "boolean"
            ],
            [
                "field",
                "java.lang.reflect.Field"
            ],
            [
                "offset",
                "int"
            ]
        ],
        "ObjectStreamReflection": [
            [
                "DRO_HANDLE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "DWO_HANDLE",
                "java.lang.invoke.MethodHandle"
            ]
        ],
        "OptionalDataException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "length",
                "int"
            ],
            [
                "eof",
                "boolean"
            ]
        ],
        "OutputStream": [],
        "OutputStreamWriter": [
            [
                "se",
                "sun.nio.cs.StreamEncoder"
            ]
        ],
        "PipedInputStream": [
            [
                "DEFAULT_PIPE_SIZE",
                "int"
            ],
            [
                "PIPE_SIZE",
                "int"
            ],
            [
                "buffer",
                "byte[]"
            ],
            [
                "in",
                "int"
            ],
            [
                "out",
                "int"
            ]
        ],
        "PipedOutputStream": [
            [
                "sink",
                "java.io.PipedInputStream"
            ]
        ],
        "PipedReader": [
            [
                "DEFAULT_PIPE_SIZE",
                "int"
            ]
        ],
        "PipedWriter": [
            [
                "sink",
                "java.io.PipedReader"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "PrintStream": [
            [
                "autoFlush",
                "boolean"
            ],
            [
                "trouble",
                "boolean"
            ],
            [
                "formatter",
                "java.util.Formatter"
            ],
            [
                "charset",
                "java.nio.charset.Charset"
            ],
            [
                "textOut",
                "java.io.BufferedWriter"
            ],
            [
                "charOut",
                "java.io.OutputStreamWriter"
            ],
            [
                "closing",
                "boolean"
            ]
        ],
        "PrintWriter": [
            [
                "out",
                "java.io.Writer"
            ],
            [
                "autoFlush",
                "boolean"
            ],
            [
                "trouble",
                "boolean"
            ],
            [
                "formatter",
                "java.util.Formatter"
            ],
            [
                "psOut",
                "java.io.PrintStream"
            ]
        ],
        "ProxyingConsole": [
            [
                "delegate",
                "jdk.internal.io.JdkConsole"
            ],
            [
                "readLock",
                "java.lang.Object"
            ],
            [
                "writeLock",
                "java.lang.Object"
            ],
            [
                "reader",
                "java.io.Reader"
            ],
            [
                "printWriter",
                "java.io.PrintWriter"
            ]
        ],
        "PushbackInputStream": [
            [
                "buf",
                "byte[]"
            ],
            [
                "pos",
                "int"
            ]
        ],
        "PushbackReader": [
            [
                "buf",
                "char[]"
            ],
            [
                "pos",
                "int"
            ]
        ],
        "RandomAccessFile": [
            [
                "O_RDONLY",
                "int"
            ],
            [
                "O_RDWR",
                "int"
            ],
            [
                "O_SYNC",
                "int"
            ],
            [
                "O_DSYNC",
                "int"
            ],
            [
                "O_TEMPORARY",
                "int"
            ],
            [
                "jfrTracing",
                "boolean"
            ],
            [
                "fd",
                "java.io.FileDescriptor"
            ],
            [
                "rw",
                "boolean"
            ],
            [
                "sync",
                "boolean"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "closeLock",
                "java.lang.Object"
            ],
            [
                "buffer",
                "byte[]"
            ],
            [
                "channel",
                "java.nio.channels.FileChannel"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "Reader": [
            [
                "TRANSFER_BUFFER_SIZE",
                "int"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "maxSkipBufferSize",
                "int"
            ],
            [
                "skipBuffer",
                "char[]"
            ]
        ],
        "SequenceInputStream": [
            [
                "e",
                "java.io.InputStream>"
            ],
            [
                "in",
                "java.io.InputStream"
            ]
        ],
        "Serial": [],
        "SerialCallbackContext": [
            [
                "obj",
                "java.lang.Object"
            ],
            [
                "desc",
                "java.io.ObjectStreamClass"
            ],
            [
                "thread",
                "java.lang.Thread"
            ]
        ],
        "Serializable": [],
        "SerializablePermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "actions",
                "java.lang.String"
            ]
        ],
        "SerializationMisdeclarationChecker": [
            [
                "SUID_NAME",
                "java.lang.String"
            ],
            [
                "SERIAL_PERSISTENT_FIELDS_NAME",
                "java.lang.String"
            ],
            [
                "WRITE_OBJECT_NAME",
                "java.lang.String"
            ],
            [
                "READ_OBJECT_NAME",
                "java.lang.String"
            ],
            [
                "READ_OBJECT_NO_DATA_NAME",
                "java.lang.String"
            ],
            [
                "WRITE_REPLACE_NAME",
                "java.lang.String"
            ],
            [
                "READ_RESOLVE_NAME",
                "java.lang.String"
            ],
            [
                "WRITE_OBJECT_PARAM_TYPES",
                "java.lang.Class<?>[]"
            ],
            [
                "READ_OBJECT_PARAM_TYPES",
                "java.lang.Class<?>[]"
            ],
            [
                "READ_OBJECT_NO_DATA_PARAM_TYPES",
                "java.lang.Class<?>[]"
            ],
            [
                "WRITE_REPLACE_PARAM_TYPES",
                "java.lang.Class<?>[]"
            ],
            [
                "READ_RESOLVE_PARAM_TYPES",
                "java.lang.Class<?>[]"
            ]
        ],
        "StreamCorruptedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StreamTokenizer": [
            [
                "reader",
                "java.io.Reader"
            ],
            [
                "input",
                "java.io.InputStream"
            ],
            [
                "buf",
                "char[]"
            ],
            [
                "peekc",
                "int"
            ],
            [
                "NEED_CHAR",
                "int"
            ],
            [
                "SKIP_LF",
                "int"
            ],
            [
                "pushedBack",
                "boolean"
            ],
            [
                "forceLower",
                "boolean"
            ],
            [
                "LINENO",
                "int"
            ],
            [
                "eolIsSignificantP",
                "boolean"
            ],
            [
                "slashSlashCommentsP",
                "boolean"
            ],
            [
                "slashStarCommentsP",
                "boolean"
            ],
            [
                "ctype",
                "byte[]"
            ],
            [
                "CT_WHITESPACE",
                "byte"
            ],
            [
                "CT_DIGIT",
                "byte"
            ],
            [
                "CT_ALPHA",
                "byte"
            ],
            [
                "CT_QUOTE",
                "byte"
            ],
            [
                "CT_COMMENT",
                "byte"
            ],
            [
                "ttype",
                "int"
            ],
            [
                "TT_EOF",
                "int"
            ],
            [
                "TT_EOL",
                "int"
            ],
            [
                "TT_NUMBER",
                "int"
            ],
            [
                "TT_WORD",
                "int"
            ],
            [
                "TT_NOTHING",
                "int"
            ],
            [
                "sval",
                "java.lang.String"
            ],
            [
                "nval",
                "double"
            ]
        ],
        "StringBufferInputStream": [
            [
                "buffer",
                "java.lang.String"
            ],
            [
                "pos",
                "int"
            ],
            [
                "count",
                "int"
            ]
        ],
        "StringReader": [
            [
                "r",
                "java.io.Reader"
            ]
        ],
        "StringWriter": [
            [
                "buf",
                "java.lang.StringBuffer"
            ]
        ],
        "SyncFailedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UTFDataFormatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UncheckedIOException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnixFileSystem": [
            [
                "slash",
                "char"
            ],
            [
                "colon",
                "char"
            ],
            [
                "userDir",
                "java.lang.String"
            ]
        ],
        "UnsupportedEncodingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "WriteAbortedException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "detail",
                "java.lang.Exception"
            ]
        ],
        "Writer": [
            [
                "writeBuffer",
                "char[]"
            ],
            [
                "WRITE_BUFFER_SIZE",
                "int"
            ],
            [
                "lock",
                "java.lang.Object"
            ]
        ]
    },
    "java.lang": {
        "AbstractMethodError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AbstractStringBuilder": [
            [
                "EMPTYVALUE",
                "byte[]"
            ]
        ],
        "Appendable": [],
        "ApplicationShutdownHooks": [
            [
                "hooks",
                "java.lang.Thread>"
            ]
        ],
        "ArithmeticException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ArrayIndexOutOfBoundsException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ArrayStoreException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AssertionError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AssertionStatusDirectives": [],
        "AutoCloseable": [],
        "BaseVirtualThread": [],
        "Boolean": [
            [
                "TRUE",
                "java.lang.Boolean"
            ],
            [
                "FALSE",
                "java.lang.Boolean"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Boolean>"
            ],
            [
                "value",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "BootstrapMethodError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Byte": [
            [
                "MIN_VALUE",
                "byte"
            ],
            [
                "MAX_VALUE",
                "byte"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Byte>"
            ],
            [
                "value",
                "byte"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "BYTES",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CharSequence": [],
        "Character": [
            [
                "MIN_RADIX",
                "int"
            ],
            [
                "MAX_RADIX",
                "int"
            ],
            [
                "MIN_VALUE",
                "char"
            ],
            [
                "MAX_VALUE",
                "char"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Character>"
            ],
            [
                "UNASSIGNED",
                "byte"
            ],
            [
                "UPPERCASE_LETTER",
                "byte"
            ],
            [
                "LOWERCASE_LETTER",
                "byte"
            ],
            [
                "TITLECASE_LETTER",
                "byte"
            ],
            [
                "MODIFIER_LETTER",
                "byte"
            ],
            [
                "OTHER_LETTER",
                "byte"
            ],
            [
                "NON_SPACING_MARK",
                "byte"
            ],
            [
                "ENCLOSING_MARK",
                "byte"
            ],
            [
                "COMBINING_SPACING_MARK",
                "byte"
            ],
            [
                "DECIMAL_DIGIT_NUMBER",
                "byte"
            ],
            [
                "LETTER_NUMBER",
                "byte"
            ],
            [
                "OTHER_NUMBER",
                "byte"
            ],
            [
                "SPACE_SEPARATOR",
                "byte"
            ],
            [
                "LINE_SEPARATOR",
                "byte"
            ],
            [
                "PARAGRAPH_SEPARATOR",
                "byte"
            ],
            [
                "CONTROL",
                "byte"
            ],
            [
                "FORMAT",
                "byte"
            ],
            [
                "PRIVATE_USE",
                "byte"
            ],
            [
                "SURROGATE",
                "byte"
            ],
            [
                "DASH_PUNCTUATION",
                "byte"
            ],
            [
                "START_PUNCTUATION",
                "byte"
            ],
            [
                "END_PUNCTUATION",
                "byte"
            ],
            [
                "CONNECTOR_PUNCTUATION",
                "byte"
            ],
            [
                "OTHER_PUNCTUATION",
                "byte"
            ],
            [
                "MATH_SYMBOL",
                "byte"
            ],
            [
                "CURRENCY_SYMBOL",
                "byte"
            ],
            [
                "MODIFIER_SYMBOL",
                "byte"
            ],
            [
                "OTHER_SYMBOL",
                "byte"
            ],
            [
                "INITIAL_QUOTE_PUNCTUATION",
                "byte"
            ],
            [
                "FINAL_QUOTE_PUNCTUATION",
                "byte"
            ],
            [
                "DIRECTIONALITY_UNDEFINED",
                "byte"
            ],
            [
                "DIRECTIONALITY_LEFT_TO_RIGHT",
                "byte"
            ],
            [
                "DIRECTIONALITY_RIGHT_TO_LEFT",
                "byte"
            ],
            [
                "DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC",
                "byte"
            ],
            [
                "DIRECTIONALITY_EUROPEAN_NUMBER",
                "byte"
            ],
            [
                "DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR",
                "byte"
            ],
            [
                "DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR",
                "byte"
            ],
            [
                "DIRECTIONALITY_ARABIC_NUMBER",
                "byte"
            ],
            [
                "DIRECTIONALITY_COMMON_NUMBER_SEPARATOR",
                "byte"
            ],
            [
                "DIRECTIONALITY_NONSPACING_MARK",
                "byte"
            ],
            [
                "DIRECTIONALITY_BOUNDARY_NEUTRAL",
                "byte"
            ],
            [
                "DIRECTIONALITY_PARAGRAPH_SEPARATOR",
                "byte"
            ],
            [
                "DIRECTIONALITY_SEGMENT_SEPARATOR",
                "byte"
            ],
            [
                "DIRECTIONALITY_WHITESPACE",
                "byte"
            ],
            [
                "DIRECTIONALITY_OTHER_NEUTRALS",
                "byte"
            ],
            [
                "DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING",
                "byte"
            ],
            [
                "DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE",
                "byte"
            ],
            [
                "DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING",
                "byte"
            ],
            [
                "DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE",
                "byte"
            ],
            [
                "DIRECTIONALITY_POP_DIRECTIONAL_FORMAT",
                "byte"
            ],
            [
                "DIRECTIONALITY_LEFT_TO_RIGHT_ISOLATE",
                "byte"
            ],
            [
                "DIRECTIONALITY_RIGHT_TO_LEFT_ISOLATE",
                "byte"
            ],
            [
                "DIRECTIONALITY_FIRST_STRONG_ISOLATE",
                "byte"
            ],
            [
                "DIRECTIONALITY_POP_DIRECTIONAL_ISOLATE",
                "byte"
            ],
            [
                "MIN_HIGH_SURROGATE",
                "char"
            ],
            [
                "MAX_HIGH_SURROGATE",
                "char"
            ],
            [
                "MIN_LOW_SURROGATE",
                "char"
            ],
            [
                "MAX_LOW_SURROGATE",
                "char"
            ],
            [
                "MIN_SURROGATE",
                "char"
            ],
            [
                "MAX_SURROGATE",
                "char"
            ],
            [
                "MIN_SUPPLEMENTARY_CODE_POINT",
                "int"
            ],
            [
                "MIN_CODE_POINT",
                "int"
            ],
            [
                "MAX_CODE_POINT",
                "int"
            ],
            [
                "value",
                "char"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "BYTES",
                "int"
            ]
        ],
        "CharacterData": [],
        "CharacterData00": [],
        "CharacterData01": [],
        "CharacterData02": [],
        "CharacterData03": [],
        "CharacterData0E": [],
        "CharacterDataLatin1": [
            [
                "DIGITS",
                "byte[]"
            ]
        ],
        "CharacterDataPrivateUse": [],
        "CharacterDataUndefined": [],
        "CharacterName": [
            [
                "refCharName",
                "java.lang.ref.SoftReference<java.lang.CharacterName>"
            ],
            [
                "strPool",
                "byte[]"
            ],
            [
                "lookup",
                "int[]"
            ],
            [
                "bkIndices",
                "int[]"
            ],
            [
                "cpEntries",
                "int[]"
            ],
            [
                "hsIndices",
                "int[]"
            ]
        ],
        "Class": [
            [
                "ANNOTATION",
                "int"
            ],
            [
                "ENUM",
                "int"
            ],
            [
                "SYNTHETIC",
                "int"
            ],
            [
                "cachedConstructor",
                "java.lang.reflect.Constructor<T>"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "module",
                "java.lang.Module"
            ],
            [
                "classLoader",
                "java.lang.ClassLoader"
            ],
            [
                "classData",
                "java.lang.Object"
            ],
            [
                "signers",
                "java.lang.Object[]"
            ],
            [
                "packageName",
                "java.lang.String"
            ],
            [
                "componentType",
                "java.lang.Class<?>"
            ],
            [
                "reflectionData",
                "java.lang.ref.SoftReference<java.lang.Class$ReflectionData<T>>"
            ],
            [
                "classRedefinedCount",
                "int"
            ],
            [
                "genericInfo",
                "sun.reflect.generics.repository.ClassRepository"
            ],
            [
                "EMPTY_CLASS_ARRAY",
                "java.lang.Class<?>[]"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "reflectionFactory",
                "jdk.internal.reflect.ReflectionFactory"
            ],
            [
                "enumConstants",
                "T[]"
            ],
            [
                "enumConstantDirectory",
                "T>"
            ],
            [
                "annotationData",
                "java.lang.Class$AnnotationData"
            ],
            [
                "annotationType",
                "sun.reflect.annotation.AnnotationType"
            ]
        ],
        "ClassCastException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ClassCircularityError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ClassFormatError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ClassFrameInfo": [
            [
                "MEMBER_INFO_FLAGS",
                "int"
            ],
            [
                "RETAIN_CLASS_REF_BIT",
                "int"
            ]
        ],
        "ClassLoader": [
            [
                "parent",
                "java.lang.ClassLoader"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "unnamedModule",
                "java.lang.Module"
            ],
            [
                "nameAndId",
                "java.lang.String"
            ],
            [
                "parallelLockMap",
                "java.lang.Object>"
            ],
            [
                "package2certs",
                "java.security.cert.Certificate[]>"
            ],
            [
                "nocerts",
                "java.security.cert.Certificate[]"
            ],
            [
                "classes",
                "java.util.ArrayList<java.lang.Class<?>>"
            ],
            [
                "defaultDomain",
                "java.security.ProtectionDomain"
            ],
            [
                "packages",
                "java.lang.NamedPackage>"
            ],
            [
                "scl",
                "java.lang.ClassLoader"
            ],
            [
                "libraries",
                "jdk.internal.loader.NativeLibraries"
            ],
            [
                "defaultAssertionStatus",
                "boolean"
            ],
            [
                "packageAssertionStatus",
                "java.lang.Boolean>"
            ],
            [
                "classLoaderValueMap",
                "?>"
            ]
        ],
        "ClassNotFoundException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "ClassValue": [
            [
                "EMPTY_CACHE",
                "java.lang.ClassValue$Entry<?>[]"
            ],
            [
                "nextHashCode",
                "java.util.concurrent.atomic.AtomicInteger"
            ],
            [
                "HASH_INCREMENT",
                "int"
            ],
            [
                "version",
                "java.lang.ClassValue$Version<T>"
            ],
            [
                "CRITICAL_SECTION",
                "java.lang.Object"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ]
        ],
        "CloneNotSupportedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Cloneable": [],
        "Comparable": [],
        "CompoundEnumeration": [
            [
                "enums",
                "java.util.Enumeration<E>[]"
            ],
            [
                "index",
                "int"
            ]
        ],
        "ConditionalSpecialCasing": [
            [
                "entryTable",
                "java.util.HashSet<java.lang.ConditionalSpecialCasing$Entry>>"
            ]
        ],
        "Deprecated": [],
        "Double": [
            [
                "POSITIVE_INFINITY",
                "double"
            ],
            [
                "NEGATIVE_INFINITY",
                "double"
            ],
            [
                "NaN",
                "double"
            ],
            [
                "MAX_VALUE",
                "double"
            ],
            [
                "MIN_NORMAL",
                "double"
            ],
            [
                "MIN_VALUE",
                "double"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "PRECISION",
                "int"
            ],
            [
                "MAX_EXPONENT",
                "int"
            ],
            [
                "MIN_EXPONENT",
                "int"
            ],
            [
                "BYTES",
                "int"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Double>"
            ],
            [
                "value",
                "double"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Enum": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "ordinal",
                "int"
            ],
            [
                "hash",
                "int"
            ]
        ],
        "EnumConstantNotPresentException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "enumType",
                "java.lang.Enum>"
            ],
            [
                "constantName",
                "java.lang.String"
            ]
        ],
        "Error": [],
        "Exception": [],
        "ExceptionInInitializerError": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "FdLibm": [
            [
                "INFINITY",
                "double"
            ],
            [
                "TWO24",
                "double"
            ],
            [
                "TWO54",
                "double"
            ],
            [
                "HUGE",
                "double"
            ],
            [
                "SIGN_BIT",
                "int"
            ],
            [
                "EXP_BITS",
                "int"
            ],
            [
                "EXP_SIGNIF_BITS",
                "int"
            ]
        ],
        "Float": [
            [
                "POSITIVE_INFINITY",
                "float"
            ],
            [
                "NEGATIVE_INFINITY",
                "float"
            ],
            [
                "NaN",
                "float"
            ],
            [
                "MAX_VALUE",
                "float"
            ],
            [
                "MIN_NORMAL",
                "float"
            ],
            [
                "MIN_VALUE",
                "float"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "PRECISION",
                "int"
            ],
            [
                "MAX_EXPONENT",
                "int"
            ],
            [
                "MIN_EXPONENT",
                "int"
            ],
            [
                "BYTES",
                "int"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Float>"
            ],
            [
                "value",
                "float"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "FunctionalInterface": [],
        "IllegalAccessError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalAccessException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalArgumentException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalCallerException": [],
        "IllegalMonitorStateException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalStateException": [],
        "IllegalThreadStateException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IncompatibleClassChangeError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IndexOutOfBoundsException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InheritableThreadLocal": [],
        "InstantiationError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InstantiationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Integer": [
            [
                "MIN_VALUE",
                "int"
            ],
            [
                "MAX_VALUE",
                "int"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Integer>"
            ],
            [
                "value",
                "int"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "BYTES",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InternalError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InterruptedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Iterable": [],
        "LayerInstantiationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LinkageError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LiveStackFrame": [],
        "LiveStackFrameInfo": [
            [
                "EMPTY_ARRAY",
                "java.lang.Object[]"
            ],
            [
                "MODE_INTERPRETED",
                "int"
            ],
            [
                "MODE_COMPILED",
                "int"
            ],
            [
                "monitors",
                "java.lang.Object[]"
            ],
            [
                "locals",
                "java.lang.Object[]"
            ],
            [
                "operands",
                "java.lang.Object[]"
            ],
            [
                "mode",
                "int"
            ]
        ],
        "Long": [
            [
                "MIN_VALUE",
                "long"
            ],
            [
                "MAX_VALUE",
                "long"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Long>"
            ],
            [
                "value",
                "long"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "BYTES",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MatchException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Math": [
            [
                "E",
                "double"
            ],
            [
                "PI",
                "double"
            ],
            [
                "TAU",
                "double"
            ],
            [
                "DEGREES_TO_RADIANS",
                "double"
            ],
            [
                "RADIANS_TO_DEGREES",
                "double"
            ],
            [
                "negativeZeroFloatBits",
                "long"
            ],
            [
                "negativeZeroDoubleBits",
                "long"
            ],
            [
                "F_UP",
                "double"
            ],
            [
                "F_DOWN",
                "double"
            ]
        ],
        "Module": [
            [
                "layer",
                "java.lang.ModuleLayer"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "loader",
                "java.lang.ClassLoader"
            ],
            [
                "descriptor",
                "java.lang.module.ModuleDescriptor"
            ],
            [
                "enableNativeAccess",
                "boolean"
            ],
            [
                "ALL_UNNAMED_MODULE",
                "java.lang.Module"
            ],
            [
                "ALL_UNNAMED_MODULE_SET",
                "java.util.Set<java.lang.Module>"
            ],
            [
                "EVERYONE_MODULE",
                "java.lang.Module"
            ],
            [
                "EVERYONE_SET",
                "java.util.Set<java.lang.Module>"
            ],
            [
                "reads",
                "java.util.Set<java.lang.Module>"
            ],
            [
                "openPackages",
                "java.util.Set<java.lang.Module>>"
            ],
            [
                "exportedPackages",
                "java.util.Set<java.lang.Module>>"
            ],
            [
                "moduleInfoClass",
                "java.lang.Class<?>"
            ]
        ],
        "ModuleLayer": [
            [
                "EMPTY_LAYER",
                "java.lang.ModuleLayer"
            ],
            [
                "cf",
                "java.lang.module.Configuration"
            ],
            [
                "parents",
                "java.util.List<java.lang.ModuleLayer>"
            ],
            [
                "nameToModule",
                "java.lang.Module>"
            ],
            [
                "allLayers",
                "java.util.List<java.lang.ModuleLayer>"
            ],
            [
                "modules",
                "java.util.Set<java.lang.Module>"
            ],
            [
                "servicesCatalog",
                "jdk.internal.module.ServicesCatalog"
            ],
            [
                "CLV",
                "jdk.internal.loader.ClassLoaderValue<java.util.List<java.lang.ModuleLayer>>"
            ]
        ],
        "NamedPackage": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "module",
                "java.lang.Module"
            ]
        ],
        "NegativeArraySizeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoClassDefFoundError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoSuchFieldError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoSuchFieldException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoSuchMethodError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoSuchMethodException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NullPointerException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "extendedMessageState",
                "int"
            ],
            [
                "extendedMessage",
                "java.lang.String"
            ]
        ],
        "Number": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NumberFormatException": [],
        "Object": [],
        "OutOfMemoryError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Override": [],
        "Package": [
            [
                "versionInfo",
                "java.lang.Package$VersionInfo"
            ],
            [
                "packageInfo",
                "java.lang.Class<?>"
            ]
        ],
        "Process": [
            [
                "outputWriter",
                "java.io.BufferedWriter"
            ],
            [
                "outputCharset",
                "java.nio.charset.Charset"
            ],
            [
                "inputReader",
                "java.io.BufferedReader"
            ],
            [
                "inputCharset",
                "java.nio.charset.Charset"
            ],
            [
                "errorReader",
                "java.io.BufferedReader"
            ],
            [
                "errorCharset",
                "java.nio.charset.Charset"
            ]
        ],
        "ProcessBuilder": [
            [
                "LOGGER",
                "java.lang.System$Logger"
            ],
            [
                "command",
                "java.util.List<java.lang.String>"
            ],
            [
                "directory",
                "java.io.File"
            ],
            [
                "environment",
                "java.lang.String>"
            ],
            [
                "redirectErrorStream",
                "boolean"
            ],
            [
                "redirects",
                "java.lang.ProcessBuilder$Redirect[]"
            ]
        ],
        "ProcessEnvironment": [
            [
                "theEnvironment",
                "java.lang.ProcessEnvironment$Value>"
            ],
            [
                "theUnmodifiableEnvironment",
                "java.lang.String>"
            ]
        ],
        "ProcessHandle": [],
        "ProcessHandleImpl": [
            [
                "REAPER_DEFAULT_STACKSIZE",
                "long"
            ],
            [
                "NOT_A_CHILD",
                "int"
            ],
            [
                "current",
                "java.lang.ProcessHandleImpl"
            ],
            [
                "completions",
                "java.lang.ProcessHandleImpl$ExitCompletion>"
            ],
            [
                "processReaperExecutor",
                "java.util.concurrent.Executor"
            ],
            [
                "pid",
                "long"
            ],
            [
                "startTime",
                "long"
            ],
            [
                "STARTTIME_ANY",
                "long"
            ],
            [
                "STARTTIME_PROCESS_UNKNOWN",
                "long"
            ]
        ],
        "ProcessImpl": [
            [
                "fdAccess",
                "jdk.internal.access.JavaIOFileDescriptorAccess"
            ],
            [
                "pid",
                "int"
            ],
            [
                "processHandle",
                "java.lang.ProcessHandleImpl"
            ],
            [
                "exitcode",
                "int"
            ],
            [
                "hasExited",
                "boolean"
            ],
            [
                "lock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "condition",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "stdin",
                "java.io.OutputStream"
            ],
            [
                "stdout",
                "java.io.InputStream"
            ],
            [
                "stderr",
                "java.io.InputStream"
            ],
            [
                "launchMechanism",
                "java.lang.ProcessImpl$LaunchMechanism"
            ],
            [
                "helperpath",
                "byte[]"
            ]
        ],
        "PublicMethods": [
            [
                "map",
                "java.lang.PublicMethods$MethodList>"
            ],
            [
                "methodCount",
                "int"
            ]
        ],
        "Readable": [],
        "Record": [],
        "ReflectiveOperationException": [],
        "Runnable": [],
        "Runtime": [
            [
                "currentRuntime",
                "java.lang.Runtime"
            ],
            [
                "version",
                "java.lang.Runtime$Version"
            ]
        ],
        "RuntimeException": [],
        "RuntimePermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SafeVarargs": [],
        "ScopedValue": [
            [
                "hash",
                "int"
            ],
            [
                "NEW_THREAD_BINDINGS",
                "java.lang.Object"
            ],
            [
                "nextKey",
                "int"
            ]
        ],
        "SecurityException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SecurityManager": [],
        "Short": [
            [
                "MIN_VALUE",
                "short"
            ],
            [
                "MAX_VALUE",
                "short"
            ],
            [
                "TYPE",
                "java.lang.Class<java.lang.Short>"
            ],
            [
                "value",
                "short"
            ],
            [
                "SIZE",
                "int"
            ],
            [
                "BYTES",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Shutdown": [
            [
                "MAX_SYSTEM_HOOKS",
                "int"
            ],
            [
                "hooks",
                "java.lang.Runnable[]"
            ],
            [
                "currentRunningHook",
                "int"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "haltLock",
                "java.lang.Object"
            ]
        ],
        "StackFrameInfo": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Object"
            ],
            [
                "bci",
                "int"
            ],
            [
                "contScope",
                "jdk.internal.vm.ContinuationScope"
            ],
            [
                "ste",
                "java.lang.StackTraceElement"
            ]
        ],
        "StackOverflowError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StackStreamFactory": [
            [
                "stackWalkImplClasses",
                "java.util.Set<java.lang.Class<?>>"
            ],
            [
                "RESERVED_ELEMENTS",
                "int"
            ],
            [
                "MIN_BATCH_SIZE",
                "int"
            ],
            [
                "SMALL_BATCH",
                "int"
            ],
            [
                "BATCH_SIZE",
                "int"
            ],
            [
                "LARGE_BATCH_SIZE",
                "int"
            ],
            [
                "DEFAULT_MODE",
                "int"
            ],
            [
                "CLASS_INFO_ONLY",
                "int"
            ],
            [
                "SHOW_HIDDEN_FRAMES",
                "int"
            ],
            [
                "FILL_LIVE_STACK_FRAMES",
                "int"
            ]
        ],
        "StackTraceElement": [
            [
                "NATIVE_METHOD",
                "java.lang.String"
            ],
            [
                "UNKNOWN_SOURCE",
                "java.lang.String"
            ],
            [
                "declaringClassObject",
                "java.lang.Class<?>"
            ],
            [
                "classLoaderName",
                "java.lang.String"
            ],
            [
                "moduleName",
                "java.lang.String"
            ],
            [
                "moduleVersion",
                "java.lang.String"
            ],
            [
                "declaringClass",
                "java.lang.String"
            ],
            [
                "methodName",
                "java.lang.String"
            ],
            [
                "fileName",
                "java.lang.String"
            ],
            [
                "lineNumber",
                "int"
            ],
            [
                "format",
                "byte"
            ],
            [
                "BUILTIN_CLASS_LOADER",
                "byte"
            ],
            [
                "JDK_NON_UPGRADEABLE_MODULE",
                "byte"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StackWalker": [
            [
                "DEFAULT_WALKER",
                "java.lang.StackWalker"
            ],
            [
                "continuation",
                "jdk.internal.vm.Continuation"
            ],
            [
                "contScope",
                "jdk.internal.vm.ContinuationScope"
            ],
            [
                "options",
                "java.util.Set<java.lang.StackWalker$Option>"
            ],
            [
                "extendedOption",
                "java.lang.StackWalker$ExtendedOption"
            ],
            [
                "estimateDepth",
                "int"
            ]
        ],
        "StrictMath": [
            [
                "E",
                "double"
            ],
            [
                "PI",
                "double"
            ],
            [
                "TAU",
                "double"
            ]
        ],
        "String": [
            [
                "value",
                "byte[]"
            ],
            [
                "coder",
                "byte"
            ],
            [
                "hash",
                "int"
            ],
            [
                "hashIsZero",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "REPL",
                "char"
            ],
            [
                "CASE_INSENSITIVE_ORDER",
                "java.util.Comparator<java.lang.String>"
            ]
        ],
        "StringBuffer": [
            [
                "toStringCache",
                "java.lang.String"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "StringBuilder": [],
        "StringCoding": [],
        "StringConcatHelper": [
            [
                "LATIN1",
                "long"
            ],
            [
                "UTF16",
                "long"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ]
        ],
        "StringIndexOutOfBoundsException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StringLatin1": [],
        "StringUTF16": [
            [
                "HI_BYTE_SHIFT",
                "int"
            ],
            [
                "LO_BYTE_SHIFT",
                "int"
            ]
        ],
        "SuppressWarnings": [],
        "System": [
            [
                "in",
                "java.io.InputStream"
            ],
            [
                "out",
                "java.io.PrintStream"
            ],
            [
                "err",
                "java.io.PrintStream"
            ],
            [
                "initialIn",
                "java.io.InputStream"
            ],
            [
                "initialErr",
                "java.io.PrintStream"
            ],
            [
                "notSupportedJnuEncoding",
                "java.lang.String"
            ],
            [
                "cons",
                "java.io.Console"
            ],
            [
                "props",
                "java.util.Properties"
            ],
            [
                "lineSeparator",
                "java.lang.String"
            ]
        ],
        "Terminator": [
            [
                "handler",
                "jdk.internal.misc.Signal$Handler"
            ]
        ],
        "Thread": [
            [
                "eetop",
                "long"
            ],
            [
                "tid",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "contextClassLoader",
                "java.lang.ClassLoader"
            ],
            [
                "holder",
                "java.lang.Thread$FieldHolder"
            ],
            [
                "scopedValueBindings",
                "java.lang.Object"
            ],
            [
                "NEW_THREAD_BINDINGS",
                "java.lang.Object"
            ],
            [
                "parkBlocker",
                "java.lang.Object"
            ],
            [
                "nioBlocker",
                "sun.nio.ch.Interruptible"
            ],
            [
                "MIN_PRIORITY",
                "int"
            ],
            [
                "NORM_PRIORITY",
                "int"
            ],
            [
                "MAX_PRIORITY",
                "int"
            ],
            [
                "cont",
                "jdk.internal.vm.Continuation"
            ],
            [
                "EMPTY_STACK_TRACE",
                "java.lang.StackTraceElement[]"
            ],
            [
                "uncaughtExceptionHandler",
                "java.lang.Thread$UncaughtExceptionHandler"
            ],
            [
                "defaultUncaughtExceptionHandler",
                "java.lang.Thread$UncaughtExceptionHandler"
            ],
            [
                "container",
                "jdk.internal.vm.ThreadContainer"
            ],
            [
                "headStackableScopes",
                "jdk.internal.vm.StackableScope"
            ]
        ],
        "ThreadBuilders": [],
        "ThreadDeath": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ThreadGroup": [
            [
                "parent",
                "java.lang.ThreadGroup"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "maxPriority",
                "int"
            ],
            [
                "daemon",
                "boolean"
            ],
            [
                "ngroups",
                "int"
            ],
            [
                "groups",
                "java.lang.ThreadGroup[]"
            ],
            [
                "nweaks",
                "int"
            ],
            [
                "weaks",
                "java.lang.ref.WeakReference<java.lang.ThreadGroup>[]"
            ]
        ],
        "ThreadLocal": [
            [
                "TRACE_VTHREAD_LOCALS",
                "boolean"
            ],
            [
                "threadLocalHashCode",
                "int"
            ],
            [
                "nextHashCode",
                "java.util.concurrent.atomic.AtomicInteger"
            ],
            [
                "HASH_INCREMENT",
                "int"
            ],
            [
                "DUMPING_STACK",
                "java.lang.ThreadLocal<java.lang.Boolean>"
            ]
        ],
        "Throwable": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "backtrace",
                "java.lang.Object"
            ],
            [
                "detailMessage",
                "java.lang.String"
            ],
            [
                "UNASSIGNED_STACK",
                "java.lang.StackTraceElement[]"
            ],
            [
                "cause",
                "java.lang.Throwable"
            ],
            [
                "stackTrace",
                "java.lang.StackTraceElement[]"
            ],
            [
                "depth",
                "int"
            ],
            [
                "SUPPRESSED_SENTINEL",
                "java.util.List<java.lang.Throwable>"
            ],
            [
                "suppressedExceptions",
                "java.util.List<java.lang.Throwable>"
            ],
            [
                "NULL_CAUSE_MESSAGE",
                "java.lang.String"
            ],
            [
                "SELF_SUPPRESSION_MESSAGE",
                "java.lang.String"
            ],
            [
                "CAUSE_CAPTION",
                "java.lang.String"
            ],
            [
                "SUPPRESSED_CAPTION",
                "java.lang.String"
            ],
            [
                "EMPTY_THROWABLE_ARRAY",
                "java.lang.Throwable[]"
            ]
        ],
        "TypeNotPresentException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "typeName",
                "java.lang.String"
            ]
        ],
        "UnknownError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnsatisfiedLinkError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnsupportedClassVersionError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnsupportedOperationException": [],
        "VerifyError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "VersionProps": [
            [
                "launcher_name",
                "java.lang.String"
            ],
            [
                "java_version",
                "java.lang.String"
            ],
            [
                "java_version_date",
                "java.lang.String"
            ],
            [
                "java_runtime_name",
                "java.lang.String"
            ],
            [
                "java_runtime_version",
                "java.lang.String"
            ],
            [
                "VERSION_NUMBER",
                "java.lang.String"
            ],
            [
                "VERSION_SPECIFICATION",
                "java.lang.String"
            ],
            [
                "VERSION_BUILD",
                "java.lang.String"
            ],
            [
                "VERSION_PRE",
                "java.lang.String"
            ],
            [
                "VERSION_OPT",
                "java.lang.String"
            ],
            [
                "isLTS",
                "boolean"
            ],
            [
                "CLASSFILE_MAJOR_MINOR",
                "java.lang.String"
            ],
            [
                "VENDOR",
                "java.lang.String"
            ],
            [
                "VENDOR_URL",
                "java.lang.String"
            ],
            [
                "VENDOR_VERSION",
                "java.lang.String"
            ],
            [
                "VENDOR_URL_BUG",
                "java.lang.String"
            ],
            [
                "VENDOR_URL_VM_BUG",
                "java.lang.String"
            ]
        ],
        "VirtualMachineError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "VirtualThread": [
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "VTHREAD_SCOPE",
                "jdk.internal.vm.ContinuationScope"
            ],
            [
                "DEFAULT_SCHEDULER",
                "java.util.concurrent.ForkJoinPool"
            ],
            [
                "DELAYED_TASK_SCHEDULERS",
                "java.util.concurrent.ScheduledExecutorService[]"
            ],
            [
                "STATE",
                "long"
            ],
            [
                "PARK_PERMIT",
                "long"
            ],
            [
                "CARRIER_THREAD",
                "long"
            ],
            [
                "TERMINATION",
                "long"
            ],
            [
                "ON_WAITING_LIST",
                "long"
            ],
            [
                "scheduler",
                "java.util.concurrent.Executor"
            ],
            [
                "cont",
                "jdk.internal.vm.Continuation"
            ],
            [
                "runContinuation",
                "java.lang.Runnable"
            ],
            [
                "state",
                "int"
            ],
            [
                "NEW",
                "int"
            ],
            [
                "STARTED",
                "int"
            ],
            [
                "RUNNING",
                "int"
            ],
            [
                "PARKING",
                "int"
            ],
            [
                "PARKED",
                "int"
            ],
            [
                "PINNED",
                "int"
            ],
            [
                "TIMED_PARKING",
                "int"
            ],
            [
                "TIMED_PARKED",
                "int"
            ],
            [
                "TIMED_PINNED",
                "int"
            ],
            [
                "UNPARKED",
                "int"
            ],
            [
                "YIELDING",
                "int"
            ],
            [
                "YIELDED",
                "int"
            ],
            [
                "BLOCKING",
                "int"
            ],
            [
                "BLOCKED",
                "int"
            ],
            [
                "UNBLOCKED",
                "int"
            ],
            [
                "WAITING",
                "int"
            ],
            [
                "WAIT",
                "int"
            ],
            [
                "TIMED_WAITING",
                "int"
            ],
            [
                "TIMED_WAIT",
                "int"
            ],
            [
                "TERMINATED",
                "int"
            ],
            [
                "SUSPENDED",
                "int"
            ],
            [
                "parkPermit",
                "boolean"
            ],
            [
                "blockPermit",
                "boolean"
            ],
            [
                "onWaitingList",
                "boolean"
            ],
            [
                "next",
                "java.lang.VirtualThread"
            ],
            [
                "notified",
                "boolean"
            ],
            [
                "timedWaitSeqNo",
                "byte"
            ],
            [
                "timeout",
                "long"
            ],
            [
                "timeoutTask",
                "java.util.concurrent.Future<?>"
            ],
            [
                "carrierThread",
                "java.lang.Thread"
            ],
            [
                "termination",
                "java.util.concurrent.CountDownLatch"
            ]
        ],
        "Void": [
            [
                "TYPE",
                "java.lang.Class<java.lang.Void>"
            ]
        ],
        "WeakPairMap": [
            [
                "map",
                "V>"
            ],
            [
                "queue",
                "java.lang.ref.ReferenceQueue<java.lang.Object>"
            ]
        ],
        "WrongThreadException": []
    },
    "java.lang.annotation": {
        "Annotation": [],
        "AnnotationFormatError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AnnotationTypeMismatchException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "element",
                "java.lang.reflect.Method"
            ],
            [
                "foundType",
                "java.lang.String"
            ]
        ],
        "Documented": [],
        "ElementType": [
            [
                "TYPE",
                "java.lang.annotation.ElementType"
            ],
            [
                "FIELD",
                "java.lang.annotation.ElementType"
            ],
            [
                "METHOD",
                "java.lang.annotation.ElementType"
            ],
            [
                "PARAMETER",
                "java.lang.annotation.ElementType"
            ],
            [
                "CONSTRUCTOR",
                "java.lang.annotation.ElementType"
            ],
            [
                "LOCAL_VARIABLE",
                "java.lang.annotation.ElementType"
            ],
            [
                "ANNOTATION_TYPE",
                "java.lang.annotation.ElementType"
            ],
            [
                "PACKAGE",
                "java.lang.annotation.ElementType"
            ],
            [
                "TYPE_PARAMETER",
                "java.lang.annotation.ElementType"
            ],
            [
                "TYPE_USE",
                "java.lang.annotation.ElementType"
            ],
            [
                "MODULE",
                "java.lang.annotation.ElementType"
            ],
            [
                "RECORD_COMPONENT",
                "java.lang.annotation.ElementType"
            ],
            [
                "$VALUES",
                "java.lang.annotation.ElementType[]"
            ]
        ],
        "IncompleteAnnotationException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "annotationType",
                "java.lang.annotation.Annotation>"
            ],
            [
                "elementName",
                "java.lang.String"
            ]
        ],
        "Inherited": [],
        "Native": [],
        "Repeatable": [],
        "Retention": [],
        "RetentionPolicy": [
            [
                "SOURCE",
                "java.lang.annotation.RetentionPolicy"
            ],
            [
                "CLASS",
                "java.lang.annotation.RetentionPolicy"
            ],
            [
                "RUNTIME",
                "java.lang.annotation.RetentionPolicy"
            ],
            [
                "$VALUES",
                "java.lang.annotation.RetentionPolicy[]"
            ]
        ],
        "Target": []
    },
    "java.lang.classfile": {
        "AccessFlags": [],
        "Annotation": [],
        "AnnotationElement": [],
        "AnnotationValue": [
            [
                "TAG_BYTE",
                "int"
            ],
            [
                "TAG_CHAR",
                "int"
            ],
            [
                "TAG_DOUBLE",
                "int"
            ],
            [
                "TAG_FLOAT",
                "int"
            ],
            [
                "TAG_INT",
                "int"
            ],
            [
                "TAG_LONG",
                "int"
            ],
            [
                "TAG_SHORT",
                "int"
            ],
            [
                "TAG_BOOLEAN",
                "int"
            ],
            [
                "TAG_STRING",
                "int"
            ],
            [
                "TAG_ENUM",
                "int"
            ],
            [
                "TAG_CLASS",
                "int"
            ],
            [
                "TAG_ANNOTATION",
                "int"
            ],
            [
                "TAG_ARRAY",
                "int"
            ]
        ],
        "Attribute": [],
        "AttributeMapper": [],
        "AttributedElement": [],
        "Attributes": [
            [
                "NAME_ANNOTATION_DEFAULT",
                "java.lang.String"
            ],
            [
                "NAME_BOOTSTRAP_METHODS",
                "java.lang.String"
            ],
            [
                "NAME_CHARACTER_RANGE_TABLE",
                "java.lang.String"
            ],
            [
                "NAME_CODE",
                "java.lang.String"
            ],
            [
                "NAME_COMPILATION_ID",
                "java.lang.String"
            ],
            [
                "NAME_CONSTANT_VALUE",
                "java.lang.String"
            ],
            [
                "NAME_DEPRECATED",
                "java.lang.String"
            ],
            [
                "NAME_ENCLOSING_METHOD",
                "java.lang.String"
            ],
            [
                "NAME_EXCEPTIONS",
                "java.lang.String"
            ],
            [
                "NAME_INNER_CLASSES",
                "java.lang.String"
            ],
            [
                "NAME_LINE_NUMBER_TABLE",
                "java.lang.String"
            ],
            [
                "NAME_LOCAL_VARIABLE_TABLE",
                "java.lang.String"
            ],
            [
                "NAME_LOCAL_VARIABLE_TYPE_TABLE",
                "java.lang.String"
            ],
            [
                "NAME_METHOD_PARAMETERS",
                "java.lang.String"
            ],
            [
                "NAME_MODULE",
                "java.lang.String"
            ],
            [
                "NAME_MODULE_HASHES",
                "java.lang.String"
            ],
            [
                "NAME_MODULE_MAIN_CLASS",
                "java.lang.String"
            ],
            [
                "NAME_MODULE_PACKAGES",
                "java.lang.String"
            ],
            [
                "NAME_MODULE_RESOLUTION",
                "java.lang.String"
            ],
            [
                "NAME_MODULE_TARGET",
                "java.lang.String"
            ],
            [
                "NAME_NEST_HOST",
                "java.lang.String"
            ],
            [
                "NAME_NEST_MEMBERS",
                "java.lang.String"
            ],
            [
                "NAME_PERMITTED_SUBCLASSES",
                "java.lang.String"
            ],
            [
                "NAME_RECORD",
                "java.lang.String"
            ],
            [
                "NAME_RUNTIME_INVISIBLE_ANNOTATIONS",
                "java.lang.String"
            ],
            [
                "NAME_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS",
                "java.lang.String"
            ],
            [
                "NAME_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS",
                "java.lang.String"
            ],
            [
                "NAME_RUNTIME_VISIBLE_ANNOTATIONS",
                "java.lang.String"
            ],
            [
                "NAME_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS",
                "java.lang.String"
            ],
            [
                "NAME_RUNTIME_VISIBLE_TYPE_ANNOTATIONS",
                "java.lang.String"
            ],
            [
                "NAME_SIGNATURE",
                "java.lang.String"
            ],
            [
                "NAME_SOURCE_DEBUG_EXTENSION",
                "java.lang.String"
            ],
            [
                "NAME_SOURCE_FILE",
                "java.lang.String"
            ],
            [
                "NAME_SOURCE_ID",
                "java.lang.String"
            ],
            [
                "NAME_STACK_MAP_TABLE",
                "java.lang.String"
            ],
            [
                "NAME_SYNTHETIC",
                "java.lang.String"
            ]
        ],
        "BootstrapMethodEntry": [],
        "BufWriter": [],
        "ClassBuilder": [],
        "ClassElement": [],
        "ClassFile": [
            [
                "MAGIC_NUMBER",
                "int"
            ],
            [
                "ACC_PUBLIC",
                "int"
            ],
            [
                "ACC_PROTECTED",
                "int"
            ],
            [
                "ACC_PRIVATE",
                "int"
            ],
            [
                "ACC_INTERFACE",
                "int"
            ],
            [
                "ACC_ENUM",
                "int"
            ],
            [
                "ACC_ANNOTATION",
                "int"
            ],
            [
                "ACC_SUPER",
                "int"
            ],
            [
                "ACC_ABSTRACT",
                "int"
            ],
            [
                "ACC_VOLATILE",
                "int"
            ],
            [
                "ACC_TRANSIENT",
                "int"
            ],
            [
                "ACC_SYNTHETIC",
                "int"
            ],
            [
                "ACC_STATIC",
                "int"
            ],
            [
                "ACC_FINAL",
                "int"
            ],
            [
                "ACC_SYNCHRONIZED",
                "int"
            ],
            [
                "ACC_BRIDGE",
                "int"
            ],
            [
                "ACC_VARARGS",
                "int"
            ],
            [
                "ACC_NATIVE",
                "int"
            ],
            [
                "ACC_STRICT",
                "int"
            ],
            [
                "ACC_MODULE",
                "int"
            ],
            [
                "ACC_OPEN",
                "int"
            ],
            [
                "ACC_MANDATED",
                "int"
            ],
            [
                "ACC_TRANSITIVE",
                "int"
            ],
            [
                "ACC_STATIC_PHASE",
                "int"
            ],
            [
                "JAVA_1_VERSION",
                "int"
            ],
            [
                "JAVA_2_VERSION",
                "int"
            ],
            [
                "JAVA_3_VERSION",
                "int"
            ],
            [
                "JAVA_4_VERSION",
                "int"
            ],
            [
                "JAVA_5_VERSION",
                "int"
            ],
            [
                "JAVA_6_VERSION",
                "int"
            ],
            [
                "JAVA_7_VERSION",
                "int"
            ],
            [
                "JAVA_8_VERSION",
                "int"
            ],
            [
                "JAVA_9_VERSION",
                "int"
            ],
            [
                "JAVA_10_VERSION",
                "int"
            ],
            [
                "JAVA_11_VERSION",
                "int"
            ],
            [
                "JAVA_12_VERSION",
                "int"
            ],
            [
                "JAVA_13_VERSION",
                "int"
            ],
            [
                "JAVA_14_VERSION",
                "int"
            ],
            [
                "JAVA_15_VERSION",
                "int"
            ],
            [
                "JAVA_16_VERSION",
                "int"
            ],
            [
                "JAVA_17_VERSION",
                "int"
            ],
            [
                "JAVA_18_VERSION",
                "int"
            ],
            [
                "JAVA_19_VERSION",
                "int"
            ],
            [
                "JAVA_20_VERSION",
                "int"
            ],
            [
                "JAVA_21_VERSION",
                "int"
            ],
            [
                "JAVA_22_VERSION",
                "int"
            ],
            [
                "JAVA_23_VERSION",
                "int"
            ],
            [
                "JAVA_24_VERSION",
                "int"
            ],
            [
                "PREVIEW_MINOR_VERSION",
                "int"
            ]
        ],
        "ClassFileBuilder": [],
        "ClassFileElement": [],
        "ClassFileTransform": [],
        "ClassFileVersion": [],
        "ClassHierarchyResolver": [],
        "ClassModel": [],
        "ClassReader": [],
        "ClassSignature": [],
        "ClassTransform": [
            [
                "ACCEPT_ALL",
                "java.lang.classfile.ClassTransform"
            ]
        ],
        "CodeBuilder": [],
        "CodeElement": [],
        "CodeModel": [],
        "CodeTransform": [
            [
                "ACCEPT_ALL",
                "java.lang.classfile.CodeTransform"
            ]
        ],
        "CompoundElement": [],
        "CustomAttribute": [
            [
                "mapper",
                "java.lang.classfile.AttributeMapper<T>"
            ]
        ],
        "FieldBuilder": [],
        "FieldElement": [],
        "FieldModel": [],
        "FieldTransform": [
            [
                "ACCEPT_ALL",
                "java.lang.classfile.FieldTransform"
            ]
        ],
        "Instruction": [],
        "Interfaces": [],
        "Label": [],
        "MethodBuilder": [],
        "MethodElement": [],
        "MethodModel": [],
        "MethodSignature": [],
        "MethodTransform": [
            [
                "ACCEPT_ALL",
                "java.lang.classfile.MethodTransform"
            ]
        ],
        "Opcode": [
            [
                "NOP",
                "java.lang.classfile.Opcode"
            ],
            [
                "ACONST_NULL",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_M1",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_4",
                "java.lang.classfile.Opcode"
            ],
            [
                "ICONST_5",
                "java.lang.classfile.Opcode"
            ],
            [
                "LCONST_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "LCONST_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "FCONST_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "FCONST_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "FCONST_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "DCONST_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "DCONST_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "BIPUSH",
                "java.lang.classfile.Opcode"
            ],
            [
                "SIPUSH",
                "java.lang.classfile.Opcode"
            ],
            [
                "LDC",
                "java.lang.classfile.Opcode"
            ],
            [
                "LDC_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "LDC2_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "ILOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "LLOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "FLOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "DLOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "ALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "ILOAD_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "ILOAD_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "ILOAD_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "ILOAD_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "LLOAD_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "LLOAD_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "LLOAD_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "LLOAD_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "FLOAD_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "FLOAD_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "FLOAD_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "FLOAD_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "DLOAD_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "DLOAD_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "DLOAD_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "DLOAD_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "ALOAD_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "ALOAD_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "ALOAD_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "ALOAD_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "IALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "LALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "FALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "DALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "AALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "BALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "CALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "SALOAD",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "ASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISTORE_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISTORE_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISTORE_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISTORE_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSTORE_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSTORE_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSTORE_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSTORE_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSTORE_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSTORE_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSTORE_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSTORE_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSTORE_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSTORE_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSTORE_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSTORE_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "ASTORE_0",
                "java.lang.classfile.Opcode"
            ],
            [
                "ASTORE_1",
                "java.lang.classfile.Opcode"
            ],
            [
                "ASTORE_2",
                "java.lang.classfile.Opcode"
            ],
            [
                "ASTORE_3",
                "java.lang.classfile.Opcode"
            ],
            [
                "IASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "LASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "FASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "DASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "AASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "BASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "CASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "SASTORE",
                "java.lang.classfile.Opcode"
            ],
            [
                "POP",
                "java.lang.classfile.Opcode"
            ],
            [
                "POP2",
                "java.lang.classfile.Opcode"
            ],
            [
                "DUP",
                "java.lang.classfile.Opcode"
            ],
            [
                "DUP_X1",
                "java.lang.classfile.Opcode"
            ],
            [
                "DUP_X2",
                "java.lang.classfile.Opcode"
            ],
            [
                "DUP2",
                "java.lang.classfile.Opcode"
            ],
            [
                "DUP2_X1",
                "java.lang.classfile.Opcode"
            ],
            [
                "DUP2_X2",
                "java.lang.classfile.Opcode"
            ],
            [
                "SWAP",
                "java.lang.classfile.Opcode"
            ],
            [
                "IADD",
                "java.lang.classfile.Opcode"
            ],
            [
                "LADD",
                "java.lang.classfile.Opcode"
            ],
            [
                "FADD",
                "java.lang.classfile.Opcode"
            ],
            [
                "DADD",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISUB",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSUB",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSUB",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSUB",
                "java.lang.classfile.Opcode"
            ],
            [
                "IMUL",
                "java.lang.classfile.Opcode"
            ],
            [
                "LMUL",
                "java.lang.classfile.Opcode"
            ],
            [
                "FMUL",
                "java.lang.classfile.Opcode"
            ],
            [
                "DMUL",
                "java.lang.classfile.Opcode"
            ],
            [
                "IDIV",
                "java.lang.classfile.Opcode"
            ],
            [
                "LDIV",
                "java.lang.classfile.Opcode"
            ],
            [
                "FDIV",
                "java.lang.classfile.Opcode"
            ],
            [
                "DDIV",
                "java.lang.classfile.Opcode"
            ],
            [
                "IREM",
                "java.lang.classfile.Opcode"
            ],
            [
                "LREM",
                "java.lang.classfile.Opcode"
            ],
            [
                "FREM",
                "java.lang.classfile.Opcode"
            ],
            [
                "DREM",
                "java.lang.classfile.Opcode"
            ],
            [
                "INEG",
                "java.lang.classfile.Opcode"
            ],
            [
                "LNEG",
                "java.lang.classfile.Opcode"
            ],
            [
                "FNEG",
                "java.lang.classfile.Opcode"
            ],
            [
                "DNEG",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISHL",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSHL",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISHR",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSHR",
                "java.lang.classfile.Opcode"
            ],
            [
                "IUSHR",
                "java.lang.classfile.Opcode"
            ],
            [
                "LUSHR",
                "java.lang.classfile.Opcode"
            ],
            [
                "IAND",
                "java.lang.classfile.Opcode"
            ],
            [
                "LAND",
                "java.lang.classfile.Opcode"
            ],
            [
                "IOR",
                "java.lang.classfile.Opcode"
            ],
            [
                "LOR",
                "java.lang.classfile.Opcode"
            ],
            [
                "IXOR",
                "java.lang.classfile.Opcode"
            ],
            [
                "LXOR",
                "java.lang.classfile.Opcode"
            ],
            [
                "IINC",
                "java.lang.classfile.Opcode"
            ],
            [
                "I2L",
                "java.lang.classfile.Opcode"
            ],
            [
                "I2F",
                "java.lang.classfile.Opcode"
            ],
            [
                "I2D",
                "java.lang.classfile.Opcode"
            ],
            [
                "L2I",
                "java.lang.classfile.Opcode"
            ],
            [
                "L2F",
                "java.lang.classfile.Opcode"
            ],
            [
                "L2D",
                "java.lang.classfile.Opcode"
            ],
            [
                "F2I",
                "java.lang.classfile.Opcode"
            ],
            [
                "F2L",
                "java.lang.classfile.Opcode"
            ],
            [
                "F2D",
                "java.lang.classfile.Opcode"
            ],
            [
                "D2I",
                "java.lang.classfile.Opcode"
            ],
            [
                "D2L",
                "java.lang.classfile.Opcode"
            ],
            [
                "D2F",
                "java.lang.classfile.Opcode"
            ],
            [
                "I2B",
                "java.lang.classfile.Opcode"
            ],
            [
                "I2C",
                "java.lang.classfile.Opcode"
            ],
            [
                "I2S",
                "java.lang.classfile.Opcode"
            ],
            [
                "LCMP",
                "java.lang.classfile.Opcode"
            ],
            [
                "FCMPL",
                "java.lang.classfile.Opcode"
            ],
            [
                "FCMPG",
                "java.lang.classfile.Opcode"
            ],
            [
                "DCMPL",
                "java.lang.classfile.Opcode"
            ],
            [
                "DCMPG",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFEQ",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFNE",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFLT",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFGE",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFGT",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFLE",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ICMPEQ",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ICMPNE",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ICMPLT",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ICMPGE",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ICMPGT",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ICMPLE",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ACMPEQ",
                "java.lang.classfile.Opcode"
            ],
            [
                "IF_ACMPNE",
                "java.lang.classfile.Opcode"
            ],
            [
                "GOTO",
                "java.lang.classfile.Opcode"
            ],
            [
                "JSR",
                "java.lang.classfile.Opcode"
            ],
            [
                "RET",
                "java.lang.classfile.Opcode"
            ],
            [
                "TABLESWITCH",
                "java.lang.classfile.Opcode"
            ],
            [
                "LOOKUPSWITCH",
                "java.lang.classfile.Opcode"
            ],
            [
                "IRETURN",
                "java.lang.classfile.Opcode"
            ],
            [
                "LRETURN",
                "java.lang.classfile.Opcode"
            ],
            [
                "FRETURN",
                "java.lang.classfile.Opcode"
            ],
            [
                "DRETURN",
                "java.lang.classfile.Opcode"
            ],
            [
                "ARETURN",
                "java.lang.classfile.Opcode"
            ],
            [
                "RETURN",
                "java.lang.classfile.Opcode"
            ],
            [
                "GETSTATIC",
                "java.lang.classfile.Opcode"
            ],
            [
                "PUTSTATIC",
                "java.lang.classfile.Opcode"
            ],
            [
                "GETFIELD",
                "java.lang.classfile.Opcode"
            ],
            [
                "PUTFIELD",
                "java.lang.classfile.Opcode"
            ],
            [
                "INVOKEVIRTUAL",
                "java.lang.classfile.Opcode"
            ],
            [
                "INVOKESPECIAL",
                "java.lang.classfile.Opcode"
            ],
            [
                "INVOKESTATIC",
                "java.lang.classfile.Opcode"
            ],
            [
                "INVOKEINTERFACE",
                "java.lang.classfile.Opcode"
            ],
            [
                "INVOKEDYNAMIC",
                "java.lang.classfile.Opcode"
            ],
            [
                "NEW",
                "java.lang.classfile.Opcode"
            ],
            [
                "NEWARRAY",
                "java.lang.classfile.Opcode"
            ],
            [
                "ANEWARRAY",
                "java.lang.classfile.Opcode"
            ],
            [
                "ARRAYLENGTH",
                "java.lang.classfile.Opcode"
            ],
            [
                "ATHROW",
                "java.lang.classfile.Opcode"
            ],
            [
                "CHECKCAST",
                "java.lang.classfile.Opcode"
            ],
            [
                "INSTANCEOF",
                "java.lang.classfile.Opcode"
            ],
            [
                "MONITORENTER",
                "java.lang.classfile.Opcode"
            ],
            [
                "MONITOREXIT",
                "java.lang.classfile.Opcode"
            ],
            [
                "MULTIANEWARRAY",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFNULL",
                "java.lang.classfile.Opcode"
            ],
            [
                "IFNONNULL",
                "java.lang.classfile.Opcode"
            ],
            [
                "GOTO_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "JSR_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "ILOAD_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "LLOAD_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "FLOAD_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "DLOAD_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "ALOAD_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "ISTORE_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "LSTORE_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "FSTORE_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "DSTORE_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "ASTORE_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "RET_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "IINC_W",
                "java.lang.classfile.Opcode"
            ],
            [
                "bytecode",
                "int"
            ],
            [
                "sizeIfFixed",
                "int"
            ],
            [
                "kind",
                "java.lang.classfile.Opcode$Kind"
            ],
            [
                "$VALUES",
                "java.lang.classfile.Opcode[]"
            ]
        ],
        "PseudoInstruction": [],
        "Signature": [],
        "Superclass": [],
        "TypeAnnotation": [],
        "TypeKind": [
            [
                "BOOLEAN",
                "java.lang.classfile.TypeKind"
            ],
            [
                "BYTE",
                "java.lang.classfile.TypeKind"
            ],
            [
                "CHAR",
                "java.lang.classfile.TypeKind"
            ],
            [
                "SHORT",
                "java.lang.classfile.TypeKind"
            ],
            [
                "INT",
                "java.lang.classfile.TypeKind"
            ],
            [
                "LONG",
                "java.lang.classfile.TypeKind"
            ],
            [
                "FLOAT",
                "java.lang.classfile.TypeKind"
            ],
            [
                "DOUBLE",
                "java.lang.classfile.TypeKind"
            ],
            [
                "REFERENCE",
                "java.lang.classfile.TypeKind"
            ],
            [
                "VOID",
                "java.lang.classfile.TypeKind"
            ],
            [
                "upperBound",
                "java.lang.constant.ClassDesc"
            ],
            [
                "slots",
                "int"
            ],
            [
                "newarrayCode",
                "int"
            ],
            [
                "$VALUES",
                "java.lang.classfile.TypeKind[]"
            ]
        ]
    },
    "java.lang.classfile.attribute": {
        "AnnotationDefaultAttribute": [],
        "BootstrapMethodsAttribute": [],
        "CharacterRangeInfo": [],
        "CharacterRangeTableAttribute": [],
        "CodeAttribute": [],
        "CompilationIDAttribute": [],
        "ConstantValueAttribute": [],
        "DeprecatedAttribute": [],
        "EnclosingMethodAttribute": [],
        "ExceptionsAttribute": [],
        "InnerClassInfo": [],
        "InnerClassesAttribute": [],
        "LineNumberInfo": [],
        "LineNumberTableAttribute": [],
        "LocalVariableInfo": [],
        "LocalVariableTableAttribute": [],
        "LocalVariableTypeInfo": [],
        "LocalVariableTypeTableAttribute": [],
        "MethodParameterInfo": [],
        "MethodParametersAttribute": [],
        "ModuleAttribute": [],
        "ModuleExportInfo": [],
        "ModuleHashInfo": [],
        "ModuleHashesAttribute": [],
        "ModuleMainClassAttribute": [],
        "ModuleOpenInfo": [],
        "ModulePackagesAttribute": [],
        "ModuleProvideInfo": [],
        "ModuleRequireInfo": [],
        "ModuleResolutionAttribute": [],
        "ModuleTargetAttribute": [],
        "NestHostAttribute": [],
        "NestMembersAttribute": [],
        "PermittedSubclassesAttribute": [],
        "RecordAttribute": [],
        "RecordComponentInfo": [],
        "RuntimeInvisibleAnnotationsAttribute": [],
        "RuntimeInvisibleParameterAnnotationsAttribute": [],
        "RuntimeInvisibleTypeAnnotationsAttribute": [],
        "RuntimeVisibleAnnotationsAttribute": [],
        "RuntimeVisibleParameterAnnotationsAttribute": [],
        "RuntimeVisibleTypeAnnotationsAttribute": [],
        "SignatureAttribute": [],
        "SourceDebugExtensionAttribute": [],
        "SourceFileAttribute": [],
        "SourceIDAttribute": [],
        "StackMapFrameInfo": [],
        "StackMapTableAttribute": [],
        "SyntheticAttribute": [],
        "UnknownAttribute": []
    },
    "java.lang.classfile.attribute.snippet": {
        "PackageSnippets": [
            [
                "DEPRECATED_DESC",
                "java.lang.String"
            ]
        ]
    },
    "java.lang.classfile.components.snippets": {
        "PackageSnippets": [
            [
                "CD_Foo",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Bar",
                "java.lang.constant.ClassDesc"
            ]
        ]
    },
    "java.lang.classfile.constantpool": {
        "AnnotationConstantValueEntry": [],
        "ClassEntry": [],
        "ConstantDynamicEntry": [],
        "ConstantPool": [],
        "ConstantPoolBuilder": [],
        "ConstantPoolException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ConstantValueEntry": [],
        "DoubleEntry": [],
        "DynamicConstantPoolEntry": [],
        "FieldRefEntry": [],
        "FloatEntry": [],
        "IntegerEntry": [],
        "InterfaceMethodRefEntry": [],
        "InvokeDynamicEntry": [],
        "LoadableConstantEntry": [],
        "LongEntry": [],
        "MemberRefEntry": [],
        "MethodHandleEntry": [],
        "MethodRefEntry": [],
        "MethodTypeEntry": [],
        "ModuleEntry": [],
        "NameAndTypeEntry": [],
        "PackageEntry": [],
        "PoolEntry": [
            [
                "TAG_CLASS",
                "int"
            ],
            [
                "TAG_DOUBLE",
                "int"
            ],
            [
                "TAG_DYNAMIC",
                "int"
            ],
            [
                "TAG_FIELDREF",
                "int"
            ],
            [
                "TAG_FLOAT",
                "int"
            ],
            [
                "TAG_INTEGER",
                "int"
            ],
            [
                "TAG_INTERFACE_METHODREF",
                "int"
            ],
            [
                "TAG_INVOKE_DYNAMIC",
                "int"
            ],
            [
                "TAG_LONG",
                "int"
            ],
            [
                "TAG_METHOD_HANDLE",
                "int"
            ],
            [
                "TAG_METHODREF",
                "int"
            ],
            [
                "TAG_METHOD_TYPE",
                "int"
            ],
            [
                "TAG_MODULE",
                "int"
            ],
            [
                "TAG_NAME_AND_TYPE",
                "int"
            ],
            [
                "TAG_PACKAGE",
                "int"
            ],
            [
                "TAG_STRING",
                "int"
            ],
            [
                "TAG_UTF8",
                "int"
            ]
        ],
        "StringEntry": [],
        "Utf8Entry": []
    },
    "java.lang.classfile.constantpool.snippet": {
        "PackageSnippets": []
    },
    "java.lang.classfile.instruction": {
        "ArrayLoadInstruction": [],
        "ArrayStoreInstruction": [],
        "BranchInstruction": [],
        "CharacterRange": [
            [
                "FLAG_STATEMENT",
                "int"
            ],
            [
                "FLAG_BLOCK",
                "int"
            ],
            [
                "FLAG_ASSIGNMENT",
                "int"
            ],
            [
                "FLAG_FLOW_CONTROLLER",
                "int"
            ],
            [
                "FLAG_FLOW_TARGET",
                "int"
            ],
            [
                "FLAG_INVOKE",
                "int"
            ],
            [
                "FLAG_CREATE",
                "int"
            ],
            [
                "FLAG_BRANCH_TRUE",
                "int"
            ],
            [
                "FLAG_BRANCH_FALSE",
                "int"
            ]
        ],
        "ConstantInstruction": [],
        "ConvertInstruction": [],
        "DiscontinuedInstruction": [],
        "ExceptionCatch": [],
        "FieldInstruction": [],
        "IncrementInstruction": [],
        "InvokeDynamicInstruction": [],
        "InvokeInstruction": [],
        "LabelTarget": [],
        "LineNumber": [],
        "LoadInstruction": [],
        "LocalVariable": [],
        "LocalVariableType": [],
        "LookupSwitchInstruction": [],
        "MonitorInstruction": [],
        "NewMultiArrayInstruction": [],
        "NewObjectInstruction": [],
        "NewPrimitiveArrayInstruction": [],
        "NewReferenceArrayInstruction": [],
        "NopInstruction": [],
        "OperatorInstruction": [],
        "ReturnInstruction": [],
        "StackInstruction": [],
        "StoreInstruction": [],
        "SwitchCase": [],
        "TableSwitchInstruction": [],
        "ThrowInstruction": [],
        "TypeCheckInstruction": []
    },
    "java.lang.constant": {
        "AsTypeMethodHandleDesc": [
            [
                "underlying",
                "java.lang.constant.MethodHandleDesc"
            ],
            [
                "type",
                "java.lang.constant.MethodTypeDesc"
            ]
        ],
        "ClassDesc": [],
        "Constable": [],
        "ConstantDesc": [],
        "ConstantDescs": [
            [
                "DEFAULT_NAME",
                "java.lang.String"
            ],
            [
                "CD_Object",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_String",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Class",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Number",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Integer",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Long",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Float",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Double",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Short",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Byte",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Character",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Boolean",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Void",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Throwable",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Exception",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Enum",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_VarHandle",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandles",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandles_Lookup",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandle",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodType",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_CallSite",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Collection",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_List",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Set",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Map",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ConstantDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ClassDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_EnumDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodTypeDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandleDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_DirectMethodHandleDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_VarHandleDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandleDesc_Kind",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_DynamicConstantDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_DynamicCallSiteDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ConstantBootstraps",
                "java.lang.constant.ClassDesc"
            ],
            [
                "INDY_BOOTSTRAP_ARGS",
                "java.lang.constant.ClassDesc[]"
            ],
            [
                "CONDY_BOOTSTRAP_ARGS",
                "java.lang.constant.ClassDesc[]"
            ],
            [
                "BSM_PRIMITIVE_CLASS",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_ENUM_CONSTANT",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_GET_STATIC_FINAL",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_NULL_CONSTANT",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_VARHANDLE_FIELD",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_VARHANDLE_STATIC_FIELD",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_VARHANDLE_ARRAY",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_INVOKE",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_EXPLICIT_CAST",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "CD_int",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_long",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_float",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_double",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_short",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_byte",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_char",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_boolean",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_void",
                "java.lang.constant.ClassDesc"
            ],
            [
                "BSM_CLASS_DATA",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "BSM_CLASS_DATA_AT",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "NULL",
                "java.lang.constant.ConstantDesc"
            ],
            [
                "TRUE",
                "java.lang.constant.DynamicConstantDesc<java.lang.Boolean>"
            ],
            [
                "FALSE",
                "java.lang.constant.DynamicConstantDesc<java.lang.Boolean>"
            ],
            [
                "INIT_NAME",
                "java.lang.String"
            ],
            [
                "CLASS_INIT_NAME",
                "java.lang.String"
            ],
            [
                "MTD_void",
                "java.lang.constant.MethodTypeDesc"
            ]
        ],
        "DirectMethodHandleDesc": [],
        "DynamicCallSiteDesc": [
            [
                "bootstrapMethod",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "bootstrapArgs",
                "java.lang.constant.ConstantDesc[]"
            ],
            [
                "invocationName",
                "java.lang.String"
            ],
            [
                "invocationType",
                "java.lang.constant.MethodTypeDesc"
            ]
        ],
        "DynamicConstantDesc": [
            [
                "bootstrapMethod",
                "java.lang.constant.DirectMethodHandleDesc"
            ],
            [
                "bootstrapArgs",
                "java.lang.constant.ConstantDesc[]"
            ],
            [
                "constantName",
                "java.lang.String"
            ],
            [
                "constantType",
                "java.lang.constant.ClassDesc"
            ]
        ],
        "MethodHandleDesc": [],
        "MethodTypeDesc": [],
        "ModuleDesc": [],
        "PackageDesc": []
    },
    "java.lang.foreign": {
        "AddressLayout": [],
        "Arena": [],
        "FunctionDescriptor": [],
        "GroupLayout": [],
        "Linker": [],
        "MemoryLayout": [],
        "MemorySegment": [
            [
                "NULL",
                "java.lang.foreign.MemorySegment"
            ]
        ],
        "PaddingLayout": [],
        "SegmentAllocator": [],
        "SequenceLayout": [],
        "StructLayout": [],
        "SymbolLookup": [],
        "UnionLayout": [],
        "ValueLayout": [
            [
                "ADDRESS",
                "java.lang.foreign.AddressLayout"
            ],
            [
                "JAVA_BYTE",
                "java.lang.foreign.ValueLayout$OfByte"
            ],
            [
                "JAVA_BOOLEAN",
                "java.lang.foreign.ValueLayout$OfBoolean"
            ],
            [
                "JAVA_CHAR",
                "java.lang.foreign.ValueLayout$OfChar"
            ],
            [
                "JAVA_SHORT",
                "java.lang.foreign.ValueLayout$OfShort"
            ],
            [
                "JAVA_INT",
                "java.lang.foreign.ValueLayout$OfInt"
            ],
            [
                "JAVA_LONG",
                "java.lang.foreign.ValueLayout$OfLong"
            ],
            [
                "JAVA_FLOAT",
                "java.lang.foreign.ValueLayout$OfFloat"
            ],
            [
                "JAVA_DOUBLE",
                "java.lang.foreign.ValueLayout$OfDouble"
            ],
            [
                "ADDRESS_UNALIGNED",
                "java.lang.foreign.AddressLayout"
            ],
            [
                "JAVA_CHAR_UNALIGNED",
                "java.lang.foreign.ValueLayout$OfChar"
            ],
            [
                "JAVA_SHORT_UNALIGNED",
                "java.lang.foreign.ValueLayout$OfShort"
            ],
            [
                "JAVA_INT_UNALIGNED",
                "java.lang.foreign.ValueLayout$OfInt"
            ],
            [
                "JAVA_LONG_UNALIGNED",
                "java.lang.foreign.ValueLayout$OfLong"
            ],
            [
                "JAVA_FLOAT_UNALIGNED",
                "java.lang.foreign.ValueLayout$OfFloat"
            ],
            [
                "JAVA_DOUBLE_UNALIGNED",
                "java.lang.foreign.ValueLayout$OfDouble"
            ]
        ]
    },
    "java.lang.invoke": {
        "AbstractConstantGroup": [
            [
                "size",
                "int"
            ]
        ],
        "AbstractValidatingLambdaMetafactory": [],
        "BootstrapCallInfo": [],
        "BootstrapMethodInvoker": [
            [
                "LMF_INDY_MT",
                "java.lang.invoke.MethodType"
            ],
            [
                "LMF_ALT_MT",
                "java.lang.invoke.MethodType"
            ],
            [
                "OBJECT_METHODS_MT",
                "java.lang.invoke.MethodType"
            ],
            [
                "SCF_MT",
                "java.lang.invoke.MethodType"
            ]
        ],
        "BoundMethodHandle": [
            [
                "FIELD_COUNT_THRESHOLD",
                "int"
            ],
            [
                "FORM_EXPRESSION_THRESHOLD",
                "int"
            ]
        ],
        "CallSite": [
            [
                "GET_TARGET",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "THROW_UCS",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "TARGET_OFFSET",
                "long"
            ]
        ],
        "ClassSpecializer": [
            [
                "CD_LambdaForm",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_BoundMethodHandle",
                "java.lang.constant.ClassDesc"
            ],
            [
                "STABLE_ANNOTATION",
                "java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute"
            ],
            [
                "topClass",
                "java.lang.Class<T>"
            ],
            [
                "keyType",
                "java.lang.Class<K>"
            ],
            [
                "metaType",
                "java.lang.Class<S>"
            ],
            [
                "sdAccessor",
                "java.lang.invoke.MemberName"
            ],
            [
                "sdFieldName",
                "java.lang.String"
            ],
            [
                "transformMethods",
                "java.util.List<java.lang.invoke.MemberName>"
            ],
            [
                "baseConstructorType",
                "java.lang.invoke.MethodType"
            ],
            [
                "topSpecies",
                "S"
            ],
            [
                "cache",
                "java.lang.Object>"
            ],
            [
                "factory",
                "S>.Factory"
            ],
            [
                "topClassIsSuper",
                "boolean"
            ],
            [
                "CREATE_RESERVATION",
                "java.lang.Object>"
            ]
        ],
        "ConstantBootstraps": [],
        "ConstantCallSite": [
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "isFrozen",
                "boolean"
            ]
        ],
        "ConstantGroup": [],
        "DelegatingMethodHandle": [],
        "DirectMethodHandle": [
            [
                "IMPL_NAMES",
                "java.lang.invoke.MemberName$Factory"
            ],
            [
                "ACCESSOR_FORMS",
                "java.lang.invoke.LambdaForm[]"
            ],
            [
                "ALL_WRAPPERS",
                "sun.invoke.util.Wrapper[]"
            ],
            [
                "NFS",
                "java.lang.invoke.LambdaForm$NamedFunction[]"
            ],
            [
                "OBJ_OBJ_TYPE",
                "java.lang.invoke.MethodType"
            ],
            [
                "LONG_OBJ_TYPE",
                "java.lang.invoke.MethodType"
            ]
        ],
        "GenerateJLIClassesHelper": [],
        "IndirectVarHandle": [
            [
                "directTarget",
                "java.lang.invoke.VarHandle"
            ],
            [
                "target",
                "java.lang.invoke.VarHandle"
            ],
            [
                "handleFactory",
                "java.lang.invoke.MethodHandle>"
            ],
            [
                "value",
                "java.lang.Class<?>"
            ],
            [
                "coordinates",
                "java.lang.Class<?>[]"
            ]
        ],
        "InfoFromMemberName": [
            [
                "member",
                "java.lang.invoke.MemberName"
            ],
            [
                "referenceKind",
                "int"
            ]
        ],
        "InjectedProfile": [],
        "InnerClassLambdaMetafactory": [
            [
                "LAMBDA_INSTANCE_FIELD",
                "java.lang.String"
            ],
            [
                "ARG_NAME_CACHE",
                "java.lang.String[]"
            ],
            [
                "EMPTY_CLASSDESC_ARRAY",
                "java.lang.constant.ClassDesc[]"
            ],
            [
                "lambdaProxyClassFileDumper",
                "jdk.internal.util.ClassFileDumper"
            ],
            [
                "disableEagerInitialization",
                "boolean"
            ],
            [
                "implMethodClassDesc",
                "java.lang.constant.ClassDesc"
            ],
            [
                "implMethodName",
                "java.lang.String"
            ],
            [
                "implMethodDesc",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "constructorType",
                "java.lang.invoke.MethodType"
            ],
            [
                "constructorTypeDesc",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "argDescs",
                "java.lang.constant.ClassDesc[]"
            ],
            [
                "lambdaClassName",
                "java.lang.String"
            ],
            [
                "pool",
                "java.lang.classfile.constantpool.ConstantPoolBuilder"
            ],
            [
                "lambdaClassEntry",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "useImplMethodHandle",
                "boolean"
            ]
        ],
        "InvokeDynamic": [],
        "InvokerBytecodeGenerator": [
            [
                "CD_CasesHolder",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_DirectMethodHandle",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MemberName",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandleImpl",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_LambdaForm",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_LambdaForm_Name",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_LoopClauses",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Object_array",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandle_array",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MethodHandle_array2",
                "java.lang.constant.ClassDesc"
            ],
            [
                "MTD_boolean_Object",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Object_int",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Object_Class",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Object_Object",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "CLASS_PREFIX",
                "java.lang.String"
            ],
            [
                "SOURCE_PREFIX",
                "java.lang.String"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "className",
                "java.lang.String"
            ],
            [
                "pool",
                "java.lang.classfile.constantpool.ConstantPoolBuilder"
            ],
            [
                "classEntry",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "lambdaForm",
                "java.lang.invoke.LambdaForm"
            ],
            [
                "invokerName",
                "java.lang.String"
            ],
            [
                "invokerType",
                "java.lang.invoke.MethodType"
            ],
            [
                "localsMap",
                "int[]"
            ],
            [
                "localClasses",
                "java.lang.Class<?>[]"
            ],
            [
                "classData",
                "java.util.List<java.lang.invoke.InvokerBytecodeGenerator$ClassData>"
            ],
            [
                "MEMBERNAME_FACTORY",
                "java.lang.invoke.MemberName$Factory"
            ],
            [
                "HOST_CLASS",
                "java.lang.Class<?>"
            ],
            [
                "LOOKUP",
                "java.lang.invoke.MethodHandles$Lookup"
            ],
            [
                "DUMP_CLASS_FILES_COUNTERS",
                "java.lang.Integer>"
            ],
            [
                "LF_DONTINLINE_ANNOTATIONS",
                "java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute"
            ],
            [
                "LF_DONTINLINE_PROFILE_ANNOTATIONS",
                "java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute"
            ],
            [
                "LF_FORCEINLINE_ANNOTATIONS",
                "java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute"
            ],
            [
                "LF_FORCEINLINE_PROFILE_ANNOTATIONS",
                "java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute"
            ],
            [
                "STATICALLY_INVOCABLE_PACKAGES",
                "java.lang.Class<?>[]"
            ]
        ],
        "Invokers": [
            [
                "targetType",
                "java.lang.invoke.MethodType"
            ],
            [
                "invokers",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "MH_LINKER_ARG_APPENDED",
                "int"
            ],
            [
                "NF_checkExactType",
                "byte"
            ],
            [
                "NF_checkGenericType",
                "byte"
            ],
            [
                "NF_getCallSiteTarget",
                "byte"
            ],
            [
                "NF_checkCustomized",
                "byte"
            ],
            [
                "NF_checkVarHandleGenericType",
                "byte"
            ],
            [
                "NF_checkVarHandleExactType",
                "byte"
            ],
            [
                "NF_directVarHandleTarget",
                "byte"
            ],
            [
                "NF_LIMIT",
                "byte"
            ],
            [
                "NFS",
                "java.lang.invoke.LambdaForm$NamedFunction[]"
            ]
        ],
        "LambdaConversionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LambdaForm": [
            [
                "isCompiled",
                "boolean"
            ],
            [
                "VOID_RESULT",
                "int"
            ],
            [
                "LAST_RESULT",
                "int"
            ],
            [
                "DEFAULT_RESULT",
                "int"
            ],
            [
                "DEFAULT_FORCE_INLINE",
                "boolean"
            ],
            [
                "DEFAULT_CUSTOMIZED",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "DEFAULT_KIND",
                "java.lang.invoke.LambdaForm$Kind"
            ],
            [
                "LF_FAILED",
                "jdk.internal.perf.PerfCounter"
            ],
            [
                "COMPILE_THRESHOLD",
                "int"
            ],
            [
                "invocationCounter",
                "int"
            ],
            [
                "INTERNED_ARGUMENTS",
                "java.lang.invoke.LambdaForm$Name[][]"
            ],
            [
                "IMPL_NAMES",
                "java.lang.invoke.MemberName$Factory"
            ],
            [
                "LF_identity",
                "java.lang.invoke.LambdaForm[]"
            ],
            [
                "LF_zero",
                "java.lang.invoke.LambdaForm[]"
            ],
            [
                "NF_identity",
                "java.lang.invoke.LambdaForm$NamedFunction[]"
            ],
            [
                "NF_zero",
                "java.lang.invoke.LambdaForm$NamedFunction[]"
            ],
            [
                "createFormsLock",
                "java.lang.Object"
            ],
            [
                "DEBUG_NAME_COUNTERS",
                "java.lang.Integer>"
            ],
            [
                "DEBUG_NAMES",
                "java.lang.String>"
            ],
            [
                "TRACE_INTERPRETER",
                "boolean"
            ]
        ],
        "LambdaFormBuffer": [
            [
                "arity",
                "int"
            ],
            [
                "length",
                "int"
            ],
            [
                "names",
                "java.lang.invoke.LambdaForm$Name[]"
            ],
            [
                "originalNames",
                "java.lang.invoke.LambdaForm$Name[]"
            ],
            [
                "flags",
                "byte"
            ],
            [
                "firstChange",
                "int"
            ],
            [
                "resultName",
                "java.lang.invoke.LambdaForm$Name"
            ],
            [
                "dups",
                "java.util.ArrayList<java.lang.invoke.LambdaForm$Name>"
            ],
            [
                "F_TRANS",
                "int"
            ],
            [
                "F_OWNED",
                "int"
            ]
        ],
        "LambdaFormEditor": [
            [
                "BIND_ARG",
                "byte"
            ],
            [
                "ADD_ARG",
                "byte"
            ],
            [
                "DUP_ARG",
                "byte"
            ],
            [
                "SPREAD_ARGS",
                "byte"
            ],
            [
                "FILTER_ARG",
                "byte"
            ],
            [
                "FILTER_RETURN",
                "byte"
            ],
            [
                "COLLECT_ARGS",
                "byte"
            ],
            [
                "COLLECT_ARGS_TO_VOID",
                "byte"
            ],
            [
                "REPEAT_FILTER_ARGS",
                "byte"
            ],
            [
                "FOLD_ARGS",
                "byte"
            ],
            [
                "FOLD_ARGS_TO_VOID",
                "byte"
            ],
            [
                "PERMUTE_ARGS",
                "byte"
            ],
            [
                "LOCAL_TYPES",
                "byte"
            ],
            [
                "FILTER_SELECT_ARGS",
                "byte"
            ],
            [
                "FOLD_SELECT_ARGS",
                "byte"
            ],
            [
                "MIN_CACHE_ARRAY_SIZE",
                "int"
            ],
            [
                "MAX_CACHE_ARRAY_SIZE",
                "int"
            ]
        ],
        "LambdaMetafactory": [
            [
                "FLAG_SERIALIZABLE",
                "int"
            ],
            [
                "FLAG_MARKERS",
                "int"
            ],
            [
                "FLAG_BRIDGES",
                "int"
            ],
            [
                "EMPTY_CLASS_ARRAY",
                "java.lang.Class<?>[]"
            ],
            [
                "EMPTY_MT_ARRAY",
                "java.lang.invoke.MethodType[]"
            ]
        ],
        "LambdaProxyClassArchive": [],
        "LazyInitializingVarHandle": [
            [
                "target",
                "java.lang.invoke.VarHandle"
            ],
            [
                "refc",
                "java.lang.Class<?>"
            ],
            [
                "initialized",
                "boolean"
            ],
            [
                "MH_ensureInitialized",
                "java.lang.invoke.MethodHandle"
            ]
        ],
        "MemberName": [
            [
                "clazz",
                "java.lang.Class<?>"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Object"
            ],
            [
                "flags",
                "int"
            ],
            [
                "method",
                "java.lang.invoke.ResolvedMethodName"
            ],
            [
                "MH_INVOKE_MODS",
                "int"
            ]
        ],
        "MethodHandle": [
            [
                "type",
                "java.lang.invoke.MethodType"
            ],
            [
                "asTypeCache",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "asTypeSoftCache",
                "java.lang.ref.SoftReference<java.lang.invoke.MethodHandle>"
            ],
            [
                "customizationCount",
                "byte"
            ],
            [
                "updateInProgress",
                "boolean"
            ],
            [
                "FORM_OFFSET",
                "long"
            ],
            [
                "UPDATE_OFFSET",
                "long"
            ]
        ],
        "MethodHandleImpl": [
            [
                "ARRAYS",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "NFS",
                "java.lang.invoke.LambdaForm$NamedFunction[]"
            ],
            [
                "HANDLES",
                "java.lang.invoke.MethodHandle[]"
            ]
        ],
        "MethodHandleInfo": [
            [
                "REF_getField",
                "int"
            ],
            [
                "REF_getStatic",
                "int"
            ],
            [
                "REF_putField",
                "int"
            ],
            [
                "REF_putStatic",
                "int"
            ],
            [
                "REF_invokeVirtual",
                "int"
            ],
            [
                "REF_invokeStatic",
                "int"
            ],
            [
                "REF_invokeSpecial",
                "int"
            ],
            [
                "REF_newInvokeSpecial",
                "int"
            ],
            [
                "REF_invokeInterface",
                "int"
            ]
        ],
        "MethodHandleNatives": [],
        "MethodHandleProxies": [
            [
                "DUMPER",
                "jdk.internal.util.ClassFileDumper"
            ],
            [
                "WRAPPER_TYPES",
                "java.util.Set<java.lang.Class<?>>"
            ],
            [
                "PROXIES",
                "java.lang.ClassValue<java.lang.invoke.MethodHandleProxies$WeakReferenceHolder<java.lang.Class<?>>>"
            ],
            [
                "DEFAULT_RETHROWS",
                "java.util.List<java.lang.constant.ClassDesc>"
            ],
            [
                "CD_UndeclaredThrowableException",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_IllegalAccessException",
                "java.lang.constant.ClassDesc"
            ],
            [
                "MTD_void_Throwable",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MT_void_Lookup_MethodHandle_MethodHandle",
                "java.lang.invoke.MethodType"
            ],
            [
                "MT_Object_Lookup_MethodHandle_MethodHandle",
                "java.lang.invoke.MethodType"
            ],
            [
                "MT_MethodHandle_Object",
                "java.lang.invoke.MethodType"
            ],
            [
                "MTD_void_Lookup_MethodHandle_MethodHandle",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_void_Lookup",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_MethodHandle_MethodType",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Class",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_int",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_String",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_void_String",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "TARGET_NAME",
                "java.lang.String"
            ],
            [
                "TYPE_NAME",
                "java.lang.String"
            ],
            [
                "ENSURE_ORIGINAL_LOOKUP",
                "java.lang.String"
            ],
            [
                "JLRA",
                "jdk.internal.access.JavaLangReflectAccess"
            ],
            [
                "counter",
                "java.util.concurrent.atomic.AtomicInteger"
            ]
        ],
        "MethodHandleStatics": [],
        "MethodHandles": [
            [
                "IDENTITY_MHS",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "ZERO_MHS",
                "java.lang.invoke.MethodHandle[]"
            ]
        ],
        "MethodType": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "rtype",
                "java.lang.Class<?>"
            ],
            [
                "ptypes",
                "java.lang.Class<?>[]"
            ],
            [
                "form",
                "java.lang.invoke.MethodTypeForm"
            ],
            [
                "wrapAlt",
                "java.lang.Object"
            ],
            [
                "invokers",
                "java.lang.invoke.Invokers"
            ],
            [
                "methodDescriptor",
                "java.lang.String"
            ],
            [
                "objectOnlyTypes",
                "java.lang.invoke.MethodType[]"
            ],
            [
                "archivedMethodTypes",
                "java.lang.invoke.MethodType>"
            ],
            [
                "METHOD_HANDLE_ARRAY",
                "java.lang.Class<?>[]"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "MethodTypeForm": [
            [
                "methodHandles",
                "java.lang.Object[]"
            ],
            [
                "lambdaForms",
                "java.lang.Object[]"
            ],
            [
                "ERASE",
                "int"
            ],
            [
                "WRAP",
                "int"
            ],
            [
                "UNWRAP",
                "int"
            ]
        ],
        "MutableCallSite": [],
        "NativeMethodHandle": [
            [
                "IMPL_NAMES",
                "java.lang.invoke.MemberName$Factory"
            ]
        ],
        "ResolvedMethodName": [
            [
                "vmholder",
                "java.lang.Class<?>"
            ]
        ],
        "SerializedLambda": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "capturingClass",
                "java.lang.Class<?>"
            ],
            [
                "functionalInterfaceClass",
                "java.lang.String"
            ],
            [
                "functionalInterfaceMethodName",
                "java.lang.String"
            ],
            [
                "functionalInterfaceMethodSignature",
                "java.lang.String"
            ],
            [
                "implClass",
                "java.lang.String"
            ],
            [
                "implMethodName",
                "java.lang.String"
            ],
            [
                "implMethodSignature",
                "java.lang.String"
            ],
            [
                "implMethodKind",
                "int"
            ],
            [
                "instantiatedMethodType",
                "java.lang.String"
            ],
            [
                "capturedArgs",
                "java.lang.Object[]"
            ]
        ],
        "SimpleMethodHandle": [],
        "StringConcatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StringConcatFactory": [
            [
                "HIGH_ARITY_THRESHOLD",
                "int"
            ],
            [
                "CACHE_THRESHOLD",
                "int"
            ],
            [
                "FORCE_INLINE_THRESHOLD",
                "int"
            ],
            [
                "TAG_ARG",
                "char"
            ],
            [
                "TAG_CONST",
                "char"
            ],
            [
                "MAX_INDY_CONCAT_ARG_SLOTS",
                "int"
            ],
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "INT_IDX",
                "int"
            ],
            [
                "CHAR_IDX",
                "int"
            ],
            [
                "LONG_IDX",
                "int"
            ],
            [
                "BOOLEAN_IDX",
                "int"
            ],
            [
                "STRING_IDX",
                "int"
            ],
            [
                "TYPE_COUNT",
                "int"
            ],
            [
                "PREPEND_FILTER_FIRST_ARGS",
                "int[]"
            ],
            [
                "PREPEND_FILTER_SECOND_ARGS",
                "int[]"
            ],
            [
                "PREPEND_FILTER_THIRD_ARGS",
                "int[]"
            ],
            [
                "PREPEND_FILTER_FIRST_PAIR_ARGS",
                "int[]"
            ],
            [
                "PREPEND_FILTER_SECOND_PAIR_ARGS",
                "int[]"
            ],
            [
                "PREPEND_BASE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "DOUBLE_PREPENDERS",
                "java.lang.invoke.MethodHandle[][]"
            ],
            [
                "MIX_FILTER_SECOND_ARGS",
                "int[]"
            ],
            [
                "MIX_FILTER_THIRD_ARGS",
                "int[]"
            ],
            [
                "MIX_FILTER_SECOND_PAIR_ARGS",
                "int[]"
            ],
            [
                "DOUBLE_MIXERS",
                "java.lang.invoke.MethodHandle[][]"
            ],
            [
                "SIMPLE_CONCAT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "NEW_STRING",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "NEW_ARRAY_SUFFIX",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "OBJECT_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "FLOAT_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "DOUBLE_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "INT_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "LONG_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "CHAR_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "BOOLEAN_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "NEW_STRINGIFIER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "NO_PREFIX_PREPENDERS",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "PREPENDERS",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "MIXERS",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "INITIAL_CODER",
                "long"
            ]
        ],
        "SwitchPoint": [
            [
                "K_true",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "K_false",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "mcs",
                "java.lang.invoke.MutableCallSite"
            ],
            [
                "mcsInvoker",
                "java.lang.invoke.MethodHandle"
            ]
        ],
        "TypeConvertingMethodAdapter": [],
        "TypeDescriptor": [],
        "VarForm": [],
        "VarHandle": [
            [
                "VFORM_OFFSET",
                "long"
            ]
        ],
        "VarHandleBooleans": [],
        "VarHandleByteArrayAsChars": [],
        "VarHandleByteArrayAsDoubles": [],
        "VarHandleByteArrayAsFloats": [],
        "VarHandleByteArrayAsInts": [],
        "VarHandleByteArrayAsLongs": [],
        "VarHandleByteArrayAsShorts": [],
        "VarHandleByteArrayBase": [],
        "VarHandleBytes": [],
        "VarHandleChars": [],
        "VarHandleDoubles": [],
        "VarHandleFloats": [],
        "VarHandleGuards": [],
        "VarHandleInts": [],
        "VarHandleLongs": [],
        "VarHandleReferences": [],
        "VarHandleSegmentAsBytes": [],
        "VarHandleSegmentAsChars": [],
        "VarHandleSegmentAsDoubles": [],
        "VarHandleSegmentAsFloats": [],
        "VarHandleSegmentAsInts": [],
        "VarHandleSegmentAsLongs": [],
        "VarHandleSegmentAsShorts": [],
        "VarHandleSegmentViewBase": [],
        "VarHandleShorts": [],
        "VarHandles": [],
        "VolatileCallSite": [],
        "WrongMethodTypeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "java.lang.module": {
        "Configuration": [
            [
                "EMPTY_CONFIGURATION",
                "java.lang.module.Configuration"
            ],
            [
                "parents",
                "java.util.List<java.lang.module.Configuration>"
            ],
            [
                "graph",
                "java.util.Set<java.lang.module.ResolvedModule>>"
            ],
            [
                "modules",
                "java.util.Set<java.lang.module.ResolvedModule>"
            ],
            [
                "nameToModule",
                "java.lang.module.ResolvedModule>"
            ],
            [
                "targetPlatform",
                "java.lang.String"
            ],
            [
                "allConfigurations",
                "java.util.List<java.lang.module.Configuration>"
            ]
        ],
        "FindException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvalidModuleDescriptorException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ModuleDescriptor": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "version",
                "java.lang.module.ModuleDescriptor$Version"
            ],
            [
                "rawVersionString",
                "java.lang.String"
            ],
            [
                "modifiers",
                "java.util.Set<java.lang.module.ModuleDescriptor$Modifier>"
            ],
            [
                "open",
                "boolean"
            ],
            [
                "automatic",
                "boolean"
            ],
            [
                "requires",
                "java.util.Set<java.lang.module.ModuleDescriptor$Requires>"
            ],
            [
                "exports",
                "java.util.Set<java.lang.module.ModuleDescriptor$Exports>"
            ],
            [
                "opens",
                "java.util.Set<java.lang.module.ModuleDescriptor$Opens>"
            ],
            [
                "uses",
                "java.util.Set<java.lang.String>"
            ],
            [
                "provides",
                "java.util.Set<java.lang.module.ModuleDescriptor$Provides>"
            ],
            [
                "packages",
                "java.util.Set<java.lang.String>"
            ],
            [
                "mainClass",
                "java.lang.String"
            ],
            [
                "hash",
                "int"
            ]
        ],
        "ModuleFinder": [],
        "ModuleReader": [],
        "ModuleReference": [
            [
                "descriptor",
                "java.lang.module.ModuleDescriptor"
            ],
            [
                "location",
                "java.net.URI"
            ]
        ],
        "ResolutionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ResolvedModule": [
            [
                "cf",
                "java.lang.module.Configuration"
            ],
            [
                "mref",
                "java.lang.module.ModuleReference"
            ]
        ],
        "Resolver": [
            [
                "beforeFinder",
                "java.lang.module.ModuleFinder"
            ],
            [
                "parents",
                "java.util.List<java.lang.module.Configuration>"
            ],
            [
                "afterFinder",
                "java.lang.module.ModuleFinder"
            ],
            [
                "traceOutput",
                "java.io.PrintStream"
            ],
            [
                "nameToReference",
                "java.lang.module.ModuleReference>"
            ],
            [
                "haveAllAutomaticModules",
                "boolean"
            ],
            [
                "targetPlatform",
                "java.lang.String"
            ],
            [
                "visited",
                "java.util.Set<java.lang.module.ModuleDescriptor>"
            ],
            [
                "visitPath",
                "java.util.Set<java.lang.module.ModuleDescriptor>"
            ]
        ]
    },
    "java.lang.ref": {
        "Cleaner": [],
        "FinalReference": [],
        "Finalizer": [
            [
                "queue",
                "java.lang.ref.ReferenceQueue<java.lang.Object>"
            ],
            [
                "unfinalized",
                "java.lang.ref.Finalizer"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "next",
                "java.lang.ref.Finalizer"
            ],
            [
                "prev",
                "java.lang.ref.Finalizer"
            ]
        ],
        "FinalizerHistogram": [],
        "PhantomReference": [],
        "Reference": [
            [
                "referent",
                "T"
            ],
            [
                "discovered",
                "java.lang.ref.Reference<?>"
            ],
            [
                "processPendingLock",
                "java.lang.Object"
            ],
            [
                "processPendingActive",
                "boolean"
            ]
        ],
        "ReferenceQueue": [
            [
                "head",
                "T>"
            ],
            [
                "queueLength",
                "long"
            ],
            [
                "lock",
                "java.lang.ref.ReferenceQueue$Lock"
            ]
        ],
        "SoftReference": [
            [
                "clock",
                "long"
            ],
            [
                "timestamp",
                "long"
            ]
        ],
        "WeakReference": []
    },
    "java.lang.reflect": {
        "AccessFlag": [
            [
                "PUBLIC",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "PRIVATE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "PROTECTED",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "STATIC",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "FINAL",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "SUPER",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "OPEN",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "TRANSITIVE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "SYNCHRONIZED",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "STATIC_PHASE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "VOLATILE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "BRIDGE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "TRANSIENT",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "VARARGS",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "NATIVE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "INTERFACE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "ABSTRACT",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "STRICT",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "SYNTHETIC",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "ANNOTATION",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "ENUM",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "MANDATED",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "MODULE",
                "java.lang.reflect.AccessFlag"
            ],
            [
                "mask",
                "int"
            ],
            [
                "sourceModifier",
                "boolean"
            ],
            [
                "locations",
                "java.util.Set<java.lang.reflect.AccessFlag$Location>"
            ],
            [
                "cffvToLocations",
                "java.util.Set<java.lang.reflect.AccessFlag$Location>>"
            ],
            [
                "$VALUES",
                "java.lang.reflect.AccessFlag[]"
            ]
        ],
        "AccessibleObject": [
            [
                "printStackWhenAccessFails",
                "boolean"
            ],
            [
                "printStackPropertiesSet",
                "boolean"
            ]
        ],
        "AnnotatedArrayType": [],
        "AnnotatedElement": [],
        "AnnotatedParameterizedType": [],
        "AnnotatedType": [],
        "AnnotatedTypeVariable": [],
        "AnnotatedWildcardType": [],
        "Array": [],
        "ClassFileFormatVersion": [
            [
                "RELEASE_0",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_1",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_2",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_3",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_4",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_5",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_6",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_7",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_8",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_9",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_10",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_11",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_12",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_13",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_14",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_15",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_16",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_17",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_18",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_19",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_20",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_21",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_22",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_23",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "RELEASE_24",
                "java.lang.reflect.ClassFileFormatVersion"
            ],
            [
                "major",
                "int"
            ],
            [
                "$VALUES",
                "java.lang.reflect.ClassFileFormatVersion[]"
            ]
        ],
        "Constructor": [
            [
                "clazz",
                "java.lang.Class<T>"
            ],
            [
                "slot",
                "int"
            ],
            [
                "parameterTypes",
                "java.lang.Class<?>[]"
            ],
            [
                "exceptionTypes",
                "java.lang.Class<?>[]"
            ],
            [
                "modifiers",
                "int"
            ],
            [
                "signature",
                "java.lang.String"
            ],
            [
                "annotations",
                "byte[]"
            ],
            [
                "parameterAnnotations",
                "byte[]"
            ],
            [
                "root",
                "java.lang.reflect.Constructor<T>"
            ],
            [
                "genericInfo",
                "sun.reflect.generics.repository.ConstructorRepository"
            ],
            [
                "constructorAccessor",
                "jdk.internal.reflect.ConstructorAccessor"
            ]
        ],
        "Executable": [
            [
                "parameterData",
                "java.lang.reflect.Executable$ParameterData"
            ],
            [
                "declaredAnnotations",
                "java.lang.annotation.Annotation>"
            ]
        ],
        "Field": [
            [
                "clazz",
                "java.lang.Class<?>"
            ],
            [
                "slot",
                "int"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Class<?>"
            ],
            [
                "modifiers",
                "int"
            ],
            [
                "trustedFinal",
                "boolean"
            ],
            [
                "signature",
                "java.lang.String"
            ],
            [
                "annotations",
                "byte[]"
            ],
            [
                "root",
                "java.lang.reflect.Field"
            ],
            [
                "genericInfo",
                "sun.reflect.generics.repository.FieldRepository"
            ],
            [
                "fieldAccessor",
                "jdk.internal.reflect.FieldAccessor"
            ],
            [
                "overrideFieldAccessor",
                "jdk.internal.reflect.FieldAccessor"
            ],
            [
                "declaredAnnotations",
                "java.lang.annotation.Annotation>"
            ]
        ],
        "GenericArrayType": [],
        "GenericDeclaration": [],
        "GenericSignatureFormatError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InaccessibleObjectException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvocationHandler": [],
        "InvocationTargetException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "target",
                "java.lang.Throwable"
            ]
        ],
        "MalformedParameterizedTypeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MalformedParametersException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Member": [
            [
                "PUBLIC",
                "int"
            ],
            [
                "DECLARED",
                "int"
            ]
        ],
        "Method": [
            [
                "clazz",
                "java.lang.Class<?>"
            ],
            [
                "slot",
                "int"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "returnType",
                "java.lang.Class<?>"
            ],
            [
                "parameterTypes",
                "java.lang.Class<?>[]"
            ],
            [
                "exceptionTypes",
                "java.lang.Class<?>[]"
            ],
            [
                "modifiers",
                "int"
            ],
            [
                "signature",
                "java.lang.String"
            ],
            [
                "annotations",
                "byte[]"
            ],
            [
                "parameterAnnotations",
                "byte[]"
            ],
            [
                "annotationDefault",
                "byte[]"
            ],
            [
                "root",
                "java.lang.reflect.Method"
            ],
            [
                "genericInfo",
                "sun.reflect.generics.repository.MethodRepository"
            ],
            [
                "methodAccessor",
                "jdk.internal.reflect.MethodAccessor"
            ],
            [
                "hash",
                "int"
            ],
            [
                "callerSensitive",
                "byte"
            ]
        ],
        "Modifier": [
            [
                "PUBLIC",
                "int"
            ],
            [
                "PRIVATE",
                "int"
            ],
            [
                "PROTECTED",
                "int"
            ],
            [
                "STATIC",
                "int"
            ],
            [
                "FINAL",
                "int"
            ],
            [
                "SYNCHRONIZED",
                "int"
            ],
            [
                "VOLATILE",
                "int"
            ],
            [
                "TRANSIENT",
                "int"
            ],
            [
                "NATIVE",
                "int"
            ],
            [
                "INTERFACE",
                "int"
            ],
            [
                "ABSTRACT",
                "int"
            ],
            [
                "STRICT",
                "int"
            ],
            [
                "CLASS_MODIFIERS",
                "int"
            ],
            [
                "INTERFACE_MODIFIERS",
                "int"
            ],
            [
                "CONSTRUCTOR_MODIFIERS",
                "int"
            ],
            [
                "METHOD_MODIFIERS",
                "int"
            ],
            [
                "FIELD_MODIFIERS",
                "int"
            ],
            [
                "PARAMETER_MODIFIERS",
                "int"
            ]
        ],
        "Parameter": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "modifiers",
                "int"
            ],
            [
                "executable",
                "java.lang.reflect.Executable"
            ],
            [
                "index",
                "int"
            ],
            [
                "parameterTypeCache",
                "java.lang.reflect.Type"
            ],
            [
                "parameterClassCache",
                "java.lang.Class<?>"
            ],
            [
                "declaredAnnotations",
                "java.lang.annotation.Annotation>"
            ]
        ],
        "ParameterizedType": [],
        "Proxy": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "constructorParams",
                "java.lang.Class<?>[]"
            ],
            [
                "proxyCache",
                "jdk.internal.loader.ClassLoaderValue<java.lang.reflect.Constructor<?>>"
            ],
            [
                "h",
                "java.lang.reflect.InvocationHandler"
            ],
            [
                "PROXY_PACKAGE_PREFIX",
                "java.lang.String"
            ],
            [
                "DEFAULT_METHODS_MAP",
                "java.lang.invoke.MethodHandle>>"
            ]
        ],
        "ProxyGenerator": [
            [
                "CF_CONTEXT",
                "java.lang.classfile.ClassFile"
            ],
            [
                "CD_ClassLoader",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Class_array",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ClassNotFoundException",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_NoClassDefFoundError",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_IllegalAccessException",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_InvocationHandler",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Method",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_NoSuchMethodError",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_NoSuchMethodException",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Object_array",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Proxy",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_UndeclaredThrowableException",
                "java.lang.constant.ClassDesc"
            ],
            [
                "MTD_boolean",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_void_InvocationHandler",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_void_String",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_void_Throwable",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Class",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Class_String_boolean_ClassLoader",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_ClassLoader",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Method_String_Class_array",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_MethodHandles$Lookup",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_MethodHandles$Lookup_MethodHandles$Lookup",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_Object_Object_Method_ObjectArray",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_String",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "NAME_LOOKUP_ACCESSOR",
                "java.lang.String"
            ],
            [
                "EMPTY_CLASS_ARRAY",
                "java.lang.Class<?>[]"
            ],
            [
                "NAME_HANDLER_FIELD",
                "java.lang.String"
            ],
            [
                "SAVE_GENERATED_FILES",
                "boolean"
            ],
            [
                "OBJECT_HASH_CODE_METHOD",
                "java.lang.reflect.Method"
            ],
            [
                "OBJECT_EQUALS_METHOD",
                "java.lang.reflect.Method"
            ],
            [
                "OBJECT_TO_STRING_METHOD",
                "java.lang.reflect.Method"
            ],
            [
                "OBJECT_HASH_CODE_SIG",
                "java.lang.String"
            ],
            [
                "OBJECT_EQUALS_SIG",
                "java.lang.String"
            ],
            [
                "OBJECT_TO_STRING_SIG",
                "java.lang.String"
            ],
            [
                "cp",
                "java.lang.classfile.constantpool.ConstantPoolBuilder"
            ],
            [
                "classLoaderLocal",
                "java.util.List<java.lang.classfile.attribute.StackMapFrameInfo$VerificationTypeInfo>"
            ],
            [
                "throwableStack",
                "java.util.List<java.lang.classfile.attribute.StackMapFrameInfo$VerificationTypeInfo>"
            ],
            [
                "exInit",
                "java.lang.classfile.constantpool.NameAndTypeEntry"
            ],
            [
                "objectCE",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "proxyCE",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "uteCE",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "classCE",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "handlerField",
                "java.lang.classfile.constantpool.FieldRefEntry"
            ],
            [
                "invocationHandlerInvoke",
                "java.lang.classfile.constantpool.InterfaceMethodRefEntry"
            ],
            [
                "uteInit",
                "java.lang.classfile.constantpool.MethodRefEntry"
            ],
            [
                "classGetMethod",
                "java.lang.classfile.constantpool.MethodRefEntry"
            ],
            [
                "classForName",
                "java.lang.classfile.constantpool.MethodRefEntry"
            ],
            [
                "throwableGetMessage",
                "java.lang.classfile.constantpool.MethodRefEntry"
            ],
            [
                "thisClassCE",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "interfaces",
                "java.util.List<java.lang.Class<?>>"
            ],
            [
                "accessFlags",
                "int"
            ],
            [
                "proxyMethods",
                "java.util.List<java.lang.reflect.ProxyGenerator$ProxyMethod>>"
            ],
            [
                "proxyMethodCount",
                "int"
            ]
        ],
        "RecordComponent": [
            [
                "clazz",
                "java.lang.Class<?>"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Class<?>"
            ],
            [
                "accessor",
                "java.lang.reflect.Method"
            ],
            [
                "signature",
                "java.lang.String"
            ],
            [
                "genericInfo",
                "sun.reflect.generics.repository.FieldRepository"
            ],
            [
                "annotations",
                "byte[]"
            ],
            [
                "typeAnnotations",
                "byte[]"
            ],
            [
                "root",
                "java.lang.reflect.RecordComponent"
            ],
            [
                "declaredAnnotations",
                "java.lang.annotation.Annotation>"
            ]
        ],
        "ReflectAccess": [],
        "ReflectPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Type": [],
        "TypeVariable": [],
        "UndeclaredThrowableException": [
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "WildcardType": []
    },
    "java.lang.runtime": {
        "Carriers": [
            [
                "MAX_COMPONENTS",
                "int"
            ],
            [
                "FLOAT_TO_INT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "INT_TO_FLOAT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "DOUBLE_TO_LONG",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "LONG_TO_DOUBLE",
                "java.lang.invoke.MethodHandle"
            ]
        ],
        "ExactConversionsSupport": [],
        "ObjectMethods": [
            [
                "MAX_STRING_CONCAT_SLOTS",
                "int"
            ],
            [
                "FALSE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "TRUE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "ZERO",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "CLASS_IS_INSTANCE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "OBJECTS_EQUALS",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "OBJECTS_HASHCODE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "OBJECTS_TOSTRING",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "OBJECT_EQ",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "HASH_COMBINER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "primitiveEquals",
                "java.lang.invoke.MethodHandle>"
            ],
            [
                "primitiveHashers",
                "java.lang.invoke.MethodHandle>"
            ],
            [
                "primitiveToString",
                "java.lang.invoke.MethodHandle>"
            ]
        ],
        "SwitchBootstraps": [
            [
                "SENTINEL",
                "java.lang.Object"
            ],
            [
                "LOOKUP",
                "java.lang.invoke.MethodHandles$Lookup"
            ],
            [
                "previewEnabled",
                "boolean"
            ],
            [
                "CD_BiPredicate",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Objects",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CHECK_INDEX_DESCRIPTOR",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_TYPE_SWITCH",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_TYPE_SWITCH_EXTRA",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MT_TYPE_SWITCH_EXTRA",
                "java.lang.invoke.MethodType"
            ],
            [
                "MT_TYPE_SWITCH",
                "java.lang.invoke.MethodType"
            ]
        ]
    },
    "java.math": {
        "BigDecimal": [
            [
                "L",
                "double"
            ],
            [
                "P_F",
                "int"
            ],
            [
                "Q_MIN_F",
                "int"
            ],
            [
                "Q_MAX_F",
                "int"
            ],
            [
                "P_D",
                "int"
            ],
            [
                "Q_MIN_D",
                "int"
            ],
            [
                "Q_MAX_D",
                "int"
            ],
            [
                "intVal",
                "java.math.BigInteger"
            ],
            [
                "scale",
                "int"
            ],
            [
                "precision",
                "int"
            ],
            [
                "stringCache",
                "java.lang.String"
            ],
            [
                "INFLATED_BIGINT",
                "java.math.BigInteger"
            ],
            [
                "intCompact",
                "long"
            ],
            [
                "MAX_COMPACT_DIGITS",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "ZERO_THROUGH_TEN",
                "java.math.BigDecimal[]"
            ],
            [
                "ZERO_SCALED_BY",
                "java.math.BigDecimal[]"
            ],
            [
                "HALF_LONG_MAX_VALUE",
                "long"
            ],
            [
                "HALF_LONG_MIN_VALUE",
                "long"
            ],
            [
                "ZERO",
                "java.math.BigDecimal"
            ],
            [
                "ONE",
                "java.math.BigDecimal"
            ],
            [
                "TWO",
                "java.math.BigDecimal"
            ],
            [
                "TEN",
                "java.math.BigDecimal"
            ],
            [
                "ONE_TENTH",
                "java.math.BigDecimal"
            ],
            [
                "ONE_HALF",
                "java.math.BigDecimal"
            ],
            [
                "ROUND_UP",
                "int"
            ],
            [
                "ROUND_DOWN",
                "int"
            ],
            [
                "ROUND_CEILING",
                "int"
            ],
            [
                "ROUND_FLOOR",
                "int"
            ],
            [
                "ROUND_HALF_UP",
                "int"
            ],
            [
                "ROUND_HALF_DOWN",
                "int"
            ],
            [
                "ROUND_HALF_EVEN",
                "int"
            ],
            [
                "ROUND_UNNECESSARY",
                "int"
            ],
            [
                "DOUBLE_10_POW",
                "double[]"
            ],
            [
                "FLOAT_10_POW",
                "float[]"
            ],
            [
                "LONG_TEN_POWERS_TABLE",
                "long[]"
            ],
            [
                "BIG_TEN_POWERS_TABLE",
                "java.math.BigInteger[]"
            ],
            [
                "BIG_TEN_POWERS_TABLE_INITLEN",
                "int"
            ],
            [
                "BIG_TEN_POWERS_TABLE_MAX",
                "int"
            ],
            [
                "THRESHOLDS_TABLE",
                "long[]"
            ],
            [
                "FIVE_TO_2_TO",
                "java.math.BigInteger[]"
            ],
            [
                "LOG_5_OF_2",
                "double"
            ],
            [
                "DIV_NUM_BASE",
                "long"
            ],
            [
                "LONGLONG_TEN_POWERS_TABLE",
                "long[][]"
            ]
        ],
        "BigInteger": [
            [
                "bitCountPlusOne",
                "int"
            ],
            [
                "bitLengthPlusOne",
                "int"
            ],
            [
                "lowestSetBitPlusTwo",
                "int"
            ],
            [
                "firstNonzeroIntNumPlusTwo",
                "int"
            ],
            [
                "MAX_MAG_LENGTH",
                "int"
            ],
            [
                "PRIME_SEARCH_BIT_LENGTH_LIMIT",
                "int"
            ],
            [
                "KARATSUBA_THRESHOLD",
                "int"
            ],
            [
                "TOOM_COOK_THRESHOLD",
                "int"
            ],
            [
                "KARATSUBA_SQUARE_THRESHOLD",
                "int"
            ],
            [
                "TOOM_COOK_SQUARE_THRESHOLD",
                "int"
            ],
            [
                "SCHOENHAGE_BASE_CONVERSION_THRESHOLD",
                "int"
            ],
            [
                "MULTIPLY_SQUARE_THRESHOLD",
                "int"
            ],
            [
                "MONTGOMERY_INTRINSIC_THRESHOLD",
                "int"
            ],
            [
                "bitsPerDigit",
                "long[]"
            ],
            [
                "SMALL_PRIME_THRESHOLD",
                "int"
            ],
            [
                "DEFAULT_PRIME_CERTAINTY",
                "int"
            ],
            [
                "SMALL_PRIME_PRODUCT",
                "java.math.BigInteger"
            ],
            [
                "MAX_CONSTANT",
                "int"
            ],
            [
                "posConst",
                "java.math.BigInteger[]"
            ],
            [
                "negConst",
                "java.math.BigInteger[]"
            ],
            [
                "powerCache",
                "java.math.BigInteger[][]"
            ],
            [
                "logCache",
                "double[]"
            ],
            [
                "LOG_TWO",
                "double"
            ],
            [
                "ZERO",
                "java.math.BigInteger"
            ],
            [
                "ONE",
                "java.math.BigInteger"
            ],
            [
                "TWO",
                "java.math.BigInteger"
            ],
            [
                "NEGATIVE_ONE",
                "java.math.BigInteger"
            ],
            [
                "TEN",
                "java.math.BigInteger"
            ],
            [
                "NUM_ZEROS",
                "int"
            ],
            [
                "ZEROS",
                "java.lang.String"
            ],
            [
                "digitsPerLong",
                "int[]"
            ],
            [
                "longRadix",
                "java.math.BigInteger[]"
            ],
            [
                "digitsPerInt",
                "int[]"
            ],
            [
                "intRadix",
                "int[]"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "BitSieve": [
            [
                "bits",
                "long[]"
            ],
            [
                "length",
                "int"
            ],
            [
                "smallSieve",
                "java.math.BitSieve"
            ]
        ],
        "MathContext": [
            [
                "DEFAULT_ROUNDINGMODE",
                "java.math.RoundingMode"
            ],
            [
                "MIN_DIGITS",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "UNLIMITED",
                "java.math.MathContext"
            ],
            [
                "DECIMAL32",
                "java.math.MathContext"
            ],
            [
                "DECIMAL64",
                "java.math.MathContext"
            ],
            [
                "DECIMAL128",
                "java.math.MathContext"
            ]
        ],
        "MutableBigInteger": [],
        "RoundingMode": [
            [
                "UP",
                "java.math.RoundingMode"
            ],
            [
                "DOWN",
                "java.math.RoundingMode"
            ],
            [
                "CEILING",
                "java.math.RoundingMode"
            ],
            [
                "FLOOR",
                "java.math.RoundingMode"
            ],
            [
                "HALF_UP",
                "java.math.RoundingMode"
            ],
            [
                "HALF_DOWN",
                "java.math.RoundingMode"
            ],
            [
                "HALF_EVEN",
                "java.math.RoundingMode"
            ],
            [
                "UNNECESSARY",
                "java.math.RoundingMode"
            ],
            [
                "$VALUES",
                "java.math.RoundingMode[]"
            ]
        ],
        "SignedMutableBigInteger": []
    },
    "java.net": {
        "Authenticator": [
            [
                "theAuthenticator",
                "java.net.Authenticator"
            ],
            [
                "requestingHost",
                "java.lang.String"
            ],
            [
                "requestingSite",
                "java.net.InetAddress"
            ],
            [
                "requestingPort",
                "int"
            ],
            [
                "requestingProtocol",
                "java.lang.String"
            ],
            [
                "requestingPrompt",
                "java.lang.String"
            ],
            [
                "requestingScheme",
                "java.lang.String"
            ],
            [
                "requestingURL",
                "java.net.URL"
            ],
            [
                "requestingAuthType",
                "java.net.Authenticator$RequestorType"
            ]
        ],
        "BindException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CacheRequest": [],
        "CacheResponse": [],
        "ConnectException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ContentHandler": [],
        "ContentHandlerFactory": [],
        "CookieHandler": [
            [
                "cookieHandler",
                "java.net.CookieHandler"
            ]
        ],
        "CookieManager": [
            [
                "policyCallback",
                "java.net.CookiePolicy"
            ],
            [
                "cookieJar",
                "java.net.CookieStore"
            ]
        ],
        "CookiePolicy": [
            [
                "ACCEPT_ALL",
                "java.net.CookiePolicy"
            ],
            [
                "ACCEPT_NONE",
                "java.net.CookiePolicy"
            ],
            [
                "ACCEPT_ORIGINAL_SERVER",
                "java.net.CookiePolicy"
            ]
        ],
        "CookieStore": [],
        "DatagramPacket": [],
        "DatagramSocket": [
            [
                "delegate",
                "java.net.DatagramSocket"
            ],
            [
                "factory",
                "java.net.DatagramSocketImplFactory"
            ],
            [
                "NO_DELEGATE",
                "java.net.SocketAddress"
            ]
        ],
        "DatagramSocketImpl": [
            [
                "localPort",
                "int"
            ],
            [
                "fd",
                "java.io.FileDescriptor"
            ]
        ],
        "DatagramSocketImplFactory": [],
        "DefaultInterface": [
            [
                "defaultInterface",
                "java.net.NetworkInterface"
            ]
        ],
        "DelegatingSocketImpl": [
            [
                "delegate",
                "java.net.SocketImpl"
            ]
        ],
        "FileNameMap": [],
        "HostPortrange": [],
        "HttpConnectSocketImpl": [
            [
                "httpURLClazzStr",
                "java.lang.String"
            ],
            [
                "netClientClazzStr",
                "java.lang.String"
            ],
            [
                "doTunnelingStr",
                "java.lang.String"
            ],
            [
                "httpField",
                "java.lang.reflect.Field"
            ],
            [
                "serverSocketField",
                "java.lang.reflect.Field"
            ],
            [
                "doTunneling",
                "java.lang.reflect.Method"
            ],
            [
                "server",
                "java.lang.String"
            ],
            [
                "socket",
                "java.net.Socket"
            ],
            [
                "external_address",
                "java.net.InetSocketAddress"
            ],
            [
                "optionsMap",
                "java.lang.Object>"
            ]
        ],
        "HttpCookie": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ],
            [
                "comment",
                "java.lang.String"
            ],
            [
                "commentURL",
                "java.lang.String"
            ],
            [
                "toDiscard",
                "boolean"
            ],
            [
                "domain",
                "java.lang.String"
            ],
            [
                "maxAge",
                "long"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "portlist",
                "java.lang.String"
            ],
            [
                "secure",
                "boolean"
            ],
            [
                "httpOnly",
                "boolean"
            ],
            [
                "version",
                "int"
            ],
            [
                "header",
                "java.lang.String"
            ],
            [
                "whenCreated",
                "long"
            ],
            [
                "MAX_AGE_UNSPECIFIED",
                "long"
            ],
            [
                "COOKIE_DATE_FORMATS",
                "java.lang.String[]"
            ],
            [
                "SET_COOKIE",
                "java.lang.String"
            ],
            [
                "SET_COOKIE2",
                "java.lang.String"
            ],
            [
                "tspecials",
                "java.lang.String"
            ]
        ],
        "HttpRetryException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "responseCode",
                "int"
            ],
            [
                "location",
                "java.lang.String"
            ]
        ],
        "HttpURLConnection": [
            [
                "method",
                "java.lang.String"
            ],
            [
                "chunkLength",
                "int"
            ],
            [
                "fixedContentLength",
                "int"
            ],
            [
                "fixedContentLengthLong",
                "long"
            ],
            [
                "DEFAULT_CHUNK_SIZE",
                "int"
            ],
            [
                "responseCode",
                "int"
            ],
            [
                "responseMessage",
                "java.lang.String"
            ],
            [
                "followRedirects",
                "boolean"
            ],
            [
                "instanceFollowRedirects",
                "boolean"
            ],
            [
                "methods",
                "java.lang.String[]"
            ],
            [
                "HTTP_OK",
                "int"
            ],
            [
                "HTTP_CREATED",
                "int"
            ],
            [
                "HTTP_ACCEPTED",
                "int"
            ],
            [
                "HTTP_NOT_AUTHORITATIVE",
                "int"
            ],
            [
                "HTTP_NO_CONTENT",
                "int"
            ],
            [
                "HTTP_RESET",
                "int"
            ],
            [
                "HTTP_PARTIAL",
                "int"
            ],
            [
                "HTTP_MULT_CHOICE",
                "int"
            ],
            [
                "HTTP_MOVED_PERM",
                "int"
            ],
            [
                "HTTP_MOVED_TEMP",
                "int"
            ],
            [
                "HTTP_SEE_OTHER",
                "int"
            ],
            [
                "HTTP_NOT_MODIFIED",
                "int"
            ],
            [
                "HTTP_USE_PROXY",
                "int"
            ],
            [
                "HTTP_BAD_REQUEST",
                "int"
            ],
            [
                "HTTP_UNAUTHORIZED",
                "int"
            ],
            [
                "HTTP_PAYMENT_REQUIRED",
                "int"
            ],
            [
                "HTTP_FORBIDDEN",
                "int"
            ],
            [
                "HTTP_NOT_FOUND",
                "int"
            ],
            [
                "HTTP_BAD_METHOD",
                "int"
            ],
            [
                "HTTP_NOT_ACCEPTABLE",
                "int"
            ],
            [
                "HTTP_PROXY_AUTH",
                "int"
            ],
            [
                "HTTP_CLIENT_TIMEOUT",
                "int"
            ],
            [
                "HTTP_CONFLICT",
                "int"
            ],
            [
                "HTTP_GONE",
                "int"
            ],
            [
                "HTTP_LENGTH_REQUIRED",
                "int"
            ],
            [
                "HTTP_PRECON_FAILED",
                "int"
            ],
            [
                "HTTP_ENTITY_TOO_LARGE",
                "int"
            ],
            [
                "HTTP_REQ_TOO_LONG",
                "int"
            ],
            [
                "HTTP_UNSUPPORTED_TYPE",
                "int"
            ],
            [
                "HTTP_SERVER_ERROR",
                "int"
            ],
            [
                "HTTP_INTERNAL_ERROR",
                "int"
            ],
            [
                "HTTP_NOT_IMPLEMENTED",
                "int"
            ],
            [
                "HTTP_BAD_GATEWAY",
                "int"
            ],
            [
                "HTTP_UNAVAILABLE",
                "int"
            ],
            [
                "HTTP_GATEWAY_TIMEOUT",
                "int"
            ],
            [
                "HTTP_VERSION",
                "int"
            ]
        ],
        "IDN": [
            [
                "ALLOW_UNASSIGNED",
                "int"
            ],
            [
                "USE_STD3_ASCII_RULES",
                "int"
            ],
            [
                "ACE_PREFIX",
                "java.lang.String"
            ],
            [
                "ACE_PREFIX_LENGTH",
                "int"
            ],
            [
                "MAX_LABEL_LENGTH",
                "int"
            ],
            [
                "namePrep",
                "jdk.internal.icu.text.StringPrep"
            ]
        ],
        "InMemoryCookieStore": [
            [
                "cookieJar",
                "java.util.List<java.net.HttpCookie>"
            ],
            [
                "domainIndex",
                "java.util.List<java.net.HttpCookie>>"
            ],
            [
                "uriIndex",
                "java.util.List<java.net.HttpCookie>>"
            ],
            [
                "lock",
                "java.util.concurrent.locks.ReentrantLock"
            ]
        ],
        "Inet4Address": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Inet4AddressImpl": [
            [
                "anyLocalAddress",
                "java.net.InetAddress"
            ],
            [
                "loopbackAddress",
                "java.net.InetAddress"
            ]
        ],
        "Inet6Address": [
            [
                "holder6",
                "java.net.Inet6Address$Inet6AddressHolder"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "FIELDS_OFFSET",
                "long"
            ],
            [
                "INT16SZ",
                "int"
            ]
        ],
        "Inet6AddressImpl": [
            [
                "anyLocalAddress",
                "java.net.InetAddress"
            ],
            [
                "loopbackAddress",
                "java.net.InetAddress"
            ]
        ],
        "InetAddress": [
            [
                "resolver",
                "java.net.spi.InetAddressResolver"
            ],
            [
                "BUILTIN_RESOLVER",
                "java.net.spi.InetAddressResolver"
            ],
            [
                "canonicalHostName",
                "java.lang.String"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "PREFER_IPV4_STACK_VALUE",
                "java.lang.String"
            ],
            [
                "PREFER_IPV6_ADDRESSES_VALUE",
                "java.lang.String"
            ],
            [
                "HOSTS_FILE_NAME",
                "java.lang.String"
            ],
            [
                "RESOLVER_LOCK",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "bootstrapResolver",
                "java.net.spi.InetAddressResolver"
            ],
            [
                "cache",
                "java.net.InetAddress$Addresses>"
            ],
            [
                "expirySet",
                "java.util.NavigableSet<java.net.InetAddress$CachedLookup>"
            ],
            [
                "cachedLocalHost",
                "java.net.InetAddress$CachedLocalHost"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "FIELDS_OFFSET",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "InetAddressImpl": [],
        "InetSocketAddress": [
            [
                "holder",
                "java.net.InetSocketAddress$InetSocketAddressHolder"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "FIELDS_OFFSET",
                "long"
            ]
        ],
        "InterfaceAddress": [
            [
                "address",
                "java.net.InetAddress"
            ],
            [
                "broadcast",
                "java.net.Inet4Address"
            ],
            [
                "maskLength",
                "short"
            ]
        ],
        "JarURLConnection": [
            [
                "jarFileURL",
                "java.net.URL"
            ],
            [
                "entryName",
                "java.lang.String"
            ],
            [
                "jarFileURLConnection",
                "java.net.URLConnection"
            ]
        ],
        "MalformedURLException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MulticastSocket": [],
        "NetMulticastSocket": [
            [
                "bound",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "created",
                "boolean"
            ],
            [
                "closeLock",
                "java.lang.Object"
            ],
            [
                "impl",
                "java.net.DatagramSocketImpl"
            ],
            [
                "explicitFilter",
                "boolean"
            ],
            [
                "bytesLeftToFilter",
                "int"
            ],
            [
                "options",
                "java.util.Set<java.net.SocketOption<?>>"
            ],
            [
                "optionsLock",
                "java.lang.Object"
            ],
            [
                "interfaceSet",
                "boolean"
            ],
            [
                "ttlLock",
                "java.lang.Object"
            ],
            [
                "infLock",
                "java.lang.Object"
            ],
            [
                "infAddress",
                "java.net.InetAddress"
            ]
        ],
        "NetPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NetworkInterface": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "displayName",
                "java.lang.String"
            ],
            [
                "index",
                "int"
            ],
            [
                "addrs",
                "java.net.InetAddress[]"
            ],
            [
                "bindings",
                "java.net.InterfaceAddress[]"
            ],
            [
                "childs",
                "java.net.NetworkInterface[]"
            ],
            [
                "parent",
                "java.net.NetworkInterface"
            ],
            [
                "virtual",
                "boolean"
            ],
            [
                "defaultInterface",
                "java.net.NetworkInterface"
            ]
        ],
        "NoRouteToHostException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PasswordAuthentication": [
            [
                "userName",
                "java.lang.String"
            ],
            [
                "password",
                "char[]"
            ]
        ],
        "PortUnreachableException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ProtocolException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ProtocolFamily": [],
        "Proxy": [
            [
                "type",
                "java.net.Proxy$Type"
            ],
            [
                "sa",
                "java.net.SocketAddress"
            ],
            [
                "NO_PROXY",
                "java.net.Proxy"
            ]
        ],
        "ProxySelector": [
            [
                "theProxySelector",
                "java.net.ProxySelector"
            ]
        ],
        "ResponseCache": [
            [
                "theResponseCache",
                "java.net.ResponseCache"
            ]
        ],
        "SecureCacheResponse": [],
        "ServerSocket": [
            [
                "impl",
                "java.net.SocketImpl"
            ],
            [
                "created",
                "boolean"
            ],
            [
                "bound",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "socketLock",
                "java.lang.Object"
            ],
            [
                "factory",
                "java.net.SocketImplFactory"
            ],
            [
                "options",
                "java.util.Set<java.net.SocketOption<?>>"
            ]
        ],
        "Socket": [
            [
                "STATE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "IN",
                "java.lang.invoke.VarHandle"
            ],
            [
                "OUT",
                "java.lang.invoke.VarHandle"
            ],
            [
                "impl",
                "java.net.SocketImpl"
            ],
            [
                "SOCKET_CREATED",
                "int"
            ],
            [
                "BOUND",
                "int"
            ],
            [
                "CONNECTED",
                "int"
            ],
            [
                "CLOSED",
                "int"
            ],
            [
                "SHUT_IN",
                "int"
            ],
            [
                "SHUT_OUT",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "socketLock",
                "java.lang.Object"
            ],
            [
                "in",
                "java.io.InputStream"
            ],
            [
                "out",
                "java.io.OutputStream"
            ],
            [
                "factory",
                "java.net.SocketImplFactory"
            ],
            [
                "options",
                "java.util.Set<java.net.SocketOption<?>>"
            ]
        ],
        "SocketAddress": [],
        "SocketException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SocketImpl": [
            [
                "fd",
                "java.io.FileDescriptor"
            ],
            [
                "address",
                "java.net.InetAddress"
            ],
            [
                "port",
                "int"
            ],
            [
                "localport",
                "int"
            ]
        ],
        "SocketImplFactory": [],
        "SocketOption": [],
        "SocketOptions": [
            [
                "TCP_NODELAY",
                "int"
            ],
            [
                "SO_BINDADDR",
                "int"
            ],
            [
                "SO_REUSEADDR",
                "int"
            ],
            [
                "SO_REUSEPORT",
                "int"
            ],
            [
                "SO_BROADCAST",
                "int"
            ],
            [
                "IP_MULTICAST_IF",
                "int"
            ],
            [
                "IP_MULTICAST_IF2",
                "int"
            ],
            [
                "IP_MULTICAST_LOOP",
                "int"
            ],
            [
                "IP_TOS",
                "int"
            ],
            [
                "SO_LINGER",
                "int"
            ],
            [
                "SO_TIMEOUT",
                "int"
            ],
            [
                "SO_SNDBUF",
                "int"
            ],
            [
                "SO_RCVBUF",
                "int"
            ],
            [
                "SO_KEEPALIVE",
                "int"
            ],
            [
                "SO_OOBINLINE",
                "int"
            ]
        ],
        "SocketPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "CONNECT",
                "int"
            ],
            [
                "LISTEN",
                "int"
            ],
            [
                "ACCEPT",
                "int"
            ],
            [
                "RESOLVE",
                "int"
            ],
            [
                "NONE",
                "int"
            ],
            [
                "ALL",
                "int"
            ],
            [
                "PORT_MIN",
                "int"
            ],
            [
                "PORT_MAX",
                "int"
            ],
            [
                "mask",
                "int"
            ],
            [
                "actions",
                "java.lang.String"
            ],
            [
                "hostname",
                "java.lang.String"
            ],
            [
                "cname",
                "java.lang.String"
            ],
            [
                "addresses",
                "java.net.InetAddress[]"
            ],
            [
                "wildcard",
                "boolean"
            ],
            [
                "init_with_ip",
                "boolean"
            ],
            [
                "invalid",
                "boolean"
            ],
            [
                "portrange",
                "int[]"
            ],
            [
                "defaultDeny",
                "boolean"
            ],
            [
                "untrusted",
                "boolean"
            ],
            [
                "trusted",
                "boolean"
            ],
            [
                "trustNameService",
                "boolean"
            ],
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "debugInit",
                "boolean"
            ],
            [
                "cdomain",
                "java.lang.String"
            ],
            [
                "hdomain",
                "java.lang.String"
            ]
        ],
        "SocketPermissionCollection": [
            [
                "perms",
                "java.net.SocketPermission>"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "SocketTimeoutException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SocksConsts": [
            [
                "PROTO_VERS4",
                "int"
            ],
            [
                "PROTO_VERS",
                "int"
            ],
            [
                "DEFAULT_PORT",
                "int"
            ],
            [
                "NO_AUTH",
                "int"
            ],
            [
                "GSSAPI",
                "int"
            ],
            [
                "USER_PASSW",
                "int"
            ],
            [
                "NO_METHODS",
                "int"
            ],
            [
                "CONNECT",
                "int"
            ],
            [
                "BIND",
                "int"
            ],
            [
                "UDP_ASSOC",
                "int"
            ],
            [
                "IPV4",
                "int"
            ],
            [
                "DOMAIN_NAME",
                "int"
            ],
            [
                "IPV6",
                "int"
            ],
            [
                "REQUEST_OK",
                "int"
            ],
            [
                "GENERAL_FAILURE",
                "int"
            ],
            [
                "NOT_ALLOWED",
                "int"
            ],
            [
                "NET_UNREACHABLE",
                "int"
            ],
            [
                "HOST_UNREACHABLE",
                "int"
            ],
            [
                "CONN_REFUSED",
                "int"
            ],
            [
                "TTL_EXPIRED",
                "int"
            ],
            [
                "CMD_NOT_SUPPORTED",
                "int"
            ],
            [
                "ADDR_TYPE_NOT_SUP",
                "int"
            ]
        ],
        "SocksSocketImpl": [
            [
                "server",
                "java.lang.String"
            ],
            [
                "serverPort",
                "int"
            ],
            [
                "external_address",
                "java.net.InetSocketAddress"
            ],
            [
                "useV4",
                "boolean"
            ],
            [
                "cmdsock",
                "java.net.Socket"
            ],
            [
                "cmdIn",
                "java.io.InputStream"
            ],
            [
                "cmdOut",
                "java.io.OutputStream"
            ]
        ],
        "StandardProtocolFamily": [
            [
                "INET",
                "java.net.StandardProtocolFamily"
            ],
            [
                "INET6",
                "java.net.StandardProtocolFamily"
            ],
            [
                "UNIX",
                "java.net.StandardProtocolFamily"
            ],
            [
                "$VALUES",
                "java.net.StandardProtocolFamily[]"
            ]
        ],
        "StandardSocketOptions": [
            [
                "SO_BROADCAST",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "SO_KEEPALIVE",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "SO_SNDBUF",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "SO_RCVBUF",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "SO_REUSEADDR",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "SO_REUSEPORT",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "SO_LINGER",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "IP_TOS",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "IP_MULTICAST_IF",
                "java.net.SocketOption<java.net.NetworkInterface>"
            ],
            [
                "IP_MULTICAST_TTL",
                "java.net.SocketOption<java.lang.Integer>"
            ],
            [
                "IP_MULTICAST_LOOP",
                "java.net.SocketOption<java.lang.Boolean>"
            ],
            [
                "TCP_NODELAY",
                "java.net.SocketOption<java.lang.Boolean>"
            ]
        ],
        "URI": [
            [
                "scheme",
                "java.lang.String"
            ],
            [
                "fragment",
                "java.lang.String"
            ],
            [
                "authority",
                "java.lang.String"
            ],
            [
                "userInfo",
                "java.lang.String"
            ],
            [
                "host",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "query",
                "java.lang.String"
            ],
            [
                "schemeSpecificPart",
                "java.lang.String"
            ],
            [
                "hash",
                "int"
            ],
            [
                "decodedUserInfo",
                "java.lang.String"
            ],
            [
                "decodedAuthority",
                "java.lang.String"
            ],
            [
                "decodedPath",
                "java.lang.String"
            ],
            [
                "decodedQuery",
                "java.lang.String"
            ],
            [
                "decodedFragment",
                "java.lang.String"
            ],
            [
                "decodedSchemeSpecificPart",
                "java.lang.String"
            ],
            [
                "string",
                "java.lang.String"
            ],
            [
                "L_DIGIT",
                "long"
            ],
            [
                "H_DIGIT",
                "long"
            ],
            [
                "L_UPALPHA",
                "long"
            ],
            [
                "H_UPALPHA",
                "long"
            ],
            [
                "L_LOWALPHA",
                "long"
            ],
            [
                "H_LOWALPHA",
                "long"
            ],
            [
                "L_ALPHA",
                "long"
            ],
            [
                "H_ALPHA",
                "long"
            ],
            [
                "L_ALPHANUM",
                "long"
            ],
            [
                "H_ALPHANUM",
                "long"
            ],
            [
                "L_HEX",
                "long"
            ],
            [
                "H_HEX",
                "long"
            ],
            [
                "L_MARK",
                "long"
            ],
            [
                "H_MARK",
                "long"
            ],
            [
                "L_UNRESERVED",
                "long"
            ],
            [
                "H_UNRESERVED",
                "long"
            ],
            [
                "L_RESERVED",
                "long"
            ],
            [
                "H_RESERVED",
                "long"
            ],
            [
                "L_ESCAPED",
                "long"
            ],
            [
                "H_ESCAPED",
                "long"
            ],
            [
                "L_URIC",
                "long"
            ],
            [
                "H_URIC",
                "long"
            ],
            [
                "L_PCHAR",
                "long"
            ],
            [
                "H_PCHAR",
                "long"
            ],
            [
                "L_PATH",
                "long"
            ],
            [
                "H_PATH",
                "long"
            ],
            [
                "L_DASH",
                "long"
            ],
            [
                "H_DASH",
                "long"
            ],
            [
                "L_DOT",
                "long"
            ],
            [
                "H_DOT",
                "long"
            ],
            [
                "L_USERINFO",
                "long"
            ],
            [
                "H_USERINFO",
                "long"
            ],
            [
                "L_REG_NAME",
                "long"
            ],
            [
                "H_REG_NAME",
                "long"
            ],
            [
                "L_SERVER",
                "long"
            ],
            [
                "H_SERVER",
                "long"
            ],
            [
                "L_SERVER_PERCENT",
                "long"
            ],
            [
                "H_SERVER_PERCENT",
                "long"
            ],
            [
                "L_SCHEME",
                "long"
            ],
            [
                "H_SCHEME",
                "long"
            ],
            [
                "L_SCOPE_ID",
                "long"
            ],
            [
                "H_SCOPE_ID",
                "long"
            ],
            [
                "hexDigits",
                "char[]"
            ]
        ],
        "URISyntaxException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "input",
                "java.lang.String"
            ],
            [
                "index",
                "int"
            ]
        ],
        "URL": [
            [
                "protocolPathProp",
                "java.lang.String"
            ],
            [
                "protocol",
                "java.lang.String"
            ],
            [
                "host",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "file",
                "java.lang.String"
            ],
            [
                "query",
                "java.lang.String"
            ],
            [
                "authority",
                "java.lang.String"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "userInfo",
                "java.lang.String"
            ],
            [
                "ref",
                "java.lang.String"
            ],
            [
                "hostAddress",
                "java.net.InetAddress"
            ],
            [
                "hashCode",
                "int"
            ],
            [
                "tempState",
                "java.net.UrlDeserializedState"
            ],
            [
                "factory",
                "java.net.URLStreamHandlerFactory"
            ],
            [
                "defaultFactory",
                "java.net.URLStreamHandlerFactory"
            ],
            [
                "handlers",
                "java.net.URLStreamHandler>"
            ],
            [
                "streamHandlerLock",
                "java.lang.Object"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "URLClassLoader": [
            [
                "ucp",
                "jdk.internal.loader.URLClassPath"
            ],
            [
                "closeables",
                "java.lang.Void>"
            ]
        ],
        "URLConnection": [
            [
                "url",
                "java.net.URL"
            ],
            [
                "doInput",
                "boolean"
            ],
            [
                "doOutput",
                "boolean"
            ],
            [
                "defaultAllowUserInteraction",
                "boolean"
            ],
            [
                "allowUserInteraction",
                "boolean"
            ],
            [
                "defaultUseCaches",
                "boolean"
            ],
            [
                "useCaches",
                "boolean"
            ],
            [
                "defaultCaching",
                "java.lang.Boolean>"
            ],
            [
                "ifModifiedSince",
                "long"
            ],
            [
                "connected",
                "boolean"
            ],
            [
                "connectTimeout",
                "int"
            ],
            [
                "readTimeout",
                "int"
            ],
            [
                "requests",
                "sun.net.www.MessageHeader"
            ],
            [
                "fileNameMap",
                "java.net.FileNameMap"
            ],
            [
                "factory",
                "java.net.ContentHandlerFactory"
            ],
            [
                "handlers",
                "java.net.ContentHandler>"
            ],
            [
                "contentClassPrefix",
                "java.lang.String"
            ],
            [
                "contentPathProp",
                "java.lang.String"
            ]
        ],
        "URLDecoder": [],
        "URLEncoder": [
            [
                "DONT_NEED_ENCODING",
                "java.util.function.IntPredicate"
            ],
            [
                "ENCODING_CHUNK_SIZE",
                "int"
            ]
        ],
        "URLPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "scheme",
                "java.lang.String"
            ],
            [
                "ssp",
                "java.lang.String"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "methods",
                "java.util.List<java.lang.String>"
            ],
            [
                "requestHeaders",
                "java.util.List<java.lang.String>"
            ],
            [
                "authority",
                "java.net.URLPermission$Authority"
            ],
            [
                "actions",
                "java.lang.String"
            ]
        ],
        "URLStreamHandler": [],
        "URLStreamHandlerFactory": [],
        "UnixDomainSocketAddress": [
            [
                "path",
                "java.nio.file.Path"
            ]
        ],
        "UnknownContentHandler": [],
        "UnknownHostException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnknownServiceException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UrlDeserializedState": [
            [
                "protocol",
                "java.lang.String"
            ],
            [
                "host",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "authority",
                "java.lang.String"
            ],
            [
                "file",
                "java.lang.String"
            ],
            [
                "ref",
                "java.lang.String"
            ],
            [
                "hashCode",
                "int"
            ]
        ],
        "package-info": []
    },
    "java.net.spi": {
        "InetAddressResolver": [],
        "InetAddressResolverProvider": [],
        "URLStreamHandlerProvider": []
    },
    "java.nio": {
        "Bits": [
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "PAGE_SIZE",
                "int"
            ],
            [
                "UNALIGNED",
                "boolean"
            ],
            [
                "MAX_MEMORY",
                "long"
            ],
            [
                "RESERVED_MEMORY",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "TOTAL_CAPACITY",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "COUNT",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "MEMORY_LIMIT_SET",
                "boolean"
            ],
            [
                "MAX_SLEEPS",
                "int"
            ]
        ],
        "Buffer": [
            [
                "mark",
                "int"
            ],
            [
                "position",
                "int"
            ],
            [
                "limit",
                "int"
            ],
            [
                "capacity",
                "int"
            ],
            [
                "IOOBE_FORMATTER",
                "java.lang.IndexOutOfBoundsException>"
            ]
        ],
        "BufferMismatch": [],
        "BufferOverflowException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "BufferUnderflowException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ByteBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "ByteBufferAsCharBufferB": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsCharBufferL": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsCharBufferRB": [],
        "ByteBufferAsCharBufferRL": [],
        "ByteBufferAsDoubleBufferB": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsDoubleBufferL": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsDoubleBufferRB": [],
        "ByteBufferAsDoubleBufferRL": [],
        "ByteBufferAsFloatBufferB": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsFloatBufferL": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsFloatBufferRB": [],
        "ByteBufferAsFloatBufferRL": [],
        "ByteBufferAsIntBufferB": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsIntBufferL": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsIntBufferRB": [],
        "ByteBufferAsIntBufferRL": [],
        "ByteBufferAsLongBufferB": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsLongBufferL": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsLongBufferRB": [],
        "ByteBufferAsLongBufferRL": [],
        "ByteBufferAsShortBufferB": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsShortBufferL": [
            [
                "bb",
                "java.nio.ByteBuffer"
            ]
        ],
        "ByteBufferAsShortBufferRB": [],
        "ByteBufferAsShortBufferRL": [],
        "ByteOrder": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "BIG_ENDIAN",
                "java.nio.ByteOrder"
            ],
            [
                "LITTLE_ENDIAN",
                "java.nio.ByteOrder"
            ],
            [
                "NATIVE_ORDER",
                "java.nio.ByteOrder"
            ]
        ],
        "CharBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "CharBufferSpliterator": [
            [
                "buffer",
                "java.nio.CharBuffer"
            ],
            [
                "index",
                "int"
            ],
            [
                "limit",
                "int"
            ]
        ],
        "DirectByteBuffer": [
            [
                "att",
                "java.lang.Object"
            ],
            [
                "cleaner",
                "jdk.internal.ref.Cleaner"
            ]
        ],
        "DirectByteBufferR": [],
        "DirectCharBufferRS": [],
        "DirectCharBufferRU": [],
        "DirectCharBufferS": [
            [
                "att",
                "java.lang.Object"
            ],
            [
                "APPEND_BUF_SIZE",
                "int"
            ]
        ],
        "DirectCharBufferU": [
            [
                "att",
                "java.lang.Object"
            ],
            [
                "APPEND_BUF_SIZE",
                "int"
            ]
        ],
        "DirectDoubleBufferRS": [],
        "DirectDoubleBufferRU": [],
        "DirectDoubleBufferS": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectDoubleBufferU": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectFloatBufferRS": [],
        "DirectFloatBufferRU": [],
        "DirectFloatBufferS": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectFloatBufferU": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectIntBufferRS": [],
        "DirectIntBufferRU": [],
        "DirectIntBufferS": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectIntBufferU": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectLongBufferRS": [],
        "DirectLongBufferRU": [],
        "DirectLongBufferS": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectLongBufferU": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectShortBufferRS": [],
        "DirectShortBufferRU": [],
        "DirectShortBufferS": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DirectShortBufferU": [
            [
                "att",
                "java.lang.Object"
            ]
        ],
        "DoubleBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "FloatBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "HeapByteBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapByteBufferR": [],
        "HeapCharBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapCharBufferR": [],
        "HeapDoubleBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapDoubleBufferR": [],
        "HeapFloatBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapFloatBufferR": [],
        "HeapIntBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapIntBufferR": [],
        "HeapLongBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapLongBufferR": [],
        "HeapShortBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ],
            [
                "ARRAY_INDEX_SCALE",
                "long"
            ]
        ],
        "HeapShortBufferR": [],
        "IntBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "InvalidMarkException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LongBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "MappedByteBuffer": [
            [
                "fd",
                "java.io.FileDescriptor"
            ],
            [
                "isSync",
                "boolean"
            ]
        ],
        "MappedMemoryUtils": [
            [
                "unused",
                "byte"
            ]
        ],
        "ReadOnlyBufferException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ShortBuffer": [
            [
                "ARRAY_BASE_OFFSET",
                "long"
            ]
        ],
        "StringCharBuffer": []
    },
    "java.nio.channels": {
        "AcceptPendingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AlreadyBoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AlreadyConnectedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AsynchronousByteChannel": [],
        "AsynchronousChannel": [],
        "AsynchronousChannelGroup": [
            [
                "provider",
                "java.nio.channels.spi.AsynchronousChannelProvider"
            ]
        ],
        "AsynchronousCloseException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AsynchronousFileChannel": [
            [
                "NO_ATTRIBUTES",
                "java.nio.file.attribute.FileAttribute<?>[]"
            ]
        ],
        "AsynchronousServerSocketChannel": [
            [
                "provider",
                "java.nio.channels.spi.AsynchronousChannelProvider"
            ]
        ],
        "AsynchronousSocketChannel": [
            [
                "provider",
                "java.nio.channels.spi.AsynchronousChannelProvider"
            ]
        ],
        "ByteChannel": [],
        "CancelledKeyException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Channel": [],
        "Channels": [],
        "ClosedByInterruptException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ClosedChannelException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ClosedSelectorException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CompletionHandler": [],
        "ConnectionPendingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DatagramChannel": [],
        "FileChannel": [
            [
                "NO_ATTRIBUTES",
                "java.nio.file.attribute.FileAttribute<?>[]"
            ]
        ],
        "FileLock": [
            [
                "channel",
                "java.nio.channels.Channel"
            ],
            [
                "position",
                "long"
            ],
            [
                "size",
                "long"
            ],
            [
                "shared",
                "boolean"
            ]
        ],
        "FileLockInterruptionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "GatheringByteChannel": [],
        "IllegalBlockingModeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalChannelGroupException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalSelectorException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InterruptedByTimeoutException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InterruptibleChannel": [],
        "MembershipKey": [],
        "MulticastChannel": [],
        "NetworkChannel": [],
        "NoConnectionPendingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NonReadableChannelException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NonWritableChannelException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NotYetBoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NotYetConnectedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "OverlappingFileLockException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Pipe": [],
        "ReadPendingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ReadableByteChannel": [],
        "ScatteringByteChannel": [],
        "SeekableByteChannel": [],
        "SelectableChannel": [],
        "SelectionKey": [
            [
                "OP_READ",
                "int"
            ],
            [
                "OP_WRITE",
                "int"
            ],
            [
                "OP_CONNECT",
                "int"
            ],
            [
                "OP_ACCEPT",
                "int"
            ],
            [
                "ATTACHMENT",
                "java.lang.invoke.VarHandle"
            ],
            [
                "attachment",
                "java.lang.Object"
            ]
        ],
        "Selector": [],
        "ServerSocketChannel": [],
        "ShutdownChannelGroupException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SocketChannel": [],
        "UnresolvedAddressException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnsupportedAddressTypeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "WritableByteChannel": [],
        "WritePendingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "java.nio.channels.spi": {
        "AbstractInterruptibleChannel": [
            [
                "closeLock",
                "java.lang.Object"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "interruptor",
                "sun.nio.ch.Interruptible"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "INTERRUPTED_TARGET",
                "long"
            ],
            [
                "interruptedTarget",
                "java.lang.Object"
            ]
        ],
        "AbstractSelectableChannel": [
            [
                "provider",
                "java.nio.channels.spi.SelectorProvider"
            ],
            [
                "keys",
                "java.nio.channels.SelectionKey[]"
            ],
            [
                "keyCount",
                "int"
            ],
            [
                "keyLock",
                "java.lang.Object"
            ],
            [
                "regLock",
                "java.lang.Object"
            ],
            [
                "nonBlocking",
                "boolean"
            ]
        ],
        "AbstractSelectionKey": [
            [
                "INVALID",
                "java.lang.invoke.VarHandle"
            ],
            [
                "invalid",
                "boolean"
            ]
        ],
        "AbstractSelector": [
            [
                "CLOSED",
                "java.lang.invoke.VarHandle"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "provider",
                "java.nio.channels.spi.SelectorProvider"
            ],
            [
                "cancelledKeys",
                "java.util.Set<java.nio.channels.SelectionKey>"
            ],
            [
                "interruptor",
                "sun.nio.ch.Interruptible"
            ]
        ],
        "AsynchronousChannelProvider": [],
        "SelectorProvider": []
    },
    "java.nio.charset": {
        "CharacterCodingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Charset": [
            [
                "standardProvider",
                "java.nio.charset.spi.CharsetProvider"
            ],
            [
                "zeroAliases",
                "java.lang.String[]"
            ],
            [
                "cache1",
                "java.lang.Object[]"
            ],
            [
                "cache2",
                "java.lang.Object[]"
            ],
            [
                "defaultCharset",
                "java.nio.charset.Charset"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "aliases",
                "java.lang.String[]"
            ],
            [
                "aliasSet",
                "java.util.Set<java.lang.String>"
            ]
        ],
        "CharsetDecoder": [
            [
                "charset",
                "java.nio.charset.Charset"
            ],
            [
                "averageCharsPerByte",
                "float"
            ],
            [
                "maxCharsPerByte",
                "float"
            ],
            [
                "replacement",
                "java.lang.String"
            ],
            [
                "malformedInputAction",
                "java.nio.charset.CodingErrorAction"
            ],
            [
                "unmappableCharacterAction",
                "java.nio.charset.CodingErrorAction"
            ],
            [
                "ST_RESET",
                "int"
            ],
            [
                "ST_CODING",
                "int"
            ],
            [
                "ST_END",
                "int"
            ],
            [
                "ST_FLUSHED",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "stateNames",
                "java.lang.String[]"
            ]
        ],
        "CharsetEncoder": [
            [
                "charset",
                "java.nio.charset.Charset"
            ],
            [
                "averageBytesPerChar",
                "float"
            ],
            [
                "maxBytesPerChar",
                "float"
            ],
            [
                "replacement",
                "byte[]"
            ],
            [
                "malformedInputAction",
                "java.nio.charset.CodingErrorAction"
            ],
            [
                "unmappableCharacterAction",
                "java.nio.charset.CodingErrorAction"
            ],
            [
                "ST_RESET",
                "int"
            ],
            [
                "ST_CODING",
                "int"
            ],
            [
                "ST_END",
                "int"
            ],
            [
                "ST_FLUSHED",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "stateNames",
                "java.lang.String[]"
            ],
            [
                "cachedDecoder",
                "java.lang.ref.WeakReference<java.nio.charset.CharsetDecoder>"
            ]
        ],
        "CoderMalfunctionError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CoderResult": [
            [
                "CR_UNDERFLOW",
                "int"
            ],
            [
                "CR_OVERFLOW",
                "int"
            ],
            [
                "CR_ERROR_MIN",
                "int"
            ],
            [
                "CR_MALFORMED",
                "int"
            ],
            [
                "CR_UNMAPPABLE",
                "int"
            ],
            [
                "names",
                "java.lang.String[]"
            ],
            [
                "type",
                "int"
            ],
            [
                "length",
                "int"
            ],
            [
                "UNDERFLOW",
                "java.nio.charset.CoderResult"
            ],
            [
                "OVERFLOW",
                "java.nio.charset.CoderResult"
            ],
            [
                "malformed4",
                "java.nio.charset.CoderResult[]"
            ],
            [
                "unmappable4",
                "java.nio.charset.CoderResult[]"
            ]
        ],
        "CodingErrorAction": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "IGNORE",
                "java.nio.charset.CodingErrorAction"
            ],
            [
                "REPLACE",
                "java.nio.charset.CodingErrorAction"
            ],
            [
                "REPORT",
                "java.nio.charset.CodingErrorAction"
            ]
        ],
        "IllegalCharsetNameException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "charsetName",
                "java.lang.String"
            ]
        ],
        "MalformedInputException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "inputLength",
                "int"
            ]
        ],
        "StandardCharsets": [
            [
                "US_ASCII",
                "java.nio.charset.Charset"
            ],
            [
                "ISO_8859_1",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_8",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_16BE",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_16LE",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_16",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_32BE",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_32LE",
                "java.nio.charset.Charset"
            ],
            [
                "UTF_32",
                "java.nio.charset.Charset"
            ]
        ],
        "UnmappableCharacterException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "inputLength",
                "int"
            ]
        ],
        "UnsupportedCharsetException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "charsetName",
                "java.lang.String"
            ]
        ]
    },
    "java.nio.charset.spi": {
        "CharsetProvider": []
    },
    "java.nio.file": {
        "AccessDeniedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AccessMode": [
            [
                "READ",
                "java.nio.file.AccessMode"
            ],
            [
                "WRITE",
                "java.nio.file.AccessMode"
            ],
            [
                "EXECUTE",
                "java.nio.file.AccessMode"
            ],
            [
                "$VALUES",
                "java.nio.file.AccessMode[]"
            ]
        ],
        "AtomicMoveNotSupportedException": [],
        "ClosedDirectoryStreamException": [],
        "ClosedFileSystemException": [],
        "ClosedWatchServiceException": [],
        "CopyMoveHelper": [],
        "CopyOption": [],
        "DirectoryIteratorException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DirectoryNotEmptyException": [],
        "DirectoryStream": [],
        "FileAlreadyExistsException": [],
        "FileChannelLinesSpliterator": [
            [
                "fc",
                "java.nio.channels.FileChannel"
            ],
            [
                "cs",
                "java.nio.charset.Charset"
            ],
            [
                "index",
                "int"
            ],
            [
                "fence",
                "int"
            ],
            [
                "buffer",
                "java.nio.ByteBuffer"
            ],
            [
                "reader",
                "java.io.BufferedReader"
            ],
            [
                "bufRefCount",
                "java.util.concurrent.atomic.AtomicInteger"
            ]
        ],
        "FileStore": [],
        "FileSystem": [],
        "FileSystemAlreadyExistsException": [],
        "FileSystemException": [
            [
                "file",
                "java.lang.String"
            ],
            [
                "other",
                "java.lang.String"
            ]
        ],
        "FileSystemLoopException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "FileSystemNotFoundException": [],
        "FileSystems": [],
        "FileTreeIterator": [
            [
                "walker",
                "java.nio.file.FileTreeWalker"
            ],
            [
                "next",
                "java.nio.file.FileTreeWalker$Event"
            ]
        ],
        "FileTreeWalker": [
            [
                "followLinks",
                "boolean"
            ],
            [
                "linkOptions",
                "java.nio.file.LinkOption[]"
            ],
            [
                "maxDepth",
                "int"
            ],
            [
                "stack",
                "java.util.ArrayDeque<java.nio.file.FileTreeWalker$DirectoryNode>"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "FileVisitOption": [
            [
                "FOLLOW_LINKS",
                "java.nio.file.FileVisitOption"
            ],
            [
                "$VALUES",
                "java.nio.file.FileVisitOption[]"
            ]
        ],
        "FileVisitResult": [
            [
                "CONTINUE",
                "java.nio.file.FileVisitResult"
            ],
            [
                "TERMINATE",
                "java.nio.file.FileVisitResult"
            ],
            [
                "SKIP_SUBTREE",
                "java.nio.file.FileVisitResult"
            ],
            [
                "SKIP_SIBLINGS",
                "java.nio.file.FileVisitResult"
            ],
            [
                "$VALUES",
                "java.nio.file.FileVisitResult[]"
            ]
        ],
        "FileVisitor": [],
        "Files": [
            [
                "BUFFER_SIZE",
                "int"
            ],
            [
                "DEFAULT_CREATE_OPTIONS",
                "java.util.Set<java.nio.file.OpenOption>"
            ],
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ]
        ],
        "InvalidPathException": [
            [
                "input",
                "java.lang.String"
            ],
            [
                "index",
                "int"
            ]
        ],
        "LinkOption": [
            [
                "NOFOLLOW_LINKS",
                "java.nio.file.LinkOption"
            ],
            [
                "$VALUES",
                "java.nio.file.LinkOption[]"
            ]
        ],
        "LinkPermission": [],
        "NoSuchFileException": [],
        "NotDirectoryException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NotLinkException": [],
        "OpenOption": [],
        "Path": [],
        "PathMatcher": [],
        "Paths": [],
        "ProviderMismatchException": [],
        "ProviderNotFoundException": [],
        "ReadOnlyFileSystemException": [],
        "SecureDirectoryStream": [],
        "SimpleFileVisitor": [],
        "StandardCopyOption": [
            [
                "REPLACE_EXISTING",
                "java.nio.file.StandardCopyOption"
            ],
            [
                "COPY_ATTRIBUTES",
                "java.nio.file.StandardCopyOption"
            ],
            [
                "ATOMIC_MOVE",
                "java.nio.file.StandardCopyOption"
            ],
            [
                "$VALUES",
                "java.nio.file.StandardCopyOption[]"
            ]
        ],
        "StandardOpenOption": [
            [
                "READ",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "WRITE",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "APPEND",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "TRUNCATE_EXISTING",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "CREATE",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "CREATE_NEW",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "DELETE_ON_CLOSE",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "SPARSE",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "SYNC",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "DSYNC",
                "java.nio.file.StandardOpenOption"
            ],
            [
                "$VALUES",
                "java.nio.file.StandardOpenOption[]"
            ]
        ],
        "StandardWatchEventKinds": [
            [
                "OVERFLOW",
                "java.nio.file.WatchEvent$Kind<java.lang.Object>"
            ],
            [
                "ENTRY_CREATE",
                "java.nio.file.WatchEvent$Kind<java.nio.file.Path>"
            ],
            [
                "ENTRY_DELETE",
                "java.nio.file.WatchEvent$Kind<java.nio.file.Path>"
            ],
            [
                "ENTRY_MODIFY",
                "java.nio.file.WatchEvent$Kind<java.nio.file.Path>"
            ]
        ],
        "TempFileHelper": [
            [
                "tmpdir",
                "java.nio.file.Path"
            ],
            [
                "isPosix",
                "boolean"
            ],
            [
                "random",
                "java.security.SecureRandom"
            ]
        ],
        "WatchEvent": [],
        "WatchKey": [],
        "WatchService": [],
        "Watchable": []
    },
    "java.nio.file.attribute": {
        "AclEntry": [
            [
                "type",
                "java.nio.file.attribute.AclEntryType"
            ],
            [
                "who",
                "java.nio.file.attribute.UserPrincipal"
            ],
            [
                "perms",
                "java.util.Set<java.nio.file.attribute.AclEntryPermission>"
            ],
            [
                "flags",
                "java.util.Set<java.nio.file.attribute.AclEntryFlag>"
            ],
            [
                "hash",
                "int"
            ]
        ],
        "AclEntryFlag": [
            [
                "FILE_INHERIT",
                "java.nio.file.attribute.AclEntryFlag"
            ],
            [
                "DIRECTORY_INHERIT",
                "java.nio.file.attribute.AclEntryFlag"
            ],
            [
                "NO_PROPAGATE_INHERIT",
                "java.nio.file.attribute.AclEntryFlag"
            ],
            [
                "INHERIT_ONLY",
                "java.nio.file.attribute.AclEntryFlag"
            ],
            [
                "$VALUES",
                "java.nio.file.attribute.AclEntryFlag[]"
            ]
        ],
        "AclEntryPermission": [
            [
                "READ_DATA",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "WRITE_DATA",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "APPEND_DATA",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "READ_NAMED_ATTRS",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "WRITE_NAMED_ATTRS",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "EXECUTE",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "DELETE_CHILD",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "READ_ATTRIBUTES",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "WRITE_ATTRIBUTES",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "DELETE",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "READ_ACL",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "WRITE_ACL",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "WRITE_OWNER",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "SYNCHRONIZE",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "LIST_DIRECTORY",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "ADD_FILE",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "ADD_SUBDIRECTORY",
                "java.nio.file.attribute.AclEntryPermission"
            ],
            [
                "$VALUES",
                "java.nio.file.attribute.AclEntryPermission[]"
            ]
        ],
        "AclEntryType": [
            [
                "ALLOW",
                "java.nio.file.attribute.AclEntryType"
            ],
            [
                "DENY",
                "java.nio.file.attribute.AclEntryType"
            ],
            [
                "AUDIT",
                "java.nio.file.attribute.AclEntryType"
            ],
            [
                "ALARM",
                "java.nio.file.attribute.AclEntryType"
            ],
            [
                "$VALUES",
                "java.nio.file.attribute.AclEntryType[]"
            ]
        ],
        "AclFileAttributeView": [],
        "AttributeView": [],
        "BasicFileAttributeView": [],
        "BasicFileAttributes": [],
        "DosFileAttributeView": [],
        "DosFileAttributes": [],
        "FileAttribute": [],
        "FileAttributeView": [],
        "FileOwnerAttributeView": [],
        "FileStoreAttributeView": [],
        "FileTime": [
            [
                "unit",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "value",
                "long"
            ],
            [
                "instant",
                "java.time.Instant"
            ],
            [
                "valueAsString",
                "java.lang.String"
            ],
            [
                "HOURS_PER_DAY",
                "long"
            ],
            [
                "MINUTES_PER_HOUR",
                "long"
            ],
            [
                "SECONDS_PER_MINUTE",
                "long"
            ],
            [
                "SECONDS_PER_HOUR",
                "long"
            ],
            [
                "SECONDS_PER_DAY",
                "long"
            ],
            [
                "MILLIS_PER_SECOND",
                "long"
            ],
            [
                "MICROS_PER_SECOND",
                "long"
            ],
            [
                "NANOS_PER_SECOND",
                "long"
            ],
            [
                "NANOS_PER_MILLI",
                "int"
            ],
            [
                "NANOS_PER_MICRO",
                "int"
            ],
            [
                "MIN_SECOND",
                "long"
            ],
            [
                "MAX_SECOND",
                "long"
            ],
            [
                "DAYS_PER_10000_YEARS",
                "long"
            ],
            [
                "SECONDS_PER_10000_YEARS",
                "long"
            ],
            [
                "SECONDS_0000_TO_1970",
                "long"
            ]
        ],
        "GroupPrincipal": [],
        "PosixFileAttributeView": [],
        "PosixFileAttributes": [],
        "PosixFilePermission": [
            [
                "OWNER_READ",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "OWNER_WRITE",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "OWNER_EXECUTE",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "GROUP_READ",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "GROUP_WRITE",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "GROUP_EXECUTE",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "OTHERS_READ",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "OTHERS_WRITE",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "OTHERS_EXECUTE",
                "java.nio.file.attribute.PosixFilePermission"
            ],
            [
                "$VALUES",
                "java.nio.file.attribute.PosixFilePermission[]"
            ]
        ],
        "PosixFilePermissions": [],
        "UserDefinedFileAttributeView": [],
        "UserPrincipal": [],
        "UserPrincipalLookupService": [],
        "UserPrincipalNotFoundException": [
            [
                "name",
                "java.lang.String"
            ]
        ]
    },
    "java.nio.file.spi": {
        "FileSystemProvider": [
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "installedProviders",
                "java.util.List<java.nio.file.spi.FileSystemProvider>"
            ],
            [
                "loadingProviders",
                "boolean"
            ],
            [
                "DEFAULT_OPEN_OPTIONS",
                "java.util.Set<java.nio.file.OpenOption>"
            ]
        ],
        "FileTypeDetector": []
    },
    "java.security": {
        "AccessControlContext": [
            [
                "context",
                "java.security.ProtectionDomain[]"
            ],
            [
                "combiner",
                "java.security.DomainCombiner"
            ]
        ],
        "AccessControlException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "perm",
                "java.security.Permission"
            ]
        ],
        "AccessController": [
            [
                "NO_PERMISSIONS_ACC",
                "java.security.AccessControlContext"
            ]
        ],
        "AlgorithmConstraints": [],
        "AlgorithmParameterGenerator": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "paramGenSpi",
                "java.security.AlgorithmParameterGeneratorSpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "AlgorithmParameterGeneratorSpi": [],
        "AlgorithmParameters": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "paramSpi",
                "java.security.AlgorithmParametersSpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "initialized",
                "boolean"
            ]
        ],
        "AlgorithmParametersSpi": [],
        "AllPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AllPermissionCollection": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "all_allowed",
                "boolean"
            ]
        ],
        "AsymmetricKey": [],
        "AuthProvider": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "BasicPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "wildcard",
                "boolean"
            ],
            [
                "path",
                "java.lang.String"
            ],
            [
                "exitVM",
                "boolean"
            ]
        ],
        "BasicPermissionCollection": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "perms",
                "java.security.Permission>"
            ],
            [
                "all_allowed",
                "boolean"
            ],
            [
                "permClass",
                "java.lang.Class<?>"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "Certificate": [],
        "CodeSigner": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "signerCertPath",
                "java.security.cert.CertPath"
            ],
            [
                "timestamp",
                "java.security.Timestamp"
            ],
            [
                "myhash",
                "int"
            ]
        ],
        "CodeSource": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "location",
                "java.net.URL"
            ],
            [
                "signers",
                "java.security.CodeSigner[]"
            ],
            [
                "certs",
                "java.security.cert.Certificate[]"
            ],
            [
                "sp",
                "java.net.SocketPermission"
            ],
            [
                "factory",
                "java.security.cert.CertificateFactory"
            ],
            [
                "locationNoFragString",
                "java.lang.String"
            ]
        ],
        "CryptoPrimitive": [
            [
                "MESSAGE_DIGEST",
                "java.security.CryptoPrimitive"
            ],
            [
                "SECURE_RANDOM",
                "java.security.CryptoPrimitive"
            ],
            [
                "BLOCK_CIPHER",
                "java.security.CryptoPrimitive"
            ],
            [
                "STREAM_CIPHER",
                "java.security.CryptoPrimitive"
            ],
            [
                "MAC",
                "java.security.CryptoPrimitive"
            ],
            [
                "KEY_WRAP",
                "java.security.CryptoPrimitive"
            ],
            [
                "PUBLIC_KEY_ENCRYPTION",
                "java.security.CryptoPrimitive"
            ],
            [
                "SIGNATURE",
                "java.security.CryptoPrimitive"
            ],
            [
                "KEY_ENCAPSULATION",
                "java.security.CryptoPrimitive"
            ],
            [
                "KEY_AGREEMENT",
                "java.security.CryptoPrimitive"
            ],
            [
                "$VALUES",
                "java.security.CryptoPrimitive[]"
            ]
        ],
        "DigestException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DigestInputStream": [
            [
                "on",
                "boolean"
            ],
            [
                "digest",
                "java.security.MessageDigest"
            ]
        ],
        "DigestOutputStream": [
            [
                "on",
                "boolean"
            ],
            [
                "digest",
                "java.security.MessageDigest"
            ]
        ],
        "DomainCombiner": [],
        "DomainLoadStoreParameter": [
            [
                "configuration",
                "java.net.URI"
            ],
            [
                "protectionParams",
                "java.security.KeyStore$ProtectionParameter>"
            ]
        ],
        "DrbgParameters": [],
        "GeneralSecurityException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Guard": [],
        "GuardedObject": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "object",
                "java.lang.Object"
            ],
            [
                "guard",
                "java.security.Guard"
            ]
        ],
        "Identity": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "publicKey",
                "java.security.PublicKey"
            ]
        ],
        "IdentityScope": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "scope",
                "java.security.IdentityScope"
            ]
        ],
        "InvalidAlgorithmParameterException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvalidKeyException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvalidParameterException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Key": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "KeyException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "KeyFactory": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "spi",
                "java.security.KeyFactorySpi"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ]
        ],
        "KeyFactorySpi": [],
        "KeyManagementException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "KeyPair": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "privateKey",
                "java.security.PrivateKey"
            ],
            [
                "publicKey",
                "java.security.PublicKey"
            ]
        ],
        "KeyPairGenerator": [
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "KeyPairGeneratorSpi": [],
        "KeyRep": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "PKCS8",
                "java.lang.String"
            ],
            [
                "X509",
                "java.lang.String"
            ],
            [
                "RAW",
                "java.lang.String"
            ],
            [
                "type",
                "java.security.KeyRep$Type"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "format",
                "java.lang.String"
            ],
            [
                "encoded",
                "byte[]"
            ]
        ],
        "KeyStore": [
            [
                "kdebug",
                "sun.security.util.Debug"
            ],
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "KEYSTORE_TYPE",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.String"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "keyStoreSpi",
                "java.security.KeyStoreSpi"
            ],
            [
                "initialized",
                "boolean"
            ]
        ],
        "KeyStoreException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "KeyStoreSpi": [],
        "MessageDigest": [
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "INITIAL",
                "int"
            ],
            [
                "IN_PROGRESS",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "provider",
                "java.security.Provider"
            ]
        ],
        "MessageDigestSpi": [
            [
                "tempArray",
                "byte[]"
            ]
        ],
        "NoSuchAlgorithmException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NoSuchProviderException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PKCS12Attribute": [
            [
                "COLON_SEPARATED_HEX_PAIRS",
                "java.util.regex.Pattern"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ],
            [
                "encoded",
                "byte[]"
            ],
            [
                "hashValue",
                "int"
            ]
        ],
        "Permission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ]
        ],
        "PermissionCollection": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "readOnly",
                "boolean"
            ]
        ],
        "Permissions": [
            [
                "permsMap",
                "java.security.PermissionCollection>"
            ],
            [
                "hasUnresolved",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "PermissionsEnumerator": [
            [
                "perms",
                "java.util.Iterator<java.security.PermissionCollection>"
            ],
            [
                "permset",
                "java.util.Enumeration<java.security.Permission>"
            ]
        ],
        "PermissionsHash": [
            [
                "permsMap",
                "java.security.Permission>"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "Policy": [
            [
                "NO_PERMISSIONS_POLICY",
                "java.security.Policy"
            ],
            [
                "UNSUPPORTED_EMPTY_COLLECTION",
                "java.security.PermissionCollection"
            ]
        ],
        "PolicySpi": [],
        "Principal": [],
        "PrivateKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PrivilegedAction": [],
        "PrivilegedActionException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "PrivilegedExceptionAction": [],
        "ProtectionDomain": [
            [
                "codesource",
                "java.security.CodeSource"
            ],
            [
                "classloader",
                "java.lang.ClassLoader"
            ],
            [
                "principals",
                "java.security.Principal[]"
            ],
            [
                "permissions",
                "java.security.PermissionCollection"
            ],
            [
                "hasAllPerm",
                "boolean"
            ],
            [
                "staticPermissions",
                "boolean"
            ]
        ],
        "Provider": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "info",
                "java.lang.String"
            ],
            [
                "version",
                "double"
            ],
            [
                "versionStr",
                "java.lang.String"
            ],
            [
                "entrySet",
                "java.lang.Object>>"
            ],
            [
                "entrySetCallCount",
                "int"
            ],
            [
                "initialized",
                "boolean"
            ],
            [
                "EMPTY",
                "java.lang.Object[]"
            ],
            [
                "legacyChanged",
                "boolean"
            ],
            [
                "servicesChanged",
                "boolean"
            ],
            [
                "serviceMap",
                "java.security.Provider$Service>"
            ],
            [
                "prngAlgos",
                "java.util.Set<java.lang.String>"
            ],
            [
                "legacyMap",
                "java.security.Provider$Service>"
            ],
            [
                "serviceSet",
                "java.util.Set<java.security.Provider$Service>"
            ],
            [
                "ALIAS_PREFIX",
                "java.lang.String"
            ],
            [
                "ALIAS_PREFIX_LOWER",
                "java.lang.String"
            ],
            [
                "ALIAS_LENGTH",
                "int"
            ],
            [
                "previousKey",
                "java.lang.ThreadLocal<java.security.Provider$ServiceKey>"
            ],
            [
                "knownEngines",
                "java.security.Provider$EngineDescription>"
            ]
        ],
        "ProviderException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PublicKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SecureClassLoader": [
            [
                "pdcache",
                "java.security.ProtectionDomain>"
            ]
        ],
        "SecureRandom": [
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "secureRandomSpi",
                "java.security.SecureRandomSpi"
            ],
            [
                "threadSafe",
                "boolean"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "seedGenerator",
                "java.security.SecureRandom"
            ],
            [
                "state",
                "byte[]"
            ],
            [
                "digest",
                "java.security.MessageDigest"
            ],
            [
                "randomBytes",
                "byte[]"
            ],
            [
                "randomBytesUsed",
                "int"
            ],
            [
                "counter",
                "long"
            ]
        ],
        "SecureRandomParameters": [],
        "SecureRandomSpi": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Security": [
            [
                "sdebug",
                "sun.security.util.Debug"
            ],
            [
                "props",
                "java.util.Properties"
            ],
            [
                "initialSecurityProperties",
                "java.util.Properties"
            ],
            [
                "spiMap",
                "java.lang.Class<?>>"
            ]
        ],
        "SecurityPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Signature": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "UNINITIALIZED",
                "int"
            ],
            [
                "SIGN",
                "int"
            ],
            [
                "VERIFY",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "RSA_SIGNATURE",
                "java.lang.String"
            ],
            [
                "RSA_CIPHER",
                "java.lang.String"
            ],
            [
                "rsaIds",
                "java.util.List<sun.security.jca.ServiceId>"
            ],
            [
                "signatureInfo",
                "java.lang.Boolean>"
            ]
        ],
        "SignatureException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SignatureSpi": [
            [
                "appRandom",
                "java.security.SecureRandom"
            ]
        ],
        "SignedObject": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "content",
                "byte[]"
            ],
            [
                "signature",
                "byte[]"
            ],
            [
                "thealgorithm",
                "java.lang.String"
            ]
        ],
        "Signer": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "privateKey",
                "java.security.PrivateKey"
            ]
        ],
        "Timestamp": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "timestamp",
                "java.util.Date"
            ],
            [
                "signerCertPath",
                "java.security.cert.CertPath"
            ],
            [
                "myhash",
                "int"
            ]
        ],
        "URIParameter": [
            [
                "uri",
                "java.net.URI"
            ]
        ],
        "UnrecoverableEntryException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnrecoverableKeyException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "UnresolvedPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "type",
                "java.lang.String"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "actions",
                "java.lang.String"
            ],
            [
                "certs",
                "java.security.cert.Certificate[]"
            ],
            [
                "PARAMS0",
                "java.lang.Class<?>[]"
            ],
            [
                "PARAMS1",
                "java.lang.Class<?>[]"
            ],
            [
                "PARAMS2",
                "java.lang.Class<?>[]"
            ]
        ],
        "UnresolvedPermissionCollection": [
            [
                "perms",
                "java.util.List<java.security.UnresolvedPermission>>"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ]
    },
    "java.security.cert": {
        "CRL": [
            [
                "type",
                "java.lang.String"
            ]
        ],
        "CRLException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CRLReason": [
            [
                "UNSPECIFIED",
                "java.security.cert.CRLReason"
            ],
            [
                "KEY_COMPROMISE",
                "java.security.cert.CRLReason"
            ],
            [
                "CA_COMPROMISE",
                "java.security.cert.CRLReason"
            ],
            [
                "AFFILIATION_CHANGED",
                "java.security.cert.CRLReason"
            ],
            [
                "SUPERSEDED",
                "java.security.cert.CRLReason"
            ],
            [
                "CESSATION_OF_OPERATION",
                "java.security.cert.CRLReason"
            ],
            [
                "CERTIFICATE_HOLD",
                "java.security.cert.CRLReason"
            ],
            [
                "UNUSED",
                "java.security.cert.CRLReason"
            ],
            [
                "REMOVE_FROM_CRL",
                "java.security.cert.CRLReason"
            ],
            [
                "PRIVILEGE_WITHDRAWN",
                "java.security.cert.CRLReason"
            ],
            [
                "AA_COMPROMISE",
                "java.security.cert.CRLReason"
            ],
            [
                "$VALUES",
                "java.security.cert.CRLReason[]"
            ]
        ],
        "CRLSelector": [],
        "CertPath": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "java.lang.String"
            ]
        ],
        "CertPathBuilder": [
            [
                "CPB_TYPE",
                "java.lang.String"
            ],
            [
                "builderSpi",
                "java.security.cert.CertPathBuilderSpi"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "CertPathBuilderException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertPathBuilderResult": [],
        "CertPathBuilderSpi": [],
        "CertPathChecker": [],
        "CertPathHelperImpl": [],
        "CertPathParameters": [],
        "CertPathValidator": [
            [
                "CPV_TYPE",
                "java.lang.String"
            ],
            [
                "validatorSpi",
                "java.security.cert.CertPathValidatorSpi"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "CertPathValidatorException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "index",
                "int"
            ],
            [
                "certPath",
                "java.security.cert.CertPath"
            ],
            [
                "reason",
                "java.security.cert.CertPathValidatorException$Reason"
            ]
        ],
        "CertPathValidatorResult": [],
        "CertPathValidatorSpi": [],
        "CertSelector": [],
        "CertStore": [
            [
                "CERTSTORE_TYPE",
                "java.lang.String"
            ],
            [
                "storeSpi",
                "java.security.cert.CertStoreSpi"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "type",
                "java.lang.String"
            ],
            [
                "params",
                "java.security.cert.CertStoreParameters"
            ]
        ],
        "CertStoreException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertStoreParameters": [],
        "CertStoreSpi": [],
        "Certificate": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "java.lang.String"
            ],
            [
                "hash",
                "int"
            ]
        ],
        "CertificateEncodingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateExpiredException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateFactory": [
            [
                "type",
                "java.lang.String"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "certFacSpi",
                "java.security.cert.CertificateFactorySpi"
            ]
        ],
        "CertificateFactorySpi": [],
        "CertificateNotYetValidException": [],
        "CertificateParsingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateRevokedException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "revocationDate",
                "java.util.Date"
            ],
            [
                "reason",
                "java.security.cert.CRLReason"
            ],
            [
                "authority",
                "javax.security.auth.x500.X500Principal"
            ],
            [
                "extensions",
                "java.security.cert.Extension>"
            ]
        ],
        "CollectionCertStoreParameters": [
            [
                "coll",
                "java.util.Collection<?>"
            ]
        ],
        "Extension": [],
        "LDAPCertStoreParameters": [
            [
                "LDAP_DEFAULT_PORT",
                "int"
            ],
            [
                "port",
                "int"
            ],
            [
                "serverName",
                "java.lang.String"
            ]
        ],
        "PKIXBuilderParameters": [
            [
                "maxPathLength",
                "int"
            ]
        ],
        "PKIXCertPathBuilderResult": [
            [
                "certPath",
                "java.security.cert.CertPath"
            ]
        ],
        "PKIXCertPathChecker": [],
        "PKIXCertPathValidatorResult": [
            [
                "trustAnchor",
                "java.security.cert.TrustAnchor"
            ],
            [
                "policyTree",
                "java.security.cert.PolicyNode"
            ],
            [
                "subjectPublicKey",
                "java.security.PublicKey"
            ]
        ],
        "PKIXParameters": [
            [
                "unmodTrustAnchors",
                "java.util.Set<java.security.cert.TrustAnchor>"
            ],
            [
                "date",
                "java.util.Date"
            ],
            [
                "certPathCheckers",
                "java.util.List<java.security.cert.PKIXCertPathChecker>"
            ],
            [
                "sigProvider",
                "java.lang.String"
            ],
            [
                "revocationEnabled",
                "boolean"
            ],
            [
                "unmodInitialPolicies",
                "java.util.Set<java.lang.String>"
            ],
            [
                "explicitPolicyRequired",
                "boolean"
            ],
            [
                "policyMappingInhibited",
                "boolean"
            ],
            [
                "anyPolicyInhibited",
                "boolean"
            ],
            [
                "policyQualifiersRejected",
                "boolean"
            ],
            [
                "certStores",
                "java.util.List<java.security.cert.CertStore>"
            ],
            [
                "certSelector",
                "java.security.cert.CertSelector"
            ]
        ],
        "PKIXReason": [
            [
                "NAME_CHAINING",
                "java.security.cert.PKIXReason"
            ],
            [
                "INVALID_KEY_USAGE",
                "java.security.cert.PKIXReason"
            ],
            [
                "INVALID_POLICY",
                "java.security.cert.PKIXReason"
            ],
            [
                "NO_TRUST_ANCHOR",
                "java.security.cert.PKIXReason"
            ],
            [
                "UNRECOGNIZED_CRIT_EXT",
                "java.security.cert.PKIXReason"
            ],
            [
                "NOT_CA_CERT",
                "java.security.cert.PKIXReason"
            ],
            [
                "PATH_TOO_LONG",
                "java.security.cert.PKIXReason"
            ],
            [
                "INVALID_NAME",
                "java.security.cert.PKIXReason"
            ],
            [
                "$VALUES",
                "java.security.cert.PKIXReason[]"
            ]
        ],
        "PKIXRevocationChecker": [
            [
                "ocspResponder",
                "java.net.URI"
            ],
            [
                "ocspResponderCert",
                "java.security.cert.X509Certificate"
            ],
            [
                "ocspExtensions",
                "java.util.List<java.security.cert.Extension>"
            ],
            [
                "ocspResponses",
                "byte[]>"
            ],
            [
                "options",
                "java.util.Set<java.security.cert.PKIXRevocationChecker$Option>"
            ]
        ],
        "PolicyNode": [],
        "PolicyQualifierInfo": [
            [
                "mEncoded",
                "byte[]"
            ],
            [
                "mId",
                "java.lang.String"
            ],
            [
                "mData",
                "byte[]"
            ],
            [
                "pqiString",
                "java.lang.String"
            ]
        ],
        "TrustAnchor": [
            [
                "pubKey",
                "java.security.PublicKey"
            ],
            [
                "caName",
                "java.lang.String"
            ],
            [
                "caPrincipal",
                "javax.security.auth.x500.X500Principal"
            ],
            [
                "trustedCert",
                "java.security.cert.X509Certificate"
            ],
            [
                "ncBytes",
                "byte[]"
            ],
            [
                "nc",
                "sun.security.x509.NameConstraintsExtension"
            ],
            [
                "jdkCA",
                "boolean"
            ],
            [
                "hasJdkCABeenChecked",
                "boolean"
            ]
        ],
        "URICertStoreParameters": [
            [
                "uri",
                "java.net.URI"
            ],
            [
                "myhash",
                "int"
            ]
        ],
        "X509CRL": [
            [
                "issuerPrincipal",
                "javax.security.auth.x500.X500Principal"
            ]
        ],
        "X509CRLEntry": [],
        "X509CRLSelector": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "issuerNames",
                "java.util.HashSet<java.lang.Object>"
            ],
            [
                "issuerX500Principals",
                "java.util.HashSet<javax.security.auth.x500.X500Principal>"
            ],
            [
                "minCRL",
                "java.math.BigInteger"
            ],
            [
                "maxCRL",
                "java.math.BigInteger"
            ],
            [
                "dateAndTime",
                "java.util.Date"
            ],
            [
                "certChecking",
                "java.security.cert.X509Certificate"
            ],
            [
                "skew",
                "long"
            ]
        ],
        "X509CertSelector": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "ANY_EXTENDED_KEY_USAGE",
                "sun.security.util.ObjectIdentifier"
            ],
            [
                "serialNumber",
                "java.math.BigInteger"
            ],
            [
                "issuer",
                "javax.security.auth.x500.X500Principal"
            ],
            [
                "subject",
                "javax.security.auth.x500.X500Principal"
            ],
            [
                "subjectKeyID",
                "byte[]"
            ],
            [
                "authorityKeyID",
                "byte[]"
            ],
            [
                "certificateValid",
                "java.util.Date"
            ],
            [
                "privateKeyValid",
                "java.util.Date"
            ],
            [
                "subjectPublicKeyAlgID",
                "sun.security.util.ObjectIdentifier"
            ],
            [
                "subjectPublicKey",
                "java.security.PublicKey"
            ],
            [
                "subjectPublicKeyBytes",
                "byte[]"
            ],
            [
                "keyUsage",
                "boolean[]"
            ],
            [
                "keyPurposeSet",
                "java.util.Set<java.lang.String>"
            ],
            [
                "keyPurposeOIDSet",
                "java.util.Set<sun.security.util.ObjectIdentifier>"
            ],
            [
                "subjectAlternativeNames",
                "java.util.Set<java.util.List<?>>"
            ],
            [
                "subjectAlternativeGeneralNames",
                "java.util.Set<sun.security.x509.GeneralNameInterface>"
            ],
            [
                "policy",
                "sun.security.x509.CertificatePolicySet"
            ],
            [
                "policySet",
                "java.util.Set<java.lang.String>"
            ],
            [
                "pathToNames",
                "java.util.Set<java.util.List<?>>"
            ],
            [
                "pathToGeneralNames",
                "java.util.Set<sun.security.x509.GeneralNameInterface>"
            ],
            [
                "nc",
                "sun.security.x509.NameConstraintsExtension"
            ],
            [
                "ncBytes",
                "byte[]"
            ],
            [
                "basicConstraints",
                "int"
            ],
            [
                "x509Cert",
                "java.security.cert.X509Certificate"
            ],
            [
                "matchAllSubjectAltNames",
                "boolean"
            ],
            [
                "FALSE",
                "java.lang.Boolean"
            ]
        ],
        "X509Certificate": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "subjectX500Principal",
                "javax.security.auth.x500.X500Principal"
            ],
            [
                "issuerX500Principal",
                "javax.security.auth.x500.X500Principal"
            ]
        ],
        "X509Extension": []
    },
    "java.security.interfaces": {
        "DSAKey": [],
        "DSAKeyPairGenerator": [],
        "DSAParams": [],
        "DSAPrivateKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DSAPublicKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ECKey": [],
        "ECPrivateKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ECPublicKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "EdECKey": [],
        "EdECPrivateKey": [],
        "EdECPublicKey": [],
        "RSAKey": [],
        "RSAMultiPrimePrivateCrtKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RSAPrivateCrtKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RSAPrivateKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RSAPublicKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "XECKey": [],
        "XECPrivateKey": [],
        "XECPublicKey": []
    },
    "java.security.spec": {
        "AlgorithmParameterSpec": [],
        "DSAGenParameterSpec": [
            [
                "pLen",
                "int"
            ],
            [
                "qLen",
                "int"
            ],
            [
                "seedLen",
                "int"
            ]
        ],
        "DSAParameterSpec": [],
        "DSAPrivateKeySpec": [
            [
                "x",
                "java.math.BigInteger"
            ],
            [
                "p",
                "java.math.BigInteger"
            ],
            [
                "q",
                "java.math.BigInteger"
            ],
            [
                "g",
                "java.math.BigInteger"
            ]
        ],
        "DSAPublicKeySpec": [
            [
                "y",
                "java.math.BigInteger"
            ],
            [
                "p",
                "java.math.BigInteger"
            ],
            [
                "q",
                "java.math.BigInteger"
            ],
            [
                "g",
                "java.math.BigInteger"
            ]
        ],
        "ECField": [],
        "ECFieldF2m": [
            [
                "m",
                "int"
            ],
            [
                "ks",
                "int[]"
            ],
            [
                "rp",
                "java.math.BigInteger"
            ]
        ],
        "ECFieldFp": [
            [
                "p",
                "java.math.BigInteger"
            ]
        ],
        "ECGenParameterSpec": [],
        "ECParameterSpec": [
            [
                "curve",
                "java.security.spec.EllipticCurve"
            ],
            [
                "g",
                "java.security.spec.ECPoint"
            ],
            [
                "n",
                "java.math.BigInteger"
            ],
            [
                "h",
                "int"
            ]
        ],
        "ECPoint": [
            [
                "x",
                "java.math.BigInteger"
            ],
            [
                "y",
                "java.math.BigInteger"
            ],
            [
                "POINT_INFINITY",
                "java.security.spec.ECPoint"
            ]
        ],
        "ECPrivateKeySpec": [
            [
                "s",
                "java.math.BigInteger"
            ],
            [
                "params",
                "java.security.spec.ECParameterSpec"
            ]
        ],
        "ECPublicKeySpec": [
            [
                "w",
                "java.security.spec.ECPoint"
            ],
            [
                "params",
                "java.security.spec.ECParameterSpec"
            ]
        ],
        "EdDSAParameterSpec": [
            [
                "prehash",
                "boolean"
            ],
            [
                "context",
                "byte[]"
            ]
        ],
        "EdECPoint": [
            [
                "xOdd",
                "boolean"
            ],
            [
                "y",
                "java.math.BigInteger"
            ]
        ],
        "EdECPrivateKeySpec": [
            [
                "params",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "bytes",
                "byte[]"
            ]
        ],
        "EdECPublicKeySpec": [
            [
                "params",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "point",
                "java.security.spec.EdECPoint"
            ]
        ],
        "EllipticCurve": [
            [
                "field",
                "java.security.spec.ECField"
            ],
            [
                "a",
                "java.math.BigInteger"
            ],
            [
                "b",
                "java.math.BigInteger"
            ],
            [
                "seed",
                "byte[]"
            ]
        ],
        "EncodedKeySpec": [
            [
                "encodedKey",
                "byte[]"
            ],
            [
                "algorithmName",
                "java.lang.String"
            ]
        ],
        "InvalidKeySpecException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "InvalidParameterSpecException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "KeySpec": [],
        "MGF1ParameterSpec": [
            [
                "SHA1",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA224",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA256",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA384",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA512",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA512_224",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA512_256",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA3_224",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA3_256",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA3_384",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "SHA3_512",
                "java.security.spec.MGF1ParameterSpec"
            ],
            [
                "mdName",
                "java.lang.String"
            ]
        ],
        "NamedParameterSpec": [
            [
                "X25519",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "X448",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ED25519",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ED448",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ML_DSA_44",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ML_DSA_65",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ML_DSA_87",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ML_KEM_512",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ML_KEM_768",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "ML_KEM_1024",
                "java.security.spec.NamedParameterSpec"
            ],
            [
                "name",
                "java.lang.String"
            ]
        ],
        "PKCS8EncodedKeySpec": [],
        "PSSParameterSpec": [
            [
                "mdName",
                "java.lang.String"
            ],
            [
                "mgfName",
                "java.lang.String"
            ],
            [
                "mgfSpec",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "saltLen",
                "int"
            ],
            [
                "trailerField",
                "int"
            ],
            [
                "TRAILER_FIELD_BC",
                "int"
            ],
            [
                "DEFAULT",
                "java.security.spec.PSSParameterSpec"
            ]
        ],
        "RSAKeyGenParameterSpec": [
            [
                "keysize",
                "int"
            ],
            [
                "publicExponent",
                "java.math.BigInteger"
            ],
            [
                "keyParams",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "F0",
                "java.math.BigInteger"
            ],
            [
                "F4",
                "java.math.BigInteger"
            ]
        ],
        "RSAMultiPrimePrivateCrtKeySpec": [
            [
                "publicExponent",
                "java.math.BigInteger"
            ],
            [
                "primeP",
                "java.math.BigInteger"
            ],
            [
                "primeQ",
                "java.math.BigInteger"
            ],
            [
                "primeExponentP",
                "java.math.BigInteger"
            ],
            [
                "primeExponentQ",
                "java.math.BigInteger"
            ],
            [
                "crtCoefficient",
                "java.math.BigInteger"
            ],
            [
                "otherPrimeInfo",
                "java.security.spec.RSAOtherPrimeInfo[]"
            ]
        ],
        "RSAOtherPrimeInfo": [
            [
                "prime",
                "java.math.BigInteger"
            ],
            [
                "primeExponent",
                "java.math.BigInteger"
            ],
            [
                "crtCoefficient",
                "java.math.BigInteger"
            ]
        ],
        "RSAPrivateCrtKeySpec": [
            [
                "publicExponent",
                "java.math.BigInteger"
            ],
            [
                "primeP",
                "java.math.BigInteger"
            ],
            [
                "primeQ",
                "java.math.BigInteger"
            ],
            [
                "primeExponentP",
                "java.math.BigInteger"
            ],
            [
                "primeExponentQ",
                "java.math.BigInteger"
            ],
            [
                "crtCoefficient",
                "java.math.BigInteger"
            ]
        ],
        "RSAPrivateKeySpec": [
            [
                "modulus",
                "java.math.BigInteger"
            ],
            [
                "privateExponent",
                "java.math.BigInteger"
            ],
            [
                "params",
                "java.security.spec.AlgorithmParameterSpec"
            ]
        ],
        "RSAPublicKeySpec": [
            [
                "modulus",
                "java.math.BigInteger"
            ],
            [
                "publicExponent",
                "java.math.BigInteger"
            ],
            [
                "params",
                "java.security.spec.AlgorithmParameterSpec"
            ]
        ],
        "X509EncodedKeySpec": [],
        "XECPrivateKeySpec": [
            [
                "params",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "scalar",
                "byte[]"
            ]
        ],
        "XECPublicKeySpec": [
            [
                "params",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "u",
                "java.math.BigInteger"
            ]
        ]
    },
    "java.text": {
        "Annotation": [
            [
                "value",
                "java.lang.Object"
            ]
        ],
        "AttributeEntry": [
            [
                "key",
                "java.text.AttributedCharacterIterator$Attribute"
            ],
            [
                "value",
                "java.lang.Object"
            ]
        ],
        "AttributedCharacterIterator": [],
        "AttributedString": [
            [
                "INITIAL_CAPACITY",
                "int"
            ]
        ],
        "Bidi": [
            [
                "DIRECTION_LEFT_TO_RIGHT",
                "int"
            ],
            [
                "DIRECTION_RIGHT_TO_LEFT",
                "int"
            ],
            [
                "DIRECTION_DEFAULT_LEFT_TO_RIGHT",
                "int"
            ],
            [
                "DIRECTION_DEFAULT_RIGHT_TO_LEFT",
                "int"
            ],
            [
                "bidiBase",
                "jdk.internal.icu.text.BidiBase"
            ]
        ],
        "BreakIterator": [
            [
                "DONE",
                "int"
            ],
            [
                "CHARACTER_INDEX",
                "int"
            ],
            [
                "WORD_INDEX",
                "int"
            ],
            [
                "LINE_INDEX",
                "int"
            ],
            [
                "SENTENCE_INDEX",
                "int"
            ],
            [
                "iterCache",
                "java.lang.ref.SoftReference<java.text.BreakIterator$BreakIteratorCache>[]"
            ]
        ],
        "CalendarBuilder": [
            [
                "UNSET",
                "int"
            ],
            [
                "COMPUTED",
                "int"
            ],
            [
                "MINIMUM_USER_STAMP",
                "int"
            ],
            [
                "MAX_FIELD",
                "int"
            ],
            [
                "WEEK_YEAR",
                "int"
            ],
            [
                "ISO_DAY_OF_WEEK",
                "int"
            ],
            [
                "field",
                "int[]"
            ],
            [
                "nextStamp",
                "int"
            ],
            [
                "maxFieldIndex",
                "int"
            ]
        ],
        "CharacterIterator": [
            [
                "DONE",
                "char"
            ]
        ],
        "CharacterIteratorFieldDelegate": [
            [
                "attributedStrings",
                "java.util.ArrayList<java.text.AttributedString>"
            ],
            [
                "size",
                "int"
            ]
        ],
        "ChoiceFormat": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "choiceLimits",
                "double[]"
            ],
            [
                "choiceFormats",
                "java.lang.String[]"
            ]
        ],
        "CollationElementIterator": [
            [
                "NULLORDER",
                "int"
            ],
            [
                "text",
                "jdk.internal.icu.text.NormalizerBase"
            ],
            [
                "buffer",
                "int[]"
            ],
            [
                "expIndex",
                "int"
            ],
            [
                "key",
                "java.lang.StringBuilder"
            ],
            [
                "swapOrder",
                "int"
            ],
            [
                "ordering",
                "java.text.RBCollationTables"
            ],
            [
                "owner",
                "java.text.RuleBasedCollator"
            ]
        ],
        "CollationKey": [
            [
                "source",
                "java.lang.String"
            ]
        ],
        "Collator": [
            [
                "PRIMARY",
                "int"
            ],
            [
                "SECONDARY",
                "int"
            ],
            [
                "TERTIARY",
                "int"
            ],
            [
                "IDENTICAL",
                "int"
            ],
            [
                "NO_DECOMPOSITION",
                "int"
            ],
            [
                "CANONICAL_DECOMPOSITION",
                "int"
            ],
            [
                "FULL_DECOMPOSITION",
                "int"
            ],
            [
                "strength",
                "int"
            ],
            [
                "decmp",
                "int"
            ],
            [
                "cache",
                "java.lang.ref.SoftReference<java.text.Collator>>"
            ]
        ],
        "CompactNumberFormat": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "compactPatterns",
                "java.lang.String[]"
            ],
            [
                "positivePrefixPatterns",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "negativePrefixPatterns",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "positiveSuffixPatterns",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "negativeSuffixPatterns",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "divisors",
                "java.util.List<java.lang.Number>"
            ],
            [
                "placeHolderPatterns",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "symbols",
                "java.text.DecimalFormatSymbols"
            ],
            [
                "decimalPattern",
                "java.lang.String"
            ],
            [
                "decimalFormat",
                "java.text.DecimalFormat"
            ],
            [
                "defaultDecimalFormat",
                "java.text.DecimalFormat"
            ],
            [
                "groupingSize",
                "byte"
            ],
            [
                "parseBigDecimal",
                "boolean"
            ],
            [
                "roundingMode",
                "java.math.RoundingMode"
            ],
            [
                "pluralRules",
                "java.lang.String"
            ],
            [
                "parseStrict",
                "boolean"
            ],
            [
                "rulesMap",
                "java.lang.String>"
            ],
            [
                "numberPattern",
                "java.util.regex.Pattern"
            ],
            [
                "SPECIAL_PATTERN",
                "java.lang.String"
            ],
            [
                "RANGE_MULTIPLIER",
                "int"
            ],
            [
                "PLURALS",
                "java.util.regex.Pattern"
            ],
            [
                "COUNT_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "EXPR",
                "java.lang.String"
            ],
            [
                "RELATION",
                "java.lang.String"
            ],
            [
                "VALUE_RANGE",
                "java.lang.String"
            ],
            [
                "CONDITION",
                "java.lang.String"
            ],
            [
                "PLURALRULES_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "digitList",
                "java.text.DigitList"
            ],
            [
                "STATUS_INFINITE",
                "int"
            ],
            [
                "STATUS_POSITIVE",
                "int"
            ],
            [
                "STATUS_LENGTH",
                "int"
            ],
            [
                "ZERO_DIGIT",
                "char"
            ],
            [
                "DIGIT",
                "char"
            ],
            [
                "DECIMAL_SEPARATOR",
                "char"
            ],
            [
                "GROUPING_SEPARATOR",
                "char"
            ],
            [
                "MINUS_SIGN",
                "char"
            ],
            [
                "PERCENT",
                "char"
            ],
            [
                "PER_MILLE",
                "char"
            ],
            [
                "SEPARATOR",
                "char"
            ],
            [
                "CURRENCY_SIGN",
                "char"
            ],
            [
                "QUOTE",
                "char"
            ],
            [
                "positivePrefixes",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "negativePrefixes",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "positiveSuffixes",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "negativeSuffixes",
                "java.util.List<java.text.CompactNumberFormat$Patterns>"
            ],
            [
                "NAMED_EXPR",
                "java.lang.String"
            ],
            [
                "NAMED_RELATION",
                "java.lang.String"
            ],
            [
                "NAMED_VALUE_RANGE",
                "java.lang.String"
            ],
            [
                "EXPR_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "RELATION_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "VALUE_RANGE_PATTERN",
                "java.util.regex.Pattern"
            ]
        ],
        "DateFormat": [
            [
                "calendar",
                "java.util.Calendar"
            ],
            [
                "numberFormat",
                "java.text.NumberFormat"
            ],
            [
                "ERA_FIELD",
                "int"
            ],
            [
                "YEAR_FIELD",
                "int"
            ],
            [
                "MONTH_FIELD",
                "int"
            ],
            [
                "DATE_FIELD",
                "int"
            ],
            [
                "HOUR_OF_DAY1_FIELD",
                "int"
            ],
            [
                "HOUR_OF_DAY0_FIELD",
                "int"
            ],
            [
                "MINUTE_FIELD",
                "int"
            ],
            [
                "SECOND_FIELD",
                "int"
            ],
            [
                "MILLISECOND_FIELD",
                "int"
            ],
            [
                "DAY_OF_WEEK_FIELD",
                "int"
            ],
            [
                "DAY_OF_YEAR_FIELD",
                "int"
            ],
            [
                "DAY_OF_WEEK_IN_MONTH_FIELD",
                "int"
            ],
            [
                "WEEK_OF_YEAR_FIELD",
                "int"
            ],
            [
                "WEEK_OF_MONTH_FIELD",
                "int"
            ],
            [
                "AM_PM_FIELD",
                "int"
            ],
            [
                "HOUR1_FIELD",
                "int"
            ],
            [
                "HOUR0_FIELD",
                "int"
            ],
            [
                "TIMEZONE_FIELD",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "FULL",
                "int"
            ],
            [
                "LONG",
                "int"
            ],
            [
                "MEDIUM",
                "int"
            ],
            [
                "SHORT",
                "int"
            ],
            [
                "DEFAULT",
                "int"
            ]
        ],
        "DateFormatSymbols": [
            [
                "cachedInstances",
                "java.lang.ref.SoftReference<java.text.DateFormatSymbols>>"
            ],
            [
                "lastZoneIndex",
                "int"
            ]
        ],
        "DecimalFormat": [
            [
                "bigIntegerMultiplier",
                "java.math.BigInteger"
            ],
            [
                "bigDecimalMultiplier",
                "java.math.BigDecimal"
            ],
            [
                "STATUS_INFINITE",
                "int"
            ],
            [
                "STATUS_POSITIVE",
                "int"
            ],
            [
                "STATUS_LENGTH",
                "int"
            ],
            [
                "digitList",
                "java.text.DigitList"
            ],
            [
                "positivePrefix",
                "java.lang.String"
            ],
            [
                "positiveSuffix",
                "java.lang.String"
            ],
            [
                "negativePrefix",
                "java.lang.String"
            ],
            [
                "negativeSuffix",
                "java.lang.String"
            ],
            [
                "posPrefixPattern",
                "java.lang.String"
            ],
            [
                "posSuffixPattern",
                "java.lang.String"
            ],
            [
                "negPrefixPattern",
                "java.lang.String"
            ],
            [
                "negSuffixPattern",
                "java.lang.String"
            ],
            [
                "multiplier",
                "int"
            ],
            [
                "groupingSize",
                "byte"
            ],
            [
                "decimalSeparatorAlwaysShown",
                "boolean"
            ],
            [
                "parseBigDecimal",
                "boolean"
            ],
            [
                "isCurrencyFormat",
                "boolean"
            ],
            [
                "symbols",
                "java.text.DecimalFormatSymbols"
            ],
            [
                "useExponentialNotation",
                "boolean"
            ],
            [
                "parseStrict",
                "boolean"
            ],
            [
                "positivePrefixFieldPositions",
                "java.text.FieldPosition[]"
            ],
            [
                "positiveSuffixFieldPositions",
                "java.text.FieldPosition[]"
            ],
            [
                "negativePrefixFieldPositions",
                "java.text.FieldPosition[]"
            ],
            [
                "negativeSuffixFieldPositions",
                "java.text.FieldPosition[]"
            ],
            [
                "minExponentDigits",
                "byte"
            ],
            [
                "maximumIntegerDigits",
                "int"
            ],
            [
                "minimumIntegerDigits",
                "int"
            ],
            [
                "maximumFractionDigits",
                "int"
            ],
            [
                "minimumFractionDigits",
                "int"
            ],
            [
                "roundingMode",
                "java.math.RoundingMode"
            ],
            [
                "isFastPath",
                "boolean"
            ],
            [
                "fastPathCheckNeeded",
                "boolean"
            ],
            [
                "fastPathData",
                "java.text.DecimalFormat$FastPathData"
            ],
            [
                "serialVersionOnStream",
                "int"
            ],
            [
                "MAX_INT_AS_DOUBLE",
                "double"
            ],
            [
                "PATTERN_ZERO_DIGIT",
                "char"
            ],
            [
                "PATTERN_GROUPING_SEPARATOR",
                "char"
            ],
            [
                "PATTERN_DECIMAL_SEPARATOR",
                "char"
            ],
            [
                "PATTERN_PER_MILLE",
                "char"
            ],
            [
                "PATTERN_PERCENT",
                "char"
            ],
            [
                "PATTERN_DIGIT",
                "char"
            ],
            [
                "PATTERN_SEPARATOR",
                "char"
            ],
            [
                "PATTERN_EXPONENT",
                "java.lang.String"
            ],
            [
                "PATTERN_MINUS",
                "char"
            ],
            [
                "CURRENCY_SIGN",
                "char"
            ],
            [
                "QUOTE",
                "char"
            ],
            [
                "EmptyFieldPositionArray",
                "java.text.FieldPosition[]"
            ]
        ],
        "DecimalFormatSymbols": [
            [
                "zeroDigit",
                "char"
            ],
            [
                "groupingSeparator",
                "char"
            ],
            [
                "decimalSeparator",
                "char"
            ],
            [
                "perMill",
                "char"
            ],
            [
                "percent",
                "char"
            ],
            [
                "digit",
                "char"
            ],
            [
                "patternSeparator",
                "char"
            ],
            [
                "infinity",
                "java.lang.String"
            ],
            [
                "NaN",
                "java.lang.String"
            ],
            [
                "minusSign",
                "char"
            ],
            [
                "currencySymbol",
                "java.lang.String"
            ],
            [
                "intlCurrencySymbol",
                "java.lang.String"
            ],
            [
                "monetarySeparator",
                "char"
            ],
            [
                "exponential",
                "char"
            ],
            [
                "exponentialSeparator",
                "java.lang.String"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "perMillText",
                "java.lang.String"
            ],
            [
                "percentText",
                "java.lang.String"
            ],
            [
                "minusSignText",
                "java.lang.String"
            ],
            [
                "monetaryGroupingSeparator",
                "char"
            ],
            [
                "currency",
                "java.util.Currency"
            ],
            [
                "currencyInitialized",
                "boolean"
            ],
            [
                "hashCode",
                "int"
            ],
            [
                "currentSerialVersion",
                "int"
            ],
            [
                "serialVersionOnStream",
                "int"
            ]
        ],
        "DigitList": [
            [
                "MAX_COUNT",
                "int"
            ],
            [
                "decimalAt",
                "int"
            ],
            [
                "count",
                "int"
            ],
            [
                "digits",
                "char[]"
            ],
            [
                "data",
                "char[]"
            ],
            [
                "roundingMode",
                "java.math.RoundingMode"
            ],
            [
                "isNegative",
                "boolean"
            ],
            [
                "LONG_MIN_REP",
                "char[]"
            ],
            [
                "tempBuilder",
                "java.lang.StringBuilder"
            ]
        ],
        "DontCareFieldPosition": [
            [
                "noDelegate",
                "java.text.Format$FieldDelegate"
            ]
        ],
        "EntryPair": [
            [
                "entryName",
                "java.lang.String"
            ],
            [
                "value",
                "int"
            ],
            [
                "fwd",
                "boolean"
            ]
        ],
        "FieldPosition": [
            [
                "attribute",
                "java.text.Format$Field"
            ]
        ],
        "Format": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ListFormat": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "START",
                "int"
            ],
            [
                "MIDDLE",
                "int"
            ],
            [
                "END",
                "int"
            ],
            [
                "TWO",
                "int"
            ],
            [
                "THREE",
                "int"
            ],
            [
                "PATTERN_ARRAY_LENGTH",
                "int"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "patterns",
                "java.lang.String[]"
            ],
            [
                "PARSE_START",
                "java.util.regex.Pattern"
            ],
            [
                "PARSE_MIDDLE",
                "java.util.regex.Pattern"
            ],
            [
                "PARSE_END",
                "java.util.regex.Pattern"
            ],
            [
                "PARSE_TWO",
                "java.util.regex.Pattern"
            ],
            [
                "PARSE_THREE",
                "java.util.regex.Pattern"
            ],
            [
                "startPattern",
                "java.util.regex.Pattern"
            ],
            [
                "middleBetween",
                "java.lang.String"
            ],
            [
                "endPattern",
                "java.util.regex.Pattern"
            ]
        ],
        "MergeCollation": [
            [
                "saveEntry",
                "java.text.PatternEntry"
            ],
            [
                "lastEntry",
                "java.text.PatternEntry"
            ],
            [
                "excess",
                "java.lang.StringBuilder"
            ],
            [
                "statusArray",
                "byte[]"
            ],
            [
                "BITARRAYMASK",
                "byte"
            ],
            [
                "BYTEPOWER",
                "int"
            ],
            [
                "BYTEMASK",
                "int"
            ]
        ],
        "MessageFormat": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "pattern",
                "java.lang.String"
            ],
            [
                "INITIAL_FORMATS",
                "int"
            ],
            [
                "formats",
                "java.text.Format[]"
            ],
            [
                "offsets",
                "int[]"
            ],
            [
                "argumentNumbers",
                "int[]"
            ],
            [
                "MAX_ARGUMENT_INDEX",
                "int"
            ],
            [
                "maxOffset",
                "int"
            ],
            [
                "SEG_RAW",
                "int"
            ],
            [
                "SEG_INDEX",
                "int"
            ],
            [
                "SEG_TYPE",
                "int"
            ],
            [
                "SEG_MODIFIER",
                "int"
            ]
        ],
        "Normalizer": [],
        "NumberFormat": [
            [
                "INTEGER_FIELD",
                "int"
            ],
            [
                "FRACTION_FIELD",
                "int"
            ],
            [
                "NUMBERSTYLE",
                "int"
            ],
            [
                "CURRENCYSTYLE",
                "int"
            ],
            [
                "PERCENTSTYLE",
                "int"
            ],
            [
                "SCIENTIFICSTYLE",
                "int"
            ],
            [
                "INTEGERSTYLE",
                "int"
            ],
            [
                "COMPACTSTYLE",
                "int"
            ],
            [
                "groupingUsed",
                "boolean"
            ],
            [
                "maxIntegerDigits",
                "byte"
            ],
            [
                "minIntegerDigits",
                "byte"
            ],
            [
                "maxFractionDigits",
                "byte"
            ],
            [
                "minFractionDigits",
                "byte"
            ],
            [
                "parseIntegerOnly",
                "boolean"
            ],
            [
                "maximumIntegerDigits",
                "int"
            ],
            [
                "minimumIntegerDigits",
                "int"
            ],
            [
                "maximumFractionDigits",
                "int"
            ],
            [
                "minimumFractionDigits",
                "int"
            ],
            [
                "serialVersionOnStream",
                "int"
            ]
        ],
        "ParseException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "errorOffset",
                "int"
            ]
        ],
        "ParsePosition": [],
        "PatternEntry": [],
        "RBCollationTables": [
            [
                "rules",
                "java.lang.String"
            ],
            [
                "frenchSec",
                "boolean"
            ],
            [
                "seAsianSwapping",
                "boolean"
            ],
            [
                "mapping",
                "sun.text.UCompactIntArray"
            ],
            [
                "contractTable",
                "java.util.Vector<java.util.Vector<java.text.EntryPair>>"
            ],
            [
                "expandTable",
                "java.util.Vector<int[]>"
            ],
            [
                "contractFlags",
                "sun.text.IntHashtable"
            ],
            [
                "maxSecOrder",
                "short"
            ],
            [
                "maxTerOrder",
                "short"
            ]
        ],
        "RBTableBuilder": [
            [
                "IGNORABLEMASK",
                "int"
            ],
            [
                "PRIMARYORDERINCREMENT",
                "int"
            ],
            [
                "SECONDARYORDERINCREMENT",
                "int"
            ],
            [
                "TERTIARYORDERINCREMENT",
                "int"
            ],
            [
                "INITIALTABLESIZE",
                "int"
            ],
            [
                "MAXKEYSIZE",
                "int"
            ],
            [
                "tables",
                "java.text.RBCollationTables$BuildAPI"
            ],
            [
                "mPattern",
                "java.text.MergeCollation"
            ],
            [
                "isOverIgnore",
                "boolean"
            ],
            [
                "keyBuf",
                "char[]"
            ],
            [
                "contractFlags",
                "sun.text.IntHashtable"
            ],
            [
                "frenchSec",
                "boolean"
            ],
            [
                "seAsianSwapping",
                "boolean"
            ],
            [
                "mapping",
                "sun.text.UCompactIntArray"
            ],
            [
                "contractTable",
                "java.util.Vector<java.util.Vector<java.text.EntryPair>>"
            ],
            [
                "expandTable",
                "java.util.Vector<int[]>"
            ],
            [
                "maxSecOrder",
                "short"
            ],
            [
                "maxTerOrder",
                "short"
            ]
        ],
        "RuleBasedCollationKey": [
            [
                "key",
                "java.lang.String"
            ]
        ],
        "RuleBasedCollator": [
            [
                "COLLATIONKEYOFFSET",
                "int"
            ],
            [
                "tables",
                "java.text.RBCollationTables"
            ],
            [
                "primResult",
                "java.lang.StringBuilder"
            ],
            [
                "secResult",
                "java.lang.StringBuilder"
            ],
            [
                "terResult",
                "java.lang.StringBuilder"
            ],
            [
                "sourceCursor",
                "java.text.CollationElementIterator"
            ],
            [
                "targetCursor",
                "java.text.CollationElementIterator"
            ]
        ],
        "SimpleDateFormat": [
            [
                "serialVersionOnStream",
                "int"
            ],
            [
                "pattern",
                "java.lang.String"
            ],
            [
                "originalNumberFormat",
                "java.text.NumberFormat"
            ],
            [
                "originalNumberPattern",
                "java.lang.String"
            ],
            [
                "minusSign",
                "char"
            ],
            [
                "hasFollowingMinusSign",
                "boolean"
            ],
            [
                "forceStandaloneForm",
                "boolean"
            ],
            [
                "compiledPattern",
                "char[]"
            ],
            [
                "TAG_QUOTE_ASCII_CHAR",
                "int"
            ],
            [
                "TAG_QUOTE_CHARS",
                "int"
            ],
            [
                "zeroDigit",
                "char"
            ],
            [
                "formatData",
                "java.text.DateFormatSymbols"
            ],
            [
                "defaultCenturyStart",
                "java.util.Date"
            ],
            [
                "defaultCenturyStartYear",
                "int"
            ],
            [
                "MILLIS_PER_MINUTE",
                "int"
            ],
            [
                "GMT",
                "java.lang.String"
            ],
            [
                "cachedNumberFormatData",
                "java.text.NumberFormat>"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "PATTERN_INDEX_TO_CALENDAR_FIELD",
                "int[]"
            ],
            [
                "PATTERN_INDEX_TO_DATE_FORMAT_FIELD",
                "int[]"
            ],
            [
                "PATTERN_INDEX_TO_DATE_FORMAT_FIELD_ID",
                "java.text.DateFormat$Field[]"
            ],
            [
                "REST_OF_STYLES",
                "int[]"
            ]
        ],
        "StringBufFactory": [],
        "StringCharacterIterator": [
            [
                "text",
                "java.lang.String"
            ],
            [
                "begin",
                "int"
            ],
            [
                "end",
                "int"
            ],
            [
                "pos",
                "int"
            ]
        ]
    },
    "java.text.spi": {
        "BreakIteratorProvider": [],
        "CollatorProvider": [],
        "DateFormatProvider": [],
        "DateFormatSymbolsProvider": [],
        "DecimalFormatSymbolsProvider": [],
        "NumberFormatProvider": []
    },
    "java.time": {
        "Clock": [
            [
                "OFFSET_SEED",
                "long"
            ],
            [
                "offset",
                "long"
            ]
        ],
        "DateTimeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DayOfWeek": [
            [
                "MONDAY",
                "java.time.DayOfWeek"
            ],
            [
                "TUESDAY",
                "java.time.DayOfWeek"
            ],
            [
                "WEDNESDAY",
                "java.time.DayOfWeek"
            ],
            [
                "THURSDAY",
                "java.time.DayOfWeek"
            ],
            [
                "FRIDAY",
                "java.time.DayOfWeek"
            ],
            [
                "SATURDAY",
                "java.time.DayOfWeek"
            ],
            [
                "SUNDAY",
                "java.time.DayOfWeek"
            ],
            [
                "ENUMS",
                "java.time.DayOfWeek[]"
            ],
            [
                "$VALUES",
                "java.time.DayOfWeek[]"
            ]
        ],
        "Duration": [
            [
                "ZERO",
                "java.time.Duration"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "BI_NANOS_PER_SECOND",
                "java.math.BigInteger"
            ],
            [
                "seconds",
                "long"
            ],
            [
                "nanos",
                "int"
            ]
        ],
        "Instant": [
            [
                "EPOCH",
                "java.time.Instant"
            ],
            [
                "MIN_SECOND",
                "long"
            ],
            [
                "MAX_SECOND",
                "long"
            ],
            [
                "MIN",
                "java.time.Instant"
            ],
            [
                "MAX",
                "java.time.Instant"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "seconds",
                "long"
            ],
            [
                "nanos",
                "int"
            ]
        ],
        "InstantSource": [],
        "LocalDate": [
            [
                "MIN",
                "java.time.LocalDate"
            ],
            [
                "MAX",
                "java.time.LocalDate"
            ],
            [
                "EPOCH",
                "java.time.LocalDate"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "DAYS_PER_CYCLE",
                "int"
            ],
            [
                "year",
                "int"
            ],
            [
                "month",
                "short"
            ],
            [
                "day",
                "short"
            ]
        ],
        "LocalDateTime": [
            [
                "MIN",
                "java.time.LocalDateTime"
            ],
            [
                "MAX",
                "java.time.LocalDateTime"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "date",
                "java.time.LocalDate"
            ],
            [
                "time",
                "java.time.LocalTime"
            ]
        ],
        "LocalTime": [
            [
                "MIN",
                "java.time.LocalTime"
            ],
            [
                "MAX",
                "java.time.LocalTime"
            ],
            [
                "MIDNIGHT",
                "java.time.LocalTime"
            ],
            [
                "NOON",
                "java.time.LocalTime"
            ],
            [
                "HOURS",
                "java.time.LocalTime[]"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "hour",
                "byte"
            ],
            [
                "minute",
                "byte"
            ],
            [
                "second",
                "byte"
            ],
            [
                "nano",
                "int"
            ]
        ],
        "Month": [
            [
                "JANUARY",
                "java.time.Month"
            ],
            [
                "FEBRUARY",
                "java.time.Month"
            ],
            [
                "MARCH",
                "java.time.Month"
            ],
            [
                "APRIL",
                "java.time.Month"
            ],
            [
                "MAY",
                "java.time.Month"
            ],
            [
                "JUNE",
                "java.time.Month"
            ],
            [
                "JULY",
                "java.time.Month"
            ],
            [
                "AUGUST",
                "java.time.Month"
            ],
            [
                "SEPTEMBER",
                "java.time.Month"
            ],
            [
                "OCTOBER",
                "java.time.Month"
            ],
            [
                "NOVEMBER",
                "java.time.Month"
            ],
            [
                "DECEMBER",
                "java.time.Month"
            ],
            [
                "ENUMS",
                "java.time.Month[]"
            ],
            [
                "$VALUES",
                "java.time.Month[]"
            ]
        ],
        "MonthDay": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "PARSER",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "month",
                "int"
            ],
            [
                "day",
                "int"
            ]
        ],
        "OffsetDateTime": [
            [
                "MIN",
                "java.time.OffsetDateTime"
            ],
            [
                "MAX",
                "java.time.OffsetDateTime"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "dateTime",
                "java.time.LocalDateTime"
            ],
            [
                "offset",
                "java.time.ZoneOffset"
            ]
        ],
        "OffsetTime": [
            [
                "MIN",
                "java.time.OffsetTime"
            ],
            [
                "MAX",
                "java.time.OffsetTime"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "time",
                "java.time.LocalTime"
            ],
            [
                "offset",
                "java.time.ZoneOffset"
            ]
        ],
        "Period": [
            [
                "ZERO",
                "java.time.Period"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "SUPPORTED_UNITS",
                "java.util.List<java.time.temporal.TemporalUnit>"
            ],
            [
                "years",
                "int"
            ],
            [
                "months",
                "int"
            ],
            [
                "days",
                "int"
            ]
        ],
        "Ser": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "byte"
            ],
            [
                "object",
                "java.io.Serializable"
            ]
        ],
        "Year": [
            [
                "MIN_VALUE",
                "int"
            ],
            [
                "MAX_VALUE",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "PARSER",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "year",
                "int"
            ]
        ],
        "YearMonth": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "PARSER",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "year",
                "int"
            ],
            [
                "month",
                "int"
            ]
        ],
        "ZoneId": [
            [
                "SHORT_IDS",
                "java.lang.String>"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ZoneOffset": [
            [
                "SECONDS_CACHE",
                "java.time.ZoneOffset>"
            ],
            [
                "ID_CACHE",
                "java.time.ZoneOffset>"
            ],
            [
                "MAX_SECONDS",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "UTC",
                "java.time.ZoneOffset"
            ],
            [
                "MIN",
                "java.time.ZoneOffset"
            ],
            [
                "MAX",
                "java.time.ZoneOffset"
            ],
            [
                "totalSeconds",
                "int"
            ],
            [
                "id",
                "java.lang.String"
            ],
            [
                "rules",
                "java.time.zone.ZoneRules"
            ]
        ],
        "ZoneRegion": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "id",
                "java.lang.String"
            ],
            [
                "rules",
                "java.time.zone.ZoneRules"
            ]
        ],
        "ZonedDateTime": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "dateTime",
                "java.time.LocalDateTime"
            ],
            [
                "offset",
                "java.time.ZoneOffset"
            ],
            [
                "zone",
                "java.time.ZoneId"
            ]
        ]
    },
    "java.time.chrono": {
        "AbstractChronology": [
            [
                "CHRONOS_BY_ID",
                "java.time.chrono.Chronology>"
            ],
            [
                "CHRONOS_BY_TYPE",
                "java.time.chrono.Chronology>"
            ]
        ],
        "ChronoLocalDate": [],
        "ChronoLocalDateImpl": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ChronoLocalDateTime": [],
        "ChronoLocalDateTimeImpl": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "date",
                "D"
            ],
            [
                "time",
                "java.time.LocalTime"
            ]
        ],
        "ChronoPeriod": [],
        "ChronoPeriodImpl": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "SUPPORTED_UNITS",
                "java.util.List<java.time.temporal.TemporalUnit>"
            ],
            [
                "chrono",
                "java.time.chrono.Chronology"
            ]
        ],
        "ChronoZonedDateTime": [],
        "ChronoZonedDateTimeImpl": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "dateTime",
                "java.time.chrono.ChronoLocalDateTimeImpl<D>"
            ],
            [
                "offset",
                "java.time.ZoneOffset"
            ],
            [
                "zone",
                "java.time.ZoneId"
            ]
        ],
        "Chronology": [],
        "Era": [],
        "HijrahChronology": [
            [
                "typeId",
                "java.lang.String"
            ],
            [
                "calendarType",
                "java.lang.String"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "INSTANCE",
                "java.time.chrono.HijrahChronology"
            ],
            [
                "initComplete",
                "boolean"
            ],
            [
                "hijrahEpochMonthStartDays",
                "int[]"
            ],
            [
                "minEpochDay",
                "int"
            ],
            [
                "maxEpochDay",
                "int"
            ],
            [
                "hijrahStartEpochMonth",
                "int"
            ],
            [
                "minMonthLength",
                "int"
            ],
            [
                "maxMonthLength",
                "int"
            ],
            [
                "minYearLength",
                "int"
            ],
            [
                "maxYearLength",
                "int"
            ],
            [
                "RESOURCE_PREFIX",
                "java.lang.String"
            ],
            [
                "RESOURCE_SUFFIX",
                "java.lang.String"
            ],
            [
                "KEY_ID",
                "java.lang.String"
            ],
            [
                "KEY_TYPE",
                "java.lang.String"
            ],
            [
                "KEY_VERSION",
                "java.lang.String"
            ],
            [
                "KEY_ISO_START",
                "java.lang.String"
            ],
            [
                "CONF_PATH",
                "java.nio.file.Path"
            ]
        ],
        "HijrahDate": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "chrono",
                "java.time.chrono.HijrahChronology"
            ],
            [
                "prolepticYear",
                "int"
            ],
            [
                "monthOfYear",
                "int"
            ],
            [
                "dayOfMonth",
                "int"
            ]
        ],
        "HijrahEra": [
            [
                "AH",
                "java.time.chrono.HijrahEra"
            ],
            [
                "$VALUES",
                "java.time.chrono.HijrahEra[]"
            ]
        ],
        "IsoChronology": [
            [
                "INSTANCE",
                "java.time.chrono.IsoChronology"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "DAYS_0000_TO_1970",
                "long"
            ]
        ],
        "IsoEra": [
            [
                "BCE",
                "java.time.chrono.IsoEra"
            ],
            [
                "CE",
                "java.time.chrono.IsoEra"
            ],
            [
                "$VALUES",
                "java.time.chrono.IsoEra[]"
            ]
        ],
        "JapaneseChronology": [
            [
                "INSTANCE",
                "java.time.chrono.JapaneseChronology"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JapaneseDate": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "isoDate",
                "java.time.LocalDate"
            ],
            [
                "era",
                "java.time.chrono.JapaneseEra"
            ],
            [
                "yearOfEra",
                "int"
            ]
        ],
        "JapaneseEra": [
            [
                "MEIJI",
                "java.time.chrono.JapaneseEra"
            ],
            [
                "TAISHO",
                "java.time.chrono.JapaneseEra"
            ],
            [
                "SHOWA",
                "java.time.chrono.JapaneseEra"
            ],
            [
                "HEISEI",
                "java.time.chrono.JapaneseEra"
            ],
            [
                "REIWA",
                "java.time.chrono.JapaneseEra"
            ],
            [
                "N_ERA_CONSTANTS",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "KNOWN_ERAS",
                "java.time.chrono.JapaneseEra[]"
            ],
            [
                "eraValue",
                "int"
            ],
            [
                "since",
                "java.time.LocalDate"
            ]
        ],
        "MinguoChronology": [
            [
                "INSTANCE",
                "java.time.chrono.MinguoChronology"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "MinguoDate": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "isoDate",
                "java.time.LocalDate"
            ]
        ],
        "MinguoEra": [
            [
                "BEFORE_ROC",
                "java.time.chrono.MinguoEra"
            ],
            [
                "ROC",
                "java.time.chrono.MinguoEra"
            ],
            [
                "$VALUES",
                "java.time.chrono.MinguoEra[]"
            ]
        ],
        "Ser": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "byte"
            ],
            [
                "object",
                "java.io.Serializable"
            ]
        ],
        "ThaiBuddhistChronology": [
            [
                "INSTANCE",
                "java.time.chrono.ThaiBuddhistChronology"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ThaiBuddhistDate": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "isoDate",
                "java.time.LocalDate"
            ]
        ],
        "ThaiBuddhistEra": [
            [
                "BEFORE_BE",
                "java.time.chrono.ThaiBuddhistEra"
            ],
            [
                "BE",
                "java.time.chrono.ThaiBuddhistEra"
            ],
            [
                "$VALUES",
                "java.time.chrono.ThaiBuddhistEra[]"
            ]
        ]
    },
    "java.time.format": {
        "DateTimeFormatter": [
            [
                "printerParser",
                "java.time.format.DateTimeFormatterBuilder$CompositePrinterParser"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "decimalStyle",
                "java.time.format.DecimalStyle"
            ],
            [
                "resolverStyle",
                "java.time.format.ResolverStyle"
            ],
            [
                "resolverFields",
                "java.util.Set<java.time.temporal.TemporalField>"
            ],
            [
                "chrono",
                "java.time.chrono.Chronology"
            ],
            [
                "zone",
                "java.time.ZoneId"
            ],
            [
                "ISO_LOCAL_DATE",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_OFFSET_DATE",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_DATE",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_LOCAL_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_OFFSET_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_LOCAL_DATE_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_OFFSET_DATE_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_ZONED_DATE_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_DATE_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_ORDINAL_DATE",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_WEEK_DATE",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "ISO_INSTANT",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "BASIC_ISO_DATE",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "RFC_1123_DATE_TIME",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "PARSED_EXCESS_DAYS",
                "java.time.temporal.TemporalQuery<java.time.Period>"
            ],
            [
                "PARSED_LEAP_SECOND",
                "java.time.temporal.TemporalQuery<java.lang.Boolean>"
            ]
        ],
        "DateTimeFormatterBuilder": [
            [
                "QUERY_REGION_ONLY",
                "java.time.temporal.TemporalQuery<java.time.ZoneId>"
            ],
            [
                "active",
                "java.time.format.DateTimeFormatterBuilder"
            ],
            [
                "parent",
                "java.time.format.DateTimeFormatterBuilder"
            ],
            [
                "printerParsers",
                "java.util.List<java.time.format.DateTimeFormatterBuilder$DateTimePrinterParser>"
            ],
            [
                "optional",
                "boolean"
            ],
            [
                "padNextWidth",
                "int"
            ],
            [
                "padNextChar",
                "char"
            ],
            [
                "valueParserIndex",
                "int"
            ],
            [
                "VALID_TEMPLATE_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "FIELD_MAP",
                "java.time.temporal.TemporalField>"
            ]
        ],
        "DateTimeParseContext": [
            [
                "formatter",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "caseSensitive",
                "boolean"
            ],
            [
                "strict",
                "boolean"
            ],
            [
                "parsed",
                "java.util.ArrayList<java.time.format.Parsed>"
            ],
            [
                "chronoListeners",
                "java.util.ArrayList<java.util.function.Consumer<java.time.chrono.Chronology>>"
            ]
        ],
        "DateTimeParseException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "parsedString",
                "java.lang.String"
            ],
            [
                "errorIndex",
                "int"
            ]
        ],
        "DateTimePrintContext": [
            [
                "temporal",
                "java.time.temporal.TemporalAccessor"
            ],
            [
                "formatter",
                "java.time.format.DateTimeFormatter"
            ],
            [
                "optional",
                "int"
            ]
        ],
        "DateTimeTextProvider": [
            [
                "CACHE",
                "java.lang.Object>"
            ],
            [
                "COMPARATOR",
                "java.lang.Long>>"
            ],
            [
                "INSTANCE",
                "java.time.format.DateTimeTextProvider"
            ]
        ],
        "DecimalStyle": [
            [
                "STANDARD",
                "java.time.format.DecimalStyle"
            ],
            [
                "CACHE",
                "java.time.format.DecimalStyle>"
            ],
            [
                "zeroDigit",
                "char"
            ],
            [
                "positiveSign",
                "char"
            ],
            [
                "negativeSign",
                "char"
            ],
            [
                "decimalSeparator",
                "char"
            ]
        ],
        "FormatStyle": [
            [
                "FULL",
                "java.time.format.FormatStyle"
            ],
            [
                "LONG",
                "java.time.format.FormatStyle"
            ],
            [
                "MEDIUM",
                "java.time.format.FormatStyle"
            ],
            [
                "SHORT",
                "java.time.format.FormatStyle"
            ],
            [
                "$VALUES",
                "java.time.format.FormatStyle[]"
            ]
        ],
        "Parsed": [
            [
                "resolverStyle",
                "java.time.format.ResolverStyle"
            ],
            [
                "date",
                "java.time.chrono.ChronoLocalDate"
            ],
            [
                "time",
                "java.time.LocalTime"
            ]
        ],
        "ResolverStyle": [
            [
                "STRICT",
                "java.time.format.ResolverStyle"
            ],
            [
                "SMART",
                "java.time.format.ResolverStyle"
            ],
            [
                "LENIENT",
                "java.time.format.ResolverStyle"
            ],
            [
                "$VALUES",
                "java.time.format.ResolverStyle[]"
            ]
        ],
        "SignStyle": [
            [
                "NORMAL",
                "java.time.format.SignStyle"
            ],
            [
                "ALWAYS",
                "java.time.format.SignStyle"
            ],
            [
                "NEVER",
                "java.time.format.SignStyle"
            ],
            [
                "NOT_NEGATIVE",
                "java.time.format.SignStyle"
            ],
            [
                "EXCEEDS_PAD",
                "java.time.format.SignStyle"
            ],
            [
                "$VALUES",
                "java.time.format.SignStyle[]"
            ]
        ],
        "TextStyle": [
            [
                "FULL",
                "java.time.format.TextStyle"
            ],
            [
                "FULL_STANDALONE",
                "java.time.format.TextStyle"
            ],
            [
                "SHORT",
                "java.time.format.TextStyle"
            ],
            [
                "SHORT_STANDALONE",
                "java.time.format.TextStyle"
            ],
            [
                "NARROW",
                "java.time.format.TextStyle"
            ],
            [
                "NARROW_STANDALONE",
                "java.time.format.TextStyle"
            ],
            [
                "calendarStyle",
                "int"
            ],
            [
                "zoneNameStyleIndex",
                "int"
            ],
            [
                "$VALUES",
                "java.time.format.TextStyle[]"
            ]
        ],
        "ZoneName": [
            [
                "zidMap",
                "java.lang.String[]"
            ],
            [
                "mzoneMap",
                "java.lang.String[]"
            ],
            [
                "aliasMap",
                "java.lang.String[]"
            ],
            [
                "zidToMzone",
                "java.lang.String>"
            ],
            [
                "mzoneToZid",
                "java.lang.String>"
            ],
            [
                "mzoneToZidL",
                "java.lang.String>>"
            ],
            [
                "aliases",
                "java.lang.String>"
            ]
        ]
    },
    "java.time.temporal": {
        "ChronoField": [
            [
                "NANO_OF_SECOND",
                "java.time.temporal.ChronoField"
            ],
            [
                "NANO_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "MICRO_OF_SECOND",
                "java.time.temporal.ChronoField"
            ],
            [
                "MICRO_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "MILLI_OF_SECOND",
                "java.time.temporal.ChronoField"
            ],
            [
                "MILLI_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "SECOND_OF_MINUTE",
                "java.time.temporal.ChronoField"
            ],
            [
                "SECOND_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "MINUTE_OF_HOUR",
                "java.time.temporal.ChronoField"
            ],
            [
                "MINUTE_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "HOUR_OF_AMPM",
                "java.time.temporal.ChronoField"
            ],
            [
                "CLOCK_HOUR_OF_AMPM",
                "java.time.temporal.ChronoField"
            ],
            [
                "HOUR_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "CLOCK_HOUR_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "AMPM_OF_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "DAY_OF_WEEK",
                "java.time.temporal.ChronoField"
            ],
            [
                "ALIGNED_DAY_OF_WEEK_IN_MONTH",
                "java.time.temporal.ChronoField"
            ],
            [
                "ALIGNED_DAY_OF_WEEK_IN_YEAR",
                "java.time.temporal.ChronoField"
            ],
            [
                "DAY_OF_MONTH",
                "java.time.temporal.ChronoField"
            ],
            [
                "DAY_OF_YEAR",
                "java.time.temporal.ChronoField"
            ],
            [
                "EPOCH_DAY",
                "java.time.temporal.ChronoField"
            ],
            [
                "ALIGNED_WEEK_OF_MONTH",
                "java.time.temporal.ChronoField"
            ],
            [
                "ALIGNED_WEEK_OF_YEAR",
                "java.time.temporal.ChronoField"
            ],
            [
                "MONTH_OF_YEAR",
                "java.time.temporal.ChronoField"
            ],
            [
                "PROLEPTIC_MONTH",
                "java.time.temporal.ChronoField"
            ],
            [
                "YEAR_OF_ERA",
                "java.time.temporal.ChronoField"
            ],
            [
                "YEAR",
                "java.time.temporal.ChronoField"
            ],
            [
                "ERA",
                "java.time.temporal.ChronoField"
            ],
            [
                "INSTANT_SECONDS",
                "java.time.temporal.ChronoField"
            ],
            [
                "OFFSET_SECONDS",
                "java.time.temporal.ChronoField"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "baseUnit",
                "java.time.temporal.TemporalUnit"
            ],
            [
                "rangeUnit",
                "java.time.temporal.TemporalUnit"
            ],
            [
                "range",
                "java.time.temporal.ValueRange"
            ],
            [
                "displayNameKey",
                "java.lang.String"
            ],
            [
                "$VALUES",
                "java.time.temporal.ChronoField[]"
            ]
        ],
        "ChronoUnit": [
            [
                "NANOS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "MICROS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "MILLIS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "SECONDS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "MINUTES",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "HOURS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "HALF_DAYS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "DAYS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "WEEKS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "MONTHS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "YEARS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "DECADES",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "CENTURIES",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "MILLENNIA",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "ERAS",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "FOREVER",
                "java.time.temporal.ChronoUnit"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "duration",
                "java.time.Duration"
            ],
            [
                "$VALUES",
                "java.time.temporal.ChronoUnit[]"
            ]
        ],
        "IsoFields": [
            [
                "DAY_OF_QUARTER",
                "java.time.temporal.TemporalField"
            ],
            [
                "QUARTER_OF_YEAR",
                "java.time.temporal.TemporalField"
            ],
            [
                "WEEK_OF_WEEK_BASED_YEAR",
                "java.time.temporal.TemporalField"
            ],
            [
                "WEEK_BASED_YEAR",
                "java.time.temporal.TemporalField"
            ],
            [
                "WEEK_BASED_YEARS",
                "java.time.temporal.TemporalUnit"
            ],
            [
                "QUARTER_YEARS",
                "java.time.temporal.TemporalUnit"
            ]
        ],
        "JulianFields": [
            [
                "JULIAN_DAY_OFFSET",
                "long"
            ],
            [
                "JULIAN_DAY",
                "java.time.temporal.TemporalField"
            ],
            [
                "MODIFIED_JULIAN_DAY",
                "java.time.temporal.TemporalField"
            ],
            [
                "RATA_DIE",
                "java.time.temporal.TemporalField"
            ]
        ],
        "Temporal": [],
        "TemporalAccessor": [],
        "TemporalAdjuster": [],
        "TemporalAdjusters": [],
        "TemporalAmount": [],
        "TemporalField": [],
        "TemporalQueries": [],
        "TemporalQuery": [],
        "TemporalUnit": [],
        "UnsupportedTemporalTypeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ValueRange": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "minSmallest",
                "long"
            ],
            [
                "minLargest",
                "long"
            ],
            [
                "maxSmallest",
                "long"
            ],
            [
                "maxLargest",
                "long"
            ]
        ],
        "WeekFields": [
            [
                "CACHE",
                "java.time.temporal.WeekFields>"
            ],
            [
                "ISO",
                "java.time.temporal.WeekFields"
            ],
            [
                "SUNDAY_START",
                "java.time.temporal.WeekFields"
            ],
            [
                "WEEK_BASED_YEARS",
                "java.time.temporal.TemporalUnit"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "firstDayOfWeek",
                "java.time.DayOfWeek"
            ],
            [
                "minimalDays",
                "int"
            ],
            [
                "dayOfWeek",
                "java.time.temporal.TemporalField"
            ],
            [
                "weekOfMonth",
                "java.time.temporal.TemporalField"
            ],
            [
                "weekOfYear",
                "java.time.temporal.TemporalField"
            ],
            [
                "weekOfWeekBasedYear",
                "java.time.temporal.TemporalField"
            ],
            [
                "weekBasedYear",
                "java.time.temporal.TemporalField"
            ]
        ]
    },
    "java.time.zone": {
        "Ser": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "type",
                "byte"
            ],
            [
                "object",
                "java.io.Serializable"
            ]
        ],
        "TzdbZoneRulesProvider": [
            [
                "regionIds",
                "java.util.List<java.lang.String>"
            ],
            [
                "versionId",
                "java.lang.String"
            ],
            [
                "regionToRules",
                "java.lang.Object>"
            ]
        ],
        "ZoneOffsetTransition": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "epochSecond",
                "long"
            ],
            [
                "transition",
                "java.time.LocalDateTime"
            ],
            [
                "offsetBefore",
                "java.time.ZoneOffset"
            ],
            [
                "offsetAfter",
                "java.time.ZoneOffset"
            ]
        ],
        "ZoneOffsetTransitionRule": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "month",
                "java.time.Month"
            ],
            [
                "dom",
                "byte"
            ],
            [
                "dow",
                "java.time.DayOfWeek"
            ],
            [
                "time",
                "java.time.LocalTime"
            ],
            [
                "timeEndOfDay",
                "boolean"
            ],
            [
                "timeDefinition",
                "java.time.zone.ZoneOffsetTransitionRule$TimeDefinition"
            ],
            [
                "standardOffset",
                "java.time.ZoneOffset"
            ],
            [
                "offsetBefore",
                "java.time.ZoneOffset"
            ],
            [
                "offsetAfter",
                "java.time.ZoneOffset"
            ]
        ],
        "ZoneRules": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "LAST_CACHED_YEAR",
                "int"
            ],
            [
                "standardTransitions",
                "long[]"
            ],
            [
                "standardOffsets",
                "java.time.ZoneOffset[]"
            ],
            [
                "savingsInstantTransitions",
                "long[]"
            ],
            [
                "savingsLocalTransitions",
                "java.time.LocalDateTime[]"
            ],
            [
                "wallOffsets",
                "java.time.ZoneOffset[]"
            ],
            [
                "lastRules",
                "java.time.zone.ZoneOffsetTransitionRule[]"
            ],
            [
                "lastRulesCache",
                "java.time.zone.ZoneOffsetTransition[]>"
            ],
            [
                "EMPTY_LONG_ARRAY",
                "long[]"
            ],
            [
                "EMPTY_LASTRULES",
                "java.time.zone.ZoneOffsetTransitionRule[]"
            ],
            [
                "EMPTY_LDT_ARRAY",
                "java.time.LocalDateTime[]"
            ],
            [
                "DAYS_PER_CYCLE",
                "int"
            ],
            [
                "DAYS_0000_TO_1970",
                "long"
            ]
        ],
        "ZoneRulesException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ZoneRulesProvider": [
            [
                "PROVIDERS",
                "java.util.concurrent.CopyOnWriteArrayList<java.time.zone.ZoneRulesProvider>"
            ],
            [
                "ZONES",
                "java.time.zone.ZoneRulesProvider>"
            ],
            [
                "ZONE_IDS",
                "java.util.Set<java.lang.String>"
            ]
        ]
    },
    "java.util": {
        "AbstractCollection": [],
        "AbstractList": [
            [
                "modCount",
                "int"
            ]
        ],
        "AbstractMap": [],
        "AbstractQueue": [],
        "AbstractSequentialList": [],
        "AbstractSet": [],
        "ArrayDeque": [
            [
                "MAX_ARRAY_SIZE",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ArrayList": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "DEFAULT_CAPACITY",
                "int"
            ],
            [
                "EMPTY_ELEMENTDATA",
                "java.lang.Object[]"
            ],
            [
                "DEFAULTCAPACITY_EMPTY_ELEMENTDATA",
                "java.lang.Object[]"
            ],
            [
                "size",
                "int"
            ]
        ],
        "ArrayPrefixHelpers": [],
        "Arrays": [
            [
                "MIN_ARRAY_SORT_GRAN",
                "int"
            ],
            [
                "INSERTIONSORT_THRESHOLD",
                "int"
            ]
        ],
        "ArraysParallelSortHelpers": [],
        "Base64": [],
        "BitSet": [
            [
                "ADDRESS_BITS_PER_WORD",
                "int"
            ],
            [
                "BITS_PER_WORD",
                "int"
            ],
            [
                "BIT_INDEX_MASK",
                "int"
            ],
            [
                "WORD_MASK",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "words",
                "long[]"
            ],
            [
                "wordsInUse",
                "int"
            ],
            [
                "sizeIsSticky",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Calendar": [
            [
                "ERA",
                "int"
            ],
            [
                "YEAR",
                "int"
            ],
            [
                "MONTH",
                "int"
            ],
            [
                "WEEK_OF_YEAR",
                "int"
            ],
            [
                "WEEK_OF_MONTH",
                "int"
            ],
            [
                "DATE",
                "int"
            ],
            [
                "DAY_OF_MONTH",
                "int"
            ],
            [
                "DAY_OF_YEAR",
                "int"
            ],
            [
                "DAY_OF_WEEK",
                "int"
            ],
            [
                "DAY_OF_WEEK_IN_MONTH",
                "int"
            ],
            [
                "AM_PM",
                "int"
            ],
            [
                "HOUR",
                "int"
            ],
            [
                "HOUR_OF_DAY",
                "int"
            ],
            [
                "MINUTE",
                "int"
            ],
            [
                "SECOND",
                "int"
            ],
            [
                "MILLISECOND",
                "int"
            ],
            [
                "ZONE_OFFSET",
                "int"
            ],
            [
                "DST_OFFSET",
                "int"
            ],
            [
                "FIELD_COUNT",
                "int"
            ],
            [
                "SUNDAY",
                "int"
            ],
            [
                "MONDAY",
                "int"
            ],
            [
                "TUESDAY",
                "int"
            ],
            [
                "WEDNESDAY",
                "int"
            ],
            [
                "THURSDAY",
                "int"
            ],
            [
                "FRIDAY",
                "int"
            ],
            [
                "SATURDAY",
                "int"
            ],
            [
                "JANUARY",
                "int"
            ],
            [
                "FEBRUARY",
                "int"
            ],
            [
                "MARCH",
                "int"
            ],
            [
                "APRIL",
                "int"
            ],
            [
                "MAY",
                "int"
            ],
            [
                "JUNE",
                "int"
            ],
            [
                "JULY",
                "int"
            ],
            [
                "AUGUST",
                "int"
            ],
            [
                "SEPTEMBER",
                "int"
            ],
            [
                "OCTOBER",
                "int"
            ],
            [
                "NOVEMBER",
                "int"
            ],
            [
                "DECEMBER",
                "int"
            ],
            [
                "UNDECIMBER",
                "int"
            ],
            [
                "AM",
                "int"
            ],
            [
                "PM",
                "int"
            ],
            [
                "ALL_STYLES",
                "int"
            ],
            [
                "SHORT",
                "int"
            ],
            [
                "LONG",
                "int"
            ],
            [
                "NARROW_FORMAT",
                "int"
            ],
            [
                "NARROW_STANDALONE",
                "int"
            ],
            [
                "SHORT_FORMAT",
                "int"
            ],
            [
                "LONG_FORMAT",
                "int"
            ],
            [
                "SHORT_STANDALONE",
                "int"
            ],
            [
                "LONG_STANDALONE",
                "int"
            ],
            [
                "fields",
                "int[]"
            ],
            [
                "isSet",
                "boolean[]"
            ],
            [
                "stamp",
                "int[]"
            ],
            [
                "time",
                "long"
            ],
            [
                "isTimeSet",
                "boolean"
            ],
            [
                "areFieldsSet",
                "boolean"
            ],
            [
                "lenient",
                "boolean"
            ],
            [
                "zone",
                "java.util.TimeZone"
            ],
            [
                "sharedZone",
                "boolean"
            ],
            [
                "firstDayOfWeek",
                "int"
            ],
            [
                "minimalDaysInFirstWeek",
                "int"
            ],
            [
                "cachedLocaleData",
                "int[]>"
            ],
            [
                "UNSET",
                "int"
            ],
            [
                "COMPUTED",
                "int"
            ],
            [
                "MINIMUM_USER_STAMP",
                "int"
            ],
            [
                "nextStamp",
                "int"
            ],
            [
                "serialVersionOnStream",
                "int"
            ],
            [
                "FIELD_NAME",
                "java.lang.String[]"
            ]
        ],
        "CollSer": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "tag",
                "int"
            ],
            [
                "array",
                "java.lang.Object[]"
            ]
        ],
        "Collection": [],
        "Collections": [
            [
                "BINARYSEARCH_THRESHOLD",
                "int"
            ],
            [
                "REVERSE_THRESHOLD",
                "int"
            ],
            [
                "SHUFFLE_THRESHOLD",
                "int"
            ],
            [
                "FILL_THRESHOLD",
                "int"
            ],
            [
                "ROTATE_THRESHOLD",
                "int"
            ],
            [
                "COPY_THRESHOLD",
                "int"
            ],
            [
                "REPLACEALL_THRESHOLD",
                "int"
            ],
            [
                "INDEXOFSUBLIST_THRESHOLD",
                "int"
            ],
            [
                "r",
                "java.util.Random"
            ],
            [
                "EMPTY_SET",
                "java.util.Set"
            ],
            [
                "EMPTY_LIST",
                "java.util.List"
            ],
            [
                "EMPTY_MAP",
                "java.util.Map"
            ]
        ],
        "ComparableTimSort": [
            [
                "MIN_MERGE",
                "int"
            ],
            [
                "a",
                "java.lang.Object[]"
            ],
            [
                "MIN_GALLOP",
                "int"
            ],
            [
                "minGallop",
                "int"
            ],
            [
                "INITIAL_TMP_STORAGE_LENGTH",
                "int"
            ],
            [
                "tmp",
                "java.lang.Object[]"
            ],
            [
                "tmpBase",
                "int"
            ],
            [
                "tmpLen",
                "int"
            ],
            [
                "stackSize",
                "int"
            ],
            [
                "runBase",
                "int[]"
            ],
            [
                "runLen",
                "int[]"
            ]
        ],
        "Comparator": [],
        "Comparators": [],
        "ConcurrentModificationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Currency": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "currencyCode",
                "java.lang.String"
            ],
            [
                "defaultFractionDigits",
                "int"
            ],
            [
                "numericCode",
                "int"
            ],
            [
                "instances",
                "java.util.Currency>"
            ],
            [
                "available",
                "java.util.HashSet<java.util.Currency>"
            ],
            [
                "MAGIC_NUMBER",
                "int"
            ],
            [
                "A_TO_Z",
                "int"
            ],
            [
                "INVALID_COUNTRY_ENTRY",
                "int"
            ],
            [
                "COUNTRY_WITHOUT_CURRENCY_ENTRY",
                "int"
            ],
            [
                "SIMPLE_CASE_COUNTRY_MASK",
                "int"
            ],
            [
                "SIMPLE_CASE_COUNTRY_FINAL_CHAR_MASK",
                "int"
            ],
            [
                "SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_MASK",
                "int"
            ],
            [
                "SIMPLE_CASE_COUNTRY_DEFAULT_DIGITS_SHIFT",
                "int"
            ],
            [
                "SIMPLE_CASE_COUNTRY_MAX_DEFAULT_DIGITS",
                "int"
            ],
            [
                "SPECIAL_CASE_COUNTRY_MASK",
                "int"
            ],
            [
                "SPECIAL_CASE_COUNTRY_INDEX_MASK",
                "int"
            ],
            [
                "SPECIAL_CASE_COUNTRY_INDEX_DELTA",
                "int"
            ],
            [
                "COUNTRY_TYPE_MASK",
                "int"
            ],
            [
                "NUMERIC_CODE_MASK",
                "int"
            ],
            [
                "NUMERIC_CODE_SHIFT",
                "int"
            ],
            [
                "VALID_FORMAT_VERSION",
                "int"
            ],
            [
                "SYMBOL",
                "int"
            ],
            [
                "DISPLAYNAME",
                "int"
            ]
        ],
        "Date": [
            [
                "gcal",
                "sun.util.calendar.BaseCalendar"
            ],
            [
                "jcal",
                "sun.util.calendar.BaseCalendar"
            ],
            [
                "fastTime",
                "long"
            ],
            [
                "cdate",
                "sun.util.calendar.BaseCalendar$Date"
            ],
            [
                "defaultCenturyStart",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "wtb",
                "java.lang.String[]"
            ],
            [
                "ttb",
                "int[]"
            ]
        ],
        "Deque": [],
        "Dictionary": [],
        "DoubleSummaryStatistics": [
            [
                "count",
                "long"
            ],
            [
                "sum",
                "double"
            ],
            [
                "sumCompensation",
                "double"
            ],
            [
                "simpleSum",
                "double"
            ],
            [
                "min",
                "double"
            ],
            [
                "max",
                "double"
            ]
        ],
        "DualPivotQuicksort": [
            [
                "MAX_MIXED_INSERTION_SORT_SIZE",
                "int"
            ],
            [
                "MAX_INSERTION_SORT_SIZE",
                "int"
            ],
            [
                "MIN_PARALLEL_SORT_SIZE",
                "int"
            ],
            [
                "MIN_TRY_MERGE_SIZE",
                "int"
            ],
            [
                "MIN_FIRST_RUN_SIZE",
                "int"
            ],
            [
                "MIN_FIRST_RUNS_FACTOR",
                "int"
            ],
            [
                "MAX_RUN_CAPACITY",
                "int"
            ],
            [
                "MIN_RUN_COUNT",
                "int"
            ],
            [
                "MIN_PARALLEL_MERGE_PARTS_SIZE",
                "int"
            ],
            [
                "MIN_BYTE_COUNTING_SORT_SIZE",
                "int"
            ],
            [
                "MIN_SHORT_OR_CHAR_COUNTING_SORT_SIZE",
                "int"
            ],
            [
                "DELTA",
                "int"
            ],
            [
                "MAX_RECURSION_DEPTH",
                "int"
            ],
            [
                "NUM_BYTE_VALUES",
                "int"
            ],
            [
                "MAX_BYTE_INDEX",
                "int"
            ],
            [
                "NUM_CHAR_VALUES",
                "int"
            ],
            [
                "NUM_SHORT_VALUES",
                "int"
            ],
            [
                "MAX_SHORT_INDEX",
                "int"
            ]
        ],
        "DuplicateFormatFlagsException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "flags",
                "java.lang.String"
            ]
        ],
        "EmptyStackException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "EnumMap": [
            [
                "keyType",
                "java.lang.Class<K>"
            ],
            [
                "keyUniverse",
                "K[]"
            ],
            [
                "vals",
                "java.lang.Object[]"
            ],
            [
                "size",
                "int"
            ],
            [
                "NULL",
                "java.lang.Object"
            ],
            [
                "entrySet",
                "V>>"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "EnumSet": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Enumeration": [],
        "EventListener": [],
        "EventListenerProxy": [
            [
                "listener",
                "T"
            ]
        ],
        "EventObject": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "source",
                "java.lang.Object"
            ]
        ],
        "FormatFlagsConversionMismatchException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "f",
                "java.lang.String"
            ],
            [
                "c",
                "char"
            ]
        ],
        "Formattable": [],
        "FormattableFlags": [
            [
                "LEFT_JUSTIFY",
                "int"
            ],
            [
                "UPPERCASE",
                "int"
            ],
            [
                "ALTERNATE",
                "int"
            ]
        ],
        "Formatter": [
            [
                "DFS",
                "java.text.DecimalFormatSymbols"
            ],
            [
                "a",
                "java.lang.Appendable"
            ],
            [
                "l",
                "java.util.Locale"
            ],
            [
                "lastException",
                "java.io.IOException"
            ]
        ],
        "FormatterClosedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "GregorianCalendar": [
            [
                "BC",
                "int"
            ],
            [
                "AD",
                "int"
            ],
            [
                "EPOCH_OFFSET",
                "int"
            ],
            [
                "EPOCH_YEAR",
                "int"
            ],
            [
                "ONE_SECOND",
                "int"
            ],
            [
                "ONE_MINUTE",
                "int"
            ],
            [
                "ONE_HOUR",
                "int"
            ],
            [
                "ONE_DAY",
                "long"
            ],
            [
                "ONE_WEEK",
                "long"
            ],
            [
                "gcal",
                "sun.util.calendar.Gregorian"
            ],
            [
                "jcal",
                "sun.util.calendar.JulianCalendar"
            ],
            [
                "jeras",
                "sun.util.calendar.Era[]"
            ],
            [
                "gregorianCutover",
                "long"
            ],
            [
                "gregorianCutoverDate",
                "long"
            ],
            [
                "gregorianCutoverYear",
                "int"
            ],
            [
                "gregorianCutoverYearJulian",
                "int"
            ],
            [
                "gdate",
                "sun.util.calendar.BaseCalendar$Date"
            ],
            [
                "cdate",
                "sun.util.calendar.BaseCalendar$Date"
            ],
            [
                "calsys",
                "sun.util.calendar.BaseCalendar"
            ],
            [
                "zoneOffsets",
                "int[]"
            ],
            [
                "originalFields",
                "int[]"
            ],
            [
                "cachedFixedDate",
                "long"
            ]
        ],
        "HashMap": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "HashSet": [],
        "Hashtable": [
            [
                "table",
                "?>[]"
            ],
            [
                "count",
                "int"
            ],
            [
                "threshold",
                "int"
            ],
            [
                "loadFactor",
                "float"
            ],
            [
                "modCount",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "MAX_ARRAY_SIZE",
                "int"
            ],
            [
                "keySet",
                "java.util.Set<K>"
            ],
            [
                "entrySet",
                "V>>"
            ],
            [
                "values",
                "java.util.Collection<V>"
            ],
            [
                "KEYS",
                "int"
            ],
            [
                "VALUES",
                "int"
            ],
            [
                "ENTRIES",
                "int"
            ]
        ],
        "HexFormat": [
            [
                "jla",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "DIGITS",
                "byte[]"
            ],
            [
                "HEX_FORMAT",
                "java.util.HexFormat"
            ],
            [
                "HEX_UPPER_FORMAT",
                "java.util.HexFormat"
            ],
            [
                "EMPTY_BYTES",
                "byte[]"
            ],
            [
                "delimiter",
                "java.lang.String"
            ],
            [
                "prefix",
                "java.lang.String"
            ],
            [
                "suffix",
                "java.lang.String"
            ],
            [
                "ucase",
                "boolean"
            ]
        ],
        "IdentityHashMap": [
            [
                "DEFAULT_CAPACITY",
                "int"
            ],
            [
                "MINIMUM_CAPACITY",
                "int"
            ],
            [
                "MAXIMUM_CAPACITY",
                "int"
            ],
            [
                "entrySet",
                "V>>"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalFormatArgumentIndexException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "illegalIndex",
                "int"
            ]
        ],
        "IllegalFormatCodePointException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "c",
                "int"
            ]
        ],
        "IllegalFormatConversionException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "c",
                "char"
            ],
            [
                "arg",
                "java.lang.Class<?>"
            ]
        ],
        "IllegalFormatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IllegalFormatFlagsException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "flags",
                "java.lang.String"
            ]
        ],
        "IllegalFormatPrecisionException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "p",
                "int"
            ]
        ],
        "IllegalFormatWidthException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "w",
                "int"
            ]
        ],
        "IllformedLocaleException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "_errIdx",
                "int"
            ]
        ],
        "ImmutableCollections": [
            [
                "SALT32L",
                "long"
            ],
            [
                "REVERSE",
                "boolean"
            ],
            [
                "archivedObjects",
                "java.lang.Object[]"
            ],
            [
                "EMPTY",
                "java.lang.Object"
            ]
        ],
        "InputMismatchException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "IntSummaryStatistics": [
            [
                "count",
                "long"
            ],
            [
                "sum",
                "long"
            ],
            [
                "min",
                "int"
            ],
            [
                "max",
                "int"
            ]
        ],
        "InvalidPropertiesFormatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Iterator": [],
        "JapaneseImperialCalendar": [
            [
                "BEFORE_MEIJI",
                "int"
            ],
            [
                "MEIJI",
                "int"
            ],
            [
                "TAISHO",
                "int"
            ],
            [
                "SHOWA",
                "int"
            ],
            [
                "HEISEI",
                "int"
            ],
            [
                "REIWA",
                "int"
            ],
            [
                "EPOCH_OFFSET",
                "int"
            ],
            [
                "ONE_SECOND",
                "int"
            ],
            [
                "ONE_MINUTE",
                "int"
            ],
            [
                "ONE_HOUR",
                "int"
            ],
            [
                "ONE_DAY",
                "long"
            ],
            [
                "jcal",
                "sun.util.calendar.LocalGregorianCalendar"
            ],
            [
                "gcal",
                "sun.util.calendar.Gregorian"
            ],
            [
                "BEFORE_MEIJI_ERA",
                "sun.util.calendar.Era"
            ],
            [
                "eras",
                "sun.util.calendar.Era[]"
            ],
            [
                "sinceFixedDates",
                "long[]"
            ],
            [
                "currentEra",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "jdate",
                "sun.util.calendar.LocalGregorianCalendar$Date"
            ],
            [
                "zoneOffsets",
                "int[]"
            ],
            [
                "originalFields",
                "int[]"
            ],
            [
                "cachedFixedDate",
                "long"
            ]
        ],
        "JumboEnumSet": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "elements",
                "long[]"
            ],
            [
                "size",
                "int"
            ]
        ],
        "KeyValueHolder": [],
        "LinkedHashMap": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LinkedHashSet": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LinkedList": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "List": [],
        "ListIterator": [],
        "ListResourceBundle": [
            [
                "lookup",
                "java.lang.Object>"
            ]
        ],
        "Locale": [
            [
                "ENGLISH",
                "java.util.Locale"
            ],
            [
                "FRENCH",
                "java.util.Locale"
            ],
            [
                "GERMAN",
                "java.util.Locale"
            ],
            [
                "ITALIAN",
                "java.util.Locale"
            ],
            [
                "JAPANESE",
                "java.util.Locale"
            ],
            [
                "KOREAN",
                "java.util.Locale"
            ],
            [
                "CHINESE",
                "java.util.Locale"
            ],
            [
                "SIMPLIFIED_CHINESE",
                "java.util.Locale"
            ],
            [
                "TRADITIONAL_CHINESE",
                "java.util.Locale"
            ],
            [
                "FRANCE",
                "java.util.Locale"
            ],
            [
                "GERMANY",
                "java.util.Locale"
            ],
            [
                "ITALY",
                "java.util.Locale"
            ],
            [
                "JAPAN",
                "java.util.Locale"
            ],
            [
                "KOREA",
                "java.util.Locale"
            ],
            [
                "UK",
                "java.util.Locale"
            ],
            [
                "US",
                "java.util.Locale"
            ],
            [
                "CANADA",
                "java.util.Locale"
            ],
            [
                "CANADA_FRENCH",
                "java.util.Locale"
            ],
            [
                "ROOT",
                "java.util.Locale"
            ],
            [
                "CONSTANT_LOCALES",
                "java.util.Locale>"
            ],
            [
                "CHINA",
                "java.util.Locale"
            ],
            [
                "PRC",
                "java.util.Locale"
            ],
            [
                "TAIWAN",
                "java.util.Locale"
            ],
            [
                "PRIVATE_USE_EXTENSION",
                "char"
            ],
            [
                "UNICODE_LOCALE_EXTENSION",
                "char"
            ],
            [
                "DISPLAY_LANGUAGE",
                "int"
            ],
            [
                "DISPLAY_COUNTRY",
                "int"
            ],
            [
                "DISPLAY_VARIANT",
                "int"
            ],
            [
                "DISPLAY_SCRIPT",
                "int"
            ],
            [
                "DISPLAY_UEXT_KEY",
                "int"
            ],
            [
                "DISPLAY_UEXT_TYPE",
                "int"
            ],
            [
                "baseLocale",
                "sun.util.locale.BaseLocale"
            ],
            [
                "localeExtensions",
                "sun.util.locale.LocaleExtensions"
            ],
            [
                "hashCodeValue",
                "int"
            ],
            [
                "defaultLocale",
                "java.util.Locale"
            ],
            [
                "defaultDisplayLocale",
                "java.util.Locale"
            ],
            [
                "defaultFormatLocale",
                "java.util.Locale"
            ],
            [
                "languageTag",
                "java.lang.String"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "isoLanguages",
                "java.lang.String[]"
            ],
            [
                "isoCountries",
                "java.lang.String[]"
            ]
        ],
        "LocaleISOData": [],
        "LongSummaryStatistics": [
            [
                "count",
                "long"
            ],
            [
                "sum",
                "long"
            ],
            [
                "min",
                "long"
            ],
            [
                "max",
                "long"
            ]
        ],
        "Map": [],
        "MissingFormatArgumentException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "s",
                "java.lang.String"
            ]
        ],
        "MissingFormatWidthException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "s",
                "java.lang.String"
            ]
        ],
        "MissingResourceException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "className",
                "java.lang.String"
            ],
            [
                "key",
                "java.lang.String"
            ]
        ],
        "NavigableMap": [],
        "NavigableSet": [],
        "NoSuchElementException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Objects": [],
        "Observable": [
            [
                "changed",
                "boolean"
            ],
            [
                "obs",
                "java.util.Vector<java.util.Observer>"
            ]
        ],
        "Observer": [],
        "Optional": [
            [
                "EMPTY",
                "java.util.Optional<?>"
            ],
            [
                "value",
                "T"
            ]
        ],
        "OptionalDouble": [
            [
                "EMPTY",
                "java.util.OptionalDouble"
            ],
            [
                "isPresent",
                "boolean"
            ],
            [
                "value",
                "double"
            ]
        ],
        "OptionalInt": [
            [
                "EMPTY",
                "java.util.OptionalInt"
            ],
            [
                "isPresent",
                "boolean"
            ],
            [
                "value",
                "int"
            ]
        ],
        "OptionalLong": [
            [
                "EMPTY",
                "java.util.OptionalLong"
            ],
            [
                "isPresent",
                "boolean"
            ],
            [
                "value",
                "long"
            ]
        ],
        "PrimitiveIterator": [],
        "PriorityQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "DEFAULT_INITIAL_CAPACITY",
                "int"
            ],
            [
                "comparator",
                "E>"
            ]
        ],
        "Properties": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "defaults",
                "java.util.Properties"
            ],
            [
                "map",
                "java.lang.Object>"
            ]
        ],
        "PropertyPermission": [
            [
                "READ",
                "int"
            ],
            [
                "WRITE",
                "int"
            ],
            [
                "ALL",
                "int"
            ],
            [
                "NONE",
                "int"
            ],
            [
                "mask",
                "int"
            ],
            [
                "actions",
                "java.lang.String"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PropertyPermissionCollection": [
            [
                "perms",
                "java.util.PropertyPermission>"
            ],
            [
                "all_allowed",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ]
        ],
        "PropertyResourceBundle": [
            [
                "encoding",
                "java.lang.String"
            ],
            [
                "lookup",
                "java.lang.Object>"
            ]
        ],
        "Queue": [],
        "Random": [
            [
                "seed",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "multiplier",
                "long"
            ],
            [
                "addend",
                "long"
            ],
            [
                "mask",
                "long"
            ],
            [
                "DOUBLE_UNIT",
                "double"
            ],
            [
                "FLOAT_UNIT",
                "float"
            ],
            [
                "seedUniquifier",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "nextNextGaussian",
                "double"
            ],
            [
                "haveNextNextGaussian",
                "boolean"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "unsafe",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "seedOffset",
                "long"
            ]
        ],
        "RandomAccess": [],
        "RegularEnumSet": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "elements",
                "long"
            ]
        ],
        "ResourceBundle": [
            [
                "INITIAL_CACHE_SIZE",
                "int"
            ],
            [
                "NONEXISTENT_BUNDLE",
                "java.util.ResourceBundle"
            ],
            [
                "cacheList",
                "java.util.ResourceBundle$BundleReference>"
            ],
            [
                "referenceQueue",
                "java.lang.ref.ReferenceQueue<java.lang.Object>"
            ],
            [
                "parent",
                "java.util.ResourceBundle"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "expired",
                "boolean"
            ],
            [
                "cacheKey",
                "java.util.ResourceBundle$CacheKey"
            ],
            [
                "keySet",
                "java.util.Set<java.lang.String>"
            ],
            [
                "UNKNOWN_FORMAT",
                "java.lang.String"
            ],
            [
                "TRACE_ON",
                "boolean"
            ]
        ],
        "ReverseOrderDequeView": [],
        "ReverseOrderListView": [],
        "ReverseOrderSortedMapView": [],
        "ReverseOrderSortedSetView": [],
        "Scanner": [
            [
                "buf",
                "java.nio.CharBuffer"
            ],
            [
                "BUFFER_SIZE",
                "int"
            ],
            [
                "position",
                "int"
            ],
            [
                "matcher",
                "java.util.regex.Matcher"
            ],
            [
                "delimPattern",
                "java.util.regex.Pattern"
            ],
            [
                "hasNextPattern",
                "java.util.regex.Pattern"
            ],
            [
                "hasNextPosition",
                "int"
            ],
            [
                "hasNextResult",
                "java.lang.String"
            ],
            [
                "source",
                "java.lang.Readable"
            ],
            [
                "sourceClosed",
                "boolean"
            ],
            [
                "needInput",
                "boolean"
            ],
            [
                "skipped",
                "boolean"
            ],
            [
                "savedScannerPosition",
                "int"
            ],
            [
                "typeCache",
                "java.lang.Object"
            ],
            [
                "matchValid",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "radix",
                "int"
            ],
            [
                "defaultRadix",
                "int"
            ],
            [
                "locale",
                "java.util.Locale"
            ],
            [
                "patternCache",
                "java.util.Scanner$PatternLRUCache"
            ],
            [
                "lastException",
                "java.io.IOException"
            ],
            [
                "WHITESPACE_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "FIND_ANY_PATTERN",
                "java.util.regex.Pattern"
            ],
            [
                "NON_ASCII_DIGIT",
                "java.util.regex.Pattern"
            ],
            [
                "groupSeparator",
                "java.lang.String"
            ],
            [
                "decimalSeparator",
                "java.lang.String"
            ],
            [
                "nanString",
                "java.lang.String"
            ],
            [
                "infinityString",
                "java.lang.String"
            ],
            [
                "positivePrefix",
                "java.lang.String"
            ],
            [
                "negativePrefix",
                "java.lang.String"
            ],
            [
                "positiveSuffix",
                "java.lang.String"
            ],
            [
                "negativeSuffix",
                "java.lang.String"
            ],
            [
                "boolPattern",
                "java.util.regex.Pattern"
            ],
            [
                "BOOLEAN_PATTERN",
                "java.lang.String"
            ],
            [
                "integerPattern",
                "java.util.regex.Pattern"
            ],
            [
                "digits",
                "java.lang.String"
            ],
            [
                "non0Digit",
                "java.lang.String"
            ],
            [
                "SIMPLE_GROUP_INDEX",
                "int"
            ],
            [
                "separatorPattern",
                "java.util.regex.Pattern"
            ],
            [
                "linePattern",
                "java.util.regex.Pattern"
            ],
            [
                "LINE_SEPARATOR_PATTERN",
                "java.lang.String"
            ],
            [
                "LINE_PATTERN",
                "java.lang.String"
            ],
            [
                "floatPattern",
                "java.util.regex.Pattern"
            ],
            [
                "decimalPattern",
                "java.util.regex.Pattern"
            ]
        ],
        "SequencedCollection": [],
        "SequencedMap": [],
        "SequencedSet": [],
        "ServiceConfigurationError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ServiceLoader": [
            [
                "service",
                "java.lang.Class<S>"
            ],
            [
                "serviceName",
                "java.lang.String"
            ],
            [
                "layer",
                "java.lang.ModuleLayer"
            ],
            [
                "loader",
                "java.lang.ClassLoader"
            ],
            [
                "lookupIterator1",
                "java.util.Iterator<java.util.ServiceLoader$Provider<S>>"
            ],
            [
                "instantiatedProviders",
                "java.util.List<S>"
            ],
            [
                "lookupIterator2",
                "java.util.Iterator<java.util.ServiceLoader$Provider<S>>"
            ],
            [
                "loadedProviders",
                "java.util.List<java.util.ServiceLoader$Provider<S>>"
            ],
            [
                "loadedAllProviders",
                "boolean"
            ],
            [
                "reloadCount",
                "int"
            ],
            [
                "LANG_ACCESS",
                "jdk.internal.access.JavaLangAccess"
            ]
        ],
        "Set": [],
        "SimpleTimeZone": [
            [
                "startMonth",
                "int"
            ],
            [
                "startDay",
                "int"
            ],
            [
                "startDayOfWeek",
                "int"
            ],
            [
                "startTime",
                "int"
            ],
            [
                "startTimeMode",
                "int"
            ],
            [
                "endMonth",
                "int"
            ],
            [
                "endDay",
                "int"
            ],
            [
                "endDayOfWeek",
                "int"
            ],
            [
                "endTime",
                "int"
            ],
            [
                "endTimeMode",
                "int"
            ],
            [
                "startYear",
                "int"
            ],
            [
                "rawOffset",
                "int"
            ],
            [
                "useDaylight",
                "boolean"
            ],
            [
                "millisPerHour",
                "int"
            ],
            [
                "millisPerDay",
                "int"
            ],
            [
                "monthLength",
                "byte[]"
            ],
            [
                "staticMonthLength",
                "byte[]"
            ],
            [
                "staticLeapMonthLength",
                "byte[]"
            ],
            [
                "startMode",
                "int"
            ],
            [
                "endMode",
                "int"
            ],
            [
                "dstSavings",
                "int"
            ],
            [
                "gcal",
                "sun.util.calendar.Gregorian"
            ],
            [
                "cache",
                "java.util.SimpleTimeZone$Cache"
            ],
            [
                "DOM_MODE",
                "int"
            ],
            [
                "DOW_IN_MONTH_MODE",
                "int"
            ],
            [
                "DOW_GE_DOM_MODE",
                "int"
            ],
            [
                "DOW_LE_DOM_MODE",
                "int"
            ],
            [
                "WALL_TIME",
                "int"
            ],
            [
                "STANDARD_TIME",
                "int"
            ],
            [
                "UTC_TIME",
                "int"
            ],
            [
                "serialVersionOnStream",
                "int"
            ],
            [
                "MAX_RULE_NUM",
                "int"
            ]
        ],
        "SortedMap": [],
        "SortedSet": [],
        "Spliterator": [
            [
                "ORDERED",
                "int"
            ],
            [
                "DISTINCT",
                "int"
            ],
            [
                "SORTED",
                "int"
            ],
            [
                "SIZED",
                "int"
            ],
            [
                "NONNULL",
                "int"
            ],
            [
                "IMMUTABLE",
                "int"
            ],
            [
                "CONCURRENT",
                "int"
            ],
            [
                "SUBSIZED",
                "int"
            ]
        ],
        "Spliterators": [],
        "SplittableRandom": [
            [
                "GOLDEN_GAMMA",
                "long"
            ],
            [
                "seed",
                "long"
            ],
            [
                "gamma",
                "long"
            ],
            [
                "proxy",
                "java.util.SplittableRandom$AbstractSplittableGeneratorProxy"
            ],
            [
                "defaultGen",
                "java.util.concurrent.atomic.AtomicLong"
            ]
        ],
        "Stack": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StringJoiner": [
            [
                "EMPTY_STRING_ARRAY",
                "java.lang.String[]"
            ],
            [
                "prefix",
                "java.lang.String"
            ],
            [
                "delimiter",
                "java.lang.String"
            ],
            [
                "suffix",
                "java.lang.String"
            ],
            [
                "elts",
                "java.lang.String[]"
            ],
            [
                "size",
                "int"
            ],
            [
                "len",
                "int"
            ],
            [
                "emptyValue",
                "java.lang.String"
            ],
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ]
        ],
        "StringTokenizer": [
            [
                "currentPosition",
                "int"
            ],
            [
                "newPosition",
                "int"
            ],
            [
                "maxPosition",
                "int"
            ],
            [
                "str",
                "java.lang.String"
            ],
            [
                "delimiters",
                "java.lang.String"
            ],
            [
                "retDelims",
                "boolean"
            ],
            [
                "delimsChanged",
                "boolean"
            ],
            [
                "maxDelimCodePoint",
                "int"
            ],
            [
                "hasSurrogates",
                "boolean"
            ],
            [
                "delimiterCodePoints",
                "int[]"
            ]
        ],
        "TaskQueue": [
            [
                "queue",
                "java.util.TimerTask[]"
            ],
            [
                "size",
                "int"
            ]
        ],
        "TimSort": [
            [
                "MIN_MERGE",
                "int"
            ],
            [
                "a",
                "T[]"
            ],
            [
                "c",
                "T>"
            ],
            [
                "MIN_GALLOP",
                "int"
            ],
            [
                "minGallop",
                "int"
            ],
            [
                "INITIAL_TMP_STORAGE_LENGTH",
                "int"
            ],
            [
                "tmp",
                "T[]"
            ],
            [
                "tmpBase",
                "int"
            ],
            [
                "tmpLen",
                "int"
            ],
            [
                "stackSize",
                "int"
            ],
            [
                "runBase",
                "int[]"
            ],
            [
                "runLen",
                "int[]"
            ]
        ],
        "TimeZone": [
            [
                "SHORT",
                "int"
            ],
            [
                "LONG",
                "int"
            ],
            [
                "ONE_MINUTE",
                "int"
            ],
            [
                "ONE_HOUR",
                "int"
            ],
            [
                "ONE_DAY",
                "int"
            ],
            [
                "ID",
                "java.lang.String"
            ],
            [
                "zoneId",
                "java.time.ZoneId"
            ],
            [
                "defaultTimeZone",
                "java.util.TimeZone"
            ],
            [
                "GMT_ID_LENGTH",
                "int"
            ]
        ],
        "Timer": [
            [
                "queue",
                "java.util.TaskQueue"
            ],
            [
                "thread",
                "java.util.TimerThread"
            ],
            [
                "cleanup",
                "java.lang.ref.Cleaner$Cleanable"
            ],
            [
                "nextSerialNumber",
                "java.util.concurrent.atomic.AtomicInteger"
            ]
        ],
        "TimerTask": [],
        "TimerThread": [
            [
                "queue",
                "java.util.TaskQueue"
            ]
        ],
        "TooManyListenersException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TreeMap": [
            [
                "comparator",
                "K>"
            ],
            [
                "root",
                "V>"
            ],
            [
                "size",
                "int"
            ],
            [
                "modCount",
                "int"
            ],
            [
                "entrySet",
                "V>.EntrySet"
            ],
            [
                "navigableKeySet",
                "java.util.TreeMap$KeySet<K>"
            ],
            [
                "descendingMap",
                "V>"
            ],
            [
                "UNBOUNDED",
                "java.lang.Object"
            ],
            [
                "RED",
                "boolean"
            ],
            [
                "BLACK",
                "boolean"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TreeSet": [
            [
                "m",
                "java.lang.Object>"
            ],
            [
                "PRESENT",
                "java.lang.Object"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Tripwire": [
            [
                "TRIPWIRE_PROPERTY",
                "java.lang.String"
            ]
        ],
        "UUID": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "mostSigBits",
                "long"
            ],
            [
                "leastSigBits",
                "long"
            ],
            [
                "jla",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "NIBBLES",
                "byte[]"
            ]
        ],
        "UnknownFormatConversionException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "s",
                "java.lang.String"
            ]
        ],
        "UnknownFormatFlagsException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "flags",
                "java.lang.String"
            ]
        ],
        "Vector": [
            [
                "elementData",
                "java.lang.Object[]"
            ],
            [
                "elementCount",
                "int"
            ],
            [
                "capacityIncrement",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "WeakHashMap": [
            [
                "DEFAULT_INITIAL_CAPACITY",
                "int"
            ],
            [
                "MAXIMUM_CAPACITY",
                "int"
            ],
            [
                "DEFAULT_LOAD_FACTOR",
                "float"
            ],
            [
                "size",
                "int"
            ],
            [
                "threshold",
                "int"
            ],
            [
                "loadFactor",
                "float"
            ],
            [
                "queue",
                "java.lang.ref.ReferenceQueue<java.lang.Object>"
            ],
            [
                "NULL_KEY",
                "java.lang.Object"
            ],
            [
                "entrySet",
                "V>>"
            ]
        ]
    },
    "java.util.concurrent": {
        "AbstractExecutorService": [],
        "ArrayBlockingQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "notEmpty",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "notFull",
                "java.util.concurrent.locks.Condition"
            ]
        ],
        "BlockingDeque": [],
        "BlockingQueue": [],
        "BrokenBarrierException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Callable": [],
        "CancellationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CompletableFuture": [
            [
                "USE_COMMON_POOL",
                "boolean"
            ],
            [
                "ASYNC_POOL",
                "java.util.concurrent.Executor"
            ],
            [
                "RESULT",
                "java.lang.invoke.VarHandle"
            ],
            [
                "STACK",
                "java.lang.invoke.VarHandle"
            ],
            [
                "NEXT",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "CompletionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CompletionService": [],
        "CompletionStage": [],
        "ConcurrentHashMap": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "MAXIMUM_CAPACITY",
                "int"
            ],
            [
                "DEFAULT_CAPACITY",
                "int"
            ],
            [
                "DEFAULT_CONCURRENCY_LEVEL",
                "int"
            ],
            [
                "LOAD_FACTOR",
                "float"
            ],
            [
                "MIN_TRANSFER_STRIDE",
                "int"
            ],
            [
                "RESIZE_STAMP_BITS",
                "int"
            ],
            [
                "MAX_RESIZERS",
                "int"
            ],
            [
                "RESIZE_STAMP_SHIFT",
                "int"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "nextTable",
                "V>[]"
            ],
            [
                "baseCount",
                "long"
            ],
            [
                "sizeCtl",
                "int"
            ],
            [
                "transferIndex",
                "int"
            ],
            [
                "cellsBusy",
                "int"
            ],
            [
                "counterCells",
                "java.util.concurrent.ConcurrentHashMap$CounterCell[]"
            ],
            [
                "keySet",
                "V>"
            ],
            [
                "values",
                "V>"
            ],
            [
                "entrySet",
                "V>"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "SIZECTL",
                "long"
            ],
            [
                "TRANSFERINDEX",
                "long"
            ],
            [
                "BASECOUNT",
                "long"
            ],
            [
                "CELLSBUSY",
                "long"
            ],
            [
                "CELLVALUE",
                "long"
            ],
            [
                "ABASE",
                "int"
            ],
            [
                "ASHIFT",
                "int"
            ]
        ],
        "ConcurrentLinkedDeque": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "head",
                "java.util.concurrent.ConcurrentLinkedDeque$Node<E>"
            ],
            [
                "tail",
                "java.util.concurrent.ConcurrentLinkedDeque$Node<E>"
            ],
            [
                "PREV_TERMINATOR",
                "java.util.concurrent.ConcurrentLinkedDeque$Node<java.lang.Object>"
            ],
            [
                "NEXT_TERMINATOR",
                "java.util.concurrent.ConcurrentLinkedDeque$Node<java.lang.Object>"
            ],
            [
                "HOPS",
                "int"
            ],
            [
                "HEAD",
                "java.lang.invoke.VarHandle"
            ],
            [
                "TAIL",
                "java.lang.invoke.VarHandle"
            ],
            [
                "PREV",
                "java.lang.invoke.VarHandle"
            ],
            [
                "NEXT",
                "java.lang.invoke.VarHandle"
            ],
            [
                "ITEM",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "ConcurrentLinkedQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "tail",
                "java.util.concurrent.ConcurrentLinkedQueue$Node<E>"
            ],
            [
                "MAX_HOPS",
                "int"
            ],
            [
                "HEAD",
                "java.lang.invoke.VarHandle"
            ],
            [
                "TAIL",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "ConcurrentMap": [],
        "ConcurrentNavigableMap": [],
        "ConcurrentSkipListMap": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "head",
                "V>"
            ],
            [
                "adder",
                "java.util.concurrent.atomic.LongAdder"
            ],
            [
                "keySet",
                "V>"
            ],
            [
                "values",
                "V>"
            ],
            [
                "entrySet",
                "V>"
            ],
            [
                "descendingMap",
                "V>"
            ],
            [
                "EQ",
                "int"
            ],
            [
                "LT",
                "int"
            ],
            [
                "GT",
                "int"
            ],
            [
                "HEAD",
                "java.lang.invoke.VarHandle"
            ],
            [
                "ADDER",
                "java.lang.invoke.VarHandle"
            ],
            [
                "NEXT",
                "java.lang.invoke.VarHandle"
            ],
            [
                "VAL",
                "java.lang.invoke.VarHandle"
            ],
            [
                "RIGHT",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "ConcurrentSkipListSet": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "m",
                "java.lang.Object>"
            ]
        ],
        "CopyOnWriteArrayList": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "EMPTY_ELEMENTDATA",
                "java.lang.Object[]"
            ],
            [
                "array",
                "java.lang.Object[]"
            ]
        ],
        "CopyOnWriteArraySet": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "al",
                "java.util.concurrent.CopyOnWriteArrayList<E>"
            ]
        ],
        "CountDownLatch": [
            [
                "sync",
                "java.util.concurrent.CountDownLatch$Sync"
            ]
        ],
        "CountedCompleter": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "PENDING",
                "long"
            ]
        ],
        "CyclicBarrier": [
            [
                "lock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "trip",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "parties",
                "int"
            ],
            [
                "barrierCommand",
                "java.lang.Runnable"
            ],
            [
                "generation",
                "java.util.concurrent.CyclicBarrier$Generation"
            ],
            [
                "count",
                "int"
            ]
        ],
        "DelayQueue": [
            [
                "lock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "q",
                "java.util.PriorityQueue<E>"
            ],
            [
                "leader",
                "java.lang.Thread"
            ],
            [
                "available",
                "java.util.concurrent.locks.Condition"
            ]
        ],
        "Delayed": [],
        "Exchanger": [
            [
                "MMASK",
                "int"
            ],
            [
                "SEQ",
                "int"
            ],
            [
                "SPINS",
                "int"
            ],
            [
                "participant",
                "java.util.concurrent.Exchanger$Participant"
            ],
            [
                "arena",
                "java.util.concurrent.Exchanger$Slot[]"
            ],
            [
                "ncpu",
                "int"
            ],
            [
                "bound",
                "int"
            ],
            [
                "BOUND",
                "java.lang.invoke.VarHandle"
            ],
            [
                "MATCH",
                "java.lang.invoke.VarHandle"
            ],
            [
                "ENTRY",
                "java.lang.invoke.VarHandle"
            ],
            [
                "AA",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "ExecutionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Executor": [],
        "ExecutorCompletionService": [
            [
                "executor",
                "java.util.concurrent.Executor"
            ],
            [
                "aes",
                "java.util.concurrent.AbstractExecutorService"
            ],
            [
                "completionQueue",
                "java.util.concurrent.BlockingQueue<java.util.concurrent.Future<V>>"
            ]
        ],
        "ExecutorService": [],
        "Executors": [],
        "Flow": [],
        "ForkJoinPool": [
            [
                "defaultForkJoinWorkerThreadFactory",
                "java.util.concurrent.ForkJoinPool$ForkJoinWorkerThreadFactory"
            ],
            [
                "poolIds",
                "int"
            ],
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "CTL",
                "long"
            ],
            [
                "RUNSTATE",
                "long"
            ],
            [
                "PARALLELISM",
                "long"
            ],
            [
                "THREADIDS",
                "long"
            ],
            [
                "TERMINATION",
                "long"
            ],
            [
                "POOLIDS_BASE",
                "java.lang.Object"
            ],
            [
                "POOLIDS",
                "long"
            ]
        ],
        "ForkJoinTask": [
            [
                "aux",
                "java.util.concurrent.ForkJoinTask$Aux"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "STATUS",
                "long"
            ],
            [
                "AUX",
                "long"
            ],
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ForkJoinWorkerThread": [
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "THREADLOCALS",
                "long"
            ],
            [
                "INHERITABLETHREADLOCALS",
                "long"
            ],
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ]
        ],
        "Future": [],
        "FutureTask": [
            [
                "state",
                "int"
            ],
            [
                "NEW",
                "int"
            ],
            [
                "COMPLETING",
                "int"
            ],
            [
                "NORMAL",
                "int"
            ],
            [
                "EXCEPTIONAL",
                "int"
            ],
            [
                "CANCELLED",
                "int"
            ],
            [
                "INTERRUPTING",
                "int"
            ],
            [
                "INTERRUPTED",
                "int"
            ],
            [
                "callable",
                "java.util.concurrent.Callable<V>"
            ],
            [
                "outcome",
                "java.lang.Object"
            ],
            [
                "runner",
                "java.lang.Thread"
            ],
            [
                "waiters",
                "java.util.concurrent.FutureTask$WaitNode"
            ],
            [
                "STATE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "RUNNER",
                "java.lang.invoke.VarHandle"
            ],
            [
                "WAITERS",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "Helpers": [],
        "LinkedBlockingDeque": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "count",
                "int"
            ],
            [
                "capacity",
                "int"
            ],
            [
                "notEmpty",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "notFull",
                "java.util.concurrent.locks.Condition"
            ]
        ],
        "LinkedBlockingQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "capacity",
                "int"
            ],
            [
                "count",
                "java.util.concurrent.atomic.AtomicInteger"
            ],
            [
                "last",
                "java.util.concurrent.LinkedBlockingQueue$Node<E>"
            ],
            [
                "takeLock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "notEmpty",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "putLock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "notFull",
                "java.util.concurrent.locks.Condition"
            ]
        ],
        "LinkedTransferQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "MAX_HOPS",
                "int"
            ]
        ],
        "Phaser": [
            [
                "state",
                "long"
            ],
            [
                "MAX_PARTIES",
                "int"
            ],
            [
                "MAX_PHASE",
                "int"
            ],
            [
                "PARTIES_SHIFT",
                "int"
            ],
            [
                "PHASE_SHIFT",
                "int"
            ],
            [
                "UNARRIVED_MASK",
                "int"
            ],
            [
                "PARTIES_MASK",
                "long"
            ],
            [
                "COUNTS_MASK",
                "long"
            ],
            [
                "TERMINATION_BIT",
                "long"
            ],
            [
                "ONE_ARRIVAL",
                "int"
            ],
            [
                "ONE_PARTY",
                "int"
            ],
            [
                "ONE_DEREGISTER",
                "int"
            ],
            [
                "EMPTY",
                "int"
            ],
            [
                "parent",
                "java.util.concurrent.Phaser"
            ],
            [
                "root",
                "java.util.concurrent.Phaser"
            ],
            [
                "evenQ",
                "java.util.concurrent.atomic.AtomicReference<java.util.concurrent.Phaser$QNode>"
            ],
            [
                "oddQ",
                "java.util.concurrent.atomic.AtomicReference<java.util.concurrent.Phaser$QNode>"
            ],
            [
                "NCPU",
                "int"
            ],
            [
                "STATE",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "PriorityBlockingQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "DEFAULT_INITIAL_CAPACITY",
                "int"
            ],
            [
                "queue",
                "java.lang.Object[]"
            ],
            [
                "size",
                "int"
            ],
            [
                "comparator",
                "E>"
            ],
            [
                "lock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "notEmpty",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "allocationSpinLock",
                "int"
            ],
            [
                "q",
                "java.util.PriorityQueue<E>"
            ],
            [
                "ALLOCATIONSPINLOCK",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "RecursiveAction": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RecursiveTask": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RejectedExecutionException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "RejectedExecutionHandler": [],
        "RunnableFuture": [],
        "RunnableScheduledFuture": [],
        "ScheduledExecutorService": [],
        "ScheduledFuture": [],
        "ScheduledThreadPoolExecutor": [
            [
                "continueExistingPeriodicTasksAfterShutdown",
                "boolean"
            ],
            [
                "executeExistingDelayedTasksAfterShutdown",
                "boolean"
            ],
            [
                "sequencer",
                "java.util.concurrent.atomic.AtomicLong"
            ],
            [
                "MAX_NANOS",
                "long"
            ],
            [
                "DEFAULT_KEEPALIVE_MILLIS",
                "long"
            ]
        ],
        "Semaphore": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "sync",
                "java.util.concurrent.Semaphore$Sync"
            ]
        ],
        "StructureViolationException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "StructuredTaskScope": [
            [
                "factory",
                "java.util.concurrent.ThreadFactory"
            ],
            [
                "flock",
                "jdk.internal.misc.ThreadFlock"
            ],
            [
                "shutdownLock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "OPEN",
                "int"
            ],
            [
                "SHUTDOWN",
                "int"
            ],
            [
                "CLOSED",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "forkRound",
                "int"
            ],
            [
                "lastJoinAttempted",
                "int"
            ],
            [
                "lastJoinCompleted",
                "int"
            ]
        ],
        "SubmissionPublisher": [
            [
                "ASYNC_POOL",
                "java.util.concurrent.Executor"
            ]
        ],
        "SynchronousQueue": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "transferer",
                "java.util.concurrent.SynchronousQueue$Transferer<E>"
            ],
            [
                "fair",
                "boolean"
            ],
            [
                "qlock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "waitingProducers",
                "java.util.concurrent.SynchronousQueue$WaitQueue"
            ],
            [
                "waitingConsumers",
                "java.util.concurrent.SynchronousQueue$WaitQueue"
            ]
        ],
        "ThreadFactory": [],
        "ThreadLocalRandom": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "GOLDEN_GAMMA",
                "long"
            ],
            [
                "PROBE_INCREMENT",
                "int"
            ],
            [
                "SEEDER_INCREMENT",
                "long"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "SEED",
                "long"
            ],
            [
                "PROBE",
                "long"
            ],
            [
                "SECONDARY",
                "long"
            ],
            [
                "THREADLOCALS",
                "long"
            ],
            [
                "INHERITABLETHREADLOCALS",
                "long"
            ],
            [
                "probeGenerator",
                "java.util.concurrent.atomic.AtomicInteger"
            ],
            [
                "instance",
                "java.util.concurrent.ThreadLocalRandom"
            ],
            [
                "seeder",
                "java.util.concurrent.atomic.AtomicLong"
            ]
        ],
        "ThreadPerTaskExecutor": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "STATE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "factory",
                "java.util.concurrent.ThreadFactory"
            ],
            [
                "threads",
                "java.util.Set<java.lang.Thread>"
            ],
            [
                "terminationSignal",
                "java.util.concurrent.CountDownLatch"
            ],
            [
                "RUNNING",
                "int"
            ],
            [
                "SHUTDOWN",
                "int"
            ],
            [
                "TERMINATED",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "key",
                "java.lang.Object"
            ]
        ],
        "ThreadPoolExecutor": [
            [
                "ctl",
                "java.util.concurrent.atomic.AtomicInteger"
            ],
            [
                "COUNT_BITS",
                "int"
            ],
            [
                "COUNT_MASK",
                "int"
            ],
            [
                "RUNNING",
                "int"
            ],
            [
                "SHUTDOWN",
                "int"
            ],
            [
                "STOP",
                "int"
            ],
            [
                "TIDYING",
                "int"
            ],
            [
                "TERMINATED",
                "int"
            ],
            [
                "workQueue",
                "java.util.concurrent.BlockingQueue<java.lang.Runnable>"
            ],
            [
                "mainLock",
                "java.util.concurrent.locks.ReentrantLock"
            ],
            [
                "workers",
                "java.util.HashSet<java.util.concurrent.ThreadPoolExecutor$Worker>"
            ],
            [
                "termination",
                "java.util.concurrent.locks.Condition"
            ],
            [
                "container",
                "jdk.internal.vm.SharedThreadContainer"
            ],
            [
                "largestPoolSize",
                "int"
            ],
            [
                "completedTaskCount",
                "long"
            ],
            [
                "threadFactory",
                "java.util.concurrent.ThreadFactory"
            ],
            [
                "handler",
                "java.util.concurrent.RejectedExecutionHandler"
            ],
            [
                "keepAliveTime",
                "long"
            ],
            [
                "allowCoreThreadTimeOut",
                "boolean"
            ],
            [
                "corePoolSize",
                "int"
            ],
            [
                "maximumPoolSize",
                "int"
            ],
            [
                "defaultHandler",
                "java.util.concurrent.RejectedExecutionHandler"
            ],
            [
                "ONLY_ONE",
                "boolean"
            ]
        ],
        "TimeUnit": [
            [
                "NANOSECONDS",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "MICROSECONDS",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "MILLISECONDS",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "SECONDS",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "MINUTES",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "HOURS",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "DAYS",
                "java.util.concurrent.TimeUnit"
            ],
            [
                "NANO_SCALE",
                "long"
            ],
            [
                "MICRO_SCALE",
                "long"
            ],
            [
                "MILLI_SCALE",
                "long"
            ],
            [
                "SECOND_SCALE",
                "long"
            ],
            [
                "MINUTE_SCALE",
                "long"
            ],
            [
                "HOUR_SCALE",
                "long"
            ],
            [
                "DAY_SCALE",
                "long"
            ],
            [
                "scale",
                "long"
            ],
            [
                "maxNanos",
                "long"
            ],
            [
                "maxMicros",
                "long"
            ],
            [
                "maxMillis",
                "long"
            ],
            [
                "maxSecs",
                "long"
            ],
            [
                "microRatio",
                "long"
            ],
            [
                "milliRatio",
                "int"
            ],
            [
                "secRatio",
                "int"
            ],
            [
                "$VALUES",
                "java.util.concurrent.TimeUnit[]"
            ]
        ],
        "TimeoutException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "TransferQueue": []
    },
    "java.util.concurrent.atomic": {
        "AtomicBoolean": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "VALUE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "value",
                "int"
            ]
        ],
        "AtomicInteger": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "VALUE",
                "long"
            ],
            [
                "value",
                "int"
            ]
        ],
        "AtomicIntegerArray": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "AA",
                "java.lang.invoke.VarHandle"
            ],
            [
                "array",
                "int[]"
            ]
        ],
        "AtomicIntegerFieldUpdater": [],
        "AtomicLong": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "VALUE",
                "long"
            ],
            [
                "value",
                "long"
            ]
        ],
        "AtomicLongArray": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "AA",
                "java.lang.invoke.VarHandle"
            ],
            [
                "array",
                "long[]"
            ]
        ],
        "AtomicLongFieldUpdater": [],
        "AtomicMarkableReference": [
            [
                "pair",
                "java.util.concurrent.atomic.AtomicMarkableReference$Pair<V>"
            ],
            [
                "PAIR",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "AtomicReference": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "VALUE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "value",
                "V"
            ]
        ],
        "AtomicReferenceArray": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "AA",
                "java.lang.invoke.VarHandle"
            ],
            [
                "array",
                "java.lang.Object[]"
            ]
        ],
        "AtomicReferenceFieldUpdater": [],
        "AtomicStampedReference": [
            [
                "pair",
                "java.util.concurrent.atomic.AtomicStampedReference$Pair<V>"
            ],
            [
                "PAIR",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "DoubleAccumulator": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "function",
                "java.util.function.DoubleBinaryOperator"
            ],
            [
                "identity",
                "long"
            ]
        ],
        "DoubleAdder": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LongAccumulator": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "function",
                "java.util.function.LongBinaryOperator"
            ],
            [
                "identity",
                "long"
            ]
        ],
        "LongAdder": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Striped64": [
            [
                "BASE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "CELLSBUSY",
                "java.lang.invoke.VarHandle"
            ],
            [
                "THREAD_PROBE",
                "java.lang.invoke.VarHandle"
            ]
        ]
    },
    "java.util.concurrent.locks": {
        "AbstractOwnableSynchronizer": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "exclusiveOwnerThread",
                "java.lang.Thread"
            ]
        ],
        "AbstractQueuedLongSynchronizer": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "head",
                "java.util.concurrent.locks.AbstractQueuedLongSynchronizer$Node"
            ],
            [
                "tail",
                "java.util.concurrent.locks.AbstractQueuedLongSynchronizer$Node"
            ],
            [
                "state",
                "long"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "STATE",
                "long"
            ],
            [
                "HEAD",
                "long"
            ],
            [
                "TAIL",
                "long"
            ]
        ],
        "AbstractQueuedSynchronizer": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "head",
                "java.util.concurrent.locks.AbstractQueuedSynchronizer$Node"
            ],
            [
                "tail",
                "java.util.concurrent.locks.AbstractQueuedSynchronizer$Node"
            ],
            [
                "state",
                "int"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "STATE",
                "long"
            ],
            [
                "HEAD",
                "long"
            ],
            [
                "TAIL",
                "long"
            ]
        ],
        "Condition": [],
        "Lock": [],
        "LockSupport": [
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "PARKBLOCKER",
                "long"
            ],
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ]
        ],
        "ReadWriteLock": [],
        "ReentrantLock": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "sync",
                "java.util.concurrent.locks.ReentrantLock$Sync"
            ]
        ],
        "ReentrantReadWriteLock": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "readerLock",
                "java.util.concurrent.locks.ReentrantReadWriteLock$ReadLock"
            ],
            [
                "writerLock",
                "java.util.concurrent.locks.ReentrantReadWriteLock$WriteLock"
            ]
        ],
        "StampedLock": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "LG_READERS",
                "int"
            ],
            [
                "RUNIT",
                "long"
            ],
            [
                "WBIT",
                "long"
            ],
            [
                "RBITS",
                "long"
            ],
            [
                "RFULL",
                "long"
            ],
            [
                "ABITS",
                "long"
            ],
            [
                "SBITS",
                "long"
            ],
            [
                "RSAFE",
                "long"
            ],
            [
                "ORIGIN",
                "long"
            ],
            [
                "INTERRUPTED",
                "long"
            ],
            [
                "head",
                "java.util.concurrent.locks.StampedLock$Node"
            ],
            [
                "tail",
                "java.util.concurrent.locks.StampedLock$Node"
            ],
            [
                "state",
                "long"
            ],
            [
                "readerOverflow",
                "int"
            ],
            [
                "U",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "STATE",
                "long"
            ],
            [
                "HEAD",
                "long"
            ],
            [
                "TAIL",
                "long"
            ]
        ]
    },
    "java.util.function": {
        "BiConsumer": [],
        "BiFunction": [],
        "BiPredicate": [],
        "BinaryOperator": [],
        "BooleanSupplier": [],
        "Consumer": [],
        "DoubleBinaryOperator": [],
        "DoubleConsumer": [],
        "DoubleFunction": [],
        "DoublePredicate": [],
        "DoubleSupplier": [],
        "DoubleToIntFunction": [],
        "DoubleToLongFunction": [],
        "DoubleUnaryOperator": [],
        "Function": [],
        "IntBinaryOperator": [],
        "IntConsumer": [],
        "IntFunction": [],
        "IntPredicate": [],
        "IntSupplier": [],
        "IntToDoubleFunction": [],
        "IntToLongFunction": [],
        "IntUnaryOperator": [],
        "LongBinaryOperator": [],
        "LongConsumer": [],
        "LongFunction": [],
        "LongPredicate": [],
        "LongSupplier": [],
        "LongToDoubleFunction": [],
        "LongToIntFunction": [],
        "LongUnaryOperator": [],
        "ObjDoubleConsumer": [],
        "ObjIntConsumer": [],
        "ObjLongConsumer": [],
        "Predicate": [],
        "Supplier": [],
        "ToDoubleBiFunction": [],
        "ToDoubleFunction": [],
        "ToIntBiFunction": [],
        "ToIntFunction": [],
        "ToLongBiFunction": [],
        "ToLongFunction": [],
        "UnaryOperator": []
    },
    "java.util.jar": {
        "Attributes": [
            [
                "map",
                "java.lang.Object>"
            ]
        ],
        "JarEntry": [],
        "JarException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JarFile": [
            [
                "BASE_VERSION",
                "java.lang.Runtime$Version"
            ],
            [
                "BASE_VERSION_FEATURE",
                "int"
            ],
            [
                "RUNTIME_VERSION",
                "java.lang.Runtime$Version"
            ],
            [
                "MULTI_RELEASE_ENABLED",
                "boolean"
            ],
            [
                "MULTI_RELEASE_FORCED",
                "boolean"
            ],
            [
                "manRef",
                "java.lang.ref.SoftReference<java.util.jar.Manifest>"
            ],
            [
                "manEntry",
                "java.util.jar.JarEntry"
            ],
            [
                "jv",
                "java.util.jar.JarVerifier"
            ],
            [
                "jvInitialized",
                "boolean"
            ],
            [
                "verify",
                "boolean"
            ],
            [
                "version",
                "java.lang.Runtime$Version"
            ],
            [
                "versionFeature",
                "int"
            ],
            [
                "isMultiRelease",
                "boolean"
            ],
            [
                "hasClassPathAttribute",
                "boolean"
            ],
            [
                "hasCheckedSpecialAttributes",
                "boolean"
            ],
            [
                "JUZFA",
                "jdk.internal.access.JavaUtilZipFileAccess"
            ],
            [
                "META_INF",
                "java.lang.String"
            ],
            [
                "META_INF_VERSIONS",
                "java.lang.String"
            ],
            [
                "MANIFEST_NAME",
                "java.lang.String"
            ],
            [
                "CLASSPATH_CHARS",
                "byte[]"
            ],
            [
                "CLASSPATH_LASTOCC",
                "byte[]"
            ],
            [
                "CLASSPATH_OPTOSFT",
                "byte[]"
            ],
            [
                "MULTIRELEASE_CHARS",
                "byte[]"
            ],
            [
                "MULTIRELEASE_LASTOCC",
                "byte[]"
            ],
            [
                "MULTIRELEASE_OPTOSFT",
                "byte[]"
            ]
        ],
        "JarInputStream": [
            [
                "man",
                "java.util.jar.Manifest"
            ],
            [
                "first",
                "java.util.jar.JarEntry"
            ],
            [
                "jv",
                "java.util.jar.JarVerifier"
            ],
            [
                "mev",
                "sun.security.util.ManifestEntryVerifier"
            ],
            [
                "doVerify",
                "boolean"
            ],
            [
                "tryManifest",
                "boolean"
            ]
        ],
        "JarOutputStream": [
            [
                "JAR_MAGIC",
                "int"
            ],
            [
                "firstEntry",
                "boolean"
            ]
        ],
        "JarVerifier": [
            [
                "MULTIPLE_MANIFEST_WARNING",
                "java.lang.String"
            ],
            [
                "verifiedSigners",
                "java.security.CodeSigner[]>"
            ],
            [
                "sigFileSigners",
                "java.security.CodeSigner[]>"
            ],
            [
                "sigFileData",
                "byte[]>"
            ],
            [
                "pendingBlocks",
                "java.util.ArrayList<sun.security.util.SignatureFileVerifier>"
            ],
            [
                "signerCache",
                "java.util.ArrayList<java.security.CodeSigner[]>"
            ],
            [
                "parsingBlockOrSF",
                "boolean"
            ],
            [
                "parsingMeta",
                "boolean"
            ],
            [
                "anyToVerify",
                "boolean"
            ],
            [
                "baos",
                "java.io.ByteArrayOutputStream"
            ],
            [
                "manDig",
                "sun.security.util.ManifestDigester"
            ],
            [
                "manifestDigests",
                "java.util.List<java.lang.Object>"
            ],
            [
                "signersToAlgs",
                "java.lang.Boolean>>"
            ]
        ],
        "JavaUtilJarAccessImpl": [],
        "Manifest": [
            [
                "attr",
                "java.util.jar.Attributes"
            ],
            [
                "entries",
                "java.util.jar.Attributes>"
            ],
            [
                "jv",
                "java.util.jar.JarVerifier"
            ]
        ]
    },
    "java.util.random": {
        "RandomGenerator": [],
        "RandomGeneratorFactory": [
            [
                "DEFAULT_ALGORITHM",
                "java.lang.String"
            ],
            [
                "properties",
                "java.util.random.RandomGeneratorFactory$RandomGeneratorProperties"
            ]
        ]
    },
    "java.util.regex": {
        "ASCII": [
            [
                "ctype",
                "int[]"
            ]
        ],
        "CharPredicates": [],
        "IntHashSet": [
            [
                "entries",
                "int[]"
            ],
            [
                "hashes",
                "int[]"
            ],
            [
                "pos",
                "int"
            ]
        ],
        "MatchResult": [],
        "Matcher": [
            [
                "namedGroups",
                "java.lang.Integer>"
            ]
        ],
        "Pattern": [
            [
                "UNIX_LINES",
                "int"
            ],
            [
                "CASE_INSENSITIVE",
                "int"
            ],
            [
                "COMMENTS",
                "int"
            ],
            [
                "MULTILINE",
                "int"
            ],
            [
                "LITERAL",
                "int"
            ],
            [
                "DOTALL",
                "int"
            ],
            [
                "UNICODE_CASE",
                "int"
            ],
            [
                "CANON_EQ",
                "int"
            ],
            [
                "UNICODE_CHARACTER_CLASS",
                "int"
            ],
            [
                "ALL_FLAGS",
                "int"
            ],
            [
                "serialVersionUID",
                "long"
            ],
            [
                "pattern",
                "java.lang.String"
            ],
            [
                "flags",
                "int"
            ],
            [
                "flags0",
                "int"
            ],
            [
                "compiled",
                "boolean"
            ],
            [
                "normalizedPattern",
                "java.lang.String"
            ],
            [
                "temp",
                "int[]"
            ],
            [
                "cursor",
                "int"
            ],
            [
                "patternLength",
                "int"
            ],
            [
                "hasSupplementary",
                "boolean"
            ]
        ],
        "PatternSyntaxException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "desc",
                "java.lang.String"
            ],
            [
                "pattern",
                "java.lang.String"
            ],
            [
                "index",
                "int"
            ]
        ],
        "PrintPattern": [
            [
                "ids",
                "java.lang.Integer>"
            ]
        ]
    },
    "java.util.spi": {
        "AbstractResourceBundleProvider": [
            [
                "RB_ACCESS",
                "jdk.internal.access.JavaUtilResourceBundleAccess"
            ],
            [
                "FORMAT_CLASS",
                "java.lang.String"
            ],
            [
                "FORMAT_PROPERTIES",
                "java.lang.String"
            ],
            [
                "formats",
                "java.lang.String[]"
            ]
        ],
        "CalendarDataProvider": [],
        "CalendarNameProvider": [],
        "CurrencyNameProvider": [],
        "LocaleNameProvider": [],
        "LocaleServiceProvider": [],
        "ResourceBundleControlProvider": [],
        "ResourceBundleProvider": [],
        "TimeZoneNameProvider": [],
        "ToolProvider": []
    },
    "java.util.stream": {
        "AbstractPipeline": [
            [
                "MSG_STREAM_LINKED",
                "java.lang.String"
            ],
            [
                "MSG_CONSUMED",
                "java.lang.String"
            ],
            [
                "sourceStage",
                "java.util.stream.AbstractPipeline"
            ],
            [
                "previousStage",
                "java.util.stream.AbstractPipeline"
            ],
            [
                "sourceOrOpFlags",
                "int"
            ],
            [
                "nextStage",
                "java.util.stream.AbstractPipeline"
            ],
            [
                "depth",
                "int"
            ],
            [
                "combinedFlags",
                "int"
            ],
            [
                "sourceSpliterator",
                "java.util.Spliterator<?>"
            ],
            [
                "sourceSupplier",
                "java.util.Spliterator<?>>"
            ],
            [
                "linkedOrConsumed",
                "boolean"
            ],
            [
                "sourceCloseAction",
                "java.lang.Runnable"
            ],
            [
                "parallel",
                "boolean"
            ]
        ],
        "AbstractShortCircuitTask": [
            [
                "sharedResult",
                "java.util.concurrent.atomic.AtomicReference<R>"
            ],
            [
                "canceled",
                "boolean"
            ]
        ],
        "AbstractSpinedBuffer": [
            [
                "MIN_CHUNK_POWER",
                "int"
            ],
            [
                "MIN_CHUNK_SIZE",
                "int"
            ],
            [
                "MAX_CHUNK_POWER",
                "int"
            ],
            [
                "MIN_SPINE_SIZE",
                "int"
            ],
            [
                "initialChunkPower",
                "int"
            ],
            [
                "elementIndex",
                "int"
            ],
            [
                "spineIndex",
                "int"
            ],
            [
                "priorElementCount",
                "long[]"
            ]
        ],
        "AbstractTask": [
            [
                "LEAF_TARGET",
                "int"
            ],
            [
                "helper",
                "java.util.stream.PipelineHelper<P_OUT>"
            ],
            [
                "spliterator",
                "java.util.Spliterator<P_IN>"
            ],
            [
                "targetSize",
                "long"
            ],
            [
                "leftChild",
                "K"
            ],
            [
                "rightChild",
                "K"
            ],
            [
                "localResult",
                "R"
            ]
        ],
        "BaseStream": [],
        "Collector": [],
        "Collectors": [],
        "DistinctOps": [],
        "DoublePipeline": [],
        "DoubleStream": [],
        "FindOps": [],
        "ForEachOps": [],
        "Gatherer": [],
        "GathererOp": [
            [
                "DEFAULT_FLAGS",
                "int"
            ],
            [
                "SHORT_CIRCUIT_FLAGS",
                "int"
            ],
            [
                "GREEDY_FLAGS",
                "int"
            ]
        ],
        "Gatherers": [],
        "IntPipeline": [],
        "IntStream": [],
        "LongPipeline": [],
        "LongStream": [],
        "MatchOps": [],
        "Node": [],
        "Nodes": [
            [
                "EMPTY_NODE",
                "java.util.stream.Node"
            ],
            [
                "EMPTY_INT_NODE",
                "java.util.stream.Node$OfInt"
            ],
            [
                "EMPTY_LONG_NODE",
                "java.util.stream.Node$OfLong"
            ],
            [
                "EMPTY_DOUBLE_NODE",
                "java.util.stream.Node$OfDouble"
            ],
            [
                "EMPTY_INT_ARRAY",
                "int[]"
            ],
            [
                "EMPTY_LONG_ARRAY",
                "long[]"
            ],
            [
                "EMPTY_DOUBLE_ARRAY",
                "double[]"
            ]
        ],
        "PipelineHelper": [],
        "ReduceOps": [],
        "ReferencePipeline": [],
        "Sink": [],
        "SliceOps": [],
        "SortedOps": [],
        "SpinedBuffer": [
            [
                "curChunk",
                "E[]"
            ],
            [
                "spine",
                "E[][]"
            ],
            [
                "SPLITERATOR_CHARACTERISTICS",
                "int"
            ]
        ],
        "Stream": [],
        "StreamOpFlag": [
            [
                "DISTINCT",
                "java.util.stream.StreamOpFlag"
            ],
            [
                "SORTED",
                "java.util.stream.StreamOpFlag"
            ],
            [
                "ORDERED",
                "java.util.stream.StreamOpFlag"
            ],
            [
                "SIZED",
                "java.util.stream.StreamOpFlag"
            ],
            [
                "SHORT_CIRCUIT",
                "java.util.stream.StreamOpFlag"
            ],
            [
                "SIZE_ADJUSTING",
                "java.util.stream.StreamOpFlag"
            ],
            [
                "SET_BITS",
                "int"
            ],
            [
                "CLEAR_BITS",
                "int"
            ],
            [
                "PRESERVE_BITS",
                "int"
            ],
            [
                "maskTable",
                "java.lang.Integer>"
            ],
            [
                "bitPosition",
                "int"
            ],
            [
                "set",
                "int"
            ],
            [
                "clear",
                "int"
            ],
            [
                "preserve",
                "int"
            ],
            [
                "FLAG_MASK",
                "int"
            ],
            [
                "FLAG_MASK_IS",
                "int"
            ],
            [
                "FLAG_MASK_NOT",
                "int"
            ],
            [
                "$VALUES",
                "java.util.stream.StreamOpFlag[]"
            ]
        ],
        "StreamShape": [
            [
                "REFERENCE",
                "java.util.stream.StreamShape"
            ],
            [
                "INT_VALUE",
                "java.util.stream.StreamShape"
            ],
            [
                "LONG_VALUE",
                "java.util.stream.StreamShape"
            ],
            [
                "DOUBLE_VALUE",
                "java.util.stream.StreamShape"
            ],
            [
                "$VALUES",
                "java.util.stream.StreamShape[]"
            ]
        ],
        "StreamSpliterators": [],
        "StreamSupport": [],
        "Streams": [],
        "TerminalOp": [],
        "TerminalSink": [],
        "Tripwire": [
            [
                "TRIPWIRE_PROPERTY",
                "java.lang.String"
            ]
        ],
        "WhileOps": []
    },
    "java.util.zip": {
        "Adler32": [
            [
                "adler",
                "int"
            ]
        ],
        "CRC32": [
            [
                "crc",
                "int"
            ]
        ],
        "CRC32C": [
            [
                "CRC32C_POLY",
                "int"
            ],
            [
                "REVERSED_CRC32C_POLY",
                "int"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "byteTable",
                "int[]"
            ],
            [
                "byteTables",
                "int[][]"
            ],
            [
                "byteTable0",
                "int[]"
            ],
            [
                "byteTable1",
                "int[]"
            ],
            [
                "byteTable2",
                "int[]"
            ],
            [
                "byteTable3",
                "int[]"
            ],
            [
                "byteTable4",
                "int[]"
            ],
            [
                "byteTable5",
                "int[]"
            ],
            [
                "byteTable6",
                "int[]"
            ],
            [
                "byteTable7",
                "int[]"
            ],
            [
                "crc",
                "int"
            ]
        ],
        "CheckedInputStream": [
            [
                "cksum",
                "java.util.zip.Checksum"
            ]
        ],
        "CheckedOutputStream": [
            [
                "cksum",
                "java.util.zip.Checksum"
            ]
        ],
        "Checksum": [],
        "DataFormatException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Deflater": [
            [
                "zsRef",
                "java.util.zip.Deflater$DeflaterZStreamRef"
            ],
            [
                "input",
                "java.nio.ByteBuffer"
            ],
            [
                "inputArray",
                "byte[]"
            ],
            [
                "inputPos",
                "int"
            ],
            [
                "inputLim",
                "int"
            ],
            [
                "level",
                "int"
            ],
            [
                "strategy",
                "int"
            ],
            [
                "setParams",
                "boolean"
            ],
            [
                "finish",
                "boolean"
            ],
            [
                "finished",
                "boolean"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "bytesWritten",
                "long"
            ],
            [
                "DEFLATED",
                "int"
            ],
            [
                "NO_COMPRESSION",
                "int"
            ],
            [
                "BEST_SPEED",
                "int"
            ],
            [
                "BEST_COMPRESSION",
                "int"
            ],
            [
                "DEFAULT_COMPRESSION",
                "int"
            ],
            [
                "FILTERED",
                "int"
            ],
            [
                "HUFFMAN_ONLY",
                "int"
            ],
            [
                "DEFAULT_STRATEGY",
                "int"
            ],
            [
                "NO_FLUSH",
                "int"
            ],
            [
                "SYNC_FLUSH",
                "int"
            ],
            [
                "FULL_FLUSH",
                "int"
            ],
            [
                "FINISH",
                "int"
            ]
        ],
        "DeflaterInputStream": [
            [
                "def",
                "java.util.zip.Deflater"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "rbuf",
                "byte[]"
            ],
            [
                "usesDefaultDeflater",
                "boolean"
            ],
            [
                "reachEOF",
                "boolean"
            ]
        ],
        "DeflaterOutputStream": [
            [
                "SYNC_FLUSH_MIN_BUF_SIZE",
                "int"
            ],
            [
                "def",
                "java.util.zip.Deflater"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "syncFlush",
                "boolean"
            ]
        ],
        "GZIPInputStream": [
            [
                "crc",
                "java.util.zip.CRC32"
            ],
            [
                "eos",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "GZIP_MAGIC",
                "int"
            ],
            [
                "FTEXT",
                "int"
            ],
            [
                "FHCRC",
                "int"
            ],
            [
                "FEXTRA",
                "int"
            ],
            [
                "FNAME",
                "int"
            ],
            [
                "FCOMMENT",
                "int"
            ],
            [
                "tmpbuf",
                "byte[]"
            ]
        ],
        "GZIPOutputStream": [
            [
                "crc",
                "java.util.zip.CRC32"
            ],
            [
                "GZIP_MAGIC",
                "int"
            ],
            [
                "TRAILER_SIZE",
                "int"
            ],
            [
                "OS_UNKNOWN",
                "byte"
            ]
        ],
        "Inflater": [
            [
                "zsRef",
                "java.util.zip.Inflater$InflaterZStreamRef"
            ],
            [
                "input",
                "java.nio.ByteBuffer"
            ],
            [
                "inputArray",
                "byte[]"
            ],
            [
                "inputPos",
                "int"
            ],
            [
                "inputLim",
                "int"
            ],
            [
                "finished",
                "boolean"
            ],
            [
                "pendingOutput",
                "boolean"
            ],
            [
                "needDict",
                "boolean"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "bytesWritten",
                "long"
            ],
            [
                "inputConsumed",
                "int"
            ],
            [
                "outputConsumed",
                "int"
            ]
        ],
        "InflaterInputStream": [
            [
                "inf",
                "java.util.zip.Inflater"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "len",
                "int"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "reachEOF",
                "boolean"
            ],
            [
                "singleByteBuf",
                "byte[]"
            ]
        ],
        "InflaterOutputStream": [
            [
                "inf",
                "java.util.zip.Inflater"
            ],
            [
                "buf",
                "byte[]"
            ],
            [
                "wbuf",
                "byte[]"
            ],
            [
                "usesDefaultInflater",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "Snippets": [],
        "ZipCoder": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "cs",
                "java.nio.charset.Charset"
            ],
            [
                "dec",
                "java.nio.charset.CharsetDecoder"
            ],
            [
                "enc",
                "java.nio.charset.CharsetEncoder"
            ]
        ],
        "ZipConstants": [
            [
                "LOCSIG",
                "long"
            ],
            [
                "EXTSIG",
                "long"
            ],
            [
                "CENSIG",
                "long"
            ],
            [
                "ENDSIG",
                "long"
            ],
            [
                "LOCHDR",
                "int"
            ],
            [
                "EXTHDR",
                "int"
            ],
            [
                "CENHDR",
                "int"
            ],
            [
                "ENDHDR",
                "int"
            ],
            [
                "LOCVER",
                "int"
            ],
            [
                "LOCFLG",
                "int"
            ],
            [
                "LOCHOW",
                "int"
            ],
            [
                "LOCTIM",
                "int"
            ],
            [
                "LOCCRC",
                "int"
            ],
            [
                "LOCSIZ",
                "int"
            ],
            [
                "LOCLEN",
                "int"
            ],
            [
                "LOCNAM",
                "int"
            ],
            [
                "LOCEXT",
                "int"
            ],
            [
                "EXTCRC",
                "int"
            ],
            [
                "EXTSIZ",
                "int"
            ],
            [
                "EXTLEN",
                "int"
            ],
            [
                "CENVEM",
                "int"
            ],
            [
                "CENVER",
                "int"
            ],
            [
                "CENFLG",
                "int"
            ],
            [
                "CENHOW",
                "int"
            ],
            [
                "CENTIM",
                "int"
            ],
            [
                "CENCRC",
                "int"
            ],
            [
                "CENSIZ",
                "int"
            ],
            [
                "CENLEN",
                "int"
            ],
            [
                "CENNAM",
                "int"
            ],
            [
                "CENEXT",
                "int"
            ],
            [
                "CENCOM",
                "int"
            ],
            [
                "CENDSK",
                "int"
            ],
            [
                "CENATT",
                "int"
            ],
            [
                "CENATX",
                "int"
            ],
            [
                "CENOFF",
                "int"
            ],
            [
                "ENDSUB",
                "int"
            ],
            [
                "ENDTOT",
                "int"
            ],
            [
                "ENDSIZ",
                "int"
            ],
            [
                "ENDOFF",
                "int"
            ],
            [
                "ENDCOM",
                "int"
            ]
        ],
        "ZipConstants64": [],
        "ZipEntry": [
            [
                "STORED",
                "int"
            ],
            [
                "DEFLATED",
                "int"
            ],
            [
                "UPPER_DOSTIME_BOUND",
                "long"
            ],
            [
                "MAX_COMBINED_CEN_HEADER_SIZE",
                "int"
            ]
        ],
        "ZipError": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ZipException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ZipFile": [
            [
                "filePath",
                "java.lang.String"
            ],
            [
                "fileName",
                "java.lang.String"
            ],
            [
                "closeRequested",
                "boolean"
            ],
            [
                "res",
                "java.util.zip.ZipFile$CleanableResource"
            ],
            [
                "STORED",
                "int"
            ],
            [
                "DEFLATED",
                "int"
            ],
            [
                "OPEN_READ",
                "int"
            ],
            [
                "OPEN_DELETE",
                "int"
            ],
            [
                "DISABLE_ZIP64_EXTRA_VALIDATION",
                "boolean"
            ],
            [
                "lastEntryName",
                "java.lang.String"
            ],
            [
                "lastEntryPos",
                "int"
            ],
            [
                "EMPTY_VERSIONS",
                "java.util.BitSet"
            ]
        ],
        "ZipInputStream": [
            [
                "entry",
                "java.util.zip.ZipEntry"
            ],
            [
                "flag",
                "int"
            ],
            [
                "crc",
                "java.util.zip.CRC32"
            ],
            [
                "remaining",
                "long"
            ],
            [
                "tmpbuf",
                "byte[]"
            ],
            [
                "STORED",
                "int"
            ],
            [
                "DEFLATED",
                "int"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "entryEOF",
                "boolean"
            ],
            [
                "zc",
                "java.util.zip.ZipCoder"
            ],
            [
                "expect64BitDataDescriptor",
                "boolean"
            ],
            [
                "b",
                "byte[]"
            ]
        ],
        "ZipOutputStream": [
            [
                "inhibitZip64",
                "boolean"
            ],
            [
                "current",
                "java.util.zip.ZipOutputStream$XEntry"
            ],
            [
                "xentries",
                "java.util.Vector<java.util.zip.ZipOutputStream$XEntry>"
            ],
            [
                "names",
                "java.util.HashSet<java.lang.String>"
            ],
            [
                "crc",
                "java.util.zip.CRC32"
            ],
            [
                "written",
                "long"
            ],
            [
                "locoff",
                "long"
            ],
            [
                "comment",
                "byte[]"
            ],
            [
                "method",
                "int"
            ],
            [
                "finished",
                "boolean"
            ],
            [
                "closed",
                "boolean"
            ],
            [
                "zc",
                "java.util.zip.ZipCoder"
            ],
            [
                "STORED",
                "int"
            ],
            [
                "DEFLATED",
                "int"
            ]
        ],
        "ZipUtils": [
            [
                "WINDOWS_EPOCH_IN_MICROSECONDS",
                "long"
            ],
            [
                "WINDOWS_TIME_NOT_AVAILABLE",
                "long"
            ],
            [
                "UPPER_UNIXTIME_BOUND",
                "long"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "byteBufferArrayOffset",
                "long"
            ],
            [
                "byteBufferOffsetOffset",
                "long"
            ]
        ]
    },
    "javax.crypto": {
        "AEADBadTagException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "BadPaddingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Cipher": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "ENCRYPT_MODE",
                "int"
            ],
            [
                "DECRYPT_MODE",
                "int"
            ],
            [
                "WRAP_MODE",
                "int"
            ],
            [
                "UNWRAP_MODE",
                "int"
            ],
            [
                "PUBLIC_KEY",
                "int"
            ],
            [
                "PRIVATE_KEY",
                "int"
            ],
            [
                "SECRET_KEY",
                "int"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "spi",
                "javax.crypto.CipherSpi"
            ],
            [
                "transformation",
                "java.lang.String"
            ],
            [
                "cryptoPerm",
                "javax.crypto.CryptoPermission"
            ],
            [
                "exmech",
                "javax.crypto.ExemptionMechanism"
            ],
            [
                "initialized",
                "boolean"
            ],
            [
                "opmode",
                "int"
            ],
            [
                "firstSpi",
                "javax.crypto.CipherSpi"
            ],
            [
                "firstService",
                "java.security.Provider$Service"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ],
            [
                "transforms",
                "java.util.List<javax.crypto.Cipher$Transform>"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "SHA512TRUNCATED",
                "java.lang.String"
            ],
            [
                "ATTR_MODE",
                "java.lang.String"
            ],
            [
                "ATTR_PAD",
                "java.lang.String"
            ],
            [
                "S_NO",
                "int"
            ],
            [
                "S_MAYBE",
                "int"
            ],
            [
                "S_YES",
                "int"
            ],
            [
                "warnCount",
                "int"
            ],
            [
                "I_KEY",
                "int"
            ],
            [
                "I_PARAMSPEC",
                "int"
            ],
            [
                "I_PARAMS",
                "int"
            ],
            [
                "I_CERT",
                "int"
            ]
        ],
        "CipherInputStream": [
            [
                "cipher",
                "javax.crypto.Cipher"
            ],
            [
                "input",
                "java.io.InputStream"
            ],
            [
                "ibuffer",
                "byte[]"
            ],
            [
                "done",
                "boolean"
            ],
            [
                "obuffer",
                "byte[]"
            ],
            [
                "ostart",
                "int"
            ],
            [
                "ofinish",
                "int"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "CipherOutputStream": [
            [
                "cipher",
                "javax.crypto.Cipher"
            ],
            [
                "output",
                "java.io.OutputStream"
            ],
            [
                "ibuffer",
                "byte[]"
            ],
            [
                "obuffer",
                "byte[]"
            ],
            [
                "closed",
                "boolean"
            ]
        ],
        "CipherSpi": [],
        "CryptoAllPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CryptoAllPermissionCollection": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "all_allowed",
                "boolean"
            ]
        ],
        "CryptoPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "alg",
                "java.lang.String"
            ],
            [
                "maxKeySize",
                "int"
            ],
            [
                "exemptionMechanism",
                "java.lang.String"
            ],
            [
                "algParamSpec",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "checkParam",
                "boolean"
            ]
        ],
        "CryptoPermissionCollection": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "permissions",
                "java.util.Vector<java.security.Permission>"
            ]
        ],
        "CryptoPermissions": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "serialPersistentFields",
                "java.io.ObjectStreamField[]"
            ],
            [
                "perms",
                "java.security.PermissionCollection>"
            ]
        ],
        "CryptoPolicyParser": [
            [
                "grantEntries",
                "java.util.Vector<javax.crypto.CryptoPolicyParser$GrantEntry>"
            ],
            [
                "st",
                "java.io.StreamTokenizer"
            ],
            [
                "lookahead",
                "int"
            ],
            [
                "allPermEntryFound",
                "boolean"
            ]
        ],
        "DecapsulateException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "EncryptedPrivateKeyInfo": [
            [
                "algid",
                "sun.security.x509.AlgorithmId"
            ],
            [
                "params",
                "java.security.AlgorithmParameters"
            ],
            [
                "encryptedData",
                "byte[]"
            ],
            [
                "encoded",
                "byte[]"
            ]
        ],
        "ExemptionMechanism": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "exmechSpi",
                "javax.crypto.ExemptionMechanismSpi"
            ],
            [
                "mechanism",
                "java.lang.String"
            ],
            [
                "done",
                "boolean"
            ],
            [
                "initialized",
                "boolean"
            ],
            [
                "keyStored",
                "java.security.Key"
            ]
        ],
        "ExemptionMechanismException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "ExemptionMechanismSpi": [],
        "IllegalBlockSizeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "JceSecurity": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "defaultPolicy",
                "javax.crypto.CryptoPermissions"
            ],
            [
                "exemptPolicy",
                "javax.crypto.CryptoPermissions"
            ],
            [
                "verificationResults",
                "java.lang.Object>"
            ],
            [
                "verifyingProviders",
                "java.lang.Object>"
            ],
            [
                "queue",
                "java.lang.ref.ReferenceQueue<java.lang.Object>"
            ],
            [
                "isRestricted",
                "boolean"
            ],
            [
                "PROVIDER_VERIFIED",
                "java.lang.Object"
            ],
            [
                "NULL_URL",
                "java.net.URL"
            ],
            [
                "codeBaseCacheRef",
                "java.net.URL>"
            ]
        ],
        "JceSecurityManager": [
            [
                "defaultPolicy",
                "javax.crypto.CryptoPermissions"
            ],
            [
                "exemptPolicy",
                "javax.crypto.CryptoPermissions"
            ],
            [
                "allPerm",
                "javax.crypto.CryptoAllPermission"
            ],
            [
                "TrustedCallersCache",
                "java.util.Vector<java.lang.Class<?>>"
            ],
            [
                "exemptCache",
                "javax.crypto.CryptoPermissions>"
            ],
            [
                "CACHE_NULL_MARK",
                "javax.crypto.CryptoPermissions"
            ]
        ],
        "KDF": [
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "theOne",
                "javax.crypto.KDF$Delegate"
            ],
            [
                "candidate",
                "javax.crypto.KDF$Delegate"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "kdfParameters",
                "javax.crypto.KDFParameters"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ],
            [
                "lock",
                "java.lang.Object"
            ]
        ],
        "KDFParameters": [],
        "KDFSpi": [],
        "KEM": [
            [
                "delayed",
                "javax.crypto.KEM$DelayedKEM"
            ],
            [
                "spi",
                "javax.crypto.KEMSpi"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "KEMSpi": [],
        "KeyAgreement": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "spi",
                "javax.crypto.KeyAgreementSpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "firstService",
                "java.security.Provider$Service"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "warnCount",
                "int"
            ],
            [
                "I_NO_PARAMS",
                "int"
            ],
            [
                "I_PARAMS",
                "int"
            ]
        ],
        "KeyAgreementSpi": [],
        "KeyGenerator": [
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "I_NONE",
                "int"
            ],
            [
                "I_RANDOM",
                "int"
            ],
            [
                "I_PARAMS",
                "int"
            ],
            [
                "I_SIZE",
                "int"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "spi",
                "javax.crypto.KeyGeneratorSpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ],
            [
                "initType",
                "int"
            ],
            [
                "initKeySize",
                "int"
            ],
            [
                "initParams",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "initRandom",
                "java.security.SecureRandom"
            ]
        ],
        "KeyGeneratorSpi": [],
        "Mac": [
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "pdebug",
                "sun.security.util.Debug"
            ],
            [
                "skipDebug",
                "boolean"
            ],
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "spi",
                "javax.crypto.MacSpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "initialized",
                "boolean"
            ],
            [
                "firstService",
                "java.security.Provider$Service"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "warnCount",
                "int"
            ]
        ],
        "MacSpi": [],
        "NoSuchPaddingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "NullCipher": [],
        "NullCipherSpi": [],
        "PermissionsEnumerator": [
            [
                "perms",
                "java.util.Enumeration<java.security.PermissionCollection>"
            ],
            [
                "permset",
                "java.util.Enumeration<java.security.Permission>"
            ]
        ],
        "ProviderVerifier": [
            [
                "jarURL",
                "java.net.URL"
            ],
            [
                "savePerms",
                "boolean"
            ],
            [
                "appPerms",
                "javax.crypto.CryptoPermissions"
            ]
        ],
        "SealedObject": [
            [
                "encryptedContent",
                "byte[]"
            ],
            [
                "sealAlg",
                "java.lang.String"
            ],
            [
                "paramsAlg",
                "java.lang.String"
            ],
            [
                "encodedParams",
                "byte[]"
            ]
        ],
        "SecretKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SecretKeyFactory": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "spi",
                "javax.crypto.SecretKeyFactorySpi"
            ],
            [
                "lock",
                "java.lang.Object"
            ],
            [
                "serviceIterator",
                "java.util.Iterator<java.security.Provider$Service>"
            ]
        ],
        "SecretKeyFactorySpi": [],
        "ShortBufferException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "extObjectInputStream": []
    },
    "javax.crypto.interfaces": {
        "DHKey": [],
        "DHPrivateKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DHPublicKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "PBEKey": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "javax.crypto.spec": {
        "ChaCha20ParameterSpec": [
            [
                "NONCE_LENGTH",
                "int"
            ],
            [
                "nonce",
                "byte[]"
            ],
            [
                "counter",
                "int"
            ]
        ],
        "DESKeySpec": [
            [
                "DES_KEY_LEN",
                "int"
            ],
            [
                "key",
                "byte[]"
            ],
            [
                "WEAK_KEYS",
                "byte[][]"
            ]
        ],
        "DESedeKeySpec": [
            [
                "DES_EDE_KEY_LEN",
                "int"
            ],
            [
                "key",
                "byte[]"
            ]
        ],
        "DHGenParameterSpec": [
            [
                "primeSize",
                "int"
            ],
            [
                "exponentSize",
                "int"
            ]
        ],
        "DHParameterSpec": [
            [
                "p",
                "java.math.BigInteger"
            ],
            [
                "g",
                "java.math.BigInteger"
            ],
            [
                "l",
                "int"
            ]
        ],
        "DHPrivateKeySpec": [
            [
                "x",
                "java.math.BigInteger"
            ],
            [
                "p",
                "java.math.BigInteger"
            ],
            [
                "g",
                "java.math.BigInteger"
            ]
        ],
        "DHPublicKeySpec": [
            [
                "y",
                "java.math.BigInteger"
            ],
            [
                "p",
                "java.math.BigInteger"
            ],
            [
                "g",
                "java.math.BigInteger"
            ]
        ],
        "GCMParameterSpec": [
            [
                "iv",
                "byte[]"
            ],
            [
                "tLen",
                "int"
            ]
        ],
        "HKDFParameterSpec": [],
        "IvParameterSpec": [
            [
                "iv",
                "byte[]"
            ]
        ],
        "OAEPParameterSpec": [
            [
                "mdName",
                "java.lang.String"
            ],
            [
                "mgfName",
                "java.lang.String"
            ],
            [
                "mgfSpec",
                "java.security.spec.AlgorithmParameterSpec"
            ],
            [
                "pSrc",
                "javax.crypto.spec.PSource"
            ],
            [
                "DEFAULT",
                "javax.crypto.spec.OAEPParameterSpec"
            ]
        ],
        "PBEKeySpec": [
            [
                "password",
                "char[]"
            ],
            [
                "salt",
                "byte[]"
            ],
            [
                "iterationCount",
                "int"
            ],
            [
                "keyLength",
                "int"
            ]
        ],
        "PBEParameterSpec": [
            [
                "salt",
                "byte[]"
            ],
            [
                "iterationCount",
                "int"
            ],
            [
                "paramSpec",
                "java.security.spec.AlgorithmParameterSpec"
            ]
        ],
        "PSource": [
            [
                "pSrcName",
                "java.lang.String"
            ]
        ],
        "RC2ParameterSpec": [
            [
                "iv",
                "byte[]"
            ],
            [
                "effectiveKeyBits",
                "int"
            ]
        ],
        "RC5ParameterSpec": [
            [
                "iv",
                "byte[]"
            ],
            [
                "version",
                "int"
            ],
            [
                "rounds",
                "int"
            ],
            [
                "wordSize",
                "int"
            ]
        ],
        "SecretKeySpec": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "key",
                "byte[]"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ]
    },
    "javax.net": {
        "DefaultServerSocketFactory": [],
        "DefaultSocketFactory": [],
        "ServerSocketFactory": [
            [
                "theFactory",
                "javax.net.ServerSocketFactory"
            ]
        ],
        "SocketFactory": [
            [
                "theFactory",
                "javax.net.SocketFactory"
            ]
        ]
    },
    "javax.net.ssl": {
        "CertPathTrustManagerParameters": [
            [
                "parameters",
                "java.security.cert.CertPathParameters"
            ]
        ],
        "DefaultSSLServerSocketFactory": [
            [
                "reason",
                "java.lang.Exception"
            ]
        ],
        "DefaultSSLSocketFactory": [
            [
                "reason",
                "java.lang.Exception"
            ]
        ],
        "ExtendedSSLSession": [],
        "HandshakeCompletedEvent": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "session",
                "javax.net.ssl.SSLSession"
            ]
        ],
        "HandshakeCompletedListener": [],
        "HostnameVerifier": [],
        "HttpsURLConnection": [
            [
                "defaultHostnameVerifier",
                "javax.net.ssl.HostnameVerifier"
            ],
            [
                "hostnameVerifier",
                "javax.net.ssl.HostnameVerifier"
            ],
            [
                "defaultSSLSocketFactory",
                "javax.net.ssl.SSLSocketFactory"
            ],
            [
                "sslSocketFactory",
                "javax.net.ssl.SSLSocketFactory"
            ]
        ],
        "KeyManager": [],
        "KeyManagerFactory": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "factorySpi",
                "javax.net.ssl.KeyManagerFactorySpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "KeyManagerFactorySpi": [],
        "KeyStoreBuilderParameters": [
            [
                "parameters",
                "java.util.List<java.security.KeyStore$Builder>"
            ]
        ],
        "ManagerFactoryParameters": [],
        "SNIHostName": [
            [
                "hostname",
                "java.lang.String"
            ]
        ],
        "SNIMatcher": [
            [
                "type",
                "int"
            ]
        ],
        "SNIServerName": [
            [
                "type",
                "int"
            ],
            [
                "encoded",
                "byte[]"
            ]
        ],
        "SSLContext": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "contextSpi",
                "javax.net.ssl.SSLContextSpi"
            ],
            [
                "protocol",
                "java.lang.String"
            ],
            [
                "defaultContext",
                "javax.net.ssl.SSLContext"
            ],
            [
                "VH_DEFAULT_CONTEXT",
                "java.lang.invoke.VarHandle"
            ]
        ],
        "SSLContextSpi": [],
        "SSLEngine": [
            [
                "peerHost",
                "java.lang.String"
            ],
            [
                "peerPort",
                "int"
            ]
        ],
        "SSLEngineResult": [
            [
                "status",
                "javax.net.ssl.SSLEngineResult$Status"
            ],
            [
                "handshakeStatus",
                "javax.net.ssl.SSLEngineResult$HandshakeStatus"
            ],
            [
                "bytesConsumed",
                "int"
            ],
            [
                "bytesProduced",
                "int"
            ],
            [
                "sequenceNumber",
                "long"
            ]
        ],
        "SSLException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SSLHandshakeException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SSLKeyException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SSLParameters": [
            [
                "cipherSuites",
                "java.lang.String[]"
            ],
            [
                "protocols",
                "java.lang.String[]"
            ],
            [
                "wantClientAuth",
                "boolean"
            ],
            [
                "needClientAuth",
                "boolean"
            ],
            [
                "identificationAlgorithm",
                "java.lang.String"
            ],
            [
                "algorithmConstraints",
                "java.security.AlgorithmConstraints"
            ],
            [
                "sniNames",
                "java.util.List<javax.net.ssl.SNIServerName>"
            ],
            [
                "sniMatchers",
                "java.util.Collection<javax.net.ssl.SNIMatcher>"
            ],
            [
                "preferLocalCipherSuites",
                "boolean"
            ],
            [
                "enableRetransmissions",
                "boolean"
            ],
            [
                "maximumPacketSize",
                "int"
            ],
            [
                "applicationProtocols",
                "java.lang.String[]"
            ],
            [
                "signatureSchemes",
                "java.lang.String[]"
            ],
            [
                "namedGroups",
                "java.lang.String[]"
            ]
        ],
        "SSLPeerUnverifiedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SSLPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SSLProtocolException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "SSLServerSocket": [],
        "SSLServerSocketFactory": [],
        "SSLSession": [],
        "SSLSessionBindingEvent": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "name",
                "java.lang.String"
            ]
        ],
        "SSLSessionBindingListener": [],
        "SSLSessionContext": [],
        "SSLSocket": [],
        "SSLSocketFactory": [],
        "StandardConstants": [
            [
                "SNI_HOST_NAME",
                "int"
            ]
        ],
        "TrustManager": [],
        "TrustManagerFactory": [
            [
                "provider",
                "java.security.Provider"
            ],
            [
                "factorySpi",
                "javax.net.ssl.TrustManagerFactorySpi"
            ],
            [
                "algorithm",
                "java.lang.String"
            ]
        ],
        "TrustManagerFactorySpi": [],
        "X509ExtendedKeyManager": [],
        "X509ExtendedTrustManager": [],
        "X509KeyManager": [],
        "X509TrustManager": []
    },
    "javax.security.auth": {
        "AuthPermission": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "DestroyFailedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Destroyable": [],
        "PrivateCredentialPermission": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "EMPTY_PRINCIPALS",
                "javax.security.auth.PrivateCredentialPermission$CredOwner[]"
            ],
            [
                "credentialClass",
                "java.lang.String"
            ],
            [
                "principals",
                "java.util.Set<java.security.Principal>"
            ],
            [
                "credOwners",
                "javax.security.auth.PrivateCredentialPermission$CredOwner[]"
            ]
        ],
        "RefreshFailedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "Refreshable": [],
        "Subject": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "readOnly",
                "boolean"
            ],
            [
                "PRINCIPAL_SET",
                "int"
            ],
            [
                "PUB_CREDENTIAL_SET",
                "int"
            ],
            [
                "PRIV_CREDENTIAL_SET",
                "int"
            ],
            [
                "NULL_PD_ARRAY",
                "java.security.ProtectionDomain[]"
            ],
            [
                "SCOPED_SUBJECT",
                "java.lang.ScopedValue<javax.security.auth.Subject>"
            ]
        ],
        "SubjectDomainCombiner": [
            [
                "subject",
                "javax.security.auth.Subject"
            ],
            [
                "cachedPDs",
                "java.security.ProtectionDomain>"
            ],
            [
                "principalSet",
                "java.util.Set<java.security.Principal>"
            ],
            [
                "principals",
                "java.security.Principal[]"
            ],
            [
                "debug",
                "sun.security.util.Debug"
            ]
        ]
    },
    "javax.security.auth.callback": {
        "Callback": [],
        "CallbackHandler": [],
        "ChoiceCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "prompt",
                "java.lang.String"
            ],
            [
                "choices",
                "java.lang.String[]"
            ],
            [
                "defaultChoice",
                "int"
            ],
            [
                "multipleSelectionsAllowed",
                "boolean"
            ],
            [
                "selections",
                "int[]"
            ]
        ],
        "ConfirmationCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "UNSPECIFIED_OPTION",
                "int"
            ],
            [
                "YES_NO_OPTION",
                "int"
            ],
            [
                "YES_NO_CANCEL_OPTION",
                "int"
            ],
            [
                "OK_CANCEL_OPTION",
                "int"
            ],
            [
                "YES",
                "int"
            ],
            [
                "NO",
                "int"
            ],
            [
                "CANCEL",
                "int"
            ],
            [
                "OK",
                "int"
            ],
            [
                "INFORMATION",
                "int"
            ],
            [
                "WARNING",
                "int"
            ],
            [
                "ERROR",
                "int"
            ],
            [
                "prompt",
                "java.lang.String"
            ],
            [
                "messageType",
                "int"
            ],
            [
                "optionType",
                "int"
            ],
            [
                "defaultOption",
                "int"
            ],
            [
                "options",
                "java.lang.String[]"
            ],
            [
                "selection",
                "int"
            ]
        ],
        "LanguageCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "locale",
                "java.util.Locale"
            ]
        ],
        "NameCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "prompt",
                "java.lang.String"
            ],
            [
                "defaultName",
                "java.lang.String"
            ],
            [
                "inputName",
                "java.lang.String"
            ]
        ],
        "PasswordCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "cleanable",
                "java.lang.ref.Cleaner$Cleanable"
            ],
            [
                "prompt",
                "java.lang.String"
            ],
            [
                "echoOn",
                "boolean"
            ],
            [
                "inputPassword",
                "char[]"
            ]
        ],
        "TextInputCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "prompt",
                "java.lang.String"
            ],
            [
                "defaultText",
                "java.lang.String"
            ],
            [
                "inputText",
                "java.lang.String"
            ]
        ],
        "TextOutputCallback": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "INFORMATION",
                "int"
            ],
            [
                "WARNING",
                "int"
            ],
            [
                "ERROR",
                "int"
            ],
            [
                "messageType",
                "int"
            ],
            [
                "message",
                "java.lang.String"
            ]
        ],
        "UnsupportedCallbackException": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "callback",
                "javax.security.auth.callback.Callback"
            ]
        ]
    },
    "javax.security.auth.login": {
        "AccountException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AccountExpiredException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AccountLockedException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AccountNotFoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "AppConfigurationEntry": [
            [
                "loginModuleName",
                "java.lang.String"
            ],
            [
                "controlFlag",
                "javax.security.auth.login.AppConfigurationEntry$LoginModuleControlFlag"
            ],
            [
                "options",
                "?>"
            ]
        ],
        "Configuration": [
            [
                "configuration",
                "javax.security.auth.login.Configuration"
            ]
        ],
        "ConfigurationSpi": [],
        "CredentialException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CredentialExpiredException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CredentialNotFoundException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "FailedLoginException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "LoginContext": [
            [
                "LOGIN_METHOD",
                "java.lang.String"
            ],
            [
                "COMMIT_METHOD",
                "java.lang.String"
            ],
            [
                "ABORT_METHOD",
                "java.lang.String"
            ],
            [
                "LOGOUT_METHOD",
                "java.lang.String"
            ],
            [
                "OTHER",
                "java.lang.String"
            ],
            [
                "DEFAULT_HANDLER",
                "java.lang.String"
            ],
            [
                "subject",
                "javax.security.auth.Subject"
            ],
            [
                "subjectProvided",
                "boolean"
            ],
            [
                "loginSucceeded",
                "boolean"
            ],
            [
                "callbackHandler",
                "javax.security.auth.callback.CallbackHandler"
            ],
            [
                "state",
                "?>"
            ],
            [
                "config",
                "javax.security.auth.login.Configuration"
            ],
            [
                "moduleStack",
                "javax.security.auth.login.LoginContext$ModuleInfo[]"
            ],
            [
                "contextClassLoader",
                "java.lang.ClassLoader"
            ],
            [
                "moduleIndex",
                "int"
            ],
            [
                "firstError",
                "javax.security.auth.login.LoginException"
            ],
            [
                "firstRequiredError",
                "javax.security.auth.login.LoginException"
            ],
            [
                "success",
                "boolean"
            ],
            [
                "debug",
                "sun.security.util.Debug"
            ],
            [
                "providersCache",
                "java.util.Set<java.util.ServiceLoader$Provider<javax.security.auth.spi.LoginModule>>>"
            ]
        ],
        "LoginException": [
            [
                "serialVersionUID",
                "long"
            ]
        ]
    },
    "javax.security.auth.spi": {
        "LoginModule": []
    },
    "javax.security.auth.x500": {
        "X500Principal": [
            [
                "serialVersionUID",
                "long"
            ],
            [
                "RFC1779",
                "java.lang.String"
            ],
            [
                "RFC2253",
                "java.lang.String"
            ],
            [
                "CANONICAL",
                "java.lang.String"
            ],
            [
                "thisX500Name",
                "sun.security.x509.X500Name"
            ]
        ],
        "X500PrivateCredential": [
            [
                "cert",
                "java.security.cert.X509Certificate"
            ],
            [
                "key",
                "java.security.PrivateKey"
            ],
            [
                "alias",
                "java.lang.String"
            ]
        ]
    },
    "javax.security.cert": {
        "Certificate": [],
        "CertificateEncodingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateExpiredException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateNotYetValidException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "CertificateParsingException": [
            [
                "serialVersionUID",
                "long"
            ]
        ],
        "X509Certificate": [
            [
                "X509_PROVIDER",
                "java.lang.String"
            ],
            [
                "X509Provider",
                "java.lang.String"
            ]
        ]
    },
    "jdk.internal": {
        "ValueBased": []
    },
    "jdk.internal.access": {
        "JavaAWTAccess": [],
        "JavaAWTFontAccess": [],
        "JavaBeansAccess": [],
        "JavaIOAccess": [],
        "JavaIOFileDescriptorAccess": [],
        "JavaIOFilePermissionAccess": [],
        "JavaIORandomAccessFileAccess": [],
        "JavaLangAccess": [],
        "JavaLangInvokeAccess": [],
        "JavaLangModuleAccess": [],
        "JavaLangRefAccess": [],
        "JavaLangReflectAccess": [],
        "JavaNetHttpCookieAccess": [],
        "JavaNetInetAddressAccess": [],
        "JavaNetURLAccess": [],
        "JavaNetUriAccess": [],
        "JavaNioAccess": [],
        "JavaObjectInputFilterAccess": [],
        "JavaObjectInputStreamAccess": [],
        "JavaObjectInputStreamReadString": [],
        "JavaObjectStreamReflectionAccess": [],
        "JavaSecurityPropertiesAccess": [],
        "JavaSecuritySignatureAccess": [],
        "JavaSecuritySpecAccess": [],
        "JavaUtilCollectionAccess": [],
        "JavaUtilConcurrentFJPAccess": [],
        "JavaUtilConcurrentTLRAccess": [],
        "JavaUtilJarAccess": [],
        "JavaUtilResourceBundleAccess": [],
        "JavaUtilZipFileAccess": [],
        "JavaxCryptoSealedObjectAccess": [],
        "JavaxCryptoSpecAccess": [],
        "JavaxSecurityAccess": [],
        "SharedSecrets": [
            [
                "javaAWTAccess",
                "jdk.internal.access.JavaAWTAccess"
            ],
            [
                "javaAWTFontAccess",
                "jdk.internal.access.JavaAWTFontAccess"
            ],
            [
                "javaBeansAccess",
                "jdk.internal.access.JavaBeansAccess"
            ],
            [
                "javaLangAccess",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "javaLangInvokeAccess",
                "jdk.internal.access.JavaLangInvokeAccess"
            ],
            [
                "javaLangModuleAccess",
                "jdk.internal.access.JavaLangModuleAccess"
            ],
            [
                "javaLangRefAccess",
                "jdk.internal.access.JavaLangRefAccess"
            ],
            [
                "javaLangReflectAccess",
                "jdk.internal.access.JavaLangReflectAccess"
            ],
            [
                "javaIOAccess",
                "jdk.internal.access.JavaIOAccess"
            ],
            [
                "javaIOFileDescriptorAccess",
                "jdk.internal.access.JavaIOFileDescriptorAccess"
            ],
            [
                "javaIOFilePermissionAccess",
                "jdk.internal.access.JavaIOFilePermissionAccess"
            ],
            [
                "javaIORandomAccessFileAccess",
                "jdk.internal.access.JavaIORandomAccessFileAccess"
            ],
            [
                "javaObjectInputStreamReadString",
                "jdk.internal.access.JavaObjectInputStreamReadString"
            ],
            [
                "javaObjectInputStreamAccess",
                "jdk.internal.access.JavaObjectInputStreamAccess"
            ],
            [
                "javaObjectInputFilterAccess",
                "jdk.internal.access.JavaObjectInputFilterAccess"
            ],
            [
                "javaObjectStreamReflectionAccess",
                "jdk.internal.access.JavaObjectStreamReflectionAccess"
            ],
            [
                "javaNetInetAddressAccess",
                "jdk.internal.access.JavaNetInetAddressAccess"
            ],
            [
                "javaNetHttpCookieAccess",
                "jdk.internal.access.JavaNetHttpCookieAccess"
            ],
            [
                "javaNetUriAccess",
                "jdk.internal.access.JavaNetUriAccess"
            ],
            [
                "javaNetURLAccess",
                "jdk.internal.access.JavaNetURLAccess"
            ],
            [
                "javaNioAccess",
                "jdk.internal.access.JavaNioAccess"
            ],
            [
                "javaUtilCollectionAccess",
                "jdk.internal.access.JavaUtilCollectionAccess"
            ],
            [
                "javaUtilConcurrentTLRAccess",
                "jdk.internal.access.JavaUtilConcurrentTLRAccess"
            ],
            [
                "javaUtilConcurrentFJPAccess",
                "jdk.internal.access.JavaUtilConcurrentFJPAccess"
            ],
            [
                "javaUtilJarAccess",
                "jdk.internal.access.JavaUtilJarAccess"
            ],
            [
                "javaUtilZipFileAccess",
                "jdk.internal.access.JavaUtilZipFileAccess"
            ],
            [
                "javaUtilResourceBundleAccess",
                "jdk.internal.access.JavaUtilResourceBundleAccess"
            ],
            [
                "javaSecurityPropertiesAccess",
                "jdk.internal.access.JavaSecurityPropertiesAccess"
            ],
            [
                "javaSecuritySignatureAccess",
                "jdk.internal.access.JavaSecuritySignatureAccess"
            ],
            [
                "javaSecuritySpecAccess",
                "jdk.internal.access.JavaSecuritySpecAccess"
            ],
            [
                "javaxCryptoSealedObjectAccess",
                "jdk.internal.access.JavaxCryptoSealedObjectAccess"
            ],
            [
                "javaxCryptoSpecAccess",
                "jdk.internal.access.JavaxCryptoSpecAccess"
            ],
            [
                "javaxSecurityAccess",
                "jdk.internal.access.JavaxSecurityAccess"
            ]
        ]
    },
    "jdk.internal.access.foreign": {
        "MappedMemoryUtilsProxy": [],
        "UnmapperProxy": []
    },
    "jdk.internal.classfile.components": {
        "ClassPrinter": [],
        "ClassRemapper": [],
        "CodeLocalsShifter": [],
        "CodeRelabeler": [],
        "CodeStackTracker": []
    },
    "jdk.internal.classfile.impl": {
        "AbstractAttributeMapper": [
            [
                "name",
                "java.lang.String"
            ],
            [
                "stability",
                "java.lang.classfile.AttributeMapper$AttributeStability"
            ],
            [
                "allowMultiple",
                "boolean"
            ]
        ],
        "AbstractBoundLocalVariable": [
            [
                "code",
                "jdk.internal.classfile.impl.CodeImpl"
            ],
            [
                "offset",
                "int"
            ],
            [
                "nameEntry",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "secondaryEntry",
                "java.lang.classfile.constantpool.Utf8Entry"
            ]
        ],
        "AbstractDirectBuilder": [
            [
                "constantPool",
                "jdk.internal.classfile.impl.SplitConstantPool"
            ],
            [
                "context",
                "jdk.internal.classfile.impl.ClassFileImpl"
            ],
            [
                "attributes",
                "jdk.internal.classfile.impl.AttributeHolder"
            ],
            [
                "original",
                "M"
            ]
        ],
        "AbstractElement": [],
        "AbstractInstruction": [
            [
                "FMT_ArgumentConstant",
                "java.lang.String"
            ],
            [
                "FMT_Branch",
                "java.lang.String"
            ],
            [
                "FMT_Field",
                "java.lang.String"
            ],
            [
                "FMT_Increment",
                "java.lang.String"
            ],
            [
                "FMT_Invoke",
                "java.lang.String"
            ],
            [
                "FMT_InvokeDynamic",
                "java.lang.String"
            ],
            [
                "FMT_InvokeInterface",
                "java.lang.String"
            ],
            [
                "FMT_Load",
                "java.lang.String"
            ],
            [
                "FMT_LoadConstant",
                "java.lang.String"
            ],
            [
                "FMT_LookupSwitch",
                "java.lang.String"
            ],
            [
                "FMT_NewMultiArray",
                "java.lang.String"
            ],
            [
                "FMT_NewObj",
                "java.lang.String"
            ],
            [
                "FMT_NewPrimitiveArray",
                "java.lang.String"
            ],
            [
                "FMT_NewRefArray",
                "java.lang.String"
            ],
            [
                "FMT_Return",
                "java.lang.String"
            ],
            [
                "FMT_Store",
                "java.lang.String"
            ],
            [
                "FMT_TableSwitch",
                "java.lang.String"
            ],
            [
                "FMT_Throw",
                "java.lang.String"
            ],
            [
                "FMT_TypeCheck",
                "java.lang.String"
            ],
            [
                "FMT_Unbound",
                "java.lang.String"
            ],
            [
                "FMT_Discontinued",
                "java.lang.String"
            ]
        ],
        "AbstractPoolEntry": [
            [
                "TAG_SMEAR",
                "int"
            ],
            [
                "index",
                "int"
            ],
            [
                "hash",
                "int"
            ]
        ],
        "AbstractPseudoInstruction": [],
        "AbstractUnboundModel": [
            [
                "attributes",
                "java.util.List<java.lang.classfile.Attribute<?>>"
            ]
        ],
        "AccessFlagsImpl": [
            [
                "location",
                "java.lang.reflect.AccessFlag$Location"
            ],
            [
                "flagsMask",
                "int"
            ],
            [
                "flags",
                "java.util.Set<java.lang.reflect.AccessFlag>"
            ]
        ],
        "AnnotationImpl": [
            [
                "className",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "elements",
                "java.util.List<java.lang.classfile.AnnotationElement>"
            ]
        ],
        "AnnotationReader": [],
        "AttributeHolder": [
            [
                "EMPTY_ATTRIBUTE_ARRAY",
                "java.lang.classfile.Attribute<?>[]"
            ],
            [
                "attributesCount",
                "int"
            ],
            [
                "attributes",
                "java.lang.classfile.Attribute<?>[]"
            ]
        ],
        "BlockCodeBuilderImpl": [
            [
                "startLabel",
                "java.lang.classfile.Label"
            ],
            [
                "endLabel",
                "java.lang.classfile.Label"
            ],
            [
                "breakLabel",
                "java.lang.classfile.Label"
            ],
            [
                "reachable",
                "boolean"
            ],
            [
                "hasInstructions",
                "boolean"
            ],
            [
                "topLocal",
                "int"
            ],
            [
                "terminalMaxLocals",
                "int"
            ]
        ],
        "BootstrapMethodEntryImpl": [
            [
                "constantPool",
                "java.lang.classfile.constantpool.ConstantPool"
            ],
            [
                "handle",
                "jdk.internal.classfile.impl.AbstractPoolEntry$MethodHandleEntryImpl"
            ],
            [
                "arguments",
                "java.util.List<java.lang.classfile.constantpool.LoadableConstantEntry>"
            ]
        ],
        "BoundAttribute": [
            [
                "mapper",
                "java.lang.classfile.AttributeMapper<T>"
            ]
        ],
        "BoundCharacterRange": [
            [
                "code",
                "jdk.internal.classfile.impl.CodeImpl"
            ],
            [
                "offset",
                "int"
            ]
        ],
        "BoundLocalVariable": [],
        "BoundLocalVariableType": [],
        "BoundRecordComponentInfo": [
            [
                "reader",
                "java.lang.classfile.ClassReader"
            ],
            [
                "startPos",
                "int"
            ],
            [
                "attributesPos",
                "int"
            ],
            [
                "attributes",
                "java.util.List<java.lang.classfile.Attribute<?>>"
            ]
        ],
        "BufWriterImpl": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "constantPool",
                "java.lang.classfile.constantpool.ConstantPoolBuilder"
            ],
            [
                "context",
                "jdk.internal.classfile.impl.ClassFileImpl"
            ],
            [
                "labelContext",
                "jdk.internal.classfile.impl.LabelContext"
            ],
            [
                "thisClass",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "majorVersion",
                "int"
            ]
        ],
        "BufferedCodeBuilder": [
            [
                "constantPool",
                "jdk.internal.classfile.impl.SplitConstantPool"
            ],
            [
                "context",
                "jdk.internal.classfile.impl.ClassFileImpl"
            ],
            [
                "elements",
                "java.util.List<java.lang.classfile.CodeElement>"
            ],
            [
                "startLabel",
                "jdk.internal.classfile.impl.LabelImpl"
            ],
            [
                "endLabel",
                "jdk.internal.classfile.impl.LabelImpl"
            ],
            [
                "methodInfo",
                "jdk.internal.classfile.impl.MethodInfo"
            ],
            [
                "finished",
                "boolean"
            ],
            [
                "maxLocals",
                "int"
            ]
        ],
        "BufferedFieldBuilder": [
            [
                "constantPool",
                "jdk.internal.classfile.impl.SplitConstantPool"
            ],
            [
                "context",
                "jdk.internal.classfile.impl.ClassFileImpl"
            ],
            [
                "name",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "desc",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "elements",
                "java.util.List<java.lang.classfile.FieldElement>"
            ],
            [
                "flags",
                "java.lang.classfile.AccessFlags"
            ]
        ],
        "BufferedMethodBuilder": [
            [
                "elements",
                "java.util.List<java.lang.classfile.MethodElement>"
            ],
            [
                "constantPool",
                "jdk.internal.classfile.impl.SplitConstantPool"
            ],
            [
                "context",
                "jdk.internal.classfile.impl.ClassFileImpl"
            ],
            [
                "name",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "desc",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "flags",
                "java.lang.classfile.AccessFlags"
            ],
            [
                "original",
                "java.lang.classfile.MethodModel"
            ],
            [
                "parameterSlots",
                "int[]"
            ]
        ],
        "BytecodeHelpers": [],
        "CatchBuilderImpl": [],
        "ChainedClassBuilder": [
            [
                "terminal",
                "jdk.internal.classfile.impl.DirectClassBuilder"
            ],
            [
                "consumer",
                "java.util.function.Consumer<java.lang.classfile.ClassElement>"
            ]
        ],
        "ChainedCodeBuilder": [
            [
                "consumer",
                "java.util.function.Consumer<java.lang.classfile.CodeElement>"
            ]
        ],
        "ChainedFieldBuilder": [
            [
                "terminal",
                "jdk.internal.classfile.impl.TerminalFieldBuilder"
            ],
            [
                "consumer",
                "java.util.function.Consumer<java.lang.classfile.FieldElement>"
            ]
        ],
        "ChainedMethodBuilder": [],
        "ClassFileImpl": [
            [
                "stackMapsOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "debugElementsOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "lineNumbersOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "attributesProcessingOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "constantPoolSharingOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "shortJumpsOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "deadCodeOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "deadLabelsOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "classHierarchyResolverOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "attributeMapperOption",
                "java.lang.classfile.ClassFile$Option"
            ],
            [
                "DEFAULT_CONTEXT",
                "jdk.internal.classfile.impl.ClassFileImpl"
            ]
        ],
        "ClassFileVersionImpl": [
            [
                "majorVersion",
                "int"
            ],
            [
                "minorVersion",
                "int"
            ]
        ],
        "ClassHierarchyImpl": [
            [
                "DEFAULT_RESOLVER",
                "java.lang.classfile.ClassHierarchyResolver"
            ],
            [
                "resolver",
                "java.lang.classfile.ClassHierarchyResolver"
            ]
        ],
        "ClassImpl": [
            [
                "attributesPos",
                "int"
            ],
            [
                "methods",
                "java.util.List<java.lang.classfile.MethodModel>"
            ],
            [
                "fields",
                "java.util.List<java.lang.classfile.FieldModel>"
            ],
            [
                "attributes",
                "java.util.List<java.lang.classfile.Attribute<?>>"
            ],
            [
                "interfaces",
                "java.util.List<java.lang.classfile.constantpool.ClassEntry>"
            ]
        ],
        "ClassPrinterImpl": [
            [
                "NL",
                "java.lang.String"
            ],
            [
                "DIGITS",
                "char[]"
            ]
        ],
        "ClassReaderImpl": [
            [
                "buffer",
                "byte[]"
            ],
            [
                "metadataStart",
                "int"
            ],
            [
                "classfileLength",
                "int"
            ],
            [
                "attributeMapper",
                "java.lang.classfile.AttributeMapper<?>>"
            ],
            [
                "flags",
                "int"
            ],
            [
                "thisClassPos",
                "int"
            ],
            [
                "thisClass",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "superclass",
                "java.util.Optional<java.lang.classfile.constantpool.ClassEntry>"
            ],
            [
                "constantPoolCount",
                "int"
            ],
            [
                "cpOffset",
                "int[]"
            ],
            [
                "containedClass",
                "java.lang.classfile.ClassModel"
            ],
            [
                "bsmEntries",
                "java.util.List<jdk.internal.classfile.impl.BootstrapMethodEntryImpl>"
            ],
            [
                "bootstrapMethodsAttribute",
                "java.lang.classfile.attribute.BootstrapMethodsAttribute"
            ]
        ],
        "ClassRemapperImpl": [
            [
                "mapFunction",
                "java.lang.constant.ClassDesc>"
            ]
        ],
        "CodeImpl": [],
        "CodeLocalsShifterImpl": [
            [
                "locals",
                "int[]"
            ],
            [
                "fixed",
                "int"
            ]
        ],
        "CodeRelabelerImpl": [
            [
                "mapFunction",
                "java.lang.classfile.Label>"
            ]
        ],
        "CodeStackTrackerImpl": [
            [
                "stack",
                "jdk.internal.classfile.impl.CodeStackTrackerImpl$Stack"
            ],
            [
                "maxSize",
                "java.lang.Integer"
            ],
            [
                "map",
                "jdk.internal.classfile.impl.CodeStackTrackerImpl$Stack>"
            ]
        ],
        "DirectClassBuilder": [
            [
                "fields",
                "jdk.internal.classfile.impl.Util$Writable[]"
            ],
            [
                "methods",
                "jdk.internal.classfile.impl.Util$Writable[]"
            ],
            [
                "fieldsCount",
                "int"
            ],
            [
                "methodsCount",
                "int"
            ],
            [
                "superclassEntry",
                "java.lang.classfile.constantpool.ClassEntry"
            ],
            [
                "interfaceEntries",
                "java.util.List<java.lang.classfile.constantpool.ClassEntry>"
            ],
            [
                "majorVersion",
                "int"
            ],
            [
                "minorVersion",
                "int"
            ],
            [
                "flags",
                "int"
            ],
            [
                "sizeHint",
                "int"
            ]
        ],
        "DirectCodeBuilder": [
            [
                "EMPTY_CHARACTER_RANGE",
                "java.lang.classfile.instruction.CharacterRange[]"
            ],
            [
                "EMPTY_LABEL_ARRAY",
                "jdk.internal.classfile.impl.DirectCodeBuilder$DeferredLabel[]"
            ],
            [
                "EMPTY_LOCAL_VARIABLE_ARRAY",
                "java.lang.classfile.instruction.LocalVariable[]"
            ],
            [
                "EMPTY_LOCAL_VARIABLE_TYPE_ARRAY",
                "java.lang.classfile.instruction.LocalVariableType[]"
            ],
            [
                "EMPTY_HANDLER_ARRAY",
                "jdk.internal.classfile.impl.AbstractPseudoInstruction$ExceptionCatchImpl[]"
            ],
            [
                "EMPTY_DEFERRED_LABEL_ARRAY",
                "jdk.internal.classfile.impl.DirectCodeBuilder$DeferredLabel[]"
            ],
            [
                "characterRanges",
                "java.lang.classfile.instruction.CharacterRange[]"
            ],
            [
                "localVariables",
                "java.lang.classfile.instruction.LocalVariable[]"
            ],
            [
                "localVariableTypes",
                "java.lang.classfile.instruction.LocalVariableType[]"
            ],
            [
                "characterRangesCount",
                "int"
            ],
            [
                "localVariablesCount",
                "int"
            ],
            [
                "localVariableTypesCount",
                "int"
            ],
            [
                "transformDeferredJumps",
                "boolean"
            ],
            [
                "transformKnownJumps",
                "boolean"
            ],
            [
                "startLabel",
                "java.lang.classfile.Label"
            ],
            [
                "endLabel",
                "java.lang.classfile.Label"
            ],
            [
                "mruParent",
                "java.lang.classfile.attribute.CodeAttribute"
            ],
            [
                "mruParentTable",
                "int[]"
            ],
            [
                "parentMap",
                "int[]>"
            ],
            [
                "lineNumberWriter",
                "jdk.internal.classfile.impl.DirectCodeBuilder$DedupLineNumberTableAttribute"
            ],
            [
                "topLocal",
                "int"
            ],
            [
                "deferredLabels",
                "jdk.internal.classfile.impl.DirectCodeBuilder$DeferredLabel[]"
            ],
            [
                "deferredLabelsCount",
                "int"
            ],
            [
                "content",
                "jdk.internal.classfile.impl.UnboundAttribute<java.lang.classfile.attribute.CodeAttribute>"
            ]
        ],
        "DirectFieldBuilder": [
            [
                "name",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "desc",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "flags",
                "int"
            ]
        ],
        "DirectMethodBuilder": [],
        "EntryMap": [
            [
                "NO_VALUE",
                "int"
            ],
            [
                "data",
                "int[]"
            ],
            [
                "fillFactor",
                "float"
            ],
            [
                "resizeThreshold",
                "int"
            ],
            [
                "size",
                "int"
            ],
            [
                "mask1",
                "int"
            ],
            [
                "mask2",
                "int"
            ]
        ],
        "FieldImpl": [
            [
                "reader",
                "java.lang.classfile.ClassReader"
            ],
            [
                "startPos",
                "int"
            ],
            [
                "endPos",
                "int"
            ],
            [
                "attributesPos",
                "int"
            ],
            [
                "attributes",
                "java.util.List<java.lang.classfile.Attribute<?>>"
            ]
        ],
        "InterfacesImpl": [
            [
                "interfaces",
                "java.util.List<java.lang.classfile.constantpool.ClassEntry>"
            ]
        ],
        "LabelContext": [],
        "LabelImpl": [
            [
                "labelContext",
                "jdk.internal.classfile.impl.LabelContext"
            ],
            [
                "bci",
                "int"
            ]
        ],
        "LineNumberImpl": [
            [
                "INTERN_LIMIT",
                "int"
            ],
            [
                "internCache",
                "java.lang.classfile.instruction.LineNumber[]"
            ],
            [
                "line",
                "int"
            ]
        ],
        "MethodImpl": [
            [
                "reader",
                "java.lang.classfile.ClassReader"
            ],
            [
                "startPos",
                "int"
            ],
            [
                "endPos",
                "int"
            ],
            [
                "attributesPos",
                "int"
            ],
            [
                "attributes",
                "java.util.List<java.lang.classfile.Attribute<?>>"
            ],
            [
                "parameterSlots",
                "int[]"
            ]
        ],
        "MethodInfo": [],
        "ModuleAttributeBuilderImpl": [
            [
                "moduleEntry",
                "java.lang.classfile.constantpool.ModuleEntry"
            ],
            [
                "moduleVersion",
                "java.lang.classfile.constantpool.Utf8Entry"
            ],
            [
                "moduleFlags",
                "int"
            ],
            [
                "requires",
                "java.util.Set<java.lang.classfile.attribute.ModuleRequireInfo>"
            ],
            [
                "exports",
                "java.util.Set<java.lang.classfile.attribute.ModuleExportInfo>"
            ],
            [
                "opens",
                "java.util.Set<java.lang.classfile.attribute.ModuleOpenInfo>"
            ],
            [
                "uses",
                "java.util.Set<java.lang.classfile.constantpool.ClassEntry>"
            ],
            [
                "provides",
                "java.util.Set<java.lang.classfile.attribute.ModuleProvideInfo>"
            ]
        ],
        "NonterminalCodeBuilder": [
            [
                "terminal",
                "jdk.internal.classfile.impl.TerminalCodeBuilder"
            ],
            [
                "parent",
                "java.lang.classfile.CodeBuilder"
            ]
        ],
        "RawBytecodeHelper": [
            [
                "IAE_FORMATTER",
                "java.lang.IllegalArgumentException>"
            ],
            [
                "ILLEGAL",
                "int"
            ],
            [
                "NOP",
                "int"
            ],
            [
                "ACONST_NULL",
                "int"
            ],
            [
                "ICONST_M1",
                "int"
            ],
            [
                "ICONST_0",
                "int"
            ],
            [
                "ICONST_1",
                "int"
            ],
            [
                "ICONST_2",
                "int"
            ],
            [
                "ICONST_3",
                "int"
            ],
            [
                "ICONST_4",
                "int"
            ],
            [
                "ICONST_5",
                "int"
            ],
            [
                "LCONST_0",
                "int"
            ],
            [
                "LCONST_1",
                "int"
            ],
            [
                "FCONST_0",
                "int"
            ],
            [
                "FCONST_1",
                "int"
            ],
            [
                "FCONST_2",
                "int"
            ],
            [
                "DCONST_0",
                "int"
            ],
            [
                "DCONST_1",
                "int"
            ],
            [
                "BIPUSH",
                "int"
            ],
            [
                "SIPUSH",
                "int"
            ],
            [
                "LDC",
                "int"
            ],
            [
                "LDC_W",
                "int"
            ],
            [
                "LDC2_W",
                "int"
            ],
            [
                "ILOAD",
                "int"
            ],
            [
                "LLOAD",
                "int"
            ],
            [
                "FLOAD",
                "int"
            ],
            [
                "DLOAD",
                "int"
            ],
            [
                "ALOAD",
                "int"
            ],
            [
                "ILOAD_0",
                "int"
            ],
            [
                "ILOAD_1",
                "int"
            ],
            [
                "ILOAD_2",
                "int"
            ],
            [
                "ILOAD_3",
                "int"
            ],
            [
                "LLOAD_0",
                "int"
            ],
            [
                "LLOAD_1",
                "int"
            ],
            [
                "LLOAD_2",
                "int"
            ],
            [
                "LLOAD_3",
                "int"
            ],
            [
                "FLOAD_0",
                "int"
            ],
            [
                "FLOAD_1",
                "int"
            ],
            [
                "FLOAD_2",
                "int"
            ],
            [
                "FLOAD_3",
                "int"
            ],
            [
                "DLOAD_0",
                "int"
            ],
            [
                "DLOAD_1",
                "int"
            ],
            [
                "DLOAD_2",
                "int"
            ],
            [
                "DLOAD_3",
                "int"
            ],
            [
                "ALOAD_0",
                "int"
            ],
            [
                "ALOAD_1",
                "int"
            ],
            [
                "ALOAD_2",
                "int"
            ],
            [
                "ALOAD_3",
                "int"
            ],
            [
                "IALOAD",
                "int"
            ],
            [
                "LALOAD",
                "int"
            ],
            [
                "FALOAD",
                "int"
            ],
            [
                "DALOAD",
                "int"
            ],
            [
                "AALOAD",
                "int"
            ],
            [
                "BALOAD",
                "int"
            ],
            [
                "CALOAD",
                "int"
            ],
            [
                "SALOAD",
                "int"
            ],
            [
                "ISTORE",
                "int"
            ],
            [
                "LSTORE",
                "int"
            ],
            [
                "FSTORE",
                "int"
            ],
            [
                "DSTORE",
                "int"
            ],
            [
                "ASTORE",
                "int"
            ],
            [
                "ISTORE_0",
                "int"
            ],
            [
                "ISTORE_1",
                "int"
            ],
            [
                "ISTORE_2",
                "int"
            ],
            [
                "ISTORE_3",
                "int"
            ],
            [
                "LSTORE_0",
                "int"
            ],
            [
                "LSTORE_1",
                "int"
            ],
            [
                "LSTORE_2",
                "int"
            ],
            [
                "LSTORE_3",
                "int"
            ],
            [
                "FSTORE_0",
                "int"
            ],
            [
                "FSTORE_1",
                "int"
            ],
            [
                "FSTORE_2",
                "int"
            ],
            [
                "FSTORE_3",
                "int"
            ],
            [
                "DSTORE_0",
                "int"
            ],
            [
                "DSTORE_1",
                "int"
            ],
            [
                "DSTORE_2",
                "int"
            ],
            [
                "DSTORE_3",
                "int"
            ],
            [
                "ASTORE_0",
                "int"
            ],
            [
                "ASTORE_1",
                "int"
            ],
            [
                "ASTORE_2",
                "int"
            ],
            [
                "ASTORE_3",
                "int"
            ],
            [
                "IASTORE",
                "int"
            ],
            [
                "LASTORE",
                "int"
            ],
            [
                "FASTORE",
                "int"
            ],
            [
                "DASTORE",
                "int"
            ],
            [
                "AASTORE",
                "int"
            ],
            [
                "BASTORE",
                "int"
            ],
            [
                "CASTORE",
                "int"
            ],
            [
                "SASTORE",
                "int"
            ],
            [
                "POP",
                "int"
            ],
            [
                "POP2",
                "int"
            ],
            [
                "DUP",
                "int"
            ],
            [
                "DUP_X1",
                "int"
            ],
            [
                "DUP_X2",
                "int"
            ],
            [
                "DUP2",
                "int"
            ],
            [
                "DUP2_X1",
                "int"
            ],
            [
                "DUP2_X2",
                "int"
            ],
            [
                "SWAP",
                "int"
            ],
            [
                "IADD",
                "int"
            ],
            [
                "LADD",
                "int"
            ],
            [
                "FADD",
                "int"
            ],
            [
                "DADD",
                "int"
            ],
            [
                "ISUB",
                "int"
            ],
            [
                "LSUB",
                "int"
            ],
            [
                "FSUB",
                "int"
            ],
            [
                "DSUB",
                "int"
            ],
            [
                "IMUL",
                "int"
            ],
            [
                "LMUL",
                "int"
            ],
            [
                "FMUL",
                "int"
            ],
            [
                "DMUL",
                "int"
            ],
            [
                "IDIV",
                "int"
            ],
            [
                "LDIV",
                "int"
            ],
            [
                "FDIV",
                "int"
            ],
            [
                "DDIV",
                "int"
            ],
            [
                "IREM",
                "int"
            ],
            [
                "LREM",
                "int"
            ],
            [
                "FREM",
                "int"
            ],
            [
                "DREM",
                "int"
            ],
            [
                "INEG",
                "int"
            ],
            [
                "LNEG",
                "int"
            ],
            [
                "FNEG",
                "int"
            ],
            [
                "DNEG",
                "int"
            ],
            [
                "ISHL",
                "int"
            ],
            [
                "LSHL",
                "int"
            ],
            [
                "ISHR",
                "int"
            ],
            [
                "LSHR",
                "int"
            ],
            [
                "IUSHR",
                "int"
            ],
            [
                "LUSHR",
                "int"
            ],
            [
                "IAND",
                "int"
            ],
            [
                "LAND",
                "int"
            ],
            [
                "IOR",
                "int"
            ],
            [
                "LOR",
                "int"
            ],
            [
                "IXOR",
                "int"
            ],
            [
                "LXOR",
                "int"
            ],
            [
                "IINC",
                "int"
            ],
            [
                "I2L",
                "int"
            ],
            [
                "I2F",
                "int"
            ],
            [
                "I2D",
                "int"
            ],
            [
                "L2I",
                "int"
            ],
            [
                "L2F",
                "int"
            ],
            [
                "L2D",
                "int"
            ],
            [
                "F2I",
                "int"
            ],
            [
                "F2L",
                "int"
            ],
            [
                "F2D",
                "int"
            ],
            [
                "D2I",
                "int"
            ],
            [
                "D2L",
                "int"
            ],
            [
                "D2F",
                "int"
            ],
            [
                "I2B",
                "int"
            ],
            [
                "I2C",
                "int"
            ],
            [
                "I2S",
                "int"
            ],
            [
                "LCMP",
                "int"
            ],
            [
                "FCMPL",
                "int"
            ],
            [
                "FCMPG",
                "int"
            ],
            [
                "DCMPL",
                "int"
            ],
            [
                "DCMPG",
                "int"
            ],
            [
                "IFEQ",
                "int"
            ],
            [
                "IFNE",
                "int"
            ],
            [
                "IFLT",
                "int"
            ],
            [
                "IFGE",
                "int"
            ],
            [
                "IFGT",
                "int"
            ],
            [
                "IFLE",
                "int"
            ],
            [
                "IF_ICMPEQ",
                "int"
            ],
            [
                "IF_ICMPNE",
                "int"
            ],
            [
                "IF_ICMPLT",
                "int"
            ],
            [
                "IF_ICMPGE",
                "int"
            ],
            [
                "IF_ICMPGT",
                "int"
            ],
            [
                "IF_ICMPLE",
                "int"
            ],
            [
                "IF_ACMPEQ",
                "int"
            ],
            [
                "IF_ACMPNE",
                "int"
            ],
            [
                "GOTO",
                "int"
            ],
            [
                "JSR",
                "int"
            ],
            [
                "RET",
                "int"
            ],
            [
                "TABLESWITCH",
                "int"
            ],
            [
                "LOOKUPSWITCH",
                "int"
            ],
            [
                "IRETURN",
                "int"
            ],
            [
                "LRETURN",
                "int"
            ],
            [
                "FRETURN",
                "int"
            ],
            [
                "DRETURN",
                "int"
            ],
            [
                "ARETURN",
                "int"
            ],
            [
                "RETURN",
                "int"
            ],
            [
                "GETSTATIC",
                "int"
            ],
            [
                "PUTSTATIC",
                "int"
            ],
            [
                "GETFIELD",
                "int"
            ],
            [
                "PUTFIELD",
                "int"
            ],
            [
                "INVOKEVIRTUAL",
                "int"
            ],
            [
                "INVOKESPECIAL",
                "int"
            ],
            [
                "INVOKESTATIC",
                "int"
            ],
            [
                "INVOKEINTERFACE",
                "int"
            ],
            [
                "INVOKEDYNAMIC",
                "int"
            ],
            [
                "NEW",
                "int"
            ],
            [
                "NEWARRAY",
                "int"
            ],
            [
                "ANEWARRAY",
                "int"
            ],
            [
                "ARRAYLENGTH",
                "int"
            ],
            [
                "ATHROW",
                "int"
            ],
            [
                "CHECKCAST",
                "int"
            ],
            [
                "INSTANCEOF",
                "int"
            ],
            [
                "MONITORENTER",
                "int"
            ],
            [
                "MONITOREXIT",
                "int"
            ],
            [
                "WIDE",
                "int"
            ],
            [
                "MULTIANEWARRAY",
                "int"
            ],
            [
                "IFNULL",
                "int"
            ],
            [
                "IFNONNULL",
                "int"
            ],
            [
                "GOTO_W",
                "int"
            ],
            [
                "JSR_W",
                "int"
            ],
            [
                "LENGTHS",
                "byte[]"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ],
            [
                "code",
                "jdk.internal.classfile.impl.RawBytecodeHelper$CodeRange"
            ],
            [
                "nextBci",
                "int"
            ],
            [
                "bci",
                "int"
            ],
            [
                "opcode",
                "int"
            ]
        ],
        "SignaturesImpl": [
            [
                "sig",
                "java.lang.String"
            ],
            [
                "sigp",
                "int"
            ]
        ],
        "SplitConstantPool": [
            [
                "parent",
                "jdk.internal.classfile.impl.ClassReaderImpl"
            ],
            [
                "parentSize",
                "int"
            ],
            [
                "parentBsmSize",
                "int"
            ],
            [
                "size",
                "int"
            ],
            [
                "bsmSize",
                "int"
            ],
            [
                "myEntries",
                "java.lang.classfile.constantpool.PoolEntry[]"
            ],
            [
                "myBsmEntries",
                "jdk.internal.classfile.impl.BootstrapMethodEntryImpl[]"
            ],
            [
                "doneFullScan",
                "boolean"
            ],
            [
                "map",
                "jdk.internal.classfile.impl.EntryMap"
            ],
            [
                "bsmMap",
                "jdk.internal.classfile.impl.EntryMap"
            ]
        ],
        "StackCounter": [
            [
                "stack",
                "int"
            ],
            [
                "maxStack",
                "int"
            ],
            [
                "maxLocals",
                "int"
            ],
            [
                "rets",
                "int"
            ],
            [
                "bcs",
                "jdk.internal.classfile.impl.RawBytecodeHelper"
            ],
            [
                "thisClass",
                "java.lang.constant.ClassDesc"
            ],
            [
                "methodName",
                "java.lang.String"
            ],
            [
                "methodDesc",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "isStatic",
                "boolean"
            ],
            [
                "cp",
                "jdk.internal.classfile.impl.SplitConstantPool"
            ],
            [
                "targets",
                "java.util.Queue<jdk.internal.classfile.impl.StackCounter$Target>"
            ],
            [
                "visited",
                "java.util.BitSet"
            ]
        ],
        "StackMapDecoder": [
            [
                "SAME_LOCALS_1_STACK_ITEM_EXTENDED",
                "int"
            ],
            [
                "SAME_EXTENDED",
                "int"
            ],
            [
                "NO_STACK_FRAME_INFOS",
                "java.lang.classfile.attribute.StackMapFrameInfo[]"
            ],
            [
                "classReader",
                "java.lang.classfile.ClassReader"
            ],
            [
                "pos",
                "int"
            ],
            [
                "ctx",
                "jdk.internal.classfile.impl.LabelContext"
            ],
            [
                "initFrameLocals",
                "java.util.List<java.lang.classfile.attribute.StackMapFrameInfo$VerificationTypeInfo>"
            ],
            [
                "p",
                "int"
            ]
        ],
        "StackMapGenerator": [
            [
                "OBJECT_INITIALIZER_NAME",
                "java.lang.String"
            ],
            [
                "FLAG_THIS_UNINIT",
                "int"
            ],
            [
                "FRAME_DEFAULT_CAPACITY",
                "int"
            ],
            [
                "T_BOOLEAN",
                "int"
            ],
            [
                "T_LONG",
                "int"
            ],
            [
                "EMPTY_FRAME_ARRAY",
                "jdk.internal.classfile.impl.StackMapGenerator$Frame[]"
            ],
            [
                "ITEM_TOP",
                "int"
            ],
            [
                "ITEM_INTEGER",
                "int"
            ],
            [
                "ITEM_FLOAT",
                "int"
            ],
            [
                "ITEM_DOUBLE",
                "int"
            ],
            [
                "ITEM_LONG",
                "int"
            ],
            [
                "ITEM_NULL",
                "int"
            ],
            [
                "ITEM_UNINITIALIZED_THIS",
                "int"
            ],
            [
                "ITEM_OBJECT",
                "int"
            ],
            [
                "ITEM_UNINITIALIZED",
                "int"
            ],
            [
                "ITEM_BOOLEAN",
                "int"
            ],
            [
                "ITEM_BYTE",
                "int"
            ],
            [
                "ITEM_SHORT",
                "int"
            ],
            [
                "ITEM_CHAR",
                "int"
            ],
            [
                "ITEM_LONG_2ND",
                "int"
            ],
            [
                "ITEM_DOUBLE_2ND",
                "int"
            ],
            [
                "ARRAY_FROM_BASIC_TYPE",
                "jdk.internal.classfile.impl.StackMapGenerator$Type[]"
            ],
            [
                "thisType",
                "jdk.internal.classfile.impl.StackMapGenerator$Type"
            ],
            [
                "methodName",
                "java.lang.String"
            ],
            [
                "methodDesc",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "bytecode",
                "jdk.internal.classfile.impl.RawBytecodeHelper$CodeRange"
            ],
            [
                "cp",
                "jdk.internal.classfile.impl.SplitConstantPool"
            ],
            [
                "isStatic",
                "boolean"
            ],
            [
                "labelContext",
                "jdk.internal.classfile.impl.LabelContext"
            ],
            [
                "handlers",
                "java.util.List<jdk.internal.classfile.impl.AbstractPseudoInstruction$ExceptionCatchImpl>"
            ],
            [
                "rawHandlers",
                "java.util.List<jdk.internal.classfile.impl.StackMapGenerator$RawExceptionCatch>"
            ],
            [
                "classHierarchy",
                "jdk.internal.classfile.impl.ClassHierarchyImpl"
            ],
            [
                "patchDeadCode",
                "boolean"
            ],
            [
                "filterDeadLabels",
                "boolean"
            ],
            [
                "frames",
                "jdk.internal.classfile.impl.StackMapGenerator$Frame[]"
            ],
            [
                "framesCount",
                "int"
            ],
            [
                "currentFrame",
                "jdk.internal.classfile.impl.StackMapGenerator$Frame"
            ],
            [
                "maxStack",
                "int"
            ],
            [
                "maxLocals",
                "int"
            ],
            [
                "exMin",
                "int"
            ],
            [
                "exMax",
                "int"
            ]
        ],
        "SuperclassImpl": [
            [
                "superclassEntry",
                "java.lang.classfile.constantpool.ClassEntry"
            ]
        ],
        "TargetInfoImpl": [],
        "TemporaryConstantPool": [
            [
                "INSTANCE",
                "jdk.internal.classfile.impl.TemporaryConstantPool"
            ]
        ],
        "TerminalCodeBuilder": [],
        "TerminalFieldBuilder": [],
        "TerminalMethodBuilder": [],
        "TransformImpl": [
            [
                "NOTHING",
                "java.lang.Runnable"
            ]
        ],
        "UnboundAttribute": [
            [
                "mapper",
                "java.lang.classfile.AttributeMapper<T>"
            ]
        ],
        "Util": [
            [
                "ATTRIBUTE_STABILITY_COUNT",
                "int"
            ]
        ]
    },
    "jdk.internal.classfile.impl.verifier": {
        "ParserVerifier": [
            [
                "classModel",
                "java.lang.classfile.ClassModel"
            ]
        ],
        "VerificationBytecodes": [],
        "VerificationFrame": [
            [
                "FLAG_THIS_UNINIT",
                "int"
            ],
            [
                "_offset",
                "int"
            ],
            [
                "_locals_size",
                "int"
            ],
            [
                "_stack_size",
                "int"
            ],
            [
                "_stack_mark",
                "int"
            ],
            [
                "_max_locals",
                "int"
            ],
            [
                "_max_stack",
                "int"
            ],
            [
                "_flags",
                "int"
            ],
            [
                "_locals",
                "jdk.internal.classfile.impl.verifier.VerificationType[]"
            ],
            [
                "_stack",
                "jdk.internal.classfile.impl.verifier.VerificationType[]"
            ],
            [
                "_verifier",
                "jdk.internal.classfile.impl.verifier.VerifierImpl"
            ]
        ],
        "VerificationSignature": [
            [
                "TYPE2CHAR_TAB",
                "char[]"
            ],
            [
                "type",
                "jdk.internal.classfile.impl.verifier.VerificationSignature$BasicType"
            ],
            [
                "signature",
                "java.lang.String"
            ],
            [
                "limit",
                "int"
            ],
            [
                "begin",
                "int"
            ],
            [
                "end",
                "int"
            ],
            [
                "arrayPrefix",
                "int"
            ],
            [
                "state",
                "int"
            ],
            [
                "S_FIELD",
                "int"
            ],
            [
                "S_METHOD",
                "int"
            ],
            [
                "S_METHOD_RETURN",
                "int"
            ],
            [
                "context",
                "jdk.internal.classfile.impl.verifier.VerifierImpl"
            ]
        ],
        "VerificationTable": [
            [
                "_code_length",
                "int"
            ],
            [
                "_frame_count",
                "int"
            ],
            [
                "_frame_array",
                "jdk.internal.classfile.impl.verifier.VerificationFrame[]"
            ],
            [
                "_verifier",
                "jdk.internal.classfile.impl.verifier.VerifierImpl"
            ]
        ],
        "VerificationType": [
            [
                "BitsPerByte",
                "int"
            ],
            [
                "_data",
                "int"
            ],
            [
                "_sym",
                "java.lang.String"
            ],
            [
                "_constantsMap",
                "java.lang.String>"
            ],
            [
                "ITEM_Boolean",
                "int"
            ],
            [
                "ITEM_Byte",
                "int"
            ],
            [
                "ITEM_Short",
                "int"
            ],
            [
                "ITEM_Char",
                "int"
            ],
            [
                "ITEM_Long_2nd",
                "int"
            ],
            [
                "ITEM_Double_2nd",
                "int"
            ],
            [
                "TypeMask",
                "int"
            ],
            [
                "Reference",
                "int"
            ],
            [
                "Primitive",
                "int"
            ],
            [
                "Uninitialized",
                "int"
            ],
            [
                "TypeQuery",
                "int"
            ],
            [
                "ReferenceFlag",
                "int"
            ],
            [
                "Category1Flag",
                "int"
            ],
            [
                "Category2Flag",
                "int"
            ],
            [
                "Category2_2ndFlag",
                "int"
            ],
            [
                "Null",
                "int"
            ],
            [
                "Category1",
                "int"
            ],
            [
                "Category2",
                "int"
            ],
            [
                "Category2_2nd",
                "int"
            ],
            [
                "Bogus",
                "int"
            ],
            [
                "Boolean",
                "int"
            ],
            [
                "Byte",
                "int"
            ],
            [
                "Short",
                "int"
            ],
            [
                "Char",
                "int"
            ],
            [
                "Integer",
                "int"
            ],
            [
                "Float",
                "int"
            ],
            [
                "Long",
                "int"
            ],
            [
                "Double",
                "int"
            ],
            [
                "Long_2nd",
                "int"
            ],
            [
                "Double_2nd",
                "int"
            ],
            [
                "BciMask",
                "int"
            ],
            [
                "BciForThis",
                "int"
            ],
            [
                "ReferenceQuery",
                "int"
            ],
            [
                "Category1Query",
                "int"
            ],
            [
                "Category2Query",
                "int"
            ],
            [
                "Category2_2ndQuery",
                "int"
            ]
        ],
        "VerificationWrapper": [
            [
                "clm",
                "java.lang.classfile.ClassModel"
            ],
            [
                "cp",
                "jdk.internal.classfile.impl.verifier.VerificationWrapper$ConstantPoolWrapper"
            ]
        ],
        "VerifierImpl": [
            [
                "bci",
                "int"
            ],
            [
                "_logger",
                "java.util.function.Consumer<java.lang.String>"
            ],
            [
                "NONZERO_PADDING_BYTES_IN_SWITCH_MAJOR_VERSION",
                "int"
            ],
            [
                "STATIC_METHOD_IN_INTERFACE_MAJOR_VERSION",
                "int"
            ],
            [
                "MAX_ARRAY_DIMENSIONS",
                "int"
            ]
        ]
    },
    "jdk.internal.constant": {
        "ArrayClassDescImpl": [
            [
                "elementType",
                "java.lang.constant.ClassDesc"
            ],
            [
                "rank",
                "int"
            ],
            [
                "cachedDescriptorString",
                "java.lang.String"
            ]
        ],
        "ClassOrInterfaceDescImpl": [
            [
                "descriptor",
                "java.lang.String"
            ],
            [
                "internalName",
                "java.lang.String"
            ]
        ],
        "ConstantUtils": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "EMPTY_CONSTANTDESC",
                "java.lang.constant.ConstantDesc[]"
            ],
            [
                "EMPTY_CLASSDESC",
                "java.lang.constant.ClassDesc[]"
            ],
            [
                "MAX_ARRAY_TYPE_DESC_DIMENSIONS",
                "int"
            ],
            [
                "CD_module_info",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Object_array",
                "java.lang.constant.ClassDesc"
            ],
            [
                "pointyNames",
                "java.util.Set<java.lang.String>"
            ],
            [
                "JVM_SIGNATURE_ARRAY",
                "char"
            ],
            [
                "JVM_SIGNATURE_BYTE",
                "char"
            ],
            [
                "JVM_SIGNATURE_CHAR",
                "char"
            ],
            [
                "JVM_SIGNATURE_CLASS",
                "char"
            ],
            [
                "JVM_SIGNATURE_FLOAT",
                "char"
            ],
            [
                "JVM_SIGNATURE_DOUBLE",
                "char"
            ],
            [
                "JVM_SIGNATURE_INT",
                "char"
            ],
            [
                "JVM_SIGNATURE_LONG",
                "char"
            ],
            [
                "JVM_SIGNATURE_SHORT",
                "char"
            ],
            [
                "JVM_SIGNATURE_VOID",
                "char"
            ],
            [
                "JVM_SIGNATURE_BOOLEAN",
                "char"
            ]
        ],
        "DirectMethodHandleDescImpl": [
            [
                "kind",
                "java.lang.constant.DirectMethodHandleDesc$Kind"
            ],
            [
                "owner",
                "java.lang.constant.ClassDesc"
            ],
            [
                "name",
                "java.lang.String"
            ],
            [
                "invocationType",
                "java.lang.constant.MethodTypeDesc"
            ]
        ],
        "MethodTypeDescImpl": [
            [
                "returnType",
                "java.lang.constant.ClassDesc"
            ],
            [
                "argTypes",
                "java.lang.constant.ClassDesc[]"
            ],
            [
                "cachedDescriptorString",
                "java.lang.String"
            ]
        ],
        "ModuleDescImpl": [
            [
                "name",
                "java.lang.String"
            ]
        ],
        "PackageDescImpl": [
            [
                "internalName",
                "java.lang.String"
            ]
        ],
        "PrimitiveClassDescImpl": [
            [
                "CD_int",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_long",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_float",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_double",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_short",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_byte",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_char",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_boolean",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "CD_void",
                "jdk.internal.constant.PrimitiveClassDescImpl"
            ],
            [
                "descriptor",
                "java.lang.String"
            ],
            [
                "lazyWrapper",
                "sun.invoke.util.Wrapper"
            ]
        ]
    },
    "jdk.internal.event": {
        "DeserializationEvent": [
            [
                "filterConfigured",
                "boolean"
            ],
            [
                "filterStatus",
                "java.lang.String"
            ],
            [
                "type",
                "java.lang.Class<?>"
            ],
            [
                "arrayLength",
                "int"
            ],
            [
                "objectReferences",
                "long"
            ],
            [
                "depth",
                "long"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "exceptionType",
                "java.lang.Class<?>"
            ],
            [
                "exceptionMessage",
                "java.lang.String"
            ]
        ],
        "ErrorThrownEvent": [
            [
                "message",
                "java.lang.String"
            ],
            [
                "thrownClass",
                "java.lang.Class<?>"
            ]
        ],
        "Event": [],
        "EventHelper": [
            [
                "JUJA",
                "jdk.internal.access.JavaUtilJarAccess"
            ],
            [
                "loggingSecurity",
                "boolean"
            ],
            [
                "securityLogger",
                "java.lang.System$Logger"
            ],
            [
                "LOGGER_HANDLE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "LOG_LEVEL",
                "java.lang.System$Logger$Level"
            ],
            [
                "SECURITY_LOGGER_NAME",
                "java.lang.String"
            ]
        ],
        "ExceptionStatisticsEvent": [
            [
                "throwables",
                "long"
            ]
        ],
        "ExceptionThrownEvent": [
            [
                "message",
                "java.lang.String"
            ],
            [
                "thrownClass",
                "java.lang.Class<?>"
            ]
        ],
        "FileForceEvent": [
            [
                "path",
                "java.lang.String"
            ],
            [
                "metaData",
                "boolean"
            ]
        ],
        "FileReadEvent": [
            [
                "path",
                "java.lang.String"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "endOfFile",
                "boolean"
            ]
        ],
        "FileWriteEvent": [
            [
                "path",
                "java.lang.String"
            ],
            [
                "bytesWritten",
                "long"
            ]
        ],
        "JFRTracing": [],
        "ProcessStartEvent": [
            [
                "pid",
                "long"
            ],
            [
                "directory",
                "java.lang.String"
            ],
            [
                "command",
                "java.lang.String"
            ]
        ],
        "SecurityPropertyModificationEvent": [
            [
                "key",
                "java.lang.String"
            ],
            [
                "value",
                "java.lang.String"
            ]
        ],
        "SecurityProviderServiceEvent": [
            [
                "EVENT",
                "jdk.internal.event.SecurityProviderServiceEvent"
            ],
            [
                "type",
                "java.lang.String"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "provider",
                "java.lang.String"
            ]
        ],
        "SerializationMisdeclarationEvent": [
            [
                "misdeclaredClass",
                "java.lang.Class<?>"
            ],
            [
                "message",
                "java.lang.String"
            ]
        ],
        "SocketReadEvent": [
            [
                "host",
                "java.lang.String"
            ],
            [
                "address",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "timeout",
                "long"
            ],
            [
                "bytesRead",
                "long"
            ],
            [
                "endOfStream",
                "boolean"
            ]
        ],
        "SocketWriteEvent": [
            [
                "host",
                "java.lang.String"
            ],
            [
                "address",
                "java.lang.String"
            ],
            [
                "port",
                "int"
            ],
            [
                "bytesWritten",
                "long"
            ]
        ],
        "TLSHandshakeEvent": [
            [
                "peerHost",
                "java.lang.String"
            ],
            [
                "peerPort",
                "int"
            ],
            [
                "protocolVersion",
                "java.lang.String"
            ],
            [
                "cipherSuite",
                "java.lang.String"
            ],
            [
                "certificateId",
                "long"
            ]
        ],
        "ThreadSleepEvent": [
            [
                "time",
                "long"
            ]
        ],
        "ThrowableTracer": [
            [
                "numThrowables",
                "java.util.concurrent.atomic.AtomicLong"
            ]
        ],
        "VirtualThreadEndEvent": [
            [
                "EVENT",
                "jdk.internal.event.VirtualThreadEndEvent"
            ],
            [
                "javaThreadId",
                "long"
            ]
        ],
        "VirtualThreadStartEvent": [
            [
                "EVENT",
                "jdk.internal.event.VirtualThreadStartEvent"
            ],
            [
                "javaThreadId",
                "long"
            ]
        ],
        "VirtualThreadSubmitFailedEvent": [
            [
                "javaThreadId",
                "long"
            ],
            [
                "exceptionMessage",
                "java.lang.String"
            ]
        ],
        "X509CertificateEvent": [
            [
                "EVENT",
                "jdk.internal.event.X509CertificateEvent"
            ],
            [
                "algorithm",
                "java.lang.String"
            ],
            [
                "serialNumber",
                "java.lang.String"
            ],
            [
                "subject",
                "java.lang.String"
            ],
            [
                "issuer",
                "java.lang.String"
            ],
            [
                "keyType",
                "java.lang.String"
            ],
            [
                "keyLength",
                "int"
            ],
            [
                "certificateId",
                "long"
            ],
            [
                "validFrom",
                "long"
            ],
            [
                "validUntil",
                "long"
            ]
        ],
        "X509ValidationEvent": [
            [
                "certificateId",
                "long"
            ],
            [
                "certificatePosition",
                "int"
            ],
            [
                "validationCounter",
                "long"
            ]
        ]
    },
    "jdk.internal.foreign": {
        "AbstractMemorySegmentImpl": [],
        "ArenaImpl": [
            [
                "session",
                "jdk.internal.foreign.MemorySessionImpl"
            ],
            [
                "shouldReserveMemory",
                "boolean"
            ]
        ],
        "CABI": [
            [
                "SYS_V",
                "jdk.internal.foreign.CABI"
            ],
            [
                "WIN_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "LINUX_AARCH_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "MAC_OS_AARCH_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "WIN_AARCH_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "AIX_PPC_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "LINUX_PPC_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "LINUX_PPC_64_LE",
                "jdk.internal.foreign.CABI"
            ],
            [
                "LINUX_RISCV_64",
                "jdk.internal.foreign.CABI"
            ],
            [
                "LINUX_S390",
                "jdk.internal.foreign.CABI"
            ],
            [
                "FALLBACK",
                "jdk.internal.foreign.CABI"
            ],
            [
                "UNSUPPORTED",
                "jdk.internal.foreign.CABI"
            ],
            [
                "CURRENT",
                "jdk.internal.foreign.CABI"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.CABI[]"
            ]
        ],
        "ConfinedSession": [
            [
                "asyncReleaseCount",
                "int"
            ]
        ],
        "FunctionDescriptorImpl": [
            [
                "resLayout",
                "java.lang.foreign.MemoryLayout"
            ],
            [
                "argLayouts",
                "java.util.List<java.lang.foreign.MemoryLayout>"
            ]
        ],
        "GlobalSession": [],
        "HeapMemorySegmentImpl": [
            [
                "MAX_ALIGN_BYTE_ARRAY",
                "long"
            ],
            [
                "MAX_ALIGN_SHORT_ARRAY",
                "long"
            ],
            [
                "MAX_ALIGN_INT_ARRAY",
                "long"
            ],
            [
                "MAX_ALIGN_LONG_ARRAY",
                "long"
            ]
        ],
        "ImplicitSession": [],
        "LayoutPath": [
            [
                "EMPTY_STRIDES",
                "long[]"
            ],
            [
                "EMPTY_BOUNDS",
                "long[]"
            ],
            [
                "EMPTY_DEREF_HANDLES",
                "java.lang.invoke.MethodHandle[]"
            ],
            [
                "MH_ADD_SCALED_OFFSET",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_SLICE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_SLICE_LAYOUT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_CHECK_ENCL_LAYOUT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_SEGMENT_RESIZE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_ADD_EXACT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "layout",
                "java.lang.foreign.MemoryLayout"
            ],
            [
                "offset",
                "long"
            ],
            [
                "enclosing",
                "jdk.internal.foreign.LayoutPath"
            ],
            [
                "strides",
                "long[]"
            ],
            [
                "bounds",
                "long[]"
            ],
            [
                "derefAdapters",
                "java.lang.invoke.MethodHandle[]"
            ]
        ],
        "MappedMemorySegmentImpl": [
            [
                "unmapper",
                "jdk.internal.access.foreign.UnmapperProxy"
            ]
        ],
        "MemorySessionImpl": [
            [
                "GLOBAL_SESSION",
                "jdk.internal.foreign.MemorySessionImpl"
            ]
        ],
        "NativeMemorySegmentImpl": [],
        "SegmentBulkOperations": [
            [
                "SCOPED_MEMORY_ACCESS",
                "jdk.internal.misc.ScopedMemoryAccess"
            ],
            [
                "LONG_MASK",
                "long"
            ],
            [
                "NATIVE_THRESHOLD_FILL",
                "int"
            ],
            [
                "NATIVE_THRESHOLD_MISMATCH",
                "int"
            ],
            [
                "NATIVE_THRESHOLD_COPY",
                "int"
            ],
            [
                "POWERS_OF_31",
                "int[]"
            ]
        ],
        "SegmentFactories": [
            [
                "MAX_MALLOC_ALIGN",
                "long"
            ],
            [
                "UNSAFE",
                "jdk.internal.misc.Unsafe"
            ]
        ],
        "SharedSession": [
            [
                "SCOPED_MEMORY_ACCESS",
                "jdk.internal.misc.ScopedMemoryAccess"
            ],
            [
                "CLOSED_ACQUIRE_COUNT",
                "int"
            ]
        ],
        "SlicingAllocator": [
            [
                "segment",
                "java.lang.foreign.MemorySegment"
            ],
            [
                "sp",
                "long"
            ]
        ],
        "StringSupport": [
            [
                "JAVA_LANG_ACCESS",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "SCOPED_MEMORY_ACCESS",
                "jdk.internal.misc.ScopedMemoryAccess"
            ],
            [
                "LONG_MASK",
                "long"
            ],
            [
                "HIMAGIC_FOR_BYTES",
                "long"
            ],
            [
                "LOMAGIC_FOR_BYTES",
                "long"
            ],
            [
                "HIMAGIC_FOR_SHORTS",
                "long"
            ],
            [
                "LOMAGIC_FOR_SHORTS",
                "long"
            ],
            [
                "HIMAGIC_FOR_INTS",
                "long"
            ],
            [
                "LOMAGIC_FOR_INTS",
                "long"
            ]
        ],
        "SystemLookup": [
            [
                "INSTANCE",
                "jdk.internal.foreign.SystemLookup"
            ],
            [
                "FALLBACK_LOOKUP",
                "java.lang.foreign.SymbolLookup"
            ],
            [
                "SYSTEM_LOOKUP",
                "java.lang.foreign.SymbolLookup"
            ]
        ],
        "Utils": [
            [
                "BYTE_TO_BOOL",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "BOOL_TO_BYTE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "ADDRESS_TO_LONG",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "LONG_TO_ADDRESS_TARGET",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "LONG_TO_ADDRESS_NO_TARGET",
                "java.lang.invoke.MethodHandle"
            ]
        ]
    },
    "jdk.internal.foreign.abi": {
        "ABIDescriptor": [
            [
                "inputStorage",
                "jdk.internal.foreign.abi.VMStorage[][]"
            ],
            [
                "outputStorage",
                "jdk.internal.foreign.abi.VMStorage[][]"
            ]
        ],
        "AbstractLinker": [
            [
                "DOWNCALL_CACHE",
                "java.lang.invoke.MethodHandle>"
            ],
            [
                "UPCALL_CACHE",
                "jdk.internal.foreign.abi.AbstractLinker$UpcallStubFactory>"
            ],
            [
                "CANONICAL_LAYOUTS_CACHE",
                "java.util.Set<java.lang.foreign.MemoryLayout>"
            ]
        ],
        "Architecture": [],
        "Binding": [],
        "BindingInterpreter": [],
        "BindingSpecializer": [
            [
                "DUMP_CLASSES_DIR",
                "java.lang.String"
            ],
            [
                "PERFORM_VERIFICATION",
                "boolean"
            ],
            [
                "SCOPE_DEDUP_DEPTH",
                "int"
            ],
            [
                "CLASSFILE_VERSION",
                "int"
            ],
            [
                "CD_Arena",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MemorySegment",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MemorySegment_Scope",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_SharedUtils",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_AbstractMemorySegmentImpl",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_MemorySessionImpl",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_Utils",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_SegmentAllocator",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfBoolean",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfByte",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfShort",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfChar",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfInt",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfLong",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfFloat",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ValueLayout_OfDouble",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_AddressLayout",
                "java.lang.constant.ClassDesc"
            ],
            [
                "CD_ForceInline",
                "java.lang.constant.ClassDesc"
            ],
            [
                "MTD_NEW_BOUNDED_ARENA",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_NEW_EMPTY_ARENA",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_SCOPE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_SESSION_IMPL",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_CLOSE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_CHECK_NATIVE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_UNSAFE_GET_BASE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_UNSAFE_GET_OFFSET",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_COPY",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_LONG_TO_ADDRESS_NO_SCOPE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_LONG_TO_ADDRESS_SCOPE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_ALLOCATE",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_HANDLE_UNCAUGHT_EXCEPTION",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_RELEASE0",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_ACQUIRE0",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_INTEGER_TO_UNSIGNED_LONG",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_SHORT_TO_UNSIGNED_LONG",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_BYTE_TO_UNSIGNED_LONG",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "MTD_BYTE_TO_BOOLEAN",
                "java.lang.constant.MethodTypeDesc"
            ],
            [
                "CLASS_DATA_DESC",
                "java.lang.constant.ConstantDesc"
            ],
            [
                "CLASS_NAME_DOWNCALL",
                "java.lang.String"
            ],
            [
                "CLASS_NAME_UPCALL",
                "java.lang.String"
            ],
            [
                "METHOD_NAME",
                "java.lang.String"
            ],
            [
                "cb",
                "java.lang.classfile.CodeBuilder"
            ],
            [
                "callerMethodType",
                "java.lang.invoke.MethodType"
            ],
            [
                "callingSequence",
                "jdk.internal.foreign.abi.CallingSequence"
            ],
            [
                "abi",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ],
            [
                "leafType",
                "java.lang.invoke.MethodType"
            ],
            [
                "leafArgSlots",
                "int[]"
            ],
            [
                "scopeSlots",
                "int[]"
            ],
            [
                "curScopeLocalIdx",
                "int"
            ],
            [
                "returnAllocatorIdx",
                "int"
            ],
            [
                "contextIdx",
                "int"
            ],
            [
                "returnBufferIdx",
                "int"
            ],
            [
                "retValIdx",
                "int"
            ],
            [
                "typeStack",
                "java.util.Deque<java.lang.Class<?>>"
            ],
            [
                "leafArgTypes",
                "java.util.List<java.lang.Class<?>>"
            ],
            [
                "paramIndex",
                "int"
            ],
            [
                "retBufOffset",
                "long"
            ]
        ],
        "CallingSequence": [
            [
                "forUpcall",
                "boolean"
            ],
            [
                "callerMethodType",
                "java.lang.invoke.MethodType"
            ],
            [
                "calleeMethodType",
                "java.lang.invoke.MethodType"
            ],
            [
                "desc",
                "java.lang.foreign.FunctionDescriptor"
            ],
            [
                "needsReturnBuffer",
                "boolean"
            ],
            [
                "returnBufferSize",
                "long"
            ],
            [
                "allocationSize",
                "long"
            ],
            [
                "returnBindings",
                "java.util.List<jdk.internal.foreign.abi.Binding>"
            ],
            [
                "argumentBindings",
                "java.util.List<java.util.List<jdk.internal.foreign.abi.Binding>>"
            ],
            [
                "linkerOptions",
                "jdk.internal.foreign.abi.LinkerOptions"
            ]
        ],
        "CallingSequenceBuilder": [
            [
                "VERIFY_BINDINGS",
                "boolean"
            ],
            [
                "abi",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ],
            [
                "linkerOptions",
                "jdk.internal.foreign.abi.LinkerOptions"
            ],
            [
                "forUpcall",
                "boolean"
            ],
            [
                "inputBindings",
                "java.util.List<java.util.List<jdk.internal.foreign.abi.Binding>>"
            ],
            [
                "outputBindings",
                "java.util.List<jdk.internal.foreign.abi.Binding>"
            ],
            [
                "mt",
                "java.lang.invoke.MethodType"
            ],
            [
                "desc",
                "java.lang.foreign.FunctionDescriptor"
            ]
        ],
        "CapturableState": [
            [
                "GET_LAST_ERROR",
                "jdk.internal.foreign.abi.CapturableState"
            ],
            [
                "WSA_GET_LAST_ERROR",
                "jdk.internal.foreign.abi.CapturableState"
            ],
            [
                "ERRNO",
                "jdk.internal.foreign.abi.CapturableState"
            ],
            [
                "LAYOUT",
                "java.lang.foreign.StructLayout"
            ],
            [
                "stateName",
                "java.lang.String"
            ],
            [
                "layout",
                "java.lang.foreign.ValueLayout"
            ],
            [
                "mask",
                "int"
            ],
            [
                "isSupported",
                "boolean"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.CapturableState[]"
            ]
        ],
        "DowncallLinker": [
            [
                "USE_SPEC",
                "boolean"
            ],
            [
                "JLIA",
                "jdk.internal.access.JavaLangInvokeAccess"
            ],
            [
                "MH_INVOKE_INTERP_BINDINGS",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "EMPTY_OBJECT_ARRAY_HANDLE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "abi",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ],
            [
                "callingSequence",
                "jdk.internal.foreign.abi.CallingSequence"
            ]
        ],
        "LinkerOptions": [
            [
                "EMPTY",
                "jdk.internal.foreign.abi.LinkerOptions"
            ],
            [
                "optionsMap",
                "jdk.internal.foreign.abi.LinkerOptions$LinkerOptionImpl>"
            ]
        ],
        "NativeEntryPoint": [
            [
                "methodType",
                "java.lang.invoke.MethodType"
            ],
            [
                "downcallStubAddress",
                "long"
            ],
            [
                "CLEANER",
                "java.lang.ref.Cleaner"
            ],
            [
                "NEP_CACHE",
                "jdk.internal.foreign.abi.NativeEntryPoint>"
            ]
        ],
        "SharedUtils": [
            [
                "JLA",
                "jdk.internal.access.JavaLangAccess"
            ],
            [
                "JLIA",
                "jdk.internal.access.JavaLangInvokeAccess"
            ],
            [
                "MH_ALLOC_BUFFER",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_BUFFER_COPY",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_REACHABILITY_FENCE",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_CHECK_SYMBOL",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_CHECK_CAPTURE_SEGMENT",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "C_POINTER",
                "java.lang.foreign.AddressLayout"
            ],
            [
                "DUMMY_ARENA",
                "java.lang.foreign.Arena"
            ],
            [
                "THROWING_ALLOCATOR",
                "java.lang.foreign.SegmentAllocator"
            ]
        ],
        "SoftReferenceCache": [
            [
                "cache",
                "V>.Node>"
            ]
        ],
        "StubLocations": [
            [
                "TARGET_ADDRESS",
                "jdk.internal.foreign.abi.StubLocations"
            ],
            [
                "RETURN_BUFFER",
                "jdk.internal.foreign.abi.StubLocations"
            ],
            [
                "CAPTURED_STATE_BUFFER",
                "jdk.internal.foreign.abi.StubLocations"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.StubLocations[]"
            ]
        ],
        "UpcallLinker": [
            [
                "DEBUG",
                "boolean"
            ],
            [
                "USE_SPEC",
                "boolean"
            ],
            [
                "MH_invokeInterpBindings",
                "java.lang.invoke.MethodHandle"
            ]
        ],
        "UpcallStubs": [],
        "VMStorage": [
            [
                "type",
                "byte"
            ],
            [
                "segmentMaskOrSize",
                "short"
            ],
            [
                "indexOrOffset",
                "int"
            ],
            [
                "debugName",
                "java.lang.String"
            ]
        ]
    },
    "jdk.internal.foreign.abi.aarch64": {
        "AArch64Architecture": [
            [
                "INSTANCE",
                "jdk.internal.foreign.abi.Architecture"
            ],
            [
                "REG64_MASK",
                "short"
            ],
            [
                "V128_MASK",
                "short"
            ],
            [
                "INTEGER_REG_SIZE",
                "int"
            ],
            [
                "VECTOR_REG_SIZE",
                "int"
            ]
        ],
        "CallArranger": [
            [
                "STACK_SLOT_SIZE",
                "int"
            ],
            [
                "MAX_COPY_SIZE",
                "int"
            ],
            [
                "MAX_REGISTER_ARGUMENTS",
                "int"
            ],
            [
                "INDIRECT_RESULT",
                "jdk.internal.foreign.abi.VMStorage"
            ],
            [
                "C",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ],
            [
                "LINUX",
                "jdk.internal.foreign.abi.aarch64.CallArranger"
            ],
            [
                "MACOS",
                "jdk.internal.foreign.abi.aarch64.CallArranger"
            ],
            [
                "WINDOWS",
                "jdk.internal.foreign.abi.aarch64.CallArranger"
            ]
        ],
        "TypeClass": [
            [
                "STRUCT_REGISTER",
                "jdk.internal.foreign.abi.aarch64.TypeClass"
            ],
            [
                "STRUCT_REFERENCE",
                "jdk.internal.foreign.abi.aarch64.TypeClass"
            ],
            [
                "STRUCT_HFA",
                "jdk.internal.foreign.abi.aarch64.TypeClass"
            ],
            [
                "POINTER",
                "jdk.internal.foreign.abi.aarch64.TypeClass"
            ],
            [
                "INTEGER",
                "jdk.internal.foreign.abi.aarch64.TypeClass"
            ],
            [
                "FLOAT",
                "jdk.internal.foreign.abi.aarch64.TypeClass"
            ],
            [
                "MAX_AGGREGATE_REGS_SIZE",
                "int"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.aarch64.TypeClass[]"
            ]
        ]
    },
    "jdk.internal.foreign.abi.aarch64.linux": {
        "LinuxAArch64CallArranger": [],
        "LinuxAArch64Linker": []
    },
    "jdk.internal.foreign.abi.aarch64.macos": {
        "MacOsAArch64CallArranger": [],
        "MacOsAArch64Linker": []
    },
    "jdk.internal.foreign.abi.aarch64.windows": {
        "WindowsAArch64CallArranger": [
            [
                "INDIRECT_RESULT",
                "jdk.internal.foreign.abi.VMStorage"
            ],
            [
                "WindowsAArch64AbiDescriptor",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ]
        ],
        "WindowsAArch64Linker": []
    },
    "jdk.internal.foreign.abi.fallback": {
        "FFIABI": [
            [
                "DEFAULT",
                "jdk.internal.foreign.abi.fallback.FFIABI"
            ],
            [
                "value",
                "int"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.fallback.FFIABI[]"
            ]
        ],
        "FFIStatus": [
            [
                "FFI_OK",
                "jdk.internal.foreign.abi.fallback.FFIStatus"
            ],
            [
                "FFI_BAD_TYPEDEF",
                "jdk.internal.foreign.abi.fallback.FFIStatus"
            ],
            [
                "FFI_BAD_ABI",
                "jdk.internal.foreign.abi.fallback.FFIStatus"
            ],
            [
                "FFI_BAD_ARGTYPE",
                "jdk.internal.foreign.abi.fallback.FFIStatus"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.fallback.FFIStatus[]"
            ]
        ],
        "FFIType": [
            [
                "UNSIGNED_SHORT",
                "java.lang.foreign.ValueLayout"
            ],
            [
                "LAYOUT",
                "java.lang.foreign.StructLayout"
            ],
            [
                "VH_TYPE",
                "java.lang.invoke.VarHandle"
            ],
            [
                "VH_ELEMENTS",
                "java.lang.invoke.VarHandle"
            ],
            [
                "VH_SIZE_T",
                "java.lang.invoke.VarHandle"
            ],
            [
                "CARRIER_TO_TYPE",
                "java.lang.foreign.MemorySegment>"
            ]
        ],
        "FallbackLinker": [
            [
                "MH_DO_DOWNCALL",
                "java.lang.invoke.MethodHandle"
            ],
            [
                "MH_DO_UPCALL",
                "java.lang.invoke.MethodHandle"
            ]
        ],
        "LibFallback": [
            [
                "UPCALL_TARGET_TYPE",
                "java.lang.invoke.MethodType"
            ]
        ]
    },
    "jdk.internal.foreign.abi.ppc64": {
        "CallArranger": [
            [
                "STACK_SLOT_SIZE",
                "int"
            ],
            [
                "MAX_COPY_SIZE",
                "int"
            ],
            [
                "MAX_REGISTER_ARGUMENTS",
                "int"
            ],
            [
                "MAX_FLOAT_REGISTER_ARGUMENTS",
                "int"
            ],
            [
                "C",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ],
            [
                "ABIv1",
                "jdk.internal.foreign.abi.ppc64.CallArranger"
            ],
            [
                "ABIv2",
                "jdk.internal.foreign.abi.ppc64.CallArranger"
            ],
            [
                "AIX",
                "jdk.internal.foreign.abi.ppc64.CallArranger"
            ]
        ],
        "PPC64Architecture": [
            [
                "INSTANCE",
                "jdk.internal.foreign.abi.Architecture"
            ],
            [
                "REG32_MASK",
                "short"
            ],
            [
                "REG64_MASK",
                "short"
            ],
            [
                "INTEGER_REG_SIZE",
                "int"
            ],
            [
                "FLOAT_REG_SIZE",
                "int"
            ],
            [
                "STACK_SLOT_SIZE",
                "int"
            ]
        ],
        "TypeClass": [
            [
                "STRUCT_REGISTER",
                "jdk.internal.foreign.abi.ppc64.TypeClass"
            ],
            [
                "STRUCT_HFA",
                "jdk.internal.foreign.abi.ppc64.TypeClass"
            ],
            [
                "POINTER",
                "jdk.internal.foreign.abi.ppc64.TypeClass"
            ],
            [
                "INTEGER",
                "jdk.internal.foreign.abi.ppc64.TypeClass"
            ],
            [
                "FLOAT",
                "jdk.internal.foreign.abi.ppc64.TypeClass"
            ],
            [
                "MAX_RETURN_AGGREGATE_REGS_SIZE",
                "int"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.ppc64.TypeClass[]"
            ]
        ]
    },
    "jdk.internal.foreign.abi.ppc64.aix": {
        "AixCallArranger": [],
        "AixPPC64Linker": []
    },
    "jdk.internal.foreign.abi.ppc64.linux": {
        "ABIv1CallArranger": [],
        "ABIv2CallArranger": [],
        "LinuxPPC64Linker": [],
        "LinuxPPC64leLinker": []
    },
    "jdk.internal.foreign.abi.riscv64": {
        "RISCV64Architecture": [
            [
                "INSTANCE",
                "jdk.internal.foreign.abi.Architecture"
            ],
            [
                "REG64_MASK",
                "short"
            ],
            [
                "FP_MASK",
                "short"
            ],
            [
                "INTEGER_REG_SIZE",
                "int"
            ],
            [
                "FLOAT_REG_SIZE",
                "int"
            ]
        ]
    },
    "jdk.internal.foreign.abi.riscv64.linux": {
        "LinuxRISCV64CallArranger": [
            [
                "STACK_SLOT_SIZE",
                "int"
            ],
            [
                "MAX_REGISTER_ARGUMENTS",
                "int"
            ],
            [
                "CLinux",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ]
        ],
        "LinuxRISCV64Linker": [],
        "TypeClass": [
            [
                "INTEGER",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "FLOAT",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "POINTER",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "STRUCT_REFERENCE",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "STRUCT_REGISTER_F",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "STRUCT_REGISTER_XF",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "STRUCT_REGISTER_X",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass"
            ],
            [
                "MAX_AGGREGATE_REGS_SIZE",
                "int"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.riscv64.linux.TypeClass[]"
            ]
        ]
    },
    "jdk.internal.foreign.abi.s390": {
        "S390Architecture": [
            [
                "INSTANCE",
                "jdk.internal.foreign.abi.Architecture"
            ],
            [
                "REG32_MASK",
                "short"
            ],
            [
                "REG64_MASK",
                "short"
            ],
            [
                "INTEGER_REG_SIZE",
                "int"
            ],
            [
                "FLOAT_REG_SIZE",
                "int"
            ],
            [
                "STACK_SLOT_SIZE",
                "int"
            ]
        ]
    },
    "jdk.internal.foreign.abi.s390.linux": {
        "LinuxS390CallArranger": [
            [
                "STACK_SLOT_SIZE",
                "int"
            ],
            [
                "MAX_REGISTER_ARGUMENTS",
                "int"
            ],
            [
                "MAX_FLOAT_REGISTER_ARGUMENTS",
                "int"
            ],
            [
                "CLinux",
                "jdk.internal.foreign.abi.ABIDescriptor"
            ]
        ],
        "LinuxS390Linker": [
            [
                "CANONICAL_LAYOUTS",
                "java.lang.foreign.MemoryLayout>"
            ]
        ],
        "TypeClass": [
            [
                "STRUCT_REGISTER",
                "jdk.internal.foreign.abi.s390.linux.TypeClass"
            ],
            [
                "STRUCT_SFA",
                "jdk.internal.foreign.abi.s390.linux.TypeClass"
            ],
            [
                "STRUCT_REFERENCE",
                "jdk.internal.foreign.abi.s390.linux.TypeClass"
            ],
            [
                "POINTER",
                "jdk.internal.foreign.abi.s390.linux.TypeClass"
            ],
            [
                "INTEGER",
                "jdk.internal.foreign.abi.s390.linux.TypeClass"
            ],
            [
                "FLOAT",
                "jdk.internal.foreign.abi.s390.linux.TypeClass"
            ],
            [
                "$VALUES",
                "jdk.internal.foreign.abi.s390.linux.TypeClass[]"
            ]
