# Auto-generated by java_generate.py
# flake8: noqa

from typing import Dict, List, TypedDict

class MethodInfo(TypedDict):
    name: str
    parameters: List[str]
    return_type: str
    signature: str

MethodsDict = Dict[str, Dict[str, List[MethodInfo]]]

JAVA_METHODS: MethodsDict = {
    "javax.jms": {
        "BytesMessage": [
            {
                "name": "getBodyLength",
                "parameters": [],
                "signature": "public abstract long getBodyLength() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBoolean",
                "parameters": [],
                "signature": "public abstract boolean readBoolean() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readByte",
                "parameters": [],
                "signature": "public abstract byte readByte() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readUnsignedByte",
                "parameters": [],
                "signature": "public abstract int readUnsignedByte() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readShort",
                "parameters": [],
                "signature": "public abstract short readShort() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readUnsignedShort",
                "parameters": [],
                "signature": "public abstract int readUnsignedShort() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readChar",
                "parameters": [],
                "signature": "public abstract char readChar() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readInt",
                "parameters": [],
                "signature": "public abstract int readInt() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readLong",
                "parameters": [],
                "signature": "public abstract long readLong() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readFloat",
                "parameters": [],
                "signature": "public abstract float readFloat() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readDouble",
                "parameters": [],
                "signature": "public abstract double readDouble() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readUTF",
                "parameters": [],
                "signature": "public abstract java.lang.String readUTF() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract int readBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [
                    "byte[]",
                    "int"
                ],
                "signature": "public abstract int readBytes(byte[], int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBoolean",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void writeBoolean(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeByte",
                "parameters": [
                    "byte"
                ],
                "signature": "public abstract void writeByte(byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeShort",
                "parameters": [
                    "short"
                ],
                "signature": "public abstract void writeShort(short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeChar",
                "parameters": [
                    "char"
                ],
                "signature": "public abstract void writeChar(char) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void writeInt(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeLong",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void writeLong(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeFloat",
                "parameters": [
                    "float"
                ],
                "signature": "public abstract void writeFloat(float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeDouble",
                "parameters": [
                    "double"
                ],
                "signature": "public abstract void writeDouble(double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeUTF",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void writeUTF(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void writeBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract void writeBytes(byte[], int, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract void writeObject(java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "reset",
                "parameters": [],
                "signature": "public abstract void reset() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MapMessage": [
            {
                "name": "getBoolean",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBoolean(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getByte",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByte(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getShort",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShort(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getChar",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract char getChar(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getInt",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getInt(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getLong",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLong(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getFloat",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloat(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDouble",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDouble(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getString(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte[] getBytes(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObject(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMapNames",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getMapNames() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBoolean",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void setBoolean(java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setByte",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void setByte(java.lang.String, byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setShort",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void setShort(java.lang.String, short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setChar",
                "parameters": [
                    "java.lang.String",
                    "char"
                ],
                "signature": "public abstract void setChar(java.lang.String, char) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setInt",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setInt(java.lang.String, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setLong",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void setLong(java.lang.String, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setFloat",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void setFloat(java.lang.String, float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDouble",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void setDouble(java.lang.String, double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]"
                ],
                "signature": "public abstract void setBytes(java.lang.String, byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract void setBytes(java.lang.String, byte[], int, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "itemExists",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean itemExists(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "JMSConsumer": [
            {
                "name": "getMessageSelector",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessageSelector();",
                "return_type": "void"
            },
            {
                "name": "getMessageListener",
                "parameters": [],
                "signature": "public abstract javax.jms.MessageListener getMessageListener() throws javax.jms.JMSRuntimeException;",
                "return_type": "void"
            },
            {
                "name": "setMessageListener",
                "parameters": [
                    "javax.jms.MessageListener"
                ],
                "signature": "public abstract void setMessageListener(javax.jms.MessageListener) throws javax.jms.JMSRuntimeException;",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receive();",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.Message receive(long);",
                "return_type": "void"
            },
            {
                "name": "receiveNoWait",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receiveNoWait();",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close();",
                "return_type": "void"
            },
            {
                "name": "receiveBody",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T receiveBody(java.lang.Class<T>);",
                "return_type": "void"
            },
            {
                "name": "receiveBody",
                "parameters": [
                    "java.lang.Class<T>",
                    "long"
                ],
                "signature": "public abstract <T> T receiveBody(java.lang.Class<T>, long);",
                "return_type": "void"
            },
            {
                "name": "receiveBodyNoWait",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T receiveBodyNoWait(java.lang.Class<T>);",
                "return_type": "void"
            }
        ],
        "TemporaryTopic": [
            {
                "name": "delete",
                "parameters": [],
                "signature": "public abstract void delete() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MessageProducer": [
            {
                "name": "setDisableMessageID",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setDisableMessageID(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageID",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDisableMessageTimestamp",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setDisableMessageTimestamp(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageTimestamp",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageTimestamp() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDeliveryMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setDeliveryMode(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDeliveryMode",
                "parameters": [],
                "signature": "public abstract int getDeliveryMode() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setPriority",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setPriority(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getPriority",
                "parameters": [],
                "signature": "public abstract int getPriority() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setTimeToLive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setTimeToLive(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getTimeToLive",
                "parameters": [],
                "signature": "public abstract long getTimeToLive() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDeliveryDelay",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setDeliveryDelay(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDeliveryDelay",
                "parameters": [],
                "signature": "public abstract long getDeliveryDelay() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDestination",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getDestination() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Message, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Message, int, int, long, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long",
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract void send(javax.jms.Destination, javax.jms.Message, int, int, long, javax.jms.CompletionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TopicSubscriber": [
            {
                "name": "getTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.Topic getTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getNoLocal",
                "parameters": [],
                "signature": "public abstract boolean getNoLocal() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueSender": [
            {
                "name": "getQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.Queue getQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Queue",
                    "javax.jms.Message"
                ],
                "signature": "public abstract void send(javax.jms.Queue, javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Queue",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void send(javax.jms.Queue, javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "CompletionListener": [
            {
                "name": "onCompletion",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void onCompletion(javax.jms.Message);",
                "return_type": "void"
            },
            {
                "name": "onException",
                "parameters": [
                    "javax.jms.Message",
                    "java.lang.Exception"
                ],
                "signature": "public abstract void onException(javax.jms.Message, java.lang.Exception);",
                "return_type": "void"
            }
        ],
        "TopicRequestor": [
            {
                "name": "javax.jms.TopicRequestor",
                "parameters": [
                    "javax.jms.TopicSession",
                    "javax.jms.Topic"
                ],
                "signature": "public javax.jms.TopicRequestor(javax.jms.TopicSession, javax.jms.Topic) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "request",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public javax.jms.Message request(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "javax.jms.Message"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TopicPublisher": [
            {
                "name": "getTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.Topic getTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void publish(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void publish(javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Topic",
                    "javax.jms.Message"
                ],
                "signature": "public abstract void publish(javax.jms.Topic, javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "publish",
                "parameters": [
                    "javax.jms.Topic",
                    "javax.jms.Message",
                    "int",
                    "int",
                    "long"
                ],
                "signature": "public abstract void publish(javax.jms.Topic, javax.jms.Message, int, int, long) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XATopicSession": [
            {
                "name": "getTopicSession",
                "parameters": [],
                "signature": "public abstract javax.jms.TopicSession getTopicSession() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MessageFormatException": [
            {
                "name": "javax.jms.MessageFormatException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageFormatException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSConnectionFactory": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract java.lang.String value();",
                "return_type": "void"
            }
        ],
        "InvalidDestinationException": [
            {
                "name": "javax.jms.InvalidDestinationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidDestinationException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "InvalidDestinationRuntimeException": [
            {
                "name": "javax.jms.InvalidDestinationRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidDestinationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidDestinationRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidDestinationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.InvalidDestinationRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "TopicConnectionFactory": [
            {
                "name": "createTopicConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.TopicConnection createTopicConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTopicConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TopicConnection createTopicConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ResourceAllocationRuntimeException": [
            {
                "name": "javax.jms.ResourceAllocationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.ResourceAllocationRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.ResourceAllocationRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.ResourceAllocationRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "TransactionInProgressRuntimeException": [
            {
                "name": "javax.jms.TransactionInProgressRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionInProgressRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionInProgressRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.TransactionInProgressRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "MessageNotWriteableException": [
            {
                "name": "javax.jms.MessageNotWriteableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotWriteableException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "MessageNotReadableException": [
            {
                "name": "javax.jms.MessageNotReadableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotReadableException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotReadableException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotReadableException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "QueueRequestor": [
            {
                "name": "javax.jms.QueueRequestor",
                "parameters": [
                    "javax.jms.QueueSession",
                    "javax.jms.Queue"
                ],
                "signature": "public javax.jms.QueueRequestor(javax.jms.QueueSession, javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "request",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public javax.jms.Message request(javax.jms.Message) throws javax.jms.JMSException;",
                "return_type": "javax.jms.Message"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TransactionInProgressException": [
            {
                "name": "javax.jms.TransactionInProgressException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionInProgressException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionInProgressException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "TransactionRolledBackRuntimeException": [
            {
                "name": "javax.jms.TransactionRolledBackRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionRolledBackRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionRolledBackRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.TransactionRolledBackRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "InvalidClientIDRuntimeException": [
            {
                "name": "javax.jms.InvalidClientIDRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidClientIDRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidClientIDRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.InvalidClientIDRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "MessageNotWriteableRuntimeException": [
            {
                "name": "javax.jms.MessageNotWriteableRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotWriteableRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageNotWriteableRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageNotWriteableRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.MessageNotWriteableRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "JMSSecurityException": [
            {
                "name": "javax.jms.JMSSecurityException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSSecurityException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "IllegalStateRuntimeException": [
            {
                "name": "javax.jms.IllegalStateRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.IllegalStateRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.IllegalStateRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.IllegalStateRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "StreamMessage": [
            {
                "name": "readBoolean",
                "parameters": [],
                "signature": "public abstract boolean readBoolean() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readByte",
                "parameters": [],
                "signature": "public abstract byte readByte() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readShort",
                "parameters": [],
                "signature": "public abstract short readShort() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readChar",
                "parameters": [],
                "signature": "public abstract char readChar() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readInt",
                "parameters": [],
                "signature": "public abstract int readInt() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readLong",
                "parameters": [],
                "signature": "public abstract long readLong() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readFloat",
                "parameters": [],
                "signature": "public abstract float readFloat() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readDouble",
                "parameters": [],
                "signature": "public abstract double readDouble() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readString",
                "parameters": [],
                "signature": "public abstract java.lang.String readString() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract int readBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [],
                "signature": "public abstract java.lang.Object readObject() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBoolean",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void writeBoolean(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeByte",
                "parameters": [
                    "byte"
                ],
                "signature": "public abstract void writeByte(byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeShort",
                "parameters": [
                    "short"
                ],
                "signature": "public abstract void writeShort(short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeChar",
                "parameters": [
                    "char"
                ],
                "signature": "public abstract void writeChar(char) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void writeInt(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeLong",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void writeLong(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeFloat",
                "parameters": [
                    "float"
                ],
                "signature": "public abstract void writeFloat(float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeDouble",
                "parameters": [
                    "double"
                ],
                "signature": "public abstract void writeDouble(double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void writeString(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void writeBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract void writeBytes(byte[], int, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract void writeObject(java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "reset",
                "parameters": [],
                "signature": "public abstract void reset() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Message": [
            {
                "name": "getJMSMessageID",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSMessageID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSMessageID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setJMSMessageID(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSTimestamp",
                "parameters": [],
                "signature": "public abstract long getJMSTimestamp() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSTimestamp",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setJMSTimestamp(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationIDAsBytes",
                "parameters": [],
                "signature": "public abstract byte[] getJMSCorrelationIDAsBytes() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationIDAsBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void setJMSCorrelationIDAsBytes(byte[]) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setJMSCorrelationID(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationID",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSCorrelationID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSReplyTo",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getJMSReplyTo() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSReplyTo",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract void setJMSReplyTo(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSDestination",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getJMSDestination() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSDestination",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract void setJMSDestination(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSDeliveryMode",
                "parameters": [],
                "signature": "public abstract int getJMSDeliveryMode() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSDeliveryMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setJMSDeliveryMode(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSRedelivered",
                "parameters": [],
                "signature": "public abstract boolean getJMSRedelivered() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSRedelivered",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setJMSRedelivered(boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSType",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSType() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSType",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setJMSType(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSExpiration",
                "parameters": [],
                "signature": "public abstract long getJMSExpiration() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSExpiration",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setJMSExpiration(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSDeliveryTime",
                "parameters": [],
                "signature": "public abstract long getJMSDeliveryTime() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSDeliveryTime",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void setJMSDeliveryTime(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSPriority",
                "parameters": [],
                "signature": "public abstract int getJMSPriority() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setJMSPriority",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setJMSPriority(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "clearProperties",
                "parameters": [],
                "signature": "public abstract void clearProperties() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "propertyExists",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean propertyExists(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getBooleanProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBooleanProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getByteProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByteProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getShortProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShortProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getIntProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getIntProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getLongProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLongProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getFloatProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloatProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getDoubleProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDoubleProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getStringProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getStringProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getObjectProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObjectProperty(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getPropertyNames",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getPropertyNames() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setBooleanProperty",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void setBooleanProperty(java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setByteProperty",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void setByteProperty(java.lang.String, byte) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setShortProperty",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void setShortProperty(java.lang.String, short) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setIntProperty",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setIntProperty(java.lang.String, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setLongProperty",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void setLongProperty(java.lang.String, long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setFloatProperty",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void setFloatProperty(java.lang.String, float) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setDoubleProperty",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void setDoubleProperty(java.lang.String, double) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setStringProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setStringProperty(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setObjectProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObjectProperty(java.lang.String, java.lang.Object) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "acknowledge",
                "parameters": [],
                "signature": "public abstract void acknowledge() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "clearBody",
                "parameters": [],
                "signature": "public abstract void clearBody() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getBody",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T getBody(java.lang.Class<T>) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "isBodyAssignableTo",
                "parameters": [
                    "java.lang.Class"
                ],
                "signature": "public abstract boolean isBodyAssignableTo(java.lang.Class) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "JMSException": [
            {
                "name": "javax.jms.JMSException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getErrorCode",
                "parameters": [],
                "signature": "public java.lang.String getErrorCode();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getLinkedException",
                "parameters": [],
                "signature": "public java.lang.Exception getLinkedException();",
                "return_type": "java.lang.Exception"
            },
            {
                "name": "setLinkedException",
                "parameters": [
                    "java.lang.Exception"
                ],
                "signature": "public void setLinkedException(java.lang.Exception);",
                "return_type": "void"
            }
        ],
        "Destination": [],
        "XAQueueConnectionFactory": [
            {
                "name": "createXAQueueConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.XAQueueConnection createXAQueueConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXAQueueConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XAQueueConnection createXAQueueConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XAConnectionFactory": [
            {
                "name": "createXAConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.XAConnection createXAConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXAConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XAConnection createXAConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXAContext",
                "parameters": [],
                "signature": "public abstract javax.jms.XAJMSContext createXAContext();",
                "return_type": "void"
            },
            {
                "name": "createXAContext",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XAJMSContext createXAContext(java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ],
        "QueueConnectionFactory": [
            {
                "name": "createQueueConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.QueueConnection createQueueConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createQueueConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueConnection createQueueConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ConnectionFactory": [
            {
                "name": "createConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.Connection createConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Connection createConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSContext createContext();",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "createContext",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(int);",
                "return_type": "void"
            }
        ],
        "XAQueueConnection": [
            {
                "name": "createXAQueueSession",
                "parameters": [],
                "signature": "public abstract javax.jms.XAQueueSession createXAQueueSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createQueueSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.QueueSession createQueueSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XAConnection": [
            {
                "name": "createXASession",
                "parameters": [],
                "signature": "public abstract javax.jms.XASession createXASession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.Session createSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Connection": [
            {
                "name": "createSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.Session createSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSession",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.Session createSession(int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSession",
                "parameters": [],
                "signature": "public abstract javax.jms.Session createSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getClientID",
                "parameters": [],
                "signature": "public abstract java.lang.String getClientID() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setClientID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setClientID(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract javax.jms.ConnectionMetaData getMetaData() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getExceptionListener",
                "parameters": [],
                "signature": "public abstract javax.jms.ExceptionListener getExceptionListener() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setExceptionListener",
                "parameters": [
                    "javax.jms.ExceptionListener"
                ],
                "signature": "public abstract void setExceptionListener(javax.jms.ExceptionListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "start",
                "parameters": [],
                "signature": "public abstract void start() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "stop",
                "parameters": [],
                "signature": "public abstract void stop() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createConnectionConsumer(javax.jms.Destination, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createSharedConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createDurableConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createSharedDurableConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueConnection": [
            {
                "name": "createQueueSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.QueueSession createQueueSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionConsumer",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createConnectionConsumer(javax.jms.Queue, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XAJMSContext": [
            {
                "name": "getContext",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSContext getContext();",
                "return_type": "void"
            },
            {
                "name": "getXAResource",
                "parameters": [],
                "signature": "public abstract javax.transaction.xa.XAResource getXAResource();",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted();",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit();",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback();",
                "return_type": "void"
            }
        ],
        "JMSContext": [
            {
                "name": "createContext",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSContext createContext(int);",
                "return_type": "void"
            },
            {
                "name": "createProducer",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSProducer createProducer();",
                "return_type": "void"
            },
            {
                "name": "getClientID",
                "parameters": [],
                "signature": "public abstract java.lang.String getClientID();",
                "return_type": "void"
            },
            {
                "name": "setClientID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setClientID(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract javax.jms.ConnectionMetaData getMetaData();",
                "return_type": "void"
            },
            {
                "name": "getExceptionListener",
                "parameters": [],
                "signature": "public abstract javax.jms.ExceptionListener getExceptionListener();",
                "return_type": "void"
            },
            {
                "name": "setExceptionListener",
                "parameters": [
                    "javax.jms.ExceptionListener"
                ],
                "signature": "public abstract void setExceptionListener(javax.jms.ExceptionListener);",
                "return_type": "void"
            },
            {
                "name": "start",
                "parameters": [],
                "signature": "public abstract void start();",
                "return_type": "void"
            },
            {
                "name": "stop",
                "parameters": [],
                "signature": "public abstract void stop();",
                "return_type": "void"
            },
            {
                "name": "setAutoStart",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setAutoStart(boolean);",
                "return_type": "void"
            },
            {
                "name": "getAutoStart",
                "parameters": [],
                "signature": "public abstract boolean getAutoStart();",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close();",
                "return_type": "void"
            },
            {
                "name": "createBytesMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.BytesMessage createBytesMessage();",
                "return_type": "void"
            },
            {
                "name": "createMapMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.MapMessage createMapMessage();",
                "return_type": "void"
            },
            {
                "name": "createMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.Message createMessage();",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage();",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [
                    "java.io.Serializable"
                ],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage(java.io.Serializable);",
                "return_type": "void"
            },
            {
                "name": "createStreamMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.StreamMessage createStreamMessage();",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.TextMessage createTextMessage();",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TextMessage createTextMessage(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted();",
                "return_type": "void"
            },
            {
                "name": "getSessionMode",
                "parameters": [],
                "signature": "public abstract int getSessionMode();",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit();",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback();",
                "return_type": "void"
            },
            {
                "name": "recover",
                "parameters": [],
                "signature": "public abstract void recover();",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createConsumer(javax.jms.Destination);",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createConsumer(javax.jms.Destination, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createConsumer(javax.jms.Destination, java.lang.String, boolean);",
                "return_type": "void"
            },
            {
                "name": "createQueue",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Queue createQueue(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createTopic",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Topic createTopic(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createDurableConsumer(javax.jms.Topic, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String, boolean);",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedConsumer(javax.jms.Topic, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSConsumer createSharedConsumer(javax.jms.Topic, java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue);",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "createTemporaryQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryQueue createTemporaryQueue();",
                "return_type": "void"
            },
            {
                "name": "createTemporaryTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryTopic createTemporaryTopic();",
                "return_type": "void"
            },
            {
                "name": "unsubscribe",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void unsubscribe(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "acknowledge",
                "parameters": [],
                "signature": "public abstract void acknowledge();",
                "return_type": "void"
            }
        ],
        "XAQueueSession": [
            {
                "name": "getQueueSession",
                "parameters": [],
                "signature": "public abstract javax.jms.QueueSession getQueueSession() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XASession": [
            {
                "name": "getSession",
                "parameters": [],
                "signature": "public abstract javax.jms.Session getSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getXAResource",
                "parameters": [],
                "signature": "public abstract javax.transaction.xa.XAResource getXAResource();",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Session": [
            {
                "name": "createBytesMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.BytesMessage createBytesMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createMapMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.MapMessage createMapMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.Message createMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createObjectMessage",
                "parameters": [
                    "java.io.Serializable"
                ],
                "signature": "public abstract javax.jms.ObjectMessage createObjectMessage(java.io.Serializable) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createStreamMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.StreamMessage createStreamMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [],
                "signature": "public abstract javax.jms.TextMessage createTextMessage() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTextMessage",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TextMessage createTextMessage(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getTransacted",
                "parameters": [],
                "signature": "public abstract boolean getTransacted() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getAcknowledgeMode",
                "parameters": [],
                "signature": "public abstract int getAcknowledgeMode() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "recover",
                "parameters": [],
                "signature": "public abstract void recover() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMessageListener",
                "parameters": [],
                "signature": "public abstract javax.jms.MessageListener getMessageListener() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setMessageListener",
                "parameters": [
                    "javax.jms.MessageListener"
                ],
                "signature": "public abstract void setMessageListener(javax.jms.MessageListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "run",
                "parameters": [],
                "signature": "public abstract void run();",
                "return_type": "void"
            },
            {
                "name": "createProducer",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.MessageProducer createProducer(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createConsumer(javax.jms.Destination) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createConsumer(javax.jms.Destination, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConsumer",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createConsumer(javax.jms.Destination, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedConsumer(javax.jms.Topic, java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createQueue",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Queue createQueue(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTopic",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Topic createTopic(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSharedDurableConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.MessageConsumer createSharedDurableConsumer(javax.jms.Topic, java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryQueue createTemporaryQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryTopic createTemporaryTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "unsubscribe",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void unsubscribe(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueSession": [
            {
                "name": "createQueue",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Queue createQueue(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createReceiver",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueReceiver createReceiver(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createReceiver",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueReceiver createReceiver(javax.jms.Queue, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSender",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueSender createSender(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createBrowser",
                "parameters": [
                    "javax.jms.Queue",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.QueueBrowser createBrowser(javax.jms.Queue, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryQueue createTemporaryQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ConnectionMetaData": [
            {
                "name": "getJMSVersion",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSMajorVersion",
                "parameters": [],
                "signature": "public abstract int getJMSMajorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSMinorVersion",
                "parameters": [],
                "signature": "public abstract int getJMSMinorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSProviderName",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSProviderName() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getProviderVersion",
                "parameters": [],
                "signature": "public abstract java.lang.String getProviderVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getProviderMajorVersion",
                "parameters": [],
                "signature": "public abstract int getProviderMajorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getProviderMinorVersion",
                "parameters": [],
                "signature": "public abstract int getProviderMinorVersion() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getJMSXPropertyNames",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getJMSXPropertyNames() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ExceptionListener": [
            {
                "name": "onException",
                "parameters": [
                    "javax.jms.JMSException"
                ],
                "signature": "public abstract void onException(javax.jms.JMSException);",
                "return_type": "void"
            }
        ],
        "ServerSessionPool": [
            {
                "name": "getServerSession",
                "parameters": [],
                "signature": "public abstract javax.jms.ServerSession getServerSession() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ConnectionConsumer": [
            {
                "name": "getServerSessionPool",
                "parameters": [],
                "signature": "public abstract javax.jms.ServerSessionPool getServerSessionPool() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "Topic": [
            {
                "name": "getTopicName",
                "parameters": [],
                "signature": "public abstract java.lang.String getTopicName() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            }
        ],
        "Queue": [
            {
                "name": "getQueueName",
                "parameters": [],
                "signature": "public abstract java.lang.String getQueueName() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            }
        ],
        "JMSProducer": [
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "javax.jms.Message"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, javax.jms.Message);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "java.util.Map<java.lang.String",
                    "java.lang.Object>"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, java.util.Map<java.lang.String, java.lang.Object>);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "byte[]"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, byte[]);",
                "return_type": "void"
            },
            {
                "name": "send",
                "parameters": [
                    "javax.jms.Destination",
                    "java.io.Serializable"
                ],
                "signature": "public abstract javax.jms.JMSProducer send(javax.jms.Destination, java.io.Serializable);",
                "return_type": "void"
            },
            {
                "name": "setDisableMessageID",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDisableMessageID(boolean);",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageID",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageID();",
                "return_type": "void"
            },
            {
                "name": "setDisableMessageTimestamp",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDisableMessageTimestamp(boolean);",
                "return_type": "void"
            },
            {
                "name": "getDisableMessageTimestamp",
                "parameters": [],
                "signature": "public abstract boolean getDisableMessageTimestamp();",
                "return_type": "void"
            },
            {
                "name": "setDeliveryMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDeliveryMode(int);",
                "return_type": "void"
            },
            {
                "name": "getDeliveryMode",
                "parameters": [],
                "signature": "public abstract int getDeliveryMode();",
                "return_type": "void"
            },
            {
                "name": "setPriority",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSProducer setPriority(int);",
                "return_type": "void"
            },
            {
                "name": "getPriority",
                "parameters": [],
                "signature": "public abstract int getPriority();",
                "return_type": "void"
            },
            {
                "name": "setTimeToLive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.JMSProducer setTimeToLive(long);",
                "return_type": "void"
            },
            {
                "name": "getTimeToLive",
                "parameters": [],
                "signature": "public abstract long getTimeToLive();",
                "return_type": "void"
            },
            {
                "name": "setDeliveryDelay",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.JMSProducer setDeliveryDelay(long);",
                "return_type": "void"
            },
            {
                "name": "getDeliveryDelay",
                "parameters": [],
                "signature": "public abstract long getDeliveryDelay();",
                "return_type": "void"
            },
            {
                "name": "setAsync",
                "parameters": [
                    "javax.jms.CompletionListener"
                ],
                "signature": "public abstract javax.jms.JMSProducer setAsync(javax.jms.CompletionListener);",
                "return_type": "void"
            },
            {
                "name": "getAsync",
                "parameters": [],
                "signature": "public abstract javax.jms.CompletionListener getAsync();",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, boolean);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, byte);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, short);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, long);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, float);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, double);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "setProperty",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract javax.jms.JMSProducer setProperty(java.lang.String, java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "clearProperties",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSProducer clearProperties();",
                "return_type": "void"
            },
            {
                "name": "propertyExists",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean propertyExists(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getBooleanProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBooleanProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getByteProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByteProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getShortProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShortProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getIntProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getIntProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getLongProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLongProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getFloatProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloatProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getDoubleProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDoubleProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getStringProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getStringProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getObjectProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObjectProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getPropertyNames",
                "parameters": [],
                "signature": "public abstract java.util.Set<java.lang.String> getPropertyNames();",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationIDAsBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSCorrelationIDAsBytes(byte[]);",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationIDAsBytes",
                "parameters": [],
                "signature": "public abstract byte[] getJMSCorrelationIDAsBytes();",
                "return_type": "void"
            },
            {
                "name": "setJMSCorrelationID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSCorrelationID(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getJMSCorrelationID",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSCorrelationID();",
                "return_type": "void"
            },
            {
                "name": "setJMSType",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSType(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getJMSType",
                "parameters": [],
                "signature": "public abstract java.lang.String getJMSType();",
                "return_type": "void"
            },
            {
                "name": "setJMSReplyTo",
                "parameters": [
                    "javax.jms.Destination"
                ],
                "signature": "public abstract javax.jms.JMSProducer setJMSReplyTo(javax.jms.Destination);",
                "return_type": "void"
            },
            {
                "name": "getJMSReplyTo",
                "parameters": [],
                "signature": "public abstract javax.jms.Destination getJMSReplyTo();",
                "return_type": "void"
            }
        ],
        "ObjectMessage": [
            {
                "name": "setObject",
                "parameters": [
                    "java.io.Serializable"
                ],
                "signature": "public abstract void setObject(java.io.Serializable) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [],
                "signature": "public abstract java.io.Serializable getObject() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TextMessage": [
            {
                "name": "setText",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setText(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getText",
                "parameters": [],
                "signature": "public abstract java.lang.String getText() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueBrowser": [
            {
                "name": "getQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.Queue getQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMessageSelector",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessageSelector() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getEnumeration",
                "parameters": [],
                "signature": "public abstract java.util.Enumeration getEnumeration() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TemporaryQueue": [
            {
                "name": "delete",
                "parameters": [],
                "signature": "public abstract void delete() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "MessageListener": [
            {
                "name": "onMessage",
                "parameters": [
                    "javax.jms.Message"
                ],
                "signature": "public abstract void onMessage(javax.jms.Message);",
                "return_type": "void"
            }
        ],
        "MessageConsumer": [
            {
                "name": "getMessageSelector",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessageSelector() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "getMessageListener",
                "parameters": [],
                "signature": "public abstract javax.jms.MessageListener getMessageListener() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "setMessageListener",
                "parameters": [
                    "javax.jms.MessageListener"
                ],
                "signature": "public abstract void setMessageListener(javax.jms.MessageListener) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receive() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "receive",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract javax.jms.Message receive(long) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "receiveNoWait",
                "parameters": [],
                "signature": "public abstract javax.jms.Message receiveNoWait() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "QueueReceiver": [
            {
                "name": "getQueue",
                "parameters": [],
                "signature": "public abstract javax.jms.Queue getQueue() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "ServerSession": [
            {
                "name": "getSession",
                "parameters": [],
                "signature": "public abstract javax.jms.Session getSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "start",
                "parameters": [],
                "signature": "public abstract void start() throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "JMSRuntimeException": [
            {
                "name": "javax.jms.JMSRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.JMSRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getErrorCode",
                "parameters": [],
                "signature": "public java.lang.String getErrorCode();",
                "return_type": "java.lang.String"
            }
        ],
        "JMSSecurityRuntimeException": [
            {
                "name": "javax.jms.JMSSecurityRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSSecurityRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.JMSSecurityRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.JMSSecurityRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.JMSSecurityRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "TopicSession": [
            {
                "name": "createTopic",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.Topic createTopic(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSubscriber",
                "parameters": [
                    "javax.jms.Topic"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createSubscriber(javax.jms.Topic) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createSubscriber(javax.jms.Topic, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableSubscriber",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract javax.jms.TopicSubscriber createDurableSubscriber(javax.jms.Topic, java.lang.String, java.lang.String, boolean) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createPublisher",
                "parameters": [
                    "javax.jms.Topic"
                ],
                "signature": "public abstract javax.jms.TopicPublisher createPublisher(javax.jms.Topic) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTemporaryTopic",
                "parameters": [],
                "signature": "public abstract javax.jms.TemporaryTopic createTemporaryTopic() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "unsubscribe",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void unsubscribe(java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "XATopicConnection": [
            {
                "name": "createXATopicSession",
                "parameters": [],
                "signature": "public abstract javax.jms.XATopicSession createXATopicSession() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createTopicSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.TopicSession createTopicSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "TopicConnection": [
            {
                "name": "createTopicSession",
                "parameters": [
                    "boolean",
                    "int"
                ],
                "signature": "public abstract javax.jms.TopicSession createTopicSession(boolean, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createConnectionConsumer(javax.jms.Topic, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createDurableConnectionConsumer",
                "parameters": [
                    "javax.jms.Topic",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.jms.ServerSessionPool",
                    "int"
                ],
                "signature": "public abstract javax.jms.ConnectionConsumer createDurableConnectionConsumer(javax.jms.Topic, java.lang.String, java.lang.String, javax.jms.ServerSessionPool, int) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "InvalidClientIDException": [
            {
                "name": "javax.jms.InvalidClientIDException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidClientIDException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidClientIDException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSDestinationDefinition": [
            {
                "name": "description",
                "parameters": [],
                "signature": "public abstract java.lang.String description();",
                "return_type": "void"
            },
            {
                "name": "name",
                "parameters": [],
                "signature": "public abstract java.lang.String name();",
                "return_type": "void"
            },
            {
                "name": "interfaceName",
                "parameters": [],
                "signature": "public abstract java.lang.String interfaceName();",
                "return_type": "void"
            },
            {
                "name": "className",
                "parameters": [],
                "signature": "public abstract java.lang.String className();",
                "return_type": "void"
            },
            {
                "name": "resourceAdapter",
                "parameters": [],
                "signature": "public abstract java.lang.String resourceAdapter();",
                "return_type": "void"
            },
            {
                "name": "destinationName",
                "parameters": [],
                "signature": "public abstract java.lang.String destinationName();",
                "return_type": "void"
            },
            {
                "name": "properties",
                "parameters": [],
                "signature": "public abstract java.lang.String[] properties();",
                "return_type": "void"
            }
        ],
        "ResourceAllocationException": [
            {
                "name": "javax.jms.ResourceAllocationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.ResourceAllocationException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.ResourceAllocationException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSConnectionFactoryDefinition": [
            {
                "name": "description",
                "parameters": [],
                "signature": "public abstract java.lang.String description();",
                "return_type": "void"
            },
            {
                "name": "name",
                "parameters": [],
                "signature": "public abstract java.lang.String name();",
                "return_type": "void"
            },
            {
                "name": "interfaceName",
                "parameters": [],
                "signature": "public abstract java.lang.String interfaceName();",
                "return_type": "void"
            },
            {
                "name": "className",
                "parameters": [],
                "signature": "public abstract java.lang.String className();",
                "return_type": "void"
            },
            {
                "name": "resourceAdapter",
                "parameters": [],
                "signature": "public abstract java.lang.String resourceAdapter();",
                "return_type": "void"
            },
            {
                "name": "user",
                "parameters": [],
                "signature": "public abstract java.lang.String user();",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [],
                "signature": "public abstract java.lang.String password();",
                "return_type": "void"
            },
            {
                "name": "clientId",
                "parameters": [],
                "signature": "public abstract java.lang.String clientId();",
                "return_type": "void"
            },
            {
                "name": "properties",
                "parameters": [],
                "signature": "public abstract java.lang.String[] properties();",
                "return_type": "void"
            },
            {
                "name": "transactional",
                "parameters": [],
                "signature": "public abstract boolean transactional();",
                "return_type": "void"
            },
            {
                "name": "maxPoolSize",
                "parameters": [],
                "signature": "public abstract int maxPoolSize();",
                "return_type": "void"
            },
            {
                "name": "minPoolSize",
                "parameters": [],
                "signature": "public abstract int minPoolSize();",
                "return_type": "void"
            }
        ],
        "JMSPasswordCredential": [
            {
                "name": "userName",
                "parameters": [],
                "signature": "public abstract java.lang.String userName();",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [],
                "signature": "public abstract java.lang.String password();",
                "return_type": "void"
            }
        ],
        "JMSDestinationDefinitions": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSDestinationDefinition[] value();",
                "return_type": "void"
            }
        ],
        "TransactionRolledBackException": [
            {
                "name": "javax.jms.TransactionRolledBackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.TransactionRolledBackException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.TransactionRolledBackException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "XATopicConnectionFactory": [
            {
                "name": "createXATopicConnection",
                "parameters": [],
                "signature": "public abstract javax.jms.XATopicConnection createXATopicConnection() throws javax.jms.JMSException;",
                "return_type": "void"
            },
            {
                "name": "createXATopicConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.jms.XATopicConnection createXATopicConnection(java.lang.String, java.lang.String) throws javax.jms.JMSException;",
                "return_type": "void"
            }
        ],
        "DeliveryMode": [],
        "MessageFormatRuntimeException": [
            {
                "name": "javax.jms.MessageFormatRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageFormatRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageFormatRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageFormatRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.MessageFormatRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "IllegalStateException": [
            {
                "name": "javax.jms.IllegalStateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.IllegalStateException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.IllegalStateException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "MessageEOFException": [
            {
                "name": "javax.jms.MessageEOFException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageEOFException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.MessageEOFException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.MessageEOFException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSSessionMode": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract int value();",
                "return_type": "void"
            }
        ],
        "InvalidSelectorException": [
            {
                "name": "javax.jms.InvalidSelectorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidSelectorException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "JMSConnectionFactoryDefinitions": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract javax.jms.JMSConnectionFactoryDefinition[] value();",
                "return_type": "void"
            }
        ],
        "InvalidSelectorRuntimeException": [
            {
                "name": "javax.jms.InvalidSelectorRuntimeException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorRuntimeException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidSelectorRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.jms.InvalidSelectorRuntimeException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.jms.InvalidSelectorRuntimeException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.jms.InvalidSelectorRuntimeException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ]
    },
    "javax.security.sasl": {
        "AuthenticationException": [
            {
                "name": "javax.security.sasl.AuthenticationException",
                "parameters": [],
                "signature": "public javax.security.sasl.AuthenticationException();",
                "return_type": "void"
            },
            {
                "name": "javax.security.sasl.AuthenticationException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.security.sasl.AuthenticationException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.security.sasl.AuthenticationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.security.sasl.AuthenticationException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "AuthorizeCallback": [
            {
                "name": "javax.security.sasl.AuthorizeCallback",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.security.sasl.AuthorizeCallback(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getAuthenticationID",
                "parameters": [],
                "signature": "public java.lang.String getAuthenticationID();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getAuthorizationID",
                "parameters": [],
                "signature": "public java.lang.String getAuthorizationID();",
                "return_type": "java.lang.String"
            },
            {
                "name": "isAuthorized",
                "parameters": [],
                "signature": "public boolean isAuthorized();",
                "return_type": "boolean"
            },
            {
                "name": "setAuthorized",
                "parameters": [
                    "boolean"
                ],
                "signature": "public void setAuthorized(boolean);",
                "return_type": "void"
            },
            {
                "name": "getAuthorizedID",
                "parameters": [],
                "signature": "public java.lang.String getAuthorizedID();",
                "return_type": "java.lang.String"
            },
            {
                "name": "setAuthorizedID",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public void setAuthorizedID(java.lang.String);",
                "return_type": "void"
            }
        ],
        "RealmCallback": [
            {
                "name": "javax.security.sasl.RealmCallback",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.security.sasl.RealmCallback(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.security.sasl.RealmCallback",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.security.sasl.RealmCallback(java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ],
        "RealmChoiceCallback": [
            {
                "name": "javax.security.sasl.RealmChoiceCallback",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String[]",
                    "int",
                    "boolean"
                ],
                "signature": "public javax.security.sasl.RealmChoiceCallback(java.lang.String, java.lang.String[], int, boolean);",
                "return_type": "void"
            }
        ],
        "Sasl": [
            {
                "name": "javax.security.sasl.Sasl",
                "parameters": [],
                "signature": "private javax.security.sasl.Sasl();",
                "return_type": "void"
            },
            {
                "name": "createSaslClient",
                "parameters": [
                    "java.lang.String[]",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "?>",
                    "javax.security.auth.callback.CallbackHandler"
                ],
                "signature": "public static javax.security.sasl.SaslClient createSaslClient(java.lang.String[], java.lang.String, java.lang.String, java.lang.String, java.util.Map<java.lang.String, ?>, javax.security.auth.callback.CallbackHandler) throws javax.security.sasl.SaslException;",
                "return_type": "javax.security.sasl.SaslClient"
            },
            {
                "name": "loadFactory",
                "parameters": [
                    "java.security.Provider$Service"
                ],
                "signature": "private static java.lang.Object loadFactory(java.security.Provider$Service) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "createSaslServer",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "?>",
                    "javax.security.auth.callback.CallbackHandler"
                ],
                "signature": "public static javax.security.sasl.SaslServer createSaslServer(java.lang.String, java.lang.String, java.lang.String, java.util.Map<java.lang.String, ?>, javax.security.auth.callback.CallbackHandler) throws javax.security.sasl.SaslException;",
                "return_type": "javax.security.sasl.SaslServer"
            },
            {
                "name": "getSaslClientFactories",
                "parameters": [],
                "signature": "public static java.util.Enumeration<javax.security.sasl.SaslClientFactory> getSaslClientFactories();",
                "return_type": "java.util.Enumeration<javax.security.sasl.SaslClientFactory>"
            },
            {
                "name": "getSaslServerFactories",
                "parameters": [],
                "signature": "public static java.util.Enumeration<javax.security.sasl.SaslServerFactory> getSaslServerFactories();",
                "return_type": "java.util.Enumeration<javax.security.sasl.SaslServerFactory>"
            },
            {
                "name": "getFactories",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private static java.util.Set<java.lang.Object> getFactories(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "isDisabled",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private static boolean isDisabled(java.lang.String);",
                "return_type": "void"
            }
        ],
        "SaslClient": [
            {
                "name": "getMechanismName",
                "parameters": [],
                "signature": "public abstract java.lang.String getMechanismName();",
                "return_type": "void"
            },
            {
                "name": "hasInitialResponse",
                "parameters": [],
                "signature": "public abstract boolean hasInitialResponse();",
                "return_type": "void"
            },
            {
                "name": "evaluateChallenge",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract byte[] evaluateChallenge(byte[]) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "isComplete",
                "parameters": [],
                "signature": "public abstract boolean isComplete();",
                "return_type": "void"
            },
            {
                "name": "unwrap",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract byte[] unwrap(byte[], int, int) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "wrap",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract byte[] wrap(byte[], int, int) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "getNegotiatedProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getNegotiatedProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "dispose",
                "parameters": [],
                "signature": "public abstract void dispose() throws javax.security.sasl.SaslException;",
                "return_type": "void"
            }
        ],
        "SaslClientFactory": [
            {
                "name": "createSaslClient",
                "parameters": [
                    "java.lang.String[]",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "?>",
                    "javax.security.auth.callback.CallbackHandler"
                ],
                "signature": "public abstract javax.security.sasl.SaslClient createSaslClient(java.lang.String[], java.lang.String, java.lang.String, java.lang.String, java.util.Map<java.lang.String, ?>, javax.security.auth.callback.CallbackHandler) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "getMechanismNames",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "public abstract java.lang.String[] getMechanismNames(java.util.Map<java.lang.String, ?>);",
                "return_type": "void"
            }
        ],
        "SaslException": [
            {
                "name": "javax.security.sasl.SaslException",
                "parameters": [],
                "signature": "public javax.security.sasl.SaslException();",
                "return_type": "void"
            },
            {
                "name": "javax.security.sasl.SaslException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.security.sasl.SaslException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.security.sasl.SaslException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.security.sasl.SaslException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getCause",
                "parameters": [],
                "signature": "public java.lang.Throwable getCause();",
                "return_type": "java.lang.Throwable"
            },
            {
                "name": "initCause",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.lang.Throwable initCause(java.lang.Throwable);",
                "return_type": "java.lang.Throwable"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            }
        ],
        "SaslServer": [
            {
                "name": "getMechanismName",
                "parameters": [],
                "signature": "public abstract java.lang.String getMechanismName();",
                "return_type": "void"
            },
            {
                "name": "evaluateResponse",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract byte[] evaluateResponse(byte[]) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "isComplete",
                "parameters": [],
                "signature": "public abstract boolean isComplete();",
                "return_type": "void"
            },
            {
                "name": "getAuthorizationID",
                "parameters": [],
                "signature": "public abstract java.lang.String getAuthorizationID();",
                "return_type": "void"
            },
            {
                "name": "unwrap",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract byte[] unwrap(byte[], int, int) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "wrap",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract byte[] wrap(byte[], int, int) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "getNegotiatedProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getNegotiatedProperty(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "dispose",
                "parameters": [],
                "signature": "public abstract void dispose() throws javax.security.sasl.SaslException;",
                "return_type": "void"
            }
        ],
        "SaslServerFactory": [
            {
                "name": "createSaslServer",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "?>",
                    "javax.security.auth.callback.CallbackHandler"
                ],
                "signature": "public abstract javax.security.sasl.SaslServer createSaslServer(java.lang.String, java.lang.String, java.lang.String, java.util.Map<java.lang.String, ?>, javax.security.auth.callback.CallbackHandler) throws javax.security.sasl.SaslException;",
                "return_type": "void"
            },
            {
                "name": "getMechanismNames",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "public abstract java.lang.String[] getMechanismNames(java.util.Map<java.lang.String, ?>);",
                "return_type": "void"
            }
        ]
    },
    "jdk.security.jarsigner": {
        "JarSigner": [
            {
                "name": "jdk.security.jarsigner.JarSigner",
                "parameters": [
                    "jdk.security.jarsigner.JarSigner$Builder"
                ],
                "signature": "private jdk.security.jarsigner.JarSigner(jdk.security.jarsigner.JarSigner$Builder);",
                "return_type": "void"
            },
            {
                "name": "sign",
                "parameters": [
                    "java.util.zip.ZipFile",
                    "java.io.OutputStream"
                ],
                "signature": "public void sign(java.util.zip.ZipFile, java.io.OutputStream);",
                "return_type": "void"
            },
            {
                "name": "getDigestAlgorithm",
                "parameters": [],
                "signature": "public java.lang.String getDigestAlgorithm();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getSignatureAlgorithm",
                "parameters": [],
                "signature": "public java.lang.String getSignatureAlgorithm();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getTsa",
                "parameters": [],
                "signature": "public java.net.URI getTsa();",
                "return_type": "java.net.URI"
            },
            {
                "name": "getSignerName",
                "parameters": [],
                "signature": "public java.lang.String getSignerName();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getProperty",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.lang.String getProperty(java.lang.String);",
                "return_type": "java.lang.String"
            },
            {
                "name": "sign0",
                "parameters": [
                    "java.util.zip.ZipFile",
                    "java.io.OutputStream"
                ],
                "signature": "private void sign0(java.util.zip.ZipFile, java.io.OutputStream) throws java.io.IOException, java.security.cert.CertificateException, java.security.NoSuchAlgorithmException, java.security.SignatureException, java.security.InvalidKeyException, java.security.spec.InvalidParameterSpecException;",
                "return_type": "void"
            },
            {
                "name": "writeEntry",
                "parameters": [
                    "java.util.zip.ZipFile",
                    "java.util.zip.ZipOutputStream",
                    "java.util.zip.ZipEntry"
                ],
                "signature": "private void writeEntry(java.util.zip.ZipFile, java.util.zip.ZipOutputStream, java.util.zip.ZipEntry) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "java.util.zip.ZipFile",
                    "java.util.zip.ZipEntry",
                    "java.util.zip.ZipOutputStream"
                ],
                "signature": "private void writeBytes(java.util.zip.ZipFile, java.util.zip.ZipEntry, java.util.zip.ZipOutputStream) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "updateDigests",
                "parameters": [
                    "java.util.zip.ZipEntry",
                    "java.util.zip.ZipFile",
                    "java.security.MessageDigest[]",
                    "java.util.jar.Manifest"
                ],
                "signature": "private void updateDigests(java.util.zip.ZipEntry, java.util.zip.ZipFile, java.security.MessageDigest[], java.util.jar.Manifest) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getDigestAttributes",
                "parameters": [
                    "java.util.zip.ZipEntry",
                    "java.util.zip.ZipFile",
                    "java.security.MessageDigest[]"
                ],
                "signature": "private java.util.jar.Attributes getDigestAttributes(java.util.zip.ZipEntry, java.util.zip.ZipFile, java.security.MessageDigest[]) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getManifestFile",
                "parameters": [
                    "java.util.zip.ZipFile"
                ],
                "signature": "private java.util.zip.ZipEntry getManifestFile(java.util.zip.ZipFile);",
                "return_type": "void"
            },
            {
                "name": "getDigests",
                "parameters": [
                    "java.util.zip.ZipEntry",
                    "java.util.zip.ZipFile",
                    "java.security.MessageDigest[]"
                ],
                "signature": "private java.lang.String[] getDigests(java.util.zip.ZipEntry, java.util.zip.ZipFile, java.security.MessageDigest[]) throws java.io.IOException;",
                "return_type": "void"
            }
        ],
        "JarSignerException": [
            {
                "name": "jdk.security.jarsigner.JarSignerException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public jdk.security.jarsigner.JarSignerException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ]
    },
    "jdk.nio.zipfs": {
        "ByteArrayChannel": [
            {
                "name": "isOpen",
                "parameters": [],
                "signature": "public boolean isOpen();",
                "return_type": "boolean"
            },
            {
                "name": "position",
                "parameters": [],
                "signature": "public long position() throws java.io.IOException;",
                "return_type": "long"
            },
            {
                "name": "position",
                "parameters": [
                    "long"
                ],
                "signature": "public java.nio.channels.SeekableByteChannel position(long) throws java.io.IOException;",
                "return_type": "java.nio.channels.SeekableByteChannel"
            },
            {
                "name": "read",
                "parameters": [
                    "java.nio.ByteBuffer"
                ],
                "signature": "public int read(java.nio.ByteBuffer) throws java.io.IOException;",
                "return_type": "int"
            },
            {
                "name": "truncate",
                "parameters": [
                    "long"
                ],
                "signature": "public java.nio.channels.SeekableByteChannel truncate(long) throws java.io.IOException;",
                "return_type": "java.nio.channels.SeekableByteChannel"
            },
            {
                "name": "write",
                "parameters": [
                    "java.nio.ByteBuffer"
                ],
                "signature": "public int write(java.nio.ByteBuffer) throws java.io.IOException;",
                "return_type": "int"
            },
            {
                "name": "size",
                "parameters": [],
                "signature": "public long size() throws java.io.IOException;",
                "return_type": "long"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "toByteArray",
                "parameters": [],
                "signature": "public byte[] toByteArray();",
                "return_type": "byte[]"
            },
            {
                "name": "ensureOpen",
                "parameters": [],
                "signature": "private void ensureOpen() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "beginRead",
                "parameters": [],
                "signature": "private final void beginRead();",
                "return_type": "void"
            },
            {
                "name": "endRead",
                "parameters": [],
                "signature": "private final void endRead();",
                "return_type": "void"
            },
            {
                "name": "ensureCapacity",
                "parameters": [
                    "int"
                ],
                "signature": "private void ensureCapacity(int);",
                "return_type": "void"
            },
            {
                "name": "grow",
                "parameters": [
                    "int"
                ],
                "signature": "private void grow(int);",
                "return_type": "void"
            },
            {
                "name": "hugeCapacity",
                "parameters": [
                    "int"
                ],
                "signature": "private static int hugeCapacity(int);",
                "return_type": "void"
            }
        ],
        "ZipCoder": [
            {
                "name": "get",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static jdk.nio.zipfs.ZipCoder get(java.lang.String);",
                "return_type": "jdk.nio.zipfs.ZipCoder"
            },
            {
                "name": "jdk.nio.zipfs.ZipCoder",
                "parameters": [
                    "java.nio.charset.Charset"
                ],
                "signature": "private jdk.nio.zipfs.ZipCoder(java.nio.charset.Charset);",
                "return_type": "void"
            },
            {
                "name": "decoder",
                "parameters": [],
                "signature": "private java.nio.charset.CharsetDecoder decoder();",
                "return_type": "void"
            },
            {
                "name": "encoder",
                "parameters": [],
                "signature": "private java.nio.charset.CharsetEncoder encoder();",
                "return_type": "void"
            }
        ],
        "ZipConstants": [
            {
                "name": "pkSigAt",
                "parameters": [
                    "byte[]",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "private static boolean pkSigAt(byte[], int, int, int);",
                "return_type": "void"
            }
        ],
        "ZipDirectoryStream": [
            {
                "name": "iterator",
                "parameters": [],
                "signature": "public synchronized java.util.Iterator<java.nio.file.Path> iterator();",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public synchronized void close() throws java.io.IOException;",
                "return_type": "void"
            }
        ],
        "ZipFileAttributeView": [
            {
                "name": "name",
                "parameters": [],
                "signature": "public java.lang.String name();",
                "return_type": "java.lang.String"
            },
            {
                "name": "readAttributes",
                "parameters": [],
                "signature": "public java.nio.file.attribute.BasicFileAttributes readAttributes() throws java.io.IOException;",
                "return_type": "java.nio.file.attribute.BasicFileAttributes"
            },
            {
                "name": "setTimes",
                "parameters": [
                    "java.nio.file.attribute.FileTime",
                    "java.nio.file.attribute.FileTime",
                    "java.nio.file.attribute.FileTime"
                ],
                "signature": "public void setTimes(java.nio.file.attribute.FileTime, java.nio.file.attribute.FileTime, java.nio.file.attribute.FileTime) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "setPermissions",
                "parameters": [
                    "java.util.Set<java.nio.file.attribute.PosixFilePermission>"
                ],
                "signature": "public void setPermissions(java.util.Set<java.nio.file.attribute.PosixFilePermission>) throws java.io.IOException;",
                "return_type": "void"
            }
        ],
        "ZipFileAttributes": [
            {
                "name": "compressedSize",
                "parameters": [],
                "signature": "public abstract long compressedSize();",
                "return_type": "void"
            },
            {
                "name": "crc",
                "parameters": [],
                "signature": "public abstract long crc();",
                "return_type": "void"
            },
            {
                "name": "method",
                "parameters": [],
                "signature": "public abstract int method();",
                "return_type": "void"
            },
            {
                "name": "extra",
                "parameters": [],
                "signature": "public abstract byte[] extra();",
                "return_type": "void"
            },
            {
                "name": "comment",
                "parameters": [],
                "signature": "public abstract byte[] comment();",
                "return_type": "void"
            },
            {
                "name": "storedPermissions",
                "parameters": [],
                "signature": "public abstract java.util.Optional<java.util.Set<java.nio.file.attribute.PosixFilePermission>> storedPermissions();",
                "return_type": "void"
            }
        ],
        "ZipFileStore": [
            {
                "name": "name",
                "parameters": [],
                "signature": "public java.lang.String name();",
                "return_type": "java.lang.String"
            },
            {
                "name": "type",
                "parameters": [],
                "signature": "public java.lang.String type();",
                "return_type": "java.lang.String"
            },
            {
                "name": "isReadOnly",
                "parameters": [],
                "signature": "public boolean isReadOnly();",
                "return_type": "boolean"
            },
            {
                "name": "supportsFileAttributeView",
                "parameters": [
                    "java.lang.Class<? extends java.nio.file.attribute.FileAttributeView>"
                ],
                "signature": "public boolean supportsFileAttributeView(java.lang.Class<? extends java.nio.file.attribute.FileAttributeView>);",
                "return_type": "boolean"
            },
            {
                "name": "supportsFileAttributeView",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public boolean supportsFileAttributeView(java.lang.String);",
                "return_type": "boolean"
            },
            {
                "name": "getFileStoreAttributeView",
                "parameters": [
                    "java.lang.Class<V>"
                ],
                "signature": "public <V extends java.nio.file.attribute.FileStoreAttributeView> V getFileStoreAttributeView(java.lang.Class<V>);",
                "return_type": "void"
            },
            {
                "name": "getTotalSpace",
                "parameters": [],
                "signature": "public long getTotalSpace() throws java.io.IOException;",
                "return_type": "long"
            },
            {
                "name": "getUsableSpace",
                "parameters": [],
                "signature": "public long getUsableSpace() throws java.io.IOException;",
                "return_type": "long"
            },
            {
                "name": "getUnallocatedSpace",
                "parameters": [],
                "signature": "public long getUnallocatedSpace() throws java.io.IOException;",
                "return_type": "long"
            },
            {
                "name": "getAttribute",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.lang.Object getAttribute(java.lang.String) throws java.io.IOException;",
                "return_type": "java.lang.Object"
            }
        ],
        "ZipFileSystem": [
            {
                "name": "getDefaultCompressionMethod",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "private int getDefaultCompressionMethod(java.util.Map<java.lang.String, ?>);",
                "return_type": "void"
            },
            {
                "name": "isTrue",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "?>",
                    "java.lang.String"
                ],
                "signature": "private static boolean isTrue(java.util.Map<java.lang.String, ?>, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "initOwner",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "private java.nio.file.attribute.UserPrincipal initOwner(java.nio.file.Path, java.util.Map<java.lang.String, ?>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "initGroup",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "private java.nio.file.attribute.GroupPrincipal initGroup(java.nio.file.Path, java.util.Map<java.lang.String, ?>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "initPermissions",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "private java.util.Set<java.nio.file.attribute.PosixFilePermission> initPermissions(java.util.Map<java.lang.String, ?>);",
                "return_type": "void"
            },
            {
                "name": "provider",
                "parameters": [],
                "signature": "public java.nio.file.spi.FileSystemProvider provider();",
                "return_type": "java.nio.file.spi.FileSystemProvider"
            },
            {
                "name": "getSeparator",
                "parameters": [],
                "signature": "public java.lang.String getSeparator();",
                "return_type": "java.lang.String"
            },
            {
                "name": "isOpen",
                "parameters": [],
                "signature": "public boolean isOpen();",
                "return_type": "boolean"
            },
            {
                "name": "isReadOnly",
                "parameters": [],
                "signature": "public boolean isReadOnly();",
                "return_type": "boolean"
            },
            {
                "name": "checkWritable",
                "parameters": [],
                "signature": "private void checkWritable();",
                "return_type": "void"
            },
            {
                "name": "getRootDirectories",
                "parameters": [],
                "signature": "public java.lang.Iterable<java.nio.file.Path> getRootDirectories();",
                "return_type": "java.lang.Iterable<java.nio.file.Path>"
            },
            {
                "name": "getPath",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String..."
                ],
                "signature": "public jdk.nio.zipfs.ZipPath getPath(java.lang.String, java.lang.String...);",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "getUserPrincipalLookupService",
                "parameters": [],
                "signature": "public java.nio.file.attribute.UserPrincipalLookupService getUserPrincipalLookupService();",
                "return_type": "java.nio.file.attribute.UserPrincipalLookupService"
            },
            {
                "name": "newWatchService",
                "parameters": [],
                "signature": "public java.nio.file.WatchService newWatchService();",
                "return_type": "java.nio.file.WatchService"
            },
            {
                "name": "getFileStores",
                "parameters": [],
                "signature": "public java.lang.Iterable<java.nio.file.FileStore> getFileStores();",
                "return_type": "java.lang.Iterable<java.nio.file.FileStore>"
            },
            {
                "name": "supportedFileAttributeViews",
                "parameters": [],
                "signature": "public java.util.Set<java.lang.String> supportedFileAttributeViews();",
                "return_type": "java.util.Set<java.lang.String>"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getPathMatcher",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.nio.file.PathMatcher getPathMatcher(java.lang.String);",
                "return_type": "java.nio.file.PathMatcher"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "checkOptions",
                "parameters": [
                    "java.util.Set<? extends java.nio.file.OpenOption>"
                ],
                "signature": "private void checkOptions(java.util.Set<? extends java.nio.file.OpenOption>);",
                "return_type": "void"
            },
            {
                "name": "getTempPathForEntry",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private java.nio.file.Path getTempPathForEntry(byte[]) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "removeTempPathForEntry",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "private void removeTempPathForEntry(java.nio.file.Path) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "checkParents",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private void checkParents(byte[]) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getParent",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private static byte[] getParent(byte[]);",
                "return_type": "void"
            },
            {
                "name": "getParentOff",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private static int getParentOff(byte[]);",
                "return_type": "void"
            },
            {
                "name": "beginWrite",
                "parameters": [],
                "signature": "private void beginWrite();",
                "return_type": "void"
            },
            {
                "name": "endWrite",
                "parameters": [],
                "signature": "private void endWrite();",
                "return_type": "void"
            },
            {
                "name": "beginRead",
                "parameters": [],
                "signature": "private void beginRead();",
                "return_type": "void"
            },
            {
                "name": "endRead",
                "parameters": [],
                "signature": "private void endRead();",
                "return_type": "void"
            },
            {
                "name": "finalize",
                "parameters": [],
                "signature": "protected void finalize() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readAt",
                "parameters": [
                    "java.nio.ByteBuffer",
                    "long"
                ],
                "signature": "private int readAt(java.nio.ByteBuffer, long) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "findEND",
                "parameters": [],
                "signature": "private jdk.nio.zipfs.ZipFileSystem$END findEND() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "makeParentDirs",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode",
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode"
                ],
                "signature": "private void makeParentDirs(jdk.nio.zipfs.ZipFileSystem$IndexNode, jdk.nio.zipfs.ZipFileSystem$IndexNode);",
                "return_type": "void"
            },
            {
                "name": "buildNodeTree",
                "parameters": [],
                "signature": "private void buildNodeTree();",
                "return_type": "void"
            },
            {
                "name": "removeFromTree",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode"
                ],
                "signature": "private void removeFromTree(jdk.nio.zipfs.ZipFileSystem$IndexNode);",
                "return_type": "void"
            },
            {
                "name": "initializeReleaseVersion",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "private void initializeReleaseVersion(java.util.Map<java.lang.String, ?>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "isMultiReleaseJar",
                "parameters": [],
                "signature": "private boolean isMultiReleaseJar() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "createVersionedLinks",
                "parameters": [
                    "int"
                ],
                "signature": "private void createVersionedLinks(int);",
                "return_type": "void"
            },
            {
                "name": "getVersionMap",
                "parameters": [
                    "int",
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode"
                ],
                "signature": "private java.util.TreeMap<java.lang.Integer, jdk.nio.zipfs.ZipFileSystem$IndexNode> getVersionMap(int, jdk.nio.zipfs.ZipFileSystem$IndexNode);",
                "return_type": "void"
            },
            {
                "name": "getVersion",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode",
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode"
                ],
                "signature": "private java.lang.Integer getVersion(jdk.nio.zipfs.ZipFileSystem$IndexNode, jdk.nio.zipfs.ZipFileSystem$IndexNode);",
                "return_type": "void"
            },
            {
                "name": "walk",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode",
                    "java.util.function.Consumer<jdk.nio.zipfs.ZipFileSystem$IndexNode>"
                ],
                "signature": "private void walk(jdk.nio.zipfs.ZipFileSystem$IndexNode, java.util.function.Consumer<jdk.nio.zipfs.ZipFileSystem$IndexNode>);",
                "return_type": "void"
            },
            {
                "name": "getRootName",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode",
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode"
                ],
                "signature": "private byte[] getRootName(jdk.nio.zipfs.ZipFileSystem$IndexNode, jdk.nio.zipfs.ZipFileSystem$IndexNode);",
                "return_type": "void"
            },
            {
                "name": "initCEN",
                "parameters": [],
                "signature": "private byte[] initCEN() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "checkExtraFields",
                "parameters": [
                    "byte[]",
                    "int",
                    "long",
                    "long",
                    "long",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "private void checkExtraFields(byte[], int, long, long, long, int, int, int) throws java.util.zip.ZipException;",
                "return_type": "void"
            },
            {
                "name": "checkZip64ExtraFieldValues",
                "parameters": [
                    "byte[]",
                    "int",
                    "int",
                    "long",
                    "long",
                    "long",
                    "int"
                ],
                "signature": "private void checkZip64ExtraFieldValues(byte[], int, int, long, long, long, int) throws java.util.zip.ZipException;",
                "return_type": "void"
            },
            {
                "name": "isZip64ExtBlockSizeValid",
                "parameters": [
                    "int",
                    "long",
                    "long",
                    "long",
                    "int"
                ],
                "signature": "private static boolean isZip64ExtBlockSizeValid(int, long, long, long, int);",
                "return_type": "void"
            },
            {
                "name": "checkUTF8",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private final void checkUTF8(byte[]) throws java.util.zip.ZipException;",
                "return_type": "void"
            },
            {
                "name": "zerror",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private static void zerror(java.lang.String) throws java.util.zip.ZipException;",
                "return_type": "void"
            },
            {
                "name": "checkEncoding",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private final void checkEncoding(byte[]) throws java.util.zip.ZipException;",
                "return_type": "void"
            },
            {
                "name": "ensureOpen",
                "parameters": [],
                "signature": "private void ensureOpen();",
                "return_type": "void"
            },
            {
                "name": "createTempFileInSameDirectoryAs",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "private java.nio.file.Path createTempFileInSameDirectoryAs(java.nio.file.Path) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "updateDelete",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$IndexNode"
                ],
                "signature": "private void updateDelete(jdk.nio.zipfs.ZipFileSystem$IndexNode);",
                "return_type": "void"
            },
            {
                "name": "update",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$Entry"
                ],
                "signature": "private void update(jdk.nio.zipfs.ZipFileSystem$Entry);",
                "return_type": "void"
            },
            {
                "name": "copyLOCEntry",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$Entry",
                    "boolean",
                    "java.io.OutputStream",
                    "long",
                    "byte[]"
                ],
                "signature": "private long copyLOCEntry(jdk.nio.zipfs.ZipFileSystem$Entry, boolean, java.io.OutputStream, long, byte[]) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeEntry",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$Entry",
                    "java.io.OutputStream"
                ],
                "signature": "private long writeEntry(jdk.nio.zipfs.ZipFileSystem$Entry, java.io.OutputStream) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeTo",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$Entry",
                    "java.io.OutputStream"
                ],
                "signature": "private void writeTo(jdk.nio.zipfs.ZipFileSystem$Entry, java.io.OutputStream) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "sync",
                "parameters": [],
                "signature": "private void sync() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getPosixAttributes",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "private java.nio.file.attribute.PosixFileAttributes getPosixAttributes(java.nio.file.Path) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getInode",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private jdk.nio.zipfs.ZipFileSystem$IndexNode getInode(byte[]);",
                "return_type": "void"
            },
            {
                "name": "getOrCreateInode",
                "parameters": [
                    "byte[]",
                    "boolean"
                ],
                "signature": "private jdk.nio.zipfs.ZipFileSystem$IndexNode getOrCreateInode(byte[], boolean);",
                "return_type": "void"
            },
            {
                "name": "getEntry",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private jdk.nio.zipfs.ZipFileSystem$Entry getEntry(byte[]) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "deleteFile",
                "parameters": [
                    "byte[]",
                    "boolean"
                ],
                "signature": "public void deleteFile(byte[], boolean) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getOutputStream",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$Entry"
                ],
                "signature": "private java.io.OutputStream getOutputStream(jdk.nio.zipfs.ZipFileSystem$Entry) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getInputStream",
                "parameters": [
                    "jdk.nio.zipfs.ZipFileSystem$Entry"
                ],
                "signature": "private java.io.InputStream getInputStream(jdk.nio.zipfs.ZipFileSystem$Entry) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getInflater",
                "parameters": [],
                "signature": "private java.util.zip.Inflater getInflater();",
                "return_type": "void"
            },
            {
                "name": "releaseInflater",
                "parameters": [
                    "java.util.zip.Inflater"
                ],
                "signature": "private void releaseInflater(java.util.zip.Inflater);",
                "return_type": "void"
            },
            {
                "name": "getDeflater",
                "parameters": [],
                "signature": "private java.util.zip.Deflater getDeflater();",
                "return_type": "void"
            },
            {
                "name": "releaseDeflater",
                "parameters": [
                    "java.util.zip.Deflater"
                ],
                "signature": "private void releaseDeflater(java.util.zip.Deflater);",
                "return_type": "void"
            },
            {
                "name": "getPath",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String[]"
                ],
                "signature": "public java.nio.file.Path getPath(java.lang.String, java.lang.String[]);",
                "return_type": "java.nio.file.Path"
            }
        ],
        "ZipFileSystemProvider": [
            {
                "name": "jdk.nio.zipfs.ZipFileSystemProvider",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipFileSystemProvider();",
                "return_type": "void"
            },
            {
                "name": "getScheme",
                "parameters": [],
                "signature": "public java.lang.String getScheme();",
                "return_type": "java.lang.String"
            },
            {
                "name": "uriToPath",
                "parameters": [
                    "java.net.URI"
                ],
                "signature": "protected java.nio.file.Path uriToPath(java.net.URI);",
                "return_type": "void"
            },
            {
                "name": "ensureFile",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "private boolean ensureFile(java.nio.file.Path);",
                "return_type": "void"
            },
            {
                "name": "newFileSystem",
                "parameters": [
                    "java.net.URI",
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "public java.nio.file.FileSystem newFileSystem(java.net.URI, java.util.Map<java.lang.String, ?>) throws java.io.IOException;",
                "return_type": "java.nio.file.FileSystem"
            },
            {
                "name": "newFileSystem",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "public java.nio.file.FileSystem newFileSystem(java.nio.file.Path, java.util.Map<java.lang.String, ?>) throws java.io.IOException;",
                "return_type": "java.nio.file.FileSystem"
            },
            {
                "name": "getZipFileSystem",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Map<java.lang.String",
                    "?>"
                ],
                "signature": "private jdk.nio.zipfs.ZipFileSystem getZipFileSystem(java.nio.file.Path, java.util.Map<java.lang.String, ?>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getPath",
                "parameters": [
                    "java.net.URI"
                ],
                "signature": "public java.nio.file.Path getPath(java.net.URI);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getFileSystem",
                "parameters": [
                    "java.net.URI"
                ],
                "signature": "public java.nio.file.FileSystem getFileSystem(java.net.URI);",
                "return_type": "java.nio.file.FileSystem"
            },
            {
                "name": "toZipPath",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "private static jdk.nio.zipfs.ZipPath toZipPath(java.nio.file.Path);",
                "return_type": "void"
            },
            {
                "name": "checkAccess",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.AccessMode..."
                ],
                "signature": "public void checkAccess(java.nio.file.Path, java.nio.file.AccessMode...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "copy",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.Path",
                    "java.nio.file.CopyOption..."
                ],
                "signature": "public void copy(java.nio.file.Path, java.nio.file.Path, java.nio.file.CopyOption...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "createDirectory",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.attribute.FileAttribute<?>..."
                ],
                "signature": "public void createDirectory(java.nio.file.Path, java.nio.file.attribute.FileAttribute<?>...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "delete",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public final void delete(java.nio.file.Path) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "exists",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public boolean exists(java.nio.file.Path, java.nio.file.LinkOption...);",
                "return_type": "boolean"
            },
            {
                "name": "getFileAttributeView",
                "parameters": [
                    "java.nio.file.Path",
                    "java.lang.Class<V>",
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public <V extends java.nio.file.attribute.FileAttributeView> V getFileAttributeView(java.nio.file.Path, java.lang.Class<V>, java.nio.file.LinkOption...);",
                "return_type": "void"
            },
            {
                "name": "getFileStore",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public java.nio.file.FileStore getFileStore(java.nio.file.Path) throws java.io.IOException;",
                "return_type": "java.nio.file.FileStore"
            },
            {
                "name": "isHidden",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public boolean isHidden(java.nio.file.Path);",
                "return_type": "boolean"
            },
            {
                "name": "isSameFile",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.Path"
                ],
                "signature": "public boolean isSameFile(java.nio.file.Path, java.nio.file.Path) throws java.io.IOException;",
                "return_type": "boolean"
            },
            {
                "name": "move",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.Path",
                    "java.nio.file.CopyOption..."
                ],
                "signature": "public void move(java.nio.file.Path, java.nio.file.Path, java.nio.file.CopyOption...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "newAsynchronousFileChannel",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Set<? extends java.nio.file.OpenOption>",
                    "java.util.concurrent.ExecutorService",
                    "java.nio.file.attribute.FileAttribute<?>..."
                ],
                "signature": "public java.nio.channels.AsynchronousFileChannel newAsynchronousFileChannel(java.nio.file.Path, java.util.Set<? extends java.nio.file.OpenOption>, java.util.concurrent.ExecutorService, java.nio.file.attribute.FileAttribute<?>...);",
                "return_type": "java.nio.channels.AsynchronousFileChannel"
            },
            {
                "name": "newByteChannel",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Set<? extends java.nio.file.OpenOption>",
                    "java.nio.file.attribute.FileAttribute<?>..."
                ],
                "signature": "public java.nio.channels.SeekableByteChannel newByteChannel(java.nio.file.Path, java.util.Set<? extends java.nio.file.OpenOption>, java.nio.file.attribute.FileAttribute<?>...) throws java.io.IOException;",
                "return_type": "java.nio.channels.SeekableByteChannel"
            },
            {
                "name": "newDirectoryStream",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.DirectoryStream$Filter<? super java.nio.file.Path>"
                ],
                "signature": "public java.nio.file.DirectoryStream<java.nio.file.Path> newDirectoryStream(java.nio.file.Path, java.nio.file.DirectoryStream$Filter<? super java.nio.file.Path>) throws java.io.IOException;",
                "return_type": "java.nio.file.DirectoryStream<java.nio.file.Path>"
            },
            {
                "name": "newFileChannel",
                "parameters": [
                    "java.nio.file.Path",
                    "java.util.Set<? extends java.nio.file.OpenOption>",
                    "java.nio.file.attribute.FileAttribute<?>..."
                ],
                "signature": "public java.nio.channels.FileChannel newFileChannel(java.nio.file.Path, java.util.Set<? extends java.nio.file.OpenOption>, java.nio.file.attribute.FileAttribute<?>...) throws java.io.IOException;",
                "return_type": "java.nio.channels.FileChannel"
            },
            {
                "name": "newInputStream",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.OpenOption..."
                ],
                "signature": "public java.io.InputStream newInputStream(java.nio.file.Path, java.nio.file.OpenOption...) throws java.io.IOException;",
                "return_type": "java.io.InputStream"
            },
            {
                "name": "newOutputStream",
                "parameters": [
                    "java.nio.file.Path",
                    "java.nio.file.OpenOption..."
                ],
                "signature": "public java.io.OutputStream newOutputStream(java.nio.file.Path, java.nio.file.OpenOption...) throws java.io.IOException;",
                "return_type": "java.io.OutputStream"
            },
            {
                "name": "readAttributes",
                "parameters": [
                    "java.nio.file.Path",
                    "java.lang.Class<A>",
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public <A extends java.nio.file.attribute.BasicFileAttributes> A readAttributes(java.nio.file.Path, java.lang.Class<A>, java.nio.file.LinkOption...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readAttributes",
                "parameters": [
                    "java.nio.file.Path",
                    "java.lang.String",
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public java.util.Map<java.lang.String, java.lang.Object> readAttributes(java.nio.file.Path, java.lang.String, java.nio.file.LinkOption...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readAttributesIfExists",
                "parameters": [
                    "java.nio.file.Path",
                    "java.lang.Class<A>",
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public <A extends java.nio.file.attribute.BasicFileAttributes> A readAttributesIfExists(java.nio.file.Path, java.lang.Class<A>, java.nio.file.LinkOption...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readSymbolicLink",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public java.nio.file.Path readSymbolicLink(java.nio.file.Path);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "setAttribute",
                "parameters": [
                    "java.nio.file.Path",
                    "java.lang.String",
                    "java.lang.Object",
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public void setAttribute(java.nio.file.Path, java.lang.String, java.lang.Object, java.nio.file.LinkOption...) throws java.io.IOException;",
                "return_type": "void"
            }
        ],
        "ZipInfo": [
            {
                "name": "jdk.nio.zipfs.ZipInfo",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipInfo();",
                "return_type": "void"
            },
            {
                "name": "main",
                "parameters": [
                    "java.lang.String[]"
                ],
                "signature": "public static void main(java.lang.String[]) throws java.lang.Throwable;",
                "return_type": "void"
            },
            {
                "name": "print",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object..."
                ],
                "signature": "private static void print(java.lang.String, java.lang.Object...);",
                "return_type": "void"
            },
            {
                "name": "printLOC",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private static void printLOC(byte[]);",
                "return_type": "void"
            },
            {
                "name": "printCEN",
                "parameters": [
                    "byte[]",
                    "int"
                ],
                "signature": "private static void printCEN(byte[], int);",
                "return_type": "void"
            },
            {
                "name": "locoff",
                "parameters": [
                    "byte[]",
                    "int"
                ],
                "signature": "private static long locoff(byte[], int);",
                "return_type": "void"
            },
            {
                "name": "printExtra",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "private static void printExtra(byte[], int, int);",
                "return_type": "void"
            }
        ],
        "ZipPath": [
            {
                "name": "getRoot",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipPath getRoot();",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "getFileName",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipPath getFileName();",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "getParent",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipPath getParent();",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "getNameCount",
                "parameters": [],
                "signature": "public int getNameCount();",
                "return_type": "int"
            },
            {
                "name": "getName",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.nio.zipfs.ZipPath getName(int);",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "subpath",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public jdk.nio.zipfs.ZipPath subpath(int, int);",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "toRealPath",
                "parameters": [
                    "java.nio.file.LinkOption..."
                ],
                "signature": "public jdk.nio.zipfs.ZipPath toRealPath(java.nio.file.LinkOption...) throws java.io.IOException;",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "toAbsolutePath",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipPath toAbsolutePath();",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "toUri",
                "parameters": [],
                "signature": "public java.net.URI toUri();",
                "return_type": "java.net.URI"
            },
            {
                "name": "getRealPath",
                "parameters": [],
                "signature": "private java.lang.String getRealPath();",
                "return_type": "void"
            },
            {
                "name": "equalsNameAt",
                "parameters": [
                    "jdk.nio.zipfs.ZipPath",
                    "int"
                ],
                "signature": "private boolean equalsNameAt(jdk.nio.zipfs.ZipPath, int);",
                "return_type": "void"
            },
            {
                "name": "relativize",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public java.nio.file.Path relativize(java.nio.file.Path);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getFileSystem",
                "parameters": [],
                "signature": "public jdk.nio.zipfs.ZipFileSystem getFileSystem();",
                "return_type": "jdk.nio.zipfs.ZipFileSystem"
            },
            {
                "name": "isAbsolute",
                "parameters": [],
                "signature": "public boolean isAbsolute();",
                "return_type": "boolean"
            },
            {
                "name": "resolve",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public jdk.nio.zipfs.ZipPath resolve(java.nio.file.Path);",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "resolve",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private jdk.nio.zipfs.ZipPath resolve(byte[]);",
                "return_type": "void"
            },
            {
                "name": "resolveSibling",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public java.nio.file.Path resolveSibling(java.nio.file.Path);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "startsWith",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public boolean startsWith(java.nio.file.Path);",
                "return_type": "boolean"
            },
            {
                "name": "endsWith",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public boolean endsWith(java.nio.file.Path);",
                "return_type": "boolean"
            },
            {
                "name": "resolve",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public jdk.nio.zipfs.ZipPath resolve(java.lang.String);",
                "return_type": "jdk.nio.zipfs.ZipPath"
            },
            {
                "name": "resolveSibling",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.nio.file.Path resolveSibling(java.lang.String);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "startsWith",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public boolean startsWith(java.lang.String);",
                "return_type": "boolean"
            },
            {
                "name": "endsWith",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public boolean endsWith(java.lang.String);",
                "return_type": "boolean"
            },
            {
                "name": "normalize",
                "parameters": [],
                "signature": "public java.nio.file.Path normalize();",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "checkPath",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "private jdk.nio.zipfs.ZipPath checkPath(java.nio.file.Path);",
                "return_type": "void"
            },
            {
                "name": "initOffsets",
                "parameters": [],
                "signature": "private void initOffsets();",
                "return_type": "void"
            },
            {
                "name": "normalize",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private byte[] normalize(byte[]);",
                "return_type": "void"
            },
            {
                "name": "normalize",
                "parameters": [
                    "byte[]",
                    "int"
                ],
                "signature": "private byte[] normalize(byte[], int);",
                "return_type": "void"
            },
            {
                "name": "normalize",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private byte[] normalize(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "normalize",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "int"
                ],
                "signature": "private byte[] normalize(java.lang.String, int, int);",
                "return_type": "void"
            },
            {
                "name": "getResolved",
                "parameters": [],
                "signature": "private byte[] getResolved();",
                "return_type": "void"
            },
            {
                "name": "resolve0",
                "parameters": [],
                "signature": "private byte[] resolve0();",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "compareTo",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public int compareTo(java.nio.file.Path);",
                "return_type": "int"
            },
            {
                "name": "register",
                "parameters": [
                    "java.nio.file.WatchService",
                    "java.nio.file.WatchEvent$Kind<?>[]",
                    "java.nio.file.WatchEvent$Modifier..."
                ],
                "signature": "public java.nio.file.WatchKey register(java.nio.file.WatchService, java.nio.file.WatchEvent$Kind<?>[], java.nio.file.WatchEvent$Modifier...);",
                "return_type": "java.nio.file.WatchKey"
            },
            {
                "name": "register",
                "parameters": [
                    "java.nio.file.WatchService",
                    "java.nio.file.WatchEvent$Kind<?>..."
                ],
                "signature": "public java.nio.file.WatchKey register(java.nio.file.WatchService, java.nio.file.WatchEvent$Kind<?>...);",
                "return_type": "java.nio.file.WatchKey"
            },
            {
                "name": "toFile",
                "parameters": [],
                "signature": "public java.io.File toFile();",
                "return_type": "java.io.File"
            },
            {
                "name": "iterator",
                "parameters": [],
                "signature": "public java.util.Iterator<java.nio.file.Path> iterator();",
                "return_type": "java.util.Iterator<java.nio.file.Path>"
            },
            {
                "name": "getFileAttributeView",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private jdk.nio.zipfs.ZipFileAttributeView getFileAttributeView(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "deleteIfExists",
                "parameters": [],
                "signature": "private void deleteIfExists() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "copyToTarget",
                "parameters": [
                    "jdk.nio.zipfs.ZipPath",
                    "java.nio.file.CopyOption..."
                ],
                "signature": "private void copyToTarget(jdk.nio.zipfs.ZipPath, java.nio.file.CopyOption...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "decode",
                "parameters": [
                    "char"
                ],
                "signature": "private static int decode(char);",
                "return_type": "void"
            },
            {
                "name": "decodeUri",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private static java.lang.String decodeUri(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "toRealPath",
                "parameters": [
                    "java.nio.file.LinkOption[]"
                ],
                "signature": "public java.nio.file.Path toRealPath(java.nio.file.LinkOption[]) throws java.io.IOException;",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "toAbsolutePath",
                "parameters": [],
                "signature": "public java.nio.file.Path toAbsolutePath();",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "resolve",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.nio.file.Path resolve(java.lang.String);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "resolve",
                "parameters": [
                    "java.nio.file.Path"
                ],
                "signature": "public java.nio.file.Path resolve(java.nio.file.Path);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "subpath",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public java.nio.file.Path subpath(int, int);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getName",
                "parameters": [
                    "int"
                ],
                "signature": "public java.nio.file.Path getName(int);",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getParent",
                "parameters": [],
                "signature": "public java.nio.file.Path getParent();",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getFileName",
                "parameters": [],
                "signature": "public java.nio.file.Path getFileName();",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getRoot",
                "parameters": [],
                "signature": "public java.nio.file.Path getRoot();",
                "return_type": "java.nio.file.Path"
            },
            {
                "name": "getFileSystem",
                "parameters": [],
                "signature": "public java.nio.file.FileSystem getFileSystem();",
                "return_type": "java.nio.file.FileSystem"
            },
            {
                "name": "compareTo",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public int compareTo(java.lang.Object);",
                "return_type": "int"
            }
        ],
        "ZipPosixFileAttributeView": [
            {
                "name": "name",
                "parameters": [],
                "signature": "public java.lang.String name();",
                "return_type": "java.lang.String"
            },
            {
                "name": "readAttributes",
                "parameters": [],
                "signature": "public java.nio.file.attribute.PosixFileAttributes readAttributes() throws java.io.IOException;",
                "return_type": "java.nio.file.attribute.PosixFileAttributes"
            },
            {
                "name": "getOwner",
                "parameters": [],
                "signature": "public java.nio.file.attribute.UserPrincipal getOwner() throws java.io.IOException;",
                "return_type": "java.nio.file.attribute.UserPrincipal"
            },
            {
                "name": "setOwner",
                "parameters": [
                    "java.nio.file.attribute.UserPrincipal"
                ],
                "signature": "public void setOwner(java.nio.file.attribute.UserPrincipal) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "setGroup",
                "parameters": [
                    "java.nio.file.attribute.GroupPrincipal"
                ],
                "signature": "public void setGroup(java.nio.file.attribute.GroupPrincipal) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readAttributes",
                "parameters": [],
                "signature": "public java.nio.file.attribute.BasicFileAttributes readAttributes() throws java.io.IOException;",
                "return_type": "java.nio.file.attribute.BasicFileAttributes"
            }
        ],
        "ZipUtils": [
            {
                "name": "writeShort",
                "parameters": [
                    "java.io.OutputStream",
                    "int"
                ],
                "signature": "public static void writeShort(java.io.OutputStream, int) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeInt",
                "parameters": [
                    "java.io.OutputStream",
                    "long"
                ],
                "signature": "public static void writeInt(java.io.OutputStream, long) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeLong",
                "parameters": [
                    "java.io.OutputStream",
                    "long"
                ],
                "signature": "public static void writeLong(java.io.OutputStream, long) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "java.io.OutputStream",
                    "byte[]"
                ],
                "signature": "public static void writeBytes(java.io.OutputStream, byte[]) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "java.io.OutputStream",
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public static void writeBytes(java.io.OutputStream, byte[], int, int) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "toDirectoryPath",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public static byte[] toDirectoryPath(byte[]);",
                "return_type": "byte[]"
            },
            {
                "name": "dosToJavaTime",
                "parameters": [
                    "long"
                ],
                "signature": "public static long dosToJavaTime(long);",
                "return_type": "long"
            },
            {
                "name": "overflowDosToJavaTime",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "private static long overflowDosToJavaTime(int, int, int, int, int, int);",
                "return_type": "void"
            },
            {
                "name": "javaToDosTime",
                "parameters": [
                    "long"
                ],
                "signature": "public static long javaToDosTime(long);",
                "return_type": "long"
            },
            {
                "name": "winToJavaTime",
                "parameters": [
                    "long"
                ],
                "signature": "public static long winToJavaTime(long);",
                "return_type": "long"
            },
            {
                "name": "javaToWinTime",
                "parameters": [
                    "long"
                ],
                "signature": "public static long javaToWinTime(long);",
                "return_type": "long"
            },
            {
                "name": "unixToJavaTime",
                "parameters": [
                    "long"
                ],
                "signature": "public static long unixToJavaTime(long);",
                "return_type": "long"
            },
            {
                "name": "javaToUnixTime",
                "parameters": [
                    "long"
                ],
                "signature": "public static long javaToUnixTime(long);",
                "return_type": "long"
            },
            {
                "name": "isRegexMeta",
                "parameters": [
                    "char"
                ],
                "signature": "private static boolean isRegexMeta(char);",
                "return_type": "void"
            },
            {
                "name": "isGlobMeta",
                "parameters": [
                    "char"
                ],
                "signature": "private static boolean isGlobMeta(char);",
                "return_type": "void"
            },
            {
                "name": "next",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "private static char next(java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "toRegexPattern",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.lang.String toRegexPattern(java.lang.String);",
                "return_type": "java.lang.String"
            }
        ]
    },
    "java.sql": {
        "Array": [
            {
                "name": "getBaseTypeName",
                "parameters": [],
                "signature": "public abstract java.lang.String getBaseTypeName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBaseType",
                "parameters": [],
                "signature": "public abstract int getBaseType() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [],
                "signature": "public abstract java.lang.Object getArray() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getArray(java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "long",
                    "int"
                ],
                "signature": "public abstract java.lang.Object getArray(long, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "long",
                    "int",
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getArray(long, int, java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSet",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getResultSet() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSet",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.sql.ResultSet getResultSet(java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSet",
                "parameters": [
                    "long",
                    "int"
                ],
                "signature": "public abstract java.sql.ResultSet getResultSet(long, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSet",
                "parameters": [
                    "long",
                    "int",
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.sql.ResultSet getResultSet(long, int, java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "free",
                "parameters": [],
                "signature": "public abstract void free() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "BatchUpdateException": [
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "int[]"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, java.lang.String, int, int[]);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, java.lang.String, int[]);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, int[]);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "int[]"
                ],
                "signature": "public java.sql.BatchUpdateException(int[]);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [],
                "signature": "public java.sql.BatchUpdateException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "int[]",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.BatchUpdateException(int[], java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "int[]",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, int[], java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int[]",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, java.lang.String, int[], java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "int[]",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, java.lang.String, int, int[], java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getUpdateCounts",
                "parameters": [],
                "signature": "public int[] getUpdateCounts();",
                "return_type": "int[]"
            },
            {
                "name": "java.sql.BatchUpdateException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "long[]",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.BatchUpdateException(java.lang.String, java.lang.String, int, long[], java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getLargeUpdateCounts",
                "parameters": [],
                "signature": "public long[] getLargeUpdateCounts();",
                "return_type": "long[]"
            },
            {
                "name": "copyUpdateCount",
                "parameters": [
                    "int[]"
                ],
                "signature": "private static long[] copyUpdateCount(int[]);",
                "return_type": "void"
            },
            {
                "name": "copyUpdateCount",
                "parameters": [
                    "long[]"
                ],
                "signature": "private static int[] copyUpdateCount(long[]);",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.io.ObjectOutputStream"
                ],
                "signature": "private void writeObject(java.io.ObjectOutputStream) throws java.io.IOException;",
                "return_type": "void"
            }
        ],
        "Blob": [
            {
                "name": "length",
                "parameters": [],
                "signature": "public abstract long length() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "long",
                    "int"
                ],
                "signature": "public abstract byte[] getBytes(long, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBinaryStream",
                "parameters": [],
                "signature": "public abstract java.io.InputStream getBinaryStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "position",
                "parameters": [
                    "byte[]",
                    "long"
                ],
                "signature": "public abstract long position(byte[], long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "position",
                "parameters": [
                    "java.sql.Blob",
                    "long"
                ],
                "signature": "public abstract long position(java.sql.Blob, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "long",
                    "byte[]"
                ],
                "signature": "public abstract int setBytes(long, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "long",
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public abstract int setBytes(long, byte[], int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract java.io.OutputStream setBinaryStream(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "truncate",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void truncate(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "free",
                "parameters": [],
                "signature": "public abstract void free() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBinaryStream",
                "parameters": [
                    "long",
                    "long"
                ],
                "signature": "public abstract java.io.InputStream getBinaryStream(long, long) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "CallableStatement": [
            {
                "name": "registerOutParameter",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void registerOutParameter(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public abstract void registerOutParameter(int, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "wasNull",
                "parameters": [],
                "signature": "public abstract boolean wasNull() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getString(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBoolean",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean getBoolean(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getByte",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract byte getByte(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getShort",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract short getShort(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getInt(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLong",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract long getLong(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFloat",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract float getFloat(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDouble",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract double getDouble(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract byte[] getBytes(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Date getDate(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Time getTime(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.Object getObject(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "int",
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getObject(int, java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRef",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Ref getRef(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBlob",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Blob getBlob(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getClob",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Clob getClob(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Array getArray(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "int",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Date getDate(int, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "int",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Time getTime(int, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "int",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(int, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "int",
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void registerOutParameter(int, int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void registerOutParameter(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "int"
                ],
                "signature": "public abstract void registerOutParameter(java.lang.String, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void registerOutParameter(java.lang.String, int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getURL",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.net.URL getURL(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setURL",
                "parameters": [
                    "java.lang.String",
                    "java.net.URL"
                ],
                "signature": "public abstract void setURL(java.lang.String, java.net.URL) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setNull(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBoolean",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void setBoolean(java.lang.String, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setByte",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void setByte(java.lang.String, byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShort",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void setShort(java.lang.String, short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setInt",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setInt(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLong",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void setLong(java.lang.String, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFloat",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void setFloat(java.lang.String, float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDouble",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void setDouble(java.lang.String, double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBigDecimal",
                "parameters": [
                    "java.lang.String",
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void setBigDecimal(java.lang.String, java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]"
                ],
                "signature": "public abstract void setBytes(java.lang.String, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Date"
                ],
                "signature": "public abstract void setDate(java.lang.String, java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Time"
                ],
                "signature": "public abstract void setTime(java.lang.String, java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void setTimestamp(java.lang.String, java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setAsciiStream(java.lang.String, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setBinaryStream(java.lang.String, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "int",
                    "int"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "int"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "int"
                ],
                "signature": "public abstract void setCharacterStream(java.lang.String, java.io.Reader, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Date",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setDate(java.lang.String, java.sql.Date, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Time",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTime(java.lang.String, java.sql.Time, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Timestamp",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTimestamp(java.lang.String, java.sql.Timestamp, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNull(java.lang.String, int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBoolean",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBoolean(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getByte",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByte(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getShort",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShort(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getInt",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getInt(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLong",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLong(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFloat",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloat(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDouble",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDouble(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte[] getBytes(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Date getDate(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Time getTime(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObject(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getObject(java.lang.String, java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRef",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Ref getRef(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBlob",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Blob getBlob(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getClob",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Clob getClob(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Array getArray(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "java.lang.String",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Date getDate(java.lang.String, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "java.lang.String",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Time getTime(java.lang.String, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(java.lang.String, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getURL",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.net.URL getURL(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRowId",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.RowId getRowId(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRowId",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.RowId getRowId(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setRowId",
                "parameters": [
                    "java.lang.String",
                    "java.sql.RowId"
                ],
                "signature": "public abstract void setRowId(java.lang.String, java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNString(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNCharacterStream(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.NClob"
                ],
                "signature": "public abstract void setNClob(java.lang.String, java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setClob(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setBlob(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNClob(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNClob",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.NClob getNClob(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNClob",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.NClob getNClob(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSQLXML",
                "parameters": [
                    "java.lang.String",
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void setSQLXML(java.lang.String, java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSQLXML",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.SQLXML getSQLXML(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSQLXML",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.SQLXML getSQLXML(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNString",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getNString(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getNString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNCharacterStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.Reader getNCharacterStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNCharacterStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.Reader getNCharacterStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.Reader getCharacterStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.Reader getCharacterStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Blob"
                ],
                "signature": "public abstract void setBlob(java.lang.String, java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Clob"
                ],
                "signature": "public abstract void setClob(java.lang.String, java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setAsciiStream(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setBinaryStream(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setCharacterStream(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setAsciiStream(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBinaryStream(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setCharacterStream(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNCharacterStream(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setClob(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBlob(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNClob(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "int",
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T getObject(int, java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T getObject(java.lang.String, java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "java.sql.SQLType",
                    "int"
                ],
                "signature": "public default void setObject(java.lang.String, java.lang.Object, java.sql.SQLType, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "java.sql.SQLType"
                ],
                "signature": "public default void setObject(java.lang.String, java.lang.Object, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "int",
                    "java.sql.SQLType"
                ],
                "signature": "public default void registerOutParameter(int, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "int",
                    "java.sql.SQLType",
                    "int"
                ],
                "signature": "public default void registerOutParameter(int, java.sql.SQLType, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "int",
                    "java.sql.SQLType",
                    "java.lang.String"
                ],
                "signature": "public default void registerOutParameter(int, java.sql.SQLType, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "java.lang.String",
                    "java.sql.SQLType"
                ],
                "signature": "public default void registerOutParameter(java.lang.String, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "java.lang.String",
                    "java.sql.SQLType",
                    "int"
                ],
                "signature": "public default void registerOutParameter(java.lang.String, java.sql.SQLType, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerOutParameter",
                "parameters": [
                    "java.lang.String",
                    "java.sql.SQLType",
                    "java.lang.String"
                ],
                "signature": "public default void registerOutParameter(java.lang.String, java.sql.SQLType, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "ClientInfoStatus": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static java.sql.ClientInfoStatus[] values();",
                "return_type": "java.sql.ClientInfoStatus[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.ClientInfoStatus valueOf(java.lang.String);",
                "return_type": "java.sql.ClientInfoStatus"
            },
            {
                "name": "java.sql.ClientInfoStatus",
                "parameters": [],
                "signature": "private java.sql.ClientInfoStatus();",
                "return_type": "void"
            }
        ],
        "Clob": [
            {
                "name": "length",
                "parameters": [],
                "signature": "public abstract long length() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSubString",
                "parameters": [
                    "long",
                    "int"
                ],
                "signature": "public abstract java.lang.String getSubString(long, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [],
                "signature": "public abstract java.io.Reader getCharacterStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAsciiStream",
                "parameters": [],
                "signature": "public abstract java.io.InputStream getAsciiStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "position",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract long position(java.lang.String, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "position",
                "parameters": [
                    "java.sql.Clob",
                    "long"
                ],
                "signature": "public abstract long position(java.sql.Clob, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "long",
                    "java.lang.String"
                ],
                "signature": "public abstract int setString(long, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "long",
                    "java.lang.String",
                    "int",
                    "int"
                ],
                "signature": "public abstract int setString(long, java.lang.String, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract java.io.OutputStream setAsciiStream(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract java.io.Writer setCharacterStream(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "truncate",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void truncate(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "free",
                "parameters": [],
                "signature": "public abstract void free() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [
                    "long",
                    "long"
                ],
                "signature": "public abstract java.io.Reader getCharacterStream(long, long) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "Connection": [
            {
                "name": "createStatement",
                "parameters": [],
                "signature": "public abstract java.sql.Statement createStatement() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareStatement",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.PreparedStatement prepareStatement(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareCall",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.CallableStatement prepareCall(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "nativeSQL",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String nativeSQL(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAutoCommit",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setAutoCommit(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAutoCommit",
                "parameters": [],
                "signature": "public abstract boolean getAutoCommit() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "commit",
                "parameters": [],
                "signature": "public abstract void commit() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [],
                "signature": "public abstract void rollback() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isClosed",
                "parameters": [],
                "signature": "public abstract boolean isClosed() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract java.sql.DatabaseMetaData getMetaData() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setReadOnly",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setReadOnly(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isReadOnly",
                "parameters": [],
                "signature": "public abstract boolean isReadOnly() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCatalog",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setCatalog(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCatalog",
                "parameters": [],
                "signature": "public abstract java.lang.String getCatalog() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTransactionIsolation",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setTransactionIsolation(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTransactionIsolation",
                "parameters": [],
                "signature": "public abstract int getTransactionIsolation() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getWarnings",
                "parameters": [],
                "signature": "public abstract java.sql.SQLWarning getWarnings() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "clearWarnings",
                "parameters": [],
                "signature": "public abstract void clearWarnings() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createStatement",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract java.sql.Statement createStatement(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareStatement",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "int"
                ],
                "signature": "public abstract java.sql.PreparedStatement prepareStatement(java.lang.String, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareCall",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "int"
                ],
                "signature": "public abstract java.sql.CallableStatement prepareCall(java.lang.String, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTypeMap",
                "parameters": [],
                "signature": "public abstract java.util.Map<java.lang.String, java.lang.Class<?>> getTypeMap() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTypeMap",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract void setTypeMap(java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setHoldability",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setHoldability(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getHoldability",
                "parameters": [],
                "signature": "public abstract int getHoldability() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSavepoint",
                "parameters": [],
                "signature": "public abstract java.sql.Savepoint setSavepoint() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSavepoint",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Savepoint setSavepoint(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "rollback",
                "parameters": [
                    "java.sql.Savepoint"
                ],
                "signature": "public abstract void rollback(java.sql.Savepoint) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "releaseSavepoint",
                "parameters": [
                    "java.sql.Savepoint"
                ],
                "signature": "public abstract void releaseSavepoint(java.sql.Savepoint) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createStatement",
                "parameters": [
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public abstract java.sql.Statement createStatement(int, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareStatement",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public abstract java.sql.PreparedStatement prepareStatement(java.lang.String, int, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareCall",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public abstract java.sql.CallableStatement prepareCall(java.lang.String, int, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareStatement",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract java.sql.PreparedStatement prepareStatement(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareStatement",
                "parameters": [
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public abstract java.sql.PreparedStatement prepareStatement(java.lang.String, int[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "prepareStatement",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String[]"
                ],
                "signature": "public abstract java.sql.PreparedStatement prepareStatement(java.lang.String, java.lang.String[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createClob",
                "parameters": [],
                "signature": "public abstract java.sql.Clob createClob() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createBlob",
                "parameters": [],
                "signature": "public abstract java.sql.Blob createBlob() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createNClob",
                "parameters": [],
                "signature": "public abstract java.sql.NClob createNClob() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createSQLXML",
                "parameters": [],
                "signature": "public abstract java.sql.SQLXML createSQLXML() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isValid",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isValid(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClientInfo",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setClientInfo(java.lang.String, java.lang.String) throws java.sql.SQLClientInfoException;",
                "return_type": "void"
            },
            {
                "name": "setClientInfo",
                "parameters": [
                    "java.util.Properties"
                ],
                "signature": "public abstract void setClientInfo(java.util.Properties) throws java.sql.SQLClientInfoException;",
                "return_type": "void"
            },
            {
                "name": "getClientInfo",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getClientInfo(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getClientInfo",
                "parameters": [],
                "signature": "public abstract java.util.Properties getClientInfo() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createArrayOf",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object[]"
                ],
                "signature": "public abstract java.sql.Array createArrayOf(java.lang.String, java.lang.Object[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createStruct",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object[]"
                ],
                "signature": "public abstract java.sql.Struct createStruct(java.lang.String, java.lang.Object[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSchema",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setSchema(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSchema",
                "parameters": [],
                "signature": "public abstract java.lang.String getSchema() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "abort",
                "parameters": [
                    "java.util.concurrent.Executor"
                ],
                "signature": "public abstract void abort(java.util.concurrent.Executor) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNetworkTimeout",
                "parameters": [
                    "java.util.concurrent.Executor",
                    "int"
                ],
                "signature": "public abstract void setNetworkTimeout(java.util.concurrent.Executor, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNetworkTimeout",
                "parameters": [],
                "signature": "public abstract int getNetworkTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "beginRequest",
                "parameters": [],
                "signature": "public default void beginRequest() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "endRequest",
                "parameters": [],
                "signature": "public default void endRequest() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShardingKeyIfValid",
                "parameters": [
                    "java.sql.ShardingKey",
                    "java.sql.ShardingKey",
                    "int"
                ],
                "signature": "public default boolean setShardingKeyIfValid(java.sql.ShardingKey, java.sql.ShardingKey, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShardingKeyIfValid",
                "parameters": [
                    "java.sql.ShardingKey",
                    "int"
                ],
                "signature": "public default boolean setShardingKeyIfValid(java.sql.ShardingKey, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShardingKey",
                "parameters": [
                    "java.sql.ShardingKey",
                    "java.sql.ShardingKey"
                ],
                "signature": "public default void setShardingKey(java.sql.ShardingKey, java.sql.ShardingKey) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public default void setShardingKey(java.sql.ShardingKey) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "ConnectionBuilder": [
            {
                "name": "user",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ConnectionBuilder user(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ConnectionBuilder password(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "shardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public abstract java.sql.ConnectionBuilder shardingKey(java.sql.ShardingKey);",
                "return_type": "void"
            },
            {
                "name": "superShardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public abstract java.sql.ConnectionBuilder superShardingKey(java.sql.ShardingKey);",
                "return_type": "void"
            },
            {
                "name": "build",
                "parameters": [],
                "signature": "public abstract java.sql.Connection build() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "DataTruncation": [
            {
                "name": "java.sql.DataTruncation",
                "parameters": [
                    "int",
                    "boolean",
                    "boolean",
                    "int",
                    "int"
                ],
                "signature": "public java.sql.DataTruncation(int, boolean, boolean, int, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.DataTruncation",
                "parameters": [
                    "int",
                    "boolean",
                    "boolean",
                    "int",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.DataTruncation(int, boolean, boolean, int, int, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getIndex",
                "parameters": [],
                "signature": "public int getIndex();",
                "return_type": "int"
            },
            {
                "name": "getParameter",
                "parameters": [],
                "signature": "public boolean getParameter();",
                "return_type": "boolean"
            },
            {
                "name": "getRead",
                "parameters": [],
                "signature": "public boolean getRead();",
                "return_type": "boolean"
            },
            {
                "name": "getDataSize",
                "parameters": [],
                "signature": "public int getDataSize();",
                "return_type": "int"
            },
            {
                "name": "getTransferSize",
                "parameters": [],
                "signature": "public int getTransferSize();",
                "return_type": "int"
            }
        ],
        "DatabaseMetaData": [
            {
                "name": "allProceduresAreCallable",
                "parameters": [],
                "signature": "public abstract boolean allProceduresAreCallable() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "allTablesAreSelectable",
                "parameters": [],
                "signature": "public abstract boolean allTablesAreSelectable() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getURL",
                "parameters": [],
                "signature": "public abstract java.lang.String getURL() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getUserName",
                "parameters": [],
                "signature": "public abstract java.lang.String getUserName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isReadOnly",
                "parameters": [],
                "signature": "public abstract boolean isReadOnly() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "nullsAreSortedHigh",
                "parameters": [],
                "signature": "public abstract boolean nullsAreSortedHigh() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "nullsAreSortedLow",
                "parameters": [],
                "signature": "public abstract boolean nullsAreSortedLow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "nullsAreSortedAtStart",
                "parameters": [],
                "signature": "public abstract boolean nullsAreSortedAtStart() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "nullsAreSortedAtEnd",
                "parameters": [],
                "signature": "public abstract boolean nullsAreSortedAtEnd() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDatabaseProductName",
                "parameters": [],
                "signature": "public abstract java.lang.String getDatabaseProductName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDatabaseProductVersion",
                "parameters": [],
                "signature": "public abstract java.lang.String getDatabaseProductVersion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDriverName",
                "parameters": [],
                "signature": "public abstract java.lang.String getDriverName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDriverVersion",
                "parameters": [],
                "signature": "public abstract java.lang.String getDriverVersion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDriverMajorVersion",
                "parameters": [],
                "signature": "public abstract int getDriverMajorVersion();",
                "return_type": "void"
            },
            {
                "name": "getDriverMinorVersion",
                "parameters": [],
                "signature": "public abstract int getDriverMinorVersion();",
                "return_type": "void"
            },
            {
                "name": "usesLocalFiles",
                "parameters": [],
                "signature": "public abstract boolean usesLocalFiles() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "usesLocalFilePerTable",
                "parameters": [],
                "signature": "public abstract boolean usesLocalFilePerTable() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsMixedCaseIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean supportsMixedCaseIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "storesUpperCaseIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean storesUpperCaseIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "storesLowerCaseIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean storesLowerCaseIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "storesMixedCaseIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean storesMixedCaseIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsMixedCaseQuotedIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean supportsMixedCaseQuotedIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "storesUpperCaseQuotedIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean storesUpperCaseQuotedIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "storesLowerCaseQuotedIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean storesLowerCaseQuotedIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "storesMixedCaseQuotedIdentifiers",
                "parameters": [],
                "signature": "public abstract boolean storesMixedCaseQuotedIdentifiers() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getIdentifierQuoteString",
                "parameters": [],
                "signature": "public abstract java.lang.String getIdentifierQuoteString() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSQLKeywords",
                "parameters": [],
                "signature": "public abstract java.lang.String getSQLKeywords() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNumericFunctions",
                "parameters": [],
                "signature": "public abstract java.lang.String getNumericFunctions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getStringFunctions",
                "parameters": [],
                "signature": "public abstract java.lang.String getStringFunctions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSystemFunctions",
                "parameters": [],
                "signature": "public abstract java.lang.String getSystemFunctions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimeDateFunctions",
                "parameters": [],
                "signature": "public abstract java.lang.String getTimeDateFunctions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSearchStringEscape",
                "parameters": [],
                "signature": "public abstract java.lang.String getSearchStringEscape() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getExtraNameCharacters",
                "parameters": [],
                "signature": "public abstract java.lang.String getExtraNameCharacters() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsAlterTableWithAddColumn",
                "parameters": [],
                "signature": "public abstract boolean supportsAlterTableWithAddColumn() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsAlterTableWithDropColumn",
                "parameters": [],
                "signature": "public abstract boolean supportsAlterTableWithDropColumn() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsColumnAliasing",
                "parameters": [],
                "signature": "public abstract boolean supportsColumnAliasing() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "nullPlusNonNullIsNull",
                "parameters": [],
                "signature": "public abstract boolean nullPlusNonNullIsNull() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsConvert",
                "parameters": [],
                "signature": "public abstract boolean supportsConvert() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsConvert",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract boolean supportsConvert(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsTableCorrelationNames",
                "parameters": [],
                "signature": "public abstract boolean supportsTableCorrelationNames() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsDifferentTableCorrelationNames",
                "parameters": [],
                "signature": "public abstract boolean supportsDifferentTableCorrelationNames() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsExpressionsInOrderBy",
                "parameters": [],
                "signature": "public abstract boolean supportsExpressionsInOrderBy() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsOrderByUnrelated",
                "parameters": [],
                "signature": "public abstract boolean supportsOrderByUnrelated() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsGroupBy",
                "parameters": [],
                "signature": "public abstract boolean supportsGroupBy() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsGroupByUnrelated",
                "parameters": [],
                "signature": "public abstract boolean supportsGroupByUnrelated() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsGroupByBeyondSelect",
                "parameters": [],
                "signature": "public abstract boolean supportsGroupByBeyondSelect() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsLikeEscapeClause",
                "parameters": [],
                "signature": "public abstract boolean supportsLikeEscapeClause() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsMultipleResultSets",
                "parameters": [],
                "signature": "public abstract boolean supportsMultipleResultSets() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsMultipleTransactions",
                "parameters": [],
                "signature": "public abstract boolean supportsMultipleTransactions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsNonNullableColumns",
                "parameters": [],
                "signature": "public abstract boolean supportsNonNullableColumns() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsMinimumSQLGrammar",
                "parameters": [],
                "signature": "public abstract boolean supportsMinimumSQLGrammar() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCoreSQLGrammar",
                "parameters": [],
                "signature": "public abstract boolean supportsCoreSQLGrammar() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsExtendedSQLGrammar",
                "parameters": [],
                "signature": "public abstract boolean supportsExtendedSQLGrammar() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsANSI92EntryLevelSQL",
                "parameters": [],
                "signature": "public abstract boolean supportsANSI92EntryLevelSQL() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsANSI92IntermediateSQL",
                "parameters": [],
                "signature": "public abstract boolean supportsANSI92IntermediateSQL() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsANSI92FullSQL",
                "parameters": [],
                "signature": "public abstract boolean supportsANSI92FullSQL() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsIntegrityEnhancementFacility",
                "parameters": [],
                "signature": "public abstract boolean supportsIntegrityEnhancementFacility() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsOuterJoins",
                "parameters": [],
                "signature": "public abstract boolean supportsOuterJoins() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsFullOuterJoins",
                "parameters": [],
                "signature": "public abstract boolean supportsFullOuterJoins() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsLimitedOuterJoins",
                "parameters": [],
                "signature": "public abstract boolean supportsLimitedOuterJoins() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSchemaTerm",
                "parameters": [],
                "signature": "public abstract java.lang.String getSchemaTerm() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getProcedureTerm",
                "parameters": [],
                "signature": "public abstract java.lang.String getProcedureTerm() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCatalogTerm",
                "parameters": [],
                "signature": "public abstract java.lang.String getCatalogTerm() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isCatalogAtStart",
                "parameters": [],
                "signature": "public abstract boolean isCatalogAtStart() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCatalogSeparator",
                "parameters": [],
                "signature": "public abstract java.lang.String getCatalogSeparator() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSchemasInDataManipulation",
                "parameters": [],
                "signature": "public abstract boolean supportsSchemasInDataManipulation() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSchemasInProcedureCalls",
                "parameters": [],
                "signature": "public abstract boolean supportsSchemasInProcedureCalls() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSchemasInTableDefinitions",
                "parameters": [],
                "signature": "public abstract boolean supportsSchemasInTableDefinitions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSchemasInIndexDefinitions",
                "parameters": [],
                "signature": "public abstract boolean supportsSchemasInIndexDefinitions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSchemasInPrivilegeDefinitions",
                "parameters": [],
                "signature": "public abstract boolean supportsSchemasInPrivilegeDefinitions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCatalogsInDataManipulation",
                "parameters": [],
                "signature": "public abstract boolean supportsCatalogsInDataManipulation() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCatalogsInProcedureCalls",
                "parameters": [],
                "signature": "public abstract boolean supportsCatalogsInProcedureCalls() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCatalogsInTableDefinitions",
                "parameters": [],
                "signature": "public abstract boolean supportsCatalogsInTableDefinitions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCatalogsInIndexDefinitions",
                "parameters": [],
                "signature": "public abstract boolean supportsCatalogsInIndexDefinitions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCatalogsInPrivilegeDefinitions",
                "parameters": [],
                "signature": "public abstract boolean supportsCatalogsInPrivilegeDefinitions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsPositionedDelete",
                "parameters": [],
                "signature": "public abstract boolean supportsPositionedDelete() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsPositionedUpdate",
                "parameters": [],
                "signature": "public abstract boolean supportsPositionedUpdate() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSelectForUpdate",
                "parameters": [],
                "signature": "public abstract boolean supportsSelectForUpdate() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsStoredProcedures",
                "parameters": [],
                "signature": "public abstract boolean supportsStoredProcedures() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSubqueriesInComparisons",
                "parameters": [],
                "signature": "public abstract boolean supportsSubqueriesInComparisons() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSubqueriesInExists",
                "parameters": [],
                "signature": "public abstract boolean supportsSubqueriesInExists() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSubqueriesInIns",
                "parameters": [],
                "signature": "public abstract boolean supportsSubqueriesInIns() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSubqueriesInQuantifieds",
                "parameters": [],
                "signature": "public abstract boolean supportsSubqueriesInQuantifieds() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsCorrelatedSubqueries",
                "parameters": [],
                "signature": "public abstract boolean supportsCorrelatedSubqueries() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsUnion",
                "parameters": [],
                "signature": "public abstract boolean supportsUnion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsUnionAll",
                "parameters": [],
                "signature": "public abstract boolean supportsUnionAll() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsOpenCursorsAcrossCommit",
                "parameters": [],
                "signature": "public abstract boolean supportsOpenCursorsAcrossCommit() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsOpenCursorsAcrossRollback",
                "parameters": [],
                "signature": "public abstract boolean supportsOpenCursorsAcrossRollback() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsOpenStatementsAcrossCommit",
                "parameters": [],
                "signature": "public abstract boolean supportsOpenStatementsAcrossCommit() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsOpenStatementsAcrossRollback",
                "parameters": [],
                "signature": "public abstract boolean supportsOpenStatementsAcrossRollback() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxBinaryLiteralLength",
                "parameters": [],
                "signature": "public abstract int getMaxBinaryLiteralLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxCharLiteralLength",
                "parameters": [],
                "signature": "public abstract int getMaxCharLiteralLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxColumnNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxColumnNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxColumnsInGroupBy",
                "parameters": [],
                "signature": "public abstract int getMaxColumnsInGroupBy() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxColumnsInIndex",
                "parameters": [],
                "signature": "public abstract int getMaxColumnsInIndex() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxColumnsInOrderBy",
                "parameters": [],
                "signature": "public abstract int getMaxColumnsInOrderBy() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxColumnsInSelect",
                "parameters": [],
                "signature": "public abstract int getMaxColumnsInSelect() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxColumnsInTable",
                "parameters": [],
                "signature": "public abstract int getMaxColumnsInTable() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxConnections",
                "parameters": [],
                "signature": "public abstract int getMaxConnections() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxCursorNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxCursorNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxIndexLength",
                "parameters": [],
                "signature": "public abstract int getMaxIndexLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxSchemaNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxSchemaNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxProcedureNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxProcedureNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxCatalogNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxCatalogNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxRowSize",
                "parameters": [],
                "signature": "public abstract int getMaxRowSize() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "doesMaxRowSizeIncludeBlobs",
                "parameters": [],
                "signature": "public abstract boolean doesMaxRowSizeIncludeBlobs() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxStatementLength",
                "parameters": [],
                "signature": "public abstract int getMaxStatementLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxStatements",
                "parameters": [],
                "signature": "public abstract int getMaxStatements() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxTableNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxTableNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxTablesInSelect",
                "parameters": [],
                "signature": "public abstract int getMaxTablesInSelect() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxUserNameLength",
                "parameters": [],
                "signature": "public abstract int getMaxUserNameLength() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDefaultTransactionIsolation",
                "parameters": [],
                "signature": "public abstract int getDefaultTransactionIsolation() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsTransactions",
                "parameters": [],
                "signature": "public abstract boolean supportsTransactions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsTransactionIsolationLevel",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean supportsTransactionIsolationLevel(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsDataDefinitionAndDataManipulationTransactions",
                "parameters": [],
                "signature": "public abstract boolean supportsDataDefinitionAndDataManipulationTransactions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsDataManipulationTransactionsOnly",
                "parameters": [],
                "signature": "public abstract boolean supportsDataManipulationTransactionsOnly() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "dataDefinitionCausesTransactionCommit",
                "parameters": [],
                "signature": "public abstract boolean dataDefinitionCausesTransactionCommit() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "dataDefinitionIgnoredInTransactions",
                "parameters": [],
                "signature": "public abstract boolean dataDefinitionIgnoredInTransactions() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getProcedures",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getProcedures(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getProcedureColumns",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getProcedureColumns(java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTables",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String[]"
                ],
                "signature": "public abstract java.sql.ResultSet getTables(java.lang.String, java.lang.String, java.lang.String, java.lang.String[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSchemas",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getSchemas() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCatalogs",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getCatalogs() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTableTypes",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getTableTypes() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumns",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getColumns(java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnPrivileges",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getColumnPrivileges(java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTablePrivileges",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getTablePrivileges(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBestRowIdentifier",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "boolean"
                ],
                "signature": "public abstract java.sql.ResultSet getBestRowIdentifier(java.lang.String, java.lang.String, java.lang.String, int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getVersionColumns",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getVersionColumns(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPrimaryKeys",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getPrimaryKeys(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getImportedKeys",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getImportedKeys(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getExportedKeys",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getExportedKeys(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCrossReference",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getCrossReference(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTypeInfo",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getTypeInfo() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getIndexInfo",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "boolean",
                    "boolean"
                ],
                "signature": "public abstract java.sql.ResultSet getIndexInfo(java.lang.String, java.lang.String, java.lang.String, boolean, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsResultSetType",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean supportsResultSetType(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsResultSetConcurrency",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract boolean supportsResultSetConcurrency(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "ownUpdatesAreVisible",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean ownUpdatesAreVisible(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "ownDeletesAreVisible",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean ownDeletesAreVisible(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "ownInsertsAreVisible",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean ownInsertsAreVisible(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "othersUpdatesAreVisible",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean othersUpdatesAreVisible(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "othersDeletesAreVisible",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean othersDeletesAreVisible(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "othersInsertsAreVisible",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean othersInsertsAreVisible(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updatesAreDetected",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean updatesAreDetected(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "deletesAreDetected",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean deletesAreDetected(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "insertsAreDetected",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean insertsAreDetected(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsBatchUpdates",
                "parameters": [],
                "signature": "public abstract boolean supportsBatchUpdates() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getUDTs",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public abstract java.sql.ResultSet getUDTs(java.lang.String, java.lang.String, java.lang.String, int[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getConnection",
                "parameters": [],
                "signature": "public abstract java.sql.Connection getConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSavepoints",
                "parameters": [],
                "signature": "public abstract boolean supportsSavepoints() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsNamedParameters",
                "parameters": [],
                "signature": "public abstract boolean supportsNamedParameters() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsMultipleOpenResults",
                "parameters": [],
                "signature": "public abstract boolean supportsMultipleOpenResults() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsGetGeneratedKeys",
                "parameters": [],
                "signature": "public abstract boolean supportsGetGeneratedKeys() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSuperTypes",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getSuperTypes(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSuperTables",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getSuperTables(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAttributes",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getAttributes(java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsResultSetHoldability",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean supportsResultSetHoldability(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSetHoldability",
                "parameters": [],
                "signature": "public abstract int getResultSetHoldability() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDatabaseMajorVersion",
                "parameters": [],
                "signature": "public abstract int getDatabaseMajorVersion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDatabaseMinorVersion",
                "parameters": [],
                "signature": "public abstract int getDatabaseMinorVersion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getJDBCMajorVersion",
                "parameters": [],
                "signature": "public abstract int getJDBCMajorVersion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getJDBCMinorVersion",
                "parameters": [],
                "signature": "public abstract int getJDBCMinorVersion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSQLStateType",
                "parameters": [],
                "signature": "public abstract int getSQLStateType() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "locatorsUpdateCopy",
                "parameters": [],
                "signature": "public abstract boolean locatorsUpdateCopy() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsStatementPooling",
                "parameters": [],
                "signature": "public abstract boolean supportsStatementPooling() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRowIdLifetime",
                "parameters": [],
                "signature": "public abstract java.sql.RowIdLifetime getRowIdLifetime() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSchemas",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getSchemas(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsStoredFunctionsUsingCallSyntax",
                "parameters": [],
                "signature": "public abstract boolean supportsStoredFunctionsUsingCallSyntax() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "autoCommitFailureClosesAllResultSets",
                "parameters": [],
                "signature": "public abstract boolean autoCommitFailureClosesAllResultSets() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getClientInfoProperties",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getClientInfoProperties() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFunctions",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getFunctions(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFunctionColumns",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getFunctionColumns(java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPseudoColumns",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet getPseudoColumns(java.lang.String, java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "generatedKeyAlwaysReturned",
                "parameters": [],
                "signature": "public abstract boolean generatedKeyAlwaysReturned() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxLogicalLobSize",
                "parameters": [],
                "signature": "public default long getMaxLogicalLobSize() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsRefCursors",
                "parameters": [],
                "signature": "public default boolean supportsRefCursors() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "supportsSharding",
                "parameters": [],
                "signature": "public default boolean supportsSharding() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "Date": [
            {
                "name": "java.sql.Date",
                "parameters": [
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public java.sql.Date(int, int, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.Date",
                "parameters": [
                    "long"
                ],
                "signature": "public java.sql.Date(long);",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "long"
                ],
                "signature": "public void setTime(long);",
                "return_type": "void"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.Date valueOf(java.lang.String);",
                "return_type": "java.sql.Date"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getHours",
                "parameters": [],
                "signature": "public int getHours();",
                "return_type": "int"
            },
            {
                "name": "getMinutes",
                "parameters": [],
                "signature": "public int getMinutes();",
                "return_type": "int"
            },
            {
                "name": "getSeconds",
                "parameters": [],
                "signature": "public int getSeconds();",
                "return_type": "int"
            },
            {
                "name": "setHours",
                "parameters": [
                    "int"
                ],
                "signature": "public void setHours(int);",
                "return_type": "void"
            },
            {
                "name": "setMinutes",
                "parameters": [
                    "int"
                ],
                "signature": "public void setMinutes(int);",
                "return_type": "void"
            },
            {
                "name": "setSeconds",
                "parameters": [
                    "int"
                ],
                "signature": "public void setSeconds(int);",
                "return_type": "void"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.time.LocalDate"
                ],
                "signature": "public static java.sql.Date valueOf(java.time.LocalDate);",
                "return_type": "java.sql.Date"
            },
            {
                "name": "toLocalDate",
                "parameters": [],
                "signature": "public java.time.LocalDate toLocalDate();",
                "return_type": "java.time.LocalDate"
            },
            {
                "name": "toInstant",
                "parameters": [],
                "signature": "public java.time.Instant toInstant();",
                "return_type": "java.time.Instant"
            }
        ],
        "Driver": [
            {
                "name": "connect",
                "parameters": [
                    "java.lang.String",
                    "java.util.Properties"
                ],
                "signature": "public abstract java.sql.Connection connect(java.lang.String, java.util.Properties) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "acceptsURL",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean acceptsURL(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPropertyInfo",
                "parameters": [
                    "java.lang.String",
                    "java.util.Properties"
                ],
                "signature": "public abstract java.sql.DriverPropertyInfo[] getPropertyInfo(java.lang.String, java.util.Properties) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMajorVersion",
                "parameters": [],
                "signature": "public abstract int getMajorVersion();",
                "return_type": "void"
            },
            {
                "name": "getMinorVersion",
                "parameters": [],
                "signature": "public abstract int getMinorVersion();",
                "return_type": "void"
            },
            {
                "name": "jdbcCompliant",
                "parameters": [],
                "signature": "public abstract boolean jdbcCompliant();",
                "return_type": "void"
            },
            {
                "name": "getParentLogger",
                "parameters": [],
                "signature": "public abstract java.util.logging.Logger getParentLogger() throws java.sql.SQLFeatureNotSupportedException;",
                "return_type": "void"
            }
        ],
        "DriverAction": [
            {
                "name": "deregister",
                "parameters": [],
                "signature": "public abstract void deregister();",
                "return_type": "void"
            }
        ],
        "DriverInfo": [
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            }
        ],
        "DriverManager": [
            {
                "name": "java.sql.DriverManager",
                "parameters": [],
                "signature": "private java.sql.DriverManager();",
                "return_type": "void"
            },
            {
                "name": "getLogWriter",
                "parameters": [],
                "signature": "public static java.io.PrintWriter getLogWriter();",
                "return_type": "java.io.PrintWriter"
            },
            {
                "name": "setLogWriter",
                "parameters": [
                    "java.io.PrintWriter"
                ],
                "signature": "public static void setLogWriter(java.io.PrintWriter);",
                "return_type": "void"
            },
            {
                "name": "getConnection",
                "parameters": [
                    "java.lang.String",
                    "java.util.Properties"
                ],
                "signature": "public static java.sql.Connection getConnection(java.lang.String, java.util.Properties) throws java.sql.SQLException;",
                "return_type": "java.sql.Connection"
            },
            {
                "name": "getConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public static java.sql.Connection getConnection(java.lang.String, java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "java.sql.Connection"
            },
            {
                "name": "getConnection",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.Connection getConnection(java.lang.String) throws java.sql.SQLException;",
                "return_type": "java.sql.Connection"
            },
            {
                "name": "getDriver",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.Driver getDriver(java.lang.String) throws java.sql.SQLException;",
                "return_type": "java.sql.Driver"
            },
            {
                "name": "registerDriver",
                "parameters": [
                    "java.sql.Driver"
                ],
                "signature": "public static void registerDriver(java.sql.Driver) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "registerDriver",
                "parameters": [
                    "java.sql.Driver",
                    "java.sql.DriverAction"
                ],
                "signature": "public static void registerDriver(java.sql.Driver, java.sql.DriverAction) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "deregisterDriver",
                "parameters": [
                    "java.sql.Driver"
                ],
                "signature": "public static void deregisterDriver(java.sql.Driver) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDrivers",
                "parameters": [],
                "signature": "public static java.util.Enumeration<java.sql.Driver> getDrivers();",
                "return_type": "java.util.Enumeration<java.sql.Driver>"
            },
            {
                "name": "drivers",
                "parameters": [],
                "signature": "public static java.util.stream.Stream<java.sql.Driver> drivers();",
                "return_type": "java.util.stream.Stream<java.sql.Driver>"
            },
            {
                "name": "getDrivers",
                "parameters": [
                    "java.lang.Class<?>"
                ],
                "signature": "private static java.util.List<java.sql.Driver> getDrivers(java.lang.Class<?>);",
                "return_type": "void"
            },
            {
                "name": "setLoginTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public static void setLoginTimeout(int);",
                "return_type": "void"
            },
            {
                "name": "getLoginTimeout",
                "parameters": [],
                "signature": "public static int getLoginTimeout();",
                "return_type": "int"
            },
            {
                "name": "setLogStream",
                "parameters": [
                    "java.io.PrintStream"
                ],
                "signature": "public static void setLogStream(java.io.PrintStream);",
                "return_type": "void"
            },
            {
                "name": "getLogStream",
                "parameters": [],
                "signature": "public static java.io.PrintStream getLogStream();",
                "return_type": "java.io.PrintStream"
            },
            {
                "name": "println",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static void println(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "isDriverAllowed",
                "parameters": [
                    "java.sql.Driver",
                    "java.lang.Class<?>"
                ],
                "signature": "private static boolean isDriverAllowed(java.sql.Driver, java.lang.Class<?>);",
                "return_type": "void"
            },
            {
                "name": "isDriverAllowed",
                "parameters": [
                    "java.sql.Driver",
                    "java.lang.ClassLoader"
                ],
                "signature": "private static boolean isDriverAllowed(java.sql.Driver, java.lang.ClassLoader);",
                "return_type": "void"
            },
            {
                "name": "ensureDriversInitialized",
                "parameters": [],
                "signature": "private static void ensureDriversInitialized();",
                "return_type": "void"
            },
            {
                "name": "getConnection",
                "parameters": [
                    "java.lang.String",
                    "java.util.Properties",
                    "java.lang.Class<?>"
                ],
                "signature": "private static java.sql.Connection getConnection(java.lang.String, java.util.Properties, java.lang.Class<?>) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "DriverPropertyInfo": [
            {
                "name": "java.sql.DriverPropertyInfo",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.DriverPropertyInfo(java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ],
        "JDBCType": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static java.sql.JDBCType[] values();",
                "return_type": "java.sql.JDBCType[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.JDBCType valueOf(java.lang.String);",
                "return_type": "java.sql.JDBCType"
            },
            {
                "name": "java.sql.JDBCType",
                "parameters": [
                    "java.lang.Integer"
                ],
                "signature": "private java.sql.JDBCType(java.lang.Integer);",
                "return_type": "void"
            },
            {
                "name": "getName",
                "parameters": [],
                "signature": "public java.lang.String getName();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getVendor",
                "parameters": [],
                "signature": "public java.lang.String getVendor();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getVendorTypeNumber",
                "parameters": [],
                "signature": "public java.lang.Integer getVendorTypeNumber();",
                "return_type": "java.lang.Integer"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "int"
                ],
                "signature": "public static java.sql.JDBCType valueOf(int);",
                "return_type": "java.sql.JDBCType"
            }
        ],
        "NClob": [],
        "ParameterMetaData": [
            {
                "name": "getParameterCount",
                "parameters": [],
                "signature": "public abstract int getParameterCount() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isNullable",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int isNullable(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isSigned",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isSigned(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPrecision",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getPrecision(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getScale",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getScale(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getParameterType",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getParameterType(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getParameterTypeName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getParameterTypeName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getParameterClassName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getParameterClassName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getParameterMode",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getParameterMode(int) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "PreparedStatement": [
            {
                "name": "executeQuery",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet executeQuery() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeUpdate",
                "parameters": [],
                "signature": "public abstract int executeUpdate() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setNull(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBoolean",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setBoolean(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setByte",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public abstract void setByte(int, byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShort",
                "parameters": [
                    "int",
                    "short"
                ],
                "signature": "public abstract void setShort(int, short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setInt",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setInt(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLong",
                "parameters": [
                    "int",
                    "long"
                ],
                "signature": "public abstract void setLong(int, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFloat",
                "parameters": [
                    "int",
                    "float"
                ],
                "signature": "public abstract void setFloat(int, float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDouble",
                "parameters": [
                    "int",
                    "double"
                ],
                "signature": "public abstract void setDouble(int, double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBigDecimal",
                "parameters": [
                    "int",
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void setBigDecimal(int, java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "int",
                    "byte[]"
                ],
                "signature": "public abstract void setBytes(int, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "int",
                    "java.sql.Date"
                ],
                "signature": "public abstract void setDate(int, java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "int",
                    "java.sql.Time"
                ],
                "signature": "public abstract void setTime(int, java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "int",
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void setTimestamp(int, java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setAsciiStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setUnicodeStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setUnicodeStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setBinaryStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "clearParameters",
                "parameters": [],
                "signature": "public abstract void clearParameters() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "int"
                ],
                "signature": "public abstract void setObject(int, java.lang.Object, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(int, java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "execute",
                "parameters": [],
                "signature": "public abstract boolean execute() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "addBatch",
                "parameters": [],
                "signature": "public abstract void addBatch() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "int"
                ],
                "signature": "public abstract void setCharacterStream(int, java.io.Reader, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setRef",
                "parameters": [
                    "int",
                    "java.sql.Ref"
                ],
                "signature": "public abstract void setRef(int, java.sql.Ref) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "int",
                    "java.sql.Blob"
                ],
                "signature": "public abstract void setBlob(int, java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "int",
                    "java.sql.Clob"
                ],
                "signature": "public abstract void setClob(int, java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setArray",
                "parameters": [
                    "int",
                    "java.sql.Array"
                ],
                "signature": "public abstract void setArray(int, java.sql.Array) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSetMetaData getMetaData() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "int",
                    "java.sql.Date",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setDate(int, java.sql.Date, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "int",
                    "java.sql.Time",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTime(int, java.sql.Time, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "int",
                    "java.sql.Timestamp",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTimestamp(int, java.sql.Timestamp, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "int",
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNull(int, int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setURL",
                "parameters": [
                    "int",
                    "java.net.URL"
                ],
                "signature": "public abstract void setURL(int, java.net.URL) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getParameterMetaData",
                "parameters": [],
                "signature": "public abstract java.sql.ParameterMetaData getParameterMetaData() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setRowId",
                "parameters": [
                    "int",
                    "java.sql.RowId"
                ],
                "signature": "public abstract void setRowId(int, java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNString",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNString(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNCharacterStream(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "int",
                    "java.sql.NClob"
                ],
                "signature": "public abstract void setNClob(int, java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setClob(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setBlob(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNClob(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSQLXML",
                "parameters": [
                    "int",
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void setSQLXML(int, java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "int",
                    "int"
                ],
                "signature": "public abstract void setObject(int, java.lang.Object, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setAsciiStream(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setBinaryStream(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setCharacterStream(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setAsciiStream(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBinaryStream(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setCharacterStream(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNCharacterStream(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setClob(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBlob(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNClob(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "java.sql.SQLType",
                    "int"
                ],
                "signature": "public default void setObject(int, java.lang.Object, java.sql.SQLType, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "java.sql.SQLType"
                ],
                "signature": "public default void setObject(int, java.lang.Object, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeLargeUpdate",
                "parameters": [],
                "signature": "public default long executeLargeUpdate() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "PseudoColumnUsage": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static java.sql.PseudoColumnUsage[] values();",
                "return_type": "java.sql.PseudoColumnUsage[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.PseudoColumnUsage valueOf(java.lang.String);",
                "return_type": "java.sql.PseudoColumnUsage"
            },
            {
                "name": "java.sql.PseudoColumnUsage",
                "parameters": [],
                "signature": "private java.sql.PseudoColumnUsage();",
                "return_type": "void"
            }
        ],
        "Ref": [
            {
                "name": "getBaseTypeName",
                "parameters": [],
                "signature": "public abstract java.lang.String getBaseTypeName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getObject(java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [],
                "signature": "public abstract java.lang.Object getObject() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "ResultSet": [
            {
                "name": "next",
                "parameters": [],
                "signature": "public abstract boolean next() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "wasNull",
                "parameters": [],
                "signature": "public abstract boolean wasNull() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getString(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBoolean",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean getBoolean(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getByte",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract byte getByte(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getShort",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract short getShort(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getInt(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLong",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract long getLong(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFloat",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract float getFloat(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDouble",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract double getDouble(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract byte[] getBytes(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Date getDate(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Time getTime(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAsciiStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.InputStream getAsciiStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getUnicodeStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.InputStream getUnicodeStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBinaryStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.InputStream getBinaryStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBoolean",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean getBoolean(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getByte",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte getByte(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getShort",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract short getShort(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getInt",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int getInt(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLong",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract long getLong(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFloat",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract float getFloat(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDouble",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract double getDouble(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract byte[] getBytes(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Date getDate(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Time getTime(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAsciiStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.InputStream getAsciiStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getUnicodeStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.InputStream getUnicodeStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBinaryStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.InputStream getBinaryStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getWarnings",
                "parameters": [],
                "signature": "public abstract java.sql.SQLWarning getWarnings() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "clearWarnings",
                "parameters": [],
                "signature": "public abstract void clearWarnings() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCursorName",
                "parameters": [],
                "signature": "public abstract java.lang.String getCursorName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMetaData",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSetMetaData getMetaData() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.Object getObject(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Object getObject(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "findColumn",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int findColumn(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.Reader getCharacterStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.Reader getCharacterStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBigDecimal",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.math.BigDecimal getBigDecimal(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isBeforeFirst",
                "parameters": [],
                "signature": "public abstract boolean isBeforeFirst() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isAfterLast",
                "parameters": [],
                "signature": "public abstract boolean isAfterLast() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isFirst",
                "parameters": [],
                "signature": "public abstract boolean isFirst() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isLast",
                "parameters": [],
                "signature": "public abstract boolean isLast() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "beforeFirst",
                "parameters": [],
                "signature": "public abstract void beforeFirst() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "afterLast",
                "parameters": [],
                "signature": "public abstract void afterLast() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "first",
                "parameters": [],
                "signature": "public abstract boolean first() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "last",
                "parameters": [],
                "signature": "public abstract boolean last() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRow",
                "parameters": [],
                "signature": "public abstract int getRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "absolute",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean absolute(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "relative",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean relative(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "previous",
                "parameters": [],
                "signature": "public abstract boolean previous() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFetchDirection",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setFetchDirection(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFetchDirection",
                "parameters": [],
                "signature": "public abstract int getFetchDirection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFetchSize",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setFetchSize(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFetchSize",
                "parameters": [],
                "signature": "public abstract int getFetchSize() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getType",
                "parameters": [],
                "signature": "public abstract int getType() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getConcurrency",
                "parameters": [],
                "signature": "public abstract int getConcurrency() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "rowUpdated",
                "parameters": [],
                "signature": "public abstract boolean rowUpdated() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "rowInserted",
                "parameters": [],
                "signature": "public abstract boolean rowInserted() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "rowDeleted",
                "parameters": [],
                "signature": "public abstract boolean rowDeleted() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNull",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void updateNull(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBoolean",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void updateBoolean(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateByte",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public abstract void updateByte(int, byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateShort",
                "parameters": [
                    "int",
                    "short"
                ],
                "signature": "public abstract void updateShort(int, short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateInt",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void updateInt(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateLong",
                "parameters": [
                    "int",
                    "long"
                ],
                "signature": "public abstract void updateLong(int, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateFloat",
                "parameters": [
                    "int",
                    "float"
                ],
                "signature": "public abstract void updateFloat(int, float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateDouble",
                "parameters": [
                    "int",
                    "double"
                ],
                "signature": "public abstract void updateDouble(int, double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBigDecimal",
                "parameters": [
                    "int",
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void updateBigDecimal(int, java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateString",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void updateString(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBytes",
                "parameters": [
                    "int",
                    "byte[]"
                ],
                "signature": "public abstract void updateBytes(int, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateDate",
                "parameters": [
                    "int",
                    "java.sql.Date"
                ],
                "signature": "public abstract void updateDate(int, java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateTime",
                "parameters": [
                    "int",
                    "java.sql.Time"
                ],
                "signature": "public abstract void updateTime(int, java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateTimestamp",
                "parameters": [
                    "int",
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void updateTimestamp(int, java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void updateAsciiStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void updateBinaryStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "int"
                ],
                "signature": "public abstract void updateCharacterStream(int, java.io.Reader, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "int"
                ],
                "signature": "public abstract void updateObject(int, java.lang.Object, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "int",
                    "java.lang.Object"
                ],
                "signature": "public abstract void updateObject(int, java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNull",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void updateNull(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBoolean",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void updateBoolean(java.lang.String, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateByte",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void updateByte(java.lang.String, byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateShort",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void updateShort(java.lang.String, short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateInt",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void updateInt(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateLong",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void updateLong(java.lang.String, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateFloat",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void updateFloat(java.lang.String, float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateDouble",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void updateDouble(java.lang.String, double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBigDecimal",
                "parameters": [
                    "java.lang.String",
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void updateBigDecimal(java.lang.String, java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void updateString(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]"
                ],
                "signature": "public abstract void updateBytes(java.lang.String, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateDate",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Date"
                ],
                "signature": "public abstract void updateDate(java.lang.String, java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateTime",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Time"
                ],
                "signature": "public abstract void updateTime(java.lang.String, java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void updateTimestamp(java.lang.String, java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void updateAsciiStream(java.lang.String, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void updateBinaryStream(java.lang.String, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "int"
                ],
                "signature": "public abstract void updateCharacterStream(java.lang.String, java.io.Reader, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "int"
                ],
                "signature": "public abstract void updateObject(java.lang.String, java.lang.Object, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void updateObject(java.lang.String, java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "insertRow",
                "parameters": [],
                "signature": "public abstract void insertRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateRow",
                "parameters": [],
                "signature": "public abstract void updateRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "deleteRow",
                "parameters": [],
                "signature": "public abstract void deleteRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "refreshRow",
                "parameters": [],
                "signature": "public abstract void refreshRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "cancelRowUpdates",
                "parameters": [],
                "signature": "public abstract void cancelRowUpdates() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "moveToInsertRow",
                "parameters": [],
                "signature": "public abstract void moveToInsertRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "moveToCurrentRow",
                "parameters": [],
                "signature": "public abstract void moveToCurrentRow() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getStatement",
                "parameters": [],
                "signature": "public abstract java.sql.Statement getStatement() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "int",
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getObject(int, java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRef",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Ref getRef(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBlob",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Blob getBlob(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getClob",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Clob getClob(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.Array getArray(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object getObject(java.lang.String, java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRef",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Ref getRef(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBlob",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Blob getBlob(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getClob",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Clob getClob(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getArray",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Array getArray(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "int",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Date getDate(int, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDate",
                "parameters": [
                    "java.lang.String",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Date getDate(java.lang.String, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "int",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Time getTime(int, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [
                    "java.lang.String",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Time getTime(java.lang.String, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "int",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(int, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.util.Calendar"
                ],
                "signature": "public abstract java.sql.Timestamp getTimestamp(java.lang.String, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getURL",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.net.URL getURL(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getURL",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.net.URL getURL(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateRef",
                "parameters": [
                    "int",
                    "java.sql.Ref"
                ],
                "signature": "public abstract void updateRef(int, java.sql.Ref) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateRef",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Ref"
                ],
                "signature": "public abstract void updateRef(java.lang.String, java.sql.Ref) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBlob",
                "parameters": [
                    "int",
                    "java.sql.Blob"
                ],
                "signature": "public abstract void updateBlob(int, java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBlob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Blob"
                ],
                "signature": "public abstract void updateBlob(java.lang.String, java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateClob",
                "parameters": [
                    "int",
                    "java.sql.Clob"
                ],
                "signature": "public abstract void updateClob(int, java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateClob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Clob"
                ],
                "signature": "public abstract void updateClob(java.lang.String, java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateArray",
                "parameters": [
                    "int",
                    "java.sql.Array"
                ],
                "signature": "public abstract void updateArray(int, java.sql.Array) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateArray",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Array"
                ],
                "signature": "public abstract void updateArray(java.lang.String, java.sql.Array) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRowId",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.RowId getRowId(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getRowId",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.RowId getRowId(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateRowId",
                "parameters": [
                    "int",
                    "java.sql.RowId"
                ],
                "signature": "public abstract void updateRowId(int, java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateRowId",
                "parameters": [
                    "java.lang.String",
                    "java.sql.RowId"
                ],
                "signature": "public abstract void updateRowId(java.lang.String, java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getHoldability",
                "parameters": [],
                "signature": "public abstract int getHoldability() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isClosed",
                "parameters": [],
                "signature": "public abstract boolean isClosed() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNString",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void updateNString(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void updateNString(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNClob",
                "parameters": [
                    "int",
                    "java.sql.NClob"
                ],
                "signature": "public abstract void updateNClob(int, java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNClob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.NClob"
                ],
                "signature": "public abstract void updateNClob(java.lang.String, java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNClob",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.NClob getNClob(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNClob",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.NClob getNClob(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSQLXML",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.sql.SQLXML getSQLXML(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSQLXML",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.SQLXML getSQLXML(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateSQLXML",
                "parameters": [
                    "int",
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void updateSQLXML(int, java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateSQLXML",
                "parameters": [
                    "java.lang.String",
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void updateSQLXML(java.lang.String, java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNString",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getNString(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.String getNString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNCharacterStream",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.io.Reader getNCharacterStream(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getNCharacterStream",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.io.Reader getNCharacterStream(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateNCharacterStream(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateNCharacterStream(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void updateAsciiStream(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void updateBinaryStream(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateCharacterStream(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void updateAsciiStream(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void updateBinaryStream(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateCharacterStream(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBlob",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void updateBlob(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBlob",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void updateBlob(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateClob",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateClob(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateClob(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNClob",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateNClob(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void updateNClob(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateNCharacterStream(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateNCharacterStream(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void updateAsciiStream(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void updateBinaryStream(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateCharacterStream(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void updateAsciiStream(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void updateBinaryStream(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateCharacterStream(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBlob",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void updateBlob(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateBlob",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void updateBlob(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateClob",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateClob(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateClob(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNClob",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateNClob(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateNClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void updateNClob(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "int",
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T getObject(int, java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T getObject(java.lang.String, java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "java.sql.SQLType",
                    "int"
                ],
                "signature": "public default void updateObject(int, java.lang.Object, java.sql.SQLType, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "java.sql.SQLType",
                    "int"
                ],
                "signature": "public default void updateObject(java.lang.String, java.lang.Object, java.sql.SQLType, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "java.sql.SQLType"
                ],
                "signature": "public default void updateObject(int, java.lang.Object, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "updateObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "java.sql.SQLType"
                ],
                "signature": "public default void updateObject(java.lang.String, java.lang.Object, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "ResultSetMetaData": [
            {
                "name": "getColumnCount",
                "parameters": [],
                "signature": "public abstract int getColumnCount() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isAutoIncrement",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isAutoIncrement(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isCaseSensitive",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isCaseSensitive(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isSearchable",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isSearchable(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isCurrency",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isCurrency(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isNullable",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int isNullable(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isSigned",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isSigned(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnDisplaySize",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getColumnDisplaySize(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnLabel",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getColumnLabel(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getColumnName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSchemaName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getSchemaName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPrecision",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getPrecision(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getScale",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getScale(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTableName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getTableName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCatalogName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getCatalogName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnType",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract int getColumnType(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnTypeName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getColumnTypeName(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isReadOnly",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isReadOnly(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isWritable",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isWritable(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isDefinitelyWritable",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean isDefinitelyWritable(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getColumnClassName",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract java.lang.String getColumnClassName(int) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "RowId": [
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract boolean equals(java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [],
                "signature": "public abstract byte[] getBytes();",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public abstract int hashCode();",
                "return_type": "void"
            }
        ],
        "RowIdLifetime": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static java.sql.RowIdLifetime[] values();",
                "return_type": "java.sql.RowIdLifetime[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.RowIdLifetime valueOf(java.lang.String);",
                "return_type": "java.sql.RowIdLifetime"
            },
            {
                "name": "java.sql.RowIdLifetime",
                "parameters": [],
                "signature": "private java.sql.RowIdLifetime();",
                "return_type": "void"
            }
        ],
        "SQLClientInfoException": [
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [],
                "signature": "public java.sql.SQLClientInfoException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.util.Map<java.lang.String, java.sql.ClientInfoStatus>);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.util.Map<java.lang.String, java.sql.ClientInfoStatus>, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.lang.String, java.util.Map<java.lang.String, java.sql.ClientInfoStatus>);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.lang.String, java.util.Map<java.lang.String, java.sql.ClientInfoStatus>, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.lang.String, java.lang.String, java.util.Map<java.lang.String, java.sql.ClientInfoStatus>);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.lang.String, java.lang.String, java.util.Map<java.lang.String, java.sql.ClientInfoStatus>, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.lang.String, java.lang.String, int, java.util.Map<java.lang.String, java.sql.ClientInfoStatus>);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLClientInfoException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.util.Map<java.lang.String",
                    "java.sql.ClientInfoStatus>",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLClientInfoException(java.lang.String, java.lang.String, int, java.util.Map<java.lang.String, java.sql.ClientInfoStatus>, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getFailedProperties",
                "parameters": [],
                "signature": "public java.util.Map<java.lang.String, java.sql.ClientInfoStatus> getFailedProperties();",
                "return_type": "void"
            }
        ],
        "SQLData": [
            {
                "name": "getSQLTypeName",
                "parameters": [],
                "signature": "public abstract java.lang.String getSQLTypeName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readSQL",
                "parameters": [
                    "java.sql.SQLInput",
                    "java.lang.String"
                ],
                "signature": "public abstract void readSQL(java.sql.SQLInput, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeSQL",
                "parameters": [
                    "java.sql.SQLOutput"
                ],
                "signature": "public abstract void writeSQL(java.sql.SQLOutput) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "SQLDataException": [
            {
                "name": "java.sql.SQLDataException",
                "parameters": [],
                "signature": "public java.sql.SQLDataException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLDataException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLDataException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLException": [
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [],
                "signature": "public java.sql.SQLException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getSQLState",
                "parameters": [],
                "signature": "public java.lang.String getSQLState();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getErrorCode",
                "parameters": [],
                "signature": "public int getErrorCode();",
                "return_type": "int"
            },
            {
                "name": "getNextException",
                "parameters": [],
                "signature": "public java.sql.SQLException getNextException();",
                "return_type": "java.sql.SQLException"
            },
            {
                "name": "setNextException",
                "parameters": [
                    "java.sql.SQLException"
                ],
                "signature": "public void setNextException(java.sql.SQLException);",
                "return_type": "void"
            },
            {
                "name": "iterator",
                "parameters": [],
                "signature": "public java.util.Iterator<java.lang.Throwable> iterator();",
                "return_type": "java.util.Iterator<java.lang.Throwable>"
            }
        ],
        "SQLFeatureNotSupportedException": [
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [],
                "signature": "public java.sql.SQLFeatureNotSupportedException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLFeatureNotSupportedException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLFeatureNotSupportedException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLInput": [
            {
                "name": "readString",
                "parameters": [],
                "signature": "public abstract java.lang.String readString() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readBoolean",
                "parameters": [],
                "signature": "public abstract boolean readBoolean() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readByte",
                "parameters": [],
                "signature": "public abstract byte readByte() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readShort",
                "parameters": [],
                "signature": "public abstract short readShort() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readInt",
                "parameters": [],
                "signature": "public abstract int readInt() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readLong",
                "parameters": [],
                "signature": "public abstract long readLong() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readFloat",
                "parameters": [],
                "signature": "public abstract float readFloat() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readDouble",
                "parameters": [],
                "signature": "public abstract double readDouble() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readBigDecimal",
                "parameters": [],
                "signature": "public abstract java.math.BigDecimal readBigDecimal() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readBytes",
                "parameters": [],
                "signature": "public abstract byte[] readBytes() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readDate",
                "parameters": [],
                "signature": "public abstract java.sql.Date readDate() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readTime",
                "parameters": [],
                "signature": "public abstract java.sql.Time readTime() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readTimestamp",
                "parameters": [],
                "signature": "public abstract java.sql.Timestamp readTimestamp() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readCharacterStream",
                "parameters": [],
                "signature": "public abstract java.io.Reader readCharacterStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readAsciiStream",
                "parameters": [],
                "signature": "public abstract java.io.InputStream readAsciiStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readBinaryStream",
                "parameters": [],
                "signature": "public abstract java.io.InputStream readBinaryStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [],
                "signature": "public abstract java.lang.Object readObject() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readRef",
                "parameters": [],
                "signature": "public abstract java.sql.Ref readRef() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readBlob",
                "parameters": [],
                "signature": "public abstract java.sql.Blob readBlob() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readClob",
                "parameters": [],
                "signature": "public abstract java.sql.Clob readClob() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readArray",
                "parameters": [],
                "signature": "public abstract java.sql.Array readArray() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "wasNull",
                "parameters": [],
                "signature": "public abstract boolean wasNull() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readURL",
                "parameters": [],
                "signature": "public abstract java.net.URL readURL() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readNClob",
                "parameters": [],
                "signature": "public abstract java.sql.NClob readNClob() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readNString",
                "parameters": [],
                "signature": "public abstract java.lang.String readNString() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readSQLXML",
                "parameters": [],
                "signature": "public abstract java.sql.SQLXML readSQLXML() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readRowId",
                "parameters": [],
                "signature": "public abstract java.sql.RowId readRowId() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public default <T> T readObject(java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "SQLIntegrityConstraintViolationException": [
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLIntegrityConstraintViolationException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLIntegrityConstraintViolationException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLInvalidAuthorizationSpecException": [
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLInvalidAuthorizationSpecException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLInvalidAuthorizationSpecException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLNonTransientConnectionException": [
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [],
                "signature": "public java.sql.SQLNonTransientConnectionException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientConnectionException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLNonTransientException": [
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [],
                "signature": "public java.sql.SQLNonTransientException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLNonTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLNonTransientException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLOutput": [
            {
                "name": "writeString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void writeString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeBoolean",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void writeBoolean(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeByte",
                "parameters": [
                    "byte"
                ],
                "signature": "public abstract void writeByte(byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeShort",
                "parameters": [
                    "short"
                ],
                "signature": "public abstract void writeShort(short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeInt",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void writeInt(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeLong",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract void writeLong(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeFloat",
                "parameters": [
                    "float"
                ],
                "signature": "public abstract void writeFloat(float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeDouble",
                "parameters": [
                    "double"
                ],
                "signature": "public abstract void writeDouble(double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeBigDecimal",
                "parameters": [
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void writeBigDecimal(java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeBytes",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public abstract void writeBytes(byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeDate",
                "parameters": [
                    "java.sql.Date"
                ],
                "signature": "public abstract void writeDate(java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeTime",
                "parameters": [
                    "java.sql.Time"
                ],
                "signature": "public abstract void writeTime(java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeTimestamp",
                "parameters": [
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void writeTimestamp(java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeCharacterStream",
                "parameters": [
                    "java.io.Reader"
                ],
                "signature": "public abstract void writeCharacterStream(java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeAsciiStream",
                "parameters": [
                    "java.io.InputStream"
                ],
                "signature": "public abstract void writeAsciiStream(java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeBinaryStream",
                "parameters": [
                    "java.io.InputStream"
                ],
                "signature": "public abstract void writeBinaryStream(java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.sql.SQLData"
                ],
                "signature": "public abstract void writeObject(java.sql.SQLData) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeRef",
                "parameters": [
                    "java.sql.Ref"
                ],
                "signature": "public abstract void writeRef(java.sql.Ref) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeBlob",
                "parameters": [
                    "java.sql.Blob"
                ],
                "signature": "public abstract void writeBlob(java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeClob",
                "parameters": [
                    "java.sql.Clob"
                ],
                "signature": "public abstract void writeClob(java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeStruct",
                "parameters": [
                    "java.sql.Struct"
                ],
                "signature": "public abstract void writeStruct(java.sql.Struct) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeArray",
                "parameters": [
                    "java.sql.Array"
                ],
                "signature": "public abstract void writeArray(java.sql.Array) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeURL",
                "parameters": [
                    "java.net.URL"
                ],
                "signature": "public abstract void writeURL(java.net.URL) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeNString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void writeNString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeNClob",
                "parameters": [
                    "java.sql.NClob"
                ],
                "signature": "public abstract void writeNClob(java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeRowId",
                "parameters": [
                    "java.sql.RowId"
                ],
                "signature": "public abstract void writeRowId(java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeSQLXML",
                "parameters": [
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void writeSQLXML(java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.lang.Object",
                    "java.sql.SQLType"
                ],
                "signature": "public default void writeObject(java.lang.Object, java.sql.SQLType) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "SQLPermission": [
            {
                "name": "java.sql.SQLPermission",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLPermission(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLPermission",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLPermission(java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ],
        "SQLRecoverableException": [
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [],
                "signature": "public java.sql.SQLRecoverableException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLRecoverableException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLRecoverableException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLSyntaxErrorException": [
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [],
                "signature": "public java.sql.SQLSyntaxErrorException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLSyntaxErrorException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLSyntaxErrorException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLTimeoutException": [
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [],
                "signature": "public java.sql.SQLTimeoutException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTimeoutException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTimeoutException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLTransactionRollbackException": [
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [],
                "signature": "public java.sql.SQLTransactionRollbackException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransactionRollbackException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransactionRollbackException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLTransientConnectionException": [
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [],
                "signature": "public java.sql.SQLTransientConnectionException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientConnectionException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientConnectionException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLTransientException": [
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [],
                "signature": "public java.sql.SQLTransientException();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLTransientException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLTransientException(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "SQLType": [
            {
                "name": "getName",
                "parameters": [],
                "signature": "public abstract java.lang.String getName();",
                "return_type": "void"
            },
            {
                "name": "getVendor",
                "parameters": [],
                "signature": "public abstract java.lang.String getVendor();",
                "return_type": "void"
            },
            {
                "name": "getVendorTypeNumber",
                "parameters": [],
                "signature": "public abstract java.lang.Integer getVendorTypeNumber();",
                "return_type": "void"
            }
        ],
        "SQLWarning": [
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.String, java.lang.String, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [],
                "signature": "public java.sql.SQLWarning();",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.String, java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "java.sql.SQLWarning",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String",
                    "int",
                    "java.lang.Throwable"
                ],
                "signature": "public java.sql.SQLWarning(java.lang.String, java.lang.String, int, java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "getNextWarning",
                "parameters": [],
                "signature": "public java.sql.SQLWarning getNextWarning();",
                "return_type": "java.sql.SQLWarning"
            },
            {
                "name": "setNextWarning",
                "parameters": [
                    "java.sql.SQLWarning"
                ],
                "signature": "public void setNextWarning(java.sql.SQLWarning);",
                "return_type": "void"
            }
        ],
        "SQLXML": [
            {
                "name": "free",
                "parameters": [],
                "signature": "public abstract void free() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getBinaryStream",
                "parameters": [],
                "signature": "public abstract java.io.InputStream getBinaryStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [],
                "signature": "public abstract java.io.OutputStream setBinaryStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCharacterStream",
                "parameters": [],
                "signature": "public abstract java.io.Reader getCharacterStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [],
                "signature": "public abstract java.io.Writer setCharacterStream() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getString",
                "parameters": [],
                "signature": "public abstract java.lang.String getString() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSource",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T extends javax.xml.transform.Source> T getSource(java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setResult",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T extends javax.xml.transform.Result> T setResult(java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "Savepoint": [
            {
                "name": "getSavepointId",
                "parameters": [],
                "signature": "public abstract int getSavepointId() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getSavepointName",
                "parameters": [],
                "signature": "public abstract java.lang.String getSavepointName() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "ShardingKey": [],
        "ShardingKeyBuilder": [
            {
                "name": "subkey",
                "parameters": [
                    "java.lang.Object",
                    "java.sql.SQLType"
                ],
                "signature": "public abstract java.sql.ShardingKeyBuilder subkey(java.lang.Object, java.sql.SQLType);",
                "return_type": "void"
            },
            {
                "name": "build",
                "parameters": [],
                "signature": "public abstract java.sql.ShardingKey build() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "Statement": [
            {
                "name": "executeQuery",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.ResultSet executeQuery(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeUpdate",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int executeUpdate(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxFieldSize",
                "parameters": [],
                "signature": "public abstract int getMaxFieldSize() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setMaxFieldSize",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setMaxFieldSize(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxRows",
                "parameters": [],
                "signature": "public abstract int getMaxRows() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setMaxRows",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setMaxRows(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setEscapeProcessing",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setEscapeProcessing(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getQueryTimeout",
                "parameters": [],
                "signature": "public abstract int getQueryTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setQueryTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setQueryTimeout(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "cancel",
                "parameters": [],
                "signature": "public abstract void cancel() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getWarnings",
                "parameters": [],
                "signature": "public abstract java.sql.SQLWarning getWarnings() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "clearWarnings",
                "parameters": [],
                "signature": "public abstract void clearWarnings() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCursorName",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setCursorName(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "execute",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract boolean execute(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSet",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getResultSet() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getUpdateCount",
                "parameters": [],
                "signature": "public abstract int getUpdateCount() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMoreResults",
                "parameters": [],
                "signature": "public abstract boolean getMoreResults() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFetchDirection",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setFetchDirection(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFetchDirection",
                "parameters": [],
                "signature": "public abstract int getFetchDirection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFetchSize",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setFetchSize(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getFetchSize",
                "parameters": [],
                "signature": "public abstract int getFetchSize() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSetConcurrency",
                "parameters": [],
                "signature": "public abstract int getResultSetConcurrency() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSetType",
                "parameters": [],
                "signature": "public abstract int getResultSetType() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "addBatch",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void addBatch(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "clearBatch",
                "parameters": [],
                "signature": "public abstract void clearBatch() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeBatch",
                "parameters": [],
                "signature": "public abstract int[] executeBatch() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getConnection",
                "parameters": [],
                "signature": "public abstract java.sql.Connection getConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMoreResults",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract boolean getMoreResults(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getGeneratedKeys",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getGeneratedKeys() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeUpdate",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract int executeUpdate(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeUpdate",
                "parameters": [
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public abstract int executeUpdate(java.lang.String, int[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeUpdate",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String[]"
                ],
                "signature": "public abstract int executeUpdate(java.lang.String, java.lang.String[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "execute",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract boolean execute(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "execute",
                "parameters": [
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public abstract boolean execute(java.lang.String, int[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "execute",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String[]"
                ],
                "signature": "public abstract boolean execute(java.lang.String, java.lang.String[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getResultSetHoldability",
                "parameters": [],
                "signature": "public abstract int getResultSetHoldability() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isClosed",
                "parameters": [],
                "signature": "public abstract boolean isClosed() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setPoolable",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setPoolable(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isPoolable",
                "parameters": [],
                "signature": "public abstract boolean isPoolable() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "closeOnCompletion",
                "parameters": [],
                "signature": "public abstract void closeOnCompletion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isCloseOnCompletion",
                "parameters": [],
                "signature": "public abstract boolean isCloseOnCompletion() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLargeUpdateCount",
                "parameters": [],
                "signature": "public default long getLargeUpdateCount() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLargeMaxRows",
                "parameters": [
                    "long"
                ],
                "signature": "public default void setLargeMaxRows(long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLargeMaxRows",
                "parameters": [],
                "signature": "public default long getLargeMaxRows() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeLargeBatch",
                "parameters": [],
                "signature": "public default long[] executeLargeBatch() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeLargeUpdate",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public default long executeLargeUpdate(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeLargeUpdate",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public default long executeLargeUpdate(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeLargeUpdate",
                "parameters": [
                    "java.lang.String",
                    "int[]"
                ],
                "signature": "public default long executeLargeUpdate(java.lang.String, int[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "executeLargeUpdate",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String[]"
                ],
                "signature": "public default long executeLargeUpdate(java.lang.String, java.lang.String[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "enquoteLiteral",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public default java.lang.String enquoteLiteral(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "enquoteIdentifier",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public default java.lang.String enquoteIdentifier(java.lang.String, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isSimpleIdentifier",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public default boolean isSimpleIdentifier(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "enquoteNCharLiteral",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public default java.lang.String enquoteNCharLiteral(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "Struct": [
            {
                "name": "getSQLTypeName",
                "parameters": [],
                "signature": "public abstract java.lang.String getSQLTypeName() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAttributes",
                "parameters": [],
                "signature": "public abstract java.lang.Object[] getAttributes() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getAttributes",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract java.lang.Object[] getAttributes(java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "Time": [
            {
                "name": "java.sql.Time",
                "parameters": [
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public java.sql.Time(int, int, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.Time",
                "parameters": [
                    "long"
                ],
                "signature": "public java.sql.Time(long);",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "long"
                ],
                "signature": "public void setTime(long);",
                "return_type": "void"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.Time valueOf(java.lang.String);",
                "return_type": "java.sql.Time"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getYear",
                "parameters": [],
                "signature": "public int getYear();",
                "return_type": "int"
            },
            {
                "name": "getMonth",
                "parameters": [],
                "signature": "public int getMonth();",
                "return_type": "int"
            },
            {
                "name": "getDay",
                "parameters": [],
                "signature": "public int getDay();",
                "return_type": "int"
            },
            {
                "name": "getDate",
                "parameters": [],
                "signature": "public int getDate();",
                "return_type": "int"
            },
            {
                "name": "setYear",
                "parameters": [
                    "int"
                ],
                "signature": "public void setYear(int);",
                "return_type": "void"
            },
            {
                "name": "setMonth",
                "parameters": [
                    "int"
                ],
                "signature": "public void setMonth(int);",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "int"
                ],
                "signature": "public void setDate(int);",
                "return_type": "void"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.time.LocalTime"
                ],
                "signature": "public static java.sql.Time valueOf(java.time.LocalTime);",
                "return_type": "java.sql.Time"
            },
            {
                "name": "toLocalTime",
                "parameters": [],
                "signature": "public java.time.LocalTime toLocalTime();",
                "return_type": "java.time.LocalTime"
            },
            {
                "name": "toInstant",
                "parameters": [],
                "signature": "public java.time.Instant toInstant();",
                "return_type": "java.time.Instant"
            }
        ],
        "Timestamp": [
            {
                "name": "java.sql.Timestamp",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public java.sql.Timestamp(int, int, int, int, int, int, int);",
                "return_type": "void"
            },
            {
                "name": "java.sql.Timestamp",
                "parameters": [
                    "long"
                ],
                "signature": "public java.sql.Timestamp(long);",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "long"
                ],
                "signature": "public void setTime(long);",
                "return_type": "void"
            },
            {
                "name": "getTime",
                "parameters": [],
                "signature": "public long getTime();",
                "return_type": "long"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static java.sql.Timestamp valueOf(java.lang.String);",
                "return_type": "java.sql.Timestamp"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getNanos",
                "parameters": [],
                "signature": "public int getNanos();",
                "return_type": "int"
            },
            {
                "name": "setNanos",
                "parameters": [
                    "int"
                ],
                "signature": "public void setNanos(int);",
                "return_type": "void"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.sql.Timestamp"
                ],
                "signature": "public boolean equals(java.sql.Timestamp);",
                "return_type": "boolean"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "before",
                "parameters": [
                    "java.sql.Timestamp"
                ],
                "signature": "public boolean before(java.sql.Timestamp);",
                "return_type": "boolean"
            },
            {
                "name": "after",
                "parameters": [
                    "java.sql.Timestamp"
                ],
                "signature": "public boolean after(java.sql.Timestamp);",
                "return_type": "boolean"
            },
            {
                "name": "compareTo",
                "parameters": [
                    "java.sql.Timestamp"
                ],
                "signature": "public int compareTo(java.sql.Timestamp);",
                "return_type": "int"
            },
            {
                "name": "compareTo",
                "parameters": [
                    "java.util.Date"
                ],
                "signature": "public int compareTo(java.util.Date);",
                "return_type": "int"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.time.LocalDateTime"
                ],
                "signature": "public static java.sql.Timestamp valueOf(java.time.LocalDateTime);",
                "return_type": "java.sql.Timestamp"
            },
            {
                "name": "toLocalDateTime",
                "parameters": [],
                "signature": "public java.time.LocalDateTime toLocalDateTime();",
                "return_type": "java.time.LocalDateTime"
            },
            {
                "name": "from",
                "parameters": [
                    "java.time.Instant"
                ],
                "signature": "public static java.sql.Timestamp from(java.time.Instant);",
                "return_type": "java.sql.Timestamp"
            },
            {
                "name": "toInstant",
                "parameters": [],
                "signature": "public java.time.Instant toInstant();",
                "return_type": "java.time.Instant"
            },
            {
                "name": "compareTo",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public int compareTo(java.lang.Object);",
                "return_type": "int"
            }
        ],
        "Types": [
            {
                "name": "java.sql.Types",
                "parameters": [],
                "signature": "private java.sql.Types();",
                "return_type": "void"
            }
        ],
        "Wrapper": [
            {
                "name": "unwrap",
                "parameters": [
                    "java.lang.Class<T>"
                ],
                "signature": "public abstract <T> T unwrap(java.lang.Class<T>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isWrapperFor",
                "parameters": [
                    "java.lang.Class<?>"
                ],
                "signature": "public abstract boolean isWrapperFor(java.lang.Class<?>) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ]
    },
    "javax.sql": {
        "CommonDataSource": [
            {
                "name": "getLogWriter",
                "parameters": [],
                "signature": "public abstract java.io.PrintWriter getLogWriter() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLogWriter",
                "parameters": [
                    "java.io.PrintWriter"
                ],
                "signature": "public abstract void setLogWriter(java.io.PrintWriter) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLoginTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setLoginTimeout(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLoginTimeout",
                "parameters": [],
                "signature": "public abstract int getLoginTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getParentLogger",
                "parameters": [],
                "signature": "public abstract java.util.logging.Logger getParentLogger() throws java.sql.SQLFeatureNotSupportedException;",
                "return_type": "void"
            },
            {
                "name": "createShardingKeyBuilder",
                "parameters": [],
                "signature": "public default java.sql.ShardingKeyBuilder createShardingKeyBuilder() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "ConnectionEvent": [
            {
                "name": "javax.sql.ConnectionEvent",
                "parameters": [
                    "javax.sql.PooledConnection"
                ],
                "signature": "public javax.sql.ConnectionEvent(javax.sql.PooledConnection);",
                "return_type": "void"
            },
            {
                "name": "javax.sql.ConnectionEvent",
                "parameters": [
                    "javax.sql.PooledConnection",
                    "java.sql.SQLException"
                ],
                "signature": "public javax.sql.ConnectionEvent(javax.sql.PooledConnection, java.sql.SQLException);",
                "return_type": "void"
            },
            {
                "name": "getSQLException",
                "parameters": [],
                "signature": "public java.sql.SQLException getSQLException();",
                "return_type": "java.sql.SQLException"
            }
        ],
        "ConnectionEventListener": [
            {
                "name": "connectionClosed",
                "parameters": [
                    "javax.sql.ConnectionEvent"
                ],
                "signature": "public abstract void connectionClosed(javax.sql.ConnectionEvent);",
                "return_type": "void"
            },
            {
                "name": "connectionErrorOccurred",
                "parameters": [
                    "javax.sql.ConnectionEvent"
                ],
                "signature": "public abstract void connectionErrorOccurred(javax.sql.ConnectionEvent);",
                "return_type": "void"
            }
        ],
        "ConnectionPoolDataSource": [
            {
                "name": "getPooledConnection",
                "parameters": [],
                "signature": "public abstract javax.sql.PooledConnection getPooledConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPooledConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.sql.PooledConnection getPooledConnection(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLogWriter",
                "parameters": [],
                "signature": "public abstract java.io.PrintWriter getLogWriter() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLogWriter",
                "parameters": [
                    "java.io.PrintWriter"
                ],
                "signature": "public abstract void setLogWriter(java.io.PrintWriter) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLoginTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setLoginTimeout(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLoginTimeout",
                "parameters": [],
                "signature": "public abstract int getLoginTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createPooledConnectionBuilder",
                "parameters": [],
                "signature": "public default javax.sql.PooledConnectionBuilder createPooledConnectionBuilder() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "DataSource": [
            {
                "name": "getConnection",
                "parameters": [],
                "signature": "public abstract java.sql.Connection getConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract java.sql.Connection getConnection(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLogWriter",
                "parameters": [],
                "signature": "public abstract java.io.PrintWriter getLogWriter() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLogWriter",
                "parameters": [
                    "java.io.PrintWriter"
                ],
                "signature": "public abstract void setLogWriter(java.io.PrintWriter) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLoginTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setLoginTimeout(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLoginTimeout",
                "parameters": [],
                "signature": "public abstract int getLoginTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createConnectionBuilder",
                "parameters": [],
                "signature": "public default java.sql.ConnectionBuilder createConnectionBuilder() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "PooledConnection": [
            {
                "name": "getConnection",
                "parameters": [],
                "signature": "public abstract java.sql.Connection getConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "addConnectionEventListener",
                "parameters": [
                    "javax.sql.ConnectionEventListener"
                ],
                "signature": "public abstract void addConnectionEventListener(javax.sql.ConnectionEventListener);",
                "return_type": "void"
            },
            {
                "name": "removeConnectionEventListener",
                "parameters": [
                    "javax.sql.ConnectionEventListener"
                ],
                "signature": "public abstract void removeConnectionEventListener(javax.sql.ConnectionEventListener);",
                "return_type": "void"
            },
            {
                "name": "addStatementEventListener",
                "parameters": [
                    "javax.sql.StatementEventListener"
                ],
                "signature": "public abstract void addStatementEventListener(javax.sql.StatementEventListener);",
                "return_type": "void"
            },
            {
                "name": "removeStatementEventListener",
                "parameters": [
                    "javax.sql.StatementEventListener"
                ],
                "signature": "public abstract void removeStatementEventListener(javax.sql.StatementEventListener);",
                "return_type": "void"
            }
        ],
        "PooledConnectionBuilder": [
            {
                "name": "user",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.sql.PooledConnectionBuilder user(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.sql.PooledConnectionBuilder password(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "shardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public abstract javax.sql.PooledConnectionBuilder shardingKey(java.sql.ShardingKey);",
                "return_type": "void"
            },
            {
                "name": "superShardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public abstract javax.sql.PooledConnectionBuilder superShardingKey(java.sql.ShardingKey);",
                "return_type": "void"
            },
            {
                "name": "build",
                "parameters": [],
                "signature": "public abstract javax.sql.PooledConnection build() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "RowSet": [
            {
                "name": "getUrl",
                "parameters": [],
                "signature": "public abstract java.lang.String getUrl() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setUrl",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setUrl(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getDataSourceName",
                "parameters": [],
                "signature": "public abstract java.lang.String getDataSourceName();",
                "return_type": "void"
            },
            {
                "name": "setDataSourceName",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setDataSourceName(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getUsername",
                "parameters": [],
                "signature": "public abstract java.lang.String getUsername();",
                "return_type": "void"
            },
            {
                "name": "setUsername",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setUsername(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getPassword",
                "parameters": [],
                "signature": "public abstract java.lang.String getPassword();",
                "return_type": "void"
            },
            {
                "name": "setPassword",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setPassword(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTransactionIsolation",
                "parameters": [],
                "signature": "public abstract int getTransactionIsolation();",
                "return_type": "void"
            },
            {
                "name": "setTransactionIsolation",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setTransactionIsolation(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getTypeMap",
                "parameters": [],
                "signature": "public abstract java.util.Map<java.lang.String, java.lang.Class<?>> getTypeMap() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTypeMap",
                "parameters": [
                    "java.util.Map<java.lang.String",
                    "java.lang.Class<?>>"
                ],
                "signature": "public abstract void setTypeMap(java.util.Map<java.lang.String, java.lang.Class<?>>) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getCommand",
                "parameters": [],
                "signature": "public abstract java.lang.String getCommand();",
                "return_type": "void"
            },
            {
                "name": "setCommand",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract void setCommand(java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "isReadOnly",
                "parameters": [],
                "signature": "public abstract boolean isReadOnly();",
                "return_type": "void"
            },
            {
                "name": "setReadOnly",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setReadOnly(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxFieldSize",
                "parameters": [],
                "signature": "public abstract int getMaxFieldSize() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setMaxFieldSize",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setMaxFieldSize(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getMaxRows",
                "parameters": [],
                "signature": "public abstract int getMaxRows() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setMaxRows",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setMaxRows(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getEscapeProcessing",
                "parameters": [],
                "signature": "public abstract boolean getEscapeProcessing() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setEscapeProcessing",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void setEscapeProcessing(boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getQueryTimeout",
                "parameters": [],
                "signature": "public abstract int getQueryTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setQueryTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setQueryTimeout(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setType",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setType(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setConcurrency",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setConcurrency(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setNull(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setNull(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "int",
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNull(int, int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNull",
                "parameters": [
                    "java.lang.String",
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNull(java.lang.String, int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBoolean",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setBoolean(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBoolean",
                "parameters": [
                    "java.lang.String",
                    "boolean"
                ],
                "signature": "public abstract void setBoolean(java.lang.String, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setByte",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public abstract void setByte(int, byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setByte",
                "parameters": [
                    "java.lang.String",
                    "byte"
                ],
                "signature": "public abstract void setByte(java.lang.String, byte) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShort",
                "parameters": [
                    "int",
                    "short"
                ],
                "signature": "public abstract void setShort(int, short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setShort",
                "parameters": [
                    "java.lang.String",
                    "short"
                ],
                "signature": "public abstract void setShort(java.lang.String, short) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setInt",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setInt(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setInt",
                "parameters": [
                    "java.lang.String",
                    "int"
                ],
                "signature": "public abstract void setInt(java.lang.String, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLong",
                "parameters": [
                    "int",
                    "long"
                ],
                "signature": "public abstract void setLong(int, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLong",
                "parameters": [
                    "java.lang.String",
                    "long"
                ],
                "signature": "public abstract void setLong(java.lang.String, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFloat",
                "parameters": [
                    "int",
                    "float"
                ],
                "signature": "public abstract void setFloat(int, float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setFloat",
                "parameters": [
                    "java.lang.String",
                    "float"
                ],
                "signature": "public abstract void setFloat(java.lang.String, float) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDouble",
                "parameters": [
                    "int",
                    "double"
                ],
                "signature": "public abstract void setDouble(int, double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDouble",
                "parameters": [
                    "java.lang.String",
                    "double"
                ],
                "signature": "public abstract void setDouble(java.lang.String, double) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBigDecimal",
                "parameters": [
                    "int",
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void setBigDecimal(int, java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBigDecimal",
                "parameters": [
                    "java.lang.String",
                    "java.math.BigDecimal"
                ],
                "signature": "public abstract void setBigDecimal(java.lang.String, java.math.BigDecimal) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setString(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "int",
                    "byte[]"
                ],
                "signature": "public abstract void setBytes(int, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBytes",
                "parameters": [
                    "java.lang.String",
                    "byte[]"
                ],
                "signature": "public abstract void setBytes(java.lang.String, byte[]) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "int",
                    "java.sql.Date"
                ],
                "signature": "public abstract void setDate(int, java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "int",
                    "java.sql.Time"
                ],
                "signature": "public abstract void setTime(int, java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "int",
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void setTimestamp(int, java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Timestamp"
                ],
                "signature": "public abstract void setTimestamp(java.lang.String, java.sql.Timestamp) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setAsciiStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setAsciiStream(java.lang.String, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setBinaryStream(int, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "int"
                ],
                "signature": "public abstract void setBinaryStream(java.lang.String, java.io.InputStream, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "int"
                ],
                "signature": "public abstract void setCharacterStream(int, java.io.Reader, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "int"
                ],
                "signature": "public abstract void setCharacterStream(java.lang.String, java.io.Reader, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setAsciiStream(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAsciiStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setAsciiStream(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBinaryStream(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBinaryStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBinaryStream(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setCharacterStream(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setCharacterStream(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNCharacterStream(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "int",
                    "int"
                ],
                "signature": "public abstract void setObject(int, java.lang.Object, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "int",
                    "int"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object, int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object",
                    "int"
                ],
                "signature": "public abstract void setObject(int, java.lang.Object, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "int"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(java.lang.String, java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setObject",
                "parameters": [
                    "int",
                    "java.lang.Object"
                ],
                "signature": "public abstract void setObject(int, java.lang.Object) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setRef",
                "parameters": [
                    "int",
                    "java.sql.Ref"
                ],
                "signature": "public abstract void setRef(int, java.sql.Ref) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "int",
                    "java.sql.Blob"
                ],
                "signature": "public abstract void setBlob(int, java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "int",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setBlob(int, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "int",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBlob(int, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream",
                    "long"
                ],
                "signature": "public abstract void setBlob(java.lang.String, java.io.InputStream, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Blob"
                ],
                "signature": "public abstract void setBlob(java.lang.String, java.sql.Blob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setBlob",
                "parameters": [
                    "java.lang.String",
                    "java.io.InputStream"
                ],
                "signature": "public abstract void setBlob(java.lang.String, java.io.InputStream) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "int",
                    "java.sql.Clob"
                ],
                "signature": "public abstract void setClob(int, java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setClob(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setClob(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setClob(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Clob"
                ],
                "signature": "public abstract void setClob(java.lang.String, java.sql.Clob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setClob(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setArray",
                "parameters": [
                    "int",
                    "java.sql.Array"
                ],
                "signature": "public abstract void setArray(int, java.sql.Array) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "int",
                    "java.sql.Date",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setDate(int, java.sql.Date, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Date"
                ],
                "signature": "public abstract void setDate(java.lang.String, java.sql.Date) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setDate",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Date",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setDate(java.lang.String, java.sql.Date, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "int",
                    "java.sql.Time",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTime(int, java.sql.Time, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Time"
                ],
                "signature": "public abstract void setTime(java.lang.String, java.sql.Time) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTime",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Time",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTime(java.lang.String, java.sql.Time, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "int",
                    "java.sql.Timestamp",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTimestamp(int, java.sql.Timestamp, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTimestamp",
                "parameters": [
                    "java.lang.String",
                    "java.sql.Timestamp",
                    "java.util.Calendar"
                ],
                "signature": "public abstract void setTimestamp(java.lang.String, java.sql.Timestamp, java.util.Calendar) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "clearParameters",
                "parameters": [],
                "signature": "public abstract void clearParameters() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "execute",
                "parameters": [],
                "signature": "public abstract void execute() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "addRowSetListener",
                "parameters": [
                    "javax.sql.RowSetListener"
                ],
                "signature": "public abstract void addRowSetListener(javax.sql.RowSetListener);",
                "return_type": "void"
            },
            {
                "name": "removeRowSetListener",
                "parameters": [
                    "javax.sql.RowSetListener"
                ],
                "signature": "public abstract void removeRowSetListener(javax.sql.RowSetListener);",
                "return_type": "void"
            },
            {
                "name": "setSQLXML",
                "parameters": [
                    "int",
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void setSQLXML(int, java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSQLXML",
                "parameters": [
                    "java.lang.String",
                    "java.sql.SQLXML"
                ],
                "signature": "public abstract void setSQLXML(java.lang.String, java.sql.SQLXML) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setRowId",
                "parameters": [
                    "int",
                    "java.sql.RowId"
                ],
                "signature": "public abstract void setRowId(int, java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setRowId",
                "parameters": [
                    "java.lang.String",
                    "java.sql.RowId"
                ],
                "signature": "public abstract void setRowId(java.lang.String, java.sql.RowId) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNString",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNString(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNString",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract void setNString(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNCharacterStream(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNCharacterStream(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNCharacterStream",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNCharacterStream(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "java.lang.String",
                    "java.sql.NClob"
                ],
                "signature": "public abstract void setNClob(java.lang.String, java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNClob(java.lang.String, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "java.lang.String",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNClob(java.lang.String, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "int",
                    "java.io.Reader",
                    "long"
                ],
                "signature": "public abstract void setNClob(int, java.io.Reader, long) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "int",
                    "java.sql.NClob"
                ],
                "signature": "public abstract void setNClob(int, java.sql.NClob) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNClob",
                "parameters": [
                    "int",
                    "java.io.Reader"
                ],
                "signature": "public abstract void setNClob(int, java.io.Reader) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setURL",
                "parameters": [
                    "int",
                    "java.net.URL"
                ],
                "signature": "public abstract void setURL(int, java.net.URL) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "RowSetEvent": [
            {
                "name": "javax.sql.RowSetEvent",
                "parameters": [
                    "javax.sql.RowSet"
                ],
                "signature": "public javax.sql.RowSetEvent(javax.sql.RowSet);",
                "return_type": "void"
            }
        ],
        "RowSetInternal": [
            {
                "name": "getParams",
                "parameters": [],
                "signature": "public abstract java.lang.Object[] getParams() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getConnection",
                "parameters": [],
                "signature": "public abstract java.sql.Connection getConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setMetaData",
                "parameters": [
                    "javax.sql.RowSetMetaData"
                ],
                "signature": "public abstract void setMetaData(javax.sql.RowSetMetaData) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getOriginal",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getOriginal() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getOriginalRow",
                "parameters": [],
                "signature": "public abstract java.sql.ResultSet getOriginalRow() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "RowSetListener": [
            {
                "name": "rowSetChanged",
                "parameters": [
                    "javax.sql.RowSetEvent"
                ],
                "signature": "public abstract void rowSetChanged(javax.sql.RowSetEvent);",
                "return_type": "void"
            },
            {
                "name": "rowChanged",
                "parameters": [
                    "javax.sql.RowSetEvent"
                ],
                "signature": "public abstract void rowChanged(javax.sql.RowSetEvent);",
                "return_type": "void"
            },
            {
                "name": "cursorMoved",
                "parameters": [
                    "javax.sql.RowSetEvent"
                ],
                "signature": "public abstract void cursorMoved(javax.sql.RowSetEvent);",
                "return_type": "void"
            }
        ],
        "RowSetMetaData": [
            {
                "name": "setColumnCount",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setColumnCount(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setAutoIncrement",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setAutoIncrement(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCaseSensitive",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setCaseSensitive(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSearchable",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setSearchable(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCurrency",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setCurrency(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setNullable",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setNullable(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSigned",
                "parameters": [
                    "int",
                    "boolean"
                ],
                "signature": "public abstract void setSigned(int, boolean) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setColumnDisplaySize",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setColumnDisplaySize(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setColumnLabel",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setColumnLabel(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setColumnName",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setColumnName(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setSchemaName",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setSchemaName(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setPrecision",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setPrecision(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setScale",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setScale(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setTableName",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setTableName(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setCatalogName",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setCatalogName(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setColumnType",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public abstract void setColumnType(int, int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setColumnTypeName",
                "parameters": [
                    "int",
                    "java.lang.String"
                ],
                "signature": "public abstract void setColumnTypeName(int, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "RowSetReader": [
            {
                "name": "readData",
                "parameters": [
                    "javax.sql.RowSetInternal"
                ],
                "signature": "public abstract void readData(javax.sql.RowSetInternal) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "RowSetWriter": [
            {
                "name": "writeData",
                "parameters": [
                    "javax.sql.RowSetInternal"
                ],
                "signature": "public abstract boolean writeData(javax.sql.RowSetInternal) throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "StatementEvent": [
            {
                "name": "javax.sql.StatementEvent",
                "parameters": [
                    "javax.sql.PooledConnection",
                    "java.sql.PreparedStatement"
                ],
                "signature": "public javax.sql.StatementEvent(javax.sql.PooledConnection, java.sql.PreparedStatement);",
                "return_type": "void"
            },
            {
                "name": "javax.sql.StatementEvent",
                "parameters": [
                    "javax.sql.PooledConnection",
                    "java.sql.PreparedStatement",
                    "java.sql.SQLException"
                ],
                "signature": "public javax.sql.StatementEvent(javax.sql.PooledConnection, java.sql.PreparedStatement, java.sql.SQLException);",
                "return_type": "void"
            },
            {
                "name": "getStatement",
                "parameters": [],
                "signature": "public java.sql.PreparedStatement getStatement();",
                "return_type": "java.sql.PreparedStatement"
            },
            {
                "name": "getSQLException",
                "parameters": [],
                "signature": "public java.sql.SQLException getSQLException();",
                "return_type": "java.sql.SQLException"
            }
        ],
        "StatementEventListener": [
            {
                "name": "statementClosed",
                "parameters": [
                    "javax.sql.StatementEvent"
                ],
                "signature": "public abstract void statementClosed(javax.sql.StatementEvent);",
                "return_type": "void"
            },
            {
                "name": "statementErrorOccurred",
                "parameters": [
                    "javax.sql.StatementEvent"
                ],
                "signature": "public abstract void statementErrorOccurred(javax.sql.StatementEvent);",
                "return_type": "void"
            }
        ],
        "XAConnection": [
            {
                "name": "getXAResource",
                "parameters": [],
                "signature": "public abstract javax.transaction.xa.XAResource getXAResource() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "XAConnectionBuilder": [
            {
                "name": "user",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.sql.XAConnectionBuilder user(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "password",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.sql.XAConnectionBuilder password(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "shardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public abstract javax.sql.XAConnectionBuilder shardingKey(java.sql.ShardingKey);",
                "return_type": "void"
            },
            {
                "name": "superShardingKey",
                "parameters": [
                    "java.sql.ShardingKey"
                ],
                "signature": "public abstract javax.sql.XAConnectionBuilder superShardingKey(java.sql.ShardingKey);",
                "return_type": "void"
            },
            {
                "name": "build",
                "parameters": [],
                "signature": "public abstract javax.sql.XAConnection build() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ],
        "XADataSource": [
            {
                "name": "getXAConnection",
                "parameters": [],
                "signature": "public abstract javax.sql.XAConnection getXAConnection() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getXAConnection",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.sql.XAConnection getXAConnection(java.lang.String, java.lang.String) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLogWriter",
                "parameters": [],
                "signature": "public abstract java.io.PrintWriter getLogWriter() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLogWriter",
                "parameters": [
                    "java.io.PrintWriter"
                ],
                "signature": "public abstract void setLogWriter(java.io.PrintWriter) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "setLoginTimeout",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract void setLoginTimeout(int) throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "getLoginTimeout",
                "parameters": [],
                "signature": "public abstract int getLoginTimeout() throws java.sql.SQLException;",
                "return_type": "void"
            },
            {
                "name": "createXAConnectionBuilder",
                "parameters": [],
                "signature": "public default javax.sql.XAConnectionBuilder createXAConnectionBuilder() throws java.sql.SQLException;",
                "return_type": "void"
            }
        ]
    },
    "javax.smartcardio": {
        "ATR": [
            {
                "name": "javax.smartcardio.ATR",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public javax.smartcardio.ATR(byte[]);",
                "return_type": "void"
            },
            {
                "name": "parse",
                "parameters": [],
                "signature": "private void parse();",
                "return_type": "void"
            },
            {
                "name": "getBytes",
                "parameters": [],
                "signature": "public byte[] getBytes();",
                "return_type": "byte[]"
            },
            {
                "name": "getHistoricalBytes",
                "parameters": [],
                "signature": "public byte[] getHistoricalBytes();",
                "return_type": "byte[]"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            }
        ],
        "Card": [
            {
                "name": "javax.smartcardio.Card",
                "parameters": [],
                "signature": "protected javax.smartcardio.Card();",
                "return_type": "void"
            },
            {
                "name": "getATR",
                "parameters": [],
                "signature": "public abstract javax.smartcardio.ATR getATR();",
                "return_type": "void"
            },
            {
                "name": "getProtocol",
                "parameters": [],
                "signature": "public abstract java.lang.String getProtocol();",
                "return_type": "void"
            },
            {
                "name": "getBasicChannel",
                "parameters": [],
                "signature": "public abstract javax.smartcardio.CardChannel getBasicChannel();",
                "return_type": "void"
            },
            {
                "name": "openLogicalChannel",
                "parameters": [],
                "signature": "public abstract javax.smartcardio.CardChannel openLogicalChannel() throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "beginExclusive",
                "parameters": [],
                "signature": "public abstract void beginExclusive() throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "endExclusive",
                "parameters": [],
                "signature": "public abstract void endExclusive() throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "transmitControlCommand",
                "parameters": [
                    "int",
                    "byte[]"
                ],
                "signature": "public abstract byte[] transmitControlCommand(int, byte[]) throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "disconnect",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract void disconnect(boolean) throws javax.smartcardio.CardException;",
                "return_type": "void"
            }
        ],
        "CardChannel": [
            {
                "name": "javax.smartcardio.CardChannel",
                "parameters": [],
                "signature": "protected javax.smartcardio.CardChannel();",
                "return_type": "void"
            },
            {
                "name": "getCard",
                "parameters": [],
                "signature": "public abstract javax.smartcardio.Card getCard();",
                "return_type": "void"
            },
            {
                "name": "getChannelNumber",
                "parameters": [],
                "signature": "public abstract int getChannelNumber();",
                "return_type": "void"
            },
            {
                "name": "transmit",
                "parameters": [
                    "javax.smartcardio.CommandAPDU"
                ],
                "signature": "public abstract javax.smartcardio.ResponseAPDU transmit(javax.smartcardio.CommandAPDU) throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "transmit",
                "parameters": [
                    "java.nio.ByteBuffer",
                    "java.nio.ByteBuffer"
                ],
                "signature": "public abstract int transmit(java.nio.ByteBuffer, java.nio.ByteBuffer) throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws javax.smartcardio.CardException;",
                "return_type": "void"
            }
        ],
        "CardException": [
            {
                "name": "javax.smartcardio.CardException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.smartcardio.CardException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CardException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public javax.smartcardio.CardException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CardException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.smartcardio.CardException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "CardNotPresentException": [
            {
                "name": "javax.smartcardio.CardNotPresentException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.smartcardio.CardNotPresentException(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CardNotPresentException",
                "parameters": [
                    "java.lang.Throwable"
                ],
                "signature": "public javax.smartcardio.CardNotPresentException(java.lang.Throwable);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CardNotPresentException",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Throwable"
                ],
                "signature": "public javax.smartcardio.CardNotPresentException(java.lang.String, java.lang.Throwable);",
                "return_type": "void"
            }
        ],
        "CardPermission": [
            {
                "name": "javax.smartcardio.CardPermission",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.smartcardio.CardPermission(java.lang.String, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getMask",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "private static int getMask(java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getActions",
                "parameters": [
                    "int"
                ],
                "signature": "private static java.lang.String getActions(int);",
                "return_type": "void"
            },
            {
                "name": "getActions",
                "parameters": [],
                "signature": "public java.lang.String getActions();",
                "return_type": "java.lang.String"
            },
            {
                "name": "implies",
                "parameters": [
                    "java.security.Permission"
                ],
                "signature": "public boolean implies(java.security.Permission);",
                "return_type": "boolean"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "writeObject",
                "parameters": [
                    "java.io.ObjectOutputStream"
                ],
                "signature": "private void writeObject(java.io.ObjectOutputStream) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            }
        ],
        "CardTerminal": [
            {
                "name": "javax.smartcardio.CardTerminal",
                "parameters": [],
                "signature": "protected javax.smartcardio.CardTerminal();",
                "return_type": "void"
            },
            {
                "name": "getName",
                "parameters": [],
                "signature": "public abstract java.lang.String getName();",
                "return_type": "void"
            },
            {
                "name": "connect",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract javax.smartcardio.Card connect(java.lang.String) throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "isCardPresent",
                "parameters": [],
                "signature": "public abstract boolean isCardPresent() throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "waitForCardPresent",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract boolean waitForCardPresent(long) throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "waitForCardAbsent",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract boolean waitForCardAbsent(long) throws javax.smartcardio.CardException;",
                "return_type": "void"
            }
        ],
        "CardTerminals": [
            {
                "name": "javax.smartcardio.CardTerminals",
                "parameters": [],
                "signature": "protected javax.smartcardio.CardTerminals();",
                "return_type": "void"
            },
            {
                "name": "list",
                "parameters": [],
                "signature": "public java.util.List<javax.smartcardio.CardTerminal> list() throws javax.smartcardio.CardException;",
                "return_type": "java.util.List<javax.smartcardio.CardTerminal>"
            },
            {
                "name": "list",
                "parameters": [
                    "javax.smartcardio.CardTerminals$State"
                ],
                "signature": "public abstract java.util.List<javax.smartcardio.CardTerminal> list(javax.smartcardio.CardTerminals$State) throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "getTerminal",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.smartcardio.CardTerminal getTerminal(java.lang.String);",
                "return_type": "javax.smartcardio.CardTerminal"
            },
            {
                "name": "waitForChange",
                "parameters": [],
                "signature": "public void waitForChange() throws javax.smartcardio.CardException;",
                "return_type": "void"
            },
            {
                "name": "waitForChange",
                "parameters": [
                    "long"
                ],
                "signature": "public abstract boolean waitForChange(long) throws javax.smartcardio.CardException;",
                "return_type": "void"
            }
        ],
        "CommandAPDU": [
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(byte[]);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(byte[], int, int);",
                "return_type": "void"
            },
            {
                "name": "checkArrayBounds",
                "parameters": [
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "private void checkArrayBounds(byte[], int, int);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "java.nio.ByteBuffer"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(java.nio.ByteBuffer);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(int, int, int, int);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(int, int, int, int, int);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "byte[]"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(int, int, int, int, byte[]);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "byte[]",
                    "int",
                    "int"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(int, int, int, int, byte[], int, int);",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "byte[]",
                    "int"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(int, int, int, int, byte[], int);",
                "return_type": "void"
            },
            {
                "name": "arrayLength",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private static int arrayLength(byte[]);",
                "return_type": "void"
            },
            {
                "name": "parse",
                "parameters": [],
                "signature": "private void parse();",
                "return_type": "void"
            },
            {
                "name": "javax.smartcardio.CommandAPDU",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int",
                    "byte[]",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "public javax.smartcardio.CommandAPDU(int, int, int, int, byte[], int, int, int);",
                "return_type": "void"
            },
            {
                "name": "setHeader",
                "parameters": [
                    "int",
                    "int",
                    "int",
                    "int"
                ],
                "signature": "private void setHeader(int, int, int, int);",
                "return_type": "void"
            },
            {
                "name": "getCLA",
                "parameters": [],
                "signature": "public int getCLA();",
                "return_type": "int"
            },
            {
                "name": "getINS",
                "parameters": [],
                "signature": "public int getINS();",
                "return_type": "int"
            },
            {
                "name": "getP1",
                "parameters": [],
                "signature": "public int getP1();",
                "return_type": "int"
            },
            {
                "name": "getP2",
                "parameters": [],
                "signature": "public int getP2();",
                "return_type": "int"
            },
            {
                "name": "getNc",
                "parameters": [],
                "signature": "public int getNc();",
                "return_type": "int"
            },
            {
                "name": "getData",
                "parameters": [],
                "signature": "public byte[] getData();",
                "return_type": "byte[]"
            },
            {
                "name": "getNe",
                "parameters": [],
                "signature": "public int getNe();",
                "return_type": "int"
            },
            {
                "name": "getBytes",
                "parameters": [],
                "signature": "public byte[] getBytes();",
                "return_type": "byte[]"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            }
        ],
        "ResponseAPDU": [
            {
                "name": "javax.smartcardio.ResponseAPDU",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public javax.smartcardio.ResponseAPDU(byte[]);",
                "return_type": "void"
            },
            {
                "name": "check",
                "parameters": [
                    "byte[]"
                ],
                "signature": "private static void check(byte[]);",
                "return_type": "void"
            },
            {
                "name": "getNr",
                "parameters": [],
                "signature": "public int getNr();",
                "return_type": "int"
            },
            {
                "name": "getData",
                "parameters": [],
                "signature": "public byte[] getData();",
                "return_type": "byte[]"
            },
            {
                "name": "getSW1",
                "parameters": [],
                "signature": "public int getSW1();",
                "return_type": "int"
            },
            {
                "name": "getSW2",
                "parameters": [],
                "signature": "public int getSW2();",
                "return_type": "int"
            },
            {
                "name": "getSW",
                "parameters": [],
                "signature": "public int getSW();",
                "return_type": "int"
            },
            {
                "name": "getBytes",
                "parameters": [],
                "signature": "public byte[] getBytes();",
                "return_type": "byte[]"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public boolean equals(java.lang.Object);",
                "return_type": "boolean"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public int hashCode();",
                "return_type": "int"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            }
        ],
        "TerminalFactory": [
            {
                "name": "javax.smartcardio.TerminalFactory",
                "parameters": [
                    "javax.smartcardio.TerminalFactorySpi",
                    "java.security.Provider",
                    "java.lang.String"
                ],
                "signature": "private javax.smartcardio.TerminalFactory(javax.smartcardio.TerminalFactorySpi, java.security.Provider, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "getDefaultType",
                "parameters": [],
                "signature": "public static java.lang.String getDefaultType();",
                "return_type": "java.lang.String"
            },
            {
                "name": "getDefault",
                "parameters": [],
                "signature": "public static javax.smartcardio.TerminalFactory getDefault();",
                "return_type": "javax.smartcardio.TerminalFactory"
            },
            {
                "name": "getInstance",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object"
                ],
                "signature": "public static javax.smartcardio.TerminalFactory getInstance(java.lang.String, java.lang.Object) throws java.security.NoSuchAlgorithmException;",
                "return_type": "javax.smartcardio.TerminalFactory"
            },
            {
                "name": "getInstance",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "java.lang.String"
                ],
                "signature": "public static javax.smartcardio.TerminalFactory getInstance(java.lang.String, java.lang.Object, java.lang.String) throws java.security.NoSuchAlgorithmException, java.security.NoSuchProviderException;",
                "return_type": "javax.smartcardio.TerminalFactory"
            },
            {
                "name": "getInstance",
                "parameters": [
                    "java.lang.String",
                    "java.lang.Object",
                    "java.security.Provider"
                ],
                "signature": "public static javax.smartcardio.TerminalFactory getInstance(java.lang.String, java.lang.Object, java.security.Provider) throws java.security.NoSuchAlgorithmException;",
                "return_type": "javax.smartcardio.TerminalFactory"
            },
            {
                "name": "getProvider",
                "parameters": [],
                "signature": "public java.security.Provider getProvider();",
                "return_type": "java.security.Provider"
            },
            {
                "name": "getType",
                "parameters": [],
                "signature": "public java.lang.String getType();",
                "return_type": "java.lang.String"
            },
            {
                "name": "terminals",
                "parameters": [],
                "signature": "public javax.smartcardio.CardTerminals terminals();",
                "return_type": "javax.smartcardio.CardTerminals"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            }
        ],
        "TerminalFactorySpi": [
            {
                "name": "javax.smartcardio.TerminalFactorySpi",
                "parameters": [],
                "signature": "protected javax.smartcardio.TerminalFactorySpi();",
                "return_type": "void"
            },
            {
                "name": "engineTerminals",
                "parameters": [],
                "signature": "protected abstract javax.smartcardio.CardTerminals engineTerminals();",
                "return_type": "void"
            }
        ]
    },
    "javax.annotation.processing": {
        "AbstractProcessor": [
            {
                "name": "javax.annotation.processing.AbstractProcessor",
                "parameters": [],
                "signature": "protected javax.annotation.processing.AbstractProcessor();",
                "return_type": "void"
            },
            {
                "name": "getSupportedOptions",
                "parameters": [],
                "signature": "public java.util.Set<java.lang.String> getSupportedOptions();",
                "return_type": "java.util.Set<java.lang.String>"
            },
            {
                "name": "getSupportedAnnotationTypes",
                "parameters": [],
                "signature": "public java.util.Set<java.lang.String> getSupportedAnnotationTypes();",
                "return_type": "java.util.Set<java.lang.String>"
            },
            {
                "name": "getSupportedSourceVersion",
                "parameters": [],
                "signature": "public javax.lang.model.SourceVersion getSupportedSourceVersion();",
                "return_type": "javax.lang.model.SourceVersion"
            },
            {
                "name": "init",
                "parameters": [
                    "javax.annotation.processing.ProcessingEnvironment"
                ],
                "signature": "public synchronized void init(javax.annotation.processing.ProcessingEnvironment);",
                "return_type": "void"
            },
            {
                "name": "process",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.TypeElement>",
                    "javax.annotation.processing.RoundEnvironment"
                ],
                "signature": "public abstract boolean process(java.util.Set<? extends javax.lang.model.element.TypeElement>, javax.annotation.processing.RoundEnvironment);",
                "return_type": "void"
            },
            {
                "name": "getCompletions",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "javax.lang.model.element.AnnotationMirror",
                    "javax.lang.model.element.ExecutableElement",
                    "java.lang.String"
                ],
                "signature": "public java.lang.Iterable<? extends javax.annotation.processing.Completion> getCompletions(javax.lang.model.element.Element, javax.lang.model.element.AnnotationMirror, javax.lang.model.element.ExecutableElement, java.lang.String);",
                "return_type": "void"
            },
            {
                "name": "isInitialized",
                "parameters": [],
                "signature": "protected synchronized boolean isInitialized();",
                "return_type": "void"
            },
            {
                "name": "arrayToSet",
                "parameters": [
                    "java.lang.String[]",
                    "boolean",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "private java.util.Set<java.lang.String> arrayToSet(java.lang.String[], boolean, java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ],
        "Completion": [
            {
                "name": "getValue",
                "parameters": [],
                "signature": "public abstract java.lang.String getValue();",
                "return_type": "void"
            },
            {
                "name": "getMessage",
                "parameters": [],
                "signature": "public abstract java.lang.String getMessage();",
                "return_type": "void"
            }
        ],
        "Completions": [
            {
                "name": "javax.annotation.processing.Completions",
                "parameters": [],
                "signature": "private javax.annotation.processing.Completions();",
                "return_type": "void"
            },
            {
                "name": "of",
                "parameters": [
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public static javax.annotation.processing.Completion of(java.lang.String, java.lang.String);",
                "return_type": "javax.annotation.processing.Completion"
            },
            {
                "name": "of",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.annotation.processing.Completion of(java.lang.String);",
                "return_type": "javax.annotation.processing.Completion"
            }
        ],
        "Filer": [
            {
                "name": "createSourceFile",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element..."
                ],
                "signature": "public abstract javax.tools.JavaFileObject createSourceFile(java.lang.CharSequence, javax.lang.model.element.Element...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "createClassFile",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element..."
                ],
                "signature": "public abstract javax.tools.JavaFileObject createClassFile(java.lang.CharSequence, javax.lang.model.element.Element...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "createResource",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.CharSequence",
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element..."
                ],
                "signature": "public abstract javax.tools.FileObject createResource(javax.tools.JavaFileManager$Location, java.lang.CharSequence, java.lang.CharSequence, javax.lang.model.element.Element...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getResource",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.CharSequence",
                    "java.lang.CharSequence"
                ],
                "signature": "public abstract javax.tools.FileObject getResource(javax.tools.JavaFileManager$Location, java.lang.CharSequence, java.lang.CharSequence) throws java.io.IOException;",
                "return_type": "void"
            }
        ],
        "FilerException": [
            {
                "name": "javax.annotation.processing.FilerException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public javax.annotation.processing.FilerException(java.lang.String);",
                "return_type": "void"
            }
        ],
        "Generated": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract java.lang.String[] value();",
                "return_type": "void"
            },
            {
                "name": "date",
                "parameters": [],
                "signature": "public abstract java.lang.String date();",
                "return_type": "void"
            },
            {
                "name": "comments",
                "parameters": [],
                "signature": "public abstract java.lang.String comments();",
                "return_type": "void"
            }
        ],
        "Messager": [
            {
                "name": "printMessage",
                "parameters": [
                    "javax.tools.Diagnostic$Kind",
                    "java.lang.CharSequence"
                ],
                "signature": "public abstract void printMessage(javax.tools.Diagnostic$Kind, java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "printMessage",
                "parameters": [
                    "javax.tools.Diagnostic$Kind",
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract void printMessage(javax.tools.Diagnostic$Kind, java.lang.CharSequence, javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "printMessage",
                "parameters": [
                    "javax.tools.Diagnostic$Kind",
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element",
                    "javax.lang.model.element.AnnotationMirror"
                ],
                "signature": "public abstract void printMessage(javax.tools.Diagnostic$Kind, java.lang.CharSequence, javax.lang.model.element.Element, javax.lang.model.element.AnnotationMirror);",
                "return_type": "void"
            },
            {
                "name": "printMessage",
                "parameters": [
                    "javax.tools.Diagnostic$Kind",
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element",
                    "javax.lang.model.element.AnnotationMirror",
                    "javax.lang.model.element.AnnotationValue"
                ],
                "signature": "public abstract void printMessage(javax.tools.Diagnostic$Kind, java.lang.CharSequence, javax.lang.model.element.Element, javax.lang.model.element.AnnotationMirror, javax.lang.model.element.AnnotationValue);",
                "return_type": "void"
            },
            {
                "name": "printError",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public default void printError(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "printError",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default void printError(java.lang.CharSequence, javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "printWarning",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public default void printWarning(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "printWarning",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default void printWarning(java.lang.CharSequence, javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "printNote",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public default void printNote(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "printNote",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default void printNote(java.lang.CharSequence, javax.lang.model.element.Element);",
                "return_type": "void"
            }
        ],
        "ProcessingEnvironment": [
            {
                "name": "getOptions",
                "parameters": [],
                "signature": "public abstract java.util.Map<java.lang.String, java.lang.String> getOptions();",
                "return_type": "void"
            },
            {
                "name": "getMessager",
                "parameters": [],
                "signature": "public abstract javax.annotation.processing.Messager getMessager();",
                "return_type": "void"
            },
            {
                "name": "getFiler",
                "parameters": [],
                "signature": "public abstract javax.annotation.processing.Filer getFiler();",
                "return_type": "void"
            },
            {
                "name": "getElementUtils",
                "parameters": [],
                "signature": "public abstract javax.lang.model.util.Elements getElementUtils();",
                "return_type": "void"
            },
            {
                "name": "getTypeUtils",
                "parameters": [],
                "signature": "public abstract javax.lang.model.util.Types getTypeUtils();",
                "return_type": "void"
            },
            {
                "name": "getSourceVersion",
                "parameters": [],
                "signature": "public abstract javax.lang.model.SourceVersion getSourceVersion();",
                "return_type": "void"
            },
            {
                "name": "getLocale",
                "parameters": [],
                "signature": "public abstract java.util.Locale getLocale();",
                "return_type": "void"
            },
            {
                "name": "isPreviewEnabled",
                "parameters": [],
                "signature": "public default boolean isPreviewEnabled();",
                "return_type": "void"
            }
        ],
        "Processor": [
            {
                "name": "getSupportedOptions",
                "parameters": [],
                "signature": "public abstract java.util.Set<java.lang.String> getSupportedOptions();",
                "return_type": "void"
            },
            {
                "name": "getSupportedAnnotationTypes",
                "parameters": [],
                "signature": "public abstract java.util.Set<java.lang.String> getSupportedAnnotationTypes();",
                "return_type": "void"
            },
            {
                "name": "getSupportedSourceVersion",
                "parameters": [],
                "signature": "public abstract javax.lang.model.SourceVersion getSupportedSourceVersion();",
                "return_type": "void"
            },
            {
                "name": "init",
                "parameters": [
                    "javax.annotation.processing.ProcessingEnvironment"
                ],
                "signature": "public abstract void init(javax.annotation.processing.ProcessingEnvironment);",
                "return_type": "void"
            },
            {
                "name": "process",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.TypeElement>",
                    "javax.annotation.processing.RoundEnvironment"
                ],
                "signature": "public abstract boolean process(java.util.Set<? extends javax.lang.model.element.TypeElement>, javax.annotation.processing.RoundEnvironment);",
                "return_type": "void"
            },
            {
                "name": "getCompletions",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "javax.lang.model.element.AnnotationMirror",
                    "javax.lang.model.element.ExecutableElement",
                    "java.lang.String"
                ],
                "signature": "public abstract java.lang.Iterable<? extends javax.annotation.processing.Completion> getCompletions(javax.lang.model.element.Element, javax.lang.model.element.AnnotationMirror, javax.lang.model.element.ExecutableElement, java.lang.String);",
                "return_type": "void"
            }
        ],
        "RoundEnvironment": [
            {
                "name": "processingOver",
                "parameters": [],
                "signature": "public abstract boolean processingOver();",
                "return_type": "void"
            },
            {
                "name": "errorRaised",
                "parameters": [],
                "signature": "public abstract boolean errorRaised();",
                "return_type": "void"
            },
            {
                "name": "getRootElements",
                "parameters": [],
                "signature": "public abstract java.util.Set<? extends javax.lang.model.element.Element> getRootElements();",
                "return_type": "void"
            },
            {
                "name": "getElementsAnnotatedWith",
                "parameters": [
                    "javax.lang.model.element.TypeElement"
                ],
                "signature": "public abstract java.util.Set<? extends javax.lang.model.element.Element> getElementsAnnotatedWith(javax.lang.model.element.TypeElement);",
                "return_type": "void"
            },
            {
                "name": "getElementsAnnotatedWithAny",
                "parameters": [
                    "javax.lang.model.element.TypeElement..."
                ],
                "signature": "public default java.util.Set<? extends javax.lang.model.element.Element> getElementsAnnotatedWithAny(javax.lang.model.element.TypeElement...);",
                "return_type": "void"
            },
            {
                "name": "getElementsAnnotatedWith",
                "parameters": [
                    "java.lang.Class<? extends java.lang.annotation.Annotation>"
                ],
                "signature": "public abstract java.util.Set<? extends javax.lang.model.element.Element> getElementsAnnotatedWith(java.lang.Class<? extends java.lang.annotation.Annotation>);",
                "return_type": "void"
            },
            {
                "name": "getElementsAnnotatedWithAny",
                "parameters": [
                    "java.util.Set<java.lang.Class<? extends java.lang.annotation.Annotation>>"
                ],
                "signature": "public default java.util.Set<? extends javax.lang.model.element.Element> getElementsAnnotatedWithAny(java.util.Set<java.lang.Class<? extends java.lang.annotation.Annotation>>);",
                "return_type": "void"
            }
        ],
        "SupportedAnnotationTypes": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract java.lang.String[] value();",
                "return_type": "void"
            }
        ],
        "SupportedOptions": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract java.lang.String[] value();",
                "return_type": "void"
            }
        ],
        "SupportedSourceVersion": [
            {
                "name": "value",
                "parameters": [],
                "signature": "public abstract javax.lang.model.SourceVersion value();",
                "return_type": "void"
            }
        ]
    },
    "javax.lang.model": {
        "AnnotatedConstruct": [
            {
                "name": "getAnnotationMirrors",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.AnnotationMirror> getAnnotationMirrors();",
                "return_type": "void"
            },
            {
                "name": "getAnnotation",
                "parameters": [
                    "java.lang.Class<A>"
                ],
                "signature": "public abstract <A extends java.lang.annotation.Annotation> A getAnnotation(java.lang.Class<A>);",
                "return_type": "void"
            },
            {
                "name": "getAnnotationsByType",
                "parameters": [
                    "java.lang.Class<A>"
                ],
                "signature": "public abstract <A extends java.lang.annotation.Annotation> A[] getAnnotationsByType(java.lang.Class<A>);",
                "return_type": "void"
            }
        ],
        "SourceVersion": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static javax.lang.model.SourceVersion[] values();",
                "return_type": "javax.lang.model.SourceVersion[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.lang.model.SourceVersion valueOf(java.lang.String);",
                "return_type": "javax.lang.model.SourceVersion"
            },
            {
                "name": "javax.lang.model.SourceVersion",
                "parameters": [],
                "signature": "private javax.lang.model.SourceVersion();",
                "return_type": "void"
            },
            {
                "name": "latest",
                "parameters": [],
                "signature": "public static javax.lang.model.SourceVersion latest();",
                "return_type": "javax.lang.model.SourceVersion"
            },
            {
                "name": "getLatestSupported",
                "parameters": [],
                "signature": "private static javax.lang.model.SourceVersion getLatestSupported();",
                "return_type": "void"
            },
            {
                "name": "latestSupported",
                "parameters": [],
                "signature": "public static javax.lang.model.SourceVersion latestSupported();",
                "return_type": "javax.lang.model.SourceVersion"
            },
            {
                "name": "isIdentifier",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public static boolean isIdentifier(java.lang.CharSequence);",
                "return_type": "boolean"
            },
            {
                "name": "isName",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public static boolean isName(java.lang.CharSequence);",
                "return_type": "boolean"
            },
            {
                "name": "isName",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.SourceVersion"
                ],
                "signature": "public static boolean isName(java.lang.CharSequence, javax.lang.model.SourceVersion);",
                "return_type": "boolean"
            },
            {
                "name": "isKeyword",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public static boolean isKeyword(java.lang.CharSequence);",
                "return_type": "boolean"
            },
            {
                "name": "isKeyword",
                "parameters": [
                    "java.lang.CharSequence",
                    "javax.lang.model.SourceVersion"
                ],
                "signature": "public static boolean isKeyword(java.lang.CharSequence, javax.lang.model.SourceVersion);",
                "return_type": "boolean"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.Runtime$Version"
                ],
                "signature": "public static javax.lang.model.SourceVersion valueOf(java.lang.Runtime$Version);",
                "return_type": "javax.lang.model.SourceVersion"
            },
            {
                "name": "runtimeVersion",
                "parameters": [],
                "signature": "public java.lang.Runtime$Version runtimeVersion();",
                "return_type": "java.lang.Runtime$Version"
            }
        ],
        "UnknownEntityException": [
            {
                "name": "javax.lang.model.UnknownEntityException",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "protected javax.lang.model.UnknownEntityException(java.lang.String);",
                "return_type": "void"
            }
        ]
    },
    "javax.lang.model.element": {
        "AnnotationMirror": [
            {
                "name": "getAnnotationType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.DeclaredType getAnnotationType();",
                "return_type": "void"
            },
            {
                "name": "getElementValues",
                "parameters": [],
                "signature": "public abstract java.util.Map<? extends javax.lang.model.element.ExecutableElement, ? extends javax.lang.model.element.AnnotationValue> getElementValues();",
                "return_type": "void"
            }
        ],
        "AnnotationValue": [
            {
                "name": "getValue",
                "parameters": [],
                "signature": "public abstract java.lang.Object getValue();",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            },
            {
                "name": "accept",
                "parameters": [
                    "javax.lang.model.element.AnnotationValueVisitor<R",
                    "P>",
                    "P"
                ],
                "signature": "public abstract <R, P> R accept(javax.lang.model.element.AnnotationValueVisitor<R, P>, P);",
                "return_type": "void"
            }
        ],
        "AnnotationValueVisitor": [
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue",
                    "P"
                ],
                "signature": "public abstract R visit(javax.lang.model.element.AnnotationValue, P);",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue"
                ],
                "signature": "public default R visit(javax.lang.model.element.AnnotationValue);",
                "return_type": "void"
            },
            {
                "name": "visitBoolean",
                "parameters": [
                    "boolean",
                    "P"
                ],
                "signature": "public abstract R visitBoolean(boolean, P);",
                "return_type": "void"
            },
            {
                "name": "visitByte",
                "parameters": [
                    "byte",
                    "P"
                ],
                "signature": "public abstract R visitByte(byte, P);",
                "return_type": "void"
            },
            {
                "name": "visitChar",
                "parameters": [
                    "char",
                    "P"
                ],
                "signature": "public abstract R visitChar(char, P);",
                "return_type": "void"
            },
            {
                "name": "visitDouble",
                "parameters": [
                    "double",
                    "P"
                ],
                "signature": "public abstract R visitDouble(double, P);",
                "return_type": "void"
            },
            {
                "name": "visitFloat",
                "parameters": [
                    "float",
                    "P"
                ],
                "signature": "public abstract R visitFloat(float, P);",
                "return_type": "void"
            },
            {
                "name": "visitInt",
                "parameters": [
                    "int",
                    "P"
                ],
                "signature": "public abstract R visitInt(int, P);",
                "return_type": "void"
            },
            {
                "name": "visitLong",
                "parameters": [
                    "long",
                    "P"
                ],
                "signature": "public abstract R visitLong(long, P);",
                "return_type": "void"
            },
            {
                "name": "visitShort",
                "parameters": [
                    "short",
                    "P"
                ],
                "signature": "public abstract R visitShort(short, P);",
                "return_type": "void"
            },
            {
                "name": "visitString",
                "parameters": [
                    "java.lang.String",
                    "P"
                ],
                "signature": "public abstract R visitString(java.lang.String, P);",
                "return_type": "void"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "public abstract R visitType(javax.lang.model.type.TypeMirror, P);",
                "return_type": "void"
            },
            {
                "name": "visitEnumConstant",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public abstract R visitEnumConstant(javax.lang.model.element.VariableElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitAnnotation",
                "parameters": [
                    "javax.lang.model.element.AnnotationMirror",
                    "P"
                ],
                "signature": "public abstract R visitAnnotation(javax.lang.model.element.AnnotationMirror, P);",
                "return_type": "void"
            },
            {
                "name": "visitArray",
                "parameters": [
                    "java.util.List<? extends javax.lang.model.element.AnnotationValue>",
                    "P"
                ],
                "signature": "public abstract R visitArray(java.util.List<? extends javax.lang.model.element.AnnotationValue>, P);",
                "return_type": "void"
            },
            {
                "name": "visitUnknown",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue",
                    "P"
                ],
                "signature": "public abstract R visitUnknown(javax.lang.model.element.AnnotationValue, P);",
                "return_type": "void"
            }
        ],
        "Element": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getKind",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.ElementKind getKind();",
                "return_type": "void"
            },
            {
                "name": "getModifiers",
                "parameters": [],
                "signature": "public abstract java.util.Set<javax.lang.model.element.Modifier> getModifiers();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            },
            {
                "name": "getEnclosedElements",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.Element> getEnclosedElements();",
                "return_type": "void"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract boolean equals(java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public abstract int hashCode();",
                "return_type": "void"
            },
            {
                "name": "getAnnotationMirrors",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.AnnotationMirror> getAnnotationMirrors();",
                "return_type": "void"
            },
            {
                "name": "getAnnotation",
                "parameters": [
                    "java.lang.Class<A>"
                ],
                "signature": "public abstract <A extends java.lang.annotation.Annotation> A getAnnotation(java.lang.Class<A>);",
                "return_type": "void"
            },
            {
                "name": "getAnnotationsByType",
                "parameters": [
                    "java.lang.Class<A>"
                ],
                "signature": "public abstract <A extends java.lang.annotation.Annotation> A[] getAnnotationsByType(java.lang.Class<A>);",
                "return_type": "void"
            },
            {
                "name": "accept",
                "parameters": [
                    "javax.lang.model.element.ElementVisitor<R",
                    "P>",
                    "P"
                ],
                "signature": "public abstract <R, P> R accept(javax.lang.model.element.ElementVisitor<R, P>, P);",
                "return_type": "void"
            }
        ],
        "ElementKind": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static javax.lang.model.element.ElementKind[] values();",
                "return_type": "javax.lang.model.element.ElementKind[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.lang.model.element.ElementKind valueOf(java.lang.String);",
                "return_type": "javax.lang.model.element.ElementKind"
            },
            {
                "name": "javax.lang.model.element.ElementKind",
                "parameters": [],
                "signature": "private javax.lang.model.element.ElementKind();",
                "return_type": "void"
            },
            {
                "name": "isClass",
                "parameters": [],
                "signature": "public boolean isClass();",
                "return_type": "boolean"
            },
            {
                "name": "isInterface",
                "parameters": [],
                "signature": "public boolean isInterface();",
                "return_type": "boolean"
            },
            {
                "name": "isDeclaredType",
                "parameters": [],
                "signature": "public boolean isDeclaredType();",
                "return_type": "boolean"
            },
            {
                "name": "isField",
                "parameters": [],
                "signature": "public boolean isField();",
                "return_type": "boolean"
            },
            {
                "name": "isExecutable",
                "parameters": [],
                "signature": "public boolean isExecutable();",
                "return_type": "boolean"
            },
            {
                "name": "isInitializer",
                "parameters": [],
                "signature": "public boolean isInitializer();",
                "return_type": "boolean"
            },
            {
                "name": "isVariable",
                "parameters": [],
                "signature": "public boolean isVariable();",
                "return_type": "boolean"
            }
        ],
        "ElementVisitor": [
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "P"
                ],
                "signature": "public abstract R visit(javax.lang.model.element.Element, P);",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default R visit(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "visitPackage",
                "parameters": [
                    "javax.lang.model.element.PackageElement",
                    "P"
                ],
                "signature": "public abstract R visitPackage(javax.lang.model.element.PackageElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public abstract R visitType(javax.lang.model.element.TypeElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public abstract R visitVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public abstract R visitExecutable(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitTypeParameter",
                "parameters": [
                    "javax.lang.model.element.TypeParameterElement",
                    "P"
                ],
                "signature": "public abstract R visitTypeParameter(javax.lang.model.element.TypeParameterElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitUnknown",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "P"
                ],
                "signature": "public abstract R visitUnknown(javax.lang.model.element.Element, P);",
                "return_type": "void"
            },
            {
                "name": "visitModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "P"
                ],
                "signature": "public default R visitModule(javax.lang.model.element.ModuleElement, P);",
                "return_type": "void"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public default R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "void"
            }
        ],
        "ExecutableElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getTypeParameters",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.TypeParameterElement> getTypeParameters();",
                "return_type": "void"
            },
            {
                "name": "getReturnType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getReturnType();",
                "return_type": "void"
            },
            {
                "name": "getParameters",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.VariableElement> getParameters();",
                "return_type": "void"
            },
            {
                "name": "getReceiverType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getReceiverType();",
                "return_type": "void"
            },
            {
                "name": "isVarArgs",
                "parameters": [],
                "signature": "public abstract boolean isVarArgs();",
                "return_type": "void"
            },
            {
                "name": "isDefault",
                "parameters": [],
                "signature": "public abstract boolean isDefault();",
                "return_type": "void"
            },
            {
                "name": "getThrownTypes",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getThrownTypes();",
                "return_type": "void"
            },
            {
                "name": "getDefaultValue",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.AnnotationValue getDefaultValue();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            }
        ],
        "Modifier": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static javax.lang.model.element.Modifier[] values();",
                "return_type": "javax.lang.model.element.Modifier[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.lang.model.element.Modifier valueOf(java.lang.String);",
                "return_type": "javax.lang.model.element.Modifier"
            },
            {
                "name": "javax.lang.model.element.Modifier",
                "parameters": [],
                "signature": "private javax.lang.model.element.Modifier();",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            }
        ],
        "ModuleElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getQualifiedName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getQualifiedName();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            },
            {
                "name": "getEnclosedElements",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.Element> getEnclosedElements();",
                "return_type": "void"
            },
            {
                "name": "isOpen",
                "parameters": [],
                "signature": "public abstract boolean isOpen();",
                "return_type": "void"
            },
            {
                "name": "isUnnamed",
                "parameters": [],
                "signature": "public abstract boolean isUnnamed();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            },
            {
                "name": "getDirectives",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.ModuleElement$Directive> getDirectives();",
                "return_type": "void"
            }
        ],
        "Name": [
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract boolean equals(java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public abstract int hashCode();",
                "return_type": "void"
            },
            {
                "name": "contentEquals",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public abstract boolean contentEquals(java.lang.CharSequence);",
                "return_type": "void"
            }
        ],
        "NestingKind": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static javax.lang.model.element.NestingKind[] values();",
                "return_type": "javax.lang.model.element.NestingKind[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.lang.model.element.NestingKind valueOf(java.lang.String);",
                "return_type": "javax.lang.model.element.NestingKind"
            },
            {
                "name": "javax.lang.model.element.NestingKind",
                "parameters": [],
                "signature": "private javax.lang.model.element.NestingKind();",
                "return_type": "void"
            },
            {
                "name": "isNested",
                "parameters": [],
                "signature": "public boolean isNested();",
                "return_type": "boolean"
            }
        ],
        "PackageElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getQualifiedName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getQualifiedName();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            },
            {
                "name": "getEnclosedElements",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.Element> getEnclosedElements();",
                "return_type": "void"
            },
            {
                "name": "isUnnamed",
                "parameters": [],
                "signature": "public abstract boolean isUnnamed();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            }
        ],
        "Parameterizable": [
            {
                "name": "getTypeParameters",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.TypeParameterElement> getTypeParameters();",
                "return_type": "void"
            }
        ],
        "QualifiedNameable": [
            {
                "name": "getQualifiedName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getQualifiedName();",
                "return_type": "void"
            }
        ],
        "RecordComponentElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            },
            {
                "name": "getAccessor",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.ExecutableElement getAccessor();",
                "return_type": "void"
            }
        ],
        "TypeElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getEnclosedElements",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.Element> getEnclosedElements();",
                "return_type": "void"
            },
            {
                "name": "getNestingKind",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.NestingKind getNestingKind();",
                "return_type": "void"
            },
            {
                "name": "getQualifiedName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getQualifiedName();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            },
            {
                "name": "getSuperclass",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getSuperclass();",
                "return_type": "void"
            },
            {
                "name": "getInterfaces",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getInterfaces();",
                "return_type": "void"
            },
            {
                "name": "getTypeParameters",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.TypeParameterElement> getTypeParameters();",
                "return_type": "void"
            },
            {
                "name": "getRecordComponents",
                "parameters": [],
                "signature": "public default java.util.List<? extends javax.lang.model.element.RecordComponentElement> getRecordComponents();",
                "return_type": "void"
            },
            {
                "name": "getPermittedSubclasses",
                "parameters": [],
                "signature": "public default java.util.List<? extends javax.lang.model.type.TypeMirror> getPermittedSubclasses();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            }
        ],
        "TypeParameterElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getGenericElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getGenericElement();",
                "return_type": "void"
            },
            {
                "name": "getBounds",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getBounds();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            }
        ],
        "UnknownAnnotationValueException": [
            {
                "name": "javax.lang.model.element.UnknownAnnotationValueException",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue",
                    "java.lang.Object"
                ],
                "signature": "public javax.lang.model.element.UnknownAnnotationValueException(javax.lang.model.element.AnnotationValue, java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "getUnknownAnnotationValue",
                "parameters": [],
                "signature": "public javax.lang.model.element.AnnotationValue getUnknownAnnotationValue();",
                "return_type": "javax.lang.model.element.AnnotationValue"
            },
            {
                "name": "getArgument",
                "parameters": [],
                "signature": "public java.lang.Object getArgument();",
                "return_type": "java.lang.Object"
            }
        ],
        "UnknownDirectiveException": [
            {
                "name": "javax.lang.model.element.UnknownDirectiveException",
                "parameters": [
                    "javax.lang.model.element.ModuleElement$Directive",
                    "java.lang.Object"
                ],
                "signature": "public javax.lang.model.element.UnknownDirectiveException(javax.lang.model.element.ModuleElement$Directive, java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "getUnknownDirective",
                "parameters": [],
                "signature": "public javax.lang.model.element.ModuleElement$Directive getUnknownDirective();",
                "return_type": "javax.lang.model.element.ModuleElement$Directive"
            },
            {
                "name": "getArgument",
                "parameters": [],
                "signature": "public java.lang.Object getArgument();",
                "return_type": "java.lang.Object"
            }
        ],
        "UnknownElementException": [
            {
                "name": "javax.lang.model.element.UnknownElementException",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "java.lang.Object"
                ],
                "signature": "public javax.lang.model.element.UnknownElementException(javax.lang.model.element.Element, java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "getUnknownElement",
                "parameters": [],
                "signature": "public javax.lang.model.element.Element getUnknownElement();",
                "return_type": "javax.lang.model.element.Element"
            },
            {
                "name": "getArgument",
                "parameters": [],
                "signature": "public java.lang.Object getArgument();",
                "return_type": "java.lang.Object"
            }
        ],
        "VariableElement": [
            {
                "name": "asType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror asType();",
                "return_type": "void"
            },
            {
                "name": "getConstantValue",
                "parameters": [],
                "signature": "public abstract java.lang.Object getConstantValue();",
                "return_type": "void"
            },
            {
                "name": "getSimpleName",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Name getSimpleName();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element getEnclosingElement();",
                "return_type": "void"
            },
            {
                "name": "isUnnamed",
                "parameters": [],
                "signature": "public default boolean isUnnamed();",
                "return_type": "void"
            }
        ]
    },
    "javax.lang.model.type": {
        "ArrayType": [
            {
                "name": "getComponentType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getComponentType();",
                "return_type": "void"
            }
        ],
        "DeclaredType": [
            {
                "name": "asElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element asElement();",
                "return_type": "void"
            },
            {
                "name": "getEnclosingType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getEnclosingType();",
                "return_type": "void"
            },
            {
                "name": "getTypeArguments",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getTypeArguments();",
                "return_type": "void"
            }
        ],
        "ErrorType": [],
        "ExecutableType": [
            {
                "name": "getTypeVariables",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeVariable> getTypeVariables();",
                "return_type": "void"
            },
            {
                "name": "getReturnType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getReturnType();",
                "return_type": "void"
            },
            {
                "name": "getParameterTypes",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getParameterTypes();",
                "return_type": "void"
            },
            {
                "name": "getReceiverType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getReceiverType();",
                "return_type": "void"
            },
            {
                "name": "getThrownTypes",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getThrownTypes();",
                "return_type": "void"
            }
        ],
        "IntersectionType": [
            {
                "name": "getBounds",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getBounds();",
                "return_type": "void"
            }
        ],
        "MirroredTypeException": [
            {
                "name": "javax.lang.model.type.MirroredTypeException",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public javax.lang.model.type.MirroredTypeException(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "getTypeMirror",
                "parameters": [],
                "signature": "public javax.lang.model.type.TypeMirror getTypeMirror();",
                "return_type": "javax.lang.model.type.TypeMirror"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            }
        ],
        "MirroredTypesException": [
            {
                "name": "javax.lang.model.type.MirroredTypesException",
                "parameters": [
                    "java.util.List<? extends javax.lang.model.type.TypeMirror>"
                ],
                "signature": "public javax.lang.model.type.MirroredTypesException(java.util.List<? extends javax.lang.model.type.TypeMirror>);",
                "return_type": "void"
            },
            {
                "name": "getTypeMirrors",
                "parameters": [],
                "signature": "public java.util.List<? extends javax.lang.model.type.TypeMirror> getTypeMirrors();",
                "return_type": "void"
            },
            {
                "name": "readObject",
                "parameters": [
                    "java.io.ObjectInputStream"
                ],
                "signature": "private void readObject(java.io.ObjectInputStream) throws java.io.IOException, java.lang.ClassNotFoundException;",
                "return_type": "void"
            }
        ],
        "NoType": [],
        "NullType": [],
        "PrimitiveType": [],
        "ReferenceType": [],
        "TypeKind": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static javax.lang.model.type.TypeKind[] values();",
                "return_type": "javax.lang.model.type.TypeKind[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.lang.model.type.TypeKind valueOf(java.lang.String);",
                "return_type": "javax.lang.model.type.TypeKind"
            },
            {
                "name": "javax.lang.model.type.TypeKind",
                "parameters": [],
                "signature": "private javax.lang.model.type.TypeKind();",
                "return_type": "void"
            },
            {
                "name": "isPrimitive",
                "parameters": [],
                "signature": "public boolean isPrimitive();",
                "return_type": "boolean"
            }
        ],
        "TypeMirror": [
            {
                "name": "getKind",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeKind getKind();",
                "return_type": "void"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract boolean equals(java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public abstract int hashCode();",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public abstract java.lang.String toString();",
                "return_type": "void"
            },
            {
                "name": "getAnnotationMirrors",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.AnnotationMirror> getAnnotationMirrors();",
                "return_type": "void"
            },
            {
                "name": "getAnnotation",
                "parameters": [
                    "java.lang.Class<A>"
                ],
                "signature": "public abstract <A extends java.lang.annotation.Annotation> A getAnnotation(java.lang.Class<A>);",
                "return_type": "void"
            },
            {
                "name": "getAnnotationsByType",
                "parameters": [
                    "java.lang.Class<A>"
                ],
                "signature": "public abstract <A extends java.lang.annotation.Annotation> A[] getAnnotationsByType(java.lang.Class<A>);",
                "return_type": "void"
            },
            {
                "name": "accept",
                "parameters": [
                    "javax.lang.model.type.TypeVisitor<R",
                    "P>",
                    "P"
                ],
                "signature": "public abstract <R, P> R accept(javax.lang.model.type.TypeVisitor<R, P>, P);",
                "return_type": "void"
            }
        ],
        "TypeVariable": [
            {
                "name": "asElement",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Element asElement();",
                "return_type": "void"
            },
            {
                "name": "getUpperBound",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getUpperBound();",
                "return_type": "void"
            },
            {
                "name": "getLowerBound",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getLowerBound();",
                "return_type": "void"
            }
        ],
        "TypeVisitor": [
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "public abstract R visit(javax.lang.model.type.TypeMirror, P);",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public default R visit(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "visitPrimitive",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public abstract R visitPrimitive(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "void"
            },
            {
                "name": "visitNull",
                "parameters": [
                    "javax.lang.model.type.NullType",
                    "P"
                ],
                "signature": "public abstract R visitNull(javax.lang.model.type.NullType, P);",
                "return_type": "void"
            },
            {
                "name": "visitArray",
                "parameters": [
                    "javax.lang.model.type.ArrayType",
                    "P"
                ],
                "signature": "public abstract R visitArray(javax.lang.model.type.ArrayType, P);",
                "return_type": "void"
            },
            {
                "name": "visitDeclared",
                "parameters": [
                    "javax.lang.model.type.DeclaredType",
                    "P"
                ],
                "signature": "public abstract R visitDeclared(javax.lang.model.type.DeclaredType, P);",
                "return_type": "void"
            },
            {
                "name": "visitError",
                "parameters": [
                    "javax.lang.model.type.ErrorType",
                    "P"
                ],
                "signature": "public abstract R visitError(javax.lang.model.type.ErrorType, P);",
                "return_type": "void"
            },
            {
                "name": "visitTypeVariable",
                "parameters": [
                    "javax.lang.model.type.TypeVariable",
                    "P"
                ],
                "signature": "public abstract R visitTypeVariable(javax.lang.model.type.TypeVariable, P);",
                "return_type": "void"
            },
            {
                "name": "visitWildcard",
                "parameters": [
                    "javax.lang.model.type.WildcardType",
                    "P"
                ],
                "signature": "public abstract R visitWildcard(javax.lang.model.type.WildcardType, P);",
                "return_type": "void"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.type.ExecutableType",
                    "P"
                ],
                "signature": "public abstract R visitExecutable(javax.lang.model.type.ExecutableType, P);",
                "return_type": "void"
            },
            {
                "name": "visitNoType",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public abstract R visitNoType(javax.lang.model.type.NoType, P);",
                "return_type": "void"
            },
            {
                "name": "visitUnknown",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "public abstract R visitUnknown(javax.lang.model.type.TypeMirror, P);",
                "return_type": "void"
            },
            {
                "name": "visitUnion",
                "parameters": [
                    "javax.lang.model.type.UnionType",
                    "P"
                ],
                "signature": "public abstract R visitUnion(javax.lang.model.type.UnionType, P);",
                "return_type": "void"
            },
            {
                "name": "visitIntersection",
                "parameters": [
                    "javax.lang.model.type.IntersectionType",
                    "P"
                ],
                "signature": "public abstract R visitIntersection(javax.lang.model.type.IntersectionType, P);",
                "return_type": "void"
            }
        ],
        "UnionType": [
            {
                "name": "getAlternatives",
                "parameters": [],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> getAlternatives();",
                "return_type": "void"
            }
        ],
        "UnknownTypeException": [
            {
                "name": "javax.lang.model.type.UnknownTypeException",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "java.lang.Object"
                ],
                "signature": "public javax.lang.model.type.UnknownTypeException(javax.lang.model.type.TypeMirror, java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "getUnknownType",
                "parameters": [],
                "signature": "public javax.lang.model.type.TypeMirror getUnknownType();",
                "return_type": "javax.lang.model.type.TypeMirror"
            },
            {
                "name": "getArgument",
                "parameters": [],
                "signature": "public java.lang.Object getArgument();",
                "return_type": "java.lang.Object"
            }
        ],
        "WildcardType": [
            {
                "name": "getExtendsBound",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getExtendsBound();",
                "return_type": "void"
            },
            {
                "name": "getSuperBound",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.TypeMirror getSuperBound();",
                "return_type": "void"
            }
        ]
    },
    "javax.lang.model.util": {
        "AbstractAnnotationValueVisitor14": [
            {
                "name": "javax.lang.model.util.AbstractAnnotationValueVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractAnnotationValueVisitor14();",
                "return_type": "void"
            }
        ],
        "AbstractAnnotationValueVisitor6": [
            {
                "name": "javax.lang.model.util.AbstractAnnotationValueVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractAnnotationValueVisitor6();",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue",
                    "P"
                ],
                "signature": "public final R visit(javax.lang.model.element.AnnotationValue, P);",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue"
                ],
                "signature": "public final R visit(javax.lang.model.element.AnnotationValue);",
                "return_type": "void"
            },
            {
                "name": "visitUnknown",
                "parameters": [
                    "javax.lang.model.element.AnnotationValue",
                    "P"
                ],
                "signature": "public R visitUnknown(javax.lang.model.element.AnnotationValue, P);",
                "return_type": "R"
            }
        ],
        "AbstractAnnotationValueVisitor7": [
            {
                "name": "javax.lang.model.util.AbstractAnnotationValueVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractAnnotationValueVisitor7();",
                "return_type": "void"
            }
        ],
        "AbstractAnnotationValueVisitor8": [
            {
                "name": "javax.lang.model.util.AbstractAnnotationValueVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractAnnotationValueVisitor8();",
                "return_type": "void"
            }
        ],
        "AbstractAnnotationValueVisitor9": [
            {
                "name": "javax.lang.model.util.AbstractAnnotationValueVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractAnnotationValueVisitor9();",
                "return_type": "void"
            }
        ],
        "AbstractAnnotationValueVisitorPreview": [
            {
                "name": "javax.lang.model.util.AbstractAnnotationValueVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractAnnotationValueVisitorPreview();",
                "return_type": "void"
            }
        ],
        "AbstractElementVisitor14": [
            {
                "name": "javax.lang.model.util.AbstractElementVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractElementVisitor14();",
                "return_type": "void"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public abstract R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "void"
            }
        ],
        "AbstractElementVisitor6": [
            {
                "name": "javax.lang.model.util.AbstractElementVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractElementVisitor6();",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "P"
                ],
                "signature": "public final R visit(javax.lang.model.element.Element, P);",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public final R visit(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "visitUnknown",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "P"
                ],
                "signature": "public R visitUnknown(javax.lang.model.element.Element, P);",
                "return_type": "R"
            },
            {
                "name": "visitModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "P"
                ],
                "signature": "public R visitModule(javax.lang.model.element.ModuleElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "R"
            }
        ],
        "AbstractElementVisitor7": [
            {
                "name": "javax.lang.model.util.AbstractElementVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractElementVisitor7();",
                "return_type": "void"
            }
        ],
        "AbstractElementVisitor8": [
            {
                "name": "javax.lang.model.util.AbstractElementVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractElementVisitor8();",
                "return_type": "void"
            }
        ],
        "AbstractElementVisitor9": [
            {
                "name": "javax.lang.model.util.AbstractElementVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractElementVisitor9();",
                "return_type": "void"
            },
            {
                "name": "visitModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "P"
                ],
                "signature": "public abstract R visitModule(javax.lang.model.element.ModuleElement, P);",
                "return_type": "void"
            }
        ],
        "AbstractElementVisitorPreview": [
            {
                "name": "javax.lang.model.util.AbstractElementVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractElementVisitorPreview();",
                "return_type": "void"
            }
        ],
        "AbstractTypeVisitor14": [
            {
                "name": "javax.lang.model.util.AbstractTypeVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractTypeVisitor14();",
                "return_type": "void"
            }
        ],
        "AbstractTypeVisitor6": [
            {
                "name": "javax.lang.model.util.AbstractTypeVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractTypeVisitor6();",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "public final R visit(javax.lang.model.type.TypeMirror, P);",
                "return_type": "void"
            },
            {
                "name": "visit",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public final R visit(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "visitUnion",
                "parameters": [
                    "javax.lang.model.type.UnionType",
                    "P"
                ],
                "signature": "public R visitUnion(javax.lang.model.type.UnionType, P);",
                "return_type": "R"
            },
            {
                "name": "visitIntersection",
                "parameters": [
                    "javax.lang.model.type.IntersectionType",
                    "P"
                ],
                "signature": "public R visitIntersection(javax.lang.model.type.IntersectionType, P);",
                "return_type": "R"
            },
            {
                "name": "visitUnknown",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "public R visitUnknown(javax.lang.model.type.TypeMirror, P);",
                "return_type": "R"
            }
        ],
        "AbstractTypeVisitor7": [
            {
                "name": "javax.lang.model.util.AbstractTypeVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractTypeVisitor7();",
                "return_type": "void"
            },
            {
                "name": "visitUnion",
                "parameters": [
                    "javax.lang.model.type.UnionType",
                    "P"
                ],
                "signature": "public abstract R visitUnion(javax.lang.model.type.UnionType, P);",
                "return_type": "void"
            }
        ],
        "AbstractTypeVisitor8": [
            {
                "name": "javax.lang.model.util.AbstractTypeVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractTypeVisitor8();",
                "return_type": "void"
            },
            {
                "name": "visitIntersection",
                "parameters": [
                    "javax.lang.model.type.IntersectionType",
                    "P"
                ],
                "signature": "public abstract R visitIntersection(javax.lang.model.type.IntersectionType, P);",
                "return_type": "void"
            }
        ],
        "AbstractTypeVisitor9": [
            {
                "name": "javax.lang.model.util.AbstractTypeVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractTypeVisitor9();",
                "return_type": "void"
            }
        ],
        "AbstractTypeVisitorPreview": [
            {
                "name": "javax.lang.model.util.AbstractTypeVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.AbstractTypeVisitorPreview();",
                "return_type": "void"
            }
        ],
        "ElementFilter": [
            {
                "name": "javax.lang.model.util.ElementFilter",
                "parameters": [],
                "signature": "private javax.lang.model.util.ElementFilter();",
                "return_type": "void"
            },
            {
                "name": "fieldsIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.VariableElement> fieldsIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.VariableElement>"
            },
            {
                "name": "fieldsIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.VariableElement> fieldsIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.VariableElement>"
            },
            {
                "name": "recordComponentsIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.RecordComponentElement> recordComponentsIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.RecordComponentElement>"
            },
            {
                "name": "recordComponentsIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.RecordComponentElement> recordComponentsIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.RecordComponentElement>"
            },
            {
                "name": "constructorsIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ExecutableElement> constructorsIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.ExecutableElement>"
            },
            {
                "name": "constructorsIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.ExecutableElement> constructorsIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.ExecutableElement>"
            },
            {
                "name": "methodsIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ExecutableElement> methodsIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.ExecutableElement>"
            },
            {
                "name": "methodsIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.ExecutableElement> methodsIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.ExecutableElement>"
            },
            {
                "name": "typesIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.TypeElement> typesIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.TypeElement>"
            },
            {
                "name": "typesIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.TypeElement> typesIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.TypeElement>"
            },
            {
                "name": "packagesIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.PackageElement> packagesIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.PackageElement>"
            },
            {
                "name": "packagesIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.PackageElement> packagesIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.PackageElement>"
            },
            {
                "name": "modulesIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ModuleElement> modulesIn(java.lang.Iterable<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.List<javax.lang.model.element.ModuleElement>"
            },
            {
                "name": "modulesIn",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>"
                ],
                "signature": "public static java.util.Set<javax.lang.model.element.ModuleElement> modulesIn(java.util.Set<? extends javax.lang.model.element.Element>);",
                "return_type": "java.util.Set<javax.lang.model.element.ModuleElement>"
            },
            {
                "name": "listFilter",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>",
                    "java.util.Set<javax.lang.model.element.ElementKind>",
                    "java.lang.Class<E>"
                ],
                "signature": "private static <E extends javax.lang.model.element.Element> java.util.List<E> listFilter(java.lang.Iterable<? extends javax.lang.model.element.Element>, java.util.Set<javax.lang.model.element.ElementKind>, java.lang.Class<E>);",
                "return_type": "void"
            },
            {
                "name": "setFilter",
                "parameters": [
                    "java.util.Set<? extends javax.lang.model.element.Element>",
                    "java.util.Set<javax.lang.model.element.ElementKind>",
                    "java.lang.Class<E>"
                ],
                "signature": "private static <E extends javax.lang.model.element.Element> java.util.Set<E> setFilter(java.util.Set<? extends javax.lang.model.element.Element>, java.util.Set<javax.lang.model.element.ElementKind>, java.lang.Class<E>);",
                "return_type": "void"
            },
            {
                "name": "exportsIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ModuleElement$ExportsDirective> exportsIn(java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>);",
                "return_type": "java.util.List<javax.lang.model.element.ModuleElement$ExportsDirective>"
            },
            {
                "name": "opensIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ModuleElement$OpensDirective> opensIn(java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>);",
                "return_type": "java.util.List<javax.lang.model.element.ModuleElement$OpensDirective>"
            },
            {
                "name": "providesIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ModuleElement$ProvidesDirective> providesIn(java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>);",
                "return_type": "java.util.List<javax.lang.model.element.ModuleElement$ProvidesDirective>"
            },
            {
                "name": "requiresIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ModuleElement$RequiresDirective> requiresIn(java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>);",
                "return_type": "java.util.List<javax.lang.model.element.ModuleElement$RequiresDirective>"
            },
            {
                "name": "usesIn",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>"
                ],
                "signature": "public static java.util.List<javax.lang.model.element.ModuleElement$UsesDirective> usesIn(java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>);",
                "return_type": "java.util.List<javax.lang.model.element.ModuleElement$UsesDirective>"
            },
            {
                "name": "listFilter",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>",
                    "javax.lang.model.element.ModuleElement$DirectiveKind",
                    "java.lang.Class<D>"
                ],
                "signature": "private static <D extends javax.lang.model.element.ModuleElement$Directive> java.util.List<D> listFilter(java.lang.Iterable<? extends javax.lang.model.element.ModuleElement$Directive>, javax.lang.model.element.ModuleElement$DirectiveKind, java.lang.Class<D>);",
                "return_type": "void"
            }
        ],
        "ElementKindVisitor14": [
            {
                "name": "javax.lang.model.util.ElementKindVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementKindVisitor14();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementKindVisitor14",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementKindVisitor14(R);",
                "return_type": "void"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeAsRecord",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitTypeAsRecord(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsBindingVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsBindingVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            }
        ],
        "ElementKindVisitor6": [
            {
                "name": "javax.lang.model.util.ElementKindVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementKindVisitor6();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementKindVisitor6",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementKindVisitor6(R);",
                "return_type": "void"
            },
            {
                "name": "visitPackage",
                "parameters": [
                    "javax.lang.model.element.PackageElement",
                    "P"
                ],
                "signature": "public R visitPackage(javax.lang.model.element.PackageElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitType(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeAsAnnotationType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitTypeAsAnnotationType(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeAsClass",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitTypeAsClass(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeAsEnum",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitTypeAsEnum(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeAsInterface",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitTypeAsInterface(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeAsRecord",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitTypeAsRecord(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsEnumConstant",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsEnumConstant(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsExceptionParameter",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsExceptionParameter(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsField",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsField(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsLocalVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsLocalVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsParameter",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsParameter(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsResourceVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsResourceVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariableAsBindingVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsBindingVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutable(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutableAsConstructor",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutableAsConstructor(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutableAsInstanceInit",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutableAsInstanceInit(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutableAsMethod",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutableAsMethod(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutableAsStaticInit",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutableAsStaticInit(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeParameter",
                "parameters": [
                    "javax.lang.model.element.TypeParameterElement",
                    "P"
                ],
                "signature": "public R visitTypeParameter(javax.lang.model.element.TypeParameterElement, P);",
                "return_type": "R"
            }
        ],
        "ElementKindVisitor7": [
            {
                "name": "javax.lang.model.util.ElementKindVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementKindVisitor7();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementKindVisitor7",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementKindVisitor7(R);",
                "return_type": "void"
            },
            {
                "name": "visitVariableAsResourceVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariableAsResourceVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            }
        ],
        "ElementKindVisitor8": [
            {
                "name": "javax.lang.model.util.ElementKindVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementKindVisitor8();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementKindVisitor8",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementKindVisitor8(R);",
                "return_type": "void"
            }
        ],
        "ElementKindVisitor9": [
            {
                "name": "javax.lang.model.util.ElementKindVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementKindVisitor9();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementKindVisitor9",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementKindVisitor9(R);",
                "return_type": "void"
            },
            {
                "name": "visitModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "P"
                ],
                "signature": "public R visitModule(javax.lang.model.element.ModuleElement, P);",
                "return_type": "R"
            }
        ],
        "ElementKindVisitorPreview": [
            {
                "name": "javax.lang.model.util.ElementKindVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementKindVisitorPreview();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementKindVisitorPreview",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementKindVisitorPreview(R);",
                "return_type": "void"
            }
        ],
        "ElementScanner14": [
            {
                "name": "javax.lang.model.util.ElementScanner14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementScanner14();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementScanner14",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementScanner14(R);",
                "return_type": "void"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitType(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutable(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "createScanningList",
                "parameters": [
                    "javax.lang.model.element.Parameterizable",
                    "java.util.List<? extends javax.lang.model.element.Element>"
                ],
                "signature": "private java.util.List<? extends javax.lang.model.element.Element> createScanningList(javax.lang.model.element.Parameterizable, java.util.List<? extends javax.lang.model.element.Element>);",
                "return_type": "void"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "R"
            }
        ],
        "ElementScanner6": [
            {
                "name": "javax.lang.model.util.ElementScanner6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementScanner6();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementScanner6",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementScanner6(R);",
                "return_type": "void"
            },
            {
                "name": "scan",
                "parameters": [
                    "java.lang.Iterable<? extends javax.lang.model.element.Element>",
                    "P"
                ],
                "signature": "public final R scan(java.lang.Iterable<? extends javax.lang.model.element.Element>, P);",
                "return_type": "void"
            },
            {
                "name": "scan",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "P"
                ],
                "signature": "public R scan(javax.lang.model.element.Element, P);",
                "return_type": "R"
            },
            {
                "name": "scan",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public final R scan(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "visitPackage",
                "parameters": [
                    "javax.lang.model.element.PackageElement",
                    "P"
                ],
                "signature": "public R visitPackage(javax.lang.model.element.PackageElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitType(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutable(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeParameter",
                "parameters": [
                    "javax.lang.model.element.TypeParameterElement",
                    "P"
                ],
                "signature": "public R visitTypeParameter(javax.lang.model.element.TypeParameterElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "R"
            }
        ],
        "ElementScanner7": [
            {
                "name": "javax.lang.model.util.ElementScanner7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementScanner7();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementScanner7",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementScanner7(R);",
                "return_type": "void"
            },
            {
                "name": "visitVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            }
        ],
        "ElementScanner8": [
            {
                "name": "javax.lang.model.util.ElementScanner8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementScanner8();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementScanner8",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementScanner8(R);",
                "return_type": "void"
            }
        ],
        "ElementScanner9": [
            {
                "name": "javax.lang.model.util.ElementScanner9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementScanner9();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementScanner9",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementScanner9(R);",
                "return_type": "void"
            },
            {
                "name": "visitModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "P"
                ],
                "signature": "public R visitModule(javax.lang.model.element.ModuleElement, P);",
                "return_type": "R"
            }
        ],
        "ElementScannerPreview": [
            {
                "name": "javax.lang.model.util.ElementScannerPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.ElementScannerPreview();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.ElementScannerPreview",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.ElementScannerPreview(R);",
                "return_type": "void"
            }
        ],
        "Elements": [
            {
                "name": "getPackageElement",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public abstract javax.lang.model.element.PackageElement getPackageElement(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getPackageElement",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "java.lang.CharSequence"
                ],
                "signature": "public default javax.lang.model.element.PackageElement getPackageElement(javax.lang.model.element.ModuleElement, java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getAllPackageElements",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public default java.util.Set<? extends javax.lang.model.element.PackageElement> getAllPackageElements(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getTypeElement",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public abstract javax.lang.model.element.TypeElement getTypeElement(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getTypeElement",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "java.lang.CharSequence"
                ],
                "signature": "public default javax.lang.model.element.TypeElement getTypeElement(javax.lang.model.element.ModuleElement, java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getAllTypeElements",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public default java.util.Set<? extends javax.lang.model.element.TypeElement> getAllTypeElements(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getModuleElement",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public default javax.lang.model.element.ModuleElement getModuleElement(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "getAllModuleElements",
                "parameters": [],
                "signature": "public default java.util.Set<? extends javax.lang.model.element.ModuleElement> getAllModuleElements();",
                "return_type": "void"
            },
            {
                "name": "getElementValuesWithDefaults",
                "parameters": [
                    "javax.lang.model.element.AnnotationMirror"
                ],
                "signature": "public abstract java.util.Map<? extends javax.lang.model.element.ExecutableElement, ? extends javax.lang.model.element.AnnotationValue> getElementValuesWithDefaults(javax.lang.model.element.AnnotationMirror);",
                "return_type": "void"
            },
            {
                "name": "getDocComment",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract java.lang.String getDocComment(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "getDocCommentKind",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default javax.lang.model.util.Elements$DocCommentKind getDocCommentKind(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "isDeprecated",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract boolean isDeprecated(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "getOrigin",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default javax.lang.model.util.Elements$Origin getOrigin(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "getOrigin",
                "parameters": [
                    "javax.lang.model.AnnotatedConstruct",
                    "javax.lang.model.element.AnnotationMirror"
                ],
                "signature": "public default javax.lang.model.util.Elements$Origin getOrigin(javax.lang.model.AnnotatedConstruct, javax.lang.model.element.AnnotationMirror);",
                "return_type": "void"
            },
            {
                "name": "getOrigin",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "javax.lang.model.element.ModuleElement$Directive"
                ],
                "signature": "public default javax.lang.model.util.Elements$Origin getOrigin(javax.lang.model.element.ModuleElement, javax.lang.model.element.ModuleElement$Directive);",
                "return_type": "void"
            },
            {
                "name": "isBridge",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement"
                ],
                "signature": "public default boolean isBridge(javax.lang.model.element.ExecutableElement);",
                "return_type": "void"
            },
            {
                "name": "getBinaryName",
                "parameters": [
                    "javax.lang.model.element.TypeElement"
                ],
                "signature": "public abstract javax.lang.model.element.Name getBinaryName(javax.lang.model.element.TypeElement);",
                "return_type": "void"
            },
            {
                "name": "getPackageOf",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract javax.lang.model.element.PackageElement getPackageOf(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "getModuleOf",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default javax.lang.model.element.ModuleElement getModuleOf(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "getAllMembers",
                "parameters": [
                    "javax.lang.model.element.TypeElement"
                ],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.Element> getAllMembers(javax.lang.model.element.TypeElement);",
                "return_type": "void"
            },
            {
                "name": "getOutermostTypeElement",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default javax.lang.model.element.TypeElement getOutermostTypeElement(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "getAllAnnotationMirrors",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract java.util.List<? extends javax.lang.model.element.AnnotationMirror> getAllAnnotationMirrors(javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "hides",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract boolean hides(javax.lang.model.element.Element, javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "overrides",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "javax.lang.model.element.ExecutableElement",
                    "javax.lang.model.element.TypeElement"
                ],
                "signature": "public abstract boolean overrides(javax.lang.model.element.ExecutableElement, javax.lang.model.element.ExecutableElement, javax.lang.model.element.TypeElement);",
                "return_type": "void"
            },
            {
                "name": "getConstantExpression",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public abstract java.lang.String getConstantExpression(java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "printElements",
                "parameters": [
                    "java.io.Writer",
                    "javax.lang.model.element.Element..."
                ],
                "signature": "public abstract void printElements(java.io.Writer, javax.lang.model.element.Element...);",
                "return_type": "void"
            },
            {
                "name": "getName",
                "parameters": [
                    "java.lang.CharSequence"
                ],
                "signature": "public abstract javax.lang.model.element.Name getName(java.lang.CharSequence);",
                "return_type": "void"
            },
            {
                "name": "isFunctionalInterface",
                "parameters": [
                    "javax.lang.model.element.TypeElement"
                ],
                "signature": "public abstract boolean isFunctionalInterface(javax.lang.model.element.TypeElement);",
                "return_type": "void"
            },
            {
                "name": "isAutomaticModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement"
                ],
                "signature": "public default boolean isAutomaticModule(javax.lang.model.element.ModuleElement);",
                "return_type": "void"
            },
            {
                "name": "getEnumConstantBody",
                "parameters": [
                    "javax.lang.model.element.VariableElement"
                ],
                "signature": "public default javax.lang.model.element.TypeElement getEnumConstantBody(javax.lang.model.element.VariableElement);",
                "return_type": "void"
            },
            {
                "name": "recordComponentFor",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement"
                ],
                "signature": "public default javax.lang.model.element.RecordComponentElement recordComponentFor(javax.lang.model.element.ExecutableElement);",
                "return_type": "void"
            },
            {
                "name": "isCanonicalConstructor",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement"
                ],
                "signature": "public default boolean isCanonicalConstructor(javax.lang.model.element.ExecutableElement);",
                "return_type": "void"
            },
            {
                "name": "isCompactConstructor",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement"
                ],
                "signature": "public default boolean isCompactConstructor(javax.lang.model.element.ExecutableElement);",
                "return_type": "void"
            },
            {
                "name": "getFileObjectOf",
                "parameters": [
                    "javax.lang.model.element.Element"
                ],
                "signature": "public default javax.tools.JavaFileObject getFileObjectOf(javax.lang.model.element.Element);",
                "return_type": "void"
            }
        ],
        "SimpleAnnotationValueVisitor14": [
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor14();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor14",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor14(R);",
                "return_type": "void"
            }
        ],
        "SimpleAnnotationValueVisitor6": [
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor6();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor6",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor6(R);",
                "return_type": "void"
            },
            {
                "name": "defaultAction",
                "parameters": [
                    "java.lang.Object",
                    "P"
                ],
                "signature": "protected R defaultAction(java.lang.Object, P);",
                "return_type": "void"
            },
            {
                "name": "visitBoolean",
                "parameters": [
                    "boolean",
                    "P"
                ],
                "signature": "public R visitBoolean(boolean, P);",
                "return_type": "R"
            },
            {
                "name": "visitByte",
                "parameters": [
                    "byte",
                    "P"
                ],
                "signature": "public R visitByte(byte, P);",
                "return_type": "R"
            },
            {
                "name": "visitChar",
                "parameters": [
                    "char",
                    "P"
                ],
                "signature": "public R visitChar(char, P);",
                "return_type": "R"
            },
            {
                "name": "visitDouble",
                "parameters": [
                    "double",
                    "P"
                ],
                "signature": "public R visitDouble(double, P);",
                "return_type": "R"
            },
            {
                "name": "visitFloat",
                "parameters": [
                    "float",
                    "P"
                ],
                "signature": "public R visitFloat(float, P);",
                "return_type": "R"
            },
            {
                "name": "visitInt",
                "parameters": [
                    "int",
                    "P"
                ],
                "signature": "public R visitInt(int, P);",
                "return_type": "R"
            },
            {
                "name": "visitLong",
                "parameters": [
                    "long",
                    "P"
                ],
                "signature": "public R visitLong(long, P);",
                "return_type": "R"
            },
            {
                "name": "visitShort",
                "parameters": [
                    "short",
                    "P"
                ],
                "signature": "public R visitShort(short, P);",
                "return_type": "R"
            },
            {
                "name": "visitString",
                "parameters": [
                    "java.lang.String",
                    "P"
                ],
                "signature": "public R visitString(java.lang.String, P);",
                "return_type": "R"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "public R visitType(javax.lang.model.type.TypeMirror, P);",
                "return_type": "R"
            },
            {
                "name": "visitEnumConstant",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitEnumConstant(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitAnnotation",
                "parameters": [
                    "javax.lang.model.element.AnnotationMirror",
                    "P"
                ],
                "signature": "public R visitAnnotation(javax.lang.model.element.AnnotationMirror, P);",
                "return_type": "R"
            },
            {
                "name": "visitArray",
                "parameters": [
                    "java.util.List<? extends javax.lang.model.element.AnnotationValue>",
                    "P"
                ],
                "signature": "public R visitArray(java.util.List<? extends javax.lang.model.element.AnnotationValue>, P);",
                "return_type": "R"
            }
        ],
        "SimpleAnnotationValueVisitor7": [
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor7();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor7",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor7(R);",
                "return_type": "void"
            }
        ],
        "SimpleAnnotationValueVisitor8": [
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor8();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor8",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor8(R);",
                "return_type": "void"
            }
        ],
        "SimpleAnnotationValueVisitor9": [
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor9();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitor9",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitor9(R);",
                "return_type": "void"
            }
        ],
        "SimpleAnnotationValueVisitorPreview": [
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitorPreview();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleAnnotationValueVisitorPreview",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleAnnotationValueVisitorPreview(R);",
                "return_type": "void"
            }
        ],
        "SimpleElementVisitor14": [
            {
                "name": "javax.lang.model.util.SimpleElementVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor14();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleElementVisitor14",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor14(R);",
                "return_type": "void"
            },
            {
                "name": "visitRecordComponent",
                "parameters": [
                    "javax.lang.model.element.RecordComponentElement",
                    "P"
                ],
                "signature": "public R visitRecordComponent(javax.lang.model.element.RecordComponentElement, P);",
                "return_type": "R"
            }
        ],
        "SimpleElementVisitor6": [
            {
                "name": "javax.lang.model.util.SimpleElementVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor6();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleElementVisitor6",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor6(R);",
                "return_type": "void"
            },
            {
                "name": "defaultAction",
                "parameters": [
                    "javax.lang.model.element.Element",
                    "P"
                ],
                "signature": "protected R defaultAction(javax.lang.model.element.Element, P);",
                "return_type": "void"
            },
            {
                "name": "visitPackage",
                "parameters": [
                    "javax.lang.model.element.PackageElement",
                    "P"
                ],
                "signature": "public R visitPackage(javax.lang.model.element.PackageElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "P"
                ],
                "signature": "public R visitType(javax.lang.model.element.TypeElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.element.ExecutableElement",
                    "P"
                ],
                "signature": "public R visitExecutable(javax.lang.model.element.ExecutableElement, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeParameter",
                "parameters": [
                    "javax.lang.model.element.TypeParameterElement",
                    "P"
                ],
                "signature": "public R visitTypeParameter(javax.lang.model.element.TypeParameterElement, P);",
                "return_type": "R"
            }
        ],
        "SimpleElementVisitor7": [
            {
                "name": "javax.lang.model.util.SimpleElementVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor7();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleElementVisitor7",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor7(R);",
                "return_type": "void"
            },
            {
                "name": "visitVariable",
                "parameters": [
                    "javax.lang.model.element.VariableElement",
                    "P"
                ],
                "signature": "public R visitVariable(javax.lang.model.element.VariableElement, P);",
                "return_type": "R"
            }
        ],
        "SimpleElementVisitor8": [
            {
                "name": "javax.lang.model.util.SimpleElementVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor8();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleElementVisitor8",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor8(R);",
                "return_type": "void"
            }
        ],
        "SimpleElementVisitor9": [
            {
                "name": "javax.lang.model.util.SimpleElementVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor9();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleElementVisitor9",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleElementVisitor9(R);",
                "return_type": "void"
            },
            {
                "name": "visitModule",
                "parameters": [
                    "javax.lang.model.element.ModuleElement",
                    "P"
                ],
                "signature": "public R visitModule(javax.lang.model.element.ModuleElement, P);",
                "return_type": "R"
            }
        ],
        "SimpleElementVisitorPreview": [
            {
                "name": "javax.lang.model.util.SimpleElementVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleElementVisitorPreview();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleElementVisitorPreview",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleElementVisitorPreview(R);",
                "return_type": "void"
            }
        ],
        "SimpleTypeVisitor14": [
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor14();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor14",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor14(R);",
                "return_type": "void"
            }
        ],
        "SimpleTypeVisitor6": [
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor6();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor6",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor6(R);",
                "return_type": "void"
            },
            {
                "name": "defaultAction",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "P"
                ],
                "signature": "protected R defaultAction(javax.lang.model.type.TypeMirror, P);",
                "return_type": "void"
            },
            {
                "name": "visitPrimitive",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitive(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNull",
                "parameters": [
                    "javax.lang.model.type.NullType",
                    "P"
                ],
                "signature": "public R visitNull(javax.lang.model.type.NullType, P);",
                "return_type": "R"
            },
            {
                "name": "visitArray",
                "parameters": [
                    "javax.lang.model.type.ArrayType",
                    "P"
                ],
                "signature": "public R visitArray(javax.lang.model.type.ArrayType, P);",
                "return_type": "R"
            },
            {
                "name": "visitDeclared",
                "parameters": [
                    "javax.lang.model.type.DeclaredType",
                    "P"
                ],
                "signature": "public R visitDeclared(javax.lang.model.type.DeclaredType, P);",
                "return_type": "R"
            },
            {
                "name": "visitError",
                "parameters": [
                    "javax.lang.model.type.ErrorType",
                    "P"
                ],
                "signature": "public R visitError(javax.lang.model.type.ErrorType, P);",
                "return_type": "R"
            },
            {
                "name": "visitTypeVariable",
                "parameters": [
                    "javax.lang.model.type.TypeVariable",
                    "P"
                ],
                "signature": "public R visitTypeVariable(javax.lang.model.type.TypeVariable, P);",
                "return_type": "R"
            },
            {
                "name": "visitWildcard",
                "parameters": [
                    "javax.lang.model.type.WildcardType",
                    "P"
                ],
                "signature": "public R visitWildcard(javax.lang.model.type.WildcardType, P);",
                "return_type": "R"
            },
            {
                "name": "visitExecutable",
                "parameters": [
                    "javax.lang.model.type.ExecutableType",
                    "P"
                ],
                "signature": "public R visitExecutable(javax.lang.model.type.ExecutableType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNoType",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoType(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            }
        ],
        "SimpleTypeVisitor7": [
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor7();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor7",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor7(R);",
                "return_type": "void"
            },
            {
                "name": "visitUnion",
                "parameters": [
                    "javax.lang.model.type.UnionType",
                    "P"
                ],
                "signature": "public R visitUnion(javax.lang.model.type.UnionType, P);",
                "return_type": "R"
            }
        ],
        "SimpleTypeVisitor8": [
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor8();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor8",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor8(R);",
                "return_type": "void"
            },
            {
                "name": "visitIntersection",
                "parameters": [
                    "javax.lang.model.type.IntersectionType",
                    "P"
                ],
                "signature": "public R visitIntersection(javax.lang.model.type.IntersectionType, P);",
                "return_type": "R"
            }
        ],
        "SimpleTypeVisitor9": [
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor9();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleTypeVisitor9",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitor9(R);",
                "return_type": "void"
            }
        ],
        "SimpleTypeVisitorPreview": [
            {
                "name": "javax.lang.model.util.SimpleTypeVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitorPreview();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.SimpleTypeVisitorPreview",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.SimpleTypeVisitorPreview(R);",
                "return_type": "void"
            }
        ],
        "TypeKindVisitor14": [
            {
                "name": "javax.lang.model.util.TypeKindVisitor14",
                "parameters": [],
                "signature": "protected javax.lang.model.util.TypeKindVisitor14();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.TypeKindVisitor14",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.TypeKindVisitor14(R);",
                "return_type": "void"
            }
        ],
        "TypeKindVisitor6": [
            {
                "name": "javax.lang.model.util.TypeKindVisitor6",
                "parameters": [],
                "signature": "protected javax.lang.model.util.TypeKindVisitor6();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.TypeKindVisitor6",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.TypeKindVisitor6(R);",
                "return_type": "void"
            },
            {
                "name": "visitPrimitive",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitive(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsBoolean",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsBoolean(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsByte",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsByte(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsShort",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsShort(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsInt",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsInt(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsLong",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsLong(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsChar",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsChar(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsFloat",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsFloat(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitPrimitiveAsDouble",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType",
                    "P"
                ],
                "signature": "public R visitPrimitiveAsDouble(javax.lang.model.type.PrimitiveType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNoType",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoType(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNoTypeAsVoid",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoTypeAsVoid(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNoTypeAsPackage",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoTypeAsPackage(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNoTypeAsModule",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoTypeAsModule(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            },
            {
                "name": "visitNoTypeAsNone",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoTypeAsNone(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            }
        ],
        "TypeKindVisitor7": [
            {
                "name": "javax.lang.model.util.TypeKindVisitor7",
                "parameters": [],
                "signature": "protected javax.lang.model.util.TypeKindVisitor7();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.TypeKindVisitor7",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.TypeKindVisitor7(R);",
                "return_type": "void"
            },
            {
                "name": "visitUnion",
                "parameters": [
                    "javax.lang.model.type.UnionType",
                    "P"
                ],
                "signature": "public R visitUnion(javax.lang.model.type.UnionType, P);",
                "return_type": "R"
            }
        ],
        "TypeKindVisitor8": [
            {
                "name": "javax.lang.model.util.TypeKindVisitor8",
                "parameters": [],
                "signature": "protected javax.lang.model.util.TypeKindVisitor8();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.TypeKindVisitor8",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.TypeKindVisitor8(R);",
                "return_type": "void"
            },
            {
                "name": "visitIntersection",
                "parameters": [
                    "javax.lang.model.type.IntersectionType",
                    "P"
                ],
                "signature": "public R visitIntersection(javax.lang.model.type.IntersectionType, P);",
                "return_type": "R"
            }
        ],
        "TypeKindVisitor9": [
            {
                "name": "javax.lang.model.util.TypeKindVisitor9",
                "parameters": [],
                "signature": "protected javax.lang.model.util.TypeKindVisitor9();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.TypeKindVisitor9",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.TypeKindVisitor9(R);",
                "return_type": "void"
            },
            {
                "name": "visitNoTypeAsModule",
                "parameters": [
                    "javax.lang.model.type.NoType",
                    "P"
                ],
                "signature": "public R visitNoTypeAsModule(javax.lang.model.type.NoType, P);",
                "return_type": "R"
            }
        ],
        "TypeKindVisitorPreview": [
            {
                "name": "javax.lang.model.util.TypeKindVisitorPreview",
                "parameters": [],
                "signature": "protected javax.lang.model.util.TypeKindVisitorPreview();",
                "return_type": "void"
            },
            {
                "name": "javax.lang.model.util.TypeKindVisitorPreview",
                "parameters": [
                    "R"
                ],
                "signature": "protected javax.lang.model.util.TypeKindVisitorPreview(R);",
                "return_type": "void"
            }
        ],
        "Types": [
            {
                "name": "asElement",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract javax.lang.model.element.Element asElement(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "isSameType",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract boolean isSameType(javax.lang.model.type.TypeMirror, javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "isSubtype",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract boolean isSubtype(javax.lang.model.type.TypeMirror, javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "isAssignable",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract boolean isAssignable(javax.lang.model.type.TypeMirror, javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "contains",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract boolean contains(javax.lang.model.type.TypeMirror, javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "isSubsignature",
                "parameters": [
                    "javax.lang.model.type.ExecutableType",
                    "javax.lang.model.type.ExecutableType"
                ],
                "signature": "public abstract boolean isSubsignature(javax.lang.model.type.ExecutableType, javax.lang.model.type.ExecutableType);",
                "return_type": "void"
            },
            {
                "name": "directSupertypes",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract java.util.List<? extends javax.lang.model.type.TypeMirror> directSupertypes(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "erasure",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract javax.lang.model.type.TypeMirror erasure(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "boxedClass",
                "parameters": [
                    "javax.lang.model.type.PrimitiveType"
                ],
                "signature": "public abstract javax.lang.model.element.TypeElement boxedClass(javax.lang.model.type.PrimitiveType);",
                "return_type": "void"
            },
            {
                "name": "unboxedType",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract javax.lang.model.type.PrimitiveType unboxedType(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "capture",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract javax.lang.model.type.TypeMirror capture(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "getPrimitiveType",
                "parameters": [
                    "javax.lang.model.type.TypeKind"
                ],
                "signature": "public abstract javax.lang.model.type.PrimitiveType getPrimitiveType(javax.lang.model.type.TypeKind);",
                "return_type": "void"
            },
            {
                "name": "getNullType",
                "parameters": [],
                "signature": "public abstract javax.lang.model.type.NullType getNullType();",
                "return_type": "void"
            },
            {
                "name": "getNoType",
                "parameters": [
                    "javax.lang.model.type.TypeKind"
                ],
                "signature": "public abstract javax.lang.model.type.NoType getNoType(javax.lang.model.type.TypeKind);",
                "return_type": "void"
            },
            {
                "name": "getArrayType",
                "parameters": [
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract javax.lang.model.type.ArrayType getArrayType(javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "getWildcardType",
                "parameters": [
                    "javax.lang.model.type.TypeMirror",
                    "javax.lang.model.type.TypeMirror"
                ],
                "signature": "public abstract javax.lang.model.type.WildcardType getWildcardType(javax.lang.model.type.TypeMirror, javax.lang.model.type.TypeMirror);",
                "return_type": "void"
            },
            {
                "name": "getDeclaredType",
                "parameters": [
                    "javax.lang.model.element.TypeElement",
                    "javax.lang.model.type.TypeMirror..."
                ],
                "signature": "public abstract javax.lang.model.type.DeclaredType getDeclaredType(javax.lang.model.element.TypeElement, javax.lang.model.type.TypeMirror...);",
                "return_type": "void"
            },
            {
                "name": "getDeclaredType",
                "parameters": [
                    "javax.lang.model.type.DeclaredType",
                    "javax.lang.model.element.TypeElement",
                    "javax.lang.model.type.TypeMirror..."
                ],
                "signature": "public abstract javax.lang.model.type.DeclaredType getDeclaredType(javax.lang.model.type.DeclaredType, javax.lang.model.element.TypeElement, javax.lang.model.type.TypeMirror...);",
                "return_type": "void"
            },
            {
                "name": "asMemberOf",
                "parameters": [
                    "javax.lang.model.type.DeclaredType",
                    "javax.lang.model.element.Element"
                ],
                "signature": "public abstract javax.lang.model.type.TypeMirror asMemberOf(javax.lang.model.type.DeclaredType, javax.lang.model.element.Element);",
                "return_type": "void"
            },
            {
                "name": "stripAnnotations",
                "parameters": [
                    "T"
                ],
                "signature": "public default <T extends javax.lang.model.type.TypeMirror> T stripAnnotations(T);",
                "return_type": "void"
            }
        ]
    },
    "javax.tools": {
        "Diagnostic": [
            {
                "name": "getKind",
                "parameters": [],
                "signature": "public abstract javax.tools.Diagnostic$Kind getKind();",
                "return_type": "void"
            },
            {
                "name": "getSource",
                "parameters": [],
                "signature": "public abstract S getSource();",
                "return_type": "void"
            },
            {
                "name": "getPosition",
                "parameters": [],
                "signature": "public abstract long getPosition();",
                "return_type": "void"
            },
            {
                "name": "getStartPosition",
                "parameters": [],
                "signature": "public abstract long getStartPosition();",
                "return_type": "void"
            },
            {
                "name": "getEndPosition",
                "parameters": [],
                "signature": "public abstract long getEndPosition();",
                "return_type": "void"
            },
            {
                "name": "getLineNumber",
                "parameters": [],
                "signature": "public abstract long getLineNumber();",
                "return_type": "void"
            },
            {
                "name": "getColumnNumber",
                "parameters": [],
                "signature": "public abstract long getColumnNumber();",
                "return_type": "void"
            },
            {
                "name": "getCode",
                "parameters": [],
                "signature": "public abstract java.lang.String getCode();",
                "return_type": "void"
            },
            {
                "name": "getMessage",
                "parameters": [
                    "java.util.Locale"
                ],
                "signature": "public abstract java.lang.String getMessage(java.util.Locale);",
                "return_type": "void"
            }
        ],
        "DiagnosticCollector": [
            {
                "name": "javax.tools.DiagnosticCollector",
                "parameters": [],
                "signature": "public javax.tools.DiagnosticCollector();",
                "return_type": "void"
            },
            {
                "name": "report",
                "parameters": [
                    "javax.tools.Diagnostic<? extends S>"
                ],
                "signature": "public void report(javax.tools.Diagnostic<? extends S>);",
                "return_type": "void"
            },
            {
                "name": "getDiagnostics",
                "parameters": [],
                "signature": "public java.util.List<javax.tools.Diagnostic<? extends S>> getDiagnostics();",
                "return_type": "void"
            }
        ],
        "DiagnosticListener": [
            {
                "name": "report",
                "parameters": [
                    "javax.tools.Diagnostic<? extends S>"
                ],
                "signature": "public abstract void report(javax.tools.Diagnostic<? extends S>);",
                "return_type": "void"
            }
        ],
        "DocumentationTool": [
            {
                "name": "getTask",
                "parameters": [
                    "java.io.Writer",
                    "javax.tools.JavaFileManager",
                    "javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>",
                    "java.lang.Class<?>",
                    "java.lang.Iterable<java.lang.String>",
                    "java.lang.Iterable<? extends javax.tools.JavaFileObject>"
                ],
                "signature": "public abstract javax.tools.DocumentationTool$DocumentationTask getTask(java.io.Writer, javax.tools.JavaFileManager, javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>, java.lang.Class<?>, java.lang.Iterable<java.lang.String>, java.lang.Iterable<? extends javax.tools.JavaFileObject>);",
                "return_type": "void"
            },
            {
                "name": "getStandardFileManager",
                "parameters": [
                    "javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>",
                    "java.util.Locale",
                    "java.nio.charset.Charset"
                ],
                "signature": "public abstract javax.tools.StandardJavaFileManager getStandardFileManager(javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>, java.util.Locale, java.nio.charset.Charset);",
                "return_type": "void"
            }
        ],
        "FileObject": [
            {
                "name": "toUri",
                "parameters": [],
                "signature": "public abstract java.net.URI toUri();",
                "return_type": "void"
            },
            {
                "name": "getName",
                "parameters": [],
                "signature": "public abstract java.lang.String getName();",
                "return_type": "void"
            },
            {
                "name": "openInputStream",
                "parameters": [],
                "signature": "public abstract java.io.InputStream openInputStream() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "openOutputStream",
                "parameters": [],
                "signature": "public abstract java.io.OutputStream openOutputStream() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "openReader",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract java.io.Reader openReader(boolean) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getCharContent",
                "parameters": [
                    "boolean"
                ],
                "signature": "public abstract java.lang.CharSequence getCharContent(boolean) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "openWriter",
                "parameters": [],
                "signature": "public abstract java.io.Writer openWriter() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getLastModified",
                "parameters": [],
                "signature": "public abstract long getLastModified();",
                "return_type": "void"
            },
            {
                "name": "delete",
                "parameters": [],
                "signature": "public abstract boolean delete();",
                "return_type": "void"
            }
        ],
        "ForwardingFileObject": [
            {
                "name": "javax.tools.ForwardingFileObject",
                "parameters": [
                    "F"
                ],
                "signature": "protected javax.tools.ForwardingFileObject(F);",
                "return_type": "void"
            },
            {
                "name": "toUri",
                "parameters": [],
                "signature": "public java.net.URI toUri();",
                "return_type": "java.net.URI"
            },
            {
                "name": "getName",
                "parameters": [],
                "signature": "public java.lang.String getName();",
                "return_type": "java.lang.String"
            },
            {
                "name": "openInputStream",
                "parameters": [],
                "signature": "public java.io.InputStream openInputStream() throws java.io.IOException;",
                "return_type": "java.io.InputStream"
            },
            {
                "name": "openOutputStream",
                "parameters": [],
                "signature": "public java.io.OutputStream openOutputStream() throws java.io.IOException;",
                "return_type": "java.io.OutputStream"
            },
            {
                "name": "openReader",
                "parameters": [
                    "boolean"
                ],
                "signature": "public java.io.Reader openReader(boolean) throws java.io.IOException;",
                "return_type": "java.io.Reader"
            },
            {
                "name": "getCharContent",
                "parameters": [
                    "boolean"
                ],
                "signature": "public java.lang.CharSequence getCharContent(boolean) throws java.io.IOException;",
                "return_type": "java.lang.CharSequence"
            },
            {
                "name": "openWriter",
                "parameters": [],
                "signature": "public java.io.Writer openWriter() throws java.io.IOException;",
                "return_type": "java.io.Writer"
            },
            {
                "name": "getLastModified",
                "parameters": [],
                "signature": "public long getLastModified();",
                "return_type": "long"
            },
            {
                "name": "delete",
                "parameters": [],
                "signature": "public boolean delete();",
                "return_type": "boolean"
            }
        ],
        "ForwardingJavaFileManager": [
            {
                "name": "javax.tools.ForwardingJavaFileManager",
                "parameters": [
                    "M"
                ],
                "signature": "protected javax.tools.ForwardingJavaFileManager(M);",
                "return_type": "void"
            },
            {
                "name": "getClassLoader",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public java.lang.ClassLoader getClassLoader(javax.tools.JavaFileManager$Location);",
                "return_type": "java.lang.ClassLoader"
            },
            {
                "name": "list",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.util.Set<javax.tools.JavaFileObject$Kind>",
                    "boolean"
                ],
                "signature": "public java.lang.Iterable<javax.tools.JavaFileObject> list(javax.tools.JavaFileManager$Location, java.lang.String, java.util.Set<javax.tools.JavaFileObject$Kind>, boolean) throws java.io.IOException;",
                "return_type": "java.lang.Iterable<javax.tools.JavaFileObject>"
            },
            {
                "name": "inferBinaryName",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "javax.tools.JavaFileObject"
                ],
                "signature": "public java.lang.String inferBinaryName(javax.tools.JavaFileManager$Location, javax.tools.JavaFileObject);",
                "return_type": "java.lang.String"
            },
            {
                "name": "isSameFile",
                "parameters": [
                    "javax.tools.FileObject",
                    "javax.tools.FileObject"
                ],
                "signature": "public boolean isSameFile(javax.tools.FileObject, javax.tools.FileObject);",
                "return_type": "boolean"
            },
            {
                "name": "handleOption",
                "parameters": [
                    "java.lang.String",
                    "java.util.Iterator<java.lang.String>"
                ],
                "signature": "public boolean handleOption(java.lang.String, java.util.Iterator<java.lang.String>);",
                "return_type": "boolean"
            },
            {
                "name": "hasLocation",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public boolean hasLocation(javax.tools.JavaFileManager$Location);",
                "return_type": "boolean"
            },
            {
                "name": "isSupportedOption",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public int isSupportedOption(java.lang.String);",
                "return_type": "int"
            },
            {
                "name": "getJavaFileForInput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind"
                ],
                "signature": "public javax.tools.JavaFileObject getJavaFileForInput(javax.tools.JavaFileManager$Location, java.lang.String, javax.tools.JavaFileObject$Kind) throws java.io.IOException;",
                "return_type": "javax.tools.JavaFileObject"
            },
            {
                "name": "getJavaFileForOutput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind",
                    "javax.tools.FileObject"
                ],
                "signature": "public javax.tools.JavaFileObject getJavaFileForOutput(javax.tools.JavaFileManager$Location, java.lang.String, javax.tools.JavaFileObject$Kind, javax.tools.FileObject) throws java.io.IOException;",
                "return_type": "javax.tools.JavaFileObject"
            },
            {
                "name": "getJavaFileForOutputForOriginatingFiles",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind",
                    "javax.tools.FileObject..."
                ],
                "signature": "public javax.tools.JavaFileObject getJavaFileForOutputForOriginatingFiles(javax.tools.JavaFileManager$Location, java.lang.String, javax.tools.JavaFileObject$Kind, javax.tools.FileObject...) throws java.io.IOException;",
                "return_type": "javax.tools.JavaFileObject"
            },
            {
                "name": "getFileForInput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public javax.tools.FileObject getFileForInput(javax.tools.JavaFileManager$Location, java.lang.String, java.lang.String) throws java.io.IOException;",
                "return_type": "javax.tools.FileObject"
            },
            {
                "name": "getFileForOutput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.tools.FileObject"
                ],
                "signature": "public javax.tools.FileObject getFileForOutput(javax.tools.JavaFileManager$Location, java.lang.String, java.lang.String, javax.tools.FileObject) throws java.io.IOException;",
                "return_type": "javax.tools.FileObject"
            },
            {
                "name": "getFileForOutputForOriginatingFiles",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.tools.FileObject..."
                ],
                "signature": "public javax.tools.FileObject getFileForOutputForOriginatingFiles(javax.tools.JavaFileManager$Location, java.lang.String, java.lang.String, javax.tools.FileObject...) throws java.io.IOException;",
                "return_type": "javax.tools.FileObject"
            },
            {
                "name": "flush",
                "parameters": [],
                "signature": "public void flush() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public void close() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getLocationForModule",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String"
                ],
                "signature": "public javax.tools.JavaFileManager$Location getLocationForModule(javax.tools.JavaFileManager$Location, java.lang.String) throws java.io.IOException;",
                "return_type": "javax.tools.JavaFileManager$Location"
            },
            {
                "name": "getLocationForModule",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "javax.tools.JavaFileObject"
                ],
                "signature": "public javax.tools.JavaFileManager$Location getLocationForModule(javax.tools.JavaFileManager$Location, javax.tools.JavaFileObject) throws java.io.IOException;",
                "return_type": "javax.tools.JavaFileManager$Location"
            },
            {
                "name": "getServiceLoader",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.Class<S>"
                ],
                "signature": "public <S> java.util.ServiceLoader<S> getServiceLoader(javax.tools.JavaFileManager$Location, java.lang.Class<S>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "inferModuleName",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public java.lang.String inferModuleName(javax.tools.JavaFileManager$Location) throws java.io.IOException;",
                "return_type": "java.lang.String"
            },
            {
                "name": "listLocationsForModules",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public java.lang.Iterable<java.util.Set<javax.tools.JavaFileManager$Location>> listLocationsForModules(javax.tools.JavaFileManager$Location) throws java.io.IOException;",
                "return_type": "java.lang.Iterable<java.util.Set<javax.tools.JavaFileManager$Location>>"
            },
            {
                "name": "contains",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "javax.tools.FileObject"
                ],
                "signature": "public boolean contains(javax.tools.JavaFileManager$Location, javax.tools.FileObject) throws java.io.IOException;",
                "return_type": "boolean"
            }
        ],
        "ForwardingJavaFileObject": [
            {
                "name": "javax.tools.ForwardingJavaFileObject",
                "parameters": [
                    "F"
                ],
                "signature": "protected javax.tools.ForwardingJavaFileObject(F);",
                "return_type": "void"
            },
            {
                "name": "getKind",
                "parameters": [],
                "signature": "public javax.tools.JavaFileObject$Kind getKind();",
                "return_type": "javax.tools.JavaFileObject$Kind"
            },
            {
                "name": "isNameCompatible",
                "parameters": [
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind"
                ],
                "signature": "public boolean isNameCompatible(java.lang.String, javax.tools.JavaFileObject$Kind);",
                "return_type": "boolean"
            },
            {
                "name": "getNestingKind",
                "parameters": [],
                "signature": "public javax.lang.model.element.NestingKind getNestingKind();",
                "return_type": "javax.lang.model.element.NestingKind"
            },
            {
                "name": "getAccessLevel",
                "parameters": [],
                "signature": "public javax.lang.model.element.Modifier getAccessLevel();",
                "return_type": "javax.lang.model.element.Modifier"
            }
        ],
        "JavaCompiler": [
            {
                "name": "getTask",
                "parameters": [
                    "java.io.Writer",
                    "javax.tools.JavaFileManager",
                    "javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>",
                    "java.lang.Iterable<java.lang.String>",
                    "java.lang.Iterable<java.lang.String>",
                    "java.lang.Iterable<? extends javax.tools.JavaFileObject>"
                ],
                "signature": "public abstract javax.tools.JavaCompiler$CompilationTask getTask(java.io.Writer, javax.tools.JavaFileManager, javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>, java.lang.Iterable<java.lang.String>, java.lang.Iterable<java.lang.String>, java.lang.Iterable<? extends javax.tools.JavaFileObject>);",
                "return_type": "void"
            },
            {
                "name": "getStandardFileManager",
                "parameters": [
                    "javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>",
                    "java.util.Locale",
                    "java.nio.charset.Charset"
                ],
                "signature": "public abstract javax.tools.StandardJavaFileManager getStandardFileManager(javax.tools.DiagnosticListener<? super javax.tools.JavaFileObject>, java.util.Locale, java.nio.charset.Charset);",
                "return_type": "void"
            }
        ],
        "JavaFileManager": [
            {
                "name": "getClassLoader",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public abstract java.lang.ClassLoader getClassLoader(javax.tools.JavaFileManager$Location);",
                "return_type": "void"
            },
            {
                "name": "list",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.util.Set<javax.tools.JavaFileObject$Kind>",
                    "boolean"
                ],
                "signature": "public abstract java.lang.Iterable<javax.tools.JavaFileObject> list(javax.tools.JavaFileManager$Location, java.lang.String, java.util.Set<javax.tools.JavaFileObject$Kind>, boolean) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "inferBinaryName",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "javax.tools.JavaFileObject"
                ],
                "signature": "public abstract java.lang.String inferBinaryName(javax.tools.JavaFileManager$Location, javax.tools.JavaFileObject);",
                "return_type": "void"
            },
            {
                "name": "isSameFile",
                "parameters": [
                    "javax.tools.FileObject",
                    "javax.tools.FileObject"
                ],
                "signature": "public abstract boolean isSameFile(javax.tools.FileObject, javax.tools.FileObject);",
                "return_type": "void"
            },
            {
                "name": "handleOption",
                "parameters": [
                    "java.lang.String",
                    "java.util.Iterator<java.lang.String>"
                ],
                "signature": "public abstract boolean handleOption(java.lang.String, java.util.Iterator<java.lang.String>);",
                "return_type": "void"
            },
            {
                "name": "hasLocation",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public abstract boolean hasLocation(javax.tools.JavaFileManager$Location);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileForInput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind"
                ],
                "signature": "public abstract javax.tools.JavaFileObject getJavaFileForInput(javax.tools.JavaFileManager$Location, java.lang.String, javax.tools.JavaFileObject$Kind) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getJavaFileForOutput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind",
                    "javax.tools.FileObject"
                ],
                "signature": "public abstract javax.tools.JavaFileObject getJavaFileForOutput(javax.tools.JavaFileManager$Location, java.lang.String, javax.tools.JavaFileObject$Kind, javax.tools.FileObject) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getJavaFileForOutputForOriginatingFiles",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind",
                    "javax.tools.FileObject..."
                ],
                "signature": "public default javax.tools.JavaFileObject getJavaFileForOutputForOriginatingFiles(javax.tools.JavaFileManager$Location, java.lang.String, javax.tools.JavaFileObject$Kind, javax.tools.FileObject...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getFileForInput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "public abstract javax.tools.FileObject getFileForInput(javax.tools.JavaFileManager$Location, java.lang.String, java.lang.String) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getFileForOutput",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.tools.FileObject"
                ],
                "signature": "public abstract javax.tools.FileObject getFileForOutput(javax.tools.JavaFileManager$Location, java.lang.String, java.lang.String, javax.tools.FileObject) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getFileForOutputForOriginatingFiles",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.lang.String",
                    "javax.tools.FileObject..."
                ],
                "signature": "public default javax.tools.FileObject getFileForOutputForOriginatingFiles(javax.tools.JavaFileManager$Location, java.lang.String, java.lang.String, javax.tools.FileObject...) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "flush",
                "parameters": [],
                "signature": "public abstract void flush() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "close",
                "parameters": [],
                "signature": "public abstract void close() throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getLocationForModule",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String"
                ],
                "signature": "public default javax.tools.JavaFileManager$Location getLocationForModule(javax.tools.JavaFileManager$Location, java.lang.String) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getLocationForModule",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "javax.tools.JavaFileObject"
                ],
                "signature": "public default javax.tools.JavaFileManager$Location getLocationForModule(javax.tools.JavaFileManager$Location, javax.tools.JavaFileObject) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getServiceLoader",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.Class<S>"
                ],
                "signature": "public default <S> java.util.ServiceLoader<S> getServiceLoader(javax.tools.JavaFileManager$Location, java.lang.Class<S>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "inferModuleName",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public default java.lang.String inferModuleName(javax.tools.JavaFileManager$Location) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "listLocationsForModules",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public default java.lang.Iterable<java.util.Set<javax.tools.JavaFileManager$Location>> listLocationsForModules(javax.tools.JavaFileManager$Location) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "contains",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "javax.tools.FileObject"
                ],
                "signature": "public default boolean contains(javax.tools.JavaFileManager$Location, javax.tools.FileObject) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "siblingFrom",
                "parameters": [
                    "javax.tools.FileObject[]"
                ],
                "signature": "private static javax.tools.FileObject siblingFrom(javax.tools.FileObject[]);",
                "return_type": "void"
            }
        ],
        "JavaFileObject": [
            {
                "name": "getKind",
                "parameters": [],
                "signature": "public abstract javax.tools.JavaFileObject$Kind getKind();",
                "return_type": "void"
            },
            {
                "name": "isNameCompatible",
                "parameters": [
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind"
                ],
                "signature": "public abstract boolean isNameCompatible(java.lang.String, javax.tools.JavaFileObject$Kind);",
                "return_type": "void"
            },
            {
                "name": "getNestingKind",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.NestingKind getNestingKind();",
                "return_type": "void"
            },
            {
                "name": "getAccessLevel",
                "parameters": [],
                "signature": "public abstract javax.lang.model.element.Modifier getAccessLevel();",
                "return_type": "void"
            }
        ],
        "OptionChecker": [
            {
                "name": "isSupportedOption",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public abstract int isSupportedOption(java.lang.String);",
                "return_type": "void"
            }
        ],
        "SimpleJavaFileObject": [
            {
                "name": "javax.tools.SimpleJavaFileObject",
                "parameters": [
                    "java.net.URI",
                    "javax.tools.JavaFileObject$Kind"
                ],
                "signature": "protected javax.tools.SimpleJavaFileObject(java.net.URI, javax.tools.JavaFileObject$Kind);",
                "return_type": "void"
            },
            {
                "name": "toUri",
                "parameters": [],
                "signature": "public java.net.URI toUri();",
                "return_type": "java.net.URI"
            },
            {
                "name": "getName",
                "parameters": [],
                "signature": "public java.lang.String getName();",
                "return_type": "java.lang.String"
            },
            {
                "name": "openInputStream",
                "parameters": [],
                "signature": "public java.io.InputStream openInputStream() throws java.io.IOException;",
                "return_type": "java.io.InputStream"
            },
            {
                "name": "openOutputStream",
                "parameters": [],
                "signature": "public java.io.OutputStream openOutputStream() throws java.io.IOException;",
                "return_type": "java.io.OutputStream"
            },
            {
                "name": "openReader",
                "parameters": [
                    "boolean"
                ],
                "signature": "public java.io.Reader openReader(boolean) throws java.io.IOException;",
                "return_type": "java.io.Reader"
            },
            {
                "name": "getCharContent",
                "parameters": [
                    "boolean"
                ],
                "signature": "public java.lang.CharSequence getCharContent(boolean) throws java.io.IOException;",
                "return_type": "java.lang.CharSequence"
            },
            {
                "name": "openWriter",
                "parameters": [],
                "signature": "public java.io.Writer openWriter() throws java.io.IOException;",
                "return_type": "java.io.Writer"
            },
            {
                "name": "getLastModified",
                "parameters": [],
                "signature": "public long getLastModified();",
                "return_type": "long"
            },
            {
                "name": "delete",
                "parameters": [],
                "signature": "public boolean delete();",
                "return_type": "boolean"
            },
            {
                "name": "getKind",
                "parameters": [],
                "signature": "public javax.tools.JavaFileObject$Kind getKind();",
                "return_type": "javax.tools.JavaFileObject$Kind"
            },
            {
                "name": "isNameCompatible",
                "parameters": [
                    "java.lang.String",
                    "javax.tools.JavaFileObject$Kind"
                ],
                "signature": "public boolean isNameCompatible(java.lang.String, javax.tools.JavaFileObject$Kind);",
                "return_type": "boolean"
            },
            {
                "name": "getNestingKind",
                "parameters": [],
                "signature": "public javax.lang.model.element.NestingKind getNestingKind();",
                "return_type": "javax.lang.model.element.NestingKind"
            },
            {
                "name": "getAccessLevel",
                "parameters": [],
                "signature": "public javax.lang.model.element.Modifier getAccessLevel();",
                "return_type": "javax.lang.model.element.Modifier"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public java.lang.String toString();",
                "return_type": "java.lang.String"
            },
            {
                "name": "forSource",
                "parameters": [
                    "java.net.URI",
                    "java.lang.String"
                ],
                "signature": "public static javax.tools.JavaFileObject forSource(java.net.URI, java.lang.String);",
                "return_type": "javax.tools.JavaFileObject"
            }
        ],
        "StandardJavaFileManager": [
            {
                "name": "isSameFile",
                "parameters": [
                    "javax.tools.FileObject",
                    "javax.tools.FileObject"
                ],
                "signature": "public abstract boolean isSameFile(javax.tools.FileObject, javax.tools.FileObject);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjectsFromFiles",
                "parameters": [
                    "java.lang.Iterable<? extends java.io.File>"
                ],
                "signature": "public abstract java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjectsFromFiles(java.lang.Iterable<? extends java.io.File>);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjectsFromPaths",
                "parameters": [
                    "java.util.Collection<? extends java.nio.file.Path>"
                ],
                "signature": "public default java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjectsFromPaths(java.util.Collection<? extends java.nio.file.Path>);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjectsFromPaths",
                "parameters": [
                    "java.lang.Iterable<? extends java.nio.file.Path>"
                ],
                "signature": "public default java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjectsFromPaths(java.lang.Iterable<? extends java.nio.file.Path>);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjects",
                "parameters": [
                    "java.io.File..."
                ],
                "signature": "public abstract java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjects(java.io.File...);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjects",
                "parameters": [
                    "java.nio.file.Path..."
                ],
                "signature": "public default java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjects(java.nio.file.Path...);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjectsFromStrings",
                "parameters": [
                    "java.lang.Iterable<java.lang.String>"
                ],
                "signature": "public abstract java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjectsFromStrings(java.lang.Iterable<java.lang.String>);",
                "return_type": "void"
            },
            {
                "name": "getJavaFileObjects",
                "parameters": [
                    "java.lang.String..."
                ],
                "signature": "public abstract java.lang.Iterable<? extends javax.tools.JavaFileObject> getJavaFileObjects(java.lang.String...);",
                "return_type": "void"
            },
            {
                "name": "setLocation",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.Iterable<? extends java.io.File>"
                ],
                "signature": "public abstract void setLocation(javax.tools.JavaFileManager$Location, java.lang.Iterable<? extends java.io.File>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "setLocationFromPaths",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.util.Collection<? extends java.nio.file.Path>"
                ],
                "signature": "public default void setLocationFromPaths(javax.tools.JavaFileManager$Location, java.util.Collection<? extends java.nio.file.Path>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "setLocationForModule",
                "parameters": [
                    "javax.tools.JavaFileManager$Location",
                    "java.lang.String",
                    "java.util.Collection<? extends java.nio.file.Path>"
                ],
                "signature": "public default void setLocationForModule(javax.tools.JavaFileManager$Location, java.lang.String, java.util.Collection<? extends java.nio.file.Path>) throws java.io.IOException;",
                "return_type": "void"
            },
            {
                "name": "getLocation",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public abstract java.lang.Iterable<? extends java.io.File> getLocation(javax.tools.JavaFileManager$Location);",
                "return_type": "void"
            },
            {
                "name": "getLocationAsPaths",
                "parameters": [
                    "javax.tools.JavaFileManager$Location"
                ],
                "signature": "public default java.lang.Iterable<? extends java.nio.file.Path> getLocationAsPaths(javax.tools.JavaFileManager$Location);",
                "return_type": "void"
            },
            {
                "name": "asPath",
                "parameters": [
                    "javax.tools.FileObject"
                ],
                "signature": "public default java.nio.file.Path asPath(javax.tools.FileObject);",
                "return_type": "void"
            },
            {
                "name": "setPathFactory",
                "parameters": [
                    "javax.tools.StandardJavaFileManager$PathFactory"
                ],
                "signature": "public default void setPathFactory(javax.tools.StandardJavaFileManager$PathFactory);",
                "return_type": "void"
            },
            {
                "name": "asPaths",
                "parameters": [
                    "java.lang.Iterable<? extends java.io.File>"
                ],
                "signature": "private static java.lang.Iterable<java.nio.file.Path> asPaths(java.lang.Iterable<? extends java.io.File>);",
                "return_type": "void"
            },
            {
                "name": "asFiles",
                "parameters": [
                    "java.lang.Iterable<? extends java.nio.file.Path>"
                ],
                "signature": "private static java.lang.Iterable<java.io.File> asFiles(java.lang.Iterable<? extends java.nio.file.Path>);",
                "return_type": "void"
            },
            {
                "name": "asCollection",
                "parameters": [
                    "java.lang.Iterable<T>"
                ],
                "signature": "private static <T> java.util.Collection<T> asCollection(java.lang.Iterable<T>);",
                "return_type": "void"
            }
        ],
        "StandardLocation": [
            {
                "name": "values",
                "parameters": [],
                "signature": "public static javax.tools.StandardLocation[] values();",
                "return_type": "javax.tools.StandardLocation[]"
            },
            {
                "name": "valueOf",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.tools.StandardLocation valueOf(java.lang.String);",
                "return_type": "javax.tools.StandardLocation"
            },
            {
                "name": "javax.tools.StandardLocation",
                "parameters": [],
                "signature": "private javax.tools.StandardLocation();",
                "return_type": "void"
            },
            {
                "name": "locationFor",
                "parameters": [
                    "java.lang.String"
                ],
                "signature": "public static javax.tools.JavaFileManager$Location locationFor(java.lang.String);",
                "return_type": "javax.tools.JavaFileManager$Location"
            },
            {
                "name": "getName",
                "parameters": [],
                "signature": "public java.lang.String getName();",
                "return_type": "java.lang.String"
            },
            {
                "name": "isOutputLocation",
                "parameters": [],
                "signature": "public boolean isOutputLocation();",
                "return_type": "boolean"
            },
            {
                "name": "isModuleOrientedLocation",
                "parameters": [],
                "signature": "public boolean isModuleOrientedLocation();",
                "return_type": "boolean"
            }
        ],
        "Tool": [
            {
                "name": "name",
                "parameters": [],
                "signature": "public default java.lang.String name();",
                "return_type": "void"
            },
            {
                "name": "run",
                "parameters": [
                    "java.io.InputStream",
                    "java.io.OutputStream",
                    "java.io.OutputStream",
                    "java.lang.String..."
                ],
                "signature": "public abstract int run(java.io.InputStream, java.io.OutputStream, java.io.OutputStream, java.lang.String...);",
                "return_type": "void"
            },
            {
                "name": "getSourceVersions",
                "parameters": [],
                "signature": "public abstract java.util.Set<javax.lang.model.SourceVersion> getSourceVersions();",
                "return_type": "void"
            }
        ],
        "ToolProvider": [
            {
                "name": "javax.tools.ToolProvider",
                "parameters": [],
                "signature": "private javax.tools.ToolProvider();",
                "return_type": "void"
            },
            {
                "name": "getSystemJavaCompiler",
                "parameters": [],
                "signature": "public static javax.tools.JavaCompiler getSystemJavaCompiler();",
                "return_type": "javax.tools.JavaCompiler"
            },
            {
                "name": "getSystemDocumentationTool",
                "parameters": [],
                "signature": "public static javax.tools.DocumentationTool getSystemDocumentationTool();",
                "return_type": "javax.tools.DocumentationTool"
            },
            {
                "name": "getSystemToolClassLoader",
                "parameters": [],
                "signature": "public static java.lang.ClassLoader getSystemToolClassLoader();",
                "return_type": "java.lang.ClassLoader"
            },
            {
                "name": "getSystemTool",
                "parameters": [
                    "java.lang.Class<T>",
                    "java.lang.String",
                    "java.lang.String"
                ],
                "signature": "private static <T> T getSystemTool(java.lang.Class<T>, java.lang.String, java.lang.String);",
                "return_type": "void"
            }
        ]
    },
    "jdk.incubator.vector": {
        "AbstractMask": [
            {
                "name": "vectorSpecies",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorSpecies<E> vectorSpecies();",
                "return_type": "void"
            },
            {
                "name": "intoArray",
                "parameters": [
                    "boolean[]",
                    "int"
                ],
                "signature": "public void intoArray(boolean[], int);",
                "return_type": "void"
            },
            {
                "name": "toArray",
                "parameters": [],
                "signature": "public boolean[] toArray();",
                "return_type": "boolean[]"
            },
            {
                "name": "check",
                "parameters": [
                    "java.lang.Class<F>"
                ],
                "signature": "public <F> jdk.incubator.vector.VectorMask<F> check(java.lang.Class<F>);",
                "return_type": "void"
            },
            {
                "name": "check",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<F>"
                ],
                "signature": "public <F> jdk.incubator.vector.VectorMask<F> check(jdk.incubator.vector.VectorSpecies<F>);",
                "return_type": "void"
            },
            {
                "name": "sameSpecies",
                "parameters": [
                    "java.lang.Class<? extends jdk.incubator.vector.VectorMask<F>>",
                    "jdk.incubator.vector.Vector<F>"
                ],
                "signature": "private <F> boolean sameSpecies(java.lang.Class<? extends jdk.incubator.vector.VectorMask<F>>, jdk.incubator.vector.Vector<F>);",
                "return_type": "void"
            },
            {
                "name": "andNot",
                "parameters": [
                    "jdk.incubator.vector.VectorMask<E>"
                ],
                "signature": "public final jdk.incubator.vector.VectorMask<E> andNot(jdk.incubator.vector.VectorMask<E>);",
                "return_type": "void"
            },
            {
                "name": "eq",
                "parameters": [
                    "jdk.incubator.vector.VectorMask<E>"
                ],
                "signature": "public final jdk.incubator.vector.VectorMask<E> eq(jdk.incubator.vector.VectorMask<E>);",
                "return_type": "void"
            },
            {
                "name": "indexInRange",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.VectorMask<E> indexInRange(int, int);",
                "return_type": "jdk.incubator.vector.VectorMask<E>"
            },
            {
                "name": "indexInRange",
                "parameters": [
                    "long",
                    "long"
                ],
                "signature": "public jdk.incubator.vector.VectorMask<E> indexInRange(long, long);",
                "return_type": "jdk.incubator.vector.VectorMask<E>"
            },
            {
                "name": "checkIndex0",
                "parameters": [
                    "int",
                    "int",
                    "jdk.incubator.vector.Vector<E>",
                    "int"
                ],
                "signature": "private jdk.incubator.vector.VectorMask<E> checkIndex0(int, int, jdk.incubator.vector.Vector<E>, int);",
                "return_type": "void"
            },
            {
                "name": "checkIndex0",
                "parameters": [
                    "long",
                    "long",
                    "jdk.incubator.vector.Vector<E>",
                    "int"
                ],
                "signature": "private jdk.incubator.vector.VectorMask<E> checkIndex0(long, long, jdk.incubator.vector.Vector<E>, int);",
                "return_type": "void"
            },
            {
                "name": "checkIndexFailed",
                "parameters": [
                    "long",
                    "int",
                    "long",
                    "int"
                ],
                "signature": "private java.lang.IndexOutOfBoundsException checkIndexFailed(long, int, long, int);",
                "return_type": "void"
            }
        ],
        "AbstractShuffle": [
            {
                "name": "prepare",
                "parameters": [
                    "int",
                    "int[]",
                    "int"
                ],
                "signature": "private static byte[] prepare(int, int[], int);",
                "return_type": "void"
            },
            {
                "name": "prepare",
                "parameters": [
                    "int",
                    "java.util.function.IntUnaryOperator"
                ],
                "signature": "private static byte[] prepare(int, java.util.function.IntUnaryOperator);",
                "return_type": "void"
            },
            {
                "name": "vectorSpecies",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorSpecies<E> vectorSpecies();",
                "return_type": "void"
            },
            {
                "name": "intoArray",
                "parameters": [
                    "int[]",
                    "int"
                ],
                "signature": "public void intoArray(int[], int);",
                "return_type": "void"
            },
            {
                "name": "toArray",
                "parameters": [],
                "signature": "public int[] toArray();",
                "return_type": "int[]"
            },
            {
                "name": "checkIndexes",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> checkIndexes();",
                "return_type": "void"
            },
            {
                "name": "wrapIndexesTemplate",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> wrapIndexesTemplate();",
                "return_type": "void"
            },
            {
                "name": "wrapAndRebuild",
                "parameters": [
                    "byte[]"
                ],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> wrapAndRebuild(byte[]);",
                "return_type": "void"
            },
            {
                "name": "laneIsValid",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorMask<E> laneIsValid();",
                "return_type": "void"
            },
            {
                "name": "check",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<F>"
                ],
                "signature": "public final <F> jdk.incubator.vector.VectorShuffle<F> check(jdk.incubator.vector.VectorSpecies<F>);",
                "return_type": "void"
            },
            {
                "name": "checkIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public final int checkIndex(int);",
                "return_type": "void"
            },
            {
                "name": "wrapIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public final int wrapIndex(int);",
                "return_type": "void"
            },
            {
                "name": "checkIndexFailed",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "private static java.lang.IndexOutOfBoundsException checkIndexFailed(int, int);",
                "return_type": "void"
            }
        ],
        "AbstractSpecies": [
            {
                "name": "length",
                "parameters": [],
                "signature": "public final int length();",
                "return_type": "void"
            },
            {
                "name": "elementType",
                "parameters": [],
                "signature": "public java.lang.Class<E> elementType();",
                "return_type": "java.lang.Class<E>"
            },
            {
                "name": "vectorType",
                "parameters": [],
                "signature": "public java.lang.Class<? extends jdk.incubator.vector.AbstractVector<E>> vectorType();",
                "return_type": "void"
            },
            {
                "name": "maskType",
                "parameters": [],
                "signature": "public final java.lang.Class<? extends jdk.incubator.vector.AbstractMask<E>> maskType();",
                "return_type": "void"
            },
            {
                "name": "elementSize",
                "parameters": [],
                "signature": "public final int elementSize();",
                "return_type": "void"
            },
            {
                "name": "vectorShape",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorShape vectorShape();",
                "return_type": "void"
            },
            {
                "name": "vectorBitSize",
                "parameters": [],
                "signature": "public final int vectorBitSize();",
                "return_type": "void"
            },
            {
                "name": "vectorByteSize",
                "parameters": [],
                "signature": "public final int vectorByteSize();",
                "return_type": "void"
            },
            {
                "name": "loopBound",
                "parameters": [
                    "int"
                ],
                "signature": "public final int loopBound(int);",
                "return_type": "void"
            },
            {
                "name": "loopBound",
                "parameters": [
                    "long"
                ],
                "signature": "public final long loopBound(long);",
                "return_type": "void"
            },
            {
                "name": "indexInRange",
                "parameters": [
                    "int",
                    "int"
                ],
                "signature": "public final jdk.incubator.vector.VectorMask<E> indexInRange(int, int);",
                "return_type": "void"
            },
            {
                "name": "indexInRange",
                "parameters": [
                    "long",
                    "long"
                ],
                "signature": "public final jdk.incubator.vector.VectorMask<E> indexInRange(long, long);",
                "return_type": "void"
            },
            {
                "name": "withLanes",
                "parameters": [
                    "java.lang.Class<F>"
                ],
                "signature": "public final <F> jdk.incubator.vector.VectorSpecies<F> withLanes(java.lang.Class<F>);",
                "return_type": "void"
            },
            {
                "name": "withShape",
                "parameters": [
                    "jdk.incubator.vector.VectorShape"
                ],
                "signature": "public final jdk.incubator.vector.VectorSpecies<E> withShape(jdk.incubator.vector.VectorShape);",
                "return_type": "void"
            },
            {
                "name": "makeSwapBytesShuffle",
                "parameters": [],
                "signature": "private jdk.incubator.vector.AbstractShuffle<java.lang.Byte> makeSwapBytesShuffle();",
                "return_type": "void"
            },
            {
                "name": "makeDummyVector",
                "parameters": [],
                "signature": "private jdk.incubator.vector.AbstractVector<E> makeDummyVector();",
                "return_type": "void"
            },
            {
                "name": "shuffleFromArray",
                "parameters": [
                    "int[]",
                    "int"
                ],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> shuffleFromArray(int[], int);",
                "return_type": "void"
            },
            {
                "name": "shuffleFromValues",
                "parameters": [
                    "int..."
                ],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> shuffleFromValues(int...);",
                "return_type": "void"
            },
            {
                "name": "shuffleFromOp",
                "parameters": [
                    "java.util.function.IntUnaryOperator"
                ],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> shuffleFromOp(java.util.function.IntUnaryOperator);",
                "return_type": "void"
            },
            {
                "name": "iotaShuffle",
                "parameters": [
                    "int",
                    "int",
                    "boolean"
                ],
                "signature": "public final jdk.incubator.vector.VectorShuffle<E> iotaShuffle(int, int, boolean);",
                "return_type": "void"
            },
            {
                "name": "loadMask",
                "parameters": [
                    "boolean[]",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.VectorMask<E> loadMask(boolean[], int);",
                "return_type": "jdk.incubator.vector.VectorMask<E>"
            },
            {
                "name": "zero",
                "parameters": [],
                "signature": "public abstract jdk.incubator.vector.AbstractVector<E> zero();",
                "return_type": "void"
            },
            {
                "name": "checkScaleFailed",
                "parameters": [
                    "int"
                ],
                "signature": "private java.lang.IllegalArgumentException checkScaleFailed(int);",
                "return_type": "void"
            },
            {
                "name": "check",
                "parameters": [
                    "java.lang.Class<F>"
                ],
                "signature": "public final <F> jdk.incubator.vector.VectorSpecies<F> check(java.lang.Class<F>);",
                "return_type": "void"
            },
            {
                "name": "partLimit",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<?>",
                    "boolean"
                ],
                "signature": "public int partLimit(jdk.incubator.vector.VectorSpecies<?>, boolean);",
                "return_type": "int"
            },
            {
                "name": "computeSpecies",
                "parameters": [
                    "jdk.incubator.vector.LaneType",
                    "jdk.incubator.vector.VectorShape"
                ],
                "signature": "private static jdk.incubator.vector.AbstractSpecies<?> computeSpecies(jdk.incubator.vector.LaneType, jdk.incubator.vector.VectorShape);",
                "return_type": "void"
            },
            {
                "name": "toString",
                "parameters": [],
                "signature": "public final java.lang.String toString();",
                "return_type": "void"
            },
            {
                "name": "equals",
                "parameters": [
                    "java.lang.Object"
                ],
                "signature": "public final boolean equals(java.lang.Object);",
                "return_type": "void"
            },
            {
                "name": "hashCode",
                "parameters": [],
                "signature": "public final int hashCode();",
                "return_type": "void"
            },
            {
                "name": "zero",
                "parameters": [],
                "signature": "public jdk.incubator.vector.Vector zero();",
                "return_type": "jdk.incubator.vector.Vector"
            }
        ],
        "AbstractVector": [
            {
                "name": "species",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorSpecies<E> species();",
                "return_type": "void"
            },
            {
                "name": "check",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<F>"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> check(jdk.incubator.vector.VectorSpecies<F>);",
                "return_type": "void"
            },
            {
                "name": "check",
                "parameters": [
                    "java.lang.Class<F>"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> check(java.lang.Class<F>);",
                "return_type": "void"
            },
            {
                "name": "sameSpecies",
                "parameters": [
                    "jdk.incubator.vector.Vector<?>"
                ],
                "signature": "private boolean sameSpecies(jdk.incubator.vector.Vector<?>);",
                "return_type": "void"
            },
            {
                "name": "sameSpecies",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<?>"
                ],
                "signature": "private boolean sameSpecies(jdk.incubator.vector.VectorSpecies<?>);",
                "return_type": "void"
            },
            {
                "name": "maskAll",
                "parameters": [
                    "boolean"
                ],
                "signature": "public final jdk.incubator.vector.VectorMask<E> maskAll(boolean);",
                "return_type": "void"
            },
            {
                "name": "reinterpretAsShorts",
                "parameters": [],
                "signature": "public jdk.incubator.vector.ShortVector reinterpretAsShorts();",
                "return_type": "jdk.incubator.vector.ShortVector"
            },
            {
                "name": "reinterpretAsInts",
                "parameters": [],
                "signature": "public jdk.incubator.vector.IntVector reinterpretAsInts();",
                "return_type": "jdk.incubator.vector.IntVector"
            },
            {
                "name": "reinterpretAsLongs",
                "parameters": [],
                "signature": "public jdk.incubator.vector.LongVector reinterpretAsLongs();",
                "return_type": "jdk.incubator.vector.LongVector"
            },
            {
                "name": "reinterpretAsFloats",
                "parameters": [],
                "signature": "public jdk.incubator.vector.FloatVector reinterpretAsFloats();",
                "return_type": "jdk.incubator.vector.FloatVector"
            },
            {
                "name": "reinterpretAsDoubles",
                "parameters": [],
                "signature": "public jdk.incubator.vector.DoubleVector reinterpretAsDoubles();",
                "return_type": "jdk.incubator.vector.DoubleVector"
            },
            {
                "name": "convert",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Conversion<E",
                    "F>",
                    "int"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> convert(jdk.incubator.vector.VectorOperators$Conversion<E, F>, int);",
                "return_type": "void"
            },
            {
                "name": "castShape",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<F>",
                    "int"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> castShape(jdk.incubator.vector.VectorSpecies<F>, int);",
                "return_type": "void"
            },
            {
                "name": "convertShape",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Conversion<E",
                    "F>",
                    "jdk.incubator.vector.VectorSpecies<F>",
                    "int"
                ],
                "signature": "public abstract <F> jdk.incubator.vector.Vector<F> convertShape(jdk.incubator.vector.VectorOperators$Conversion<E, F>, jdk.incubator.vector.VectorSpecies<F>, int);",
                "return_type": "void"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<E>"
                ],
                "signature": "public abstract jdk.incubator.vector.AbstractVector<E> slice(int, jdk.incubator.vector.Vector<E>);",
                "return_type": "void"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public abstract jdk.incubator.vector.AbstractVector<E> slice(int);",
                "return_type": "void"
            },
            {
                "name": "partInRange",
                "parameters": [
                    "int",
                    "int",
                    "int"
                ],
                "signature": "private static boolean partInRange(int, int, int);",
                "return_type": "void"
            },
            {
                "name": "partInRangeSlow",
                "parameters": [
                    "int",
                    "int",
                    "int"
                ],
                "signature": "private static boolean partInRangeSlow(int, int, int);",
                "return_type": "void"
            },
            {
                "name": "wrongPart",
                "parameters": [
                    "jdk.incubator.vector.AbstractSpecies<?>",
                    "jdk.incubator.vector.AbstractSpecies<?>",
                    "boolean",
                    "int"
                ],
                "signature": "private static java.lang.ArrayIndexOutOfBoundsException wrongPart(jdk.incubator.vector.AbstractSpecies<?>, jdk.incubator.vector.AbstractSpecies<?>, boolean, int);",
                "return_type": "void"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector slice(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            }
        ],
        "Byte128Vector": [
            {
                "name": "vspecies",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.ByteVector$ByteSpecies vspecies();",
                "return_type": "void"
            },
            {
                "name": "elementType",
                "parameters": [],
                "signature": "public final java.lang.Class<java.lang.Byte> elementType();",
                "return_type": "void"
            },
            {
                "name": "elementSize",
                "parameters": [],
                "signature": "public final int elementSize();",
                "return_type": "void"
            },
            {
                "name": "shape",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorShape shape();",
                "return_type": "void"
            },
            {
                "name": "length",
                "parameters": [],
                "signature": "public final int length();",
                "return_type": "void"
            },
            {
                "name": "bitSize",
                "parameters": [],
                "signature": "public final int bitSize();",
                "return_type": "void"
            },
            {
                "name": "byteSize",
                "parameters": [],
                "signature": "public final int byteSize();",
                "return_type": "void"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "byte"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector broadcast(byte);",
                "return_type": "void"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "long"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector broadcast(long);",
                "return_type": "void"
            },
            {
                "name": "convertShape",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Conversion<java.lang.Byte",
                    "F>",
                    "jdk.incubator.vector.VectorSpecies<F>",
                    "int"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> convertShape(jdk.incubator.vector.VectorOperators$Conversion<java.lang.Byte, F>, jdk.incubator.vector.VectorSpecies<F>, int);",
                "return_type": "void"
            },
            {
                "name": "reinterpretShape",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<F>",
                    "int"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> reinterpretShape(jdk.incubator.vector.VectorSpecies<F>, int);",
                "return_type": "void"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector lanewise(jdk.incubator.vector.VectorOperators$Unary);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector lanewise(jdk.incubator.vector.VectorOperators$Unary, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "addIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector addIndex(int);",
                "return_type": "void"
            },
            {
                "name": "reduceLanes",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative"
                ],
                "signature": "public final byte reduceLanes(jdk.incubator.vector.VectorOperators$Associative);",
                "return_type": "void"
            },
            {
                "name": "reduceLanes",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final byte reduceLanes(jdk.incubator.vector.VectorOperators$Associative, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "reduceLanesToLong",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative"
                ],
                "signature": "public final long reduceLanesToLong(jdk.incubator.vector.VectorOperators$Associative);",
                "return_type": "void"
            },
            {
                "name": "reduceLanesToLong",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final long reduceLanesToLong(jdk.incubator.vector.VectorOperators$Associative, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "toShuffle",
                "parameters": [],
                "signature": "public jdk.incubator.vector.VectorShuffle<java.lang.Byte> toShuffle();",
                "return_type": "jdk.incubator.vector.VectorShuffle<java.lang.Byte>"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector$Byte128Mask test(jdk.incubator.vector.VectorOperators$Test);",
                "return_type": "void"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector$Byte128Mask test(jdk.incubator.vector.VectorOperators$Test, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector$Byte128Mask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "byte"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector$Byte128Mask compare(jdk.incubator.vector.VectorOperators$Comparison, byte);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "long"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector$Byte128Mask compare(jdk.incubator.vector.VectorOperators$Comparison, long);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte128Vector$Byte128Mask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "blend",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector blend(jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector slice(int, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector slice(int);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector unslice(int, jdk.incubator.vector.Vector<java.lang.Byte>, int);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "int",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector unslice(int, jdk.incubator.vector.Vector<java.lang.Byte>, int, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector unslice(int);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector rearrange(jdk.incubator.vector.VectorShuffle<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector rearrange(jdk.incubator.vector.VectorShuffle<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector rearrange(jdk.incubator.vector.VectorShuffle<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "compress",
                "parameters": [
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector compress(jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "expand",
                "parameters": [
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector expand(jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector selectFrom(jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector selectFrom(jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector selectFrom(jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "lane",
                "parameters": [
                    "int"
                ],
                "signature": "public byte lane(int);",
                "return_type": "byte"
            },
            {
                "name": "laneHelper",
                "parameters": [
                    "int"
                ],
                "signature": "public byte laneHelper(int);",
                "return_type": "byte"
            },
            {
                "name": "withLane",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector withLane(int, byte);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "withLaneHelper",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.Byte128Vector withLaneHelper(int, byte);",
                "return_type": "jdk.incubator.vector.Byte128Vector"
            },
            {
                "name": "withLane",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.ByteVector withLane(int, byte);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector selectFrom(jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "expand",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector expand(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "compress",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector compress(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle"
                ],
                "signature": "public jdk.incubator.vector.ByteVector rearrange(jdk.incubator.vector.VectorShuffle);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector unslice(int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector unslice(int, jdk.incubator.vector.Vector, int, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector unslice(int, jdk.incubator.vector.Vector, int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector slice(int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "addIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector addIndex(int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "blend",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector blend(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "long"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, long);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, byte);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.VectorMask test(jdk.incubator.vector.VectorOperators$Test, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test"
                ],
                "signature": "public jdk.incubator.vector.VectorMask test(jdk.incubator.vector.VectorOperators$Test);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Unary, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Unary);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "long"
                ],
                "signature": "public jdk.incubator.vector.ByteVector broadcast(long);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.ByteVector broadcast(byte);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.AbstractVector slice(int);",
                "return_type": "jdk.incubator.vector.AbstractVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.AbstractVector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.AbstractVector"
            },
            {
                "name": "vspecies",
                "parameters": [],
                "signature": "public jdk.incubator.vector.AbstractSpecies vspecies();",
                "return_type": "jdk.incubator.vector.AbstractSpecies"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "long"
                ],
                "signature": "public jdk.incubator.vector.Vector broadcast(long);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector selectFrom(jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "expand",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector expand(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "compress",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector compress(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle"
                ],
                "signature": "public jdk.incubator.vector.Vector rearrange(jdk.incubator.vector.VectorShuffle);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector unslice(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector unslice(int, jdk.incubator.vector.Vector, int, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector unslice(int, jdk.incubator.vector.Vector, int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector slice(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "addIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector addIndex(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "blend",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector blend(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Unary, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Unary);",
                "return_type": "jdk.incubator.vector.Vector"
            }
        ],
        "Byte256Vector": [
            {
                "name": "vspecies",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.ByteVector$ByteSpecies vspecies();",
                "return_type": "void"
            },
            {
                "name": "elementType",
                "parameters": [],
                "signature": "public final java.lang.Class<java.lang.Byte> elementType();",
                "return_type": "void"
            },
            {
                "name": "elementSize",
                "parameters": [],
                "signature": "public final int elementSize();",
                "return_type": "void"
            },
            {
                "name": "shape",
                "parameters": [],
                "signature": "public final jdk.incubator.vector.VectorShape shape();",
                "return_type": "void"
            },
            {
                "name": "length",
                "parameters": [],
                "signature": "public final int length();",
                "return_type": "void"
            },
            {
                "name": "bitSize",
                "parameters": [],
                "signature": "public final int bitSize();",
                "return_type": "void"
            },
            {
                "name": "byteSize",
                "parameters": [],
                "signature": "public final int byteSize();",
                "return_type": "void"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "byte"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector broadcast(byte);",
                "return_type": "void"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "long"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector broadcast(long);",
                "return_type": "void"
            },
            {
                "name": "convertShape",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Conversion<java.lang.Byte",
                    "F>",
                    "jdk.incubator.vector.VectorSpecies<F>",
                    "int"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> convertShape(jdk.incubator.vector.VectorOperators$Conversion<java.lang.Byte, F>, jdk.incubator.vector.VectorSpecies<F>, int);",
                "return_type": "void"
            },
            {
                "name": "reinterpretShape",
                "parameters": [
                    "jdk.incubator.vector.VectorSpecies<F>",
                    "int"
                ],
                "signature": "public final <F> jdk.incubator.vector.Vector<F> reinterpretShape(jdk.incubator.vector.VectorSpecies<F>, int);",
                "return_type": "void"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector lanewise(jdk.incubator.vector.VectorOperators$Unary);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector lanewise(jdk.incubator.vector.VectorOperators$Unary, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "addIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector addIndex(int);",
                "return_type": "void"
            },
            {
                "name": "reduceLanes",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative"
                ],
                "signature": "public final byte reduceLanes(jdk.incubator.vector.VectorOperators$Associative);",
                "return_type": "void"
            },
            {
                "name": "reduceLanes",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final byte reduceLanes(jdk.incubator.vector.VectorOperators$Associative, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "reduceLanesToLong",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative"
                ],
                "signature": "public final long reduceLanesToLong(jdk.incubator.vector.VectorOperators$Associative);",
                "return_type": "void"
            },
            {
                "name": "reduceLanesToLong",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Associative",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final long reduceLanesToLong(jdk.incubator.vector.VectorOperators$Associative, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "toShuffle",
                "parameters": [],
                "signature": "public jdk.incubator.vector.VectorShuffle<java.lang.Byte> toShuffle();",
                "return_type": "jdk.incubator.vector.VectorShuffle<java.lang.Byte>"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector$Byte256Mask test(jdk.incubator.vector.VectorOperators$Test);",
                "return_type": "void"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector$Byte256Mask test(jdk.incubator.vector.VectorOperators$Test, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector$Byte256Mask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "byte"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector$Byte256Mask compare(jdk.incubator.vector.VectorOperators$Comparison, byte);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "long"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector$Byte256Mask compare(jdk.incubator.vector.VectorOperators$Comparison, long);",
                "return_type": "void"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public final jdk.incubator.vector.Byte256Vector$Byte256Mask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "void"
            },
            {
                "name": "blend",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector blend(jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector slice(int, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector slice(int);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector unslice(int, jdk.incubator.vector.Vector<java.lang.Byte>, int);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "int",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector unslice(int, jdk.incubator.vector.Vector<java.lang.Byte>, int, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector unslice(int);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector rearrange(jdk.incubator.vector.VectorShuffle<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector rearrange(jdk.incubator.vector.VectorShuffle<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector rearrange(jdk.incubator.vector.VectorShuffle<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "compress",
                "parameters": [
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector compress(jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "expand",
                "parameters": [
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector expand(jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector selectFrom(jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.VectorMask<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector selectFrom(jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.VectorMask<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector<java.lang.Byte>",
                    "jdk.incubator.vector.Vector<java.lang.Byte>"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector selectFrom(jdk.incubator.vector.Vector<java.lang.Byte>, jdk.incubator.vector.Vector<java.lang.Byte>);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "lane",
                "parameters": [
                    "int"
                ],
                "signature": "public byte lane(int);",
                "return_type": "byte"
            },
            {
                "name": "laneHelper",
                "parameters": [
                    "int"
                ],
                "signature": "public byte laneHelper(int);",
                "return_type": "byte"
            },
            {
                "name": "withLane",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector withLane(int, byte);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "withLaneHelper",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.Byte256Vector withLaneHelper(int, byte);",
                "return_type": "jdk.incubator.vector.Byte256Vector"
            },
            {
                "name": "withLane",
                "parameters": [
                    "int",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.ByteVector withLane(int, byte);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector selectFrom(jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "expand",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector expand(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "compress",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector compress(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle"
                ],
                "signature": "public jdk.incubator.vector.ByteVector rearrange(jdk.incubator.vector.VectorShuffle);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector unslice(int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector unslice(int, jdk.incubator.vector.Vector, int, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector unslice(int, jdk.incubator.vector.Vector, int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector slice(int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "addIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.ByteVector addIndex(int);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "blend",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector blend(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "long"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, long);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, byte);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.VectorMask test(jdk.incubator.vector.VectorOperators$Test, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "test",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Test"
                ],
                "signature": "public jdk.incubator.vector.VectorMask test(jdk.incubator.vector.VectorOperators$Test);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Binary",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Binary, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Unary, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Unary"
                ],
                "signature": "public jdk.incubator.vector.ByteVector lanewise(jdk.incubator.vector.VectorOperators$Unary);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "long"
                ],
                "signature": "public jdk.incubator.vector.ByteVector broadcast(long);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "byte"
                ],
                "signature": "public jdk.incubator.vector.ByteVector broadcast(byte);",
                "return_type": "jdk.incubator.vector.ByteVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.AbstractVector slice(int);",
                "return_type": "jdk.incubator.vector.AbstractVector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.AbstractVector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.AbstractVector"
            },
            {
                "name": "vspecies",
                "parameters": [],
                "signature": "public jdk.incubator.vector.AbstractSpecies vspecies();",
                "return_type": "jdk.incubator.vector.AbstractSpecies"
            },
            {
                "name": "broadcast",
                "parameters": [
                    "long"
                ],
                "signature": "public jdk.incubator.vector.Vector broadcast(long);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector selectFrom(jdk.incubator.vector.Vector, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "selectFrom",
                "parameters": [
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector selectFrom(jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "expand",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector expand(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "compress",
                "parameters": [
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector compress(jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector rearrange(jdk.incubator.vector.VectorShuffle, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "rearrange",
                "parameters": [
                    "jdk.incubator.vector.VectorShuffle"
                ],
                "signature": "public jdk.incubator.vector.Vector rearrange(jdk.incubator.vector.VectorShuffle);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector unslice(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector unslice(int, jdk.incubator.vector.Vector, int, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "unslice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector",
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector unslice(int, jdk.incubator.vector.Vector, int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector slice(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "slice",
                "parameters": [
                    "int",
                    "jdk.incubator.vector.Vector"
                ],
                "signature": "public jdk.incubator.vector.Vector slice(int, jdk.incubator.vector.Vector);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "addIndex",
                "parameters": [
                    "int"
                ],
                "signature": "public jdk.incubator.vector.Vector addIndex(int);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "blend",
                "parameters": [
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector blend(jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "compare",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Comparison",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.VectorMask compare(jdk.incubator.vector.VectorOperators$Comparison, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.VectorMask"
            },
            {
                "name": "lanewise",
                "parameters": [
                    "jdk.incubator.vector.VectorOperators$Ternary",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.Vector",
                    "jdk.incubator.vector.VectorMask"
                ],
                "signature": "public jdk.incubator.vector.Vector lanewise(jdk.incubator.vector.VectorOperators$Ternary, jdk.incubator.vector.Vector, jdk.incubator.vector.Vector, jdk.incubator.vector.VectorMask);",
                "return_type": "jdk.incubator.vector.Vector"
            },
            {
                "name": "lanewise",
                "parameters": [
