# Code Diff Review

**Code Diff Review** is a tool to help developers review their code differences by integrating with GitHub and an external API using OpenAI. It generates automated issues and publishes code analysis reports.

## Features

- Generate GitHub issues for code diffs
- Integrate with an external API for code analysis
- Publish detailed reports including commit messages, code diffs, and ACID analysis

## Installation

You can install the package using pip:

```sh
pip install code-diff-review
```

## Requirements

* Python 3.6+
* `cururo`
* `PyGithub`
* `requests`

## Usage

### Command Line Interface

After installation, you can use the `code-diff-review` command-line tool.

#### Basic Usage

```sh
code-diff-review --openai-key <OPENAI_API_KEY> --assistant-id <OPENAI_ASSISTANT_ID> --token <GH_TOKEN> --repo <REPO> --message <COMMIT_MESSAGE> --gh-before <GH_BEFORE_SHA> --sha <COMMIT_SHA> --branch <BRANCH> --webhook <WEBHOOK_URL> --websecret <WEBSECRET_SECRET>
```

#### Arguments

- `--openai-key`: OpenAI API key (default: environment variable `OPENAI_API_KEY`)
- `--assistant-id`: OpenAI assistant ID (default: environment variable `OPENAI_ASSISTANT_ID`)
- `--token`: GitHub token (default: environment variable `GH_TOKEN`)
- `--repo`: Repository name (default: environment variable `REPO`)
- `--branch`: Branch of work (default: environment variable `BRANCH`)
- `--gh-before`: GitHub before SHA (default: environment variable `GH_BEFORE`)
- `--sha`: Commit SHA (default: environment variable `SHA`)
- `--message`: Commit message (default: environment variable `MESSAGE`)
- `--webhook`: Webhook URL (default: environment variable `WEBHOOK`)
- `--websecret`: Webhook secret (default: environment variable `WEBSECRET`)


### Example Workflow

1. **Prepare the environment**: Ensure all required environment variables are set or provide them directly as arguments.

2. **Generate a Git diff**: The script will automatically generate a Git diff between the provided SHAs.

3. **Analyze the diff with OpenAI**: The script uses OpenAI to analyze the commit message and diff.

4. **Publish the results**: The script publishes the results as a GitHub issue and to a specified webhook.

### Detailed Example

Below is a step-by-step example of how you might use the `code-diff-review` tool in a real scenario.

1. **Set environment variables** (optional):

    ```sh
    export OPENAI_API_KEY=your_openai_key
    export OPENAI_ASSISTANT_ID=your_assistant_id
    export GH_TOKEN=your_github_token
    export REPO=your_repo
    export MESSAGE="Initial commit"
    export GH_BEFORE=abc123
    export SHA=def456
    export BRANCH=branch
    export WEBHOOK=https://your.webhook.url
    export WEBSECRET=your_webhook_secret
    ```

2. **Run the tool**:

    ```sh
    code-diff-review
    ```

    Alternatively, you can pass arguments directly:

    ```sh
    code-diff-review \
        --openai-key your_openai_key \
        --assistant-id your_assistant_id \
        --token your_github_token \
        --repo your_repo \
        --message "Initial commit" \
        --gh-before abc123 \
        --sha def456 \
        --branch your_work_branch \
        --webhook https://your.webhook.url \
        --websecret your_webhook_secret
    ```

3. **Review the output**: The tool will create a GitHub issue with the analysis results and send the same information to the specified webhook.

## Development

To contribute to this project, follow these steps:

1. Clone the repository
2. Create a virtual environment: `python -m venv venv`
3. Activate the virtual environment:
   - On Windows: `venv\Scripts\activate`
   - On macOS/Linux: `source venv/bin/activate`
4. Install the dependencies: `pip install -r requirements.txt`
5. Make your changes and run the tests.

## License

This project is licensed under the MIT License. See the [LICENSE](LICENSE) file for details.

## Author

Agustin Rios - [arios6@uc.cl](mailto:arios6@uc.cl)

## Changelog

See the [CHANGELOG.md](CHANGELOG.md) file for details on changes in each version.
