"""Service layer for Code Knowledge Graph.

This module provides high-level services that orchestrate
storage, parsing, and analysis operations.
"""

from .stats import StatsService
from .project import ProjectService
from .function_analysis import (
    FunctionAnalysisService,
    FunctionRelation,
    FileAnalysis,
    FunctionRelationsResult,
)
from .related_context import (
    RelatedContextService,
    SignatureInfo,
    FileContext,
    RelatedCodeContext,
)
from .llm_provider import (
    LLMConfig,
    LLMProvider,
    OpenAICompatibleProvider,
    NoOpLLMProvider,
    create_llm_provider,
)
from .embedding_provider import (
    EmbeddingConfig,
    EmbeddingProviderType,
    EmbeddingProvider,
    OpenAIEmbeddingProvider,
    OllamaEmbeddingProvider,
    NoOpEmbeddingProvider,
    create_embedding_provider,
)
from .summarizer import (
    CodeSummarizer,
    CodeEntity,
    SummaryResult,
    SummarizationStats,
    create_summarizer,
)

__all__ = [
    "StatsService",
    "ProjectService",
    "FunctionAnalysisService",
    "FunctionRelation",
    "FileAnalysis",
    "FunctionRelationsResult",
    "RelatedContextService",
    "SignatureInfo",
    "FileContext",
    "RelatedCodeContext",
    # LLM Provider
    "LLMConfig",
    "LLMProvider",
    "OpenAICompatibleProvider",
    "NoOpLLMProvider",
    "create_llm_provider",
    # Embedding Provider
    "EmbeddingConfig",
    "EmbeddingProviderType",
    "EmbeddingProvider",
    "OpenAIEmbeddingProvider",
    "OllamaEmbeddingProvider",
    "NoOpEmbeddingProvider",
    "create_embedding_provider",
    # Summarizer
    "CodeSummarizer",
    "CodeEntity",
    "SummaryResult",
    "SummarizationStats",
    "create_summarizer",
]
