# code_size_analyzer_client-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 0.7.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import code_size_analyzer_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import code_size_analyzer_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import code_size_analyzer_client
from pprint import pprint
from code_size_analyzer_client.api import analyzer_api
from code_size_analyzer_client.model.http_validation_error import HTTPValidationError
from code_size_analyzer_client.model.map_file_request import MapFileRequest
from code_size_analyzer_client.model.map_file_response import MapFileResponse
# Defining the host is optional and defaults to https://code-size-analyzer.silabs.net
# See configuration.py for a list of all supported configuration parameters.
configuration = code_size_analyzer_client.Configuration(
    host = "https://code-size-analyzer.silabs.net"
)



# Enter a context with an instance of the API client
with code_size_analyzer_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = analyzer_api.AnalyzerApi(api_client)
    map_file_request = MapFileRequest(
        map_file="map_file_example",
        stack_name="stack_name_example",
        target_part="target_part_example",
        target_board="target_board_example",
        app_name="app_name_example",
        compiler="compiler_example",
        project_file="project_file_example",
        project_file_name="project_file_name_example",
        branch_name="branch_name_example",
        build_number="build_number_example",
        commit="commit_example",
        store_results=True,
        build_url="build_url_example",
        classification_rules=[
            ClassificationRule(
                matcher="matcher_example",
                module="module_example",
                component="component_example",
                team_owner="team_owner_example",
            ),
        ],
        ignore_default_rules=False,
        uc_component_branch_name="uc_component_branch_name_example",
    ) # MapFileRequest | 

    try:
        # Analyze Map File Post
        api_response = api_instance.analyze_map_file(map_file_request)
        pprint(api_response)
    except code_size_analyzer_client.ApiException as e:
        print("Exception when calling AnalyzerApi->analyze_map_file: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://code-size-analyzer.silabs.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnalyzerApi* | [**analyze_map_file**](docs/AnalyzerApi.md#analyze_map_file) | **POST** /analyze_map_file | Analyze Map File Post
*DefaultApi* | [**metrics_health_get**](docs/DefaultApi.md#metrics_health_get) | **GET** /health | Metrics
*ParserApi* | [**parse_map_file**](docs/ParserApi.md#parse_map_file) | **POST** /parse_map_file | Analyze Map File Post
*ResultsApi* | [**get_app_analysis_details**](docs/ResultsApi.md#get_app_analysis_details) | **GET** /results/get_app_analysis_details | Get App Analysis Details
*ResultsApi* | [**get_app_combinations**](docs/ResultsApi.md#get_app_combinations) | **GET** /results/get_app_combinations | Get App Combinations
*ResultsApi* | [**get_app_stack_names**](docs/ResultsApi.md#get_app_stack_names) | **GET** /results/get_app_stack_names | Get App Stack Names
*ResultsApi* | [**get_app_summary_records**](docs/ResultsApi.md#get_app_summary_records) | **GET** /results/get_app_summary_records | Get App Summary Records
*ResultsApi* | [**get_branch_builds**](docs/ResultsApi.md#get_branch_builds) | **GET** /results/get_branch_builds | Get Branch Builds
*ResultsApi* | [**get_target_info**](docs/ResultsApi.md#get_target_info) | **GET** /results/get_target_info | Get Target Info


## Documentation For Models

 - [ApplicationAnalysisResultWithDetail](docs/ApplicationAnalysisResultWithDetail.md)
 - [ApplicationCombination](docs/ApplicationCombination.md)
 - [ClassificationRule](docs/ClassificationRule.md)
 - [DataRecord](docs/DataRecord.md)
 - [FileData](docs/FileData.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [MapFileMemoryConfig](docs/MapFileMemoryConfig.md)
 - [MapFileParseRequest](docs/MapFileParseRequest.md)
 - [MapFileParseResponse](docs/MapFileParseResponse.md)
 - [MapFileRequest](docs/MapFileRequest.md)
 - [MapFileResponse](docs/MapFileResponse.md)
 - [MapFileSection](docs/MapFileSection.md)
 - [MapFileSummary](docs/MapFileSummary.md)
 - [Module](docs/Module.md)
 - [ModuleGroup](docs/ModuleGroup.md)
 - [ResponseGetAppAnalysisDetailsResultsGetAppAnalysisDetailsGet](docs/ResponseGetAppAnalysisDetailsResultsGetAppAnalysisDetailsGet.md)
 - [SectionSummary](docs/SectionSummary.md)
 - [SummaryRecord](docs/SummaryRecord.md)
 - [Symbol](docs/Symbol.md)
 - [TargetInfo](docs/TargetInfo.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in code_size_analyzer_client.apis and code_size_analyzer_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from code_size_analyzer_client.api.default_api import DefaultApi`
- `from code_size_analyzer_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import code_size_analyzer_client
from code_size_analyzer_client.apis import *
from code_size_analyzer_client.models import *
```

