"""
FastAPI

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing_extensions import Self

from code_size_analyzer_client.models.classification_rule import ClassificationRule


class MapFileRequest(BaseModel):
    """
    MapFileRequest
    """  # noqa: E501

    map_file: StrictStr = Field(
        description="base64-encoded string representation of map file contents"
    )
    stack_name: StrictStr = Field(description="end product name; e.g. zigbee")
    target_part: StrictStr = Field(
        description="target part OPN; e.g. 'efr32mg22c224f512im40'"
    )
    target_board: StrictStr | None = None
    app_name: StrictStr | None = None
    compiler: StrictStr = Field(
        description="compiler that produced the map file.  Must be one of 'iar' or 'gcc'"
    )
    project_file: StrictStr | None = None
    project_file_name: StrictStr | None = None
    branch_name: StrictStr | None = None
    build_number: StrictStr | None = None
    commit: StrictStr | None = None
    store_results: StrictBool | None = None
    build_url: StrictStr | None = None
    classification_rules: list[ClassificationRule] | None = None
    ignore_default_rules: StrictBool | None = None
    uc_component_branch_name: StrictStr | None = None
    code_size_upper_threshold: StrictInt | None = None
    code_size_lower_threshold: StrictInt | None = None
    ram_size_upper_threshold: StrictInt | None = None
    ram_size_lower_threshold: StrictInt | None = None
    code_size_absolute_upper_threshold: StrictInt | None = None
    code_size_absolute_lower_threshold: StrictInt | None = None
    ram_size_absolute_upper_threshold: StrictInt | None = None
    ram_size_absolute_lower_threshold: StrictInt | None = None
    alert_notification_topic_id: StrictStr | None = None
    dynamic_ram: StrictInt | None = None
    __properties: ClassVar[list[str]] = [
        "map_file",
        "stack_name",
        "target_part",
        "target_board",
        "app_name",
        "compiler",
        "project_file",
        "project_file_name",
        "branch_name",
        "build_number",
        "commit",
        "store_results",
        "build_url",
        "classification_rules",
        "ignore_default_rules",
        "uc_component_branch_name",
        "code_size_upper_threshold",
        "code_size_lower_threshold",
        "ram_size_upper_threshold",
        "ram_size_lower_threshold",
        "code_size_absolute_upper_threshold",
        "code_size_absolute_lower_threshold",
        "ram_size_absolute_upper_threshold",
        "ram_size_absolute_lower_threshold",
        "alert_notification_topic_id",
        "dynamic_ram",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self | None:
        """Create an instance of MapFileRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in classification_rules (list)
        _items = []
        if self.classification_rules:
            for _item_classification_rules in self.classification_rules:
                if _item_classification_rules:
                    _items.append(_item_classification_rules.to_dict())
            _dict["classification_rules"] = _items
        # set to None if target_board (nullable) is None
        # and model_fields_set contains the field
        if self.target_board is None and "target_board" in self.model_fields_set:
            _dict["target_board"] = None

        # set to None if app_name (nullable) is None
        # and model_fields_set contains the field
        if self.app_name is None and "app_name" in self.model_fields_set:
            _dict["app_name"] = None

        # set to None if project_file (nullable) is None
        # and model_fields_set contains the field
        if self.project_file is None and "project_file" in self.model_fields_set:
            _dict["project_file"] = None

        # set to None if project_file_name (nullable) is None
        # and model_fields_set contains the field
        if (
            self.project_file_name is None
            and "project_file_name" in self.model_fields_set
        ):
            _dict["project_file_name"] = None

        # set to None if branch_name (nullable) is None
        # and model_fields_set contains the field
        if self.branch_name is None and "branch_name" in self.model_fields_set:
            _dict["branch_name"] = None

        # set to None if build_number (nullable) is None
        # and model_fields_set contains the field
        if self.build_number is None and "build_number" in self.model_fields_set:
            _dict["build_number"] = None

        # set to None if commit (nullable) is None
        # and model_fields_set contains the field
        if self.commit is None and "commit" in self.model_fields_set:
            _dict["commit"] = None

        # set to None if store_results (nullable) is None
        # and model_fields_set contains the field
        if self.store_results is None and "store_results" in self.model_fields_set:
            _dict["store_results"] = None

        # set to None if build_url (nullable) is None
        # and model_fields_set contains the field
        if self.build_url is None and "build_url" in self.model_fields_set:
            _dict["build_url"] = None

        # set to None if classification_rules (nullable) is None
        # and model_fields_set contains the field
        if (
            self.classification_rules is None
            and "classification_rules" in self.model_fields_set
        ):
            _dict["classification_rules"] = None

        # set to None if ignore_default_rules (nullable) is None
        # and model_fields_set contains the field
        if (
            self.ignore_default_rules is None
            and "ignore_default_rules" in self.model_fields_set
        ):
            _dict["ignore_default_rules"] = None

        # set to None if uc_component_branch_name (nullable) is None
        # and model_fields_set contains the field
        if (
            self.uc_component_branch_name is None
            and "uc_component_branch_name" in self.model_fields_set
        ):
            _dict["uc_component_branch_name"] = None

        # set to None if code_size_upper_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.code_size_upper_threshold is None
            and "code_size_upper_threshold" in self.model_fields_set
        ):
            _dict["code_size_upper_threshold"] = None

        # set to None if code_size_lower_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.code_size_lower_threshold is None
            and "code_size_lower_threshold" in self.model_fields_set
        ):
            _dict["code_size_lower_threshold"] = None

        # set to None if ram_size_upper_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.ram_size_upper_threshold is None
            and "ram_size_upper_threshold" in self.model_fields_set
        ):
            _dict["ram_size_upper_threshold"] = None

        # set to None if ram_size_lower_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.ram_size_lower_threshold is None
            and "ram_size_lower_threshold" in self.model_fields_set
        ):
            _dict["ram_size_lower_threshold"] = None

        # set to None if code_size_absolute_upper_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.code_size_absolute_upper_threshold is None
            and "code_size_absolute_upper_threshold" in self.model_fields_set
        ):
            _dict["code_size_absolute_upper_threshold"] = None

        # set to None if code_size_absolute_lower_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.code_size_absolute_lower_threshold is None
            and "code_size_absolute_lower_threshold" in self.model_fields_set
        ):
            _dict["code_size_absolute_lower_threshold"] = None

        # set to None if ram_size_absolute_upper_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.ram_size_absolute_upper_threshold is None
            and "ram_size_absolute_upper_threshold" in self.model_fields_set
        ):
            _dict["ram_size_absolute_upper_threshold"] = None

        # set to None if ram_size_absolute_lower_threshold (nullable) is None
        # and model_fields_set contains the field
        if (
            self.ram_size_absolute_lower_threshold is None
            and "ram_size_absolute_lower_threshold" in self.model_fields_set
        ):
            _dict["ram_size_absolute_lower_threshold"] = None

        # set to None if alert_notification_topic_id (nullable) is None
        # and model_fields_set contains the field
        if (
            self.alert_notification_topic_id is None
            and "alert_notification_topic_id" in self.model_fields_set
        ):
            _dict["alert_notification_topic_id"] = None

        # set to None if dynamic_ram (nullable) is None
        # and model_fields_set contains the field
        if self.dynamic_ram is None and "dynamic_ram" in self.model_fields_set:
            _dict["dynamic_ram"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict[str, Any] | None) -> Self | None:
        """Create an instance of MapFileRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "map_file": obj.get("map_file"),
                "stack_name": obj.get("stack_name"),
                "target_part": obj.get("target_part"),
                "target_board": obj.get("target_board"),
                "app_name": obj.get("app_name"),
                "compiler": obj.get("compiler"),
                "project_file": obj.get("project_file"),
                "project_file_name": obj.get("project_file_name"),
                "branch_name": obj.get("branch_name"),
                "build_number": obj.get("build_number"),
                "commit": obj.get("commit"),
                "store_results": obj.get("store_results"),
                "build_url": obj.get("build_url"),
                "classification_rules": [
                    ClassificationRule.from_dict(_item)
                    for _item in obj["classification_rules"]
                ]
                if obj.get("classification_rules") is not None
                else None,
                "ignore_default_rules": obj.get("ignore_default_rules"),
                "uc_component_branch_name": obj.get("uc_component_branch_name"),
                "code_size_upper_threshold": obj.get("code_size_upper_threshold"),
                "code_size_lower_threshold": obj.get("code_size_lower_threshold"),
                "ram_size_upper_threshold": obj.get("ram_size_upper_threshold"),
                "ram_size_lower_threshold": obj.get("ram_size_lower_threshold"),
                "code_size_absolute_upper_threshold": obj.get(
                    "code_size_absolute_upper_threshold"
                ),
                "code_size_absolute_lower_threshold": obj.get(
                    "code_size_absolute_lower_threshold"
                ),
                "ram_size_absolute_upper_threshold": obj.get(
                    "ram_size_absolute_upper_threshold"
                ),
                "ram_size_absolute_lower_threshold": obj.get(
                    "ram_size_absolute_lower_threshold"
                ),
                "alert_notification_topic_id": obj.get("alert_notification_topic_id"),
                "dynamic_ram": obj.get("dynamic_ram"),
            }
        )
        return _obj
