# code_size_analyzer_client-python
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.2.0a0
- Generator version: 7.15.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import code_size_analyzer_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import code_size_analyzer_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import code_size_analyzer_client
from code_size_analyzer_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://code-size-analyzer.silabs.net
# See configuration.py for a list of all supported configuration parameters.
configuration = code_size_analyzer_client.Configuration(
    host = "https://code-size-analyzer.silabs.net"
)



# Enter a context with an instance of the API client
with code_size_analyzer_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = code_size_analyzer_client.AnalyzerApi(api_client)
    map_file_request = code_size_analyzer_client.MapFileRequest() # MapFileRequest | 

    try:
        # Analyze Map File Post
        api_response = api_instance.analyze_map_file(map_file_request)
        print("The response of AnalyzerApi->analyze_map_file:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnalyzerApi->analyze_map_file: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://code-size-analyzer.silabs.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnalyzerApi* | [**analyze_map_file**](docs/AnalyzerApi.md#analyze_map_file) | **POST** /analyze_map_file | Analyze Map File Post
*AsyncapiApi* | [**download_app_json_schema_asyncapi_json_get**](docs/AsyncapiApi.md#download_app_json_schema_asyncapi_json_get) | **GET** /asyncapi.json | Download App Json Schema
*AsyncapiApi* | [**download_app_yaml_schema_asyncapi_yaml_get**](docs/AsyncapiApi.md#download_app_yaml_schema_asyncapi_yaml_get) | **GET** /asyncapi.yaml | Download App Yaml Schema
*AsyncapiApi* | [**serve_asyncapi_schema_asyncapi_get**](docs/AsyncapiApi.md#serve_asyncapi_schema_asyncapi_get) | **GET** /asyncapi | Serve Asyncapi Schema
*DefaultApi* | [**metrics_health_get**](docs/DefaultApi.md#metrics_health_get) | **GET** /health | Metrics
*ParserApi* | [**parse_map_file**](docs/ParserApi.md#parse_map_file) | **POST** /parse_map_file | Analyze Map File Post
*ResultsApi* | [**get_app_analysis_details**](docs/ResultsApi.md#get_app_analysis_details) | **GET** /results/get_app_analysis_details | Get App Analysis Details
*ResultsApi* | [**get_app_combinations**](docs/ResultsApi.md#get_app_combinations) | **GET** /results/get_app_combinations | Get App Combinations
*ResultsApi* | [**get_app_stack_names**](docs/ResultsApi.md#get_app_stack_names) | **GET** /results/get_app_stack_names | Get App Stack Names
*ResultsApi* | [**get_app_summary_records**](docs/ResultsApi.md#get_app_summary_records) | **GET** /results/get_app_summary_records | Get App Summary Records
*ResultsApi* | [**get_branch_builds**](docs/ResultsApi.md#get_branch_builds) | **GET** /results/get_branch_builds | Get Branch Builds
*ResultsApi* | [**get_target_info**](docs/ResultsApi.md#get_target_info) | **GET** /results/get_target_info | Get Target Info


## Documentation For Models

 - [ApplicationAnalysisResultWithDetail](docs/ApplicationAnalysisResultWithDetail.md)
 - [ApplicationCombination](docs/ApplicationCombination.md)
 - [ClassificationRule](docs/ClassificationRule.md)
 - [DataRecord](docs/DataRecord.md)
 - [FileData](docs/FileData.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [MapFileMemoryConfig](docs/MapFileMemoryConfig.md)
 - [MapFileParseRequest](docs/MapFileParseRequest.md)
 - [MapFileParseResponse](docs/MapFileParseResponse.md)
 - [MapFileRequest](docs/MapFileRequest.md)
 - [MapFileResponse](docs/MapFileResponse.md)
 - [MapFileSection](docs/MapFileSection.md)
 - [MapFileSummary](docs/MapFileSummary.md)
 - [Module](docs/Module.md)
 - [ModuleGroup](docs/ModuleGroup.md)
 - [ResponseGetAppAnalysisDetails](docs/ResponseGetAppAnalysisDetails.md)
 - [SectionSummary](docs/SectionSummary.md)
 - [SummaryRecord](docs/SummaryRecord.md)
 - [Symbol](docs/Symbol.md)
 - [TargetInfo](docs/TargetInfo.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




