"""
FastAPI

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from datetime import datetime
from typing import Any, ClassVar

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing_extensions import Self

from code_size_analyzer_client.models.file_data import FileData
from code_size_analyzer_client.models.section_summary import SectionSummary


class ApplicationAnalysisResultWithDetail(BaseModel):
    """
    ApplicationAnalysisResultWithDetail
    """  # noqa: E501

    build_number: StrictStr
    build_sequence: StrictInt
    branch: StrictStr
    build_name: StrictStr
    board: StrictStr
    application_name: StrictStr
    stack: StrictStr
    compiler: StrictStr
    compiler_options: dict[str, Any] | None = None
    target: StrictStr
    row_create_date_time: datetime
    summary_json: dict[str, SectionSummary]
    summary_ext_json: dict[str, SectionSummary] | None
    sdk_commit_hash: StrictStr | None
    file_data: list[FileData]
    uc_summary_json: dict[str, SectionSummary] | None = None
    __properties: ClassVar[list[str]] = [
        "build_number",
        "build_sequence",
        "branch",
        "build_name",
        "board",
        "application_name",
        "stack",
        "compiler",
        "compiler_options",
        "target",
        "row_create_date_time",
        "summary_json",
        "summary_ext_json",
        "sdk_commit_hash",
        "file_data",
        "uc_summary_json",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self | None:
        """Create an instance of ApplicationAnalysisResultWithDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in summary_json (dict)
        _field_dict = {}
        if self.summary_json:
            for _key_summary_json in self.summary_json:
                if self.summary_json[_key_summary_json]:
                    _field_dict[_key_summary_json] = self.summary_json[
                        _key_summary_json
                    ].to_dict()
            _dict["summary_json"] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in summary_ext_json (dict)
        _field_dict = {}
        if self.summary_ext_json:
            for _key_summary_ext_json in self.summary_ext_json:
                if self.summary_ext_json[_key_summary_ext_json]:
                    _field_dict[_key_summary_ext_json] = self.summary_ext_json[
                        _key_summary_ext_json
                    ].to_dict()
            _dict["summary_ext_json"] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in file_data (list)
        _items = []
        if self.file_data:
            for _item_file_data in self.file_data:
                if _item_file_data:
                    _items.append(_item_file_data.to_dict())
            _dict["file_data"] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in uc_summary_json (dict)
        _field_dict = {}
        if self.uc_summary_json:
            for _key_uc_summary_json in self.uc_summary_json:
                if self.uc_summary_json[_key_uc_summary_json]:
                    _field_dict[_key_uc_summary_json] = self.uc_summary_json[
                        _key_uc_summary_json
                    ].to_dict()
            _dict["uc_summary_json"] = _field_dict
        # set to None if compiler_options (nullable) is None
        # and model_fields_set contains the field
        if (
            self.compiler_options is None
            and "compiler_options" in self.model_fields_set
        ):
            _dict["compiler_options"] = None

        # set to None if summary_ext_json (nullable) is None
        # and model_fields_set contains the field
        if (
            self.summary_ext_json is None
            and "summary_ext_json" in self.model_fields_set
        ):
            _dict["summary_ext_json"] = None

        # set to None if sdk_commit_hash (nullable) is None
        # and model_fields_set contains the field
        if self.sdk_commit_hash is None and "sdk_commit_hash" in self.model_fields_set:
            _dict["sdk_commit_hash"] = None

        # set to None if uc_summary_json (nullable) is None
        # and model_fields_set contains the field
        if self.uc_summary_json is None and "uc_summary_json" in self.model_fields_set:
            _dict["uc_summary_json"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict[str, Any] | None) -> Self | None:
        """Create an instance of ApplicationAnalysisResultWithDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "build_number": obj.get("build_number"),
                "build_sequence": obj.get("build_sequence"),
                "branch": obj.get("branch"),
                "build_name": obj.get("build_name"),
                "board": obj.get("board"),
                "application_name": obj.get("application_name"),
                "stack": obj.get("stack"),
                "compiler": obj.get("compiler"),
                "compiler_options": obj.get("compiler_options"),
                "target": obj.get("target"),
                "row_create_date_time": obj.get("row_create_date_time"),
                "summary_json": dict(
                    (_k, SectionSummary.from_dict(_v))
                    for _k, _v in obj["summary_json"].items()
                )
                if obj.get("summary_json") is not None
                else None,
                "summary_ext_json": dict(
                    (_k, SectionSummary.from_dict(_v))
                    for _k, _v in obj["summary_ext_json"].items()
                )
                if obj.get("summary_ext_json") is not None
                else None,
                "sdk_commit_hash": obj.get("sdk_commit_hash"),
                "file_data": [FileData.from_dict(_item) for _item in obj["file_data"]]
                if obj.get("file_data") is not None
                else None,
                "uc_summary_json": dict(
                    (_k, SectionSummary.from_dict(_v))
                    for _k, _v in obj["uc_summary_json"].items()
                )
                if obj.get("uc_summary_json") is not None
                else None,
            }
        )
        return _obj
