#!/usr/bin/python
'''
This program converts all the comments in your code to a README.md file and saves a lot of your time provided you write comments in your code. It is obvious how easy it is to actually generate the README.md file and save your time.Using the argparse module to get the file path. Note that to run the file
```bash
python main.py -p <path to file>
```

'''
#The readme for this program is also generated by the code itself except the images added.
import argparse
import re

#adds arguments
parser = argparse.ArgumentParser()
parser.add_argument("-p", type=str, help="enter the file path")
parser.add_argument("-o", type=str, help="enter the output path. Empty quotes for same directory")

args = parser.parse_args()
print("Hi there, it's nice to meet you! This will convert your code to a README.md")
file = open(args.p, 'r')
f = file.readlines()

#To find Block Comments
def blockComm():
    p = [(x, f[x][0]) for x in range(len(f))]
    fip = []
    for a in range(len(p)):
        try:
            if p[a][1] == "'":
                fip.append(a)
        except IndexError:
            pass

    fip = [[fip[x], fip[x + 1]] for x in range(0, len(fip) - 1, 2)]
    contents = []
    sidecomm = []
    blockcomm = [''.join(f[x[0] + 1:x[1]]).strip() for x in fip]
    return blockcomm
'''
For now this program only supports python.
'''

# find the side comments and create contents list
def content_sidecomm():
    contents = []
    sidecomm = []
    for a in range(0, len(f)):
        finder = f[a].find('#')
        try:
            if finder != -1:
                if finder == 0:
                    # fin_out.write('### {}\n'.format(f[a][1::]).upper())
                    contents.append(f[a][1::].upper())
                else:
                    # fin_out.write('> {}\n'.format(f[a][finder+1::]).capitalize())
                    sidecomm.append(f[a][finder + 1::].capitalize())
        except IndexError:
            pass

    return [contents, sidecomm]

# Format the file and save
def main():
    print('Convertion Start!')
    #initial file
    fin_out = open(args.o+'README.md', 'w+')  #output file
    fin_out.write('# README\n')
    fin_out.write('## Contents\n')
    cs = content_sidecomm()
    for a in range(len(cs[0])):
        fin_out.write('{}. {}\n'.format(a+1,cs[0][a]))
    fin_out.write('## Docstrings\n')
    bc = blockComm()
    for a in range(len(bc)):
        fin_out.write('>{}\n'.format(bc[a]))

    fin_out.write('## Side comments\n')
    for a in range(len(cs[1])):
        fin_out.write('- {}\n'.format(cs[1][a]))


    fin_out.close()
    print('Done!')

main()
