# Contribute

Great that you see this page and want to contribute!

:::{tip}
All contributions are welcome!
Think of corrections on the manual, code and more or better tests.
:::

The **Codeaudit** code repository is hosted at [Github](github.com/nocomplexity/codeaudit).

Simple Guidelines:

* Questions, Feature Requests, Bug Reports should all be reported on the [Github Issue Tracker](https://github.com/nocomplexity/codeaudit/issues) .
* [Black](https://black.readthedocs.io/en/stable/index.html) is used for code style. But for a simple fix, using `Black` is not required!

This codeaudit tool is designed by applying [Zero Complexity By Design principles](https://nocomplexity.com/documents/0complexity/abstract.html). So the goal is to keep the tool simple to use and the code simple to adjust or to extend.

:::{warning}
This simple tool is designed to be simple to use and maintain. 
:::

**Pull Requests are welcome!** 

When you contribute to Codeaudit, your contributions are made under the same license as the file you are working on. 


We adopt the [Collective Code Construction Contract(C4)](https://rfc.zeromq.org/spec/42/) to streamline collaboration. C4 is meant to provide a reusable optimal collaboration model for open source software projects. 

:::{attention} 
This project values respect and inclusiveness, and enforces a [Code of Conduct](CoC-label) in all interactions.
:::


:::{note} 
This is an open community driven project. Contributors will be mentioned in the documentation.
:::

(CoC-label)=
## Code of Conduct

Version : 1.0 

As contributors, maintainers, administrators and founders of the Python Codeaudit Community projects, and in the interest of fostering an open and welcoming community, we pledge to respect all people who contribute through reporting issues, posting feature requests, updating documentation, submitting pull requests or patches, and other activities.

We are committed to making participation in this project a harassment-free experience for everyone, regardless of level of experience, gender, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, religion, or nationality.

Examples of unacceptable behavior by participants include:
*    The use of sexualized language or imagery.
*    Personal attacks.
*    Trolling or insulting/derogatory comments.
*    Public or private harassment.
*    Publishing other’s private information, such as physical or electronic addresses, without explicit permission.
*    Other unethical or unprofessional conduct.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, documentation edits, issues, and other contributions that are not aligned to this Code of Conduct. 

By adopting this Code of Conduct, project maintainers commit themselves to fairly and consistently applying these principles to every aspect of managing this project. Project maintainers who do not follow or enforce the Code of Conduct may be permanently removed from the project team.

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by opening an issue or contacting one or more of the project maintainers.

This code of conduct applies both within project spaces and in public spaces when an individual is representing the project or its community.

This Code of Conduct is adapted from the [Contributor Covenant](http://contributor-covenant.org), version 1.2.0, available at [http://contributor-covenant.org/version/1/2/0/](https://www.contributor-covenant.org/version/1/2/0/code-of-conduct/).