# APIs and Examples

The Python Code Audit APIs empower you to build your own Python security tools or create seamless integrations you need! Leverage our standardized JSON output to enhance your development workflow in the following ways:

* **Automated Scanning**: Perform deep security analysis on local files, directories, or PyPI.org packages. Use the structured JSON output to trigger custom logic or automated remediation.

+++

* **Custom Reporting & Dashboards**: Transform audit results into visual insights. The human-readable JSON export makes it easy to feed data into custom monitoring dashboards or BI tools.

+++


* **Security Statistical Analysis**: Identify trends and recurring vulnerabilities. Use the APIs to study security weaknesses across your organization’s entire Python ecosystem to improve coding standards.

+++


* **Seamless CI/CD Integration**: Embed security audits directly into your deployment pipelines. The APIs fully support remote source control systems, including GitHub, GitLab, [Codeberg](https://codeberg.org/), [NotABug](https://notabug.org/), and other Git-based platforms.

## Getting Started
We have provided several practical examples to help you implement these APIs effectively and secure your codebase with minimal friction.


```{tableofcontents}
```
