"""
This file contains the schema for the CodeBox API.
It is used to validate the data returned from the API.
It also helps with type hinting and provides a nice
interface for interacting with the API.
"""

from typing import Optional

from pydantic import BaseModel


class CodeBoxStatus(BaseModel):
    """
    Represents the status of a CodeBox instance.
    """

    status: str

    def __str__(self):
        return self.status

    def __repr__(self):
        return f"Status({self.status})"


class CodeBoxOutput(BaseModel):
    """
    Represents the code execution output of a CodeBox instance.
    """

    type: str
    content: str

    def __str__(self):
        return self.content

    def __repr__(self):
        return f"{self.type}({self.content})"


class CodeBoxFile(BaseModel):
    """
    Represents a file returned from a CodeBox instance.
    """

    name: str
    content: Optional[bytes] = None

    def __str__(self):
        return self.name

    def __repr__(self):
        return f"File({self.name})"
