#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 1616
#define LARGE_STATE_COUNT 293
#define SYMBOL_COUNT 249
#define ALIAS_COUNT 6
#define TOKEN_COUNT 128
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 38
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 110

enum {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_LBRACE = 6,
  anon_sym_COMMA = 7,
  anon_sym_RBRACE = 8,
  anon_sym_as = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_var = 12,
  anon_sym_let = 13,
  anon_sym_const = 14,
  anon_sym_else = 15,
  anon_sym_if = 16,
  anon_sym_switch = 17,
  anon_sym_for = 18,
  anon_sym_LPAREN = 19,
  anon_sym_RPAREN = 20,
  anon_sym_await = 21,
  anon_sym_in = 22,
  anon_sym_of = 23,
  anon_sym_while = 24,
  anon_sym_do = 25,
  anon_sym_try = 26,
  anon_sym_with = 27,
  anon_sym_break = 28,
  anon_sym_continue = 29,
  anon_sym_debugger = 30,
  anon_sym_return = 31,
  anon_sym_throw = 32,
  anon_sym_SEMI = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  sym__glimmer_template_content = 42,
  anon_sym_LTtemplate_GT = 43,
  anon_sym_LT_SLASHtemplate_GT = 44,
  anon_sym_LT = 45,
  anon_sym_GT = 46,
  anon_sym_SLASH = 47,
  sym_jsx_text = 48,
  sym_jsx_identifier = 49,
  anon_sym_DOT = 50,
  anon_sym_class = 51,
  anon_sym_extends = 52,
  anon_sym_async = 53,
  anon_sym_function = 54,
  anon_sym_EQ_GT = 55,
  sym_optional_chain = 56,
  anon_sym_new = 57,
  anon_sym_PLUS_EQ = 58,
  anon_sym_DASH_EQ = 59,
  anon_sym_STAR_EQ = 60,
  anon_sym_SLASH_EQ = 61,
  anon_sym_PERCENT_EQ = 62,
  anon_sym_CARET_EQ = 63,
  anon_sym_AMP_EQ = 64,
  anon_sym_PIPE_EQ = 65,
  anon_sym_GT_GT_EQ = 66,
  anon_sym_GT_GT_GT_EQ = 67,
  anon_sym_LT_LT_EQ = 68,
  anon_sym_STAR_STAR_EQ = 69,
  anon_sym_AMP_AMP_EQ = 70,
  anon_sym_PIPE_PIPE_EQ = 71,
  anon_sym_QMARK_QMARK_EQ = 72,
  anon_sym_DOT_DOT_DOT = 73,
  anon_sym_AMP_AMP = 74,
  anon_sym_PIPE_PIPE = 75,
  anon_sym_GT_GT = 76,
  anon_sym_GT_GT_GT = 77,
  anon_sym_LT_LT = 78,
  anon_sym_AMP = 79,
  anon_sym_CARET = 80,
  anon_sym_PIPE = 81,
  anon_sym_PLUS = 82,
  anon_sym_DASH = 83,
  anon_sym_PERCENT = 84,
  anon_sym_STAR_STAR = 85,
  anon_sym_LT_EQ = 86,
  anon_sym_EQ_EQ = 87,
  anon_sym_EQ_EQ_EQ = 88,
  anon_sym_BANG_EQ = 89,
  anon_sym_BANG_EQ_EQ = 90,
  anon_sym_GT_EQ = 91,
  anon_sym_QMARK_QMARK = 92,
  anon_sym_instanceof = 93,
  anon_sym_BANG = 94,
  anon_sym_TILDE = 95,
  anon_sym_typeof = 96,
  anon_sym_void = 97,
  anon_sym_delete = 98,
  anon_sym_PLUS_PLUS = 99,
  anon_sym_DASH_DASH = 100,
  anon_sym_DQUOTE = 101,
  anon_sym_SQUOTE = 102,
  sym_unescaped_double_string_fragment = 103,
  sym_unescaped_single_string_fragment = 104,
  sym_escape_sequence = 105,
  sym_comment = 106,
  anon_sym_BQUOTE = 107,
  anon_sym_DOLLAR_LBRACE = 108,
  anon_sym_SLASH2 = 109,
  sym_regex_pattern = 110,
  sym_regex_flags = 111,
  sym_number = 112,
  sym_private_property_identifier = 113,
  anon_sym_target = 114,
  sym_this = 115,
  sym_super = 116,
  sym_true = 117,
  sym_false = 118,
  sym_null = 119,
  sym_undefined = 120,
  anon_sym_AT = 121,
  anon_sym_static = 122,
  anon_sym_get = 123,
  anon_sym_set = 124,
  sym__automatic_semicolon = 125,
  sym__template_chars = 126,
  sym__ternary_qmark = 127,
  sym_program = 128,
  sym_export_statement = 129,
  sym_export_clause = 130,
  sym__import_export_specifier = 131,
  sym_declaration = 132,
  sym_import = 133,
  sym_import_statement = 134,
  sym_import_clause = 135,
  sym__from_clause = 136,
  sym_namespace_import_export = 137,
  sym_named_imports = 138,
  sym_expression_statement = 139,
  sym_variable_declaration = 140,
  sym_lexical_declaration = 141,
  sym_variable_declarator = 142,
  sym_statement_block = 143,
  sym_else_clause = 144,
  sym_if_statement = 145,
  sym_switch_statement = 146,
  sym_for_statement = 147,
  sym_for_in_statement = 148,
  sym__for_header = 149,
  sym_while_statement = 150,
  sym_do_statement = 151,
  sym_try_statement = 152,
  sym_with_statement = 153,
  sym_break_statement = 154,
  sym_continue_statement = 155,
  sym_debugger_statement = 156,
  sym_return_statement = 157,
  sym_throw_statement = 158,
  sym_empty_statement = 159,
  sym_labeled_statement = 160,
  sym_switch_body = 161,
  sym_switch_case = 162,
  sym_switch_default = 163,
  sym_catch_clause = 164,
  sym_finally_clause = 165,
  sym_parenthesized_expression = 166,
  sym_expression = 167,
  sym_primary_expression = 168,
  sym_yield_expression = 169,
  sym_object = 170,
  sym_object_pattern = 171,
  sym_assignment_pattern = 172,
  sym_object_assignment_pattern = 173,
  sym_array = 174,
  sym_array_pattern = 175,
  sym_glimmer_template = 176,
  sym_glimmer_opening_tag = 177,
  sym_glimmer_closing_tag = 178,
  sym_jsx_element = 179,
  sym_jsx_fragment = 180,
  sym_jsx_expression = 181,
  sym_jsx_opening_element = 182,
  sym_nested_identifier = 183,
  sym_jsx_namespace_name = 184,
  sym_jsx_closing_element = 185,
  sym_jsx_self_closing_element = 186,
  sym_jsx_attribute = 187,
  sym_class = 188,
  sym_class_declaration = 189,
  sym_class_heritage = 190,
  sym_function = 191,
  sym_function_declaration = 192,
  sym_generator_function = 193,
  sym_generator_function_declaration = 194,
  sym_arrow_function = 195,
  sym_call_expression = 196,
  sym_new_expression = 197,
  sym_await_expression = 198,
  sym_member_expression = 199,
  sym_subscript_expression = 200,
  sym_assignment_expression = 201,
  sym__augmented_assignment_lhs = 202,
  sym_augmented_assignment_expression = 203,
  sym__initializer = 204,
  sym__destructuring_pattern = 205,
  sym_spread_element = 206,
  sym_ternary_expression = 207,
  sym_binary_expression = 208,
  sym_unary_expression = 209,
  sym_update_expression = 210,
  sym_sequence_expression = 211,
  sym_string = 212,
  sym_template_string = 213,
  sym_template_substitution = 214,
  sym_regex = 215,
  sym_meta_property = 216,
  sym_arguments = 217,
  sym_decorator = 218,
  sym_decorator_member_expression = 219,
  sym_decorator_call_expression = 220,
  sym_class_body = 221,
  sym_field_definition = 222,
  sym_formal_parameters = 223,
  sym_pattern = 224,
  sym_rest_pattern = 225,
  sym_method_definition = 226,
  sym_pair = 227,
  sym_pair_pattern = 228,
  sym__property_name = 229,
  sym_computed_property_name = 230,
  aux_sym_program_repeat1 = 231,
  aux_sym_export_statement_repeat1 = 232,
  aux_sym_export_clause_repeat1 = 233,
  aux_sym_named_imports_repeat1 = 234,
  aux_sym_variable_declaration_repeat1 = 235,
  aux_sym_switch_body_repeat1 = 236,
  aux_sym_object_repeat1 = 237,
  aux_sym_object_pattern_repeat1 = 238,
  aux_sym_array_repeat1 = 239,
  aux_sym_array_pattern_repeat1 = 240,
  aux_sym_glimmer_template_repeat1 = 241,
  aux_sym_jsx_element_repeat1 = 242,
  aux_sym_jsx_opening_element_repeat1 = 243,
  aux_sym_string_repeat1 = 244,
  aux_sym_string_repeat2 = 245,
  aux_sym_template_string_repeat1 = 246,
  aux_sym_class_body_repeat1 = 247,
  aux_sym_formal_parameters_repeat1 = 248,
  alias_sym_import_specifier = 249,
  alias_sym_namespace_export = 250,
  alias_sym_property_identifier = 251,
  alias_sym_shorthand_property_identifier = 252,
  alias_sym_shorthand_property_identifier_pattern = 253,
  alias_sym_statement_identifier = 254,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_with] = "with",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__glimmer_template_content] = "_glimmer_template_content",
  [anon_sym_LTtemplate_GT] = "<template>",
  [anon_sym_LT_SLASHtemplate_GT] = "</template>",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_SLASH] = "/",
  [sym_jsx_text] = "jsx_text",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [sym_optional_chain] = "optional_chain",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "_template_chars",
  [sym__ternary_qmark] = "\?",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_export_clause] = "export_clause",
  [sym__import_export_specifier] = "export_specifier",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import_export] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_fragment] = "jsx_fragment",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "nested_identifier",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function] = "function",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_field_definition] = "field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_glimmer_template_repeat1] = "glimmer_template_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_import_specifier] = "import_specifier",
  [alias_sym_namespace_export] = "namespace_export",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__glimmer_template_content] = sym__glimmer_template_content,
  [anon_sym_LTtemplate_GT] = anon_sym_LTtemplate_GT,
  [anon_sym_LT_SLASHtemplate_GT] = anon_sym_LT_SLASHtemplate_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [sym_jsx_text] = sym_jsx_text,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [sym_optional_chain] = sym_optional_chain,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = sym__ternary_qmark,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_export_clause] = sym_export_clause,
  [sym__import_export_specifier] = sym__import_export_specifier,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import_export] = sym_namespace_import_export,
  [sym_named_imports] = sym_named_imports,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_fragment] = sym_jsx_fragment,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_nested_identifier,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function] = sym_function,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_field_definition] = sym_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_glimmer_template_repeat1] = aux_sym_glimmer_template_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_import_specifier] = alias_sym_import_specifier,
  [alias_sym_namespace_export] = alias_sym_namespace_export,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__glimmer_template_content] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_LTtemplate_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASHtemplate_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = false,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__import_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import_export] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glimmer_template_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_content = 11,
  field_declaration = 12,
  field_decorator = 13,
  field_finalizer = 14,
  field_flags = 15,
  field_function = 16,
  field_handler = 17,
  field_increment = 18,
  field_index = 19,
  field_initializer = 20,
  field_key = 21,
  field_kind = 22,
  field_label = 23,
  field_left = 24,
  field_member = 25,
  field_name = 26,
  field_object = 27,
  field_open_tag = 28,
  field_operator = 29,
  field_optional_chain = 30,
  field_parameter = 31,
  field_parameters = 32,
  field_pattern = 33,
  field_property = 34,
  field_right = 35,
  field_source = 36,
  field_template = 37,
  field_value = 38,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_template] = "template",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 1},
  [8] = {.index = 5, .length = 2},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 1},
  [23] = {.index = 26, .length = 2},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 6},
  [26] = {.index = 36, .length = 2},
  [27] = {.index = 38, .length = 2},
  [28] = {.index = 40, .length = 2},
  [29] = {.index = 42, .length = 2},
  [30] = {.index = 44, .length = 1},
  [31] = {.index = 45, .length = 1},
  [32] = {.index = 46, .length = 1},
  [33] = {.index = 47, .length = 1},
  [34] = {.index = 48, .length = 1},
  [35] = {.index = 49, .length = 1},
  [36] = {.index = 50, .length = 1},
  [37] = {.index = 51, .length = 2},
  [38] = {.index = 53, .length = 1},
  [39] = {.index = 54, .length = 2},
  [40] = {.index = 56, .length = 2},
  [41] = {.index = 18, .length = 2},
  [42] = {.index = 20, .length = 2},
  [43] = {.index = 58, .length = 3},
  [44] = {.index = 61, .length = 2},
  [45] = {.index = 61, .length = 2},
  [46] = {.index = 63, .length = 3},
  [47] = {.index = 63, .length = 3},
  [48] = {.index = 66, .length = 3},
  [49] = {.index = 69, .length = 3},
  [50] = {.index = 72, .length = 2},
  [51] = {.index = 74, .length = 2},
  [52] = {.index = 76, .length = 2},
  [53] = {.index = 78, .length = 2},
  [54] = {.index = 80, .length = 1},
  [55] = {.index = 81, .length = 1},
  [56] = {.index = 82, .length = 2},
  [57] = {.index = 80, .length = 1},
  [58] = {.index = 18, .length = 2},
  [59] = {.index = 84, .length = 2},
  [60] = {.index = 86, .length = 3},
  [61] = {.index = 82, .length = 2},
  [62] = {.index = 89, .length = 1},
  [63] = {.index = 90, .length = 3},
  [64] = {.index = 93, .length = 6},
  [65] = {.index = 99, .length = 3},
  [66] = {.index = 102, .length = 2},
  [67] = {.index = 104, .length = 2},
  [68] = {.index = 106, .length = 2},
  [69] = {.index = 108, .length = 1},
  [70] = {.index = 109, .length = 2},
  [71] = {.index = 111, .length = 2},
  [72] = {.index = 113, .length = 2},
  [73] = {.index = 115, .length = 4},
  [74] = {.index = 119, .length = 2},
  [75] = {.index = 121, .length = 2},
  [76] = {.index = 123, .length = 2},
  [77] = {.index = 121, .length = 2},
  [78] = {.index = 125, .length = 2},
  [79] = {.index = 127, .length = 3},
  [80] = {.index = 130, .length = 2},
  [81] = {.index = 132, .length = 2},
  [82] = {.index = 134, .length = 3},
  [83] = {.index = 137, .length = 2},
  [84] = {.index = 139, .length = 2},
  [85] = {.index = 141, .length = 4},
  [86] = {.index = 145, .length = 2},
  [87] = {.index = 147, .length = 2},
  [88] = {.index = 149, .length = 2},
  [89] = {.index = 151, .length = 3},
  [90] = {.index = 154, .length = 2},
  [91] = {.index = 156, .length = 3},
  [92] = {.index = 159, .length = 3},
  [93] = {.index = 162, .length = 3},
  [94] = {.index = 165, .length = 1},
  [95] = {.index = 166, .length = 2},
  [96] = {.index = 168, .length = 3},
  [97] = {.index = 171, .length = 4},
  [98] = {.index = 175, .length = 3},
  [99] = {.index = 175, .length = 3},
  [100] = {.index = 178, .length = 3},
  [101] = {.index = 181, .length = 3},
  [102] = {.index = 184, .length = 3},
  [103] = {.index = 187, .length = 4},
  [104] = {.index = 191, .length = 2},
  [105] = {.index = 193, .length = 4},
  [106] = {.index = 197, .length = 4},
  [107] = {.index = 201, .length = 2},
  [108] = {.index = 203, .length = 4},
  [109] = {.index = 207, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_constructor, 1},
  [5] =
    {field_argument, 1},
    {field_operator, 0},
  [7] =
    {field_argument, 0},
    {field_operator, 1},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_declaration, 2},
  [16] =
    {field_body, 2},
    {field_label, 0},
  [18] =
    {field_left, 0},
    {field_right, 2},
  [20] =
    {field_body, 2},
    {field_parameter, 0},
  [22] =
    {field_source, 1},
  [23] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [25] =
    {field_kind, 0},
  [26] =
    {field_condition, 1},
    {field_consequence, 2},
  [28] =
    {field_body, 2},
    {field_value, 1},
  [30] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [36] =
    {field_body, 2},
    {field_condition, 1},
  [38] =
    {field_body, 1},
    {field_handler, 2},
  [40] =
    {field_body, 1},
    {field_finalizer, 2},
  [42] =
    {field_body, 2},
    {field_object, 1},
  [44] =
    {field_label, 1},
  [45] =
    {field_name, 1},
  [46] =
    {field_attribute, 0},
  [47] =
    {field_pattern, 1},
  [48] =
    {field_template, 0},
  [49] =
    {field_member, 0},
  [50] =
    {field_property, 0},
  [51] =
    {field_body, 2},
    {field_name, 1},
  [53] =
    {field_body, 2},
  [54] =
    {field_body, 2},
    {field_parameters, 1},
  [56] =
    {field_arguments, 2},
    {field_constructor, 1},
  [58] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [61] =
    {field_object, 0},
    {field_property, 2},
  [63] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [66] =
    {field_arguments, 2},
    {field_function, 0},
    {field_optional_chain, 1},
  [69] =
    {field_close_tag, 2},
    {field_content, 1},
    {field_open_tag, 0},
  [72] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [74] =
    {field_body, 2},
    {field_parameters, 0},
  [76] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [78] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [80] =
    {field_source, 2, .inherited = true},
  [81] =
    {field_value, 2},
  [82] =
    {field_alias, 1, .inherited = true},
    {field_name, 1, .inherited = true},
  [84] =
    {field_key, 0},
    {field_value, 2},
  [86] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [89] =
    {field_value, 1},
  [90] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [93] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [99] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [102] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [104] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [106] =
    {field_flags, 3},
    {field_pattern, 1},
  [108] =
    {field_property, 1},
  [109] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [111] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
  [113] =
    {field_member, 1, .inherited = true},
    {field_template, 1, .inherited = true},
  [115] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
    {field_template, 0, .inherited = true},
    {field_template, 1, .inherited = true},
  [119] =
    {field_body, 3},
    {field_name, 1},
  [121] =
    {field_body, 3},
    {field_parameter, 1},
  [123] =
    {field_body, 3},
    {field_parameters, 2},
  [125] =
    {field_body, 3},
    {field_parameters, 1},
  [127] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [130] =
    {field_index, 2},
    {field_object, 0},
  [132] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [134] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [137] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [139] =
    {field_alias, 2},
    {field_name, 0},
  [141] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [145] =
    {field_body, 1},
    {field_condition, 3},
  [147] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [149] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
  [151] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [154] =
    {field_body, 4},
    {field_parameters, 3},
  [156] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [159] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [162] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [165] =
    {field_name, 2},
  [166] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [168] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [171] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [175] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [178] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [181] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
    {field_value, 3, .inherited = true},
  [184] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [187] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [191] =
    {field_body, 3},
    {field_value, 1},
  [193] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [197] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [201] =
    {field_body, 4},
    {field_parameter, 2},
  [203] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
  [207] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_statement_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [18] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [19] = {
    [1] = sym_identifier,
  },
  [30] = {
    [1] = alias_sym_statement_identifier,
  },
  [44] = {
    [2] = alias_sym_property_identifier,
  },
  [46] = {
    [2] = alias_sym_property_identifier,
  },
  [57] = {
    [1] = alias_sym_namespace_export,
  },
  [58] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [61] = {
    [1] = alias_sym_import_specifier,
  },
  [75] = {
    [1] = sym_identifier,
  },
  [98] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__import_export_specifier, 2,
    sym__import_export_specifier,
    alias_sym_import_specifier,
  sym_namespace_import_export, 2,
    sym_namespace_import_export,
    alias_sym_namespace_export,
  0,
};

static inline bool sym__glimmer_template_content_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool anon_sym_BANG_character_set_1(int32_t c) {
  return (c < 8192
    ? (c < ' '
      ? (c < '\r'
        ? (c >= '\t' && c <= '\n')
        : c <= '\r')
      : (c <= ' ' || (c < 5760
        ? c == 160
        : c <= 5760)))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '{' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_identifier_character_set_3(int32_t c) {
  return (c < 8192
    ? (c < 160
      ? (c < 0
        ? c == 0
        : c <= '~')
      : (c <= 160 || c == 5760))
    : (c <= 8203 || (c < 12288
      ? (c < 8287
        ? c == 8239
        : c <= 8288)
      : (c <= 12288 || c == 65279))));
}

static inline bool sym_identifier_character_set_4(int32_t c) {
  return (c < 160
    ? (c < ':'
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '/')))
      : (c <= '@' || (c < '`'
        ? (c >= '[' && c <= '^')
        : (c <= '`' || (c >= '|' && c <= '~')))))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static inline bool sym_private_property_identifier_character_set_1(int32_t c) {
  return (c < 160
    ? (c < '['
      ? (c < 0
        ? c == 0
        : (c <= '#' || (c >= '%' && c <= '@')))
      : (c <= '^' || (c < '{'
        ? c == '`'
        : c <= '~')))
    : (c <= 160 || (c < 8287
      ? (c < 8192
        ? c == 5760
        : (c <= 8203 || c == 8239))
      : (c <= 8288 || (c < 65279
        ? c == 12288
        : c <= 65279)))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(86);
      if (lookahead == '!') ADVANCE(182);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == '$') ADVANCE(223);
      if (lookahead == '%') ADVANCE(170);
      if (lookahead == '&') ADVANCE(159);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(208);
      if (lookahead == '0') ADVANCE(213);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(112);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '?') ADVANCE(18);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(44);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(162);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(163);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '~') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(83)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(224);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1)
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == '<') ADVANCE(107);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(106);
      if (lookahead != 0) ADVANCE(104);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(82);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(209);
      if (lookahead != 0) ADVANCE(210);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(87);
      if (lookahead == '\\') ADVANCE(45);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(225);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(181);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(130);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == '0') ADVANCE(213);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '~') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(4)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != ']' &&
          lookahead != '^' &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(224);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '%') ADVANCE(170);
      if (lookahead == '&') ADVANCE(159);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '.') ADVANCE(130);
      if (lookahead == '/') ADVANCE(120);
      if (lookahead == '0') ADVANCE(213);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(111);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '?') ADVANCE(18);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(162);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(163);
      if (lookahead == '}') ADVANCE(93);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(5)
      if (lookahead != 0 &&
          lookahead > 31 &&
          lookahead != '~') ADVANCE(224);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(160);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == '?') ADVANCE(19);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(161);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(93);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(6)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '0' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(224);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(160);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == '?') ADVANCE(19);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(161);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(93);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(8)
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(211);
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(224);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(23);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(160);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(24);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == '?') ADVANCE(19);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(161);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(93);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(8)
      if (lookahead != 0 &&
          lookahead > '#' &&
          (lookahead < '\'' || '@' < lookahead) &&
          lookahead != '~') ADVANCE(224);
      END_STATE();
    case 9:
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == '.') ADVANCE(128);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(98);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '{') ADVANCE(91);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(9)
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(222);
      if (lookahead != 0 &&
          lookahead > '~') ADVANCE(224);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '/') ADVANCE(189);
      if (lookahead == '\\') ADVANCE(47);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(192);
      if (lookahead != 0) ADVANCE(193);
      END_STATE();
    case 11:
      if (lookahead == '$') ADVANCE(48);
      if (lookahead == '/') ADVANCE(208);
      if (lookahead == '\\') ADVANCE(47);
      if (lookahead == '`') ADVANCE(206);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(12)
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(48);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == '`') ADVANCE(206);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '/') ADVANCE(195);
      if (lookahead == '\\') ADVANCE(47);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(198);
      if (lookahead != 0) ADVANCE(199);
      END_STATE();
    case 14:
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(205);
      END_STATE();
    case 15:
      if (lookahead == '*') ADVANCE(15);
      if (lookahead == '/') ADVANCE(204);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 16:
      if (lookahead == '*') ADVANCE(15);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == '.') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      END_STATE();
    case 18:
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '?') ADVANCE(180);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(132);
      if (lookahead == '?') ADVANCE(179);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(148);
      END_STATE();
    case 21:
      if (lookahead == '/') ADVANCE(122);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '{') ADVANCE(91);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(126);
      END_STATE();
    case 22:
      if (lookahead == '/') ADVANCE(14);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(22)
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(176);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(174);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(108);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(109);
      END_STATE();
    case 27:
      if (lookahead == '\\') ADVANCE(45);
      if (!sym_private_property_identifier_character_set_1(lookahead)) ADVANCE(225);
      END_STATE();
    case 28:
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead == ']') ADVANCE(210);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 35:
      if (lookahead == 'l') ADVANCE(29);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(30);
      END_STATE();
    case 37:
      if (lookahead == 'm') ADVANCE(39);
      END_STATE();
    case 38:
      if (lookahead == 'm') ADVANCE(40);
      END_STATE();
    case 39:
      if (lookahead == 'p') ADVANCE(35);
      END_STATE();
    case 40:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(33);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(49);
      if (lookahead == 'x') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(203);
      if (lookahead != 0) ADVANCE(200);
      END_STATE();
    case 45:
      if (lookahead == 'u') ADVANCE(50);
      END_STATE();
    case 46:
      if (lookahead == 'u') ADVANCE(51);
      END_STATE();
    case 47:
      if (lookahead == 'u') ADVANCE(52);
      if (lookahead == 'x') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(203);
      if (lookahead != 0) ADVANCE(200);
      END_STATE();
    case 48:
      if (lookahead == '{') ADVANCE(207);
      END_STATE();
    case 49:
      if (lookahead == '{') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 50:
      if (lookahead == '{') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(79);
      END_STATE();
    case 51:
      if (lookahead == '{') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(80);
      END_STATE();
    case 52:
      if (lookahead == '{') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 53:
      if (lookahead == '}') ADVANCE(224);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 54:
      if (lookahead == '}') ADVANCE(225);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 55:
      if (lookahead == '}') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 56:
      if (lookahead == '}') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 57:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 58:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(215);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(216);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(218);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(224);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(225);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(200);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(201);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 78:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(75);
      END_STATE();
    case 79:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      END_STATE();
    case 80:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      END_STATE();
    case 81:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(28);
      END_STATE();
    case 82:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(210);
      END_STATE();
    case 83:
      if (eof) ADVANCE(86);
      if (lookahead == '!') ADVANCE(182);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == '$') ADVANCE(223);
      if (lookahead == '%') ADVANCE(170);
      if (lookahead == '&') ADVANCE(159);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(89);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(168);
      if (lookahead == '.') ADVANCE(129);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == '0') ADVANCE(213);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(112);
      if (lookahead == '=') ADVANCE(100);
      if (lookahead == '>') ADVANCE(117);
      if (lookahead == '?') ADVANCE(18);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(162);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(163);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '~') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(83)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(224);
      END_STATE();
    case 84:
      if (eof) ADVANCE(86);
      if (lookahead == '!') ADVANCE(182);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '#') ADVANCE(27);
      if (lookahead == '%') ADVANCE(169);
      if (lookahead == '&') ADVANCE(160);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(90);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(130);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == '0') ADVANCE(213);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(114);
      if (lookahead == '=') ADVANCE(99);
      if (lookahead == '>') ADVANCE(118);
      if (lookahead == '?') ADVANCE(19);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '^') ADVANCE(161);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '|') ADVANCE(164);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '~') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(84)
      if (lookahead != 0 &&
          lookahead > 31) ADVANCE(224);
      END_STATE();
    case 85:
      if (eof) ADVANCE(86);
      if (lookahead == '!') ADVANCE(181);
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '#') ADVANCE(3);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '(') ADVANCE(94);
      if (lookahead == ')') ADVANCE(95);
      if (lookahead == '*') ADVANCE(88);
      if (lookahead == '+') ADVANCE(165);
      if (lookahead == ',') ADVANCE(92);
      if (lookahead == '-') ADVANCE(167);
      if (lookahead == '.') ADVANCE(17);
      if (lookahead == '/') ADVANCE(119);
      if (lookahead == '0') ADVANCE(213);
      if (lookahead == ':') ADVANCE(97);
      if (lookahead == ';') ADVANCE(96);
      if (lookahead == '<') ADVANCE(115);
      if (lookahead == '=') ADVANCE(101);
      if (lookahead == '>') ADVANCE(116);
      if (lookahead == '@') ADVANCE(226);
      if (lookahead == '[') ADVANCE(102);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == ']') ADVANCE(103);
      if (lookahead == '`') ADVANCE(206);
      if (lookahead == '{') ADVANCE(91);
      if (lookahead == '}') ADVANCE(93);
      if (lookahead == '~') ADVANCE(183);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if (anon_sym_BANG_character_set_1(lookahead)) SKIP(85)
      if (lookahead != 0 &&
          lookahead > 31 &&
          (lookahead < '%' || '?' < lookahead) &&
          lookahead != '^' &&
          lookahead != '|') ADVANCE(224);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(172);
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(171);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(174);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(174);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(131);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(205);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(105);
      if (lookahead == '<') ADVANCE(107);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(106);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(104);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(43);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LTtemplate_GT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT_SLASHtemplate_GT);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(173);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(173);
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(173);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(173);
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(178);
      if (lookahead == '>') ADVANCE(153);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(178);
      if (lookahead == '>') ADVANCE(154);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(205);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(205);
      if (lookahead == '=') ADVANCE(136);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '\n') ADVANCE(126);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(205);
      if (lookahead != 0) ADVANCE(121);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(124);
      if (lookahead == '/') ADVANCE(121);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(126);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '/') ADVANCE(126);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(16);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '*') ADVANCE(123);
      if (lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '{' ||
          lookahead == '}') ADVANCE(16);
      if (lookahead != 0) ADVANCE(124);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead == '/') ADVANCE(122);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(125);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(126);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_jsx_text);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_optional_chain);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(141);
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(143);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(150);
      if (lookahead == '=') ADVANCE(139);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(149);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(138);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(140);
      if (lookahead == '|') ADVANCE(152);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(151);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(184);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(184);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(185);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(185);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(137);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(144);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(176);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(193);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(188);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '/') ADVANCE(188);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(193);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(190);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(191);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(190);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(191);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(189);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(193);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(194);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(197);
      if (lookahead == '/') ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(199);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(196);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(197);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(195);
      if (anon_sym_BANG_character_set_1(lookahead)) ADVANCE(198);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(199);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(46);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(224);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(200);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(202);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      if (lookahead == '*') ADVANCE(16);
      if (lookahead == '/') ADVANCE(205);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(22)
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(82);
      if (sym__glimmer_template_content_character_set_1(lookahead)) ADVANCE(209);
      if (lookahead != 0) ADVANCE(210);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(28);
      if (lookahead == '\\') ADVANCE(82);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(210);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(46);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(211);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(224);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(221);
      if (lookahead == '0') ADVANCE(218);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(58);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(59);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(67);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'n') ADVANCE(212);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(221);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      if (lookahead == '_') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(58);
      if (lookahead == 'n') ADVANCE(212);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(215);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(67);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(62);
      if (lookahead == 'n') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      if (lookahead == '_') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(127);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(222);
      if (!sym_identifier_character_set_3(lookahead)) ADVANCE(224);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(46);
      if (lookahead == '{') ADVANCE(207);
      if (!sym_identifier_character_set_4(lookahead)) ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(46);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(224);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(45);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'g') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'l') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'o') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      if (lookahead == 'v') ADVANCE(16);
      if (lookahead == 'w') ADVANCE(17);
      if (lookahead == 'y') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 160 ||
          lookahead == 5760 ||
          (8192 <= lookahead && lookahead <= 8203) ||
          lookahead == 8239 ||
          lookahead == 8287 ||
          lookahead == 8288 ||
          lookahead == 12288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(19);
      if (lookahead == 'w') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(21);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'x') ADVANCE(28);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'r') ADVANCE(32);
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(35);
      if (lookahead == 'm') ADVANCE(36);
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'f') ADVANCE(41);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 't') ADVANCE(44);
      if (lookahead == 'u') ADVANCE(45);
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(47);
      if (lookahead == 'h') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      if (lookahead == 'y') ADVANCE(50);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'h') ADVANCE(54);
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(57);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(60);
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(64);
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'l') ADVANCE(66);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(67);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(68);
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 36:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(77);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 39:
      if (lookahead == 'w') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(80);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(83);
      END_STATE();
    case 45:
      if (lookahead == 'p') ADVANCE(84);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(87);
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 50:
      if (lookahead == 'p') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'd') ADVANCE(92);
      END_STATE();
    case 52:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(95);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(98);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(99);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(100);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 61:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(110);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 73:
      if (lookahead == 'm') ADVANCE(114);
      END_STATE();
    case 74:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 76:
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 86:
      if (lookahead == 'g') ADVANCE(123);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 89:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(129);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(130);
      END_STATE();
    case 96:
      if (lookahead == 'h') ADVANCE(131);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(133);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 100:
      if (lookahead == 'k') ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 102:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(137);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 106:
      if (lookahead == 'g') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'u') ADVANCE(141);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 110:
      if (lookahead == 'r') ADVANCE(143);
      END_STATE();
    case 111:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(145);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 120:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(153);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 125:
      if (lookahead == 'w') ADVANCE(155);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 127:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(157);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 132:
      if (lookahead == 'd') ADVANCE(159);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 139:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 140:
      if (lookahead == 'g') ADVANCE(161);
      END_STATE();
    case 141:
      if (lookahead == 'l') ADVANCE(162);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 143:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'd') ADVANCE(165);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(167);
      END_STATE();
    case 148:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 149:
      if (lookahead == 'n') ADVANCE(169);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 153:
      if (lookahead == 'h') ADVANCE(172);
      END_STATE();
    case 154:
      if (lookahead == 't') ADVANCE(173);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 156:
      if (lookahead == 'f') ADVANCE(174);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(175);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 160:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(179);
      END_STATE();
    case 166:
      if (lookahead == 'y') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'o') ADVANCE(181);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 169:
      if (lookahead == 'c') ADVANCE(182);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 175:
      if (lookahead == 'n') ADVANCE(183);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(185);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 181:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(187);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 187:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 188:
      if (lookahead == 'd') ADVANCE(190);
      END_STATE();
    case 189:
      if (lookahead == 'f') ADVANCE(191);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 85},
  [2] = {.lex_state = 85},
  [3] = {.lex_state = 85},
  [4] = {.lex_state = 85},
  [5] = {.lex_state = 85},
  [6] = {.lex_state = 85},
  [7] = {.lex_state = 85},
  [8] = {.lex_state = 85},
  [9] = {.lex_state = 85},
  [10] = {.lex_state = 85},
  [11] = {.lex_state = 85},
  [12] = {.lex_state = 85},
  [13] = {.lex_state = 85},
  [14] = {.lex_state = 85},
  [15] = {.lex_state = 85},
  [16] = {.lex_state = 85},
  [17] = {.lex_state = 85},
  [18] = {.lex_state = 85},
  [19] = {.lex_state = 85},
  [20] = {.lex_state = 85},
  [21] = {.lex_state = 85},
  [22] = {.lex_state = 85},
  [23] = {.lex_state = 85},
  [24] = {.lex_state = 85},
  [25] = {.lex_state = 85},
  [26] = {.lex_state = 85},
  [27] = {.lex_state = 85},
  [28] = {.lex_state = 85},
  [29] = {.lex_state = 85},
  [30] = {.lex_state = 85},
  [31] = {.lex_state = 85},
  [32] = {.lex_state = 85},
  [33] = {.lex_state = 85},
  [34] = {.lex_state = 85},
  [35] = {.lex_state = 85},
  [36] = {.lex_state = 85},
  [37] = {.lex_state = 85},
  [38] = {.lex_state = 85},
  [39] = {.lex_state = 85},
  [40] = {.lex_state = 85},
  [41] = {.lex_state = 85},
  [42] = {.lex_state = 85},
  [43] = {.lex_state = 85},
  [44] = {.lex_state = 84, .external_lex_state = 2},
  [45] = {.lex_state = 84, .external_lex_state = 3},
  [46] = {.lex_state = 84, .external_lex_state = 3},
  [47] = {.lex_state = 84, .external_lex_state = 2},
  [48] = {.lex_state = 84, .external_lex_state = 2},
  [49] = {.lex_state = 85},
  [50] = {.lex_state = 85},
  [51] = {.lex_state = 85},
  [52] = {.lex_state = 85},
  [53] = {.lex_state = 85},
  [54] = {.lex_state = 85},
  [55] = {.lex_state = 85},
  [56] = {.lex_state = 85},
  [57] = {.lex_state = 85},
  [58] = {.lex_state = 84, .external_lex_state = 3},
  [59] = {.lex_state = 85},
  [60] = {.lex_state = 85},
  [61] = {.lex_state = 85},
  [62] = {.lex_state = 85},
  [63] = {.lex_state = 85},
  [64] = {.lex_state = 84, .external_lex_state = 3},
  [65] = {.lex_state = 84, .external_lex_state = 3},
  [66] = {.lex_state = 84, .external_lex_state = 3},
  [67] = {.lex_state = 84, .external_lex_state = 3},
  [68] = {.lex_state = 84, .external_lex_state = 3},
  [69] = {.lex_state = 84, .external_lex_state = 3},
  [70] = {.lex_state = 84, .external_lex_state = 3},
  [71] = {.lex_state = 84, .external_lex_state = 3},
  [72] = {.lex_state = 84, .external_lex_state = 3},
  [73] = {.lex_state = 84, .external_lex_state = 3},
  [74] = {.lex_state = 84, .external_lex_state = 3},
  [75] = {.lex_state = 84, .external_lex_state = 3},
  [76] = {.lex_state = 84, .external_lex_state = 3},
  [77] = {.lex_state = 84, .external_lex_state = 3},
  [78] = {.lex_state = 85},
  [79] = {.lex_state = 85},
  [80] = {.lex_state = 85},
  [81] = {.lex_state = 85},
  [82] = {.lex_state = 85},
  [83] = {.lex_state = 85},
  [84] = {.lex_state = 85},
  [85] = {.lex_state = 85},
  [86] = {.lex_state = 85},
  [87] = {.lex_state = 85},
  [88] = {.lex_state = 85},
  [89] = {.lex_state = 85},
  [90] = {.lex_state = 85},
  [91] = {.lex_state = 85},
  [92] = {.lex_state = 85},
  [93] = {.lex_state = 85},
  [94] = {.lex_state = 85},
  [95] = {.lex_state = 85},
  [96] = {.lex_state = 85},
  [97] = {.lex_state = 85},
  [98] = {.lex_state = 85},
  [99] = {.lex_state = 85, .external_lex_state = 4},
  [100] = {.lex_state = 85},
  [101] = {.lex_state = 85},
  [102] = {.lex_state = 85},
  [103] = {.lex_state = 85},
  [104] = {.lex_state = 85},
  [105] = {.lex_state = 85},
  [106] = {.lex_state = 85},
  [107] = {.lex_state = 85},
  [108] = {.lex_state = 85},
  [109] = {.lex_state = 85},
  [110] = {.lex_state = 85},
  [111] = {.lex_state = 85},
  [112] = {.lex_state = 85},
  [113] = {.lex_state = 85},
  [114] = {.lex_state = 85},
  [115] = {.lex_state = 85},
  [116] = {.lex_state = 85},
  [117] = {.lex_state = 85},
  [118] = {.lex_state = 85},
  [119] = {.lex_state = 85},
  [120] = {.lex_state = 85},
  [121] = {.lex_state = 85},
  [122] = {.lex_state = 85},
  [123] = {.lex_state = 85},
  [124] = {.lex_state = 85},
  [125] = {.lex_state = 85},
  [126] = {.lex_state = 85},
  [127] = {.lex_state = 85},
  [128] = {.lex_state = 85},
  [129] = {.lex_state = 85},
  [130] = {.lex_state = 85},
  [131] = {.lex_state = 85},
  [132] = {.lex_state = 85},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 85},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 85},
  [137] = {.lex_state = 85},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 85},
  [140] = {.lex_state = 4},
  [141] = {.lex_state = 85},
  [142] = {.lex_state = 85},
  [143] = {.lex_state = 4},
  [144] = {.lex_state = 85},
  [145] = {.lex_state = 85},
  [146] = {.lex_state = 85},
  [147] = {.lex_state = 85},
  [148] = {.lex_state = 85},
  [149] = {.lex_state = 85},
  [150] = {.lex_state = 85},
  [151] = {.lex_state = 85},
  [152] = {.lex_state = 85},
  [153] = {.lex_state = 85},
  [154] = {.lex_state = 85},
  [155] = {.lex_state = 85},
  [156] = {.lex_state = 85},
  [157] = {.lex_state = 85},
  [158] = {.lex_state = 85},
  [159] = {.lex_state = 85},
  [160] = {.lex_state = 85},
  [161] = {.lex_state = 85},
  [162] = {.lex_state = 85},
  [163] = {.lex_state = 85},
  [164] = {.lex_state = 85},
  [165] = {.lex_state = 85},
  [166] = {.lex_state = 85},
  [167] = {.lex_state = 85},
  [168] = {.lex_state = 85},
  [169] = {.lex_state = 85},
  [170] = {.lex_state = 85},
  [171] = {.lex_state = 85},
  [172] = {.lex_state = 85},
  [173] = {.lex_state = 85},
  [174] = {.lex_state = 85},
  [175] = {.lex_state = 85},
  [176] = {.lex_state = 85},
  [177] = {.lex_state = 85},
  [178] = {.lex_state = 85},
  [179] = {.lex_state = 85},
  [180] = {.lex_state = 85},
  [181] = {.lex_state = 85},
  [182] = {.lex_state = 85},
  [183] = {.lex_state = 85},
  [184] = {.lex_state = 85},
  [185] = {.lex_state = 85},
  [186] = {.lex_state = 85},
  [187] = {.lex_state = 85},
  [188] = {.lex_state = 85},
  [189] = {.lex_state = 85},
  [190] = {.lex_state = 85},
  [191] = {.lex_state = 85},
  [192] = {.lex_state = 85},
  [193] = {.lex_state = 85},
  [194] = {.lex_state = 85},
  [195] = {.lex_state = 85},
  [196] = {.lex_state = 85},
  [197] = {.lex_state = 85},
  [198] = {.lex_state = 85},
  [199] = {.lex_state = 85},
  [200] = {.lex_state = 85},
  [201] = {.lex_state = 85},
  [202] = {.lex_state = 85},
  [203] = {.lex_state = 85},
  [204] = {.lex_state = 85},
  [205] = {.lex_state = 85},
  [206] = {.lex_state = 85},
  [207] = {.lex_state = 85},
  [208] = {.lex_state = 85},
  [209] = {.lex_state = 85},
  [210] = {.lex_state = 85},
  [211] = {.lex_state = 85},
  [212] = {.lex_state = 85},
  [213] = {.lex_state = 85},
  [214] = {.lex_state = 85},
  [215] = {.lex_state = 85},
  [216] = {.lex_state = 85},
  [217] = {.lex_state = 85},
  [218] = {.lex_state = 85},
  [219] = {.lex_state = 85},
  [220] = {.lex_state = 85},
  [221] = {.lex_state = 85},
  [222] = {.lex_state = 85},
  [223] = {.lex_state = 85},
  [224] = {.lex_state = 85},
  [225] = {.lex_state = 85},
  [226] = {.lex_state = 85},
  [227] = {.lex_state = 85},
  [228] = {.lex_state = 85},
  [229] = {.lex_state = 85},
  [230] = {.lex_state = 85},
  [231] = {.lex_state = 85},
  [232] = {.lex_state = 85},
  [233] = {.lex_state = 85},
  [234] = {.lex_state = 85},
  [235] = {.lex_state = 85},
  [236] = {.lex_state = 85},
  [237] = {.lex_state = 85},
  [238] = {.lex_state = 85},
  [239] = {.lex_state = 85},
  [240] = {.lex_state = 85},
  [241] = {.lex_state = 85},
  [242] = {.lex_state = 85},
  [243] = {.lex_state = 85},
  [244] = {.lex_state = 85},
  [245] = {.lex_state = 85},
  [246] = {.lex_state = 85},
  [247] = {.lex_state = 85},
  [248] = {.lex_state = 85},
  [249] = {.lex_state = 85},
  [250] = {.lex_state = 85},
  [251] = {.lex_state = 85},
  [252] = {.lex_state = 85},
  [253] = {.lex_state = 85},
  [254] = {.lex_state = 85},
  [255] = {.lex_state = 85},
  [256] = {.lex_state = 85},
  [257] = {.lex_state = 85},
  [258] = {.lex_state = 85},
  [259] = {.lex_state = 85},
  [260] = {.lex_state = 85},
  [261] = {.lex_state = 85},
  [262] = {.lex_state = 85},
  [263] = {.lex_state = 85},
  [264] = {.lex_state = 85},
  [265] = {.lex_state = 85},
  [266] = {.lex_state = 85},
  [267] = {.lex_state = 85},
  [268] = {.lex_state = 85},
  [269] = {.lex_state = 85},
  [270] = {.lex_state = 85},
  [271] = {.lex_state = 85},
  [272] = {.lex_state = 85},
  [273] = {.lex_state = 85},
  [274] = {.lex_state = 85},
  [275] = {.lex_state = 5, .external_lex_state = 3},
  [276] = {.lex_state = 5, .external_lex_state = 3},
  [277] = {.lex_state = 5, .external_lex_state = 3},
  [278] = {.lex_state = 5, .external_lex_state = 3},
  [279] = {.lex_state = 5, .external_lex_state = 3},
  [280] = {.lex_state = 5, .external_lex_state = 3},
  [281] = {.lex_state = 5, .external_lex_state = 3},
  [282] = {.lex_state = 5, .external_lex_state = 3},
  [283] = {.lex_state = 5, .external_lex_state = 3},
  [284] = {.lex_state = 5, .external_lex_state = 3},
  [285] = {.lex_state = 5, .external_lex_state = 3},
  [286] = {.lex_state = 5, .external_lex_state = 3},
  [287] = {.lex_state = 5, .external_lex_state = 3},
  [288] = {.lex_state = 5, .external_lex_state = 3},
  [289] = {.lex_state = 85, .external_lex_state = 4},
  [290] = {.lex_state = 85, .external_lex_state = 4},
  [291] = {.lex_state = 85},
  [292] = {.lex_state = 85},
  [293] = {.lex_state = 5, .external_lex_state = 2},
  [294] = {.lex_state = 85},
  [295] = {.lex_state = 5, .external_lex_state = 2},
  [296] = {.lex_state = 5, .external_lex_state = 3},
  [297] = {.lex_state = 5, .external_lex_state = 3},
  [298] = {.lex_state = 5, .external_lex_state = 3},
  [299] = {.lex_state = 5, .external_lex_state = 3},
  [300] = {.lex_state = 5, .external_lex_state = 3},
  [301] = {.lex_state = 5, .external_lex_state = 2},
  [302] = {.lex_state = 5, .external_lex_state = 2},
  [303] = {.lex_state = 5, .external_lex_state = 3},
  [304] = {.lex_state = 5, .external_lex_state = 2},
  [305] = {.lex_state = 5, .external_lex_state = 3},
  [306] = {.lex_state = 85},
  [307] = {.lex_state = 5, .external_lex_state = 2},
  [308] = {.lex_state = 85, .external_lex_state = 4},
  [309] = {.lex_state = 85, .external_lex_state = 4},
  [310] = {.lex_state = 85},
  [311] = {.lex_state = 85},
  [312] = {.lex_state = 85, .external_lex_state = 4},
  [313] = {.lex_state = 85},
  [314] = {.lex_state = 85},
  [315] = {.lex_state = 5, .external_lex_state = 3},
  [316] = {.lex_state = 85, .external_lex_state = 4},
  [317] = {.lex_state = 5, .external_lex_state = 2},
  [318] = {.lex_state = 85, .external_lex_state = 4},
  [319] = {.lex_state = 85},
  [320] = {.lex_state = 5, .external_lex_state = 3},
  [321] = {.lex_state = 5, .external_lex_state = 2},
  [322] = {.lex_state = 85, .external_lex_state = 4},
  [323] = {.lex_state = 85, .external_lex_state = 4},
  [324] = {.lex_state = 85, .external_lex_state = 4},
  [325] = {.lex_state = 85, .external_lex_state = 4},
  [326] = {.lex_state = 85, .external_lex_state = 4},
  [327] = {.lex_state = 85, .external_lex_state = 4},
  [328] = {.lex_state = 85, .external_lex_state = 4},
  [329] = {.lex_state = 85, .external_lex_state = 4},
  [330] = {.lex_state = 85, .external_lex_state = 4},
  [331] = {.lex_state = 85},
  [332] = {.lex_state = 85},
  [333] = {.lex_state = 85},
  [334] = {.lex_state = 85},
  [335] = {.lex_state = 85},
  [336] = {.lex_state = 85},
  [337] = {.lex_state = 85},
  [338] = {.lex_state = 85},
  [339] = {.lex_state = 85},
  [340] = {.lex_state = 85},
  [341] = {.lex_state = 85},
  [342] = {.lex_state = 85},
  [343] = {.lex_state = 85},
  [344] = {.lex_state = 85},
  [345] = {.lex_state = 85},
  [346] = {.lex_state = 85},
  [347] = {.lex_state = 85},
  [348] = {.lex_state = 85},
  [349] = {.lex_state = 85},
  [350] = {.lex_state = 85},
  [351] = {.lex_state = 5, .external_lex_state = 2},
  [352] = {.lex_state = 5, .external_lex_state = 2},
  [353] = {.lex_state = 85},
  [354] = {.lex_state = 5, .external_lex_state = 2},
  [355] = {.lex_state = 85},
  [356] = {.lex_state = 85},
  [357] = {.lex_state = 85},
  [358] = {.lex_state = 85},
  [359] = {.lex_state = 85},
  [360] = {.lex_state = 85},
  [361] = {.lex_state = 85},
  [362] = {.lex_state = 85},
  [363] = {.lex_state = 85},
  [364] = {.lex_state = 85},
  [365] = {.lex_state = 85},
  [366] = {.lex_state = 85},
  [367] = {.lex_state = 85},
  [368] = {.lex_state = 85},
  [369] = {.lex_state = 85},
  [370] = {.lex_state = 85},
  [371] = {.lex_state = 85},
  [372] = {.lex_state = 85},
  [373] = {.lex_state = 85},
  [374] = {.lex_state = 85},
  [375] = {.lex_state = 85},
  [376] = {.lex_state = 85},
  [377] = {.lex_state = 85},
  [378] = {.lex_state = 85},
  [379] = {.lex_state = 85},
  [380] = {.lex_state = 85},
  [381] = {.lex_state = 85},
  [382] = {.lex_state = 85},
  [383] = {.lex_state = 85},
  [384] = {.lex_state = 85},
  [385] = {.lex_state = 85},
  [386] = {.lex_state = 85},
  [387] = {.lex_state = 85},
  [388] = {.lex_state = 85},
  [389] = {.lex_state = 85},
  [390] = {.lex_state = 85},
  [391] = {.lex_state = 85},
  [392] = {.lex_state = 85},
  [393] = {.lex_state = 85},
  [394] = {.lex_state = 85},
  [395] = {.lex_state = 85},
  [396] = {.lex_state = 85},
  [397] = {.lex_state = 85},
  [398] = {.lex_state = 85},
  [399] = {.lex_state = 85},
  [400] = {.lex_state = 85},
  [401] = {.lex_state = 85},
  [402] = {.lex_state = 85},
  [403] = {.lex_state = 85},
  [404] = {.lex_state = 85},
  [405] = {.lex_state = 85},
  [406] = {.lex_state = 85},
  [407] = {.lex_state = 85},
  [408] = {.lex_state = 85},
  [409] = {.lex_state = 85},
  [410] = {.lex_state = 85},
  [411] = {.lex_state = 85},
  [412] = {.lex_state = 85},
  [413] = {.lex_state = 85},
  [414] = {.lex_state = 85},
  [415] = {.lex_state = 85},
  [416] = {.lex_state = 85},
  [417] = {.lex_state = 85},
  [418] = {.lex_state = 85},
  [419] = {.lex_state = 85},
  [420] = {.lex_state = 85},
  [421] = {.lex_state = 85},
  [422] = {.lex_state = 85},
  [423] = {.lex_state = 85},
  [424] = {.lex_state = 85},
  [425] = {.lex_state = 85},
  [426] = {.lex_state = 5, .external_lex_state = 3},
  [427] = {.lex_state = 5, .external_lex_state = 3},
  [428] = {.lex_state = 5, .external_lex_state = 3},
  [429] = {.lex_state = 5, .external_lex_state = 2},
  [430] = {.lex_state = 5, .external_lex_state = 2},
  [431] = {.lex_state = 5, .external_lex_state = 2},
  [432] = {.lex_state = 5, .external_lex_state = 2},
  [433] = {.lex_state = 5, .external_lex_state = 2},
  [434] = {.lex_state = 5, .external_lex_state = 2},
  [435] = {.lex_state = 5, .external_lex_state = 2},
  [436] = {.lex_state = 5, .external_lex_state = 2},
  [437] = {.lex_state = 5, .external_lex_state = 2},
  [438] = {.lex_state = 5, .external_lex_state = 2},
  [439] = {.lex_state = 5, .external_lex_state = 2},
  [440] = {.lex_state = 5, .external_lex_state = 2},
  [441] = {.lex_state = 5, .external_lex_state = 3},
  [442] = {.lex_state = 5, .external_lex_state = 2},
  [443] = {.lex_state = 5, .external_lex_state = 3},
  [444] = {.lex_state = 5, .external_lex_state = 3},
  [445] = {.lex_state = 5, .external_lex_state = 3},
  [446] = {.lex_state = 5, .external_lex_state = 3},
  [447] = {.lex_state = 85},
  [448] = {.lex_state = 85},
  [449] = {.lex_state = 5, .external_lex_state = 2},
  [450] = {.lex_state = 5, .external_lex_state = 2},
  [451] = {.lex_state = 5, .external_lex_state = 3},
  [452] = {.lex_state = 5, .external_lex_state = 3},
  [453] = {.lex_state = 5, .external_lex_state = 2},
  [454] = {.lex_state = 5, .external_lex_state = 3},
  [455] = {.lex_state = 5, .external_lex_state = 3},
  [456] = {.lex_state = 5, .external_lex_state = 3},
  [457] = {.lex_state = 5, .external_lex_state = 3},
  [458] = {.lex_state = 5, .external_lex_state = 3},
  [459] = {.lex_state = 5, .external_lex_state = 3},
  [460] = {.lex_state = 85},
  [461] = {.lex_state = 5, .external_lex_state = 3},
  [462] = {.lex_state = 5, .external_lex_state = 3},
  [463] = {.lex_state = 5, .external_lex_state = 2},
  [464] = {.lex_state = 5, .external_lex_state = 2},
  [465] = {.lex_state = 5, .external_lex_state = 3},
  [466] = {.lex_state = 5, .external_lex_state = 2},
  [467] = {.lex_state = 5, .external_lex_state = 3},
  [468] = {.lex_state = 85},
  [469] = {.lex_state = 85},
  [470] = {.lex_state = 5, .external_lex_state = 3},
  [471] = {.lex_state = 5, .external_lex_state = 3},
  [472] = {.lex_state = 85},
  [473] = {.lex_state = 85},
  [474] = {.lex_state = 5, .external_lex_state = 3},
  [475] = {.lex_state = 85},
  [476] = {.lex_state = 5, .external_lex_state = 3},
  [477] = {.lex_state = 5, .external_lex_state = 3},
  [478] = {.lex_state = 5, .external_lex_state = 3},
  [479] = {.lex_state = 5, .external_lex_state = 2},
  [480] = {.lex_state = 5, .external_lex_state = 2},
  [481] = {.lex_state = 5, .external_lex_state = 3},
  [482] = {.lex_state = 5, .external_lex_state = 2},
  [483] = {.lex_state = 5, .external_lex_state = 2},
  [484] = {.lex_state = 5, .external_lex_state = 2},
  [485] = {.lex_state = 5, .external_lex_state = 3},
  [486] = {.lex_state = 5, .external_lex_state = 2},
  [487] = {.lex_state = 5, .external_lex_state = 2},
  [488] = {.lex_state = 5, .external_lex_state = 2},
  [489] = {.lex_state = 5, .external_lex_state = 2},
  [490] = {.lex_state = 5, .external_lex_state = 2},
  [491] = {.lex_state = 5, .external_lex_state = 2},
  [492] = {.lex_state = 5, .external_lex_state = 2},
  [493] = {.lex_state = 5, .external_lex_state = 2},
  [494] = {.lex_state = 5, .external_lex_state = 2},
  [495] = {.lex_state = 5, .external_lex_state = 2},
  [496] = {.lex_state = 5, .external_lex_state = 2},
  [497] = {.lex_state = 5, .external_lex_state = 2},
  [498] = {.lex_state = 5, .external_lex_state = 2},
  [499] = {.lex_state = 5, .external_lex_state = 2},
  [500] = {.lex_state = 6, .external_lex_state = 3},
  [501] = {.lex_state = 6, .external_lex_state = 2},
  [502] = {.lex_state = 6, .external_lex_state = 3},
  [503] = {.lex_state = 6, .external_lex_state = 2},
  [504] = {.lex_state = 6, .external_lex_state = 2},
  [505] = {.lex_state = 6, .external_lex_state = 3},
  [506] = {.lex_state = 6, .external_lex_state = 2},
  [507] = {.lex_state = 6, .external_lex_state = 2},
  [508] = {.lex_state = 6, .external_lex_state = 3},
  [509] = {.lex_state = 6, .external_lex_state = 2},
  [510] = {.lex_state = 6, .external_lex_state = 2},
  [511] = {.lex_state = 6, .external_lex_state = 2},
  [512] = {.lex_state = 6, .external_lex_state = 2},
  [513] = {.lex_state = 6, .external_lex_state = 2},
  [514] = {.lex_state = 6, .external_lex_state = 2},
  [515] = {.lex_state = 6, .external_lex_state = 2},
  [516] = {.lex_state = 6, .external_lex_state = 3},
  [517] = {.lex_state = 6, .external_lex_state = 3},
  [518] = {.lex_state = 6, .external_lex_state = 2},
  [519] = {.lex_state = 6, .external_lex_state = 2},
  [520] = {.lex_state = 6, .external_lex_state = 2},
  [521] = {.lex_state = 6, .external_lex_state = 2},
  [522] = {.lex_state = 6, .external_lex_state = 2},
  [523] = {.lex_state = 6, .external_lex_state = 2},
  [524] = {.lex_state = 6, .external_lex_state = 2},
  [525] = {.lex_state = 6, .external_lex_state = 2},
  [526] = {.lex_state = 6, .external_lex_state = 2},
  [527] = {.lex_state = 6, .external_lex_state = 2},
  [528] = {.lex_state = 6, .external_lex_state = 2},
  [529] = {.lex_state = 6, .external_lex_state = 2},
  [530] = {.lex_state = 6, .external_lex_state = 3},
  [531] = {.lex_state = 6, .external_lex_state = 2},
  [532] = {.lex_state = 6, .external_lex_state = 2},
  [533] = {.lex_state = 6, .external_lex_state = 2},
  [534] = {.lex_state = 6, .external_lex_state = 2},
  [535] = {.lex_state = 6, .external_lex_state = 2},
  [536] = {.lex_state = 6, .external_lex_state = 2},
  [537] = {.lex_state = 6, .external_lex_state = 2},
  [538] = {.lex_state = 6, .external_lex_state = 2},
  [539] = {.lex_state = 6, .external_lex_state = 2},
  [540] = {.lex_state = 6, .external_lex_state = 2},
  [541] = {.lex_state = 6, .external_lex_state = 2},
  [542] = {.lex_state = 6, .external_lex_state = 3},
  [543] = {.lex_state = 6, .external_lex_state = 2},
  [544] = {.lex_state = 6, .external_lex_state = 2},
  [545] = {.lex_state = 6, .external_lex_state = 2},
  [546] = {.lex_state = 6, .external_lex_state = 2},
  [547] = {.lex_state = 6, .external_lex_state = 2},
  [548] = {.lex_state = 6, .external_lex_state = 2},
  [549] = {.lex_state = 6, .external_lex_state = 2},
  [550] = {.lex_state = 6, .external_lex_state = 2},
  [551] = {.lex_state = 6, .external_lex_state = 2},
  [552] = {.lex_state = 6, .external_lex_state = 2},
  [553] = {.lex_state = 6, .external_lex_state = 2},
  [554] = {.lex_state = 6, .external_lex_state = 2},
  [555] = {.lex_state = 6, .external_lex_state = 2},
  [556] = {.lex_state = 6, .external_lex_state = 3},
  [557] = {.lex_state = 6, .external_lex_state = 2},
  [558] = {.lex_state = 6, .external_lex_state = 2},
  [559] = {.lex_state = 6, .external_lex_state = 2},
  [560] = {.lex_state = 6, .external_lex_state = 2},
  [561] = {.lex_state = 6, .external_lex_state = 2},
  [562] = {.lex_state = 6, .external_lex_state = 2},
  [563] = {.lex_state = 6, .external_lex_state = 3},
  [564] = {.lex_state = 6, .external_lex_state = 3},
  [565] = {.lex_state = 6, .external_lex_state = 2},
  [566] = {.lex_state = 6, .external_lex_state = 2},
  [567] = {.lex_state = 6, .external_lex_state = 2},
  [568] = {.lex_state = 6, .external_lex_state = 2},
  [569] = {.lex_state = 6, .external_lex_state = 2},
  [570] = {.lex_state = 6, .external_lex_state = 2},
  [571] = {.lex_state = 6, .external_lex_state = 2},
  [572] = {.lex_state = 6, .external_lex_state = 2},
  [573] = {.lex_state = 6, .external_lex_state = 2},
  [574] = {.lex_state = 6, .external_lex_state = 2},
  [575] = {.lex_state = 6, .external_lex_state = 2},
  [576] = {.lex_state = 7, .external_lex_state = 2},
  [577] = {.lex_state = 6, .external_lex_state = 2},
  [578] = {.lex_state = 6, .external_lex_state = 3},
  [579] = {.lex_state = 6, .external_lex_state = 2},
  [580] = {.lex_state = 6, .external_lex_state = 2},
  [581] = {.lex_state = 6, .external_lex_state = 2},
  [582] = {.lex_state = 6, .external_lex_state = 2},
  [583] = {.lex_state = 6, .external_lex_state = 2},
  [584] = {.lex_state = 6, .external_lex_state = 2},
  [585] = {.lex_state = 6, .external_lex_state = 2},
  [586] = {.lex_state = 6, .external_lex_state = 2},
  [587] = {.lex_state = 6, .external_lex_state = 2},
  [588] = {.lex_state = 6, .external_lex_state = 2},
  [589] = {.lex_state = 6, .external_lex_state = 2},
  [590] = {.lex_state = 6, .external_lex_state = 2},
  [591] = {.lex_state = 6, .external_lex_state = 3},
  [592] = {.lex_state = 6, .external_lex_state = 2},
  [593] = {.lex_state = 6, .external_lex_state = 2},
  [594] = {.lex_state = 6, .external_lex_state = 2},
  [595] = {.lex_state = 6, .external_lex_state = 2},
  [596] = {.lex_state = 6, .external_lex_state = 2},
  [597] = {.lex_state = 6, .external_lex_state = 2},
  [598] = {.lex_state = 6, .external_lex_state = 2},
  [599] = {.lex_state = 6, .external_lex_state = 2},
  [600] = {.lex_state = 6, .external_lex_state = 2},
  [601] = {.lex_state = 6, .external_lex_state = 2},
  [602] = {.lex_state = 6, .external_lex_state = 2},
  [603] = {.lex_state = 6, .external_lex_state = 2},
  [604] = {.lex_state = 6, .external_lex_state = 2},
  [605] = {.lex_state = 6, .external_lex_state = 2},
  [606] = {.lex_state = 6, .external_lex_state = 2},
  [607] = {.lex_state = 6, .external_lex_state = 2},
  [608] = {.lex_state = 6, .external_lex_state = 2},
  [609] = {.lex_state = 6, .external_lex_state = 3},
  [610] = {.lex_state = 6, .external_lex_state = 3},
  [611] = {.lex_state = 6, .external_lex_state = 2},
  [612] = {.lex_state = 6, .external_lex_state = 3},
  [613] = {.lex_state = 6, .external_lex_state = 3},
  [614] = {.lex_state = 6, .external_lex_state = 3},
  [615] = {.lex_state = 6, .external_lex_state = 3},
  [616] = {.lex_state = 6, .external_lex_state = 3},
  [617] = {.lex_state = 6, .external_lex_state = 3},
  [618] = {.lex_state = 6, .external_lex_state = 3},
  [619] = {.lex_state = 6, .external_lex_state = 3},
  [620] = {.lex_state = 6, .external_lex_state = 3},
  [621] = {.lex_state = 6, .external_lex_state = 3},
  [622] = {.lex_state = 6, .external_lex_state = 3},
  [623] = {.lex_state = 6, .external_lex_state = 3},
  [624] = {.lex_state = 6, .external_lex_state = 2},
  [625] = {.lex_state = 6, .external_lex_state = 3},
  [626] = {.lex_state = 6, .external_lex_state = 2},
  [627] = {.lex_state = 6, .external_lex_state = 2},
  [628] = {.lex_state = 6, .external_lex_state = 3},
  [629] = {.lex_state = 6, .external_lex_state = 3},
  [630] = {.lex_state = 6, .external_lex_state = 3},
  [631] = {.lex_state = 6, .external_lex_state = 3},
  [632] = {.lex_state = 6, .external_lex_state = 3},
  [633] = {.lex_state = 6, .external_lex_state = 3},
  [634] = {.lex_state = 6, .external_lex_state = 3},
  [635] = {.lex_state = 6, .external_lex_state = 3},
  [636] = {.lex_state = 6, .external_lex_state = 3},
  [637] = {.lex_state = 6, .external_lex_state = 3},
  [638] = {.lex_state = 6, .external_lex_state = 3},
  [639] = {.lex_state = 6, .external_lex_state = 3},
  [640] = {.lex_state = 6, .external_lex_state = 2},
  [641] = {.lex_state = 6, .external_lex_state = 3},
  [642] = {.lex_state = 6, .external_lex_state = 3},
  [643] = {.lex_state = 6, .external_lex_state = 3},
  [644] = {.lex_state = 6, .external_lex_state = 3},
  [645] = {.lex_state = 6, .external_lex_state = 3},
  [646] = {.lex_state = 6, .external_lex_state = 3},
  [647] = {.lex_state = 6, .external_lex_state = 3},
  [648] = {.lex_state = 6, .external_lex_state = 3},
  [649] = {.lex_state = 6, .external_lex_state = 3},
  [650] = {.lex_state = 6, .external_lex_state = 3},
  [651] = {.lex_state = 6, .external_lex_state = 3},
  [652] = {.lex_state = 6, .external_lex_state = 3},
  [653] = {.lex_state = 6, .external_lex_state = 3},
  [654] = {.lex_state = 6, .external_lex_state = 3},
  [655] = {.lex_state = 6, .external_lex_state = 3},
  [656] = {.lex_state = 6, .external_lex_state = 2},
  [657] = {.lex_state = 6, .external_lex_state = 3},
  [658] = {.lex_state = 6, .external_lex_state = 3},
  [659] = {.lex_state = 6, .external_lex_state = 3},
  [660] = {.lex_state = 6, .external_lex_state = 3},
  [661] = {.lex_state = 6, .external_lex_state = 3},
  [662] = {.lex_state = 6, .external_lex_state = 3},
  [663] = {.lex_state = 6, .external_lex_state = 3},
  [664] = {.lex_state = 6, .external_lex_state = 3},
  [665] = {.lex_state = 6, .external_lex_state = 3},
  [666] = {.lex_state = 6, .external_lex_state = 3},
  [667] = {.lex_state = 6, .external_lex_state = 3},
  [668] = {.lex_state = 6, .external_lex_state = 3},
  [669] = {.lex_state = 6, .external_lex_state = 3},
  [670] = {.lex_state = 6, .external_lex_state = 3},
  [671] = {.lex_state = 6, .external_lex_state = 3},
  [672] = {.lex_state = 6, .external_lex_state = 3},
  [673] = {.lex_state = 6, .external_lex_state = 3},
  [674] = {.lex_state = 6, .external_lex_state = 3},
  [675] = {.lex_state = 6, .external_lex_state = 3},
  [676] = {.lex_state = 6, .external_lex_state = 3},
  [677] = {.lex_state = 6, .external_lex_state = 3},
  [678] = {.lex_state = 6, .external_lex_state = 3},
  [679] = {.lex_state = 6, .external_lex_state = 3},
  [680] = {.lex_state = 6, .external_lex_state = 3},
  [681] = {.lex_state = 6, .external_lex_state = 3},
  [682] = {.lex_state = 6, .external_lex_state = 3},
  [683] = {.lex_state = 6, .external_lex_state = 3},
  [684] = {.lex_state = 6, .external_lex_state = 2},
  [685] = {.lex_state = 6, .external_lex_state = 3},
  [686] = {.lex_state = 6, .external_lex_state = 2},
  [687] = {.lex_state = 6, .external_lex_state = 2},
  [688] = {.lex_state = 6, .external_lex_state = 3},
  [689] = {.lex_state = 6, .external_lex_state = 3},
  [690] = {.lex_state = 6, .external_lex_state = 3},
  [691] = {.lex_state = 6, .external_lex_state = 3},
  [692] = {.lex_state = 6, .external_lex_state = 3},
  [693] = {.lex_state = 6, .external_lex_state = 3},
  [694] = {.lex_state = 6, .external_lex_state = 2},
  [695] = {.lex_state = 6, .external_lex_state = 2},
  [696] = {.lex_state = 6, .external_lex_state = 3},
  [697] = {.lex_state = 6, .external_lex_state = 3},
  [698] = {.lex_state = 6, .external_lex_state = 3},
  [699] = {.lex_state = 6, .external_lex_state = 3},
  [700] = {.lex_state = 6, .external_lex_state = 3},
  [701] = {.lex_state = 6, .external_lex_state = 3},
  [702] = {.lex_state = 6, .external_lex_state = 3},
  [703] = {.lex_state = 6, .external_lex_state = 3},
  [704] = {.lex_state = 7, .external_lex_state = 3},
  [705] = {.lex_state = 6, .external_lex_state = 3},
  [706] = {.lex_state = 6, .external_lex_state = 3},
  [707] = {.lex_state = 6, .external_lex_state = 3},
  [708] = {.lex_state = 6, .external_lex_state = 2},
  [709] = {.lex_state = 6, .external_lex_state = 3},
  [710] = {.lex_state = 6, .external_lex_state = 3},
  [711] = {.lex_state = 6, .external_lex_state = 3},
  [712] = {.lex_state = 6, .external_lex_state = 3},
  [713] = {.lex_state = 6, .external_lex_state = 3},
  [714] = {.lex_state = 6, .external_lex_state = 3},
  [715] = {.lex_state = 6, .external_lex_state = 3},
  [716] = {.lex_state = 6, .external_lex_state = 3},
  [717] = {.lex_state = 6, .external_lex_state = 3},
  [718] = {.lex_state = 6, .external_lex_state = 3},
  [719] = {.lex_state = 6, .external_lex_state = 3},
  [720] = {.lex_state = 6, .external_lex_state = 3},
  [721] = {.lex_state = 6, .external_lex_state = 3},
  [722] = {.lex_state = 6, .external_lex_state = 3},
  [723] = {.lex_state = 6, .external_lex_state = 2},
  [724] = {.lex_state = 6, .external_lex_state = 3},
  [725] = {.lex_state = 6, .external_lex_state = 3},
  [726] = {.lex_state = 6, .external_lex_state = 3},
  [727] = {.lex_state = 6, .external_lex_state = 3},
  [728] = {.lex_state = 6, .external_lex_state = 3},
  [729] = {.lex_state = 6, .external_lex_state = 3},
  [730] = {.lex_state = 6, .external_lex_state = 3},
  [731] = {.lex_state = 6, .external_lex_state = 3},
  [732] = {.lex_state = 6, .external_lex_state = 2},
  [733] = {.lex_state = 6, .external_lex_state = 2},
  [734] = {.lex_state = 6, .external_lex_state = 2},
  [735] = {.lex_state = 6, .external_lex_state = 3},
  [736] = {.lex_state = 6, .external_lex_state = 3},
  [737] = {.lex_state = 6, .external_lex_state = 2},
  [738] = {.lex_state = 6, .external_lex_state = 3},
  [739] = {.lex_state = 6, .external_lex_state = 3},
  [740] = {.lex_state = 6, .external_lex_state = 2},
  [741] = {.lex_state = 6, .external_lex_state = 3},
  [742] = {.lex_state = 6, .external_lex_state = 3},
  [743] = {.lex_state = 6, .external_lex_state = 3},
  [744] = {.lex_state = 6, .external_lex_state = 3},
  [745] = {.lex_state = 6, .external_lex_state = 3},
  [746] = {.lex_state = 6, .external_lex_state = 3},
  [747] = {.lex_state = 6, .external_lex_state = 3},
  [748] = {.lex_state = 7, .external_lex_state = 3},
  [749] = {.lex_state = 6, .external_lex_state = 3},
  [750] = {.lex_state = 6, .external_lex_state = 2},
  [751] = {.lex_state = 6, .external_lex_state = 3},
  [752] = {.lex_state = 6, .external_lex_state = 3},
  [753] = {.lex_state = 6, .external_lex_state = 3},
  [754] = {.lex_state = 6, .external_lex_state = 3},
  [755] = {.lex_state = 6, .external_lex_state = 3},
  [756] = {.lex_state = 6, .external_lex_state = 3},
  [757] = {.lex_state = 6, .external_lex_state = 3},
  [758] = {.lex_state = 6, .external_lex_state = 3},
  [759] = {.lex_state = 6, .external_lex_state = 3},
  [760] = {.lex_state = 6, .external_lex_state = 3},
  [761] = {.lex_state = 6, .external_lex_state = 3},
  [762] = {.lex_state = 6, .external_lex_state = 3},
  [763] = {.lex_state = 6, .external_lex_state = 3},
  [764] = {.lex_state = 6, .external_lex_state = 3},
  [765] = {.lex_state = 6, .external_lex_state = 3},
  [766] = {.lex_state = 6, .external_lex_state = 3},
  [767] = {.lex_state = 6, .external_lex_state = 2},
  [768] = {.lex_state = 6, .external_lex_state = 2},
  [769] = {.lex_state = 6, .external_lex_state = 2},
  [770] = {.lex_state = 6, .external_lex_state = 3},
  [771] = {.lex_state = 6, .external_lex_state = 2},
  [772] = {.lex_state = 6, .external_lex_state = 2},
  [773] = {.lex_state = 6, .external_lex_state = 2},
  [774] = {.lex_state = 6, .external_lex_state = 2},
  [775] = {.lex_state = 6, .external_lex_state = 2},
  [776] = {.lex_state = 6, .external_lex_state = 2},
  [777] = {.lex_state = 6, .external_lex_state = 3},
  [778] = {.lex_state = 6, .external_lex_state = 2},
  [779] = {.lex_state = 6, .external_lex_state = 2},
  [780] = {.lex_state = 6, .external_lex_state = 2},
  [781] = {.lex_state = 6, .external_lex_state = 2},
  [782] = {.lex_state = 6, .external_lex_state = 2},
  [783] = {.lex_state = 6, .external_lex_state = 2},
  [784] = {.lex_state = 6, .external_lex_state = 2},
  [785] = {.lex_state = 6, .external_lex_state = 2},
  [786] = {.lex_state = 6, .external_lex_state = 2},
  [787] = {.lex_state = 6, .external_lex_state = 2},
  [788] = {.lex_state = 6, .external_lex_state = 2},
  [789] = {.lex_state = 6, .external_lex_state = 2},
  [790] = {.lex_state = 6, .external_lex_state = 2},
  [791] = {.lex_state = 6, .external_lex_state = 2},
  [792] = {.lex_state = 6, .external_lex_state = 2},
  [793] = {.lex_state = 6, .external_lex_state = 3},
  [794] = {.lex_state = 6, .external_lex_state = 2},
  [795] = {.lex_state = 6, .external_lex_state = 2},
  [796] = {.lex_state = 6, .external_lex_state = 2},
  [797] = {.lex_state = 6, .external_lex_state = 2},
  [798] = {.lex_state = 6, .external_lex_state = 2},
  [799] = {.lex_state = 6, .external_lex_state = 2},
  [800] = {.lex_state = 6, .external_lex_state = 2},
  [801] = {.lex_state = 6, .external_lex_state = 2},
  [802] = {.lex_state = 6, .external_lex_state = 2},
  [803] = {.lex_state = 6, .external_lex_state = 2},
  [804] = {.lex_state = 6, .external_lex_state = 2},
  [805] = {.lex_state = 6, .external_lex_state = 2},
  [806] = {.lex_state = 6, .external_lex_state = 2},
  [807] = {.lex_state = 6, .external_lex_state = 2},
  [808] = {.lex_state = 6, .external_lex_state = 2},
  [809] = {.lex_state = 6, .external_lex_state = 2},
  [810] = {.lex_state = 6, .external_lex_state = 2},
  [811] = {.lex_state = 6, .external_lex_state = 2},
  [812] = {.lex_state = 6, .external_lex_state = 2},
  [813] = {.lex_state = 6, .external_lex_state = 2},
  [814] = {.lex_state = 6, .external_lex_state = 2},
  [815] = {.lex_state = 6, .external_lex_state = 2},
  [816] = {.lex_state = 6, .external_lex_state = 2},
  [817] = {.lex_state = 6, .external_lex_state = 2},
  [818] = {.lex_state = 6, .external_lex_state = 2},
  [819] = {.lex_state = 6, .external_lex_state = 2},
  [820] = {.lex_state = 6, .external_lex_state = 2},
  [821] = {.lex_state = 6, .external_lex_state = 2},
  [822] = {.lex_state = 6, .external_lex_state = 2},
  [823] = {.lex_state = 6, .external_lex_state = 2},
  [824] = {.lex_state = 6, .external_lex_state = 2},
  [825] = {.lex_state = 6, .external_lex_state = 2},
  [826] = {.lex_state = 6, .external_lex_state = 2},
  [827] = {.lex_state = 6, .external_lex_state = 2},
  [828] = {.lex_state = 6, .external_lex_state = 2},
  [829] = {.lex_state = 6, .external_lex_state = 2},
  [830] = {.lex_state = 6, .external_lex_state = 2},
  [831] = {.lex_state = 6, .external_lex_state = 2},
  [832] = {.lex_state = 6, .external_lex_state = 2},
  [833] = {.lex_state = 6, .external_lex_state = 2},
  [834] = {.lex_state = 6, .external_lex_state = 2},
  [835] = {.lex_state = 6, .external_lex_state = 2},
  [836] = {.lex_state = 6, .external_lex_state = 2},
  [837] = {.lex_state = 6, .external_lex_state = 2},
  [838] = {.lex_state = 6, .external_lex_state = 2},
  [839] = {.lex_state = 6, .external_lex_state = 2},
  [840] = {.lex_state = 6, .external_lex_state = 2},
  [841] = {.lex_state = 6, .external_lex_state = 2},
  [842] = {.lex_state = 6, .external_lex_state = 2},
  [843] = {.lex_state = 6, .external_lex_state = 2},
  [844] = {.lex_state = 6, .external_lex_state = 2},
  [845] = {.lex_state = 6, .external_lex_state = 2},
  [846] = {.lex_state = 6, .external_lex_state = 2},
  [847] = {.lex_state = 6, .external_lex_state = 2},
  [848] = {.lex_state = 6, .external_lex_state = 2},
  [849] = {.lex_state = 6, .external_lex_state = 2},
  [850] = {.lex_state = 6, .external_lex_state = 2},
  [851] = {.lex_state = 6, .external_lex_state = 2},
  [852] = {.lex_state = 6, .external_lex_state = 2},
  [853] = {.lex_state = 6, .external_lex_state = 2},
  [854] = {.lex_state = 6, .external_lex_state = 2},
  [855] = {.lex_state = 6, .external_lex_state = 2},
  [856] = {.lex_state = 6, .external_lex_state = 2},
  [857] = {.lex_state = 6, .external_lex_state = 2},
  [858] = {.lex_state = 6, .external_lex_state = 2},
  [859] = {.lex_state = 6, .external_lex_state = 2},
  [860] = {.lex_state = 7, .external_lex_state = 2},
  [861] = {.lex_state = 6, .external_lex_state = 2},
  [862] = {.lex_state = 85},
  [863] = {.lex_state = 85},
  [864] = {.lex_state = 85},
  [865] = {.lex_state = 85},
  [866] = {.lex_state = 85},
  [867] = {.lex_state = 85},
  [868] = {.lex_state = 85},
  [869] = {.lex_state = 85},
  [870] = {.lex_state = 85},
  [871] = {.lex_state = 85},
  [872] = {.lex_state = 85},
  [873] = {.lex_state = 85},
  [874] = {.lex_state = 85},
  [875] = {.lex_state = 85},
  [876] = {.lex_state = 85},
  [877] = {.lex_state = 85},
  [878] = {.lex_state = 85},
  [879] = {.lex_state = 85},
  [880] = {.lex_state = 85},
  [881] = {.lex_state = 85},
  [882] = {.lex_state = 85},
  [883] = {.lex_state = 85},
  [884] = {.lex_state = 85},
  [885] = {.lex_state = 85},
  [886] = {.lex_state = 85},
  [887] = {.lex_state = 85},
  [888] = {.lex_state = 85},
  [889] = {.lex_state = 85},
  [890] = {.lex_state = 85},
  [891] = {.lex_state = 85},
  [892] = {.lex_state = 85},
  [893] = {.lex_state = 85},
  [894] = {.lex_state = 85},
  [895] = {.lex_state = 85},
  [896] = {.lex_state = 85},
  [897] = {.lex_state = 85},
  [898] = {.lex_state = 85},
  [899] = {.lex_state = 85},
  [900] = {.lex_state = 85},
  [901] = {.lex_state = 85},
  [902] = {.lex_state = 85},
  [903] = {.lex_state = 85},
  [904] = {.lex_state = 85},
  [905] = {.lex_state = 85},
  [906] = {.lex_state = 85, .external_lex_state = 4},
  [907] = {.lex_state = 85, .external_lex_state = 4},
  [908] = {.lex_state = 85},
  [909] = {.lex_state = 85, .external_lex_state = 4},
  [910] = {.lex_state = 85, .external_lex_state = 4},
  [911] = {.lex_state = 85},
  [912] = {.lex_state = 85, .external_lex_state = 4},
  [913] = {.lex_state = 85, .external_lex_state = 4},
  [914] = {.lex_state = 85},
  [915] = {.lex_state = 85},
  [916] = {.lex_state = 85, .external_lex_state = 4},
  [917] = {.lex_state = 85, .external_lex_state = 4},
  [918] = {.lex_state = 85, .external_lex_state = 4},
  [919] = {.lex_state = 85, .external_lex_state = 4},
  [920] = {.lex_state = 85},
  [921] = {.lex_state = 85, .external_lex_state = 4},
  [922] = {.lex_state = 85},
  [923] = {.lex_state = 85, .external_lex_state = 4},
  [924] = {.lex_state = 85},
  [925] = {.lex_state = 84},
  [926] = {.lex_state = 85},
  [927] = {.lex_state = 85},
  [928] = {.lex_state = 85},
  [929] = {.lex_state = 85},
  [930] = {.lex_state = 85},
  [931] = {.lex_state = 85},
  [932] = {.lex_state = 85},
  [933] = {.lex_state = 85},
  [934] = {.lex_state = 85},
  [935] = {.lex_state = 85},
  [936] = {.lex_state = 85},
  [937] = {.lex_state = 85},
  [938] = {.lex_state = 85},
  [939] = {.lex_state = 85},
  [940] = {.lex_state = 85},
  [941] = {.lex_state = 85},
  [942] = {.lex_state = 85},
  [943] = {.lex_state = 85},
  [944] = {.lex_state = 85},
  [945] = {.lex_state = 85},
  [946] = {.lex_state = 85},
  [947] = {.lex_state = 85},
  [948] = {.lex_state = 84},
  [949] = {.lex_state = 85},
  [950] = {.lex_state = 85},
  [951] = {.lex_state = 85},
  [952] = {.lex_state = 85},
  [953] = {.lex_state = 85},
  [954] = {.lex_state = 85},
  [955] = {.lex_state = 85},
  [956] = {.lex_state = 85},
  [957] = {.lex_state = 5},
  [958] = {.lex_state = 85},
  [959] = {.lex_state = 85},
  [960] = {.lex_state = 85},
  [961] = {.lex_state = 85},
  [962] = {.lex_state = 85},
  [963] = {.lex_state = 5},
  [964] = {.lex_state = 85},
  [965] = {.lex_state = 5},
  [966] = {.lex_state = 85},
  [967] = {.lex_state = 85},
  [968] = {.lex_state = 5},
  [969] = {.lex_state = 85},
  [970] = {.lex_state = 85},
  [971] = {.lex_state = 85},
  [972] = {.lex_state = 85},
  [973] = {.lex_state = 85},
  [974] = {.lex_state = 85},
  [975] = {.lex_state = 5},
  [976] = {.lex_state = 85},
  [977] = {.lex_state = 85},
  [978] = {.lex_state = 85},
  [979] = {.lex_state = 85},
  [980] = {.lex_state = 85},
  [981] = {.lex_state = 85},
  [982] = {.lex_state = 85},
  [983] = {.lex_state = 85},
  [984] = {.lex_state = 85},
  [985] = {.lex_state = 85},
  [986] = {.lex_state = 85},
  [987] = {.lex_state = 85},
  [988] = {.lex_state = 85},
  [989] = {.lex_state = 85},
  [990] = {.lex_state = 9},
  [991] = {.lex_state = 9},
  [992] = {.lex_state = 9},
  [993] = {.lex_state = 9},
  [994] = {.lex_state = 9},
  [995] = {.lex_state = 9},
  [996] = {.lex_state = 9},
  [997] = {.lex_state = 9},
  [998] = {.lex_state = 21},
  [999] = {.lex_state = 21},
  [1000] = {.lex_state = 21},
  [1001] = {.lex_state = 21},
  [1002] = {.lex_state = 21},
  [1003] = {.lex_state = 21},
  [1004] = {.lex_state = 9},
  [1005] = {.lex_state = 9},
  [1006] = {.lex_state = 21},
  [1007] = {.lex_state = 9},
  [1008] = {.lex_state = 9},
  [1009] = {.lex_state = 9},
  [1010] = {.lex_state = 9},
  [1011] = {.lex_state = 21},
  [1012] = {.lex_state = 9},
  [1013] = {.lex_state = 9},
  [1014] = {.lex_state = 21},
  [1015] = {.lex_state = 21},
  [1016] = {.lex_state = 21},
  [1017] = {.lex_state = 9},
  [1018] = {.lex_state = 21},
  [1019] = {.lex_state = 21},
  [1020] = {.lex_state = 9},
  [1021] = {.lex_state = 9},
  [1022] = {.lex_state = 21},
  [1023] = {.lex_state = 9},
  [1024] = {.lex_state = 9},
  [1025] = {.lex_state = 9},
  [1026] = {.lex_state = 9},
  [1027] = {.lex_state = 21},
  [1028] = {.lex_state = 9},
  [1029] = {.lex_state = 21},
  [1030] = {.lex_state = 9},
  [1031] = {.lex_state = 9},
  [1032] = {.lex_state = 9},
  [1033] = {.lex_state = 9},
  [1034] = {.lex_state = 9},
  [1035] = {.lex_state = 9},
  [1036] = {.lex_state = 9},
  [1037] = {.lex_state = 9},
  [1038] = {.lex_state = 9},
  [1039] = {.lex_state = 9},
  [1040] = {.lex_state = 9},
  [1041] = {.lex_state = 21},
  [1042] = {.lex_state = 85},
  [1043] = {.lex_state = 85},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 9},
  [1046] = {.lex_state = 9},
  [1047] = {.lex_state = 85},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 85},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 85},
  [1053] = {.lex_state = 85},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 85},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 85},
  [1059] = {.lex_state = 85, .external_lex_state = 4},
  [1060] = {.lex_state = 85},
  [1061] = {.lex_state = 9},
  [1062] = {.lex_state = 85},
  [1063] = {.lex_state = 85, .external_lex_state = 4},
  [1064] = {.lex_state = 0, .external_lex_state = 4},
  [1065] = {.lex_state = 11, .external_lex_state = 5},
  [1066] = {.lex_state = 9},
  [1067] = {.lex_state = 9},
  [1068] = {.lex_state = 0, .external_lex_state = 4},
  [1069] = {.lex_state = 0, .external_lex_state = 4},
  [1070] = {.lex_state = 9},
  [1071] = {.lex_state = 0, .external_lex_state = 4},
  [1072] = {.lex_state = 9},
  [1073] = {.lex_state = 85, .external_lex_state = 4},
  [1074] = {.lex_state = 11, .external_lex_state = 5},
  [1075] = {.lex_state = 85},
  [1076] = {.lex_state = 9},
  [1077] = {.lex_state = 9},
  [1078] = {.lex_state = 9},
  [1079] = {.lex_state = 9},
  [1080] = {.lex_state = 9},
  [1081] = {.lex_state = 85},
  [1082] = {.lex_state = 85, .external_lex_state = 4},
  [1083] = {.lex_state = 85, .external_lex_state = 4},
  [1084] = {.lex_state = 85, .external_lex_state = 4},
  [1085] = {.lex_state = 85, .external_lex_state = 4},
  [1086] = {.lex_state = 85},
  [1087] = {.lex_state = 85},
  [1088] = {.lex_state = 85, .external_lex_state = 4},
  [1089] = {.lex_state = 11, .external_lex_state = 5},
  [1090] = {.lex_state = 9},
  [1091] = {.lex_state = 11, .external_lex_state = 5},
  [1092] = {.lex_state = 11, .external_lex_state = 5},
  [1093] = {.lex_state = 85, .external_lex_state = 4},
  [1094] = {.lex_state = 9},
  [1095] = {.lex_state = 9},
  [1096] = {.lex_state = 9},
  [1097] = {.lex_state = 9},
  [1098] = {.lex_state = 85},
  [1099] = {.lex_state = 85, .external_lex_state = 4},
  [1100] = {.lex_state = 9},
  [1101] = {.lex_state = 85},
  [1102] = {.lex_state = 9},
  [1103] = {.lex_state = 85},
  [1104] = {.lex_state = 9},
  [1105] = {.lex_state = 9},
  [1106] = {.lex_state = 9},
  [1107] = {.lex_state = 9},
  [1108] = {.lex_state = 9},
  [1109] = {.lex_state = 9},
  [1110] = {.lex_state = 9},
  [1111] = {.lex_state = 9},
  [1112] = {.lex_state = 85},
  [1113] = {.lex_state = 85},
  [1114] = {.lex_state = 85, .external_lex_state = 4},
  [1115] = {.lex_state = 9},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 85},
  [1118] = {.lex_state = 85},
  [1119] = {.lex_state = 0},
  [1120] = {.lex_state = 9},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 85},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 0},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 85},
  [1127] = {.lex_state = 85},
  [1128] = {.lex_state = 0, .external_lex_state = 4},
  [1129] = {.lex_state = 9},
  [1130] = {.lex_state = 85},
  [1131] = {.lex_state = 9},
  [1132] = {.lex_state = 85},
  [1133] = {.lex_state = 9},
  [1134] = {.lex_state = 9},
  [1135] = {.lex_state = 9},
  [1136] = {.lex_state = 85},
  [1137] = {.lex_state = 9},
  [1138] = {.lex_state = 9},
  [1139] = {.lex_state = 85},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 9},
  [1142] = {.lex_state = 0},
  [1143] = {.lex_state = 0, .external_lex_state = 4},
  [1144] = {.lex_state = 1},
  [1145] = {.lex_state = 0, .external_lex_state = 4},
  [1146] = {.lex_state = 85},
  [1147] = {.lex_state = 0, .external_lex_state = 4},
  [1148] = {.lex_state = 9},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 13},
  [1151] = {.lex_state = 10},
  [1152] = {.lex_state = 85},
  [1153] = {.lex_state = 0, .external_lex_state = 4},
  [1154] = {.lex_state = 85},
  [1155] = {.lex_state = 85},
  [1156] = {.lex_state = 0},
  [1157] = {.lex_state = 13},
  [1158] = {.lex_state = 10},
  [1159] = {.lex_state = 0, .external_lex_state = 4},
  [1160] = {.lex_state = 85},
  [1161] = {.lex_state = 85},
  [1162] = {.lex_state = 85},
  [1163] = {.lex_state = 85},
  [1164] = {.lex_state = 0, .external_lex_state = 4},
  [1165] = {.lex_state = 13},
  [1166] = {.lex_state = 10},
  [1167] = {.lex_state = 9},
  [1168] = {.lex_state = 10},
  [1169] = {.lex_state = 13},
  [1170] = {.lex_state = 10},
  [1171] = {.lex_state = 85},
  [1172] = {.lex_state = 0, .external_lex_state = 4},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 1},
  [1175] = {.lex_state = 1},
  [1176] = {.lex_state = 13},
  [1177] = {.lex_state = 13},
  [1178] = {.lex_state = 10},
  [1179] = {.lex_state = 85},
  [1180] = {.lex_state = 85},
  [1181] = {.lex_state = 11, .external_lex_state = 5},
  [1182] = {.lex_state = 85},
  [1183] = {.lex_state = 9},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 85},
  [1186] = {.lex_state = 1},
  [1187] = {.lex_state = 85},
  [1188] = {.lex_state = 10},
  [1189] = {.lex_state = 0, .external_lex_state = 4},
  [1190] = {.lex_state = 13},
  [1191] = {.lex_state = 85, .external_lex_state = 4},
  [1192] = {.lex_state = 85},
  [1193] = {.lex_state = 1},
  [1194] = {.lex_state = 85},
  [1195] = {.lex_state = 9},
  [1196] = {.lex_state = 85},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 85},
  [1199] = {.lex_state = 85},
  [1200] = {.lex_state = 0},
  [1201] = {.lex_state = 85},
  [1202] = {.lex_state = 85},
  [1203] = {.lex_state = 85},
  [1204] = {.lex_state = 10},
  [1205] = {.lex_state = 13},
  [1206] = {.lex_state = 0, .external_lex_state = 4},
  [1207] = {.lex_state = 85},
  [1208] = {.lex_state = 85},
  [1209] = {.lex_state = 85},
  [1210] = {.lex_state = 85},
  [1211] = {.lex_state = 85},
  [1212] = {.lex_state = 85},
  [1213] = {.lex_state = 10},
  [1214] = {.lex_state = 85},
  [1215] = {.lex_state = 13},
  [1216] = {.lex_state = 1},
  [1217] = {.lex_state = 0},
  [1218] = {.lex_state = 0},
  [1219] = {.lex_state = 21},
  [1220] = {.lex_state = 0},
  [1221] = {.lex_state = 0},
  [1222] = {.lex_state = 0},
  [1223] = {.lex_state = 21},
  [1224] = {.lex_state = 85},
  [1225] = {.lex_state = 0},
  [1226] = {.lex_state = 4},
  [1227] = {.lex_state = 85},
  [1228] = {.lex_state = 85},
  [1229] = {.lex_state = 85},
  [1230] = {.lex_state = 85},
  [1231] = {.lex_state = 0},
  [1232] = {.lex_state = 21},
  [1233] = {.lex_state = 0},
  [1234] = {.lex_state = 0},
  [1235] = {.lex_state = 21},
  [1236] = {.lex_state = 4},
  [1237] = {.lex_state = 0},
  [1238] = {.lex_state = 85, .external_lex_state = 4},
  [1239] = {.lex_state = 85},
  [1240] = {.lex_state = 0},
  [1241] = {.lex_state = 85, .external_lex_state = 4},
  [1242] = {.lex_state = 0},
  [1243] = {.lex_state = 85, .external_lex_state = 4},
  [1244] = {.lex_state = 0},
  [1245] = {.lex_state = 0},
  [1246] = {.lex_state = 21},
  [1247] = {.lex_state = 0},
  [1248] = {.lex_state = 85},
  [1249] = {.lex_state = 21},
  [1250] = {.lex_state = 1},
  [1251] = {.lex_state = 0},
  [1252] = {.lex_state = 0},
  [1253] = {.lex_state = 0},
  [1254] = {.lex_state = 0},
  [1255] = {.lex_state = 21},
  [1256] = {.lex_state = 0},
  [1257] = {.lex_state = 21},
  [1258] = {.lex_state = 0},
  [1259] = {.lex_state = 0},
  [1260] = {.lex_state = 0},
  [1261] = {.lex_state = 85},
  [1262] = {.lex_state = 0},
  [1263] = {.lex_state = 0},
  [1264] = {.lex_state = 85},
  [1265] = {.lex_state = 0},
  [1266] = {.lex_state = 85},
  [1267] = {.lex_state = 0},
  [1268] = {.lex_state = 21},
  [1269] = {.lex_state = 85},
  [1270] = {.lex_state = 21},
  [1271] = {.lex_state = 0, .external_lex_state = 4},
  [1272] = {.lex_state = 21},
  [1273] = {.lex_state = 0},
  [1274] = {.lex_state = 0},
  [1275] = {.lex_state = 0},
  [1276] = {.lex_state = 85, .external_lex_state = 4},
  [1277] = {.lex_state = 21},
  [1278] = {.lex_state = 21},
  [1279] = {.lex_state = 21},
  [1280] = {.lex_state = 21},
  [1281] = {.lex_state = 0},
  [1282] = {.lex_state = 0},
  [1283] = {.lex_state = 0},
  [1284] = {.lex_state = 0},
  [1285] = {.lex_state = 21},
  [1286] = {.lex_state = 0},
  [1287] = {.lex_state = 0},
  [1288] = {.lex_state = 0},
  [1289] = {.lex_state = 0},
  [1290] = {.lex_state = 0},
  [1291] = {.lex_state = 0},
  [1292] = {.lex_state = 0},
  [1293] = {.lex_state = 0},
  [1294] = {.lex_state = 85},
  [1295] = {.lex_state = 85, .external_lex_state = 4},
  [1296] = {.lex_state = 0},
  [1297] = {.lex_state = 0},
  [1298] = {.lex_state = 0},
  [1299] = {.lex_state = 0},
  [1300] = {.lex_state = 0},
  [1301] = {.lex_state = 0},
  [1302] = {.lex_state = 0},
  [1303] = {.lex_state = 85},
  [1304] = {.lex_state = 0},
  [1305] = {.lex_state = 85},
  [1306] = {.lex_state = 4},
  [1307] = {.lex_state = 0},
  [1308] = {.lex_state = 0},
  [1309] = {.lex_state = 85},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 85},
  [1312] = {.lex_state = 0},
  [1313] = {.lex_state = 0},
  [1314] = {.lex_state = 0},
  [1315] = {.lex_state = 21},
  [1316] = {.lex_state = 85, .external_lex_state = 4},
  [1317] = {.lex_state = 85, .external_lex_state = 4},
  [1318] = {.lex_state = 85},
  [1319] = {.lex_state = 85},
  [1320] = {.lex_state = 85, .external_lex_state = 4},
  [1321] = {.lex_state = 0},
  [1322] = {.lex_state = 0},
  [1323] = {.lex_state = 85},
  [1324] = {.lex_state = 85},
  [1325] = {.lex_state = 85},
  [1326] = {.lex_state = 0},
  [1327] = {.lex_state = 85},
  [1328] = {.lex_state = 4},
  [1329] = {.lex_state = 0, .external_lex_state = 4},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 0},
  [1332] = {.lex_state = 0},
  [1333] = {.lex_state = 85},
  [1334] = {.lex_state = 0},
  [1335] = {.lex_state = 0},
  [1336] = {.lex_state = 85},
  [1337] = {.lex_state = 0},
  [1338] = {.lex_state = 0},
  [1339] = {.lex_state = 0},
  [1340] = {.lex_state = 0},
  [1341] = {.lex_state = 0},
  [1342] = {.lex_state = 0},
  [1343] = {.lex_state = 9},
  [1344] = {.lex_state = 0, .external_lex_state = 4},
  [1345] = {.lex_state = 0},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 85},
  [1348] = {.lex_state = 0},
  [1349] = {.lex_state = 0},
  [1350] = {.lex_state = 0},
  [1351] = {.lex_state = 85},
  [1352] = {.lex_state = 4},
  [1353] = {.lex_state = 4},
  [1354] = {.lex_state = 0},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 85},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 4},
  [1359] = {.lex_state = 85},
  [1360] = {.lex_state = 85},
  [1361] = {.lex_state = 0},
  [1362] = {.lex_state = 0},
  [1363] = {.lex_state = 0},
  [1364] = {.lex_state = 0, .external_lex_state = 4},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 0},
  [1367] = {.lex_state = 0, .external_lex_state = 4},
  [1368] = {.lex_state = 0},
  [1369] = {.lex_state = 0, .external_lex_state = 4},
  [1370] = {.lex_state = 0, .external_lex_state = 4},
  [1371] = {.lex_state = 0},
  [1372] = {.lex_state = 0},
  [1373] = {.lex_state = 0},
  [1374] = {.lex_state = 85},
  [1375] = {.lex_state = 0},
  [1376] = {.lex_state = 0},
  [1377] = {.lex_state = 0},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 0},
  [1380] = {.lex_state = 0},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 0},
  [1383] = {.lex_state = 0},
  [1384] = {.lex_state = 85},
  [1385] = {.lex_state = 0},
  [1386] = {.lex_state = 0},
  [1387] = {.lex_state = 0},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 0},
  [1391] = {.lex_state = 0},
  [1392] = {.lex_state = 0, .external_lex_state = 4},
  [1393] = {.lex_state = 0},
  [1394] = {.lex_state = 0},
  [1395] = {.lex_state = 0},
  [1396] = {.lex_state = 0, .external_lex_state = 4},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 0},
  [1399] = {.lex_state = 0},
  [1400] = {.lex_state = 0},
  [1401] = {.lex_state = 0},
  [1402] = {.lex_state = 0},
  [1403] = {.lex_state = 0},
  [1404] = {.lex_state = 0, .external_lex_state = 4},
  [1405] = {.lex_state = 0},
  [1406] = {.lex_state = 0},
  [1407] = {.lex_state = 0},
  [1408] = {.lex_state = 0},
  [1409] = {.lex_state = 0},
  [1410] = {.lex_state = 0},
  [1411] = {.lex_state = 0},
  [1412] = {.lex_state = 0},
  [1413] = {.lex_state = 0, .external_lex_state = 4},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 0},
  [1416] = {.lex_state = 0},
  [1417] = {.lex_state = 0},
  [1418] = {.lex_state = 0, .external_lex_state = 4},
  [1419] = {.lex_state = 0},
  [1420] = {.lex_state = 0},
  [1421] = {.lex_state = 0},
  [1422] = {.lex_state = 0, .external_lex_state = 4},
  [1423] = {.lex_state = 0, .external_lex_state = 4},
  [1424] = {.lex_state = 0},
  [1425] = {.lex_state = 0},
  [1426] = {.lex_state = 0},
  [1427] = {.lex_state = 0},
  [1428] = {.lex_state = 85},
  [1429] = {.lex_state = 0, .external_lex_state = 4},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 0},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 0},
  [1434] = {.lex_state = 0},
  [1435] = {.lex_state = 0},
  [1436] = {.lex_state = 0},
  [1437] = {.lex_state = 0},
  [1438] = {.lex_state = 4},
  [1439] = {.lex_state = 85},
  [1440] = {.lex_state = 0},
  [1441] = {.lex_state = 0},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 0},
  [1444] = {.lex_state = 0},
  [1445] = {.lex_state = 0},
  [1446] = {.lex_state = 0},
  [1447] = {.lex_state = 0, .external_lex_state = 4},
  [1448] = {.lex_state = 0},
  [1449] = {.lex_state = 0, .external_lex_state = 4},
  [1450] = {.lex_state = 0},
  [1451] = {.lex_state = 1},
  [1452] = {.lex_state = 0},
  [1453] = {.lex_state = 0},
  [1454] = {.lex_state = 0},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 0},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 85},
  [1459] = {.lex_state = 85},
  [1460] = {.lex_state = 0},
  [1461] = {.lex_state = 0},
  [1462] = {.lex_state = 0},
  [1463] = {.lex_state = 0, .external_lex_state = 4},
  [1464] = {.lex_state = 0},
  [1465] = {.lex_state = 85},
  [1466] = {.lex_state = 0},
  [1467] = {.lex_state = 0},
  [1468] = {.lex_state = 0},
  [1469] = {.lex_state = 0},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 0},
  [1472] = {.lex_state = 0},
  [1473] = {.lex_state = 0},
  [1474] = {.lex_state = 0},
  [1475] = {.lex_state = 0},
  [1476] = {.lex_state = 0},
  [1477] = {.lex_state = 0},
  [1478] = {.lex_state = 0},
  [1479] = {.lex_state = 0},
  [1480] = {.lex_state = 0},
  [1481] = {.lex_state = 0},
  [1482] = {.lex_state = 0},
  [1483] = {.lex_state = 0},
  [1484] = {.lex_state = 0},
  [1485] = {.lex_state = 0},
  [1486] = {.lex_state = 0},
  [1487] = {.lex_state = 0},
  [1488] = {.lex_state = 0, .external_lex_state = 4},
  [1489] = {.lex_state = 0},
  [1490] = {.lex_state = 0, .external_lex_state = 4},
  [1491] = {.lex_state = 0, .external_lex_state = 4},
  [1492] = {.lex_state = 0, .external_lex_state = 4},
  [1493] = {.lex_state = 0},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 85},
  [1497] = {.lex_state = 0},
  [1498] = {.lex_state = 0},
  [1499] = {.lex_state = 0},
  [1500] = {.lex_state = 0},
  [1501] = {.lex_state = 85},
  [1502] = {.lex_state = 2},
  [1503] = {.lex_state = 2},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 85},
  [1506] = {.lex_state = 0},
  [1507] = {.lex_state = 11},
  [1508] = {.lex_state = 0},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 0},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 85},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 85},
  [1516] = {.lex_state = 0},
  [1517] = {.lex_state = 0},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 85},
  [1520] = {.lex_state = 0},
  [1521] = {.lex_state = 0},
  [1522] = {.lex_state = 85},
  [1523] = {.lex_state = 85},
  [1524] = {.lex_state = 0},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 0},
  [1527] = {.lex_state = 85},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 2},
  [1531] = {.lex_state = 85},
  [1532] = {.lex_state = 0},
  [1533] = {.lex_state = 85},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 85},
  [1536] = {.lex_state = 85},
  [1537] = {.lex_state = 85},
  [1538] = {.lex_state = 85},
  [1539] = {.lex_state = 85},
  [1540] = {.lex_state = 85},
  [1541] = {.lex_state = 0},
  [1542] = {.lex_state = 85},
  [1543] = {.lex_state = 85},
  [1544] = {.lex_state = 85},
  [1545] = {.lex_state = 11},
  [1546] = {.lex_state = 0},
  [1547] = {.lex_state = 85},
  [1548] = {.lex_state = 85},
  [1549] = {.lex_state = 85},
  [1550] = {.lex_state = 85},
  [1551] = {.lex_state = 85},
  [1552] = {.lex_state = 85},
  [1553] = {.lex_state = 85},
  [1554] = {.lex_state = 85},
  [1555] = {.lex_state = 85},
  [1556] = {.lex_state = 85},
  [1557] = {.lex_state = 85},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 0},
  [1560] = {.lex_state = 0},
  [1561] = {.lex_state = 11},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 85},
  [1565] = {.lex_state = 0},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 0},
  [1568] = {.lex_state = 85},
  [1569] = {.lex_state = 0},
  [1570] = {.lex_state = 85},
  [1571] = {.lex_state = 85},
  [1572] = {.lex_state = 85},
  [1573] = {.lex_state = 0},
  [1574] = {.lex_state = 0},
  [1575] = {.lex_state = 0},
  [1576] = {.lex_state = 85},
  [1577] = {.lex_state = 85},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 85},
  [1580] = {.lex_state = 85},
  [1581] = {.lex_state = 85},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 85},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 85},
  [1586] = {.lex_state = 85},
  [1587] = {.lex_state = 85},
  [1588] = {.lex_state = 85},
  [1589] = {.lex_state = 85},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 0},
  [1594] = {.lex_state = 2},
  [1595] = {.lex_state = 85},
  [1596] = {.lex_state = 0},
  [1597] = {.lex_state = 0},
  [1598] = {.lex_state = 85},
  [1599] = {.lex_state = 85},
  [1600] = {.lex_state = 85},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 0},
  [1603] = {.lex_state = 0},
  [1604] = {.lex_state = 0},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 11},
  [1607] = {.lex_state = 85},
  [1608] = {.lex_state = 85},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 85},
  [1611] = {.lex_state = 0},
  [1612] = {.lex_state = 0},
  [1613] = {.lex_state = 0},
  [1614] = {.lex_state = 85},
  [1615] = {.lex_state = 0},
};

enum {
  ts_external_token__automatic_semicolon = 0,
  ts_external_token__template_chars = 1,
  ts_external_token__ternary_qmark = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__automatic_semicolon] = sym__automatic_semicolon,
  [ts_external_token__template_chars] = sym__template_chars,
  [ts_external_token__ternary_qmark] = sym__ternary_qmark,
};

static const bool ts_external_scanner_states[6][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__template_chars] = true,
    [ts_external_token__ternary_qmark] = true,
  },
  [2] = {
    [ts_external_token__ternary_qmark] = true,
  },
  [3] = {
    [ts_external_token__automatic_semicolon] = true,
    [ts_external_token__ternary_qmark] = true,
  },
  [4] = {
    [ts_external_token__automatic_semicolon] = true,
  },
  [5] = {
    [ts_external_token__template_chars] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LTtemplate_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [sym_optional_chain] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1582),
    [sym_export_statement] = STATE(17),
    [sym_declaration] = STATE(17),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(17),
    [sym_expression_statement] = STATE(17),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(17),
    [sym_if_statement] = STATE(17),
    [sym_switch_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_for_in_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_do_statement] = STATE(17),
    [sym_try_statement] = STATE(17),
    [sym_with_statement] = STATE(17),
    [sym_break_statement] = STATE(17),
    [sym_continue_statement] = STATE(17),
    [sym_debugger_statement] = STATE(17),
    [sym_return_statement] = STATE(17),
    [sym_throw_statement] = STATE(17),
    [sym_empty_statement] = STATE(17),
    [sym_labeled_statement] = STATE(17),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(17),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_hash_bang_line] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [2] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1563),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1563),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1563),
    [sym_spread_element] = STATE(1302),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(793),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1302),
    [sym_pair] = STATE(1302),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1287),
    [sym_computed_property_name] = STATE(1287),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(911),
    [aux_sym_object_repeat1] = STATE(1282),
    [aux_sym_object_pattern_repeat1] = STATE(1292),
    [sym_identifier] = ACTIONS(91),
    [anon_sym_export] = ACTIONS(93),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(103),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(111),
    [anon_sym_get] = ACTIONS(113),
    [anon_sym_set] = ACTIONS(113),
  },
  [3] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1563),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1563),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1563),
    [sym_spread_element] = STATE(1284),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(793),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1284),
    [sym_pair] = STATE(1284),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1287),
    [sym_computed_property_name] = STATE(1287),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(911),
    [aux_sym_object_repeat1] = STATE(1291),
    [aux_sym_object_pattern_repeat1] = STATE(1292),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_export] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(119),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_get] = ACTIONS(125),
    [anon_sym_set] = ACTIONS(125),
  },
  [4] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1563),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1563),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1563),
    [sym_spread_element] = STATE(1302),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(793),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1302),
    [sym_pair] = STATE(1302),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1287),
    [sym_computed_property_name] = STATE(1287),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(911),
    [aux_sym_object_repeat1] = STATE(1282),
    [aux_sym_object_pattern_repeat1] = STATE(1292),
    [sym_identifier] = ACTIONS(127),
    [anon_sym_export] = ACTIONS(129),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(131),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(133),
    [anon_sym_get] = ACTIONS(135),
    [anon_sym_set] = ACTIONS(135),
  },
  [5] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1563),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1563),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1563),
    [sym_spread_element] = STATE(1284),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(793),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1284),
    [sym_pair] = STATE(1284),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1287),
    [sym_computed_property_name] = STATE(1287),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(911),
    [aux_sym_object_repeat1] = STATE(1291),
    [aux_sym_object_pattern_repeat1] = STATE(1292),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_export] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(137),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_get] = ACTIONS(125),
    [anon_sym_set] = ACTIONS(125),
  },
  [6] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1563),
    [sym_object_assignment_pattern] = STATE(1281),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1563),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1563),
    [sym_spread_element] = STATE(1284),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(793),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [sym_rest_pattern] = STATE(1281),
    [sym_method_definition] = STATE(1284),
    [sym_pair] = STATE(1284),
    [sym_pair_pattern] = STATE(1281),
    [sym__property_name] = STATE(1287),
    [sym_computed_property_name] = STATE(1287),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(911),
    [aux_sym_object_repeat1] = STATE(1291),
    [aux_sym_object_pattern_repeat1] = STATE(1292),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_export] = ACTIONS(117),
    [anon_sym_STAR] = ACTIONS(95),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_COMMA] = ACTIONS(97),
    [anon_sym_RBRACE] = ACTIONS(139),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(101),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(121),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(107),
    [sym_private_property_identifier] = ACTIONS(109),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(123),
    [anon_sym_get] = ACTIONS(125),
    [anon_sym_set] = ACTIONS(125),
  },
  [7] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [ts_builtin_sym_end] = ACTIONS(141),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_export] = ACTIONS(146),
    [anon_sym_default] = ACTIONS(149),
    [anon_sym_LBRACE] = ACTIONS(151),
    [anon_sym_RBRACE] = ACTIONS(141),
    [anon_sym_import] = ACTIONS(154),
    [anon_sym_var] = ACTIONS(157),
    [anon_sym_let] = ACTIONS(160),
    [anon_sym_const] = ACTIONS(160),
    [anon_sym_if] = ACTIONS(163),
    [anon_sym_switch] = ACTIONS(166),
    [anon_sym_for] = ACTIONS(169),
    [anon_sym_LPAREN] = ACTIONS(172),
    [anon_sym_await] = ACTIONS(175),
    [anon_sym_while] = ACTIONS(178),
    [anon_sym_do] = ACTIONS(181),
    [anon_sym_try] = ACTIONS(184),
    [anon_sym_with] = ACTIONS(187),
    [anon_sym_break] = ACTIONS(190),
    [anon_sym_continue] = ACTIONS(193),
    [anon_sym_debugger] = ACTIONS(196),
    [anon_sym_return] = ACTIONS(199),
    [anon_sym_throw] = ACTIONS(202),
    [anon_sym_SEMI] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(149),
    [anon_sym_yield] = ACTIONS(208),
    [anon_sym_LBRACK] = ACTIONS(211),
    [anon_sym_LTtemplate_GT] = ACTIONS(214),
    [anon_sym_LT] = ACTIONS(217),
    [anon_sym_SLASH] = ACTIONS(220),
    [anon_sym_class] = ACTIONS(223),
    [anon_sym_async] = ACTIONS(226),
    [anon_sym_function] = ACTIONS(229),
    [anon_sym_new] = ACTIONS(232),
    [anon_sym_PLUS] = ACTIONS(235),
    [anon_sym_DASH] = ACTIONS(235),
    [anon_sym_BANG] = ACTIONS(238),
    [anon_sym_TILDE] = ACTIONS(238),
    [anon_sym_typeof] = ACTIONS(235),
    [anon_sym_void] = ACTIONS(235),
    [anon_sym_delete] = ACTIONS(235),
    [anon_sym_PLUS_PLUS] = ACTIONS(241),
    [anon_sym_DASH_DASH] = ACTIONS(241),
    [anon_sym_DQUOTE] = ACTIONS(244),
    [anon_sym_SQUOTE] = ACTIONS(247),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(250),
    [sym_number] = ACTIONS(253),
    [sym_this] = ACTIONS(256),
    [sym_super] = ACTIONS(256),
    [sym_true] = ACTIONS(256),
    [sym_false] = ACTIONS(256),
    [sym_null] = ACTIONS(256),
    [sym_undefined] = ACTIONS(259),
    [anon_sym_AT] = ACTIONS(262),
    [anon_sym_static] = ACTIONS(265),
    [anon_sym_get] = ACTIONS(265),
    [anon_sym_set] = ACTIONS(265),
  },
  [8] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(268),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(270),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(268),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [9] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(272),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(274),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(272),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [10] = {
    [sym_export_statement] = STATE(9),
    [sym_declaration] = STATE(9),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(9),
    [sym_expression_statement] = STATE(9),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_switch_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_for_in_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_do_statement] = STATE(9),
    [sym_try_statement] = STATE(9),
    [sym_with_statement] = STATE(9),
    [sym_break_statement] = STATE(9),
    [sym_continue_statement] = STATE(9),
    [sym_debugger_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_throw_statement] = STATE(9),
    [sym_empty_statement] = STATE(9),
    [sym_labeled_statement] = STATE(9),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(276),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(278),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(276),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [11] = {
    [sym_export_statement] = STATE(8),
    [sym_declaration] = STATE(8),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(8),
    [sym_expression_statement] = STATE(8),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_switch_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_for_in_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_do_statement] = STATE(8),
    [sym_try_statement] = STATE(8),
    [sym_with_statement] = STATE(8),
    [sym_break_statement] = STATE(8),
    [sym_continue_statement] = STATE(8),
    [sym_debugger_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_throw_statement] = STATE(8),
    [sym_empty_statement] = STATE(8),
    [sym_labeled_statement] = STATE(8),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(8),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_default] = ACTIONS(280),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(282),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_case] = ACTIONS(280),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [12] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(284),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [13] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [ts_builtin_sym_end] = ACTIONS(286),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [14] = {
    [sym_export_statement] = STATE(20),
    [sym_declaration] = STATE(20),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(20),
    [sym_expression_statement] = STATE(20),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(20),
    [sym_if_statement] = STATE(20),
    [sym_switch_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_for_in_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_do_statement] = STATE(20),
    [sym_try_statement] = STATE(20),
    [sym_with_statement] = STATE(20),
    [sym_break_statement] = STATE(20),
    [sym_continue_statement] = STATE(20),
    [sym_debugger_statement] = STATE(20),
    [sym_return_statement] = STATE(20),
    [sym_throw_statement] = STATE(20),
    [sym_empty_statement] = STATE(20),
    [sym_labeled_statement] = STATE(20),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(20),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(288),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [15] = {
    [sym_export_statement] = STATE(13),
    [sym_declaration] = STATE(13),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(13),
    [sym_expression_statement] = STATE(13),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_switch_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_for_in_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_do_statement] = STATE(13),
    [sym_try_statement] = STATE(13),
    [sym_with_statement] = STATE(13),
    [sym_break_statement] = STATE(13),
    [sym_continue_statement] = STATE(13),
    [sym_debugger_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_throw_statement] = STATE(13),
    [sym_empty_statement] = STATE(13),
    [sym_labeled_statement] = STATE(13),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(13),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [ts_builtin_sym_end] = ACTIONS(290),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [16] = {
    [sym_export_statement] = STATE(18),
    [sym_declaration] = STATE(18),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(18),
    [sym_expression_statement] = STATE(18),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(18),
    [sym_if_statement] = STATE(18),
    [sym_switch_statement] = STATE(18),
    [sym_for_statement] = STATE(18),
    [sym_for_in_statement] = STATE(18),
    [sym_while_statement] = STATE(18),
    [sym_do_statement] = STATE(18),
    [sym_try_statement] = STATE(18),
    [sym_with_statement] = STATE(18),
    [sym_break_statement] = STATE(18),
    [sym_continue_statement] = STATE(18),
    [sym_debugger_statement] = STATE(18),
    [sym_return_statement] = STATE(18),
    [sym_throw_statement] = STATE(18),
    [sym_empty_statement] = STATE(18),
    [sym_labeled_statement] = STATE(18),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(292),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [17] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [ts_builtin_sym_end] = ACTIONS(290),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [18] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [19] = {
    [sym_export_statement] = STATE(24),
    [sym_declaration] = STATE(24),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(24),
    [sym_expression_statement] = STATE(24),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(24),
    [sym_if_statement] = STATE(24),
    [sym_switch_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_for_in_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_do_statement] = STATE(24),
    [sym_try_statement] = STATE(24),
    [sym_with_statement] = STATE(24),
    [sym_break_statement] = STATE(24),
    [sym_continue_statement] = STATE(24),
    [sym_debugger_statement] = STATE(24),
    [sym_return_statement] = STATE(24),
    [sym_throw_statement] = STATE(24),
    [sym_empty_statement] = STATE(24),
    [sym_labeled_statement] = STATE(24),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(24),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(296),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [20] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(298),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [21] = {
    [sym_export_statement] = STATE(12),
    [sym_declaration] = STATE(12),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(12),
    [sym_expression_statement] = STATE(12),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(12),
    [sym_if_statement] = STATE(12),
    [sym_switch_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_for_in_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_do_statement] = STATE(12),
    [sym_try_statement] = STATE(12),
    [sym_with_statement] = STATE(12),
    [sym_break_statement] = STATE(12),
    [sym_continue_statement] = STATE(12),
    [sym_debugger_statement] = STATE(12),
    [sym_return_statement] = STATE(12),
    [sym_throw_statement] = STATE(12),
    [sym_empty_statement] = STATE(12),
    [sym_labeled_statement] = STATE(12),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(12),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(300),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [22] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [23] = {
    [sym_export_statement] = STATE(22),
    [sym_declaration] = STATE(22),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(22),
    [sym_expression_statement] = STATE(22),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(22),
    [sym_if_statement] = STATE(22),
    [sym_switch_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_for_in_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_do_statement] = STATE(22),
    [sym_try_statement] = STATE(22),
    [sym_with_statement] = STATE(22),
    [sym_break_statement] = STATE(22),
    [sym_continue_statement] = STATE(22),
    [sym_debugger_statement] = STATE(22),
    [sym_return_statement] = STATE(22),
    [sym_throw_statement] = STATE(22),
    [sym_empty_statement] = STATE(22),
    [sym_labeled_statement] = STATE(22),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(22),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(304),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [24] = {
    [sym_export_statement] = STATE(7),
    [sym_declaration] = STATE(7),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(7),
    [sym_expression_statement] = STATE(7),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(7),
    [sym_if_statement] = STATE(7),
    [sym_switch_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_for_in_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_do_statement] = STATE(7),
    [sym_try_statement] = STATE(7),
    [sym_with_statement] = STATE(7),
    [sym_break_statement] = STATE(7),
    [sym_continue_statement] = STATE(7),
    [sym_debugger_statement] = STATE(7),
    [sym_return_statement] = STATE(7),
    [sym_throw_statement] = STATE(7),
    [sym_empty_statement] = STATE(7),
    [sym_labeled_statement] = STATE(7),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_RBRACE] = ACTIONS(306),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [25] = {
    [sym_export_statement] = STATE(409),
    [sym_declaration] = STATE(409),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(409),
    [sym_expression_statement] = STATE(409),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(409),
    [sym_if_statement] = STATE(409),
    [sym_switch_statement] = STATE(409),
    [sym_for_statement] = STATE(409),
    [sym_for_in_statement] = STATE(409),
    [sym_while_statement] = STATE(409),
    [sym_do_statement] = STATE(409),
    [sym_try_statement] = STATE(409),
    [sym_with_statement] = STATE(409),
    [sym_break_statement] = STATE(409),
    [sym_continue_statement] = STATE(409),
    [sym_debugger_statement] = STATE(409),
    [sym_return_statement] = STATE(409),
    [sym_throw_statement] = STATE(409),
    [sym_empty_statement] = STATE(409),
    [sym_labeled_statement] = STATE(409),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [26] = {
    [sym_export_statement] = STATE(425),
    [sym_declaration] = STATE(425),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(425),
    [sym_expression_statement] = STATE(425),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(425),
    [sym_if_statement] = STATE(425),
    [sym_switch_statement] = STATE(425),
    [sym_for_statement] = STATE(425),
    [sym_for_in_statement] = STATE(425),
    [sym_while_statement] = STATE(425),
    [sym_do_statement] = STATE(425),
    [sym_try_statement] = STATE(425),
    [sym_with_statement] = STATE(425),
    [sym_break_statement] = STATE(425),
    [sym_continue_statement] = STATE(425),
    [sym_debugger_statement] = STATE(425),
    [sym_return_statement] = STATE(425),
    [sym_throw_statement] = STATE(425),
    [sym_empty_statement] = STATE(425),
    [sym_labeled_statement] = STATE(425),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [27] = {
    [sym_export_statement] = STATE(372),
    [sym_declaration] = STATE(372),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(372),
    [sym_expression_statement] = STATE(372),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(372),
    [sym_if_statement] = STATE(372),
    [sym_switch_statement] = STATE(372),
    [sym_for_statement] = STATE(372),
    [sym_for_in_statement] = STATE(372),
    [sym_while_statement] = STATE(372),
    [sym_do_statement] = STATE(372),
    [sym_try_statement] = STATE(372),
    [sym_with_statement] = STATE(372),
    [sym_break_statement] = STATE(372),
    [sym_continue_statement] = STATE(372),
    [sym_debugger_statement] = STATE(372),
    [sym_return_statement] = STATE(372),
    [sym_throw_statement] = STATE(372),
    [sym_empty_statement] = STATE(372),
    [sym_labeled_statement] = STATE(372),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [28] = {
    [sym_export_statement] = STATE(398),
    [sym_declaration] = STATE(397),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(396),
    [sym_expression_statement] = STATE(395),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(394),
    [sym_if_statement] = STATE(393),
    [sym_switch_statement] = STATE(392),
    [sym_for_statement] = STATE(388),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(384),
    [sym_try_statement] = STATE(383),
    [sym_with_statement] = STATE(382),
    [sym_break_statement] = STATE(378),
    [sym_continue_statement] = STATE(377),
    [sym_debugger_statement] = STATE(370),
    [sym_return_statement] = STATE(369),
    [sym_throw_statement] = STATE(367),
    [sym_empty_statement] = STATE(332),
    [sym_labeled_statement] = STATE(364),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [29] = {
    [sym_export_statement] = STATE(310),
    [sym_declaration] = STATE(310),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(310),
    [sym_expression_statement] = STATE(310),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(310),
    [sym_if_statement] = STATE(310),
    [sym_switch_statement] = STATE(310),
    [sym_for_statement] = STATE(310),
    [sym_for_in_statement] = STATE(310),
    [sym_while_statement] = STATE(310),
    [sym_do_statement] = STATE(310),
    [sym_try_statement] = STATE(310),
    [sym_with_statement] = STATE(310),
    [sym_break_statement] = STATE(310),
    [sym_continue_statement] = STATE(310),
    [sym_debugger_statement] = STATE(310),
    [sym_return_statement] = STATE(310),
    [sym_throw_statement] = STATE(310),
    [sym_empty_statement] = STATE(310),
    [sym_labeled_statement] = STATE(310),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [30] = {
    [sym_export_statement] = STATE(368),
    [sym_declaration] = STATE(368),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(368),
    [sym_expression_statement] = STATE(368),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(368),
    [sym_if_statement] = STATE(368),
    [sym_switch_statement] = STATE(368),
    [sym_for_statement] = STATE(368),
    [sym_for_in_statement] = STATE(368),
    [sym_while_statement] = STATE(368),
    [sym_do_statement] = STATE(368),
    [sym_try_statement] = STATE(368),
    [sym_with_statement] = STATE(368),
    [sym_break_statement] = STATE(368),
    [sym_continue_statement] = STATE(368),
    [sym_debugger_statement] = STATE(368),
    [sym_return_statement] = STATE(368),
    [sym_throw_statement] = STATE(368),
    [sym_empty_statement] = STATE(368),
    [sym_labeled_statement] = STATE(368),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [31] = {
    [sym_export_statement] = STATE(365),
    [sym_declaration] = STATE(365),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(365),
    [sym_expression_statement] = STATE(365),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(365),
    [sym_if_statement] = STATE(365),
    [sym_switch_statement] = STATE(365),
    [sym_for_statement] = STATE(365),
    [sym_for_in_statement] = STATE(365),
    [sym_while_statement] = STATE(365),
    [sym_do_statement] = STATE(365),
    [sym_try_statement] = STATE(365),
    [sym_with_statement] = STATE(365),
    [sym_break_statement] = STATE(365),
    [sym_continue_statement] = STATE(365),
    [sym_debugger_statement] = STATE(365),
    [sym_return_statement] = STATE(365),
    [sym_throw_statement] = STATE(365),
    [sym_empty_statement] = STATE(365),
    [sym_labeled_statement] = STATE(365),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [32] = {
    [sym_export_statement] = STATE(390),
    [sym_declaration] = STATE(391),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(366),
    [sym_expression_statement] = STATE(333),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(334),
    [sym_if_statement] = STATE(335),
    [sym_switch_statement] = STATE(336),
    [sym_for_statement] = STATE(337),
    [sym_for_in_statement] = STATE(338),
    [sym_while_statement] = STATE(339),
    [sym_do_statement] = STATE(340),
    [sym_try_statement] = STATE(341),
    [sym_with_statement] = STATE(342),
    [sym_break_statement] = STATE(343),
    [sym_continue_statement] = STATE(344),
    [sym_debugger_statement] = STATE(345),
    [sym_return_statement] = STATE(346),
    [sym_throw_statement] = STATE(347),
    [sym_empty_statement] = STATE(348),
    [sym_labeled_statement] = STATE(349),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [33] = {
    [sym_export_statement] = STATE(357),
    [sym_declaration] = STATE(357),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(357),
    [sym_expression_statement] = STATE(357),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(357),
    [sym_if_statement] = STATE(357),
    [sym_switch_statement] = STATE(357),
    [sym_for_statement] = STATE(357),
    [sym_for_in_statement] = STATE(357),
    [sym_while_statement] = STATE(357),
    [sym_do_statement] = STATE(357),
    [sym_try_statement] = STATE(357),
    [sym_with_statement] = STATE(357),
    [sym_break_statement] = STATE(357),
    [sym_continue_statement] = STATE(357),
    [sym_debugger_statement] = STATE(357),
    [sym_return_statement] = STATE(357),
    [sym_throw_statement] = STATE(357),
    [sym_empty_statement] = STATE(357),
    [sym_labeled_statement] = STATE(357),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [34] = {
    [sym_export_statement] = STATE(1230),
    [sym_declaration] = STATE(1230),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(1230),
    [sym_expression_statement] = STATE(1230),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(1230),
    [sym_if_statement] = STATE(1230),
    [sym_switch_statement] = STATE(1230),
    [sym_for_statement] = STATE(1230),
    [sym_for_in_statement] = STATE(1230),
    [sym_while_statement] = STATE(1230),
    [sym_do_statement] = STATE(1230),
    [sym_try_statement] = STATE(1230),
    [sym_with_statement] = STATE(1230),
    [sym_break_statement] = STATE(1230),
    [sym_continue_statement] = STATE(1230),
    [sym_debugger_statement] = STATE(1230),
    [sym_return_statement] = STATE(1230),
    [sym_throw_statement] = STATE(1230),
    [sym_empty_statement] = STATE(1230),
    [sym_labeled_statement] = STATE(1230),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [35] = {
    [sym_export_statement] = STATE(425),
    [sym_declaration] = STATE(425),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(425),
    [sym_expression_statement] = STATE(425),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(425),
    [sym_if_statement] = STATE(425),
    [sym_switch_statement] = STATE(425),
    [sym_for_statement] = STATE(425),
    [sym_for_in_statement] = STATE(425),
    [sym_while_statement] = STATE(425),
    [sym_do_statement] = STATE(425),
    [sym_try_statement] = STATE(425),
    [sym_with_statement] = STATE(425),
    [sym_break_statement] = STATE(425),
    [sym_continue_statement] = STATE(425),
    [sym_debugger_statement] = STATE(425),
    [sym_return_statement] = STATE(425),
    [sym_throw_statement] = STATE(425),
    [sym_empty_statement] = STATE(425),
    [sym_labeled_statement] = STATE(425),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [36] = {
    [sym_export_statement] = STATE(368),
    [sym_declaration] = STATE(368),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(368),
    [sym_expression_statement] = STATE(368),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(368),
    [sym_if_statement] = STATE(368),
    [sym_switch_statement] = STATE(368),
    [sym_for_statement] = STATE(368),
    [sym_for_in_statement] = STATE(368),
    [sym_while_statement] = STATE(368),
    [sym_do_statement] = STATE(368),
    [sym_try_statement] = STATE(368),
    [sym_with_statement] = STATE(368),
    [sym_break_statement] = STATE(368),
    [sym_continue_statement] = STATE(368),
    [sym_debugger_statement] = STATE(368),
    [sym_return_statement] = STATE(368),
    [sym_throw_statement] = STATE(368),
    [sym_empty_statement] = STATE(368),
    [sym_labeled_statement] = STATE(368),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [37] = {
    [sym_export_statement] = STATE(365),
    [sym_declaration] = STATE(365),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(365),
    [sym_expression_statement] = STATE(365),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(365),
    [sym_if_statement] = STATE(365),
    [sym_switch_statement] = STATE(365),
    [sym_for_statement] = STATE(365),
    [sym_for_in_statement] = STATE(365),
    [sym_while_statement] = STATE(365),
    [sym_do_statement] = STATE(365),
    [sym_try_statement] = STATE(365),
    [sym_with_statement] = STATE(365),
    [sym_break_statement] = STATE(365),
    [sym_continue_statement] = STATE(365),
    [sym_debugger_statement] = STATE(365),
    [sym_return_statement] = STATE(365),
    [sym_throw_statement] = STATE(365),
    [sym_empty_statement] = STATE(365),
    [sym_labeled_statement] = STATE(365),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [38] = {
    [sym_export_statement] = STATE(398),
    [sym_declaration] = STATE(397),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(396),
    [sym_expression_statement] = STATE(395),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(394),
    [sym_if_statement] = STATE(393),
    [sym_switch_statement] = STATE(392),
    [sym_for_statement] = STATE(388),
    [sym_for_in_statement] = STATE(387),
    [sym_while_statement] = STATE(385),
    [sym_do_statement] = STATE(384),
    [sym_try_statement] = STATE(383),
    [sym_with_statement] = STATE(382),
    [sym_break_statement] = STATE(378),
    [sym_continue_statement] = STATE(377),
    [sym_debugger_statement] = STATE(370),
    [sym_return_statement] = STATE(369),
    [sym_throw_statement] = STATE(367),
    [sym_empty_statement] = STATE(332),
    [sym_labeled_statement] = STATE(364),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [39] = {
    [sym_export_statement] = STATE(390),
    [sym_declaration] = STATE(391),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(366),
    [sym_expression_statement] = STATE(333),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(334),
    [sym_if_statement] = STATE(335),
    [sym_switch_statement] = STATE(336),
    [sym_for_statement] = STATE(337),
    [sym_for_in_statement] = STATE(338),
    [sym_while_statement] = STATE(339),
    [sym_do_statement] = STATE(340),
    [sym_try_statement] = STATE(341),
    [sym_with_statement] = STATE(342),
    [sym_break_statement] = STATE(343),
    [sym_continue_statement] = STATE(344),
    [sym_debugger_statement] = STATE(345),
    [sym_return_statement] = STATE(346),
    [sym_throw_statement] = STATE(347),
    [sym_empty_statement] = STATE(348),
    [sym_labeled_statement] = STATE(349),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [40] = {
    [sym_export_statement] = STATE(1537),
    [sym_declaration] = STATE(1537),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(1537),
    [sym_expression_statement] = STATE(1537),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(1537),
    [sym_if_statement] = STATE(1537),
    [sym_switch_statement] = STATE(1537),
    [sym_for_statement] = STATE(1537),
    [sym_for_in_statement] = STATE(1537),
    [sym_while_statement] = STATE(1537),
    [sym_do_statement] = STATE(1537),
    [sym_try_statement] = STATE(1537),
    [sym_with_statement] = STATE(1537),
    [sym_break_statement] = STATE(1537),
    [sym_continue_statement] = STATE(1537),
    [sym_debugger_statement] = STATE(1537),
    [sym_return_statement] = STATE(1537),
    [sym_throw_statement] = STATE(1537),
    [sym_empty_statement] = STATE(1537),
    [sym_labeled_statement] = STATE(1537),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [41] = {
    [sym_export_statement] = STATE(357),
    [sym_declaration] = STATE(357),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(357),
    [sym_expression_statement] = STATE(357),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(357),
    [sym_if_statement] = STATE(357),
    [sym_switch_statement] = STATE(357),
    [sym_for_statement] = STATE(357),
    [sym_for_in_statement] = STATE(357),
    [sym_while_statement] = STATE(357),
    [sym_do_statement] = STATE(357),
    [sym_try_statement] = STATE(357),
    [sym_with_statement] = STATE(357),
    [sym_break_statement] = STATE(357),
    [sym_continue_statement] = STATE(357),
    [sym_debugger_statement] = STATE(357),
    [sym_return_statement] = STATE(357),
    [sym_throw_statement] = STATE(357),
    [sym_empty_statement] = STATE(357),
    [sym_labeled_statement] = STATE(357),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1118),
    [sym_identifier] = ACTIONS(308),
    [anon_sym_export] = ACTIONS(310),
    [anon_sym_LBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(314),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(316),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(318),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(320),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(324),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(328),
    [anon_sym_get] = ACTIONS(328),
    [anon_sym_set] = ACTIONS(328),
  },
  [42] = {
    [sym_export_statement] = STATE(409),
    [sym_declaration] = STATE(409),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(409),
    [sym_expression_statement] = STATE(409),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(409),
    [sym_if_statement] = STATE(409),
    [sym_switch_statement] = STATE(409),
    [sym_for_statement] = STATE(409),
    [sym_for_in_statement] = STATE(409),
    [sym_while_statement] = STATE(409),
    [sym_do_statement] = STATE(409),
    [sym_try_statement] = STATE(409),
    [sym_with_statement] = STATE(409),
    [sym_break_statement] = STATE(409),
    [sym_continue_statement] = STATE(409),
    [sym_debugger_statement] = STATE(409),
    [sym_return_statement] = STATE(409),
    [sym_throw_statement] = STATE(409),
    [sym_empty_statement] = STATE(409),
    [sym_labeled_statement] = STATE(409),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [43] = {
    [sym_export_statement] = STATE(372),
    [sym_declaration] = STATE(372),
    [sym_import] = STATE(683),
    [sym_import_statement] = STATE(372),
    [sym_expression_statement] = STATE(372),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_statement_block] = STATE(372),
    [sym_if_statement] = STATE(372),
    [sym_switch_statement] = STATE(372),
    [sym_for_statement] = STATE(372),
    [sym_for_in_statement] = STATE(372),
    [sym_while_statement] = STATE(372),
    [sym_do_statement] = STATE(372),
    [sym_try_statement] = STATE(372),
    [sym_with_statement] = STATE(372),
    [sym_break_statement] = STATE(372),
    [sym_continue_statement] = STATE(372),
    [sym_debugger_statement] = STATE(372),
    [sym_return_statement] = STATE(372),
    [sym_throw_statement] = STATE(372),
    [sym_empty_statement] = STATE(372),
    [sym_labeled_statement] = STATE(372),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1130),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_export] = ACTIONS(11),
    [anon_sym_LBRACE] = ACTIONS(13),
    [anon_sym_import] = ACTIONS(15),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_if] = ACTIONS(21),
    [anon_sym_switch] = ACTIONS(23),
    [anon_sym_for] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_while] = ACTIONS(31),
    [anon_sym_do] = ACTIONS(33),
    [anon_sym_try] = ACTIONS(35),
    [anon_sym_with] = ACTIONS(37),
    [anon_sym_break] = ACTIONS(39),
    [anon_sym_continue] = ACTIONS(41),
    [anon_sym_debugger] = ACTIONS(43),
    [anon_sym_return] = ACTIONS(45),
    [anon_sym_throw] = ACTIONS(47),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(89),
    [anon_sym_get] = ACTIONS(89),
    [anon_sym_set] = ACTIONS(89),
  },
  [44] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(531),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_STAR] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(338),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(338),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_in] = ACTIONS(346),
    [anon_sym_COLON] = ACTIONS(338),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_RBRACK] = ACTIONS(338),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_DOT] = ACTIONS(346),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [sym_optional_chain] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_AMP_AMP] = ACTIONS(338),
    [anon_sym_PIPE_PIPE] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(346),
    [anon_sym_GT_GT_GT] = ACTIONS(338),
    [anon_sym_LT_LT] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(346),
    [anon_sym_CARET] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_PERCENT] = ACTIONS(338),
    [anon_sym_STAR_STAR] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(338),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_QMARK_QMARK] = ACTIONS(338),
    [anon_sym_instanceof] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(364),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
    [sym__ternary_qmark] = ACTIONS(338),
  },
  [45] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(659),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_STAR] = ACTIONS(386),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_COMMA] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(338),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_in] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_DOT] = ACTIONS(346),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [sym_optional_chain] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_AMP_AMP] = ACTIONS(338),
    [anon_sym_PIPE_PIPE] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(346),
    [anon_sym_GT_GT_GT] = ACTIONS(338),
    [anon_sym_LT_LT] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(346),
    [anon_sym_CARET] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_PERCENT] = ACTIONS(338),
    [anon_sym_STAR_STAR] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(338),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_QMARK_QMARK] = ACTIONS(338),
    [anon_sym_instanceof] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
    [sym__automatic_semicolon] = ACTIONS(338),
    [sym__ternary_qmark] = ACTIONS(338),
  },
  [46] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(655),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_STAR] = ACTIONS(402),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_COMMA] = ACTIONS(338),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_in] = ACTIONS(346),
    [anon_sym_of] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_DOT] = ACTIONS(346),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [sym_optional_chain] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_AMP_AMP] = ACTIONS(338),
    [anon_sym_PIPE_PIPE] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(346),
    [anon_sym_GT_GT_GT] = ACTIONS(338),
    [anon_sym_LT_LT] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(346),
    [anon_sym_CARET] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_PERCENT] = ACTIONS(338),
    [anon_sym_STAR_STAR] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(338),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_QMARK_QMARK] = ACTIONS(338),
    [anon_sym_instanceof] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(414),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
    [sym__automatic_semicolon] = ACTIONS(338),
    [sym__ternary_qmark] = ACTIONS(338),
  },
  [47] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(832),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_STAR] = ACTIONS(426),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_in] = ACTIONS(346),
    [anon_sym_of] = ACTIONS(346),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_DOT] = ACTIONS(346),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [sym_optional_chain] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_AMP_AMP] = ACTIONS(338),
    [anon_sym_PIPE_PIPE] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(346),
    [anon_sym_GT_GT_GT] = ACTIONS(338),
    [anon_sym_LT_LT] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(346),
    [anon_sym_CARET] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_PERCENT] = ACTIONS(338),
    [anon_sym_STAR_STAR] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(338),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_QMARK_QMARK] = ACTIONS(338),
    [anon_sym_instanceof] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
    [sym__ternary_qmark] = ACTIONS(338),
  },
  [48] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(809),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_STAR] = ACTIONS(454),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_in] = ACTIONS(346),
    [anon_sym_COLON] = ACTIONS(338),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(346),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_DOT] = ACTIONS(346),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [sym_optional_chain] = ACTIONS(338),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_AMP_AMP] = ACTIONS(338),
    [anon_sym_PIPE_PIPE] = ACTIONS(338),
    [anon_sym_GT_GT] = ACTIONS(346),
    [anon_sym_GT_GT_GT] = ACTIONS(338),
    [anon_sym_LT_LT] = ACTIONS(338),
    [anon_sym_AMP] = ACTIONS(346),
    [anon_sym_CARET] = ACTIONS(338),
    [anon_sym_PIPE] = ACTIONS(346),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_PERCENT] = ACTIONS(338),
    [anon_sym_STAR_STAR] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(338),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_QMARK_QMARK] = ACTIONS(338),
    [anon_sym_instanceof] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(464),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
    [sym__ternary_qmark] = ACTIONS(338),
  },
  [49] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(732),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1312),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(478),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [50] = {
    [sym_declaration] = STATE(353),
    [sym_import] = STATE(683),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(777),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1212),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(484),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [51] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(732),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1312),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(486),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [52] = {
    [sym_import] = STATE(683),
    [sym_expression_statement] = STATE(93),
    [sym_variable_declaration] = STATE(93),
    [sym_lexical_declaration] = STATE(93),
    [sym_empty_statement] = STATE(93),
    [sym_parenthesized_expression] = STATE(478),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1318),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1318),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(478),
    [sym_subscript_expression] = STATE(478),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1318),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(488),
    [anon_sym_export] = ACTIONS(490),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(494),
    [anon_sym_let] = ACTIONS(496),
    [anon_sym_const] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(498),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(500),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(502),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(490),
    [anon_sym_get] = ACTIONS(490),
    [anon_sym_set] = ACTIONS(490),
  },
  [53] = {
    [sym_import] = STATE(683),
    [sym_expression_statement] = STATE(96),
    [sym_variable_declaration] = STATE(96),
    [sym_lexical_declaration] = STATE(96),
    [sym_empty_statement] = STATE(96),
    [sym_parenthesized_expression] = STATE(478),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1318),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1318),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(478),
    [sym_subscript_expression] = STATE(478),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1318),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(488),
    [anon_sym_export] = ACTIONS(490),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(494),
    [anon_sym_let] = ACTIONS(496),
    [anon_sym_const] = ACTIONS(496),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(498),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(500),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(502),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(490),
    [anon_sym_get] = ACTIONS(490),
    [anon_sym_set] = ACTIONS(490),
  },
  [54] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(732),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1312),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(504),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [55] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(732),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1312),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(506),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [56] = {
    [sym_declaration] = STATE(424),
    [sym_import] = STATE(683),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(766),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1212),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(322),
    [anon_sym_async] = ACTIONS(484),
    [anon_sym_function] = ACTIONS(326),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [57] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(733),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1274),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1267),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(508),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [58] = {
    [ts_builtin_sym_end] = ACTIONS(510),
    [sym_identifier] = ACTIONS(512),
    [anon_sym_export] = ACTIONS(512),
    [anon_sym_STAR] = ACTIONS(514),
    [anon_sym_default] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(510),
    [anon_sym_COMMA] = ACTIONS(516),
    [anon_sym_RBRACE] = ACTIONS(510),
    [anon_sym_import] = ACTIONS(512),
    [anon_sym_var] = ACTIONS(512),
    [anon_sym_let] = ACTIONS(512),
    [anon_sym_const] = ACTIONS(512),
    [anon_sym_else] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(512),
    [anon_sym_switch] = ACTIONS(512),
    [anon_sym_for] = ACTIONS(512),
    [anon_sym_LPAREN] = ACTIONS(510),
    [anon_sym_await] = ACTIONS(512),
    [anon_sym_in] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(512),
    [anon_sym_do] = ACTIONS(512),
    [anon_sym_try] = ACTIONS(512),
    [anon_sym_with] = ACTIONS(512),
    [anon_sym_break] = ACTIONS(512),
    [anon_sym_continue] = ACTIONS(512),
    [anon_sym_debugger] = ACTIONS(512),
    [anon_sym_return] = ACTIONS(512),
    [anon_sym_throw] = ACTIONS(512),
    [anon_sym_SEMI] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(512),
    [anon_sym_yield] = ACTIONS(512),
    [anon_sym_EQ] = ACTIONS(518),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_LTtemplate_GT] = ACTIONS(510),
    [anon_sym_LT] = ACTIONS(512),
    [anon_sym_GT] = ACTIONS(514),
    [anon_sym_SLASH] = ACTIONS(512),
    [anon_sym_DOT] = ACTIONS(514),
    [anon_sym_class] = ACTIONS(512),
    [anon_sym_async] = ACTIONS(512),
    [anon_sym_function] = ACTIONS(512),
    [sym_optional_chain] = ACTIONS(516),
    [anon_sym_new] = ACTIONS(512),
    [anon_sym_AMP_AMP] = ACTIONS(516),
    [anon_sym_PIPE_PIPE] = ACTIONS(516),
    [anon_sym_GT_GT] = ACTIONS(514),
    [anon_sym_GT_GT_GT] = ACTIONS(516),
    [anon_sym_LT_LT] = ACTIONS(516),
    [anon_sym_AMP] = ACTIONS(514),
    [anon_sym_CARET] = ACTIONS(516),
    [anon_sym_PIPE] = ACTIONS(514),
    [anon_sym_PLUS] = ACTIONS(512),
    [anon_sym_DASH] = ACTIONS(512),
    [anon_sym_PERCENT] = ACTIONS(516),
    [anon_sym_STAR_STAR] = ACTIONS(516),
    [anon_sym_LT_EQ] = ACTIONS(516),
    [anon_sym_EQ_EQ] = ACTIONS(514),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(516),
    [anon_sym_BANG_EQ] = ACTIONS(514),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(516),
    [anon_sym_GT_EQ] = ACTIONS(516),
    [anon_sym_QMARK_QMARK] = ACTIONS(516),
    [anon_sym_instanceof] = ACTIONS(514),
    [anon_sym_BANG] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(510),
    [anon_sym_typeof] = ACTIONS(512),
    [anon_sym_void] = ACTIONS(512),
    [anon_sym_delete] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(510),
    [anon_sym_DASH_DASH] = ACTIONS(510),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_SQUOTE] = ACTIONS(510),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(510),
    [sym_number] = ACTIONS(510),
    [sym_this] = ACTIONS(512),
    [sym_super] = ACTIONS(512),
    [sym_true] = ACTIONS(512),
    [sym_false] = ACTIONS(512),
    [sym_null] = ACTIONS(512),
    [sym_undefined] = ACTIONS(512),
    [anon_sym_AT] = ACTIONS(510),
    [anon_sym_static] = ACTIONS(512),
    [anon_sym_get] = ACTIONS(512),
    [anon_sym_set] = ACTIONS(512),
    [sym__automatic_semicolon] = ACTIONS(520),
    [sym__ternary_qmark] = ACTIONS(516),
  },
  [59] = {
    [sym_declaration] = STATE(424),
    [sym_import] = STATE(683),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(766),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1199),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(522),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [60] = {
    [sym_declaration] = STATE(353),
    [sym_import] = STATE(683),
    [sym_variable_declaration] = STATE(356),
    [sym_lexical_declaration] = STATE(356),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(777),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_class_declaration] = STATE(356),
    [sym_function] = STATE(683),
    [sym_function_declaration] = STATE(356),
    [sym_generator_function] = STATE(683),
    [sym_generator_function_declaration] = STATE(356),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1199),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(17),
    [anon_sym_let] = ACTIONS(19),
    [anon_sym_const] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(61),
    [anon_sym_async] = ACTIONS(522),
    [anon_sym_function] = ACTIONS(65),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [61] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(734),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1274),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1267),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(508),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [62] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(734),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1274),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1267),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(524),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [63] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(732),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1312),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(526),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [64] = {
    [ts_builtin_sym_end] = ACTIONS(510),
    [sym_identifier] = ACTIONS(512),
    [anon_sym_export] = ACTIONS(512),
    [anon_sym_STAR] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(510),
    [anon_sym_COMMA] = ACTIONS(510),
    [anon_sym_RBRACE] = ACTIONS(510),
    [anon_sym_import] = ACTIONS(512),
    [anon_sym_var] = ACTIONS(512),
    [anon_sym_let] = ACTIONS(512),
    [anon_sym_const] = ACTIONS(512),
    [anon_sym_else] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(512),
    [anon_sym_switch] = ACTIONS(512),
    [anon_sym_for] = ACTIONS(512),
    [anon_sym_LPAREN] = ACTIONS(510),
    [anon_sym_await] = ACTIONS(512),
    [anon_sym_in] = ACTIONS(512),
    [anon_sym_while] = ACTIONS(512),
    [anon_sym_do] = ACTIONS(512),
    [anon_sym_try] = ACTIONS(512),
    [anon_sym_with] = ACTIONS(512),
    [anon_sym_break] = ACTIONS(512),
    [anon_sym_continue] = ACTIONS(512),
    [anon_sym_debugger] = ACTIONS(512),
    [anon_sym_return] = ACTIONS(512),
    [anon_sym_throw] = ACTIONS(512),
    [anon_sym_SEMI] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(512),
    [anon_sym_yield] = ACTIONS(512),
    [anon_sym_LBRACK] = ACTIONS(510),
    [anon_sym_LTtemplate_GT] = ACTIONS(510),
    [anon_sym_LT] = ACTIONS(512),
    [anon_sym_GT] = ACTIONS(512),
    [anon_sym_SLASH] = ACTIONS(512),
    [anon_sym_DOT] = ACTIONS(512),
    [anon_sym_class] = ACTIONS(512),
    [anon_sym_async] = ACTIONS(512),
    [anon_sym_function] = ACTIONS(512),
    [sym_optional_chain] = ACTIONS(510),
    [anon_sym_new] = ACTIONS(512),
    [anon_sym_AMP_AMP] = ACTIONS(510),
    [anon_sym_PIPE_PIPE] = ACTIONS(510),
    [anon_sym_GT_GT] = ACTIONS(512),
    [anon_sym_GT_GT_GT] = ACTIONS(510),
    [anon_sym_LT_LT] = ACTIONS(510),
    [anon_sym_AMP] = ACTIONS(512),
    [anon_sym_CARET] = ACTIONS(510),
    [anon_sym_PIPE] = ACTIONS(512),
    [anon_sym_PLUS] = ACTIONS(512),
    [anon_sym_DASH] = ACTIONS(512),
    [anon_sym_PERCENT] = ACTIONS(510),
    [anon_sym_STAR_STAR] = ACTIONS(510),
    [anon_sym_LT_EQ] = ACTIONS(510),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(510),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(510),
    [anon_sym_GT_EQ] = ACTIONS(510),
    [anon_sym_QMARK_QMARK] = ACTIONS(510),
    [anon_sym_instanceof] = ACTIONS(512),
    [anon_sym_BANG] = ACTIONS(512),
    [anon_sym_TILDE] = ACTIONS(510),
    [anon_sym_typeof] = ACTIONS(512),
    [anon_sym_void] = ACTIONS(512),
    [anon_sym_delete] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(510),
    [anon_sym_DASH_DASH] = ACTIONS(510),
    [anon_sym_DQUOTE] = ACTIONS(510),
    [anon_sym_SQUOTE] = ACTIONS(510),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(510),
    [sym_number] = ACTIONS(510),
    [sym_this] = ACTIONS(512),
    [sym_super] = ACTIONS(512),
    [sym_true] = ACTIONS(512),
    [sym_false] = ACTIONS(512),
    [sym_null] = ACTIONS(512),
    [sym_undefined] = ACTIONS(512),
    [anon_sym_AT] = ACTIONS(510),
    [anon_sym_static] = ACTIONS(512),
    [anon_sym_get] = ACTIONS(512),
    [anon_sym_set] = ACTIONS(512),
    [sym__automatic_semicolon] = ACTIONS(528),
    [sym__ternary_qmark] = ACTIONS(510),
  },
  [65] = {
    [ts_builtin_sym_end] = ACTIONS(530),
    [sym_identifier] = ACTIONS(532),
    [anon_sym_export] = ACTIONS(532),
    [anon_sym_STAR] = ACTIONS(532),
    [anon_sym_default] = ACTIONS(532),
    [anon_sym_LBRACE] = ACTIONS(530),
    [anon_sym_COMMA] = ACTIONS(530),
    [anon_sym_RBRACE] = ACTIONS(530),
    [anon_sym_import] = ACTIONS(532),
    [anon_sym_var] = ACTIONS(532),
    [anon_sym_let] = ACTIONS(532),
    [anon_sym_const] = ACTIONS(532),
    [anon_sym_else] = ACTIONS(532),
    [anon_sym_if] = ACTIONS(532),
    [anon_sym_switch] = ACTIONS(532),
    [anon_sym_for] = ACTIONS(532),
    [anon_sym_LPAREN] = ACTIONS(530),
    [anon_sym_await] = ACTIONS(532),
    [anon_sym_in] = ACTIONS(532),
    [anon_sym_while] = ACTIONS(532),
    [anon_sym_do] = ACTIONS(532),
    [anon_sym_try] = ACTIONS(532),
    [anon_sym_with] = ACTIONS(532),
    [anon_sym_break] = ACTIONS(532),
    [anon_sym_continue] = ACTIONS(532),
    [anon_sym_debugger] = ACTIONS(532),
    [anon_sym_return] = ACTIONS(532),
    [anon_sym_throw] = ACTIONS(532),
    [anon_sym_SEMI] = ACTIONS(530),
    [anon_sym_case] = ACTIONS(532),
    [anon_sym_yield] = ACTIONS(532),
    [anon_sym_LBRACK] = ACTIONS(530),
    [anon_sym_LTtemplate_GT] = ACTIONS(530),
    [anon_sym_LT] = ACTIONS(532),
    [anon_sym_GT] = ACTIONS(532),
    [anon_sym_SLASH] = ACTIONS(532),
    [anon_sym_DOT] = ACTIONS(532),
    [anon_sym_class] = ACTIONS(532),
    [anon_sym_async] = ACTIONS(532),
    [anon_sym_function] = ACTIONS(532),
    [sym_optional_chain] = ACTIONS(530),
    [anon_sym_new] = ACTIONS(532),
    [anon_sym_AMP_AMP] = ACTIONS(530),
    [anon_sym_PIPE_PIPE] = ACTIONS(530),
    [anon_sym_GT_GT] = ACTIONS(532),
    [anon_sym_GT_GT_GT] = ACTIONS(530),
    [anon_sym_LT_LT] = ACTIONS(530),
    [anon_sym_AMP] = ACTIONS(532),
    [anon_sym_CARET] = ACTIONS(530),
    [anon_sym_PIPE] = ACTIONS(532),
    [anon_sym_PLUS] = ACTIONS(532),
    [anon_sym_DASH] = ACTIONS(532),
    [anon_sym_PERCENT] = ACTIONS(530),
    [anon_sym_STAR_STAR] = ACTIONS(530),
    [anon_sym_LT_EQ] = ACTIONS(530),
    [anon_sym_EQ_EQ] = ACTIONS(532),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(530),
    [anon_sym_BANG_EQ] = ACTIONS(532),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(530),
    [anon_sym_GT_EQ] = ACTIONS(530),
    [anon_sym_QMARK_QMARK] = ACTIONS(530),
    [anon_sym_instanceof] = ACTIONS(532),
    [anon_sym_BANG] = ACTIONS(532),
    [anon_sym_TILDE] = ACTIONS(530),
    [anon_sym_typeof] = ACTIONS(532),
    [anon_sym_void] = ACTIONS(532),
    [anon_sym_delete] = ACTIONS(532),
    [anon_sym_PLUS_PLUS] = ACTIONS(530),
    [anon_sym_DASH_DASH] = ACTIONS(530),
    [anon_sym_DQUOTE] = ACTIONS(530),
    [anon_sym_SQUOTE] = ACTIONS(530),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(530),
    [sym_number] = ACTIONS(530),
    [sym_this] = ACTIONS(532),
    [sym_super] = ACTIONS(532),
    [sym_true] = ACTIONS(532),
    [sym_false] = ACTIONS(532),
    [sym_null] = ACTIONS(532),
    [sym_undefined] = ACTIONS(532),
    [anon_sym_AT] = ACTIONS(530),
    [anon_sym_static] = ACTIONS(532),
    [anon_sym_get] = ACTIONS(532),
    [anon_sym_set] = ACTIONS(532),
    [sym__automatic_semicolon] = ACTIONS(530),
    [sym__ternary_qmark] = ACTIONS(530),
  },
  [66] = {
    [ts_builtin_sym_end] = ACTIONS(534),
    [sym_identifier] = ACTIONS(536),
    [anon_sym_export] = ACTIONS(536),
    [anon_sym_STAR] = ACTIONS(538),
    [anon_sym_default] = ACTIONS(536),
    [anon_sym_LBRACE] = ACTIONS(534),
    [anon_sym_COMMA] = ACTIONS(540),
    [anon_sym_RBRACE] = ACTIONS(534),
    [anon_sym_import] = ACTIONS(536),
    [anon_sym_var] = ACTIONS(536),
    [anon_sym_let] = ACTIONS(536),
    [anon_sym_const] = ACTIONS(536),
    [anon_sym_else] = ACTIONS(536),
    [anon_sym_if] = ACTIONS(536),
    [anon_sym_switch] = ACTIONS(536),
    [anon_sym_for] = ACTIONS(536),
    [anon_sym_LPAREN] = ACTIONS(534),
    [anon_sym_await] = ACTIONS(536),
    [anon_sym_in] = ACTIONS(538),
    [anon_sym_while] = ACTIONS(536),
    [anon_sym_do] = ACTIONS(536),
    [anon_sym_try] = ACTIONS(536),
    [anon_sym_with] = ACTIONS(536),
    [anon_sym_break] = ACTIONS(536),
    [anon_sym_continue] = ACTIONS(536),
    [anon_sym_debugger] = ACTIONS(536),
    [anon_sym_return] = ACTIONS(536),
    [anon_sym_throw] = ACTIONS(536),
    [anon_sym_SEMI] = ACTIONS(534),
    [anon_sym_case] = ACTIONS(536),
    [anon_sym_yield] = ACTIONS(536),
    [anon_sym_LBRACK] = ACTIONS(534),
    [anon_sym_LTtemplate_GT] = ACTIONS(534),
    [anon_sym_LT] = ACTIONS(536),
    [anon_sym_GT] = ACTIONS(538),
    [anon_sym_SLASH] = ACTIONS(536),
    [anon_sym_DOT] = ACTIONS(538),
    [anon_sym_class] = ACTIONS(536),
    [anon_sym_async] = ACTIONS(536),
    [anon_sym_function] = ACTIONS(536),
    [sym_optional_chain] = ACTIONS(540),
    [anon_sym_new] = ACTIONS(536),
    [anon_sym_AMP_AMP] = ACTIONS(540),
    [anon_sym_PIPE_PIPE] = ACTIONS(540),
    [anon_sym_GT_GT] = ACTIONS(538),
    [anon_sym_GT_GT_GT] = ACTIONS(540),
    [anon_sym_LT_LT] = ACTIONS(540),
    [anon_sym_AMP] = ACTIONS(538),
    [anon_sym_CARET] = ACTIONS(540),
    [anon_sym_PIPE] = ACTIONS(538),
    [anon_sym_PLUS] = ACTIONS(536),
    [anon_sym_DASH] = ACTIONS(536),
    [anon_sym_PERCENT] = ACTIONS(540),
    [anon_sym_STAR_STAR] = ACTIONS(540),
    [anon_sym_LT_EQ] = ACTIONS(540),
    [anon_sym_EQ_EQ] = ACTIONS(538),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(540),
    [anon_sym_BANG_EQ] = ACTIONS(538),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(540),
    [anon_sym_GT_EQ] = ACTIONS(540),
    [anon_sym_QMARK_QMARK] = ACTIONS(540),
    [anon_sym_instanceof] = ACTIONS(538),
    [anon_sym_BANG] = ACTIONS(536),
    [anon_sym_TILDE] = ACTIONS(534),
    [anon_sym_typeof] = ACTIONS(536),
    [anon_sym_void] = ACTIONS(536),
    [anon_sym_delete] = ACTIONS(536),
    [anon_sym_PLUS_PLUS] = ACTIONS(534),
    [anon_sym_DASH_DASH] = ACTIONS(534),
    [anon_sym_DQUOTE] = ACTIONS(534),
    [anon_sym_SQUOTE] = ACTIONS(534),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(534),
    [sym_number] = ACTIONS(534),
    [sym_this] = ACTIONS(536),
    [sym_super] = ACTIONS(536),
    [sym_true] = ACTIONS(536),
    [sym_false] = ACTIONS(536),
    [sym_null] = ACTIONS(536),
    [sym_undefined] = ACTIONS(536),
    [anon_sym_AT] = ACTIONS(534),
    [anon_sym_static] = ACTIONS(536),
    [anon_sym_get] = ACTIONS(536),
    [anon_sym_set] = ACTIONS(536),
    [sym__automatic_semicolon] = ACTIONS(542),
    [sym__ternary_qmark] = ACTIONS(540),
  },
  [67] = {
    [ts_builtin_sym_end] = ACTIONS(544),
    [sym_identifier] = ACTIONS(546),
    [anon_sym_export] = ACTIONS(546),
    [anon_sym_STAR] = ACTIONS(548),
    [anon_sym_default] = ACTIONS(546),
    [anon_sym_LBRACE] = ACTIONS(544),
    [anon_sym_COMMA] = ACTIONS(550),
    [anon_sym_RBRACE] = ACTIONS(544),
    [anon_sym_import] = ACTIONS(546),
    [anon_sym_var] = ACTIONS(546),
    [anon_sym_let] = ACTIONS(546),
    [anon_sym_const] = ACTIONS(546),
    [anon_sym_else] = ACTIONS(546),
    [anon_sym_if] = ACTIONS(546),
    [anon_sym_switch] = ACTIONS(546),
    [anon_sym_for] = ACTIONS(546),
    [anon_sym_LPAREN] = ACTIONS(544),
    [anon_sym_await] = ACTIONS(546),
    [anon_sym_in] = ACTIONS(548),
    [anon_sym_while] = ACTIONS(546),
    [anon_sym_do] = ACTIONS(546),
    [anon_sym_try] = ACTIONS(546),
    [anon_sym_with] = ACTIONS(546),
    [anon_sym_break] = ACTIONS(546),
    [anon_sym_continue] = ACTIONS(546),
    [anon_sym_debugger] = ACTIONS(546),
    [anon_sym_return] = ACTIONS(546),
    [anon_sym_throw] = ACTIONS(546),
    [anon_sym_SEMI] = ACTIONS(544),
    [anon_sym_case] = ACTIONS(546),
    [anon_sym_yield] = ACTIONS(546),
    [anon_sym_LBRACK] = ACTIONS(544),
    [anon_sym_LTtemplate_GT] = ACTIONS(544),
    [anon_sym_LT] = ACTIONS(546),
    [anon_sym_GT] = ACTIONS(548),
    [anon_sym_SLASH] = ACTIONS(546),
    [anon_sym_DOT] = ACTIONS(548),
    [anon_sym_class] = ACTIONS(546),
    [anon_sym_async] = ACTIONS(546),
    [anon_sym_function] = ACTIONS(546),
    [sym_optional_chain] = ACTIONS(550),
    [anon_sym_new] = ACTIONS(546),
    [anon_sym_AMP_AMP] = ACTIONS(550),
    [anon_sym_PIPE_PIPE] = ACTIONS(550),
    [anon_sym_GT_GT] = ACTIONS(548),
    [anon_sym_GT_GT_GT] = ACTIONS(550),
    [anon_sym_LT_LT] = ACTIONS(550),
    [anon_sym_AMP] = ACTIONS(548),
    [anon_sym_CARET] = ACTIONS(550),
    [anon_sym_PIPE] = ACTIONS(548),
    [anon_sym_PLUS] = ACTIONS(546),
    [anon_sym_DASH] = ACTIONS(546),
    [anon_sym_PERCENT] = ACTIONS(550),
    [anon_sym_STAR_STAR] = ACTIONS(550),
    [anon_sym_LT_EQ] = ACTIONS(550),
    [anon_sym_EQ_EQ] = ACTIONS(548),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(550),
    [anon_sym_BANG_EQ] = ACTIONS(548),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(550),
    [anon_sym_GT_EQ] = ACTIONS(550),
    [anon_sym_QMARK_QMARK] = ACTIONS(550),
    [anon_sym_instanceof] = ACTIONS(548),
    [anon_sym_BANG] = ACTIONS(546),
    [anon_sym_TILDE] = ACTIONS(544),
    [anon_sym_typeof] = ACTIONS(546),
    [anon_sym_void] = ACTIONS(546),
    [anon_sym_delete] = ACTIONS(546),
    [anon_sym_PLUS_PLUS] = ACTIONS(544),
    [anon_sym_DASH_DASH] = ACTIONS(544),
    [anon_sym_DQUOTE] = ACTIONS(544),
    [anon_sym_SQUOTE] = ACTIONS(544),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(544),
    [sym_number] = ACTIONS(544),
    [sym_this] = ACTIONS(546),
    [sym_super] = ACTIONS(546),
    [sym_true] = ACTIONS(546),
    [sym_false] = ACTIONS(546),
    [sym_null] = ACTIONS(546),
    [sym_undefined] = ACTIONS(546),
    [anon_sym_AT] = ACTIONS(544),
    [anon_sym_static] = ACTIONS(546),
    [anon_sym_get] = ACTIONS(546),
    [anon_sym_set] = ACTIONS(546),
    [sym__automatic_semicolon] = ACTIONS(552),
    [sym__ternary_qmark] = ACTIONS(550),
  },
  [68] = {
    [ts_builtin_sym_end] = ACTIONS(554),
    [sym_identifier] = ACTIONS(556),
    [anon_sym_export] = ACTIONS(556),
    [anon_sym_STAR] = ACTIONS(558),
    [anon_sym_default] = ACTIONS(556),
    [anon_sym_LBRACE] = ACTIONS(554),
    [anon_sym_COMMA] = ACTIONS(560),
    [anon_sym_RBRACE] = ACTIONS(554),
    [anon_sym_import] = ACTIONS(556),
    [anon_sym_var] = ACTIONS(556),
    [anon_sym_let] = ACTIONS(556),
    [anon_sym_const] = ACTIONS(556),
    [anon_sym_else] = ACTIONS(556),
    [anon_sym_if] = ACTIONS(556),
    [anon_sym_switch] = ACTIONS(556),
    [anon_sym_for] = ACTIONS(556),
    [anon_sym_LPAREN] = ACTIONS(554),
    [anon_sym_await] = ACTIONS(556),
    [anon_sym_in] = ACTIONS(558),
    [anon_sym_while] = ACTIONS(556),
    [anon_sym_do] = ACTIONS(556),
    [anon_sym_try] = ACTIONS(556),
    [anon_sym_with] = ACTIONS(556),
    [anon_sym_break] = ACTIONS(556),
    [anon_sym_continue] = ACTIONS(556),
    [anon_sym_debugger] = ACTIONS(556),
    [anon_sym_return] = ACTIONS(556),
    [anon_sym_throw] = ACTIONS(556),
    [anon_sym_SEMI] = ACTIONS(554),
    [anon_sym_case] = ACTIONS(556),
    [anon_sym_yield] = ACTIONS(556),
    [anon_sym_LBRACK] = ACTIONS(554),
    [anon_sym_LTtemplate_GT] = ACTIONS(554),
    [anon_sym_LT] = ACTIONS(556),
    [anon_sym_GT] = ACTIONS(558),
    [anon_sym_SLASH] = ACTIONS(556),
    [anon_sym_DOT] = ACTIONS(558),
    [anon_sym_class] = ACTIONS(556),
    [anon_sym_async] = ACTIONS(556),
    [anon_sym_function] = ACTIONS(556),
    [sym_optional_chain] = ACTIONS(560),
    [anon_sym_new] = ACTIONS(556),
    [anon_sym_AMP_AMP] = ACTIONS(560),
    [anon_sym_PIPE_PIPE] = ACTIONS(560),
    [anon_sym_GT_GT] = ACTIONS(558),
    [anon_sym_GT_GT_GT] = ACTIONS(560),
    [anon_sym_LT_LT] = ACTIONS(560),
    [anon_sym_AMP] = ACTIONS(558),
    [anon_sym_CARET] = ACTIONS(560),
    [anon_sym_PIPE] = ACTIONS(558),
    [anon_sym_PLUS] = ACTIONS(556),
    [anon_sym_DASH] = ACTIONS(556),
    [anon_sym_PERCENT] = ACTIONS(560),
    [anon_sym_STAR_STAR] = ACTIONS(560),
    [anon_sym_LT_EQ] = ACTIONS(560),
    [anon_sym_EQ_EQ] = ACTIONS(558),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(560),
    [anon_sym_BANG_EQ] = ACTIONS(558),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(560),
    [anon_sym_GT_EQ] = ACTIONS(560),
    [anon_sym_QMARK_QMARK] = ACTIONS(560),
    [anon_sym_instanceof] = ACTIONS(558),
    [anon_sym_BANG] = ACTIONS(556),
    [anon_sym_TILDE] = ACTIONS(554),
    [anon_sym_typeof] = ACTIONS(556),
    [anon_sym_void] = ACTIONS(556),
    [anon_sym_delete] = ACTIONS(556),
    [anon_sym_PLUS_PLUS] = ACTIONS(554),
    [anon_sym_DASH_DASH] = ACTIONS(554),
    [anon_sym_DQUOTE] = ACTIONS(554),
    [anon_sym_SQUOTE] = ACTIONS(554),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(554),
    [sym_number] = ACTIONS(554),
    [sym_this] = ACTIONS(556),
    [sym_super] = ACTIONS(556),
    [sym_true] = ACTIONS(556),
    [sym_false] = ACTIONS(556),
    [sym_null] = ACTIONS(556),
    [sym_undefined] = ACTIONS(556),
    [anon_sym_AT] = ACTIONS(554),
    [anon_sym_static] = ACTIONS(556),
    [anon_sym_get] = ACTIONS(556),
    [anon_sym_set] = ACTIONS(556),
    [sym__automatic_semicolon] = ACTIONS(562),
    [sym__ternary_qmark] = ACTIONS(560),
  },
  [69] = {
    [ts_builtin_sym_end] = ACTIONS(564),
    [sym_identifier] = ACTIONS(566),
    [anon_sym_export] = ACTIONS(566),
    [anon_sym_STAR] = ACTIONS(566),
    [anon_sym_default] = ACTIONS(566),
    [anon_sym_LBRACE] = ACTIONS(564),
    [anon_sym_COMMA] = ACTIONS(564),
    [anon_sym_RBRACE] = ACTIONS(564),
    [anon_sym_import] = ACTIONS(566),
    [anon_sym_var] = ACTIONS(566),
    [anon_sym_let] = ACTIONS(566),
    [anon_sym_const] = ACTIONS(566),
    [anon_sym_else] = ACTIONS(566),
    [anon_sym_if] = ACTIONS(566),
    [anon_sym_switch] = ACTIONS(566),
    [anon_sym_for] = ACTIONS(566),
    [anon_sym_LPAREN] = ACTIONS(564),
    [anon_sym_await] = ACTIONS(566),
    [anon_sym_in] = ACTIONS(566),
    [anon_sym_while] = ACTIONS(566),
    [anon_sym_do] = ACTIONS(566),
    [anon_sym_try] = ACTIONS(566),
    [anon_sym_with] = ACTIONS(566),
    [anon_sym_break] = ACTIONS(566),
    [anon_sym_continue] = ACTIONS(566),
    [anon_sym_debugger] = ACTIONS(566),
    [anon_sym_return] = ACTIONS(566),
    [anon_sym_throw] = ACTIONS(566),
    [anon_sym_SEMI] = ACTIONS(564),
    [anon_sym_case] = ACTIONS(566),
    [anon_sym_yield] = ACTIONS(566),
    [anon_sym_LBRACK] = ACTIONS(564),
    [anon_sym_LTtemplate_GT] = ACTIONS(564),
    [anon_sym_LT] = ACTIONS(566),
    [anon_sym_GT] = ACTIONS(566),
    [anon_sym_SLASH] = ACTIONS(566),
    [anon_sym_DOT] = ACTIONS(566),
    [anon_sym_class] = ACTIONS(566),
    [anon_sym_async] = ACTIONS(566),
    [anon_sym_function] = ACTIONS(566),
    [sym_optional_chain] = ACTIONS(564),
    [anon_sym_new] = ACTIONS(566),
    [anon_sym_AMP_AMP] = ACTIONS(564),
    [anon_sym_PIPE_PIPE] = ACTIONS(564),
    [anon_sym_GT_GT] = ACTIONS(566),
    [anon_sym_GT_GT_GT] = ACTIONS(564),
    [anon_sym_LT_LT] = ACTIONS(564),
    [anon_sym_AMP] = ACTIONS(566),
    [anon_sym_CARET] = ACTIONS(564),
    [anon_sym_PIPE] = ACTIONS(566),
    [anon_sym_PLUS] = ACTIONS(566),
    [anon_sym_DASH] = ACTIONS(566),
    [anon_sym_PERCENT] = ACTIONS(564),
    [anon_sym_STAR_STAR] = ACTIONS(564),
    [anon_sym_LT_EQ] = ACTIONS(564),
    [anon_sym_EQ_EQ] = ACTIONS(566),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(564),
    [anon_sym_BANG_EQ] = ACTIONS(566),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(564),
    [anon_sym_GT_EQ] = ACTIONS(564),
    [anon_sym_QMARK_QMARK] = ACTIONS(564),
    [anon_sym_instanceof] = ACTIONS(566),
    [anon_sym_BANG] = ACTIONS(566),
    [anon_sym_TILDE] = ACTIONS(564),
    [anon_sym_typeof] = ACTIONS(566),
    [anon_sym_void] = ACTIONS(566),
    [anon_sym_delete] = ACTIONS(566),
    [anon_sym_PLUS_PLUS] = ACTIONS(564),
    [anon_sym_DASH_DASH] = ACTIONS(564),
    [anon_sym_DQUOTE] = ACTIONS(564),
    [anon_sym_SQUOTE] = ACTIONS(564),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(564),
    [sym_number] = ACTIONS(564),
    [sym_this] = ACTIONS(566),
    [sym_super] = ACTIONS(566),
    [sym_true] = ACTIONS(566),
    [sym_false] = ACTIONS(566),
    [sym_null] = ACTIONS(566),
    [sym_undefined] = ACTIONS(566),
    [anon_sym_AT] = ACTIONS(564),
    [anon_sym_static] = ACTIONS(566),
    [anon_sym_get] = ACTIONS(566),
    [anon_sym_set] = ACTIONS(566),
    [sym__automatic_semicolon] = ACTIONS(564),
    [sym__ternary_qmark] = ACTIONS(564),
  },
  [70] = {
    [ts_builtin_sym_end] = ACTIONS(568),
    [sym_identifier] = ACTIONS(570),
    [anon_sym_export] = ACTIONS(570),
    [anon_sym_STAR] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(570),
    [anon_sym_LBRACE] = ACTIONS(568),
    [anon_sym_COMMA] = ACTIONS(574),
    [anon_sym_RBRACE] = ACTIONS(568),
    [anon_sym_import] = ACTIONS(570),
    [anon_sym_var] = ACTIONS(570),
    [anon_sym_let] = ACTIONS(570),
    [anon_sym_const] = ACTIONS(570),
    [anon_sym_else] = ACTIONS(570),
    [anon_sym_if] = ACTIONS(570),
    [anon_sym_switch] = ACTIONS(570),
    [anon_sym_for] = ACTIONS(570),
    [anon_sym_LPAREN] = ACTIONS(568),
    [anon_sym_await] = ACTIONS(570),
    [anon_sym_in] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(570),
    [anon_sym_do] = ACTIONS(570),
    [anon_sym_try] = ACTIONS(570),
    [anon_sym_with] = ACTIONS(570),
    [anon_sym_break] = ACTIONS(570),
    [anon_sym_continue] = ACTIONS(570),
    [anon_sym_debugger] = ACTIONS(570),
    [anon_sym_return] = ACTIONS(570),
    [anon_sym_throw] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(568),
    [anon_sym_case] = ACTIONS(570),
    [anon_sym_yield] = ACTIONS(570),
    [anon_sym_LBRACK] = ACTIONS(568),
    [anon_sym_LTtemplate_GT] = ACTIONS(568),
    [anon_sym_LT] = ACTIONS(570),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(570),
    [anon_sym_DOT] = ACTIONS(572),
    [anon_sym_class] = ACTIONS(570),
    [anon_sym_async] = ACTIONS(570),
    [anon_sym_function] = ACTIONS(570),
    [sym_optional_chain] = ACTIONS(574),
    [anon_sym_new] = ACTIONS(570),
    [anon_sym_AMP_AMP] = ACTIONS(574),
    [anon_sym_PIPE_PIPE] = ACTIONS(574),
    [anon_sym_GT_GT] = ACTIONS(572),
    [anon_sym_GT_GT_GT] = ACTIONS(574),
    [anon_sym_LT_LT] = ACTIONS(574),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(574),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(570),
    [anon_sym_DASH] = ACTIONS(570),
    [anon_sym_PERCENT] = ACTIONS(574),
    [anon_sym_STAR_STAR] = ACTIONS(574),
    [anon_sym_LT_EQ] = ACTIONS(574),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(574),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(574),
    [anon_sym_GT_EQ] = ACTIONS(574),
    [anon_sym_QMARK_QMARK] = ACTIONS(574),
    [anon_sym_instanceof] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(570),
    [anon_sym_TILDE] = ACTIONS(568),
    [anon_sym_typeof] = ACTIONS(570),
    [anon_sym_void] = ACTIONS(570),
    [anon_sym_delete] = ACTIONS(570),
    [anon_sym_PLUS_PLUS] = ACTIONS(568),
    [anon_sym_DASH_DASH] = ACTIONS(568),
    [anon_sym_DQUOTE] = ACTIONS(568),
    [anon_sym_SQUOTE] = ACTIONS(568),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(568),
    [sym_number] = ACTIONS(568),
    [sym_this] = ACTIONS(570),
    [sym_super] = ACTIONS(570),
    [sym_true] = ACTIONS(570),
    [sym_false] = ACTIONS(570),
    [sym_null] = ACTIONS(570),
    [sym_undefined] = ACTIONS(570),
    [anon_sym_AT] = ACTIONS(568),
    [anon_sym_static] = ACTIONS(570),
    [anon_sym_get] = ACTIONS(570),
    [anon_sym_set] = ACTIONS(570),
    [sym__automatic_semicolon] = ACTIONS(576),
    [sym__ternary_qmark] = ACTIONS(574),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(580),
    [anon_sym_STAR] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_COMMA] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_var] = ACTIONS(580),
    [anon_sym_let] = ACTIONS(580),
    [anon_sym_const] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_in] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_with] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_debugger] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(580),
    [anon_sym_LBRACK] = ACTIONS(578),
    [anon_sym_LTtemplate_GT] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(580),
    [anon_sym_GT] = ACTIONS(580),
    [anon_sym_SLASH] = ACTIONS(580),
    [anon_sym_DOT] = ACTIONS(580),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_async] = ACTIONS(580),
    [anon_sym_function] = ACTIONS(580),
    [sym_optional_chain] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_AMP_AMP] = ACTIONS(578),
    [anon_sym_PIPE_PIPE] = ACTIONS(578),
    [anon_sym_GT_GT] = ACTIONS(580),
    [anon_sym_GT_GT_GT] = ACTIONS(578),
    [anon_sym_LT_LT] = ACTIONS(578),
    [anon_sym_AMP] = ACTIONS(580),
    [anon_sym_CARET] = ACTIONS(578),
    [anon_sym_PIPE] = ACTIONS(580),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_PERCENT] = ACTIONS(578),
    [anon_sym_STAR_STAR] = ACTIONS(578),
    [anon_sym_LT_EQ] = ACTIONS(578),
    [anon_sym_EQ_EQ] = ACTIONS(580),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(578),
    [anon_sym_BANG_EQ] = ACTIONS(580),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(578),
    [anon_sym_GT_EQ] = ACTIONS(578),
    [anon_sym_QMARK_QMARK] = ACTIONS(578),
    [anon_sym_instanceof] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(580),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_typeof] = ACTIONS(580),
    [anon_sym_void] = ACTIONS(580),
    [anon_sym_delete] = ACTIONS(580),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [anon_sym_DQUOTE] = ACTIONS(578),
    [anon_sym_SQUOTE] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(578),
    [sym_number] = ACTIONS(578),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_null] = ACTIONS(580),
    [sym_undefined] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(578),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_get] = ACTIONS(580),
    [anon_sym_set] = ACTIONS(580),
    [sym__automatic_semicolon] = ACTIONS(582),
    [sym__ternary_qmark] = ACTIONS(578),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(580),
    [anon_sym_STAR] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_COMMA] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_var] = ACTIONS(580),
    [anon_sym_let] = ACTIONS(580),
    [anon_sym_const] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_in] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_with] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_debugger] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(580),
    [anon_sym_LBRACK] = ACTIONS(578),
    [anon_sym_LTtemplate_GT] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(580),
    [anon_sym_GT] = ACTIONS(580),
    [anon_sym_SLASH] = ACTIONS(580),
    [anon_sym_DOT] = ACTIONS(580),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_async] = ACTIONS(580),
    [anon_sym_function] = ACTIONS(580),
    [sym_optional_chain] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_AMP_AMP] = ACTIONS(578),
    [anon_sym_PIPE_PIPE] = ACTIONS(578),
    [anon_sym_GT_GT] = ACTIONS(580),
    [anon_sym_GT_GT_GT] = ACTIONS(578),
    [anon_sym_LT_LT] = ACTIONS(578),
    [anon_sym_AMP] = ACTIONS(580),
    [anon_sym_CARET] = ACTIONS(578),
    [anon_sym_PIPE] = ACTIONS(580),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_PERCENT] = ACTIONS(578),
    [anon_sym_STAR_STAR] = ACTIONS(578),
    [anon_sym_LT_EQ] = ACTIONS(578),
    [anon_sym_EQ_EQ] = ACTIONS(580),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(578),
    [anon_sym_BANG_EQ] = ACTIONS(580),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(578),
    [anon_sym_GT_EQ] = ACTIONS(578),
    [anon_sym_QMARK_QMARK] = ACTIONS(578),
    [anon_sym_instanceof] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(580),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_typeof] = ACTIONS(580),
    [anon_sym_void] = ACTIONS(580),
    [anon_sym_delete] = ACTIONS(580),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [anon_sym_DQUOTE] = ACTIONS(578),
    [anon_sym_SQUOTE] = ACTIONS(578),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(578),
    [sym_number] = ACTIONS(578),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_null] = ACTIONS(580),
    [sym_undefined] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(578),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_get] = ACTIONS(580),
    [anon_sym_set] = ACTIONS(580),
    [sym__automatic_semicolon] = ACTIONS(578),
    [sym__ternary_qmark] = ACTIONS(578),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(584),
    [sym_identifier] = ACTIONS(586),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_STAR] = ACTIONS(586),
    [anon_sym_default] = ACTIONS(586),
    [anon_sym_LBRACE] = ACTIONS(584),
    [anon_sym_COMMA] = ACTIONS(584),
    [anon_sym_RBRACE] = ACTIONS(584),
    [anon_sym_import] = ACTIONS(586),
    [anon_sym_var] = ACTIONS(586),
    [anon_sym_let] = ACTIONS(586),
    [anon_sym_const] = ACTIONS(586),
    [anon_sym_else] = ACTIONS(586),
    [anon_sym_if] = ACTIONS(586),
    [anon_sym_switch] = ACTIONS(586),
    [anon_sym_for] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(584),
    [anon_sym_await] = ACTIONS(586),
    [anon_sym_in] = ACTIONS(586),
    [anon_sym_while] = ACTIONS(586),
    [anon_sym_do] = ACTIONS(586),
    [anon_sym_try] = ACTIONS(586),
    [anon_sym_with] = ACTIONS(586),
    [anon_sym_break] = ACTIONS(586),
    [anon_sym_continue] = ACTIONS(586),
    [anon_sym_debugger] = ACTIONS(586),
    [anon_sym_return] = ACTIONS(586),
    [anon_sym_throw] = ACTIONS(586),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_case] = ACTIONS(586),
    [anon_sym_yield] = ACTIONS(586),
    [anon_sym_LBRACK] = ACTIONS(584),
    [anon_sym_LTtemplate_GT] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(586),
    [anon_sym_GT] = ACTIONS(586),
    [anon_sym_SLASH] = ACTIONS(586),
    [anon_sym_DOT] = ACTIONS(586),
    [anon_sym_class] = ACTIONS(586),
    [anon_sym_async] = ACTIONS(586),
    [anon_sym_function] = ACTIONS(586),
    [sym_optional_chain] = ACTIONS(584),
    [anon_sym_new] = ACTIONS(586),
    [anon_sym_AMP_AMP] = ACTIONS(584),
    [anon_sym_PIPE_PIPE] = ACTIONS(584),
    [anon_sym_GT_GT] = ACTIONS(586),
    [anon_sym_GT_GT_GT] = ACTIONS(584),
    [anon_sym_LT_LT] = ACTIONS(584),
    [anon_sym_AMP] = ACTIONS(586),
    [anon_sym_CARET] = ACTIONS(584),
    [anon_sym_PIPE] = ACTIONS(586),
    [anon_sym_PLUS] = ACTIONS(586),
    [anon_sym_DASH] = ACTIONS(586),
    [anon_sym_PERCENT] = ACTIONS(584),
    [anon_sym_STAR_STAR] = ACTIONS(584),
    [anon_sym_LT_EQ] = ACTIONS(584),
    [anon_sym_EQ_EQ] = ACTIONS(586),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(584),
    [anon_sym_BANG_EQ] = ACTIONS(586),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(584),
    [anon_sym_GT_EQ] = ACTIONS(584),
    [anon_sym_QMARK_QMARK] = ACTIONS(584),
    [anon_sym_instanceof] = ACTIONS(586),
    [anon_sym_BANG] = ACTIONS(586),
    [anon_sym_TILDE] = ACTIONS(584),
    [anon_sym_typeof] = ACTIONS(586),
    [anon_sym_void] = ACTIONS(586),
    [anon_sym_delete] = ACTIONS(586),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [anon_sym_DQUOTE] = ACTIONS(584),
    [anon_sym_SQUOTE] = ACTIONS(584),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(584),
    [sym_this] = ACTIONS(586),
    [sym_super] = ACTIONS(586),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_null] = ACTIONS(586),
    [sym_undefined] = ACTIONS(586),
    [anon_sym_AT] = ACTIONS(584),
    [anon_sym_static] = ACTIONS(586),
    [anon_sym_get] = ACTIONS(586),
    [anon_sym_set] = ACTIONS(586),
    [sym__automatic_semicolon] = ACTIONS(584),
    [sym__ternary_qmark] = ACTIONS(584),
  },
  [74] = {
    [ts_builtin_sym_end] = ACTIONS(588),
    [sym_identifier] = ACTIONS(590),
    [anon_sym_export] = ACTIONS(590),
    [anon_sym_STAR] = ACTIONS(592),
    [anon_sym_default] = ACTIONS(590),
    [anon_sym_LBRACE] = ACTIONS(588),
    [anon_sym_COMMA] = ACTIONS(594),
    [anon_sym_RBRACE] = ACTIONS(588),
    [anon_sym_import] = ACTIONS(590),
    [anon_sym_var] = ACTIONS(590),
    [anon_sym_let] = ACTIONS(590),
    [anon_sym_const] = ACTIONS(590),
    [anon_sym_else] = ACTIONS(590),
    [anon_sym_if] = ACTIONS(590),
    [anon_sym_switch] = ACTIONS(590),
    [anon_sym_for] = ACTIONS(590),
    [anon_sym_LPAREN] = ACTIONS(588),
    [anon_sym_await] = ACTIONS(590),
    [anon_sym_in] = ACTIONS(592),
    [anon_sym_while] = ACTIONS(590),
    [anon_sym_do] = ACTIONS(590),
    [anon_sym_try] = ACTIONS(590),
    [anon_sym_with] = ACTIONS(590),
    [anon_sym_break] = ACTIONS(590),
    [anon_sym_continue] = ACTIONS(590),
    [anon_sym_debugger] = ACTIONS(590),
    [anon_sym_return] = ACTIONS(590),
    [anon_sym_throw] = ACTIONS(590),
    [anon_sym_SEMI] = ACTIONS(588),
    [anon_sym_case] = ACTIONS(590),
    [anon_sym_yield] = ACTIONS(590),
    [anon_sym_LBRACK] = ACTIONS(588),
    [anon_sym_LTtemplate_GT] = ACTIONS(588),
    [anon_sym_LT] = ACTIONS(590),
    [anon_sym_GT] = ACTIONS(592),
    [anon_sym_SLASH] = ACTIONS(590),
    [anon_sym_DOT] = ACTIONS(592),
    [anon_sym_class] = ACTIONS(590),
    [anon_sym_async] = ACTIONS(590),
    [anon_sym_function] = ACTIONS(590),
    [sym_optional_chain] = ACTIONS(594),
    [anon_sym_new] = ACTIONS(590),
    [anon_sym_AMP_AMP] = ACTIONS(594),
    [anon_sym_PIPE_PIPE] = ACTIONS(594),
    [anon_sym_GT_GT] = ACTIONS(592),
    [anon_sym_GT_GT_GT] = ACTIONS(594),
    [anon_sym_LT_LT] = ACTIONS(594),
    [anon_sym_AMP] = ACTIONS(592),
    [anon_sym_CARET] = ACTIONS(594),
    [anon_sym_PIPE] = ACTIONS(592),
    [anon_sym_PLUS] = ACTIONS(590),
    [anon_sym_DASH] = ACTIONS(590),
    [anon_sym_PERCENT] = ACTIONS(594),
    [anon_sym_STAR_STAR] = ACTIONS(594),
    [anon_sym_LT_EQ] = ACTIONS(594),
    [anon_sym_EQ_EQ] = ACTIONS(592),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(594),
    [anon_sym_BANG_EQ] = ACTIONS(592),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(594),
    [anon_sym_GT_EQ] = ACTIONS(594),
    [anon_sym_QMARK_QMARK] = ACTIONS(594),
    [anon_sym_instanceof] = ACTIONS(592),
    [anon_sym_BANG] = ACTIONS(590),
    [anon_sym_TILDE] = ACTIONS(588),
    [anon_sym_typeof] = ACTIONS(590),
    [anon_sym_void] = ACTIONS(590),
    [anon_sym_delete] = ACTIONS(590),
    [anon_sym_PLUS_PLUS] = ACTIONS(588),
    [anon_sym_DASH_DASH] = ACTIONS(588),
    [anon_sym_DQUOTE] = ACTIONS(588),
    [anon_sym_SQUOTE] = ACTIONS(588),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(588),
    [sym_number] = ACTIONS(588),
    [sym_this] = ACTIONS(590),
    [sym_super] = ACTIONS(590),
    [sym_true] = ACTIONS(590),
    [sym_false] = ACTIONS(590),
    [sym_null] = ACTIONS(590),
    [sym_undefined] = ACTIONS(590),
    [anon_sym_AT] = ACTIONS(588),
    [anon_sym_static] = ACTIONS(590),
    [anon_sym_get] = ACTIONS(590),
    [anon_sym_set] = ACTIONS(590),
    [sym__automatic_semicolon] = ACTIONS(596),
    [sym__ternary_qmark] = ACTIONS(594),
  },
  [75] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [anon_sym_export] = ACTIONS(600),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_COMMA] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_import] = ACTIONS(600),
    [anon_sym_var] = ACTIONS(600),
    [anon_sym_let] = ACTIONS(600),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_else] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_switch] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_await] = ACTIONS(600),
    [anon_sym_in] = ACTIONS(602),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_try] = ACTIONS(600),
    [anon_sym_with] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(600),
    [anon_sym_continue] = ACTIONS(600),
    [anon_sym_debugger] = ACTIONS(600),
    [anon_sym_return] = ACTIONS(600),
    [anon_sym_throw] = ACTIONS(600),
    [anon_sym_SEMI] = ACTIONS(598),
    [anon_sym_case] = ACTIONS(600),
    [anon_sym_yield] = ACTIONS(600),
    [anon_sym_LBRACK] = ACTIONS(598),
    [anon_sym_LTtemplate_GT] = ACTIONS(598),
    [anon_sym_LT] = ACTIONS(600),
    [anon_sym_GT] = ACTIONS(602),
    [anon_sym_SLASH] = ACTIONS(600),
    [anon_sym_DOT] = ACTIONS(602),
    [anon_sym_class] = ACTIONS(600),
    [anon_sym_async] = ACTIONS(600),
    [anon_sym_function] = ACTIONS(600),
    [sym_optional_chain] = ACTIONS(604),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_AMP_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(604),
    [anon_sym_GT_GT] = ACTIONS(602),
    [anon_sym_GT_GT_GT] = ACTIONS(604),
    [anon_sym_LT_LT] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(602),
    [anon_sym_CARET] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(602),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_PERCENT] = ACTIONS(604),
    [anon_sym_STAR_STAR] = ACTIONS(604),
    [anon_sym_LT_EQ] = ACTIONS(604),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(604),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(604),
    [anon_sym_GT_EQ] = ACTIONS(604),
    [anon_sym_QMARK_QMARK] = ACTIONS(604),
    [anon_sym_instanceof] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_TILDE] = ACTIONS(598),
    [anon_sym_typeof] = ACTIONS(600),
    [anon_sym_void] = ACTIONS(600),
    [anon_sym_delete] = ACTIONS(600),
    [anon_sym_PLUS_PLUS] = ACTIONS(598),
    [anon_sym_DASH_DASH] = ACTIONS(598),
    [anon_sym_DQUOTE] = ACTIONS(598),
    [anon_sym_SQUOTE] = ACTIONS(598),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(598),
    [sym_number] = ACTIONS(598),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(600),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_null] = ACTIONS(600),
    [sym_undefined] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(598),
    [anon_sym_static] = ACTIONS(600),
    [anon_sym_get] = ACTIONS(600),
    [anon_sym_set] = ACTIONS(600),
    [sym__automatic_semicolon] = ACTIONS(606),
    [sym__ternary_qmark] = ACTIONS(604),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(608),
    [sym_identifier] = ACTIONS(610),
    [anon_sym_export] = ACTIONS(610),
    [anon_sym_STAR] = ACTIONS(612),
    [anon_sym_default] = ACTIONS(610),
    [anon_sym_LBRACE] = ACTIONS(608),
    [anon_sym_COMMA] = ACTIONS(614),
    [anon_sym_RBRACE] = ACTIONS(608),
    [anon_sym_import] = ACTIONS(610),
    [anon_sym_var] = ACTIONS(610),
    [anon_sym_let] = ACTIONS(610),
    [anon_sym_const] = ACTIONS(610),
    [anon_sym_else] = ACTIONS(610),
    [anon_sym_if] = ACTIONS(610),
    [anon_sym_switch] = ACTIONS(610),
    [anon_sym_for] = ACTIONS(610),
    [anon_sym_LPAREN] = ACTIONS(608),
    [anon_sym_await] = ACTIONS(610),
    [anon_sym_in] = ACTIONS(612),
    [anon_sym_while] = ACTIONS(610),
    [anon_sym_do] = ACTIONS(610),
    [anon_sym_try] = ACTIONS(610),
    [anon_sym_with] = ACTIONS(610),
    [anon_sym_break] = ACTIONS(610),
    [anon_sym_continue] = ACTIONS(610),
    [anon_sym_debugger] = ACTIONS(610),
    [anon_sym_return] = ACTIONS(610),
    [anon_sym_throw] = ACTIONS(610),
    [anon_sym_SEMI] = ACTIONS(608),
    [anon_sym_case] = ACTIONS(610),
    [anon_sym_yield] = ACTIONS(610),
    [anon_sym_LBRACK] = ACTIONS(608),
    [anon_sym_LTtemplate_GT] = ACTIONS(608),
    [anon_sym_LT] = ACTIONS(610),
    [anon_sym_GT] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(610),
    [anon_sym_DOT] = ACTIONS(612),
    [anon_sym_class] = ACTIONS(610),
    [anon_sym_async] = ACTIONS(610),
    [anon_sym_function] = ACTIONS(610),
    [sym_optional_chain] = ACTIONS(614),
    [anon_sym_new] = ACTIONS(610),
    [anon_sym_AMP_AMP] = ACTIONS(614),
    [anon_sym_PIPE_PIPE] = ACTIONS(614),
    [anon_sym_GT_GT] = ACTIONS(612),
    [anon_sym_GT_GT_GT] = ACTIONS(614),
    [anon_sym_LT_LT] = ACTIONS(614),
    [anon_sym_AMP] = ACTIONS(612),
    [anon_sym_CARET] = ACTIONS(614),
    [anon_sym_PIPE] = ACTIONS(612),
    [anon_sym_PLUS] = ACTIONS(610),
    [anon_sym_DASH] = ACTIONS(610),
    [anon_sym_PERCENT] = ACTIONS(614),
    [anon_sym_STAR_STAR] = ACTIONS(614),
    [anon_sym_LT_EQ] = ACTIONS(614),
    [anon_sym_EQ_EQ] = ACTIONS(612),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(614),
    [anon_sym_BANG_EQ] = ACTIONS(612),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(614),
    [anon_sym_GT_EQ] = ACTIONS(614),
    [anon_sym_QMARK_QMARK] = ACTIONS(614),
    [anon_sym_instanceof] = ACTIONS(612),
    [anon_sym_BANG] = ACTIONS(610),
    [anon_sym_TILDE] = ACTIONS(608),
    [anon_sym_typeof] = ACTIONS(610),
    [anon_sym_void] = ACTIONS(610),
    [anon_sym_delete] = ACTIONS(610),
    [anon_sym_PLUS_PLUS] = ACTIONS(608),
    [anon_sym_DASH_DASH] = ACTIONS(608),
    [anon_sym_DQUOTE] = ACTIONS(608),
    [anon_sym_SQUOTE] = ACTIONS(608),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(608),
    [sym_number] = ACTIONS(608),
    [sym_this] = ACTIONS(610),
    [sym_super] = ACTIONS(610),
    [sym_true] = ACTIONS(610),
    [sym_false] = ACTIONS(610),
    [sym_null] = ACTIONS(610),
    [sym_undefined] = ACTIONS(610),
    [anon_sym_AT] = ACTIONS(608),
    [anon_sym_static] = ACTIONS(610),
    [anon_sym_get] = ACTIONS(610),
    [anon_sym_set] = ACTIONS(610),
    [sym__automatic_semicolon] = ACTIONS(616),
    [sym__ternary_qmark] = ACTIONS(614),
  },
  [77] = {
    [ts_builtin_sym_end] = ACTIONS(618),
    [sym_identifier] = ACTIONS(620),
    [anon_sym_export] = ACTIONS(620),
    [anon_sym_STAR] = ACTIONS(622),
    [anon_sym_default] = ACTIONS(620),
    [anon_sym_LBRACE] = ACTIONS(618),
    [anon_sym_COMMA] = ACTIONS(624),
    [anon_sym_RBRACE] = ACTIONS(618),
    [anon_sym_import] = ACTIONS(620),
    [anon_sym_var] = ACTIONS(620),
    [anon_sym_let] = ACTIONS(620),
    [anon_sym_const] = ACTIONS(620),
    [anon_sym_else] = ACTIONS(620),
    [anon_sym_if] = ACTIONS(620),
    [anon_sym_switch] = ACTIONS(620),
    [anon_sym_for] = ACTIONS(620),
    [anon_sym_LPAREN] = ACTIONS(618),
    [anon_sym_await] = ACTIONS(620),
    [anon_sym_in] = ACTIONS(622),
    [anon_sym_while] = ACTIONS(620),
    [anon_sym_do] = ACTIONS(620),
    [anon_sym_try] = ACTIONS(620),
    [anon_sym_with] = ACTIONS(620),
    [anon_sym_break] = ACTIONS(620),
    [anon_sym_continue] = ACTIONS(620),
    [anon_sym_debugger] = ACTIONS(620),
    [anon_sym_return] = ACTIONS(620),
    [anon_sym_throw] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(618),
    [anon_sym_case] = ACTIONS(620),
    [anon_sym_yield] = ACTIONS(620),
    [anon_sym_LBRACK] = ACTIONS(618),
    [anon_sym_LTtemplate_GT] = ACTIONS(618),
    [anon_sym_LT] = ACTIONS(620),
    [anon_sym_GT] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(620),
    [anon_sym_DOT] = ACTIONS(622),
    [anon_sym_class] = ACTIONS(620),
    [anon_sym_async] = ACTIONS(620),
    [anon_sym_function] = ACTIONS(620),
    [sym_optional_chain] = ACTIONS(624),
    [anon_sym_new] = ACTIONS(620),
    [anon_sym_AMP_AMP] = ACTIONS(624),
    [anon_sym_PIPE_PIPE] = ACTIONS(624),
    [anon_sym_GT_GT] = ACTIONS(622),
    [anon_sym_GT_GT_GT] = ACTIONS(624),
    [anon_sym_LT_LT] = ACTIONS(624),
    [anon_sym_AMP] = ACTIONS(622),
    [anon_sym_CARET] = ACTIONS(624),
    [anon_sym_PIPE] = ACTIONS(622),
    [anon_sym_PLUS] = ACTIONS(620),
    [anon_sym_DASH] = ACTIONS(620),
    [anon_sym_PERCENT] = ACTIONS(624),
    [anon_sym_STAR_STAR] = ACTIONS(624),
    [anon_sym_LT_EQ] = ACTIONS(624),
    [anon_sym_EQ_EQ] = ACTIONS(622),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(624),
    [anon_sym_BANG_EQ] = ACTIONS(622),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(624),
    [anon_sym_GT_EQ] = ACTIONS(624),
    [anon_sym_QMARK_QMARK] = ACTIONS(624),
    [anon_sym_instanceof] = ACTIONS(622),
    [anon_sym_BANG] = ACTIONS(620),
    [anon_sym_TILDE] = ACTIONS(618),
    [anon_sym_typeof] = ACTIONS(620),
    [anon_sym_void] = ACTIONS(620),
    [anon_sym_delete] = ACTIONS(620),
    [anon_sym_PLUS_PLUS] = ACTIONS(618),
    [anon_sym_DASH_DASH] = ACTIONS(618),
    [anon_sym_DQUOTE] = ACTIONS(618),
    [anon_sym_SQUOTE] = ACTIONS(618),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(618),
    [sym_number] = ACTIONS(618),
    [sym_this] = ACTIONS(620),
    [sym_super] = ACTIONS(620),
    [sym_true] = ACTIONS(620),
    [sym_false] = ACTIONS(620),
    [sym_null] = ACTIONS(620),
    [sym_undefined] = ACTIONS(620),
    [anon_sym_AT] = ACTIONS(618),
    [anon_sym_static] = ACTIONS(620),
    [anon_sym_get] = ACTIONS(620),
    [anon_sym_set] = ACTIONS(620),
    [sym__automatic_semicolon] = ACTIONS(626),
    [sym__ternary_qmark] = ACTIONS(624),
  },
  [78] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_RBRACK] = ACTIONS(638),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [79] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(740),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1337),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_spread_element] = STATE(1298),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1297),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_COMMA] = ACTIONS(646),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_RBRACK] = ACTIONS(646),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(105),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [80] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(825),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1225),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(494),
    [sym_subscript_expression] = STATE(494),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1197),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_pattern_repeat1] = STATE(1240),
    [sym_identifier] = ACTIONS(649),
    [anon_sym_export] = ACTIONS(651),
    [anon_sym_LBRACE] = ACTIONS(653),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(655),
    [anon_sym_RBRACK] = ACTIONS(638),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(657),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(659),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(651),
    [anon_sym_get] = ACTIONS(651),
    [anon_sym_set] = ACTIONS(651),
  },
  [81] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1314),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1156),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_pattern_repeat1] = STATE(1310),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(634),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_RBRACK] = ACTIONS(661),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [82] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(805),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1321),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1562),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1149),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(663),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [83] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1337),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1297),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(665),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_RBRACK] = ACTIONS(665),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [84] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(794),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1321),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1541),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1149),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(663),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [85] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(750),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_spread_element] = STATE(1253),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1252),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(669),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(671),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [86] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1362),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1254),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(673),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [87] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1321),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1149),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(663),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [88] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(737),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_spread_element] = STATE(1300),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1301),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(675),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(671),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [89] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(740),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_spread_element] = STATE(1298),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(677),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(677),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_RBRACK] = ACTIONS(677),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(671),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [90] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1362),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1254),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(679),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [91] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(695),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_spread_element] = STATE(1259),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [aux_sym_array_repeat1] = STATE(1258),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_COMMA] = ACTIONS(667),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(681),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(671),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [92] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(773),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_spread_element] = STATE(1574),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1574),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_RBRACE] = ACTIONS(683),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(671),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [93] = {
    [sym_import] = STATE(683),
    [sym_expression_statement] = STATE(101),
    [sym_empty_statement] = STATE(101),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [94] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(803),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_spread_element] = STATE(1596),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1596),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_RBRACE] = ACTIONS(685),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(671),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [95] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1362),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1254),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [96] = {
    [sym_import] = STATE(683),
    [sym_expression_statement] = STATE(102),
    [sym_empty_statement] = STATE(102),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(692),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1404),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(49),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [97] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1121),
    [sym_assignment_pattern] = STATE(1452),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1121),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(482),
    [sym_subscript_expression] = STATE(482),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1121),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [sym_pattern] = STATE(1260),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(628),
    [anon_sym_export] = ACTIONS(630),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(640),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(644),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(630),
    [anon_sym_get] = ACTIONS(630),
    [anon_sym_set] = ACTIONS(630),
  },
  [98] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(807),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1125),
    [sym_assignment_pattern] = STATE(1452),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1125),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(480),
    [sym_subscript_expression] = STATE(480),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1125),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [sym_pattern] = STATE(1260),
    [sym_rest_pattern] = STATE(1124),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(472),
    [anon_sym_export] = ACTIONS(474),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(480),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(642),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(474),
    [anon_sym_get] = ACTIONS(474),
    [anon_sym_set] = ACTIONS(474),
  },
  [99] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(710),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1413),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_SEMI] = ACTIONS(687),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
    [sym__automatic_semicolon] = ACTIONS(687),
  },
  [100] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(498),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1309),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1309),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(498),
    [sym_subscript_expression] = STATE(498),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1309),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(689),
    [anon_sym_export] = ACTIONS(691),
    [anon_sym_LBRACE] = ACTIONS(693),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_var] = ACTIONS(695),
    [anon_sym_let] = ACTIONS(697),
    [anon_sym_const] = ACTIONS(697),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(699),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(701),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(703),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(691),
    [anon_sym_get] = ACTIONS(691),
    [anon_sym_set] = ACTIONS(691),
  },
  [101] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(810),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1509),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(705),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [102] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(813),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1513),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_RPAREN] = ACTIONS(707),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [103] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(608),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(819),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [104] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(586),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(823),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [105] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(801),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1567),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [106] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(769),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1584),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [107] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(814),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1609),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [108] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(608),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(595),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [109] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(559),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1217),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [110] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(586),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(585),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [111] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(759),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(637),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [112] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(815),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1603),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [113] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(804),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1597),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [114] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(575),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(587),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [115] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(816),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1604),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [116] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(575),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(852),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [117] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(536),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(797),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [118] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(606),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(824),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [119] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(776),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1573),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [120] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(753),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1392),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [121] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(812),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1514),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [122] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(763),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(663),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [123] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(811),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1569),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [124] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(575),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(779),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [125] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(763),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(630),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [126] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(608),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(774),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [127] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(808),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1517),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [128] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(601),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(798),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [129] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(731),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(676),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [130] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(806),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [131] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1546),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [132] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(731),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(651),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [133] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(510),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(507),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_DOT] = ACTIONS(715),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [134] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(791),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_sequence_expression] = STATE(1534),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [135] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(510),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(507),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(717),
    [anon_sym_export] = ACTIONS(719),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_DOT] = ACTIONS(715),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(721),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(719),
    [anon_sym_get] = ACTIONS(719),
    [anon_sym_set] = ACTIONS(719),
  },
  [136] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(705),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(639),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [137] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(536),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(537),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [138] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(465),
    [sym_expression] = STATE(858),
    [sym_primary_expression] = STATE(672),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(675),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(465),
    [sym_subscript_expression] = STATE(465),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(723),
    [anon_sym_export] = ACTIONS(725),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_DOT] = ACTIONS(727),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(729),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(725),
    [anon_sym_get] = ACTIONS(725),
    [anon_sym_set] = ACTIONS(725),
  },
  [139] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(606),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(799),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [140] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(465),
    [sym_expression] = STATE(858),
    [sym_primary_expression] = STATE(672),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(675),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(465),
    [sym_subscript_expression] = STATE(465),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(733),
    [anon_sym_export] = ACTIONS(735),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_DOT] = ACTIONS(727),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(737),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(731),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(735),
    [anon_sym_get] = ACTIONS(735),
    [anon_sym_set] = ACTIONS(735),
  },
  [141] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(697),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(668),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [142] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(701),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(669),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [143] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(510),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(507),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(739),
    [anon_sym_export] = ACTIONS(741),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_DOT] = ACTIONS(715),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(743),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(741),
    [anon_sym_get] = ACTIONS(741),
    [anon_sym_set] = ACTIONS(741),
  },
  [144] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(705),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(670),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [145] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(586),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(800),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [146] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(712),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_sequence_expression] = STATE(1418),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [147] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(697),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(647),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [148] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(701),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(645),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [149] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(601),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(602),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [150] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(606),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(560),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(711),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [151] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(601),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(828),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [152] = {
    [sym_import] = STATE(683),
    [sym_statement_block] = STATE(759),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(671),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [153] = {
    [sym_import] = STATE(574),
    [sym_statement_block] = STATE(536),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(829),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(709),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [154] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(501),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [155] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(524),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [156] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(807),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [157] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(817),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [158] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(564),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [159] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(821),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [160] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(564),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [161] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(827),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [162] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(504),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [163] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(611),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [164] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(545),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [165] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(660),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [166] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(846),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [167] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(665),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [168] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(771),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [169] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(768),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [170] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(772),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [171] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(628),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [172] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(857),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1116),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1116),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1116),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(745),
    [anon_sym_export] = ACTIONS(747),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(636),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(749),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(751),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(747),
    [anon_sym_get] = ACTIONS(747),
    [anon_sym_set] = ACTIONS(747),
  },
  [173] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(643),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [174] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(831),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [175] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(775),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [176] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(778),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [177] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(503),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [178] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(780),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [179] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(781),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [180] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(517),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [181] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [182] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(516),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [183] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(504),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [184] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(784),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [185] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(667),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [186] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(501),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [187] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(785),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [188] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(786),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [189] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(822),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [190] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(826),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [191] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(657),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [192] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(820),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [193] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(568),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [194] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(635),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [195] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(521),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [196] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(787),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [197] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(788),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [198] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(623),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [199] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(619),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [200] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(618),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [201] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(617),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [202] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(614),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [203] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(615),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [204] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(612),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [205] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(610),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [206] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(621),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [207] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(622),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [208] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(789),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [209] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [210] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(792),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [211] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(795),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [212] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(728),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [213] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(504),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [214] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(844),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [215] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(434),
    [sym_expression] = STATE(796),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1613),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1613),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(434),
    [sym_subscript_expression] = STATE(434),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(965),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1613),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1565),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(450),
    [anon_sym_export] = ACTIONS(452),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(456),
    [anon_sym_yield] = ACTIONS(458),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(460),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(462),
    [anon_sym_PLUS] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(464),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(466),
    [anon_sym_typeof] = ACTIONS(464),
    [anon_sym_void] = ACTIONS(464),
    [anon_sym_delete] = ACTIONS(464),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_DASH_DASH] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(470),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(452),
    [anon_sym_get] = ACTIONS(452),
    [anon_sym_set] = ACTIONS(452),
  },
  [216] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(535),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [217] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(841),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [218] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(485),
    [sym_expression] = STATE(634),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1578),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1578),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(975),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1578),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1575),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(382),
    [anon_sym_export] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(29),
    [anon_sym_yield] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(59),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(394),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(67),
    [anon_sym_PLUS] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_TILDE] = ACTIONS(71),
    [anon_sym_typeof] = ACTIONS(69),
    [anon_sym_void] = ACTIONS(69),
    [anon_sym_delete] = ACTIONS(69),
    [anon_sym_PLUS_PLUS] = ACTIONS(73),
    [anon_sym_DASH_DASH] = ACTIONS(73),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(85),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(384),
    [anon_sym_get] = ACTIONS(384),
    [anon_sym_set] = ACTIONS(384),
  },
  [219] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(517),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [220] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(849),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [221] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(848),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [222] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(847),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [223] = {
    [sym_import] = STATE(683),
    [sym_parenthesized_expression] = STATE(481),
    [sym_expression] = STATE(516),
    [sym_primary_expression] = STATE(693),
    [sym_yield_expression] = STATE(707),
    [sym_object] = STATE(683),
    [sym_object_pattern] = STATE(1520),
    [sym_array] = STATE(683),
    [sym_array_pattern] = STATE(1520),
    [sym_glimmer_template] = STATE(707),
    [sym_glimmer_opening_tag] = STATE(1216),
    [sym_jsx_element] = STATE(707),
    [sym_jsx_fragment] = STATE(707),
    [sym_jsx_opening_element] = STATE(998),
    [sym_jsx_self_closing_element] = STATE(707),
    [sym_class] = STATE(683),
    [sym_function] = STATE(683),
    [sym_generator_function] = STATE(683),
    [sym_arrow_function] = STATE(683),
    [sym_call_expression] = STATE(683),
    [sym_new_expression] = STATE(707),
    [sym_await_expression] = STATE(707),
    [sym_member_expression] = STATE(481),
    [sym_subscript_expression] = STATE(481),
    [sym_assignment_expression] = STATE(707),
    [sym__augmented_assignment_lhs] = STATE(957),
    [sym_augmented_assignment_expression] = STATE(707),
    [sym__destructuring_pattern] = STATE(1520),
    [sym_ternary_expression] = STATE(707),
    [sym_binary_expression] = STATE(707),
    [sym_unary_expression] = STATE(707),
    [sym_update_expression] = STATE(707),
    [sym_string] = STATE(683),
    [sym_template_string] = STATE(683),
    [sym_regex] = STATE(683),
    [sym_meta_property] = STATE(683),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1521),
    [aux_sym_export_statement_repeat1] = STATE(1209),
    [sym_identifier] = ACTIONS(398),
    [anon_sym_export] = ACTIONS(400),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_import] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(27),
    [anon_sym_await] = ACTIONS(404),
    [anon_sym_yield] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_class] = ACTIONS(392),
    [anon_sym_async] = ACTIONS(410),
    [anon_sym_function] = ACTIONS(396),
    [anon_sym_new] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(414),
    [anon_sym_DASH] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(416),
    [anon_sym_typeof] = ACTIONS(414),
    [anon_sym_void] = ACTIONS(414),
    [anon_sym_delete] = ACTIONS(414),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_DQUOTE] = ACTIONS(75),
    [anon_sym_SQUOTE] = ACTIONS(77),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [sym_number] = ACTIONS(81),
    [sym_this] = ACTIONS(83),
    [sym_super] = ACTIONS(83),
    [sym_true] = ACTIONS(83),
    [sym_false] = ACTIONS(83),
    [sym_null] = ACTIONS(83),
    [sym_undefined] = ACTIONS(420),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(400),
    [anon_sym_get] = ACTIONS(400),
    [anon_sym_set] = ACTIONS(400),
  },
  [224] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(845),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [225] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(818),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [226] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(571),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [227] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(503),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [228] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(589),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [229] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(656),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [230] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(843),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [231] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(842),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [232] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(501),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [233] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(449),
    [sym_expression] = STATE(850),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1566),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1566),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(449),
    [sym_subscript_expression] = STATE(449),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(963),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1566),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1612),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(330),
    [anon_sym_export] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(344),
    [anon_sym_yield] = ACTIONS(348),
    [anon_sym_LBRACK] = ACTIONS(350),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(354),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(358),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(362),
    [anon_sym_PLUS] = ACTIONS(364),
    [anon_sym_DASH] = ACTIONS(364),
    [anon_sym_BANG] = ACTIONS(366),
    [anon_sym_TILDE] = ACTIONS(366),
    [anon_sym_typeof] = ACTIONS(364),
    [anon_sym_void] = ACTIONS(364),
    [anon_sym_delete] = ACTIONS(364),
    [anon_sym_PLUS_PLUS] = ACTIONS(368),
    [anon_sym_DASH_DASH] = ACTIONS(368),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(380),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(332),
    [anon_sym_get] = ACTIONS(332),
    [anon_sym_set] = ACTIONS(332),
  },
  [234] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(840),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [235] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(839),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [236] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(838),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTIONS(422),
    [anon_sym_export] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_import] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(342),
    [anon_sym_await] = ACTIONS(430),
    [anon_sym_yield] = ACTIONS(432),
    [anon_sym_LBRACK] = ACTIONS(434),
    [anon_sym_LTtemplate_GT] = ACTIONS(55),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_SLASH] = ACTIONS(436),
    [anon_sym_class] = ACTIONS(356),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(360),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_BANG] = ACTIONS(444),
    [anon_sym_TILDE] = ACTIONS(444),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(446),
    [anon_sym_DASH_DASH] = ACTIONS(446),
    [anon_sym_DQUOTE] = ACTIONS(370),
    [anon_sym_SQUOTE] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(374),
    [sym_number] = ACTIONS(376),
    [sym_this] = ACTIONS(378),
    [sym_super] = ACTIONS(378),
    [sym_true] = ACTIONS(378),
    [sym_false] = ACTIONS(378),
    [sym_null] = ACTIONS(378),
    [sym_undefined] = ACTIONS(448),
    [anon_sym_AT] = ACTIONS(87),
    [anon_sym_static] = ACTIONS(424),
    [anon_sym_get] = ACTIONS(424),
    [anon_sym_set] = ACTIONS(424),
  },
  [237] = {
    [sym_import] = STATE(574),
    [sym_parenthesized_expression] = STATE(499),
    [sym_expression] = STATE(836),
    [sym_primary_expression] = STATE(577),
    [sym_yield_expression] = STATE(518),
    [sym_object] = STATE(574),
    [sym_object_pattern] = STATE(1615),
    [sym_array] = STATE(574),
    [sym_array_pattern] = STATE(1615),
    [sym_glimmer_template] = STATE(518),
    [sym_glimmer_opening_tag] = STATE(1193),
    [sym_jsx_element] = STATE(518),
    [sym_jsx_fragment] = STATE(518),
    [sym_jsx_opening_element] = STATE(1000),
    [sym_jsx_self_closing_element] = STATE(518),
    [sym_class] = STATE(574),
    [sym_function] = STATE(574),
    [sym_generator_function] = STATE(574),
    [sym_arrow_function] = STATE(574),
    [sym_call_expression] = STATE(574),
    [sym_new_expression] = STATE(518),
    [sym_await_expression] = STATE(518),
    [sym_member_expression] = STATE(499),
    [sym_subscript_expression] = STATE(499),
    [sym_assignment_expression] = STATE(518),
    [sym__augmented_assignment_lhs] = STATE(968),
    [sym_augmented_assignment_expression] = STATE(518),
    [sym__destructuring_pattern] = STATE(1615),
    [sym_ternary_expression] = STATE(518),
    [sym_binary_expression] = STATE(518),
    [sym_unary_expression] = STATE(518),
    [sym_update_expression] = STATE(518),
    [sym_string] = STATE(574),
    [sym_template_string] = STATE(574),
    [sym_regex] = STATE(574),
    [sym_meta_property] = STATE(574),
    [sym_decorator] = STATE(978),
    [sym_formal_parameters] = STATE(1590),
    [aux_sym_export_statement_repeat1] = STATE(1146),
    [sym_identifier] = ACTI