<div align="center">

# 🛡️ CodeGate  
### Supply-Chain Guardrails for AI Agents

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![Python](https://img.shields.io/badge/python-3.10+-blue.svg)](https://www.python.org/)
[![Virtualization](https://img.shields.io/badge/Virtualization-Firecracker-orange)](https://firecracker-microvm.github.io/)
[![Security](https://img.shields.io/badge/Security-Zero_Trust-red)]()

**The Supply-Chain Firewall for the Agentic Era.**

CodeGate prevents hallucinated and dangerous dependencies when AI agents run `pip install`.  
It works at runtime, requires no agent integration, and is fully opt-in.

</div>

---

## Quick demo (30 seconds)

```bash
pip install codegate-cli
codegate activate

codegate run -- pip install requests   # ✅ allowed
codegate run -- pip install dotenv     # ⛔ blocked
```

Output:
```
Blocked by CodeGate (known hallucination):
  dotenv → use python-dotenv instead
```

---

## Why this exists

Autonomous coding agents generate and execute code at runtime.  
Unlike humans, LLMs frequently hallucinate dependency names or suggest unsafe packages.

Attackers register those names on PyPI (slopsquatting) to deliver malware.

If an agent runs `pip install` on a hallucinated name, your machine is compromised instantly.

CodeGate blocks those installs before they execute.

---

## What CodeGate does

**Does**
- Intercepts `pip install` at runtime
- Blocks known hallucinations and slopsquatting attacks
- Optionally enforces a remote security policy
- Works with any AI agent or coding tool

**Does NOT**
- Hijack your system globally
- Run invisibly or auto-update
- Require blind trust
- Depend on agent behavior

---

## How it works

1. `codegate run` injects a guarded PATH for that process only
2. `pip install` is intercepted by a transparent shim
3. Known hallucinated packages are blocked immediately
4. Unknown packages are optionally checked by a policy engine
5. Allowed installs are delegated to the real `pip`

No global hijacking. No hidden behavior.

---

## Installation

```bash
pip install codegate-cli
```

Activate CodeGate (dev-friendly by default):

```bash
codegate activate
```

---

## Usage (recommended)

```bash
codegate run -- pip install numpy
codegate run -- python my_agent.py
codegate run -- claude-code
codegate run -- aider
```

If the agent runs `pip install`, CodeGate is enforced.

---

## Strict mode (CI / production)

```bash
codegate activate --strict
```

Strict mode fails closed:  
if the security scanner is unreachable or denies a dependency, the installation is blocked.

---

## Trust model

CodeGate is intentionally opt-in and inspectable.

- Shims are readable shell scripts
- Enforcement happens only when invoked
- No mandatory global PATH hijacking
- Fully open source

---

## Firecracker & isolation (roadmap)

CodeGate is designed to support runtime isolation for unknown packages  
(using Firecracker MicroVMs and network confinement).

This repository currently focuses on runtime interception and policy enforcement.

---

## License

MIT License © 2025 CodeGate
